
function demo_figure_08_09A

%--------------------------------------------------------------------------
% Object:
% Comparison of errors and Lebesgue constants.
%
% * Figure 8: Lebesgue constants the three points sets: Approximate Fekete 
% Points, Discrete Leja Points and Hyperinterpolation Points.
%
% * Figure 9: Relative L2 reconstruction errors for the six test 
% functions with respect to the degree n (top) and the cardinality (bottom) 
% with interpolation at the approximate Fekete points (dotted lines) and 
% hyperinterpolation (solid lines).
%--------------------------------------------------------------------------
% Dates:
% Written on 12/02/2021: A. Sommariva and M. Vianello.
%--------------------------------------------------------------------------


clf; clear all;

nV=1:15;
nVH=1:8;

for k=nV
    
    % ... AFEK ...
    [pts_AFEKL,leb_AFEK,AE_L2err_AFEK,RE_L2err_AFEK,AE_inf_AFEK,RE_inf_AFEK]=...
        octant_afek7_pi5(k);
    card_AFEK(k)=size(pts_AFEKL,1);
    
end

for k=nV
    % ... Hyperinterpolation ...
    [pts_HYP,leb_HYP,AE_L2err_HYP,RE_L2err_HYP,AE_inf_HYP,RE_inf_HYP]=...
        octant_hyperinterpolation(k);
    card_HYP(k)=size(pts_HYP,1);
end



% ... comparison of Lebesgue constants ...
figure(1)
plot(nV,leb_AFEK(nV),'d:','Color','m','LineWidth',1.5,'MarkerSize',8);
hold on;
plot(nV,leb_HYP(nV),'*:','Color','black','LineWidth',1.5,'MarkerSize',8);
legend('AFEK','HYP');

saveas(gcf, 'figure_07_1', 'fig')
saveas(gcf, 'figure_07_1', 'epsc')

hold off



% ... comparison RE (card) ...
figure(2)

colors={'blue','green',[0.8500 0.3250 0.0980],'magenta','cyan','black'};

for j=1:6
    color_dots=colors{j};
    semilogy(card_AFEK(nV),RE_L2err_AFEK(nV,j),':','Color',color_dots,...
        'MarkerSize',2,...
        'MarkerEdgeColor',color_dots,'MarkerFaceColor',color_dots,...
        'LineWidth',2);
    hold on;
end


for j=1:6
    color_dots=colors{j};
    semilogy(card_HYP(nVH),RE_L2err_HYP(nVH,j),'-','Color',color_dots,...
        'MarkerSize',2,...
        'MarkerEdgeColor',color_dots,'MarkerFaceColor',color_dots,...
        'LineWidth',2);
end

% title('RE_{L2}');
legend('f1','f2','f3','f4','f5','f6');
hold off

saveas(gcf, 'figure_07_2', 'fig')
saveas(gcf, 'figure_07_2', 'epsc')




% ... comparison RE (deg) ...
figure(3)

colors={'blue','green',[0.8500 0.3250 0.0980],'magenta','cyan','black'};

for j=1:6
    color_dots=colors{j};
    semilogy(nV,RE_L2err_AFEK(nV,j),':','Color',color_dots,'MarkerSize',...
        2,'MarkerEdgeColor',color_dots,'MarkerFaceColor',color_dots,...
        'LineWidth',2);
    hold on;
end


for j=1:6
    color_dots=colors{j};
    semilogy(nV,RE_L2err_HYP(nV,j),'-','Color',color_dots,'MarkerSize',...
        2,'MarkerEdgeColor',color_dots,'MarkerFaceColor',color_dots,...
        'LineWidth',2);
end

% title('RE_{L2}');
legend('f1','f2','f3','f4','f5','f6');
hold off

saveas(gcf, 'figure_07_3', 'fig')
saveas(gcf, 'figure_07_3', 'epsc')
