function  [pts,leb,AE_L2err,RE_L2err,AE_inf,RE_inf]=octant_afek7(deg)


%  	 .........................................................................
%  	 |  n  |   leb   |   card0  |   card  |  poly |  cpus   |
%  	 .........................................................................
%  	 |   1 | 1.7e+00 |     628  |       4 |     4 | 3.9e-02 |
%  	 |   2 | 3.1e+00 |    2212  |       9 |     9 | 3.6e-02 |
%  	 |   3 | 3.6e+00 |    4764  |      16 |    16 | 2.8e-02 |
%  	 |   4 | 4.0e+00 |    8284  |      25 |    25 | 5.4e-02 |
%  	 |   5 | 9.4e+00 |   13228  |      36 |    36 | 1.3e-01 |
%  	 |   6 | 8.9e+00 |   18772  |      49 |    49 | 2.5e-01 |
%  	 |   7 | 1.1e+01 |   25284  |      64 |    64 | 5.5e-01 |
%  	 |   8 | 2.1e+01 |   32764  |      81 |    81 | 1.2e+00 |
%  	 |   9 | 1.5e+01 |   41212  |     100 |   100 | 2.0e+00 |
%  	 |  10 | 1.5e+01 |   51532  |     121 |   121 | 3.7e+00 |
%  	 |  11 | 1.9e+01 |   62004  |     144 |   144 | 6.0e+00 |
%  	 |  12 | 2.2e+01 |   73444  |     169 |   169 | 1.0e+01 |
%  	 |  13 | 1.8e+01 |   85852  |     196 |   196 | 1.7e+01 |
%  	 |  14 | 2.8e+01 |   99228  |     225 |   225 | 4.5e+01 |
%  	 |  15 | 3.3e+01 |   114924  |     256 |   256 | 5.2e+01 |
%  	 |  16 | 3.6e+01 |   130324  |     289 |   289 | 8.6e+01 |
%  	 |  17 | 7.3e+01 |   146692  |     324 |   324 | 1.6e+02 |
%  	 |  18 | 5.6e+01 |   164028  |     361 |   361 | 2.0e+02 |
%  	 |  19 | 5.3e+01 |   182332  |     400 |   400 | 2.7e+02 |
%  	 |  20 | 6.8e+01 |   203404  |     441 |   441 | 3.1e+02 |
%
%  	 .........................................................................
%  	 * Domain:0
%  	 * Pointset:afek
%
%  	 .........................................................................
%  	 Legend:
%  	 * leb   : Lebesgue constant;
%  	 * card0 : cardinality of initial pointset (numerical WAM);
%  	 * card  : cardinality of extracted pointset;
%  	 * poly  : dimension of space of total polynomials on the sphere;
%  	 * cpus  : cputime required for computing extracted pointset.
%  	 .........................................................................
%  	 * Function analysed (see figure 3 for L2 relative errors)):
%   	 1: f(x,y)=@(x,y)1+x+y.^2+x.^2.*y+x.^4+y.^5+x.^2.*y.^2.*z.^2
%  	 2: f(x,y)=@(x,y)cos(10*(x+y+z))
%  	 3: f(x,y)=@(x,y)exp(-g(x,y,z)), g=@(x,y,z) (x-x0).^2+(y-y0).^2+(z-z0).^2, x0=0;y0=0;z0=1;
%  	 4: f(x,y)=@(x,y)exp(-g(x,y,z)), g=@(x,y,z) (x-x0).^2+(y-y0).^2+(z-z0).^2  centroid=(5.774e-01,5.774e-01,5.774e-01)
%  	 5: f(x,y)=@(x,y)((x-x0).^2 + (y-y0).^2 + (z-z0).^2).^(5/2), x0=0; y0=0; z0=1;
%  	 6: f(x,y)=@(x,y)((x-x0).^2 + (y-y0).^2 + (z-z0).^2).^(5/2),  centroid=(5.774e-01,5.774e-01,5.774e-01)
%  	 .........................................................................
%
%
%  	 .........................................................................
%  	 For each function "f" and each degree we display the L2 relative weighted
%  	 hyperinterp. errors REL, evaluated w.r.t. to a high order cubature.
%  	 Next we compute RELinf, i.e. "maximum absolute error / norm(f,inf)".
%  	 .........................................................................
%
%
%  	 *** 1+x+y.^2+x.^2.*y+x.^4+y.^5+x.^2.*y.^2.*z.^2
%
%  	 .....................................
%  	 |  deg  |   REL2   |  RELinf  |
%  	 .....................................
%  	 |    1  | 4.64e-02 | 8.76e-02 |
%  	 |    2  | 3.18e-02 | 7.58e-02 |
%  	 |    3  | 4.46e-03 | 9.42e-03 |
%  	 |    4  | 3.76e-04 | 1.24e-03 |
%  	 |    5  | 1.84e-04 | 5.42e-04 |
%  	 |    6  | 5.78e-16 | 1.55e-15 |
%  	 |    7  | 8.52e-16 | 3.03e-15 |
%  	 |    8  | 7.00e-16 | 2.12e-15 |
%  	 |    9  | 7.60e-16 | 2.33e-15 |
%  	 |   10  | 7.54e-16 | 2.54e-15 |
%  	 |   11  | 1.11e-15 | 4.44e-15 |
%  	 |   12  | 9.83e-16 | 3.24e-15 |
%  	 |   13  | 1.23e-15 | 5.08e-15 |
%  	 |   14  | 9.87e-16 | 3.10e-15 |
%  	 |   15  | 1.01e-15 | 2.96e-15 |
%  	 |   16  | 1.29e-15 | 4.73e-15 |
%  	 |   17  | 1.19e-15 | 3.95e-15 |
%  	 |   18  | 1.22e-15 | 3.67e-15 |
%  	 |   19  | 1.53e-15 | 7.41e-15 |
%  	 |   20  | 1.23e-15 | 4.37e-15 |
%  	 .....................................
%
%
%  	 *** cos(10*(x+y+z))
%
%  	 .....................................
%  	 |  deg  |   REL2   |  RELinf  |
%  	 .....................................
%  	 |    1  | 1.09e+00 | 1.54e+00 |
%  	 |    2  | 1.52e+00 | 2.12e+00 |
%  	 |    3  | 2.51e-01 | 6.45e-01 |
%  	 |    4  | 2.46e-01 | 3.70e-01 |
%  	 |    5  | 3.07e-02 | 6.83e-02 |
%  	 |    6  | 2.43e-02 | 5.22e-02 |
%  	 |    7  | 2.20e-03 | 6.18e-03 |
%  	 |    8  | 1.16e-03 | 2.05e-03 |
%  	 |    9  | 9.64e-05 | 2.31e-04 |
%  	 |   10  | 4.05e-05 | 9.37e-05 |
%  	 |   11  | 2.52e-06 | 6.72e-06 |
%  	 |   12  | 7.85e-07 | 1.40e-06 |
%  	 |   13  | 4.57e-08 | 1.66e-07 |
%  	 |   14  | 1.37e-08 | 4.55e-08 |
%  	 |   15  | 6.72e-10 | 2.78e-09 |
%  	 |   16  | 1.55e-10 | 3.94e-10 |
%  	 |   17  | 7.52e-12 | 2.62e-11 |
%  	 |   18  | 1.96e-12 | 8.68e-12 |
%  	 |   19  | 6.52e-14 | 2.13e-13 |
%  	 |   20  | 1.25e-14 | 7.21e-14 |
%  	 .....................................
%
%
%  	 *** exp(-g(x,y,z)), g=@(x,y,z) (x-x0).^2+(y-y0).^2+(z-z0).^2, x0=0;y0=0;z0=1;
%
%  	 .....................................
%  	 |  deg  |   REL2   |  RELinf  |
%  	 .....................................
%  	 |    1  | 8.57e-02 | 1.16e-01 |
%  	 |    2  | 1.98e-02 | 2.63e-02 |
%  	 |    3  | 2.17e-03 | 2.41e-03 |
%  	 |    4  | 1.67e-04 | 2.64e-04 |
%  	 |    5  | 2.91e-05 | 5.57e-05 |
%  	 |    6  | 9.14e-07 | 2.25e-06 |
%  	 |    7  | 5.70e-08 | 1.45e-07 |
%  	 |    8  | 5.98e-09 | 2.17e-08 |
%  	 |    9  | 1.54e-10 | 4.52e-10 |
%  	 |   10  | 6.07e-12 | 2.04e-11 |
%  	 |   11  | 2.72e-13 | 1.15e-12 |
%  	 |   12  | 8.70e-15 | 2.29e-14 |
%  	 |   13  | 1.28e-15 | 3.33e-15 |
%  	 |   14  | 8.51e-16 | 2.44e-15 |
%  	 |   15  | 8.25e-16 | 1.89e-15 |
%  	 |   16  | 1.17e-15 | 2.78e-15 |
%  	 |   17  | 8.83e-16 | 2.28e-15 |
%  	 |   18  | 9.77e-16 | 1.89e-15 |
%  	 |   19  | 1.30e-15 | 4.00e-15 |
%  	 |   20  | 9.31e-16 | 2.55e-15 |
%  	 .....................................
%
%
%  	 *** exp(-g(x,y,z)), g=@(x,y,z) (x-x0).^2+(y-y0).^2+(z-z0).^2  centroid=(5.774e-01,5.774e-01,5.774e-01)
%
%  	 .....................................
%  	 |  deg  |   REL2   |  RELinf  |
%  	 .....................................
%  	 |    1  | 5.80e-02 | 5.94e-02 |
%  	 |    2  | 3.30e-03 | 4.94e-03 |
%  	 |    3  | 1.41e-04 | 2.53e-04 |
%  	 |    4  | 5.22e-06 | 9.27e-06 |
%  	 |    5  | 1.93e-07 | 3.53e-07 |
%  	 |    6  | 6.13e-09 | 1.50e-08 |
%  	 |    7  | 1.55e-10 | 3.97e-10 |
%  	 |    8  | 3.63e-12 | 7.22e-12 |
%  	 |    9  | 8.49e-14 | 1.89e-13 |
%  	 |   10  | 1.72e-15 | 5.00e-15 |
%  	 |   11  | 9.09e-16 | 4.11e-15 |
%  	 |   12  | 8.74e-16 | 2.55e-15 |
%  	 |   13  | 1.09e-15 | 4.44e-15 |
%  	 |   14  | 8.68e-16 | 2.78e-15 |
%  	 |   15  | 8.28e-16 | 2.44e-15 |
%  	 |   16  | 1.02e-15 | 4.55e-15 |
%  	 |   17  | 9.55e-16 | 4.00e-15 |
%  	 |   18  | 1.05e-15 | 4.44e-15 |
%  	 |   19  | 1.35e-15 | 7.44e-15 |
%  	 |   20  | 1.06e-15 | 4.77e-15 |
%  	 .....................................
%
%
%  	 *** ((x-x0).^2 + (y-y0).^2 + (z-z0).^2).^(5/2), x0=0; y0=0; z0=1;
%
%  	 .....................................
%  	 |  deg  |   REL2   |  RELinf  |
%  	 .....................................
%  	 |    1  | 1.88e-01 | 1.92e-01 |
%  	 |    2  | 2.25e-02 | 2.30e-02 |
%  	 |    3  | 1.32e-03 | 1.19e-03 |
%  	 |    4  | 1.75e-04 | 2.30e-04 |
%  	 |    5  | 1.02e-04 | 1.60e-04 |
%  	 |    6  | 1.09e-05 | 1.83e-05 |
%  	 |    7  | 4.28e-06 | 7.23e-06 |
%  	 |    8  | 3.00e-06 | 9.35e-06 |
%  	 |    9  | 7.50e-07 | 2.42e-06 |
%  	 |   10  | 2.16e-07 | 4.93e-07 |
%  	 |   11  | 1.20e-07 | 4.05e-07 |
%  	 |   12  | 4.94e-08 | 1.37e-07 |
%  	 |   13  | 2.14e-08 | 6.05e-08 |
%  	 |   14  | 1.63e-08 | 3.83e-08 |
%  	 |   15  | 6.79e-09 | 2.03e-08 |
%  	 |   16  | 2.92e-09 | 8.79e-09 |
%  	 |   17  | 1.66e-09 | 4.97e-09 |
%  	 |   18  | 8.94e-10 | 2.85e-09 |
%  	 |   19  | 3.80e-10 | 1.19e-09 |
%  	 |   20  | 2.44e-10 | 8.12e-10 |
%  	 .....................................
%
%
%  	 *** ((x-x0).^2 + (y-y0).^2 + (z-z0).^2).^(5/2),  centroid=(5.774e-01,5.774e-01,5.774e-01)
%
%  	 .....................................
%  	 |  deg  |   REL2   |  RELinf  |
%  	 .....................................
%  	 |    1  | 1.29e+00 | 3.27e-01 |
%  	 |    2  | 1.03e-01 | 3.57e-02 |
%  	 |    3  | 7.01e-03 | 2.64e-03 |
%  	 |    4  | 1.32e-03 | 4.93e-04 |
%  	 |    5  | 4.20e-04 | 1.89e-04 |
%  	 |    6  | 1.77e-04 | 8.59e-05 |
%  	 |    7  | 7.15e-05 | 3.97e-05 |
%  	 |    8  | 3.35e-05 | 1.65e-05 |
%  	 |    9  | 1.89e-05 | 1.21e-05 |
%  	 |   10  | 1.14e-05 | 5.91e-06 |
%  	 |   11  | 6.51e-06 | 3.60e-06 |
%  	 |   12  | 3.82e-06 | 2.31e-06 |
%  	 |   13  | 2.52e-06 | 1.88e-06 |
%  	 |   14  | 2.01e-06 | 2.30e-06 |
%  	 |   15  | 1.27e-06 | 1.65e-06 |
%  	 |   16  | 8.55e-07 | 6.14e-07 |
%  	 |   17  | 9.33e-07 | 1.10e-06 |
%  	 |   18  | 5.42e-07 | 5.14e-07 |
%  	 |   19  | 3.19e-07 | 4.07e-07 |
%  	 |   20  | 2.21e-07 | 1.86e-07 |
%  	 .....................................

switch deg
    case  1
        pts=[
            0.000000000000000e+00  0.000000000000000e+00  1.000000000000000e+00
            1.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
            5.446595298431507e-01  5.930202342884422e-01  5.930202342884422e-01
            0.000000000000000e+00  1.000000000000000e+00  0.000000000000000e+00
            ];
        
        
    case  2
        pts=[
            0.000000000000000e+00  5.868590900433557e-01  8.096890813352273e-01
            4.086354520926078e-01  0.000000000000000e+00  9.126976866920777e-01
            0.000000000000000e+00  0.000000000000000e+00  1.000000000000000e+00
            8.884797022645115e-01  4.589159167690364e-01  0.000000000000000e+00
            1.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
            8.884797022645115e-01  0.000000000000000e+00  4.589159167690364e-01
            5.777949227930294e-01  5.965060359912704e-01  5.570759160299238e-01
            0.000000000000000e+00  1.000000000000000e+00  0.000000000000000e+00
            3.250671899601978e-01  9.208905388008172e-01  2.151556124262657e-01
            ];
        
        
    case  3
        pts=[
            3.700583910574751e-01  3.343384920435815e-01  8.667609589419547e-01
            0.000000000000000e+00  2.417508727774944e-01  9.703383510463346e-01
            2.417508727774944e-01  0.000000000000000e+00  9.703383510463346e-01
            0.000000000000000e+00  0.000000000000000e+00  1.000000000000000e+00
            9.703383510463346e-01  2.417508727774944e-01  0.000000000000000e+00
            1.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
            7.208140246843528e-01  6.929569599672840e-01  1.542055288389526e-02
            9.703383510463346e-01  0.000000000000000e+00  2.417508727774944e-01
            8.748568911482929e-01  3.343357095157032e-01  3.504925867304117e-01
            7.081730973284706e-01  -3.396657974752030e-13  7.060388546108497e-01
            2.427520873441163e-02  6.971460264490454e-01  7.165180612149337e-01
            5.893703820121038e-01  5.712453732009157e-01  5.712453732009157e-01
            0.000000000000000e+00  1.000000000000000e+00  0.000000000000000e+00
            2.761883847104365e-01  9.611035199972164e-01  0.000000000000000e+00
            0.000000000000000e+00  9.611035199972164e-01  2.761883847104365e-01
            3.562768855006261e-01  8.637902301577318e-01  3.562768855006261e-01
            ];
        
        
    case  4
        pts=[
            4.204265704938189e-01  3.939879523110060e-01  8.173218412942274e-01
            0.000000000000000e+00  4.728945767759928e-01  8.811190153752526e-01
            4.728945767759929e-01  0.000000000000000e+00  8.811190153752526e-01
            2.271442107356904e-01  1.997544487103295e-01  9.531545875406006e-01
            0.000000000000000e+00  1.643387564201814e-01  9.864039604230450e-01
            1.643387564201814e-01  0.000000000000000e+00  9.864039604230450e-01
            0.000000000000000e+00  0.000000000000000e+00  1.000000000000000e+00
            9.064612007808024e-01  4.222891088804279e-01  0.000000000000000e+00
            9.897920986238496e-01  1.425187759623112e-01  0.000000000000000e+00
            1.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
            9.864039604230450e-01  0.000000000000000e+00  1.643387564201814e-01
            9.531545875406006e-01  1.997544487103295e-01  2.271442107356904e-01
            8.202534539183043e-01  3.941770917160349e-01  4.144981202627833e-01
            8.811190153752526e-01  0.000000000000000e+00  4.728945767759929e-01
            4.527936147051144e-01  8.062324260423792e-01  3.807456075650723e-01
            1.980082991606051e-01  7.033777986745061e-01  6.826802954497296e-01
            7.185710717462206e-01  6.768169305673210e-01  1.599201592886846e-01
            5.950154241242018e-01  5.578340949112581e-01  5.785998337442153e-01
            6.911426716533792e-01  1.724069976665043e-01  7.018530006884999e-01
            0.000000000000000e+00  1.000000000000000e+00  0.000000000000000e+00
            1.643387564201814e-01  9.864039604230450e-01  0.000000000000000e+00
            4.728945767759929e-01  8.811190153752526e-01  0.000000000000000e+00
            0.000000000000000e+00  9.864039604230450e-01  1.643387564201814e-01
            2.135042160429275e-01  9.497367599721103e-01  2.289454880306075e-01
            0.000000000000000e+00  8.811190153752526e-01  4.728945767759929e-01
            ];
        
        
    case  5
        pts=[
            1.637093626289751e-01  5.856239002393973e-01  7.938790160068543e-01
            0.000000000000000e+00  6.824551860518837e-01  7.309274375961603e-01
            6.180090626143796e-01  0.000000000000000e+00  7.861709728338334e-01
            4.905765704432904e-01  1.115101913777404e-01  8.642338258544380e-01
            2.972651008831608e-01  2.640356269398933e-01  9.175612500009914e-01
            0.000000000000000e+00  3.295875124763242e-01  9.441250296542660e-01
            3.295875124763242e-01  0.000000000000000e+00  9.441250296542660e-01
            1.437856427399491e-01  1.413573902702747e-01  9.794609625492161e-01
            0.000000000000000e+00  1.038999400291402e-01  9.945877550331801e-01
            1.038999400291401e-01  0.000000000000000e+00  9.945877550331801e-01
            0.000000000000000e+00  0.000000000000000e+00  1.000000000000000e+00
            7.131529128901903e-01  7.010085041112102e-01  0.000000000000000e+00
            9.441250296542660e-01  3.295875124763242e-01  0.000000000000000e+00
            9.945877550331801e-01  1.038999400291402e-01  0.000000000000000e+00
            1.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
            9.945877550331801e-01  0.000000000000000e+00  1.038999400291401e-01
            8.498538839117724e-01  5.115460345185916e-01  1.267636800048786e-01
            9.794609625492161e-01  1.413573902702747e-01  1.437856427399491e-01
            9.175612500009914e-01  2.640356269398933e-01  2.972651008831608e-01
            9.441250296542660e-01  0.000000000000000e+00  3.295875124763242e-01
            8.259259121254191e-01  9.524279048964228e-02  5.556754435275508e-01
            4.287127496783578e-01  7.737237664052860e-01  4.664299642634896e-01
            6.603951265293202e-01  6.799229249598181e-01  3.187210268721044e-01
            5.847806305880654e-01  5.654857887198271e-01  5.815990344257284e-01
            4.047776037191252e-01  4.850364771510037e-01  7.751739852190259e-01
            7.808950694292923e-01  4.082816043280533e-01  4.727674080436717e-01
            6.180091955770399e-01  3.057245433507917e-01  7.242907826109414e-01
            0.000000000000000e+00  1.000000000000000e+00  0.000000000000000e+00
            1.038999400291401e-01  9.945877550331801e-01  0.000000000000000e+00
            3.295875124763242e-01  9.441250296542660e-01  0.000000000000000e+00
            0.000000000000000e+00  9.945877550331801e-01  1.038999400291401e-01
            5.245339997571767e-01  8.433377701595941e-01  1.168139055120653e-01
            1.507268468666656e-01  9.782302015939278e-01  1.426432274001685e-01
            2.931294994836193e-01  9.149423548026331e-01  2.774086947460292e-01
            0.000000000000000e+00  9.441250296542660e-01  3.295875124763242e-01
            1.403196376019521e-01  8.246791192313220e-01  5.479185611084078e-01
            ];
        
        
    case  6
        pts=[
            5.361028439291694e-01  1.880065506826013e-01  8.229503494327511e-01
            1.491009581826230e-01  5.514355417492480e-01  8.207848363394252e-01
            3.370252227849854e-01  3.530443397673386e-01  8.727964787766819e-01
            4.843081366985837e-01  0.000000000000000e+00  8.748974961260010e-01
            0.000000000000000e+00  4.681983404769817e-01  8.836234005358845e-01
            3.067469311680609e-01  1.159581766364970e-01  9.447010222764215e-01
            1.296752530918271e-01  2.880836883369874e-01  9.487845473287009e-01
            0.000000000000000e+00  2.417508727774944e-01  9.703383510463346e-01
            2.417508727774944e-01  0.000000000000000e+00  9.703383510463346e-01
            9.646164719357905e-02  9.885513026878896e-02  9.904154753638708e-01
            0.000000000000000e+00  7.338997244140416e-02  9.973033199308272e-01
            7.338997244140413e-02  0.000000000000000e+00  9.973033199308272e-01
            0.000000000000000e+00  0.000000000000000e+00  1.000000000000000e+00
            8.836234005358845e-01  4.681983404769817e-01  0.000000000000000e+00
            9.703383510463346e-01  2.417508727774944e-01  0.000000000000000e+00
            9.973033199308272e-01  7.338997244140416e-02  0.000000000000000e+00
            1.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
            9.973033199308272e-01  0.000000000000000e+00  7.338997244140413e-02
            9.904154753638708e-01  9.885513026878896e-02  9.646164719357905e-02
            9.437769680995385e-01  3.059644719714694e-01  1.251829715898406e-01
            8.127123875302719e-01  5.542893161266541e-01  1.796160604809365e-01
            9.703383510463346e-01  0.000000000000000e+00  2.417508727774944e-01
            9.447010222764215e-01  1.159581766364970e-01  3.067469311680609e-01
            8.829100417421297e-01  3.341722494321845e-01  3.298465793370375e-01
            8.748974961260010e-01  0.000000000000000e+00  4.843081366985837e-01
            8.179277183108112e-01  1.876800947730934e-01  5.438478000735436e-01
            7.070292565414457e-01  7.070809412124911e-01  1.209020134275405e-02
            4.631521094912201e-01  7.291654174134872e-01  5.037935266773960e-01
            2.993836231129345e-01  6.746737901429744e-01  6.746737901429744e-01
            6.580338023324327e-01  6.585030233463907e-01  3.651921182495372e-01
            5.893703820121038e-01  5.712453732009157e-01  5.712453732009157e-01
            4.631521094912201e-01  5.037935266773960e-01  7.291654174134872e-01
            7.559480133684044e-01  4.628944810020761e-01  4.628944810020761e-01
            6.580338023324327e-01  3.651921182495372e-01  6.585030233463907e-01
            7.047383873574998e-01  2.307282526244078e-02  7.090919898850638e-01
            0.000000000000000e+00  1.000000000000000e+00  0.000000000000000e+00
            7.338997244140413e-02  9.973033199308272e-01  0.000000000000000e+00
            2.417508727774944e-01  9.703383510463346e-01  0.000000000000000e+00
            4.681983404769817e-01  8.836234005358845e-01  0.000000000000000e+00
            0.000000000000000e+00  9.973033199308272e-01  7.338997244140413e-02
            3.444034839906867e-01  9.349300779209343e-01  8.539314734703563e-02
            1.054438816295814e-01  9.888190813560253e-01  1.054438816295814e-01
            5.565369770636455e-01  8.126833081972170e-01  1.726627746171324e-01
            2.383309439391983e-01  9.414864429837010e-01  2.383309439391983e-01
            0.000000000000000e+00  9.703383510463346e-01  2.417508727774944e-01
            3.562768855006261e-01  8.637902301577318e-01  3.562768855006261e-01
            0.000000000000000e+00  8.836234005358845e-01  4.681983404769817e-01
            1.490087745447132e-01  8.307673905532441e-01  5.363039510408594e-01
            0.000000000000000e+00  7.113611930159753e-01  7.028266166494326e-01
            ];
        
        
    case  7
        pts=[
            5.556135967553747e-01  2.364926517300494e-01  7.970977084261662e-01
            2.180580134456649e-01  5.576662431613502e-01  8.009113958550198e-01
            3.688396128594219e-01  3.850927741872573e-01  8.459674315566018e-01
            0.000000000000000e+00  5.973707796635978e-01  8.019651810422354e-01
            5.767956465430157e-01  0.000000000000000e+00  8.168884759433349e-01
            5.322600456764331e-02  5.002189864158116e-01  8.642615102310778e-01
            1.820312332201835e-01  3.629171081915406e-01  9.138685916006900e-01
            3.353590408769374e-01  1.972306257364216e-01  9.212135441762243e-01
            0.000000000000000e+00  3.750621298432258e-01  9.269996757051554e-01
            3.750621298432258e-01  0.000000000000000e+00  9.269996757051554e-01
            9.004444206661867e-02  2.315877832177259e-01  9.686377532995557e-01
            2.314345817767008e-01  8.556770533460591e-02  9.690800803657115e-01
            0.000000000000000e+00  1.829063829959452e-01  9.831303347264495e-01
            1.829063829959451e-01  0.000000000000000e+00  9.831303347264495e-01
            7.404639951981092e-02  7.302401910236458e-02  9.945776105223212e-01
            0.000000000000000e+00  5.451876644806861e-02  9.985127460903946e-01
            5.451876644828457e-02  -2.165941854674059e-13  9.985127460903828e-01
            0.000000000000000e+00  0.000000000000000e+00  1.000000000000000e+00
            8.322105188075215e-01  5.544597842820667e-01  0.000000000000000e+00
            9.269996757051554e-01  3.750621298432258e-01  0.000000000000000e+00
            9.831303347264495e-01  1.829063829959452e-01  0.000000000000000e+00
            9.985127460903946e-01  5.451876644806861e-02  0.000000000000000e+00
            1.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
            9.985127460903828e-01  -2.165941854674059e-13  5.451876644828457e-02
            9.945776105223212e-01  7.302401910236458e-02  7.404639951981092e-02
            9.686377532995557e-01  2.315877832177259e-01  9.004444206661867e-02
            9.138685916006900e-01  3.629171081915406e-01  1.820312332201835e-01
            9.831303347264495e-01  0.000000000000000e+00  1.829063829959451e-01
            9.690800803657114e-01  8.556770533460591e-02  2.314345817767007e-01
            9.212135441762243e-01  1.972306257364216e-01  3.353590408769374e-01
            8.470446573267782e-01  3.688904926046748e-01  3.826684635033848e-01
            9.269996757051554e-01  0.000000000000000e+00  3.750621298432258e-01
            8.727945499084290e-01  7.638780632979425e-02  4.820732067790789e-01
            8.168884759433349e-01  0.000000000000000e+00  5.767956465430157e-01
            9.203758215087050e-02  7.174982590278698e-01  6.904529902634918e-01
            7.170558056848252e-01  6.920254627846368e-01  8.325701406725786e-02
            4.680905826619716e-01  7.125175174440780e-01  5.226949337409958e-01
            3.435265368304852e-01  6.606505521797182e-01  6.674806112524069e-01
            6.384926606403158e-01  6.665979067209431e-01  3.846743467710151e-01
            7.851300646300822e-01  5.671684954240664e-01  2.487783740849749e-01
            5.926096989762478e-01  5.636456110970877e-01  5.754279883445640e-01
            4.673101989956571e-01  5.134072175430839e-01  7.197459321797574e-01
            7.225645192545770e-01  4.959556884213260e-01  4.815895250490095e-01
            6.510248255091562e-01  3.734034010559169e-01  6.608604819859082e-01
            7.880451197816936e-01  2.250496719805249e-01  5.730074470106949e-01
            6.922170533800389e-01  8.912661556170666e-02  7.161647836974198e-01
            0.000000000000000e+00  1.000000000000000e+00  0.000000000000000e+00
            4.705154307222260e-02  9.988924628279677e-01  0.000000000000000e+00
            1.570183828115307e-01  9.875956801542074e-01  0.000000000000000e+00
            3.444097069443413e-01  9.388194468386949e-01  0.000000000000000e+00
            5.873068392506020e-01  8.093643657645593e-01  0.000000000000000e+00
            0.000000000000000e+00  9.988924628279677e-01  4.705154307222260e-02
            7.127061133293347e-02  9.946961737498540e-01  7.416213243718256e-02
            2.361911038963353e-01  9.680982678418333e-01  8.366305183217138e-02
            4.544879829415409e-01  8.851898382457595e-01  9.939629584735993e-02
            0.000000000000000e+00  9.875956801542074e-01  1.570183828115307e-01
            5.684733170990234e-01  7.926779848226251e-01  2.202264746209578e-01
            1.000956285003628e-01  9.664233305645108e-01  2.366575823752864e-01
            2.917868010940518e-01  9.144564190468988e-01  2.804102715151907e-01
            0.000000000000000e+00  9.388194468386949e-01  3.444097069443413e-01
            3.940692251551690e-01  8.374318658396154e-01  3.787047872182042e-01
            1.270683254412034e-01  8.930159902553289e-01  4.317129623000249e-01
            2.332956800762359e-01  8.008293990853061e-01  5.515844443223847e-01
            0.000000000000000e+00  8.322105188075215e-01  5.544597842820667e-01
            ];
        
        
    case  8
        pts=[
            4.100743951445310e-01  3.943066498943736e-01  8.224118532073348e-01
            0.000000000000000e+00  6.973008043806784e-01  7.167786186892426e-01
            6.081903656161108e-01  4.397946396827108e-02  7.925719436876407e-01
            6.185922503513914e-02  5.827243466530618e-01  8.103121448527192e-01
            4.730024162109828e-01  1.531424948873804e-01  8.676497510621674e-01
            1.798632025018120e-01  4.437081883871076e-01  8.779363712388406e-01
            3.225532054753790e-01  2.819150457184775e-01  9.035946749705349e-01
            4.850143360247255e-01  0.000000000000000e+00  8.745062000068924e-01
            0.000000000000000e+00  4.728945767759928e-01  8.811190153752526e-01
            3.706251586712062e-01  6.694910340351917e-02  9.263664551965426e-01
            9.255759695253744e-02  3.393474958361442e-01  9.360963456376217e-01
            2.206191275211680e-01  1.871634550670035e-01  9.572340579289792e-01
            0.000000000000000e+00  3.020012264715445e-01  9.533075365325100e-01
            3.020012264715444e-01  0.000000000000000e+00  9.533075365325100e-01
            6.860799687098884e-02  1.802085162672749e-01  9.812328130622711e-01
            1.875853428836114e-01  5.814509781680562e-02  9.805258215544923e-01
            0.000000000000000e+00  1.425187759623112e-01  9.897920986238496e-01
            1.425187759623112e-01  0.000000000000000e+00  9.897920986238496e-01
            5.831569792157863e-02  5.609287161089559e-02  9.967210588376082e-01
            0.000000000000000e+00  4.206877860980412e-02  9.991147170702067e-01
            4.206877860944534e-02  3.594331767793722e-13  9.991147170702218e-01
            0.000000000000000e+00  0.000000000000000e+00  1.000000000000000e+00
            7.221508962204602e-01  6.917355586407179e-01  0.000000000000000e+00
            8.811190153752526e-01  4.728945767759928e-01  0.000000000000000e+00
            9.574321928289020e-01  2.886582687796079e-01  0.000000000000000e+00
            9.897920986238496e-01  1.425187759623112e-01  0.000000000000000e+00
            9.991147170702067e-01  4.206877860980412e-02  0.000000000000000e+00
            1.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
            9.991147170702218e-01  3.594331767793722e-13  4.206877860944534e-02
            9.967210588376082e-01  5.609287161089559e-02  5.831569792157863e-02
            8.165235882087839e-01  5.735213770708102e-01  6.604892081975257e-02
            9.812328130622711e-01  1.802085162672749e-01  6.860799687098884e-02
            9.360963456376217e-01  3.393474958361442e-01  9.255759695253744e-02
            9.897920986238496e-01  0.000000000000000e+00  1.425187759623112e-01
            8.779363712388406e-01  4.437081883871076e-01  1.798632025018120e-01
            9.805258215544923e-01  5.814509781680562e-02  1.875853428836114e-01
            9.572340579289793e-01  1.871634550670036e-01  2.206191275211680e-01
            9.035946749705349e-01  2.819150457184775e-01  3.225532054753790e-01
            9.533075365325100e-01  0.000000000000000e+00  3.020012264715444e-01
            9.263664551965426e-01  6.694910340351917e-02  3.706251586712062e-01
            8.236550900026860e-01  3.943774412754323e-01  4.075030386705235e-01
            8.691473472384076e-01  1.647652421429446e-01  4.662995858565775e-01
            8.745062000068924e-01  0.000000000000000e+00  4.850143360247255e-01
            7.448358388257301e-01  1.444670707109495e-13  6.672477599818308e-01
            2.795760251960318e-01  7.825153144828312e-01  5.563335588794044e-01
            5.689748293030229e-01  7.756287737489098e-01  2.732538178184498e-01
            6.969616423474615e-01  6.980654392027290e-01  1.641618460149323e-01
            1.725244253070446e-01  6.965038846526537e-01  6.965038846526537e-01
            4.858676643185963e-01  7.088944070517024e-01  5.112742242871308e-01
            6.360779763111614e-01  6.594230906685657e-01  4.007068698500366e-01
            3.777010310189492e-01  6.547296889431634e-01  6.547296889431634e-01
            7.709554646931139e-01  5.709722525721299e-01  2.821672522681055e-01
            2.795760251960318e-01  5.563335588794044e-01  7.825153144828312e-01
            5.811056017942418e-01  5.754634130695678e-01  5.754634130695678e-01
            4.858676643185962e-01  5.112742242871308e-01  7.088944070517023e-01
            7.115597253612257e-01  4.968313382043533e-01  4.968313382043533e-01
            6.360779763111614e-01  4.007068698500366e-01  6.594230906685657e-01
            7.636536231882305e-01  2.739959657777477e-01  5.846018769461893e-01
            5.811553356014661e-01  2.658489300578522e-01  7.691442142336132e-01
            7.166083762557820e-01  1.352774224390409e-01  6.842312869624576e-01
            0.000000000000000e+00  1.000000000000000e+00  0.000000000000000e+00
            4.206877860943908e-02  9.991147170702220e-01  0.000000000000000e+00
            1.320972535647450e-01  9.912367606180934e-01  0.000000000000000e+00
            2.754123382387785e-01  9.613261901903269e-01  0.000000000000000e+00
            4.728945767759929e-01  8.811190153752526e-01  0.000000000000000e+00
            0.000000000000000e+00  9.991147170702220e-01  4.206877860943908e-02
            5.880932930625297e-01  8.069229195508471e-01  5.496981497519036e-02
            5.632438738796669e-02  9.968225151804812e-01  5.632438738796669e-02
            1.756889540737223e-01  9.824001617883328e-01  6.342959510149099e-02
            3.446947615398476e-01  9.357178037389302e-01  7.495140514346881e-02
            0.000000000000000e+00  9.912367606180934e-01  1.320972535647450e-01
            4.583427174278128e-01  8.732349588611573e-01  1.654770679086413e-01
            6.717505511554785e-02  9.827968915586709e-01  1.720400590352062e-01
            2.062494922808194e-01  9.565157049770842e-01  2.062494922808194e-01
            0.000000000000000e+00  9.613261901903269e-01  2.754123382387785e-01
            3.062801493952882e-01  9.013239928975595e-01  3.062801493952882e-01
            6.931864657060595e-02  9.342973288594858e-01  3.496904724519232e-01
            4.025070768627823e-01  8.221776609412084e-01  4.025070768627823e-01
            1.654770679086413e-01  8.732349588611573e-01  4.583427174278128e-01
            0.000000000000000e+00  8.811190153752526e-01  4.728945767759929e-01
            5.565946531885637e-02  8.014460150632221e-01  5.954715012993489e-01
            ];
        
        
    case  9
        pts=[
            6.069428199034428e-01  9.356392968807029e-02  7.892187304093732e-01
            9.411668641201197e-02  5.834998885719224e-01  8.066411403935315e-01
            4.905084753110324e-01  2.155677501452727e-01  8.443529953433881e-01
            2.359196702912949e-01  4.727316903263739e-01  8.490386670410341e-01
            3.400944555339916e-01  3.146020858422915e-01  8.862061210004799e-01
            5.679373203184634e-01  0.000000000000000e+00  8.230718074320630e-01
            0.000000000000000e+00  5.500669262185304e-01  8.351205761328706e-01
            4.222534861164006e-01  1.051974711705635e-01  9.003529782934386e-01
            4.795456944820944e-02  4.654882579431105e-01  8.837539482152965e-01
            1.463786111923920e-01  3.689052704276919e-01  9.178682931859330e-01
            2.720299422388955e-01  2.161538452469229e-01  9.376978328387415e-01
            4.004572133072130e-01  0.000000000000000e+00  9.163154589497119e-01
            0.000000000000000e+00  3.886267899037281e-01  9.213952562115367e-01
            3.003167129091556e-01  5.305537649746027e-02  9.523628504788250e-01
            6.682272280509688e-02  2.758572007460579e-01  9.588730513021327e-01
            1.698956065071860e-01  1.486038040834431e-01  9.741932007058379e-01
            0.000000000000000e+00  2.347363262504711e-01  9.720590810945765e-01
            2.347363262504711e-01  0.000000000000000e+00  9.720590810945765e-01
            5.193871769252148e-02  1.436546572686154e-01  9.882639875304033e-01
            1.434010949915186e-01  4.576013445037995e-02  9.886061582097881e-01
            0.000000000000000e+00  1.139047892485251e-01  9.934916703154832e-01
            1.139047892485250e-01  0.000000000000000e+00  9.934916703154834e-01
            4.164728264589973e-02  4.433643365520840e-02  9.981481776264233e-01
            0.000000000000000e+00  3.343473885847675e-02  9.994409028239066e-01
            3.343473885883461e-02  -3.582839728556652e-13  9.994409028238945e-01
            0.000000000000000e+00  0.000000000000000e+00  1.000000000000000e+00
            8.351205761328706e-01  5.500669262185304e-01  0.000000000000000e+00
            9.213952562115367e-01  3.886267899037281e-01  0.000000000000000e+00
            9.720590810945765e-01  2.347363262504711e-01  0.000000000000000e+00
            9.934916703154832e-01  1.139047892485251e-01  0.000000000000000e+00
            9.994409028239066e-01  3.343473885847675e-02  0.000000000000000e+00
            1.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
            9.994409028238945e-01  -3.582839728556652e-13  3.343473885883461e-02
            8.784679624856325e-01  4.758888543973581e-01  4.270640638957312e-02
            9.981481776264233e-01  4.433643365520840e-02  4.164728264589973e-02
            9.882639875304033e-01  1.436546572686154e-01  5.193871769252148e-02
            9.588730513021327e-01  2.758572007460579e-01  6.682272280509688e-02
            9.934916703154834e-01  0.000000000000000e+00  1.139047892485250e-01
            7.807742220164748e-01  6.124020186375476e-01  1.239168342204766e-01
            9.148093786813865e-01  3.804059791773658e-01  1.357022169409368e-01
            9.886061582097881e-01  4.576013445037995e-02  1.434010949915186e-01
            9.741932007058379e-01  1.486038040834431e-01  1.698956065071860e-01
            8.505405682917483e-01  4.724632946304393e-01  2.309960538989802e-01
            9.720590810945765e-01  0.000000000000000e+00  2.347363262504711e-01
            9.390248745870514e-01  2.273770279540724e-01  2.579379228914299e-01
            9.523628504788249e-01  5.305537649746026e-02  3.003167129091555e-01
            8.862061210004800e-01  3.146020858422915e-01  3.400944555339916e-01
            9.058729045643755e-01  1.140208059835234e-01  4.079136386282879e-01
            9.163154589497119e-01  0.000000000000000e+00  4.004572133072130e-01
            8.389555905577861e-01  2.269356190246603e-01  4.946248496484285e-01
            8.230718074320630e-01  0.000000000000000e+00  5.679373203184634e-01
            8.079328814206921e-01  7.152365539837972e-02  5.849177940853840e-01
            7.101230257680065e-01  2.691946830867317e-13  7.040776152343514e-01
            7.103301296165232e-01  7.037034025939896e-01  1.525215186833451e-02
            1.716929695367500e-02  7.044981554205875e-01  7.094981072921240e-01
            3.799659905437257e-01  7.949311003250624e-01  4.729803291534550e-01
            5.321927155563588e-01  7.744777197847182e-01  3.419870978060606e-01
            2.637949513809387e-01  7.337096695459028e-01  6.261647901637157e-01
            6.764198061066011e-01  6.908898539411211e-01  2.552008143167345e-01
            1.786298616104865e-01  6.530882665667423e-01  7.359124191191952e-01
            5.002853573222078e-01  6.996941698732475e-01  5.100417923017465e-01
            4.046461024465097e-01  6.559978846958043e-01  6.371250325089096e-01
            6.457112814045640e-01  6.410084433061748e-01  4.149278451454787e-01
            3.305122574477545e-01  5.762811182765589e-01  7.474367668202494e-01
            7.570316709833487e-01  5.588951892841915e-01  3.384364290722066e-01
            5.845866385421958e-01  5.782255384770523e-01  5.691341570235079e-01
            4.872540119232044e-01  5.262679141496093e-01  6.968684311987170e-01
            7.024231343014083e-01  4.977984305260987e-01  5.087223829987616e-01
            6.246693384806267e-01  4.318782893712665e-01  6.505915467725699e-01
            8.054105273342701e-01  3.999110717743256e-01  4.374757331915031e-01
            4.433472827704973e-01  4.001189462412424e-01  8.020897803356022e-01
            7.336816275487017e-01  3.208441675618806e-01  5.989743646759953e-01
            6.120184915364562e-01  2.968870893960713e-01  7.330016522269033e-01
            7.103183625217693e-01  1.754913714032129e-01  6.816528459761698e-01
            0.000000000000000e+00  1.000000000000000e+00  0.000000000000000e+00
            3.343473885883956e-02  9.994409028238944e-01  0.000000000000000e+00
            1.054901229776867e-01  9.944203507341111e-01  0.000000000000000e+00
            2.235052816716592e-01  9.747027183017765e-01  0.000000000000000e+00
            3.886267899037281e-01  9.213952562115367e-01  0.000000000000000e+00
            5.500669262185304e-01  8.351205761328705e-01  0.000000000000000e+00
            0.000000000000000e+00  9.994409028238944e-01  3.343473885883956e-02
            4.556287266886622e-02  9.979846016013917e-01  4.416740427817862e-02
            2.960501966375718e-01  9.538792854175053e-01  4.968490638256511e-02
            1.380636393263909e-01  9.889369758143249e-01  5.424103025542250e-02
            0.000000000000000e+00  9.944203507341111e-01  1.054901229776867e-01
            6.124697526919757e-01  7.824956835307395e-01  1.121664267648335e-01
            4.051770487634818e-01  9.063822398779342e-01  1.195942907883735e-01
            5.155809370700382e-02  9.887085840097859e-01  1.407021637312809e-01
            1.945552127652657e-01  9.683391814057731e-01  1.564209031435996e-01
            4.666932872636793e-01  8.554148152713800e-01  2.246394209333072e-01
            0.000000000000000e+00  9.747027183017765e-01  2.235052816716592e-01
            2.655866480512019e-01  9.290758700095243e-01  2.574524424878749e-01
            6.593152615957194e-02  9.574153383636013e-01  2.810852250197091e-01
            3.362103889446218e-01  8.755966416212339e-01  3.468329504924854e-01
            1.340652366024790e-01  9.098391516913837e-01  3.927075634415823e-01
            0.000000000000000e+00  9.213952562115367e-01  3.886267899037281e-01
            2.140886819148672e-01  8.532643409567110e-01  4.755060469937942e-01
            4.427080941627943e-02  8.773776615456652e-01  4.777536336379741e-01
            0.000000000000000e+00  8.351205761328705e-01  5.500669262185304e-01
            1.114402247898206e-01  7.856866055895286e-01  6.085044240562255e-01
            ];
        
        
    case 10
        pts=[
            6.020191211908319e-01  1.700356353301446e-01  7.801672003093264e-01
            2.550026393143820e-01  4.977563948238615e-01  8.289826447849504e-01
            4.797842370959609e-01  2.669734390530035e-01  8.357824290295046e-01
            6.497631830943202e-01  0.000000000000000e+00  7.601367021103091e-01
            3.493233335403277e-01  3.586053965497492e-01  8.656647031095065e-01
            0.000000000000000e+00  6.163763697410608e-01  7.874516942802466e-01
            5.715604406832460e-01  3.687478915695691e-02  8.197310001278491e-01
            1.033185810687944e-01  4.951344121155977e-01  8.626512532564202e-01
            4.619339235988756e-01  1.302282309130219e-01  8.773013496523373e-01
            2.065714765555028e-01  3.653484479416544e-01  9.076611353695296e-01
            3.317087543818909e-01  2.364640309552039e-01  9.132656044825245e-01
            4.893511011496378e-01  0.000000000000000e+00  8.720868648269144e-01
            0.000000000000000e+00  4.797884489312345e-01  8.773842056204113e-01
            3.885769730255531e-01  5.314586478370431e-02  9.198823039338733e-01
            4.937185068055445e-02  3.840328746373052e-01  9.219984661365683e-01
            1.388497453122783e-01  2.721101057162394e-01  9.521957984541900e-01
            2.533965397702578e-01  1.558755546869396e-01  9.547214280005970e-01
            3.344851102890421e-01  0.000000000000000e+00  9.424010351198302e-01
            0.000000000000000e+00  3.237516154882661e-01  9.461421095526495e-01
            4.854774326686625e-02  2.337676921797697e-01  9.710796994668557e-01
            2.394538972642677e-01  4.211584548421888e-02  9.699938590754598e-01
            1.336024326434674e-01  1.265265346721564e-01  9.829249340695368e-01
            2.000384966496833e-01  0.000000000000000e+00  9.797880382297666e-01
            0.000000000000000e+00  1.905061461962661e-01  9.816860028855697e-01
            1.241965050083170e-01  3.640548951890048e-02  9.915895665428355e-01
            4.313704483568157e-02  1.151284005515670e-01  9.924135462342715e-01
            0.000000000000000e+00  9.139103751026562e-02  9.958150823635867e-01
            9.139103751026560e-02  0.000000000000000e+00  9.958150823635867e-01
            3.794311890526614e-02  3.540500261989893e-02  9.986524948735801e-01
            0.000000000000000e+00  2.672774871229388e-02  9.996427499105730e-01
            2.672774871215104e-02  1.429809541350132e-13  9.996427499105769e-01
            0.000000000000000e+00  0.000000000000000e+00  1.000000000000000e+00
            7.874516942802466e-01  6.163763697410608e-01  0.000000000000000e+00
            8.826277960316239e-01  4.700725195885824e-01  0.000000000000000e+00
            9.461421095526495e-01  3.237516154882661e-01  0.000000000000000e+00
            9.816860028855697e-01  1.905061461962661e-01  0.000000000000000e+00
            9.958150823635867e-01  9.139103751026562e-02  0.000000000000000e+00
            9.996427499105730e-01  2.672774871229388e-02  0.000000000000000e+00
            1.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
            9.996427499105769e-01  1.429809541350132e-13  2.672774871215104e-02
            9.986524948735801e-01  3.540500261989893e-02  3.794311890526614e-02
            9.713668105869403e-01  2.334196604981113e-01  4.429200134450812e-02
            9.924135462342715e-01  1.151284005515670e-01  4.313704483568157e-02
            9.215944400162852e-01  3.845016113861956e-01  5.312437267854368e-02
            8.503254164631271e-01  5.204755788213619e-01  7.779368848035123e-02
            9.958150823635867e-01  0.000000000000000e+00  9.139103751026560e-02
            9.915895665428355e-01  3.640548951890048e-02  1.241965050083170e-01
            9.829249340695368e-01  1.265265346721564e-01  1.336024326434674e-01
            9.547638661742435e-01  2.615216289207898e-01  1.415358521881579e-01
            7.676353279927371e-01  6.251673621616044e-01  1.410736421355324e-01
            8.989033925314162e-01  3.974236574224307e-01  1.844644340150407e-01
            9.797880382297666e-01  0.000000000000000e+00  2.000384966496833e-01
            8.260778332598787e-01  5.073183380364203e-01  2.454048029045650e-01
            9.699938590754598e-01  4.211584548421888e-02  2.394538972642677e-01
            9.553290478159852e-01  1.469548624986270e-01  2.564189516923678e-01
            9.195789377787366e-01  2.573533449930445e-01  2.968902710002833e-01
            8.634394009430654e-01  3.586172202733581e-01  3.547761128127007e-01
            9.424010351198302e-01  0.000000000000000e+00  3.344851102890421e-01
            9.198823039338733e-01  5.314586478370431e-02  3.885769730255531e-01
            8.844455390844757e-01  1.568763880434847e-01  4.394836598418662e-01
            8.308372993375632e-01  2.666275030226845e-01  4.884865982412955e-01
            8.720868648269144e-01  0.000000000000000e+00  4.893511011496378e-01
            8.306474677882495e-01  5.773236498836386e-02  5.537975788045839e-01
            7.778929589909228e-01  0.000000000000000e+00  6.283968048552973e-01
            6.974296930152467e-01  7.152631956241025e-01  4.461372307099760e-02
            5.526075623167830e-02  7.048734283951175e-01  7.071772753441786e-01
            4.444222825403045e-01  7.834672054702995e-01  4.343592668911593e-01
            3.649881376059184e-01  7.457167840093563e-01  5.573958534593763e-01
            5.806595458367196e-01  7.327887431095533e-01  3.547606937086120e-01
            2.571321362409881e-01  6.886701604911517e-01  6.779502006498982e-01
            6.854805426800875e-01  6.832366768958092e-01  2.516029986931483e-01
            5.174154918625627e-01  6.867541779080975e-01  5.105388407422058e-01
            1.604223245749948e-01  6.188750404599227e-01  7.689332624315871e-01
            4.328292725526987e-01  6.463983032275785e-01  6.283534470391716e-01
            6.465931296754842e-01  6.313608705496027e-01  4.281363985873080e-01
            3.532771880260365e-01  5.786541580595571e-01  7.350881537481075e-01
            7.415598772571363e-01  5.763881788252807e-01  3.433156211896820e-01
            5.916415770165606e-01  5.741674763465130e-01  5.659434189486028e-01
            5.059224832894962e-01  5.252255664337390e-01  6.842371995635340e-01
            6.970991591742425e-01  5.021095614178984e-01  5.117995218943546e-01
            4.203709744929901e-01  4.503707781858393e-01  7.876892826236088e-01
            7.849948059038374e-01  4.325644587250357e-01  4.434762042679556e-01
            6.276710979698176e-01  4.429192252926972e-01  6.401964953352061e-01
            5.378053518390185e-01  3.801981595412310e-01  7.524724333919285e-01
            7.300932668965895e-01  3.546460922776331e-01  5.841146898208175e-01
            6.586602040789663e-01  2.826067954296632e-01  6.973522314724683e-01
            7.720694831171478e-01  1.761415040750855e-01  6.106413708400266e-01
            7.064170216279504e-01  7.485113786990763e-02  7.038268954180965e-01
            0.000000000000000e+00  1.000000000000000e+00  0.000000000000000e+00
            2.672774871214945e-02  9.996427499105769e-01  0.000000000000000e+00
            7.804586375962806e-02  9.969497696223284e-01  0.000000000000000e+00
            1.719537332750705e-01  9.851050266914518e-01  0.000000000000000e+00
            3.023565580236514e-01  9.531948970803874e-01  0.000000000000000e+00
            4.602122030032074e-01  8.878089480327029e-01  0.000000000000000e+00
            6.034631399671211e-01  7.973908945435876e-01  0.000000000000000e+00
            0.000000000000000e+00  9.996427499105769e-01  2.672774871214945e-02
            1.407440972493927e-01  9.895293105549196e-01  3.198191117114459e-02
            3.672904993168492e-01  9.293854165774537e-01  3.661197296967886e-02
            3.853921783197953e-02  9.984710958393895e-01  3.962574241812740e-02
            5.148461902513183e-01  8.541195910742996e-01  7.357393918212062e-02
            0.000000000000000e+00  9.969497696223284e-01  7.804586375962806e-02
            8.751447483197038e-02  9.916106577409262e-01  9.512896588049539e-02
            1.768159009079083e-01  9.781081549415998e-01  1.097295512743225e-01
            3.088094130320986e-01  9.426290854835798e-01  1.268351434861839e-01
            6.112146393988150e-01  7.772982882990435e-01  1.490772806028929e-01
            4.181225623477705e-01  8.898690036077466e-01  1.825011760890627e-01
            2.894824597568090e-02  9.846567927601602e-01  1.720842802995280e-01
            0.000000000000000e+00  9.851050266914518e-01  1.719537332750705e-01
            8.646476786190836e-02  9.737586138675750e-01  2.105184216102841e-01
            1.868846529428076e-01  9.525705963110874e-01  2.401736570442015e-01
            5.041168653658316e-01  8.226132073468435e-01  2.630089297956768e-01
            2.847011712055593e-01  9.128284377747754e-01  2.927276657643516e-01
            0.000000000000000e+00  9.531948970803874e-01  3.023565580236514e-01
            3.672367110793997e-01  8.588182501638906e-01  3.571672034510150e-01
            7.238100990325903e-02  9.266838494768173e-01  3.688062262546713e-01
            1.745439803780327e-01  8.882212302727237e-01  4.249675811242569e-01
            2.579243603918749e-01  8.301037385529974e-01  4.943711233039195e-01
            0.000000000000000e+00  8.826277960316239e-01  4.700725195885824e-01
            6.458932770145566e-02  8.406380876156574e-01  5.377321121124945e-01
            1.480931756161475e-01  7.806414498401374e-01  6.071798235509914e-01
            0.000000000000000e+00  7.826211519100633e-01  6.224982992611028e-01
            ];
        
        
    case 11
        pts=[
            2.817101872997206e-01  5.138554228686669e-01  8.103036312148797e-01
            4.950137292439001e-01  2.933049010355043e-01  8.178836365208683e-01
            0.000000000000000e+00  6.912311743656634e-01  7.226336994529565e-01
            3.799497341948213e-01  3.783879927758204e-01  8.440738868181922e-01
            6.403197394428403e-01  2.994663823943371e-02  7.675244817841381e-01
            5.575879243783840e-01  1.000100423144414e-01  8.240714156089078e-01
            3.285525648193265e-02  5.978161944335808e-01  8.009596305647728e-01
            1.281942635759274e-01  5.292422084072153e-01  8.387305381506504e-01
            4.498321750822436e-01  1.894497382818918e-01  8.727885258902642e-01
            2.224424261777200e-01  4.155153555320452e-01  8.819673215903454e-01
            3.317572820425836e-01  2.860725902662020e-01  8.989435905050457e-01
            5.644894705154758e-01  0.000000000000000e+00  8.254402689941640e-01
            0.000000000000000e+00  5.422665670239943e-01  8.402065045499302e-01
            4.945249537556987e-01  3.512536987331089e-02  8.684533830345686e-01
            7.333579488536755e-02  4.410482796597713e-01  8.944821273774493e-01
            3.967200207833676e-01  1.020522796711787e-01  9.122491750193912e-01
            1.628302073006617e-01  3.200301601613502e-01  9.333097128914517e-01
            2.721653718842602e-01  1.979576459615610e-01  9.416680841742804e-01
            0.000000000000000e+00  4.115382680091585e-01  9.113924807480156e-01
            4.115382680091585e-01  0.000000000000000e+00  9.113924807480156e-01
            3.320177606891829e-01  3.534936722926021e-02  9.426105393127276e-01
            5.253153786727162e-02  3.104783710350681e-01  9.491278199740590e-01
            1.373162808009401e-01  2.020392251876861e-01  9.697032486861931e-01
            2.283154640198296e-01  1.076912946972212e-01  9.676128533333186e-01
            0.000000000000000e+00  2.756250835507315e-01  9.612652148692640e-01
            2.756250835507315e-01  0.000000000000000e+00  9.612652148692640e-01
            3.909631910779802e-02  1.960232574475368e-01  9.798195550058582e-01
            1.948344059607901e-01  3.472061027624282e-02  9.802214206371697e-01
            1.082207437834810e-01  1.047746507540446e-01  9.885901795862218e-01
            0.000000000000000e+00  1.596595699339334e-01  9.871721337884855e-01
            1.596595699339334e-01  0.000000000000000e+00  9.871721337884855e-01
            3.298570340392802e-02  9.560254196234862e-02  9.948729051196868e-01
            9.781100588384210e-02  3.001951295381282e-02  9.947521480097476e-01
            0.000000000000000e+00  7.608888318011511e-02  9.971010389405894e-01
            7.608888318011509e-02  0.000000000000000e+00  9.971010389405894e-01
            2.812303305254635e-02  2.931073615272723e-02  9.991746472754954e-01
            0.000000000000000e+00  2.220493843524587e-02  9.997534399586164e-01
            2.220493843560242e-02  -3.567497688435274e-13  9.997534399586084e-01
            0.000000000000000e+00  0.000000000000000e+00  1.000000000000000e+00
            7.226336994529565e-01  6.912311743656634e-01  0.000000000000000e+00
            8.402065045499302e-01  5.422665670239943e-01  0.000000000000000e+00
            9.113924807480156e-01  4.115382680091585e-01  0.000000000000000e+00
            9.612652148692640e-01  2.756250835507315e-01  0.000000000000000e+00
            9.871721337884855e-01  1.596595699339334e-01  0.000000000000000e+00
            9.971010389405894e-01  7.608888318011511e-02  0.000000000000000e+00
            9.997534399586164e-01  2.220493843524587e-02  0.000000000000000e+00
            1.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
            9.997534399586084e-01  -3.567497688435274e-13  2.220493843560242e-02
            9.991746472754954e-01  2.931073615272723e-02  2.812303305254635e-02
            9.948729051196868e-01  9.560254196234862e-02  3.298570340392802e-02
            8.104136280357692e-01  5.848344213110597e-01  3.461865311735443e-02
            9.798195550058580e-01  1.960232574475368e-01  3.909631910779802e-02
            9.491278199740590e-01  3.104783710350681e-01  5.253153786727162e-02
            8.988292074259356e-01  4.317396207449808e-01  7.554439593407825e-02
            9.971010389405894e-01  0.000000000000000e+00  7.608888318011509e-02
            9.947521480097476e-01  3.001951295381282e-02  9.781100588384210e-02
            9.885901795862218e-01  1.047746507540446e-01  1.082207437834810e-01
            9.697032486861931e-01  2.020392251876861e-01  1.373162808009401e-01
            8.512248444945795e-01  5.048030690510205e-01  1.434925976900890e-01
            9.321005870531237e-01  3.204395696141831e-01  1.688400954770495e-01
            9.871721337884855e-01  0.000000000000000e+00  1.596595699339334e-01
            9.802214206371697e-01  3.472061027624282e-02  1.948344059607901e-01
            9.676128533333186e-01  1.076912946972212e-01  2.283154640198296e-01
            8.862525616479906e-01  3.962033315740719e-01  2.399569065936223e-01
            9.416680841742804e-01  1.979576459615610e-01  2.721653718842602e-01
            8.108273404976435e-01  5.138155806379577e-01  2.802723193524415e-01
            9.612652148692640e-01  0.000000000000000e+00  2.756250835507315e-01
            8.973201681912496e-01  2.761155252975522e-01  3.443497240406682e-01
            9.426105393127276e-01  3.534936722926021e-02  3.320177606891829e-01
            8.433820203446146e-01  3.886943952655834e-01  3.709763265338618e-01
            9.122491750193912e-01  1.020522796711787e-01  3.967200207833676e-01
            9.113924807480156e-01  0.000000000000000e+00  4.115382680091585e-01
            8.649999390995655e-01  1.802416706837719e-01  4.682820149299678e-01
            8.193189023025500e-01  2.934253438559881e-01  4.925627918476382e-01
            8.684533830345686e-01  3.512536987331089e-02  4.945249537556987e-01
            8.108694897189407e-01  9.285466606753501e-02  5.778137084151181e-01
            8.254402689941640e-01  0.000000000000000e+00  5.644894705154758e-01
            7.470535611216381e-01  1.958141501284730e-02  6.644753908171270e-01
            5.319714599377636e-01  8.008562548574082e-01  2.750193172623525e-01
            1.933166351420094e-01  7.768833972166972e-01  5.992335652368072e-01
            6.356365778545399e-01  7.532373712743012e-01  1.691141727033840e-01
            9.039431454982347e-02  7.030660265668341e-01  7.053559599128593e-01
            7.206915110512976e-01  6.878849722424875e-01  8.612787505534789e-02
            4.503639619188773e-01  7.671207297103501e-01  4.568348584044261e-01
            5.656312005288220e-01  7.299456988360055e-01  3.837194570765723e-01
            3.769113769909480e-01  7.288958006000751e-01  5.715319114120951e-01
            2.766449626755698e-01  6.864797588377316e-01  6.724679214150832e-01
            6.717657551465668e-01  6.792679204045774e-01  2.955094964998650e-01
            1.847764755035909e-01  6.302296233174904e-01  7.541009720147330e-01
            7.556686884950214e-01  6.255927958404019e-01  1.939032929601851e-01
            5.158045590993942e-01  6.780491693977300e-01  5.236363057421901e-01
            6.264226542305136e-01  6.369081525666382e-01  4.493803104954089e-01
            4.499166387895541e-01  6.314962462835032e-01  6.314962462835032e-01
            3.656276876926821e-01  5.820933384706134e-01  7.262807579033320e-01
            7.297331150867515e-01  5.733109749758283e-01  3.725642316675760e-01
            5.833842729366725e-01  5.743094941275784e-01  5.743094941275784e-01
            5.152909181081385e-01  5.169120864222122e-01  6.835767437719829e-01
            6.829134467526480e-01  5.165410072029220e-01  5.165410072029220e-01
            4.394834113028874e-01  4.654575587279061e-01  7.682470905982235e-01
            7.678583458984801e-01  4.529865122904047e-01  4.529865122904047e-01
            6.264226542305136e-01  4.493803104954089e-01  6.369081525666382e-01
            5.551454351663007e-01  3.859618000513822e-01  7.367815379847107e-01
            7.309847896474793e-01  3.821372151550667e-01  5.653604037227586e-01
            6.651622071083476e-01  3.026349131072453e-01  6.826209399097876e-01
            7.580593768923570e-01  2.148086598096934e-01  6.157947878768826e-01
            6.119108586644675e-01  2.022977575987939e-01  7.646180211837894e-01
            6.993459177965321e-01  1.206015688573357e-01  7.045356973571143e-01
            0.000000000000000e+00  1.000000000000000e+00  0.000000000000000e+00
            2.220493843560570e-02  9.997534399586084e-01  0.000000000000000e+00
            6.494052527240210e-02  9.978891362157143e-01  0.000000000000000e+00
            1.438878111581245e-01  9.895940065502236e-01  0.000000000000000e+00
            2.566163625117437e-01  9.665133431521995e-01  0.000000000000000e+00
            4.019775761730788e-01  9.156495116877509e-01  0.000000000000000e+00
            5.422665670239943e-01  8.402065045499302e-01  0.000000000000000e+00
            0.000000000000000e+00  9.997534399586084e-01  2.220493843560570e-02
            2.123728014806589e-01  9.768178917734897e-01  2.691838595554620e-02
            2.911228814130318e-02  9.991068744698147e-01  3.062561128101216e-02
            6.265513858594005e-01  7.786494824878410e-01  3.373935830868643e-02
            9.453137170574885e-02  9.949170014632313e-01  3.469841441395053e-02
            4.500877410045909e-01  8.918844846888490e-01  4.430678693711072e-02
            0.000000000000000e+00  9.978891362157143e-01  6.494052527240210e-02
            2.764972226967804e-01  9.572321141964751e-01  8.518195461430336e-02
            1.537192050596205e-01  9.842424786724834e-01  8.739078425374444e-02
            5.320296453429686e-01  8.401920293948680e-01  1.049848094610287e-01
            3.671990250992693e-02  9.943057457384623e-01  1.000386562841671e-01
            3.669813272739241e-01  9.192371489781060e-01  1.425754865707023e-01
            0.000000000000000e+00  9.895940065502236e-01  1.438878111581245e-01
            7.576700800151369e-02  9.833578563813378e-01  1.651262752913623e-01
            1.771432192774136e-01  9.681118529013413e-01  1.771432192774136e-01
            4.388214307870064e-01  8.730655816629256e-01  2.125846701848986e-01
            2.421197137173076e-01  9.395510036495613e-01  2.421197137173076e-01
            2.596793534426029e-02  9.699831202341894e-01  2.417817461983067e-01
            0.000000000000000e+00  9.665133431521995e-01  2.566163625117437e-01
            8.126372853614212e-02  9.565123280771836e-01  2.801434858438987e-01
            3.124274443518546e-01  8.970943005233828e-01  3.124274443518546e-01
            3.933217914630815e-01  8.399446306551988e-01  3.738863273693943e-01
            1.425754865707023e-01  9.192371489781060e-01  3.669813272739241e-01
            0.000000000000000e+00  9.156495116877509e-01  4.019775761730788e-01
            2.125846701848986e-01  8.730655816629256e-01  4.388214307870064e-01
            4.430678693711072e-02  8.918844846888490e-01  4.500877410045909e-01
            2.998949148382757e-01  8.121216126848705e-01  5.005212545579545e-01
            1.049848094610287e-01  8.401920293948679e-01  5.320296453429686e-01
            0.000000000000000e+00  8.402065045499302e-01  5.422665670239943e-01
            2.986121110008958e-02  7.807914196912328e-01  6.240777732047386e-01
            ];
        
        
    case 12
        pts=[
            3.696595748358784e-01  4.319836521915578e-01  8.226432537688502e-01
            6.438379898416862e-01  8.794383846293355e-02  7.600911288214210e-01
            8.260233661460122e-02  6.401333816497696e-01  7.638102563355893e-01
            5.586574223574138e-01  1.582515389627723e-01  8.141611234030304e-01
            1.609061354698234e-01  5.498671106892734e-01  8.196068424253162e-01
            4.528366644199457e-01  2.358934653223332e-01  8.598216259057683e-01
            2.439631841052100e-01  4.387658254252608e-01  8.648505739375659e-01
            6.102223747663431e-01  0.000000000000000e+00  7.922301769905793e-01
            3.419977224398455e-01  3.290039776549030e-01  8.802238013898570e-01
            0.000000000000000e+00  5.933249897806263e-01  8.049630156111645e-01
            5.294990658472520e-01  5.380653439112572e-02  8.466023837219595e-01
            3.894027945963548e-02  5.189892622296942e-01  8.538933190544842e-01
            1.161320455720428e-01  4.554104540522703e-01  8.826747228346113e-01
            4.271441167594722e-01  1.462627144603820e-01  8.922752500638194e-01
            2.028765639143838e-01  3.433038409650724e-01  9.170515648495025e-01
            3.040110093959780e-01  2.362201708319016e-01  9.229178387365724e-01
            4.889997613041632e-01  0.000000000000000e+00  8.722839179100298e-01
            0.000000000000000e+00  4.810012480610886e-01  8.767199093003849e-01
            3.652169734144918e-01  8.055397425505539e-02  9.274306548533288e-01
            7.389759072067861e-02  3.604372623518681e-01  9.298516688128111e-01
            2.553583811581656e-01  1.603205788117825e-01  9.534618026862619e-01
            1.567804500838190e-01  2.573836313751772e-01  9.535059290699991e-01
            3.603278794231751e-01  0.000000000000000e+00  9.328257175434208e-01
            0.000000000000000e+00  3.513493617061902e-01  9.362444264339589e-01
            3.171652479618751e-01  2.322120234688193e-02  9.480859566763170e-01
            2.293902975979318e-02  2.912072067568807e-01  9.563849453261666e-01
            2.361091274828059e-01  6.876311007613754e-02  9.692905212638597e-01
            7.711345979072867e-02  2.259030740167376e-01  9.710928459570135e-01
            1.525147872738589e-01  1.424261692174940e-01  9.779846757413121e-01
            0.000000000000000e+00  2.364975722416914e-01  9.716320797111352e-01
            2.364975722416914e-01  0.000000000000000e+00  9.716320797111353e-01
            1.749337874678106e-01  2.585865322331227e-02  9.842405702142355e-01
            3.129511442161140e-02  1.663592250134810e-01  9.855684776139364e-01
            9.978155530478632e-02  8.270557993371500e-02  9.915661492148599e-01
            0.000000000000000e+00  1.355336240377551e-01  9.907727472812282e-01
            1.355336240377551e-01  0.000000000000000e+00  9.907727472812282e-01
            2.834586992585048e-02  8.071805035693598e-02  9.963338336143774e-01
            8.316603973861292e-02  2.522153441195960e-02  9.962164845233701e-01
            0.000000000000000e+00  6.430645593492708e-02  9.979301978220166e-01
            6.430645593471063e-02  2.173305891361948e-13  9.979301978220306e-01
            2.385229883877682e-02  2.469847170310473e-02  9.994103528259234e-01
            0.000000000000000e+00  1.873918858270435e-02  9.998244059890026e-01
            1.873918858256188e-02  1.425385476445779e-13  9.998244059890052e-01
            0.000000000000000e+00  0.000000000000000e+00  1.000000000000000e+00
            8.049630156111645e-01  5.933249897806263e-01  0.000000000000000e+00
            8.811190153752526e-01  4.728945767759928e-01  0.000000000000000e+00
            9.362444264339589e-01  3.513493617061902e-01  0.000000000000000e+00
            9.716320797111352e-01  2.364975722416914e-01  0.000000000000000e+00
            9.907727472812282e-01  1.355336240377551e-01  0.000000000000000e+00
            9.979301978220166e-01  6.430645593492708e-02  0.000000000000000e+00
            9.998244059890026e-01  1.873918858270435e-02  0.000000000000000e+00
            1.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
            9.998244059890052e-01  1.425385476445779e-13  1.873918858256188e-02
            9.563849453261666e-01  2.912072067568807e-01  2.293902975979318e-02
            9.994103528259233e-01  2.469847170310472e-02  2.385229883877682e-02
            7.365602181310476e-01  6.758375242910338e-01  2.688281657322736e-02
            9.963338336143774e-01  8.071805035693598e-02  2.834586992585048e-02
            9.855684776139364e-01  1.663592250134810e-01  3.129511442161140e-02
            8.538933190544842e-01  5.189892622296942e-01  3.894027945963548e-02
            9.979301978220306e-01  2.173305891361948e-13  6.430645593471063e-02
            9.303068493943139e-01  3.600192242354577e-01  7.010937277514914e-02
            9.710928459570136e-01  2.259030740167376e-01  7.711345979072867e-02
            9.962164845233700e-01  2.522153441195959e-02  8.316603973861290e-02
            9.915661492148599e-01  8.270557993371500e-02  9.978155530478632e-02
            8.857719824988293e-01  4.474080827150255e-01  1.234261015399848e-01
            9.907727472812282e-01  0.000000000000000e+00  1.355336240377551e-01
            9.779846757413121e-01  1.424261692174940e-01  1.525147872738589e-01
            9.535059290699991e-01  2.573836313751772e-01  1.567804500838190e-01
            8.135463222677001e-01  5.576386737002724e-01  1.648681021862645e-01
            9.842405702142355e-01  2.585865322331227e-02  1.749337874678106e-01
            9.181049595808650e-01  3.344434516032708e-01  2.126754825378540e-01
            8.648505739375658e-01  4.387658254252607e-01  2.439631841052100e-01
            9.692905212638598e-01  6.876311007613756e-02  2.361091274828060e-01
            9.716320797111353e-01  0.000000000000000e+00  2.364975722416914e-01
            9.534618026862619e-01  1.603205788117825e-01  2.553583811581656e-01
            9.213509031846967e-01  2.275877924288568e-01  3.151449030812700e-01
            8.822834879363980e-01  3.289595359854835e-01  3.366919520852841e-01
            9.480859566763171e-01  2.322120234688194e-02  3.171652479618752e-01
            9.274306548533287e-01  8.055397425505538e-02  3.652169734144918e-01
            8.272655888333235e-01  4.134918316608014e-01  3.803368910348430e-01
            9.328257175434208e-01  0.000000000000000e+00  3.603278794231751e-01
            8.881745324355153e-01  1.388128234165036e-01  4.380376695994221e-01
            8.625390096684254e-01  2.360146354862701e-01  4.475751876908446e-01
            8.722839179100298e-01  0.000000000000000e+00  4.889997613041632e-01
            8.443246150834378e-01  4.486375562191322e-02  5.339505480807204e-01
            8.108557589132241e-01  1.657810411442219e-01  5.612749634843844e-01
            7.922301769905793e-01  0.000000000000000e+00  6.102223747663431e-01
            7.600911288214210e-01  8.794383846293355e-02  6.438379898416862e-01
            3.458726289235230e-01  8.106959305306169e-01  4.723814483895699e-01
            1.161427199636293e-02  7.056528192577014e-01  7.084625659550773e-01
            5.636259135021693e-01  7.803399561044424e-01  2.709158218631061e-01
            2.511668687748783e-01  7.738474452151531e-01  5.814424610946501e-01
            6.623219956173262e-01  7.267706814608068e-01  1.820273350089948e-01
            1.643706036491771e-01  7.060269743305949e-01  6.888455677244288e-01
            4.453003482058034e-01  7.519696715605076e-01  4.860547427409515e-01
            7.421503358332059e-01  6.619997657287203e-01  1.047338970810257e-01
            5.600203016667732e-01  7.286633063817746e-01  3.942423717129306e-01
            3.657625865700224e-01  7.121925393671035e-01  5.991656842105060e-01
            2.731892062367277e-01  6.754248780322699e-01  6.849590438346222e-01
            6.626518676625150e-01  6.772958963757870e-01  3.196291148126211e-01
            5.139340185633539e-01  6.757823305121209e-01  5.283843925883208e-01
            2.150033104957590e-01  6.233840737990716e-01  7.517751479062992e-01
            7.391138164233125e-01  6.279781915315074e-01  2.436270866159660e-01
            6.253450878176050e-01  6.341294117059326e-01  4.547784189601348e-01
            4.533841556724102e-01  6.328871339966645e-01  6.276118888347350e-01
            3.762332220312697e-01  5.899067723398047e-01  7.144638287468464e-01
            7.171041297967974e-01  5.784364600636327e-01  3.888096304072618e-01
            2.891864714093345e-01  5.474408759991223e-01  7.852895466254036e-01
            5.857976788026358e-01  5.764776947043523e-01  5.696617830061971e-01
            5.143529852878440e-01  5.345679386139394e-01  6.705804392699853e-01
            8.027693284930794e-01  5.003669277305062e-01  3.243367738390218e-01
            6.777305793452014e-01  5.238707493951510e-01  5.159851739619853e-01
            4.453003482058034e-01  4.860547427409515e-01  7.519696715605076e-01
            7.595170155111567e-01  4.643614437438712e-01  4.555242613880548e-01
            6.261003052919198e-01  4.623302872726315e-01  6.278925968537697e-01
            5.609945433076893e-01  4.002089304022330e-01  7.246502152109648e-01
            7.181573468168401e-01  3.974643532327496e-01  5.712023399131599e-01
            8.127677610764440e-01  3.461387739420731e-01  4.686112629127290e-01
            4.781972105912702e-01  3.431379428160762e-01  8.084452857074990e-01
            6.641784919396315e-01  3.269191048930763e-01  6.723026325254918e-01
            7.595249789657587e-01  2.732997921899111e-01  5.902787730522040e-01
            5.907892549936253e-01  2.675694225699362e-01  7.611666442308598e-01
            6.966454372441216e-01  2.084097708008434e-01  6.864768766693359e-01
            7.058582987107391e-01  2.120383737158267e-02  7.080356342882047e-01
            0.000000000000000e+00  1.000000000000000e+00  0.000000000000000e+00
            1.616107878851718e-02  9.998694012381774e-01  0.000000000000000e+00
            5.486305668965027e-02  9.984938883191365e-01  0.000000000000000e+00
            1.154948511046324e-01  9.933080787793477e-01  0.000000000000000e+00
            2.033232626263986e-01  9.791116641501910e-01  0.000000000000000e+00
            3.243872527057796e-01  9.459243681616394e-01  0.000000000000000e+00
            4.646848968694949e-01  8.854761129592299e-01  0.000000000000000e+00
            5.873830381418712e-01  8.093090673551269e-01  0.000000000000000e+00
            6.973008043805760e-01  7.167786186893423e-01  0.000000000000000e+00
            0.000000000000000e+00  9.998694012381774e-01  1.616107878851718e-02
            1.817732592766753e-01  9.830858703963737e-01  2.237529081238229e-02
            3.826461375213105e-01  9.235231025302448e-01  2.621092392368266e-02
            2.434292994676062e-02  9.993628119270892e-01  2.610348441853115e-02
            7.867547890415794e-02  9.964268489231197e-01  3.071976178852782e-02
            0.000000000000000e+00  9.984938883191365e-01  5.486305668965027e-02
            4.831847516019954e-01  8.728150393779490e-01  6.874883893555707e-02
            2.327518551623705e-01  9.700444724936619e-01  6.957223083219560e-02
            1.365807768042183e-01  9.882480833746675e-01  6.863976335807415e-02
            6.316405070408155e-01  7.719024045724848e-01  7.208985837437307e-02
            3.131426293273336e-02  9.959325161898972e-01  8.448573922645077e-02
            3.323438912428958e-01  9.384664745475335e-01  9.395857653164938e-02
            0.000000000000000e+00  9.933080787793477e-01  1.154948511046324e-01
            7.091248964354141e-02  9.883949479751418e-01  1.343385485620981e-01
            5.342174349326529e-01  8.332120130951008e-01  1.427216642559442e-01
            1.504073654234244e-01  9.765641014640509e-01  1.539486283085868e-01
            3.916738939239749e-01  9.043696985803752e-01  1.694314289264893e-01
            2.332159311146216e-01  9.538664172400124e-01  1.890745554960865e-01
            2.260821349194376e-02  9.799231152883863e-01  1.980897695647270e-01
            0.000000000000000e+00  9.791116641501910e-01  2.033232626263986e-01
            4.401643021662825e-01  8.641416030188539e-01  2.439563014772831e-01
            7.172907889653750e-02  9.681273290303366e-01  2.399675270223887e-01
            2.780092617307008e-01  9.213775294053065e-01  2.716142461266055e-01
            1.343597279960170e-01  9.459032754780082e-01  2.953209388661959e-01
            3.342766044659543e-01  8.781768619484553e-01  3.421469725791472e-01
            0.000000000000000e+00  9.459243681616394e-01  3.243872527057796e-01
            4.480425416983361e-01  8.168930799857418e-01  3.632403841809213e-01
            1.848608972600746e-01  9.035653353466477e-01  3.865179600278624e-01
            3.371841941512458e-02  9.259240938616798e-01  3.762015956884989e-01
            2.427444235732128e-01  8.541676768156135e-01  4.598616364815904e-01
            8.120151270385764e-02  8.812752671338434e-01  4.655751473959689e-01
            0.000000000000000e+00  8.854761129592299e-01  4.646848968694949e-01
            1.427216642559442e-01  8.332120130951008e-01  5.342174349326529e-01
            2.401373207627956e-02  8.467121803996436e-01  5.315090067295662e-01
            0.000000000000000e+00  8.093090673551269e-01  5.873830381418712e-01
            6.631774952026342e-02  7.752441408367785e-01  6.281707396853284e-01
            ];
        
        
    case 13
        pts=[
            2.105117602309970e-02  6.944012522069650e-01  7.192800212166630e-01
            5.689507864968713e-01  1.922077779128387e-01  7.995943800793003e-01
            2.061192169099712e-01  5.471403355205653e-01  8.112658760646003e-01
            6.605751398593016e-01  -1.449141307903523e-13  7.507599380626702e-01
            4.634962624334717e-01  2.604298641033257e-01  8.469636949676921e-01
            2.742525025985579e-01  4.418306170616726e-01  8.541494428057246e-01
            0.000000000000000e+00  6.291874246735216e-01  7.772536166739281e-01
            3.628517605049079e-01  3.394971253064159e-01  8.678019945858437e-01
            6.123740246551792e-01  2.465641931360944e-02  7.901835957005495e-01
            7.716274488223943e-02  5.403880367744298e-01  8.378703244018826e-01
            5.389117525647064e-01  7.784574230551929e-02  8.387575116519311e-01
            4.613594432633955e-01  1.662956459062291e-01  8.714890832731754e-01
            1.669393722466048e-01  4.520019267395807e-01  8.762565287731763e-01
            2.491095783847200e-01  3.458941112679604e-01  9.046002883855028e-01
            5.474749729306615e-01  0.000000000000000e+00  8.368220563623855e-01
            3.449103058932108e-01  2.450473262094353e-01  9.060842614273015e-01
            0.000000000000000e+00  5.344157564005098e-01  8.452217456448166e-01
            4.625985473782128e-01  3.520583874841167e-02  8.858685754002048e-01
            9.784267603306887e-02  4.035587149142481e-01  9.097071915531110e-01
            3.811926938082668e-01  1.194460195064975e-01  9.167468454329419e-01
            2.812869429429613e-02  4.515871987999017e-01  8.917834818145915e-01
            1.771202080125125e-01  2.987787549096477e-01  9.377418021653108e-01
            2.710561399344961e-01  1.958186202327468e-01  9.424349510570765e-01
            4.313402946917137e-01  0.000000000000000e+00  9.021893094995448e-01
            0.000000000000000e+00  4.233579234437364e-01  9.059625095209003e-01
            3.182667691698383e-01  6.884167799573562e-02  9.454983273453869e-01
            6.291168000413858e-02  3.150752140727350e-01  9.469792658744314e-01
            1.326232453347515e-01  2.216424282564061e-01  9.660671347238152e-01
            2.152766295027722e-01  1.369549699564361e-01  9.669019128092352e-01
            0.000000000000000e+00  3.080581496950097e-01  9.513675296153884e-01
            3.080581496950097e-01  0.000000000000000e+00  9.513675296153885e-01
            2.779462729641791e-01  1.978536045691954e-02  9.603928409025714e-01
            1.917892285111410e-02  2.449723676074406e-01  9.693403468478323e-01
            2.068206108669341e-01  5.856777448618342e-02  9.766243140083928e-01
            6.536041061756404e-02  1.944312443402907e-01  9.787361789308647e-01
            1.290189159109563e-01  1.215813025241447e-01  9.841606099685629e-01
            0.000000000000000e+00  2.045992848111217e-01  9.788458165895063e-01
            2.045992848111217e-01  0.000000000000000e+00  9.788458165895063e-01
            1.512203879999285e-01  2.199236022469631e-02  9.882553973264696e-01
            2.497241080964666e-02  1.427636504909168e-01  9.894417207682631e-01
            8.182901177891848e-02  7.044411890541859e-02  9.941537300352119e-01
            0.000000000000000e+00  1.163790571503599e-01  9.932048706368658e-01
            1.163790571503598e-01  0.000000000000000e+00  9.932048706368658e-01
            7.152243305877433e-02  2.148885160151613e-02  9.972074863468491e-01
            2.192999194669442e-02  6.896495127059496e-02  9.973780180801372e-01
            0.000000000000000e+00  5.504978955274840e-02  9.984836106167182e-01
            5.504978955246036e-02  2.888729417922805e-13  9.984836106167340e-01
            2.047678460678443e-02  2.109576257517623e-02  9.995677416231175e-01
            0.000000000000000e+00  1.602529825516001e-02  9.998715866629241e-01
            1.602529825544459e-02  -2.846143619585324e-13  9.998715866629194e-01
            0.000000000000000e+00  0.000000000000000e+00  1.000000000000000e+00
            7.633876480537690e-01  6.459406310172282e-01  0.000000000000000e+00
            8.452217456448166e-01  5.344157564005098e-01  0.000000000000000e+00
            9.059625095209003e-01  4.233579234437364e-01  0.000000000000000e+00
            9.513675296153884e-01  3.080581496950097e-01  0.000000000000000e+00
            9.788458165895063e-01  2.045992848111217e-01  0.000000000000000e+00
            9.932048706368658e-01  1.163790571503599e-01  0.000000000000000e+00
            9.984836106167182e-01  5.504978955274840e-02  0.000000000000000e+00
            9.998715866629241e-01  1.602529825516001e-02  0.000000000000000e+00
            1.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
            9.998715866629194e-01  -2.846143619585324e-13  1.602529825544459e-02
            9.672981756194184e-01  2.529357621055554e-01  1.891400780973808e-02
            7.634565528870590e-01  6.455957441289454e-01  1.844524373388924e-02
            9.995677416231175e-01  2.109576257517623e-02  2.047678460678443e-02
            9.894417207682631e-01  1.427636504909168e-01  2.497241080964666e-02
            9.973114002571116e-01  6.903553714874681e-02  2.457774456257672e-02
            8.874097029075556e-01  4.599152677872823e-01  3.133633101810467e-02
            8.113050529748537e-01  5.819814240695440e-01  5.551335925212417e-02
            9.984836106167340e-01  2.888729417922805e-13  5.504978955246036e-02
            9.775758566737416e-01  2.016428489390584e-01  6.070919139916407e-02
            9.466184860135634e-01  3.154328950515893e-01  6.644945941663016e-02
            9.972074863468491e-01  2.148885160151613e-02  7.152243305877433e-02
            9.937264525632996e-01  7.055518962717379e-02  8.677385950062347e-02
            9.124505447520114e-01  3.957759620298936e-01  1.039008722825258e-01
            9.932048706368658e-01  0.000000000000000e+00  1.163790571503598e-01
            8.538845027611540e-01  5.038064634119361e-01  1.306150962511385e-01
            9.835005037853733e-01  1.278573733896869e-01  1.279814483579832e-01
            9.660671347238152e-01  2.216424282564061e-01  1.326232453347515e-01
            9.882553973264696e-01  2.199236022469631e-02  1.512203879999285e-01
            9.398181135854736e-01  2.904065451079396e-01  1.800165323938671e-01
            9.780449083821825e-01  6.302268622252431e-02  1.986360949298633e-01
            8.935524298870288e-01  3.961587447008711e-01  2.112399205643117e-01
            9.788458165895063e-01  0.000000000000000e+00  2.045992848111217e-01
            8.202534067102132e-01  5.266398384226183e-01  2.232371594660892e-01
            9.653225957313687e-01  1.371193660158836e-01  2.221498720095391e-01
            9.648692059725270e-01  1.974610455762354e-02  2.619876079526373e-01
            9.404478419998732e-01  1.959658792348454e-01  2.777683039036236e-01
            8.598530987538550e-01  4.169925718133216e-01  2.945672140885761e-01
            9.104376428485917e-01  2.866178956356377e-01  2.982507005619582e-01
            9.513675296153885e-01  0.000000000000000e+00  3.080581496950097e-01
            9.454983273453869e-01  6.884167799573562e-02  3.182667691698383e-01
            8.650870794828973e-01  3.219345935926591e-01  3.846848870960238e-01
            9.133098476233302e-01  1.132104873691211e-01  3.912141456848097e-01
            8.170523450520968e-01  4.082817116689715e-01  4.071013502329908e-01
            8.888569485523568e-01  2.046478199651148e-01  4.099421846964753e-01
            9.021893094995448e-01  0.000000000000000e+00  4.313402946917137e-01
            8.820274060466577e-01  3.517892108001371e-02  4.698830689589173e-01
            8.241009831950168e-01  2.420742637561295e-01  5.121109453272159e-01
            8.504116642031653e-01  1.309372402425041e-01  5.095639709642741e-01
            8.326339483909849e-01  0.000000000000000e+00  5.538237156233368e-01
            8.119544948084720e-01  5.803019919854745e-02  5.808290577625190e-01
            7.755763654541641e-01  1.470575346225184e-01  6.138854802482754e-01
            7.675974504652510e-01  1.022522032899428e-02  6.408506837855992e-01
            3.918819754467508e-01  8.101752634143095e-01  4.359410050356659e-01
            4.903557496986575e-01  7.930146198930744e-01  3.614955758696227e-01
            7.114896544247122e-01  7.001261974936087e-01  6.004814093495272e-02
            3.225193082047047e-01  7.765484562426896e-01  5.412520586032482e-01
            6.975136672599117e-02  6.978985611428121e-01  7.127919368193281e-01
            5.871795630620286e-01  7.544971150837171e-01  2.931795764589225e-01
            2.088968314187021e-01  7.091661765660106e-01  6.733835815031225e-01
            4.671519768716452e-01  7.466077345476501e-01  4.736516876551161e-01
            6.785911581897682e-01  7.017869382090467e-01  2.168158974472131e-01
            5.740482775527130e-01  7.109280270975666e-01  4.062633571046309e-01
            4.046908428827736e-01  7.076053203498408e-01  5.792409104158903e-01
            1.331255215770882e-01  6.390617546340265e-01  7.575471399648390e-01
            7.599490509337810e-01  6.348496192389115e-01  1.394395960158190e-01
            3.173370844498620e-01  6.840595840472024e-01  6.567797654511212e-01
            6.676900819077324e-01  6.647657744586257e-01  3.350767369282285e-01
            5.216854240790911e-01  6.709632761220075e-01  5.269275096244659e-01
            2.692458972652292e-01  6.168474474154669e-01  7.395984541782550e-01
            7.439014007078844e-01  6.061778244036014e-01  2.813523613303511e-01
            6.250785814222716e-01  6.259480997805348e-01  4.663322243082269e-01
            4.662416517075754e-01  6.255472492997599e-01  6.255472492997599e-01
            3.852577830929305e-01  5.971692310895924e-01  7.035377388642243e-01
            7.118618418661384e-01  5.730138885286485e-01  4.060884160478189e-01
            5.703396607553263e-01  5.808238422144444e-01  5.808238422144444e-01
            3.401830304899185e-01  5.150401545060069e-01  7.867713422673220e-01
            5.216854240790911e-01  5.269275096244660e-01  6.709632761220075e-01
            6.663308250960245e-01  5.272585852913404e-01  5.272585852913404e-01
            7.909645519401395e-01  5.020156690795712e-01  3.497932897765834e-01
            4.488882796045394e-01  4.917349148477555e-01  7.461206912781253e-01
            7.473940542474614e-01  4.697883181154799e-01  4.697883181154799e-01
            6.172861366014750e-01  4.718841880791174e-01  6.295102370895466e-01
            4.091868516500221e-01  4.148912853203030e-01  8.126692696306473e-01
            5.485199018351381e-01  4.212304148887829e-01  7.222817004904626e-01
            7.062807857816810e-01  4.108782578142230e-01  5.764950206993641e-01
            7.885582448336814e-01  3.522911514278527e-01  5.040504331219859e-01
            6.489983068815609e-01  3.533138496293861e-01  6.737733456622715e-01
            5.065996167706952e-01  3.445355131876095e-01  7.903493584740455e-01
            7.307205511709710e-01  2.865060766811774e-01  6.196464670448396e-01
            6.228211265138776e-01  2.706245843750031e-01  7.340682384491521e-01
            6.953696261998985e-01  1.947882407183588e-01  6.917504060255116e-01
            6.486225578068747e-01  1.116046560209928e-01  7.528832434438313e-01
            7.115214492913682e-01  5.394717266021969e-02  7.005904151216169e-01
            0.000000000000000e+00  1.000000000000000e+00  0.000000000000000e+00
            1.602529825544648e-02  9.998715866629194e-01  0.000000000000000e+00
            4.695297905971817e-02  9.988971006852596e-01  0.000000000000000e+00
            9.906913734891605e-02  9.950805525307695e-01  0.000000000000000e+00
            1.753936555435715e-01  9.844983827285156e-01  0.000000000000000e+00
            2.833831964710502e-01  9.590067590782924e-01  0.000000000000000e+00
            4.072243995272669e-01  9.133281384199531e-01  0.000000000000000e+00
            5.344157564005098e-01  8.452217456448166e-01  0.000000000000000e+00
            6.335757476956436e-01  7.736806653470837e-01  0.000000000000000e+00
            0.000000000000000e+00  9.999044984977700e-01  1.382005368741569e-02
            1.712584828175401e-01  9.850398514660714e-01  1.915784661005198e-02
            3.484637870554690e-01  9.371029238705514e-01  2.027558098363877e-02
            2.158037160933308e-02  9.995341790666321e-01  2.158037160933308e-02
            7.001193961606435e-02  9.972639527005752e-01  2.372629248789648e-02
            5.741076801829391e-01  8.174080659430957e-01  4.737536581528169e-02
            0.000000000000000e+00  9.988971006852596e-01  4.695297905971817e-02
            1.181041078333974e-01  9.912767041033114e-01  5.849714193833148e-02
            4.346717219817938e-01  8.983280041780682e-01  6.377531668937950e-02
            3.156923581829683e-01  9.465266713262398e-01  6.652514902609893e-02
            2.047082736824536e-01  9.765951454607673e-01  6.600336770508351e-02
            2.731980778647889e-02  9.974168196408125e-01  6.643279310789714e-02
            0.000000000000000e+00  9.950805525307695e-01  9.906913734891605e-02
            6.455825418119319e-01  7.560969935302182e-01  1.074268033695988e-01
            4.951020667734875e-01  8.600630914861187e-01  1.231479684767933e-01
            5.849714193833148e-02  9.912767041033114e-01  1.181041078333974e-01
            1.248194325752989e-01  9.835851395939326e-01  1.303087964090095e-01
            2.222796491168806e-01  9.651906947764167e-01  1.378357004026693e-01
            3.343602569264717e-01  9.302657499803986e-01  1.510260010775312e-01
            1.809255490256972e-02  9.884108358681762e-01  1.507205327600411e-01
            5.682335639493641e-01  8.022115762694559e-01  1.832135467171541e-01
            0.000000000000000e+00  9.844983827285156e-01  1.753936555435715e-01
            4.030402055987416e-01  8.910147562542653e-01  2.089289276478402e-01
            6.102347486130978e-02  9.759033716920673e-01  2.094964072147918e-01
            1.340349543188377e-01  9.648710754651115e-01  2.259611443402297e-01
            2.260809043100460e-01  9.450821603679506e-01  2.360235896273912e-01
            4.716843922183149e-01  8.401884121675857e-01  2.675766548055902e-01
            2.927720205740316e-01  9.102577041354813e-01  2.927720205740316e-01
            0.000000000000000e+00  9.590067590782924e-01  2.833831964710502e-01
            1.959280729812896e-02  9.515119466143307e-01  3.069871941179066e-01
            6.338652439544076e-02  9.457899205461604e-01  3.185334750357548e-01
            3.512741392194885e-01  8.678784236465467e-01  3.512741392194885e-01
            1.411823445818774e-01  9.285507180377404e-01  3.433090584443713e-01
            2.089289276478402e-01  8.910147562542653e-01  4.030402055987416e-01
            0.000000000000000e+00  9.133281384199531e-01  4.072243995272669e-01
            2.700444165338435e-01  8.484235681583381e-01  4.552509880191034e-01
            4.052765315592707e-02  8.903406980157635e-01  4.534875420410970e-01
            1.163592300592816e-01  8.616841531049002e-01  4.939240324866792e-01
            1.871605992558654e-01  8.123801125478524e-01  5.522766180302441e-01
            0.000000000000000e+00  8.452217456448166e-01  5.344157564005098e-01
            4.779301738695434e-02  8.138053924654084e-01  5.791688965088447e-01
            1.191024159051108e-01  7.636761760614119e-01  6.345181736103271e-01
            0.000000000000000e+00  7.601080266042365e-01  6.497967281325856e-01
            ];
        
        
    case 14
        pts=[
            0.000000000000000e+00  7.053029297109332e-01  7.089060426750322e-01
            5.584789057258522e-01  2.316109083310142e-01  7.965285299355807e-01
            7.030424710848293e-01  -2.124622025524233e-14  7.111478635635046e-01
            2.179820205013205e-01  5.616680338789686e-01  7.981308529662887e-01
            6.431360052561832e-01  6.530067128251109e-02  7.629625816992418e-01
            2.858761174626893e-01  4.743819415123077e-01  8.326083227013000e-01
            4.545301233838642e-01  3.063602865626775e-01  8.363885112517289e-01
            3.643154994228884e-02  6.390523043979435e-01  7.683000028715871e-01
            3.482959119685186e-01  3.809452001993705e-01  8.564874267326285e-01
            5.606432414903800e-01  1.239638292517831e-01  8.187259155592879e-01
            1.108807076166047e-01  5.578908198785495e-01  8.224738912413456e-01
            4.662474992905496e-01  1.987636258058126e-01  8.620361306011690e-01
            1.883183771046326e-01  4.692586423269144e-01  8.627470750145598e-01
            6.056631714237478e-01  0.000000000000000e+00  7.957211338031233e-01
            0.000000000000000e+00  5.857288497064601e-01  8.105070725302446e-01
            2.642125652806841e-01  3.711077434359485e-01  8.902082695131958e-01
            3.579005714641600e-01  2.758681895205196e-01  8.920784287024872e-01
            5.521007598814033e-01  3.629475339956043e-02  8.329870598118810e-01
            4.838684884727231e-01  9.228557918039620e-02  8.702612583233044e-01
            4.788305335579179e-02  5.169351368933867e-01  8.546843144964940e-01
            1.151110162559986e-01  4.320182704190196e-01  8.944884951527716e-01
            3.890327166825024e-01  1.582170579963103e-01  9.075356234934384e-01
            4.955373837157068e-01  0.000000000000000e+00  8.685866113060875e-01
            1.912091048295977e-01  3.349965225967783e-01  9.226138997859993e-01
            2.838818212235404e-01  2.359177663356075e-01  9.293836232181109e-01
            0.000000000000000e+00  4.818726401251159e-01  8.762412674023350e-01
            1.659797126373410e-02  4.490459881982433e-01  8.933544693082311e-01
            3.807142701018166e-01  7.309920598098295e-02  9.217988666871917e-01
            4.239768434992763e-01  1.956833019020558e-02  9.054616041721246e-01
            5.048019131426001e-02  3.934570822862736e-01  9.179560309097861e-01
            1.159683403044639e-01  3.055753139811868e-01  9.450793995915513e-01
            2.789603495101030e-01  1.381378688431136e-01  9.503152385354473e-01
            1.900530563911995e-01  2.177689122145503e-01  9.573173646337221e-01
            3.788514676856939e-01  0.000000000000000e+00  9.254574898029598e-01
            0.000000000000000e+00  3.711701543502069e-01  9.285648693115864e-01
            2.768347217404328e-01  5.937295669317003e-02  9.590815339961500e-01
            5.631691952644152e-02  2.692974375660550e-01  9.614090152975523e-01
            1.928138901224194e-01  1.183854791469229e-01  9.740675962698959e-01
            1.157510958601833e-01  1.925873528965254e-01  9.744289585759836e-01
            2.713019933362708e-01  0.000000000000000e+00  9.624942744825894e-01
            0.000000000000000e+00  2.637856385455619e-01  9.645813272591950e-01
            2.303255851047325e-01  1.699883600397699e-02  9.729651403933609e-01
            1.746133783348219e-02  2.141931451408171e-01  9.766352431976587e-01
            1.757102657507676e-01  5.037191174982687e-02  9.831523651074955e-01
            5.520781641441390e-02  1.688162239363960e-01  9.841001877566170e-01
            1.144142087716581e-01  1.050494444565544e-01  9.878633524179975e-01
            1.784309642366067e-01  0.000000000000000e+00  9.839524333023395e-01
            0.000000000000000e+00  1.718378657077111e-01  9.851252447831285e-01
            2.215002569393306e-02  1.238640101806760e-01  9.920519559699076e-01
            1.260946758869632e-01  1.889841691831800e-02  9.918381836524258e-01
            7.168077380099803e-02  6.079585958473611e-02  9.955730661908463e-01
            0.000000000000000e+00  1.009536140234372e-01  9.948911336501129e-01
            1.009536140234371e-01  0.000000000000000e+00  9.948911336501129e-01
            6.212935473259214e-02  1.852848504085792e-02  9.978961060764806e-01
            1.917217148272430e-02  5.965213962569567e-02  9.980350946127663e-01
            0.000000000000000e+00  4.764947249439729e-02  9.988641187724212e-01
            4.764947249446917e-02  -7.196841115468740e-14  9.988641187724179e-01
            1.776494147396732e-02  1.822807728339526e-02  9.996760195448208e-01
            0.000000000000000e+00  1.386066873014992e-02  9.999039363170609e-01
            1.386066873029207e-02  -1.421060368946348e-13  9.999039363170589e-01
            0.000000000000000e+00  0.000000000000000e+00  1.000000000000000e+00
            8.142880125662967e-01  5.804610517432075e-01  0.000000000000000e+00
            8.800299681466862e-01  4.749181562793136e-01  0.000000000000000e+00
            9.285648693115864e-01  3.711701543502069e-01  0.000000000000000e+00
            9.645813272591950e-01  2.637856385455619e-01  0.000000000000000e+00
            9.851252447831285e-01  1.718378657077111e-01  0.000000000000000e+00
            9.948911336501129e-01  1.009536140234372e-01  0.000000000000000e+00
            9.988641187724212e-01  4.764947249439729e-02  0.000000000000000e+00
            9.999039363170609e-01  1.386066873014992e-02  0.000000000000000e+00
            1.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
            9.999039363170589e-01  -1.421060368946348e-13  1.386066873029207e-02
            9.393712454057984e-01  3.424865710440027e-01  1.687044632725267e-02
            9.766352431976587e-01  2.141931451408171e-01  1.746133783348219e-02
            9.996760195448208e-01  1.822807728339526e-02  1.776494147396732e-02
            9.980350946127663e-01  5.965213962569567e-02  1.917217148272430e-02
            9.920519559699076e-01  1.238640101806760e-01  2.215002569393306e-02
            7.702905857020017e-01  6.371615517399440e-01  2.603018561619918e-02
            8.552717157036751e-01  5.163143370657924e-01  4.392946229586186e-02
            9.185101394931066e-01  3.927923643181493e-01  4.531315682792617e-02
            9.988641187724179e-01  -7.196841115468740e-14  4.764947249446917e-02
            9.841001877566170e-01  1.688162239363960e-01  5.520781641441390e-02
            9.614090152975523e-01  2.692974375660550e-01  5.631691952644152e-02
            9.978961060764806e-01  1.852848504085792e-02  6.212935473259214e-02
            9.955730661908463e-01  6.079585958473611e-02  7.168077380099803e-02
            8.234533704328791e-01  5.573221875290327e-01  1.063791615429692e-01
            9.948911336501129e-01  0.000000000000000e+00  1.009536140234371e-01
            8.918261367265626e-01  4.390266333707309e-01  1.090951742403676e-01
            9.433696994645154e-01  3.129899181372941e-01  1.099587253320079e-01
            9.744289585759836e-01  1.925873528965254e-01  1.157510958601833e-01
            9.878633524179975e-01  1.050494444565544e-01  1.144142087716581e-01
            9.910894721427209e-01  1.892798628481768e-02  1.318460827748198e-01
            9.571958733942667e-01  2.248248095541923e-01  1.822906058081660e-01
            8.598791140354670e-01  4.763593407368687e-01  1.835475081234172e-01
            9.203946946430163e-01  3.428664035065224e-01  1.879261435231705e-01
            9.839524333023395e-01  0.000000000000000e+00  1.784309642366067e-01
            9.819779946742185e-01  5.044292475688219e-02  1.821393129381238e-01
            9.740675962698959e-01  1.183854791469229e-01  1.928138901224194e-01
            7.962808278540426e-01  5.620155215363954e-01  2.237753264867556e-01
            9.712361862723879e-01  1.701867083116297e-02  2.375092320694246e-01
            8.883355373652128e-01  3.790250305011245e-01  2.592296266009738e-01
            9.302649792921430e-01  2.433329522254322e-01  2.745835804702173e-01
            9.500411272786312e-01  1.443910999839401e-01  2.767183888442821e-01
            9.624942744825894e-01  0.000000000000000e+00  2.713019933362708e-01
            8.333542705824337e-01  4.670727809576460e-01  2.955734713916501e-01
            9.569606615228784e-01  5.942138431325329e-02  2.840693425626770e-01
            8.935584781336233e-01  2.837703989198780e-01  3.478902224156009e-01
            8.535500612002065e-01  3.646787807713434e-01  3.721043937932609e-01
            9.104001644024865e-01  1.648925502004540e-01  3.794495849837184e-01
            9.222103523090598e-01  7.783665071852616e-02  3.787737080354467e-01
            9.254574898029598e-01  0.000000000000000e+00  3.788514676856939e-01
            9.058749166951245e-01  2.208751122453710e-02  4.229690025882594e-01
            8.660079903853022e-01  2.136048266290446e-01  4.521096533249276e-01
            8.296110521341636e-01  2.977155752248765e-01  4.723462061299602e-01
            8.721075748770678e-01  1.030054392556298e-01  4.783495137718802e-01
            8.685866113060875e-01  0.000000000000000e+00  4.955373837157068e-01
            8.218053123063677e-01  1.362072997714168e-01  5.532482265258633e-01
            8.375581342182835e-01  3.972021247413736e-02  5.449024467974035e-01
            7.921242449677133e-01  0.000000000000000e+00  6.103598778870790e-01
            7.667983239266063e-01  6.982198928200947e-02  6.380793212728729e-01
            7.191276232499311e-01  2.305751870870252e-02  6.944953652184463e-01
            1.457483978710132e-01  7.592535880340953e-01  6.342644508210949e-01
            6.454641134600733e-01  7.511339840445944e-01  1.384695498963466e-01
            4.071878949249844e-01  8.031945409015538e-01  4.348293316837102e-01
            8.305944303901543e-02  7.148681754962481e-01  6.943087357830908e-01
            7.106583636447220e-01  6.994354033926764e-01  7.586044201512504e-02
            5.090457273294499e-01  7.754991658855782e-01  3.734614989505661e-01
            3.264747497584070e-01  7.553361743252778e-01  5.682266286666254e-01
            6.040246626627926e-01  7.381469063908508e-01  3.004885213792969e-01
            4.690295027115568e-01  7.412432163012614e-01  4.801768631176547e-01
            2.344731531070192e-01  7.024318097750553e-01  6.720207534653918e-01
            6.871137267137638e-01  6.889889054580994e-01  2.305840729911177e-01
            1.593643503615944e-01  6.509069296698488e-01  7.422419906887495e-01
            5.693721119427463e-01  7.071683162755987e-01  4.191996786709070e-01
            4.108065233632824e-01  7.043206455060002e-01  5.789390543711698e-01
            7.509347060839290e-01  6.424621606183105e-01  1.527725085618991e-01
            3.384415744555113e-01  6.704376320308305e-01  6.602807601596213e-01
            6.592609725548116e-01  6.637311417233317e-01  3.533213007628133e-01
            5.196649859114529e-01  6.694782260746700e-01  5.307986503652420e-01
            2.924981739912006e-01  6.095370910301742e-01  7.368238275668657e-01
            7.353207814970590e-01  6.073646446551948e-01  3.006851122377421e-01
            4.680646625649231e-01  6.272032586850205e-01  6.225203160964917e-01
            6.169148533759419e-01  6.276032270724877e-01  4.749002558983724e-01
            4.017805134665973e-01  5.874941301789820e-01  7.024407918136296e-01
            7.008536670815660e-01  5.779386672110861e-01  4.180801768567783e-01
            5.733845728207199e-01  5.821841657353378e-01  5.764475074265213e-01
            3.601759040919728e-01  5.222007099972307e-01  7.730328172787480e-01
            6.561305329194614e-01  5.368884731087995e-01  5.303239493118572e-01
            5.200143039188916e-01  5.361831071488702e-01  6.649005935686431e-01
            7.739218804907333e-01  5.149052237069902e-01  3.686699519854332e-01
            4.607692710042154e-01  4.907435061977183e-01  7.395015145508587e-01
            7.358862261118543e-01  4.824527677216663e-01  4.750902957718214e-01
            6.174581634158692e-01  4.813188640459672e-01  6.221555814622267e-01
            8.004398536678159e-01  4.278343017776481e-01  4.198259769031423e-01
            4.155457296182141e-01  4.271228800811133e-01  8.030490594647883e-01
            5.624674207342065e-01  4.309303686898055e-01  7.056411396407365e-01
            7.015886542329469e-01  4.253685919870147e-01  5.716947797580342e-01
            5.096893821843446e-01  3.771017267938409e-01  7.733117232640693e-01
            7.708371182763787e-01  3.716976078200029e-01  5.173500028300529e-01
            6.483627738224101e-01  3.710301043914795e-01  6.648025083861809e-01
            7.275188546681988e-01  3.090923543957213e-01  6.125179446811190e-01
            6.051295549942403e-01  3.052544637684831e-01  7.352808538387822e-01
            6.871137267137639e-01  2.305840729911178e-01  6.889889054580995e-01
            7.849460334439314e-01  2.225541182953567e-01  5.782122352652311e-01
            6.270299600929375e-01  1.764844692522830e-01  7.587401803375047e-01
            6.971400616649844e-01  1.365508933835045e-01  7.038107614536089e-01
            0.000000000000000e+00  1.000000000000000e+00  0.000000000000000e+00
            1.195296956590622e-02  9.999285607074920e-01  0.000000000000000e+00
            3.733082430271976e-02  9.993029618473467e-01  0.000000000000000e+00
            8.110166634439159e-02  9.967058340935719e-01  0.000000000000000e+00
            1.464529699600922e-01  9.892176340875997e-01  0.000000000000000e+00
            2.269931037673262e-01  9.738963655554300e-01  0.000000000000000e+00
            3.402998854612264e-01  9.403169614311315e-01  0.000000000000000e+00
            4.607811830572882e-01  8.875137752960942e-01  0.000000000000000e+00
            5.750810207976618e-01  8.180964610107534e-01  0.000000000000000e+00
            7.063055685450109e-01  7.079070870123486e-01  0.000000000000000e+00
            0.000000000000000e+00  9.999285607074920e-01  1.195296956590622e-02
            1.369017568735245e-01  9.904541204848328e-01  1.607930905103069e-02
            2.701843915821037e-01  9.626470889883589e-01  1.763452884675039e-02
            1.848510711630288e-02  9.996512637757498e-01  1.885872865399973e-02
            5.972047738417575e-02  9.979838933758682e-01  2.148518427544369e-02
            5.094557607488376e-01  8.601188621650032e-01  2.550236827832344e-02
            6.423653736518503e-01  7.659429106745936e-01  2.642317771294847e-02
            0.000000000000000e+00  9.993029618473467e-01  3.733082430271976e-02
            3.814832744610008e-01  9.234238340377047e-01  4.193964756192424e-02
            9.881651245165107e-02  9.939311311791612e-01  4.833428741386171e-02
            1.725614156937864e-01  9.833689647430258e-01  5.663953560884707e-02
            2.701242085731655e-01  9.609580265692446e-01  5.993816075643348e-02
            1.936894151634393e-02  9.978987528256577e-01  6.182979228117767e-02
            5.740248037998775e-01  8.152499294933019e-01  7.657073255283960e-02
            4.496824076474755e-01  8.891306517575910e-01  8.504361444277408e-02
            0.000000000000000e+00  9.967058340935719e-01  8.110166634439159e-02
            4.833428741386171e-02  9.939311311791612e-01  9.881651245165107e-02
            1.065087805737565e-01  9.883564891033606e-01  1.086615392306314e-01
            1.894178917282033e-01  9.746518321281163e-01  1.190574164953574e-01
            3.027834074574161e-01  9.441329311192191e-01  1.301353777598861e-01
            4.998162042714956e-01  8.518617737391195e-01  1.565735622309069e-01
            0.000000000000000e+00  9.892176340875997e-01  1.464529699600922e-01
            1.706540881533280e-02  9.877314072169130e-01  1.552270563376835e-01
            3.731127664726380e-01  9.111588572090139e-01  1.748610889383298e-01
            5.663953560884707e-02  9.833689647430258e-01  1.725614156937864e-01
            1.985782265873555e-01  9.605625289891548e-01  1.946440747296979e-01
            1.129617751066425e-01  9.725367706875782e-01  2.034990590281277e-01
            5.666080369289548e-01  7.959134492689969e-01  2.132536371559562e-01
            4.171721725927907e-01  8.761760778855604e-01  2.414184312667266e-01
            0.000000000000000e+00  9.738963655554300e-01  2.269931037673262e-01
            2.596500671399246e-01  9.342333854540860e-01  2.445195782288807e-01
            5.487228308906070e-02  9.599243365915151e-01  2.748350424671744e-01
            4.747918440257318e-01  8.279576000161003e-01  2.984274072906579e-01
            1.316060233330532e-01  9.469545979834786e-01  2.931839763363752e-01
            3.044258795033220e-01  9.004807622233566e-01  3.105789444799364e-01
            1.881654171126428e-01  9.163217386651120e-01  3.534801932959914e-01
            0.000000000000000e+00  9.403169614311315e-01  3.402998854612264e-01
            3.578933544985517e-01  8.594152334607050e-01  3.651271056789074e-01
            1.780603414934585e-02  9.344276513720808e-01  3.557076179942303e-01
            5.774294042510136e-02  9.217732430090755e-01  3.834055832973679e-01
            2.348155739165290e-01  8.751675756968106e-01  4.230169744764601e-01
            1.032257092511100e-01  8.911233144051033e-01  4.418638834225634e-01
            3.008535830048699e-01  8.248512218193588e-01  4.786518394994871e-01
            0.000000000000000e+00  8.875137752960942e-01  4.607811830572882e-01
            1.533007772638006e-01  8.445619196952591e-01  5.130438923629959e-01
            3.032573828918839e-02  8.620851155046337e-01  5.058553184682139e-01
            2.223689377689289e-01  7.945494601443456e-01  5.650161156107385e-01
            7.599034227075081e-02  8.183502994768628e-01  5.696738147639427e-01
            0.000000000000000e+00  8.180964610107534e-01  5.750810207976618e-01
            2.642317771294847e-02  7.659429106745936e-01  6.423653736518503e-01
            ];
        
        
    case 15
        pts=[
            6.979117007560746e-02  6.516550558332448e-01  7.552978755341817e-01
            6.145894540715753e-01  1.266453466693892e-01  7.786146409559694e-01
            4.388571112613504e-01  3.439114085470444e-01  8.301381685999811e-01
            3.519408380483989e-01  4.275274510386480e-01  8.326811665470687e-01
            6.291821884027423e-01  5.674525130263917e-02  7.751836880709865e-01
            1.202963988319969e-01  5.718866249149810e-01  8.114643951963666e-01
            5.185373032437592e-01  1.907890774213314e-01  8.334978062846996e-01
            1.909670715326328e-01  5.124020573135873e-01  8.372429212905019e-01
            6.426459072187968e-01  0.000000000000000e+00  7.661633232770475e-01
            4.328908328132568e-01  2.552770590292315e-01  8.645456321095095e-01
            2.593557543891182e-01  4.257181165127086e-01  8.668902340770274e-01
            0.000000000000000e+00  6.199535779825799e-01  7.846384907373569e-01
            3.395544237096180e-01  3.300476078746303e-01  8.807788427723861e-01
            5.263985928834771e-01  1.030897726504373e-01  8.439650586281262e-01
            5.764240047860435e-01  2.575321515634788e-02  8.167448430296516e-01
            3.488484160619180e-02  5.702211676190104e-01  8.207501860038311e-01
            8.761470842814463e-02  4.950607965529165e-01  8.644295636912489e-01
            4.301491124955333e-01  1.671642956506256e-01  8.871458951485574e-01
            1.684560431114906e-01  4.273889985197215e-01  8.882348819335623e-01
            5.476645569468337e-01  0.000000000000000e+00  8.366979939406024e-01
            0.000000000000000e+00  5.306603470979144e-01  8.475845657029870e-01
            2.402490577454917e-01  3.274329257844105e-01  9.138205892650177e-01
            3.253047757026823e-01  2.412306528966331e-01  9.143219208834992e-01
            4.600497554720457e-01  6.293873615837216e-02  8.856596061585387e-01
            3.175882549599335e-02  4.605337055546928e-01  8.870738881576768e-01
            1.185150847856560e-01  3.714934514097866e-01  9.208402631498545e-01
            3.654817276372369e-01  1.203654286383604e-01  9.230033967174792e-01
            1.870033364604398e-01  2.801371145600643e-01  9.415694075311840e-01
            4.419618404995072e-01  0.000000000000000e+00  8.970338519489039e-01
            2.683716466430359e-01  1.920376381232078e-01  9.439799811554085e-01
            0.000000000000000e+00  4.282773506894767e-01  9.036473376746057e-01
            3.454213639164403e-01  5.529689225719785e-02  9.368171299975263e-01
            5.221424372382274e-02  3.425168353305386e-01  9.380596411036464e-01
            1.082113593417321e-01  2.677683179793586e-01  9.573872934167863e-01
            2.591822902164331e-01  1.140327806165069e-01  9.590730240096592e-01
            1.748770262073942e-01  1.825824586887162e-01  9.675131376286533e-01
            1.673194568886285e-02  3.238502023532200e-01  9.459604053179198e-01
            3.236637499140116e-01  1.687515776263279e-02  9.460216731354977e-01
            3.361373413697455e-01  0.000000000000000e+00  9.418129791720218e-01
            0.000000000000000e+00  3.289579229645038e-01  9.443445795465125e-01
            5.407842230754393e-02  2.423697699699907e-01  9.686756004181279e-01
            2.450279413475499e-01  5.107317956232602e-02  9.681698395882697e-01
            1.713532571978974e-01  1.020107883731985e-01  9.799142106853792e-01
            1.041563005717649e-01  1.668724771740276e-01  9.804616470892719e-01
            0.000000000000000e+00  2.375519025577245e-01  9.713748471065150e-01
            2.375519025577245e-01  0.000000000000000e+00  9.713748471065150e-01
            2.014346150989832e-01  1.459639188265709e-02  9.793932004991317e-01
            1.543342170821989e-02  1.991542370901889e-01  9.798466203153435e-01
            4.844344048686452e-02  1.579080923930906e-01  9.862648059373157e-01
            1.533117040460099e-01  4.665385425046399e-02  9.870759541626394e-01
            9.577824103188293e-02  9.513216004170862e-02  9.908463052717293e-01
            0.000000000000000e+00  1.550178694515350e-01  9.879116661679358e-01
            1.550178694515350e-01  0.000000000000000e+00  9.879116661679358e-01
            1.940898917930652e-02  1.122033065291706e-01  9.934957016227894e-01
            1.145535880359834e-01  1.626029638673273e-02  9.932839866974086e-01
            6.254372271113554e-02  5.236171652270005e-02  9.966677146332318e-01
            0.000000000000000e+00  9.192395075434655e-02  9.957660303895250e-01
            8.734000248942927e-02  0.000000000000000e+00  9.961785602818134e-01
            1.663528573519605e-02  5.507077493049609e-02  9.983438671204742e-01
            5.382395039705978e-02  1.594756974891118e-02  9.984230853614906e-01
            0.000000000000000e+00  4.436400072906588e-02  9.990154330336001e-01
            4.115343409444296e-02  -2.875138970266690e-13  9.991528385898898e-01
            1.537450047733669e-02  1.571959956278546e-02  9.997582302360196e-01
            0.000000000000000e+00  1.373221823735097e-02  9.999057086457112e-01
            1.196384379554155e-02  -7.099923676372692e-14  9.999284306597327e-01
            0.000000000000000e+00  0.000000000000000e+00  1.000000000000000e+00
            7.878851471464131e-01  6.158222104683096e-01  0.000000000000000e+00
            8.512144884275229e-01  5.248179633845155e-01  0.000000000000000e+00
            9.036473376746057e-01  4.282773506894767e-01  0.000000000000000e+00
            9.443445795465125e-01  3.289579229645038e-01  0.000000000000000e+00
            9.713748471065150e-01  2.375519025577245e-01  0.000000000000000e+00
            9.879116661679358e-01  1.550178694515350e-01  0.000000000000000e+00
            9.957660303895250e-01  9.192395075434655e-02  0.000000000000000e+00
            9.990154330336001e-01  4.436400072906588e-02  0.000000000000000e+00
            9.999057086457112e-01  1.373221823735097e-02  0.000000000000000e+00
            1.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
            9.999284306597327e-01  -7.099923676372692e-14  1.196384379554155e-02
            9.867097746682491e-01  1.618400467753051e-01  1.454715896319392e-02
            9.553429264624431e-01  2.950599178407788e-01  1.611017510667838e-02
            9.997582302360196e-01  1.571959956278546e-02  1.537450047733669e-02
            9.983438671204742e-01  5.507077493049609e-02  1.663528573519605e-02
            8.335477212337253e-01  5.519510126851194e-01  2.341529461559382e-02
            9.938952055959150e-01  1.029907090164855e-01  3.956304019833973e-02
            9.991528385898898e-01  -2.875138970266690e-13  4.115343409444296e-02
            9.853109762204992e-01  1.638735944076134e-01  4.803878844575381e-02
            7.859459452417840e-01  6.163268522494997e-01  4.929687976152343e-02
            9.669630888541370e-01  2.492523131020482e-01  5.343846186918964e-02
            9.377931924066842e-01  3.428224251724044e-01  5.492461264852956e-02
            8.909957847152707e-01  4.504956414592678e-01  5.639316133913528e-02
            9.984230853614906e-01  1.594756974891118e-02  5.382395039705978e-02
            9.964180674456617e-01  5.242964004482814e-02  6.634883354379706e-02
            9.961785602818134e-01  0.000000000000000e+00  8.734000248942927e-02
            8.517001015726842e-01  5.153278334274225e-01  9.510079429782967e-02
            9.903881187061784e-01  9.526208335078122e-02  1.002821509607047e-01
            9.799451904285617e-01  1.670869280456189e-01  1.085789216754709e-01
            9.586098176430873e-01  2.610253606479073e-01  1.137232545125073e-01
            9.208402631498545e-01  3.714934514097866e-01  1.185150847856560e-01
            9.932839866974086e-01  1.626029638673273e-02  1.145535880359834e-01
            7.811244027362959e-01  6.128166922606079e-01  1.195841508588504e-01
            9.870759541626394e-01  4.665385425046399e-02  1.533117040460099e-01
            8.855251075659140e-01  4.343318454234330e-01  1.649276566299649e-01
            9.879116661679358e-01  0.000000000000000e+00  1.550178694515350e-01
            9.799142106853792e-01  1.020107883731985e-01  1.713532571978974e-01
            8.248346067954655e-01  5.367485414413690e-01  1.776200289751492e-01
            9.664943833232394e-01  1.827914750163106e-01  1.802106646843984e-01
            9.415694075311840e-01  2.801371145600643e-01  1.870033364604398e-01
            9.793932004991317e-01  1.459639188265709e-02  2.014346150989832e-01
            9.108415612571148e-01  3.350051820299705e-01  2.411206716558494e-01
            8.608706112379430e-01  4.468273649956321e-01  2.434072648830985e-01
            9.713748471065150e-01  0.000000000000000e+00  2.375519025577245e-01
            9.681698395882697e-01  5.107317956232602e-02  2.450279413475499e-01
            9.590730240096592e-01  1.140327806165069e-01  2.591822902164331e-01
            9.439799811554085e-01  1.920376381232078e-01  2.683716466430359e-01
            8.768361181828689e-01  3.600506511066162e-01  3.186250939390988e-01
            9.143219208834992e-01  2.412306528966331e-01  3.253047757026823e-01
            8.275921458236523e-01  4.492826089754072e-01  3.365061328464224e-01
            9.410598402880886e-01  1.688923689193339e-02  3.378181917454492e-01
            9.418129791720218e-01  0.000000000000000e+00  3.361373413697455e-01
            9.368171299975262e-01  5.529689225719785e-02  3.454213639164402e-01
            9.230033967174793e-01  1.203654286383604e-01  3.654817276372370e-01
            8.730275002642631e-01  2.776244252233817e-01  4.009334886258808e-01
            8.337974524747416e-01  3.518349241455010e-01  4.254338895741154e-01
            8.897329560875861e-01  1.672193518136773e-01  4.247504623077639e-01
            8.970338519489039e-01  0.000000000000000e+00  4.419618404995072e-01
            8.837610756679419e-01  3.473611951398797e-02  4.666473648648968e-01
            8.424124975465443e-01  2.047228814301402e-01  4.984272522608832e-01
            8.599974884074125e-01  9.361787907374869e-02  5.016373317952673e-01
            8.366979939406024e-01  0.000000000000000e+00  5.476645569468337e-01
            8.064977022106123e-01  1.395181795274199e-01  5.745399323896964e-01
            8.095764359863962e-01  3.393843191379930e-02  5.860325734417814e-01
            7.524648938949199e-01  8.057495238981766e-02  6.536851386585790e-01
            7.661633232770475e-01  0.000000000000000e+00  6.426459072187968e-01
            2.657462419420057e-01  7.999900467983585e-01  5.379543288395969e-01
            5.306007240183452e-01  8.012527020672278e-01  2.765085515877843e-01
            1.378757736371006e-02  7.044709546128480e-01  7.095988844532539e-01
            7.129077674608343e-01  7.011508097410580e-01  1.224977932322020e-02
            6.073073846182576e-01  7.673632607019363e-01  2.057458789697227e-01
            1.948317111490763e-01  7.569570418931362e-01  6.237440509208210e-01
            1.096563727733446e-01  7.265452303232911e-01  6.783122497822587e-01
            4.254981177347411e-01  7.913694276850697e-01  4.389598851029532e-01
            7.161742382269456e-01  6.927192679865520e-01  8.505572444127260e-02
            5.126491863533030e-01  7.657300380738234e-01  3.883919676341895e-01
            3.738417693454702e-01  7.603399833775309e-01  5.311548184570150e-01
            6.936154642511190e-01  7.026578534511508e-01  1.586490741704028e-01
            6.020784143783473e-01  7.315535047693789e-01  3.198922515461943e-01
            3.099859707949127e-01  7.274450718133220e-01  6.121538739604990e-01
            1.558849362981774e-01  6.759628685488627e-01  7.202597357748843e-01
            4.827580372623380e-01  7.321650204341805e-01  4.804987620288227e-01
            6.830754734764743e-01  6.842046585363393e-01  2.554836252523080e-01
            2.547218218261521e-01  6.778400730486180e-01  6.896735668814705e-01
            5.755569799678908e-01  6.980998405980746e-01  4.258999593416083e-01
            4.291195065646667e-01  6.967459303587142e-01  5.748056694346939e-01
            7.491938882512050e-01  6.271395110170374e-01  2.130834379494386e-01
            3.702432857013704e-01  6.585744772179546e-01  6.551332439665624e-01
            6.594657360594727e-01  6.564225568238784e-01  3.663527942521253e-01
            5.296280883330773e-01  6.619344284364684e-01  5.304120101384733e-01
            2.227984845662623e-01  5.993623842922933e-01  7.688469077589077e-01
            7.322274681785427e-01  6.024890255628407e-01  3.175687467638778e-01
            3.262689003165760e-01  5.988590342267419e-01  7.313798341567985e-01
            6.193100393874069e-01  6.218916497554439e-01  4.792763827672097e-01
            4.821436794016069e-01  6.217273017812137e-01  6.172460081952190e-01
            6.978114738502565e-01  5.750705376783496e-01  4.270281298196485e-01
            4.291195065646667e-01  5.748056694346939e-01  6.967459303587142e-01
            5.713866592178797e-01  5.829583992857724e-01  5.776476351288909e-01
            7.978330344461982e-01  5.390256277807329e-01  2.700255946053229e-01
            2.886310757640432e-01  5.207921833454960e-01  8.034099849202290e-01
            6.554910714921577e-01  5.370466566163872e-01  5.309541824029861e-01
            5.299492179559476e-01  5.355161084941578e-01  6.575532860013344e-01
            7.654918910818780e-01  5.172300456465680e-01  3.827469719910786e-01
            3.893196220242350e-01  5.076922740917725e-01  7.685563003023470e-01
            7.307543455384615e-01  4.860838031237626e-01  4.792917929793853e-01
            4.832193689616652e-01  4.848122545571805e-01  7.290103698106589e-01
            6.197868810559962e-01  4.852632918934408e-01  6.167525918969630e-01
            7.908795311505251e-01  4.363892711314605e-01  4.290384263075724e-01
            6.984402422057342e-01  4.337693269787146e-01  5.692322891755425e-01
            5.762875481245364e-01  4.311833461748129e-01  6.942431734328408e-01
            7.661773542088194e-01  3.901115228641181e-01  5.106713832066685e-01
            5.126491863533030e-01  3.883919676341895e-01  7.657300380738234e-01
            6.605057637987296e-01  3.724687376414390e-01  6.519196081331268e-01
            7.335148806118118e-01  3.244318498773448e-01  5.972435807157774e-01
            6.030916519344489e-01  3.245565160651485e-01  7.286587179514360e-01
            8.027442038255018e-01  2.826848926476722e-01  5.250628483270695e-01
            5.316114829475259e-01  2.806874140161377e-01  7.991269028203628e-01
            6.845213450682148e-01  2.610144154472891e-01  6.806629144258645e-01
            7.649601141560857e-01  2.190913750932010e-01  6.056690458576190e-01
            6.179722309255722e-01  2.189596442890994e-01  7.550940312157569e-01
            7.012480981282871e-01  1.679582642012197e-01  6.928500027841332e-01
            6.761330134664262e-01  1.000194868265431e-01  7.299590744389473e-01
            7.093225460361798e-01  2.259646851393690e-02  7.045217706327109e-01
            0.000000000000000e+00  1.000000000000000e+00  0.000000000000000e+00
            1.031697580190100e-02  9.999467785888921e-01  0.000000000000000e+00
            3.223432532498844e-02  9.994803391117020e-01  0.000000000000000e+00
            7.011267547196789e-02  9.975390783012776e-01  0.000000000000000e+00
            1.269843914964326e-01  9.919047153412877e-01  0.000000000000000e+00
            2.043775032879486e-01  9.788921473532129e-01  0.000000000000000e+00
            3.003387902009970e-01  9.538325907100268e-01  0.000000000000000e+00
            4.144101799126674e-01  9.100902168382817e-01  0.000000000000000e+00
            5.248179633845155e-01  8.512144884275228e-01  0.000000000000000e+00
            6.199535779825799e-01  7.846384907373569e-01  0.000000000000000e+00
            0.000000000000000e+00  9.999467785888921e-01  1.031697580190100e-02
            2.300873847698034e-01  9.730524841259326e-01  1.512145846617196e-02
            1.232664832394135e-01  9.922617309515085e-01  1.490071806671163e-02
            5.874059216792332e-01  8.091190279483442e-01  1.675356046029965e-02
            1.597151037488420e-02  9.997400458154966e-01  1.627119077307104e-02
            5.225579845575130e-02  9.984728915392113e-01  1.792251068010147e-02
            3.450066663852941e-01  9.383263234922630e-01  2.267401136101645e-02
            4.631231722905630e-01  8.859734524226436e-01  2.383209788976503e-02
            0.000000000000000e+00  9.994803391117020e-01  3.223432532498844e-02
            8.408954720842002e-02  9.955145006740318e-01  4.335697173484482e-02
            2.397564550542450e-01  9.695559502920100e-01  4.978053347624137e-02
            1.500819977654775e-01  9.874428583027794e-01  4.931526673921895e-02
            1.792251068010147e-02  9.984728915392113e-01  5.225579845575130e-02
            6.517793634394751e-01  7.565246272537329e-01  5.342424312082682e-02
            5.343193118958840e-01  8.433501680898545e-01  5.712588658325499e-02
            0.000000000000000e+00  9.975390783012776e-01  7.011267547196789e-02
            3.855458977370244e-01  9.195391499401128e-01  7.617159881193673e-02
            4.335697173484482e-02  9.955145006740318e-01  8.408954720842002e-02
            9.757437076183269e-02  9.906088827430920e-01  9.577726035398640e-02
            1.752941564351220e-01  9.792629576420833e-01  1.015678025251032e-01
            2.608743732105095e-01  9.585317038912461e-01  1.147237291817537e-01
            5.863142246723927e-01  8.017589490122582e-01  1.158370304590474e-01
            4.567341754003707e-01  8.814428224896859e-01  1.202183168354956e-01
            0.000000000000000e+00  9.919047153412877e-01  1.269843914964326e-01
            1.468826563846054e-02  9.915219594385327e-01  1.291063856039144e-01
            3.195375800856276e-01  9.342411165212888e-01  1.583959314947103e-01
            4.931526673921895e-02  9.874428583027794e-01  1.500819977654775e-01
            5.107687209859441e-01  8.416808762176098e-01  1.751816664835086e-01
            1.040728849043087e-01  9.794364780584209e-01  1.728381325871434e-01
            1.753077205718449e-01  9.681788473976587e-01  1.785970956080897e-01
            3.790980034185198e-01  9.027564578195997e-01  2.032621009167747e-01
            0.000000000000000e+00  9.788921473532129e-01  2.043775032879486e-01
            2.265392577578940e-01  9.462642236822882e-01  2.307899124170271e-01
            1.554894912864250e-02  9.714846505827127e-01  2.365920621305363e-01
            4.978053347624137e-02  9.695559502920100e-01  2.397564550542450e-01
            4.398835177903942e-01  8.611280415172663e-01  2.548744531901645e-01
            1.114673052418688e-01  9.580734743120176e-01  2.639512411067921e-01
            2.852125880291713e-01  9.166659209634669e-01  2.799595845365920e-01
            0.000000000000000e+00  9.538325907100268e-01  3.003387902009970e-01
            3.393244729463399e-01  8.797272588004049e-01  3.330748447169404e-01
            1.498784905836896e-01  9.329289009815397e-01  3.273837255786111e-01
            4.298963192667247e-01  8.321658642464798e-01  3.502700801721892e-01
            2.435897371847751e-02  9.388297769750075e-01  3.435189809376483e-01
            2.086215340319267e-01  9.035548181287383e-01  3.742535853863104e-01
            7.409492524513187e-02  9.159186970831602e-01  3.944653120191997e-01
            2.659046177230754e-01  8.652527275162978e-01  4.250087667321142e-01
            3.441494848862247e-01  8.302357443005796e-01  4.384857362996076e-01
            0.000000000000000e+00  9.100902168382817e-01  4.144101799126674e-01
            1.247849184432492e-01  8.827292872111352e-01  4.530096352494422e-01
            2.189870982304525e-02  8.852258736186938e-01  4.646456705750162e-01
            1.870992331278651e-01  8.447647868984405e-01  5.013644700010136e-01
            6.050903530244401e-02  8.446676629114525e-01  5.318601281149702e-01
            0.000000000000000e+00  8.512144884275228e-01  5.248179633845155e-01
            1.190303824180919e-01  8.106658281377083e-01  5.732823764526573e-01
            1.675356046029965e-02  8.091190279483442e-01  5.874059216792332e-01
            0.000000000000000e+00  7.846384907373569e-01  6.199535779825799e-01
            5.645180579816701e-02  7.640777549227219e-01  6.426494986027601e-01
            ];
        
        
    case 16
        pts=[
            3.417121802591054e-01  4.702017751446543e-01  8.137217439108928e-01
            6.716330226038359e-01  6.301322339171300e-02  7.381994423093404e-01
            4.570717704357451e-01  3.505977199992783e-01  8.174146043483939e-01
            6.883392191281382e-01  1.760848503424206e-02  7.251751930843083e-01
            0.000000000000000e+00  6.946770714451244e-01  7.193217405364762e-01
            5.813407507548295e-01  1.784736668967238e-01  7.938451245276048e-01
            1.167028428112231e-01  6.179539576947209e-01  7.775045676066539e-01
            3.871855794610585e-01  3.948216043505082e-01  8.331885907737184e-01
            1.839787258717057e-01  5.611417324116647e-01  8.070141167121301e-01
            2.451509745415205e-01  4.810203178912550e-01  8.417365701079753e-01
            4.844817893445581e-01  2.393764876063677e-01  8.414132712138154e-01
            1.451021236647557e-02  6.334375742521882e-01  7.736577365105214e-01
            3.143024453360581e-01  3.948038228334094e-01  8.633330263182917e-01
            3.959763762964095e-01  3.100409738089852e-01  8.643363372985892e-01
            5.695425916552579e-01  9.466860422265168e-02  8.164919421924182e-01
            6.035295110419671e-02  5.824873485188340e-01  8.105960832057559e-01
            6.115672410006738e-01  0.000000000000000e+00  7.911924606155090e-01
            1.663263227373259e-01  4.820567330813097e-01  8.602074519879805e-01
            4.912662251371674e-01  1.527713578880497e-01  8.575070893284319e-01
            5.532135205249906e-01  3.854627972225654e-02  8.321472135553417e-01
            0.000000000000000e+00  5.766167055966157e-01  8.170147947417511e-01
            4.003788835355038e-01  2.213718346269693e-01  8.892082210892751e-01
            2.361890153474117e-01  3.851348091209466e-01  8.921243903361190e-01
            3.100106768655707e-01  2.956605340855697e-01  9.035918485763285e-01
            8.520550072390796e-02  4.795543375068270e-01  8.733657080655138e-01
            2.597250362219342e-02  5.187538783721060e-01  8.545290180734025e-01
            4.644391465628060e-01  8.308075920439284e-02  8.816994196380273e-01
            1.447828385640093e-01  3.997523608554063e-01  9.051165558356984e-01
            5.141907598175780e-01  0.000000000000000e+00  8.576758493266683e-01
            3.826114160817546e-01  1.483345076209267e-01  9.119239980024496e-01
            0.000000000000000e+00  4.850143360247255e-01  8.745062000068924e-01
            4.718613964388714e-01  1.674475501212909e-02  8.815137184016718e-01
            2.071404367379118e-01  3.060198255306876e-01  9.292172543868279e-01
            2.885582788468233e-01  2.205710794621299e-01  9.317094604080555e-01
            5.180873473810230e-02  4.099700762552444e-01  9.106263732069844e-01
            4.043507980830276e-01  4.551489077885765e-02  9.134707585943884e-01
            1.075642354825164e-01  3.338283669411565e-01  9.364766717171668e-01
            3.243578067684186e-01  1.062172391811097e-01  9.399520792514499e-01
            1.605876279255029e-02  3.983638272485743e-01  9.170868973425804e-01
            4.026169425195268e-01  0.000000000000000e+00  9.153685583393326e-01
            1.667431719104110e-01  2.490255683656622e-01  9.540351046588452e-01
            2.427592484078821e-01  1.697579029885295e-01  9.551178993639357e-01
            0.000000000000000e+00  3.893520057663316e-01  9.210890378273614e-01
            3.441868634973719e-01  1.489473070923249e-02  9.387830153943674e-01
            4.652663152103637e-02  3.140202536931428e-01  9.482755679810589e-01
            3.068809935971025e-01  4.866281872237840e-02  9.505030172718276e-01
            9.705905496150541e-02  2.380703738838382e-01  9.663860703304807e-01
            2.295959697559360e-01  1.003254313157534e-01  9.681014918401579e-01
            1.600725769655104e-01  1.613284454725976e-01  9.738325845775626e-01
            3.020012264715444e-01  0.000000000000000e+00  9.533075365325100e-01
            0.000000000000000e+00  2.953191663555329e-01  9.553986550038016e-01
            2.589758161248975e-01  1.299212064790752e-02  9.657964234058406e-01
            4.712677505861541e-02  2.152660243270624e-01  9.754176571310339e-01
            2.138616196497752e-01  4.481851254863661e-02  9.758352876247623e-01
            9.389677979589192e-02  1.528858115594053e-01  9.837730039840409e-01
            1.483387948251109e-01  9.408307504181478e-02  9.844511043929556e-01
            1.484015812448507e-02  2.127151973911649e-01  9.770015427345434e-01
            0.000000000000000e+00  2.114681667339786e-01  9.773848855277895e-01
            2.114681667339786e-01  0.000000000000000e+00  9.773848855277895e-01
            1.849891533857388e-01  1.282520929938294e-02  9.826568715152073e-01
            4.382239824695475e-02  1.396016966992345e-01  9.892375668617626e-01
            1.366164515516499e-01  4.097571619088207e-02  9.897762049312360e-01
            8.577761819565392e-02  8.375544859575131e-02  9.927876031897281e-01
            0.000000000000000e+00  1.372659463041273e-01  9.905342295878686e-01
            1.372659463041273e-01  0.000000000000000e+00  9.905342295878686e-01
            1.213084248737920e-02  1.128454917972883e-01  9.935384932862815e-01
            3.864860533170494e-02  7.829376493487801e-02  9.961808930501710e-01
            1.014592582047684e-01  1.428058194750987e-02  9.947371933851568e-01
            7.016941385748898e-02  4.017005564468963e-02  9.967259502934590e-01
            0.000000000000000e+00  8.118016093286774e-02  9.966994439001728e-01
            7.712051514016337e-02  0.000000000000000e+00  9.970217781696225e-01
            1.477322453891537e-02  4.854852392666478e-02  9.987115662999327e-01
            4.757784797787439e-02  1.402869878118300e-02  9.987690143332948e-01
            0.000000000000000e+00  3.913008355493901e-02  9.992341249982325e-01
            3.629608482550405e-02  -2.868386391665161e-13  9.993410800254034e-01
            1.358084943485434e-02  1.384909465457308e-02  9.998118638553338e-01
            0.000000000000000e+00  1.210656910447230e-02  9.999267128067529e-01
            1.054734441543026e-02  0.000000000000000e+00  9.999443752158328e-01
            0.000000000000000e+00  0.000000000000000e+00  1.000000000000000e+00
            7.084760759762923e-01  7.057348296415834e-01  0.000000000000000e+00
            8.170147947417511e-01  5.766167055966157e-01  0.000000000000000e+00
            8.745062000068924e-01  4.850143360247255e-01  0.000000000000000e+00
            9.210890378273614e-01  3.893520057663316e-01  0.000000000000000e+00
            9.553986550038016e-01  2.953191663555329e-01  0.000000000000000e+00
            9.773848855277895e-01  2.114681667339786e-01  0.000000000000000e+00
            9.905342295878686e-01  1.372659463041273e-01  0.000000000000000e+00
            9.966994439001728e-01  8.118016093286774e-02  0.000000000000000e+00
            9.992341249982325e-01  3.913008355493901e-02  0.000000000000000e+00
            9.999267128067529e-01  1.210656910447230e-02  0.000000000000000e+00
            1.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
            9.999443752158328e-01  0.000000000000000e+00  1.054734441543026e-02
            7.712696294458254e-01  6.364037444754880e-01  1.155130780808033e-02
            9.935384932862815e-01  1.128454917972883e-01  1.213084248737920e-02
            9.998118638553338e-01  1.384909465457308e-02  1.358084943485434e-02
            9.336537551746910e-01  3.578633407064074e-01  1.498315142578671e-02
            9.770015427345434e-01  2.127151973911649e-01  1.484015812448507e-02
            9.987115662999327e-01  4.854852392666478e-02  1.477322453891537e-02
            8.547025278902822e-01  5.185320259549749e-01  2.466022864838283e-02
            9.993410800254034e-01  -2.868386391665161e-13  3.629608482550405e-02
            9.961808930501710e-01  7.829376493487801e-02  3.864860533170494e-02
            9.892375668617626e-01  1.396016966992345e-01  4.382239824695475e-02
            9.504469446400001e-01  3.072859591543129e-01  4.717991872717369e-02
            9.754176571310339e-01  2.152660243270624e-01  4.712677505861541e-02
            9.140202933927416e-01  4.027899730045253e-01  4.824044893302967e-02
            9.987690143332948e-01  1.402869878118300e-02  4.757784797787439e-02
            8.013910816541830e-01  5.956588179321910e-01  5.443259009787763e-02
            9.967259502934590e-01  4.017005564468963e-02  7.016941385748898e-02
            8.776893750241653e-01  4.725358729360036e-01  7.981985817012686e-02
            9.970217781696225e-01  0.000000000000000e+00  7.712051514016337e-02
            9.927876031897281e-01  8.375544859575131e-02  8.577761819565392e-02
            9.841176914737665e-01  1.475851605341010e-01  9.864577902002772e-02
            9.673825156528368e-01  2.319125644294983e-01  1.019197275748070e-01
            9.369812934390633e-01  3.335113902648000e-01  1.040971099930262e-01
            9.947371933851568e-01  1.428058194750987e-02  1.014592582047684e-01
            8.259319591743004e-01  5.532592157389845e-01  1.083542293331727e-01
            9.083163487249150e-01  3.927527910709475e-01  1.438980741532675e-01
            9.897762049312360e-01  4.097571619088207e-02  1.366164515516499e-01
            9.905342295878686e-01  0.000000000000000e+00  1.372659463041273e-01
            9.839477098489365e-01  8.974776257381105e-02  1.542473448589244e-01
            9.540351046588452e-01  2.490255683656622e-01  1.667431719104110e-01
            9.736760659338061e-01  1.558610505120598e-01  1.663197269145896e-01
            8.621348361645320e-01  4.761995537311842e-01  1.730823772016572e-01
            7.996193930957018e-01  5.718493802225431e-01  1.832951513934691e-01
            9.826942145194519e-01  1.458939679612627e-02  1.846597689024942e-01
            9.281319662817376e-01  3.062514669638106e-01  2.116154345706136e-01
            9.773848855277895e-01  0.000000000000000e+00  2.114681667339786e-01
            9.744971705595833e-01  4.486693769611977e-02  2.198686482269335e-01
            8.921243903361190e-01  3.851348091209466e-01  2.361890153474117e-01
            9.668359894326858e-01  9.579285781627973e-02  2.367528203192300e-01
            9.551178993639357e-01  1.697579029885295e-01  2.427592484078821e-01
            8.374402309942955e-01  4.875661945270750e-01  2.469272473150897e-01
            9.317094604080555e-01  2.205710794621299e-01  2.885582788468233e-01
            8.621105966223094e-01  4.017263232721219e-01  3.088385992420445e-01
            9.035918485763285e-01  2.956605340855697e-01  3.100106768655707e-01
            9.565782994122752e-01  1.483694790494556e-02  2.910976160506738e-01
            9.533075365325100e-01  0.000000000000000e+00  3.020012264715444e-01
            9.483972939175601e-01  4.868824808420393e-02  3.133241570456070e-01
            9.378242580435420e-01  1.062562375617230e-01  3.304470804899123e-01
            9.121285010201228e-01  1.539928384093966e-01  3.798786692424326e-01
            8.641343985543988e-01  3.171401980279364e-01  3.907605865870160e-01
            8.288102168395333e-01  3.946399306274383e-01  3.966521771234547e-01
            8.892082210892751e-01  2.213718346269693e-01  4.003788835355038e-01
            9.153685583393326e-01  0.000000000000000e+00  4.026169425195268e-01
            9.070353895680724e-01  2.099415821198803e-02  4.205306735448261e-01
            9.017258876683125e-01  6.302688361926899e-02  4.276891808896232e-01
            8.422168062842148e-01  2.461839573940072e-01  4.796501958034032e-01
            8.600342719737474e-01  1.528687435643912e-01  4.867979029038960e-01
            8.610670339041844e-01  0.000000000000000e+00  5.084914582600678e-01
            8.440515766112970e-01  3.579207043479714e-02  5.350662236714016e-01
            8.259487537518411e-01  9.048376950798874e-02  5.564362889239034e-01
            8.056528217032467e-01  1.733165726126316e-01  5.664670304081316e-01
            7.974751521966115e-01  0.000000000000000e+00  6.033517892813376e-01
            7.745420302061625e-01  4.361840727034229e-02  6.310167018323006e-01
            7.125660168857664e-01  -7.087886570804707e-14  7.016050680971124e-01
            5.232841941477402e-01  7.983719585171516e-01  2.979527949334219e-01
            2.793094803646224e-01  7.859105347548315e-01  5.516618942249133e-01
            7.093839991151645e-01  7.038379727245964e-01  3.723506345243133e-02
            6.054932961518086e-01  7.613525323836503e-01  2.317761630285154e-01
            4.894257257425470e-02  6.939177405711531e-01  7.183890268583170e-01
            4.300765195752092e-01  7.832243018466377e-01  4.489920715412707e-01
            2.108136063675766e-01  7.404260846659272e-01  6.382216202202663e-01
            6.776908128637777e-01  7.146135890375337e-01  1.733856410517523e-01
            5.049785735854564e-01  7.621659643969747e-01  4.050921906608758e-01
            3.811592489969896e-01  7.538348317846310e-01  5.352108680625686e-01
            1.603761973914809e-01  6.923379112656317e-01  7.035251892680113e-01
            5.849012370507672e-01  7.348088068385354e-01  3.434334874309873e-01
            3.208277060151367e-01  7.223410971533635e-01  6.126115591599135e-01
            7.493080365119810e-01  6.524350960960047e-01  1.134280027187150e-01
            4.838839798824695e-01  7.248892878612151e-01  4.902976793307944e-01
            6.669559669810978e-01  6.905237874498895e-01  2.799046928405605e-01
            2.608374153960598e-01  6.803487698480175e-01  6.849010104356634e-01
            5.719016422130849e-01  6.917014078191303e-01  4.409962290711906e-01
            4.331476376988663e-01  6.909152841012348e-01  5.788084261231876e-01
            7.314854049415054e-01  6.438969532290468e-01  2.243341614197728e-01
            6.455756017347057e-01  6.626472661604561e-01  3.796455492889996e-01
            3.777010310189492e-01  6.547296889431634e-01  6.547296889431634e-01
            2.310383767711449e-01  6.185185203429008e-01  7.510366891515907e-01
            5.273859211561817e-01  6.611727836300908e-01  5.335865818712864e-01
            7.189187840310700e-01  6.114627317426341e-01  3.305587839660641e-01
            3.285276491162961e-01  6.063920679680903e-01  7.241258479515166e-01
            4.827574224975708e-01  6.192516738061764e-01  6.192516738061764e-01
            6.128200027039187e-01  6.188344404284226e-01  4.914219974986976e-01
            6.826206756439711e-01  5.877767767358786e-01  4.342205360336491e-01
            7.778081823223174e-01  5.570587248866267e-01  2.910326588892352e-01
            4.331476376988663e-01  5.788084261231876e-01  6.909152841012348e-01
            2.866825502112204e-01  5.480865281312535e-01  7.857571336522626e-01
            5.667738606327297e-01  5.825664729897658e-01  5.825664729897658e-01
            7.522456195679267e-01  5.321073522866707e-01  3.885721213408587e-01
            3.887321415970272e-01  5.271526694080357e-01  7.556436893307394e-01
            6.469966392206304e-01  5.391638660171920e-01  5.391638660171920e-01
            5.276767160457956e-01  5.383583546290124e-01  6.570597882569496e-01
            7.160742389366520e-01  5.059147203023578e-01  4.809240897612445e-01
            8.125308793804852e-01  4.708102054347864e-01  3.437023719901126e-01
            4.838839798824694e-01  4.902976793307943e-01  7.248892878612150e-01
            6.128200027039187e-01  4.914219974986976e-01  6.188344404284226e-01
            7.774366832535844e-01  4.581018586307861e-01  4.309697096672629e-01
            4.378390470964924e-01  4.455062775323353e-01  7.809104465410341e-01
            6.894060609471445e-01  4.488440131300894e-01  5.685581192865142e-01
            5.719016422130849e-01  4.409962290711906e-01  6.917014078191303e-01
            7.579101307665554e-01  4.127867618598622e-01  5.051527718568635e-01
            5.193643042339965e-01  3.963154978944117e-01  7.570962591482284e-01
            6.537550497558910e-01  3.918838723712423e-01  6.473263207177601e-01
            8.117096742447956e-01  3.445945745593641e-01  4.715739432174542e-01
            7.271764832848738e-01  3.523661052275208e-01  5.891116108550496e-01
            6.051045904605777e-01  3.393817503915859e-01  7.201864078866524e-01
            5.509107321287509e-01  2.881032258359900e-01  7.832585119156129e-01
            6.849644998044355e-01  2.867481478608027e-01  6.697754352811536e-01
            7.769987926507518e-01  2.751271461834285e-01  5.661960169872590e-01
            6.424616976697781e-01  2.312930464142709e-01  7.305795601491138e-01
            7.266367793524703e-01  2.075569016360312e-01  6.549191732385916e-01
            6.873021328296545e-01  1.369286068154796e-01  7.133486769058872e-01
            7.547420795020361e-01  1.126023744953182e-01  6.462856169581358e-01
            0.000000000000000e+00  1.000000000000000e+00  0.000000000000000e+00
            9.095314188832474e-03  9.999586367744451e-01  0.000000000000000e+00
            2.842534357981646e-02  9.995959182801665e-01  0.000000000000000e+00
            6.187774347254921e-02  9.980837363982771e-01  0.000000000000000e+00
            1.075664339460128e-01  9.941978989558055e-01  0.000000000000000e+00
            1.699871190188134e-01  9.854462843644415e-01  0.000000000000000e+00
            2.493085804187053e-01  9.684240970409657e-01  0.000000000000000e+00
            3.491029566755264e-01  9.370843748779538e-01  0.000000000000000e+00
            4.605431084736968e-01  8.876373388030636e-01  0.000000000000000e+00
            5.670203777438783e-01  8.237037642400267e-01  0.000000000000000e+00
            0.000000000000000e+00  9.999586367744451e-01  9.095314188832474e-03
            6.417020612049210e-01  7.668929990283265e-01  9.674331330644893e-03
            1.566111090777402e-01  9.875647489356276e-01  1.374143999552787e-02
            1.278170557468532e-02  9.998307068252629e-01  1.323577318849931e-02
            2.751549760296258e-01  9.612880180576689e-01  1.466579370149252e-02
            3.878217423318182e-01  9.215678375527609e-01  1.752189952718614e-02
            4.151208803670711e-02  9.989959410730517e-01  1.684803449665699e-02
            8.467942002440292e-02  9.962381039320376e-01  1.841293290677352e-02
            5.000483348776208e-01  8.655872571394404e-01  2.665263709164935e-02
            0.000000000000000e+00  9.995959182801665e-01  2.842534357981646e-02
            6.053491695278753e-01  7.949296428335373e-01  4.048760176222224e-02
            2.012499367104362e-01  9.785619521523672e-01  4.376035618906500e-02
            1.269024656840620e-01  9.909374145215432e-01  4.403186010906938e-02
            1.548030137610944e-02  9.989603892628316e-01  4.287774426385656e-02
            2.925236722550834e-01  9.550653211957956e-01  4.775074260754870e-02
            5.111608934445928e-02  9.970783428034026e-01  5.676199188321008e-02
            0.000000000000000e+00  9.980837363982771e-01  6.187774347254921e-02
            5.389026358888869e-01  8.377621454874246e-01  8.796895259304256e-02
            8.411991611044729e-02  9.926409173426787e-01  8.710825983026327e-02
            4.344777407785430e-01  8.957140965655855e-01  9.447407041971906e-02
            1.468110328127707e-01  9.847933608513553e-01  9.289002673882675e-02
            1.782371652832158e-02  9.957899445908943e-01  8.991496750142208e-02
            6.560873932390052e-01  7.490913298948250e-01  9.171429501037197e-02
            2.241033728987102e-01  9.696075275022304e-01  9.817800602188295e-02
            3.199804763675428e-01  9.418712951588228e-01  1.024253782001399e-01
            0.000000000000000e+00  9.936751283686639e-01  1.122930953421417e-01
            4.284979567389365e-02  9.900728525745144e-01  1.338642656038926e-01
            5.865216382570621e-01  7.967024686207619e-01  1.457996719812357e-01
            4.665234722330370e-01  8.707313974505895e-01  1.555078240776790e-01
            8.919065181912277e-02  9.835519061327183e-01  1.570690153110298e-01
            3.477187688092300e-01  9.231005722106903e-01  1.642467393956101e-01
            1.554032459363263e-01  9.746554900927435e-01  1.609239161359418e-01
            2.373725148290329e-01  9.569333604531947e-01  1.671311845691784e-01
            1.337869201899983e-02  9.865828245681096e-01  1.627124484084466e-01
            0.000000000000000e+00  9.833904715566621e-01  1.815025632093540e-01
            5.118756993235651e-01  8.335607804903631e-01  2.077491123213471e-01
            3.831511146212547e-01  8.957129849500398e-01  2.255958154673532e-01
            4.270212706575417e-02  9.755876935060991e-01  2.154186171701737e-01
            2.558351790692449e-01  9.368179059113781e-01  2.385803267548012e-01
            9.712586109413437e-02  9.660732150731520e-01  2.393096534303336e-01
            1.660211590308833e-01  9.530677589591745e-01  2.531774507861610e-01
            4.375083053078344e-01  8.555451137266469e-01  2.768195100875764e-01
            0.000000000000000e+00  9.631866887426938e-01  2.688334105517488e-01
            2.964771922877339e-01  9.078560177177680e-01  2.964771922877339e-01
            1.420555104643784e-02  9.572136951551041e-01  2.890331194292072e-01
            4.545887586006341e-02  9.501354841618923e-01  3.085061625672749e-01
            1.911974293108140e-01  9.219931516951239e-01  3.367078425760655e-01
            1.025990952123484e-01  9.370017707286366e-01  3.339178152075851e-01
            3.471425730403142e-01  8.711969168712091e-01  3.471425730403142e-01
            4.329944707805183e-01  8.248230778601171e-01  3.635693585863116e-01
            0.000000000000000e+00  9.293144498157485e-01  3.692893897252573e-01
            2.324773655809089e-01  8.888513172212990e-01  3.948387143714789e-01
            1.839054763374995e-02  9.132216107494171e-01  4.070480038250662e-01
            1.244114344652539e-01  8.980101158994518e-01  4.220185146608509e-01
            2.802974860285581e-01  8.515748504839739e-01  4.430051843367840e-01
            3.482783152571530e-01  8.162595465627248e-01  4.608932281633717e-01
            5.534820342107721e-02  8.956149462054911e-01  4.413733618053933e-01
            1.688611870667853e-01  8.571114720123627e-01  4.866680840646906e-01
            0.000000000000000e+00  8.778233457635140e-01  4.789845233747642e-01
            2.150171870767661e-01  8.204248560942972e-01  5.297836018264880e-01
            8.727419600594191e-02  8.405571453323327e-01  5.346465188723069e-01
            2.177180372386204e-02  8.502182429986895e-01  5.259799690433382e-01
            1.452335922427760e-01  7.984770905389147e-01  5.842444176616229e-01
            0.000000000000000e+00  8.136979784808765e-01  5.812878803279274e-01
            4.358630429321657e-02  7.934452962177785e-01  6.070789042521088e-01
            9.627179018538115e-02  7.509120148106322e-01  6.533474484740402e-01
            1.121388312863342e-02  7.624157018315133e-01  6.469903758371823e-01
            ];
        
        
    case 17
        pts=[
            0.000000000000000e+00  7.062608939409797e-01  7.079516577349672e-01
            3.892587127559944e-01  4.249584882372396e-01  8.172441115227848e-01
            1.882956154758516e-01  5.908963362715348e-01  7.844656021607623e-01
            6.967531985146972e-01  1.081665421669195e-02  7.172293777802856e-01
            5.669716753788948e-01  2.169569779650822e-01  7.946526216091582e-01
            2.498884916202146e-01  5.273369542814031e-01  8.120784927610060e-01
            3.854297876804138e-02  6.669978906492483e-01  7.440619951705231e-01
            4.695486435632446e-01  2.908059093501928e-01  8.336402068128219e-01
            6.621960414672062e-01  7.240345695103207e-14  7.493306364116992e-01
            3.055102477998293e-01  4.379615060159802e-01  8.454899217243820e-01
            3.775816462914845e-01  3.525640864966151e-01  8.562304977613328e-01
            5.493093313907190e-01  1.449546838617353e-01  8.229504226097861e-01
            8.489958112888317e-02  5.886540263516082e-01  8.039144844970642e-01
            6.138656225547148e-01  3.112124848688843e-02  7.887968466836881e-01
            1.566404940774300e-01  5.207284885983220e-01  8.392291682116904e-01
            1.473996745173717e-02  6.181862183974873e-01  7.858934614455929e-01
            4.705427786636637e-01  2.089976758635594e-01  8.572686072236105e-01
            0.000000000000000e+00  6.152960244860282e-01  7.882961386761254e-01
            5.585672609765959e-01  8.045958131950169e-02  8.255476186986394e-01
            2.350655567252397e-01  4.354080316182486e-01  8.690017434066374e-01
            3.780570135621859e-01  2.730916673273947e-01  8.845868163910113e-01
            2.990880601762236e-01  3.519403953225480e-01  8.869522480946943e-01
            5.787549779450188e-01  0.000000000000000e+00  8.155014871254748e-01
            4.245170582303556e-02  5.486311728416252e-01  8.349860411163393e-01
            4.685604854528388e-01  1.266268208295709e-01  8.743092815010005e-01
            1.658646891946427e-01  4.306652992896715e-01  8.871393942702027e-01
            9.564069925627167e-02  4.850559623470561e-01  8.692373496562045e-01
            3.881737847047850e-01  1.865051953854750e-01  9.025169942788828e-01
            0.000000000000000e+00  5.361174080951494e-01  8.441434266387076e-01
            5.022829182842590e-01  4.009461373467819e-02  8.637732873557248e-01
            2.279294088913889e-01  3.359693774352209e-01  9.138778703898087e-01
            3.003370333273032e-01  2.530649202578208e-01  9.196498314831885e-01
            1.939402341383437e-02  4.798729502814333e-01  8.771236078478429e-01
            4.238358369942329e-01  8.203246603103764e-02  9.020165507330034e-01
            4.766002342795926e-01  0.000000000000000e+00  8.791201377995146e-01
            6.109620067305296e-02  4.257525482457235e-01  9.027746241037078e-01
            1.267240641963889e-01  3.686884776764009e-01  9.208744854659658e-01
            3.438498182149477e-01  1.372195425159031e-01  9.289446160376159e-01
            4.353535995195573e-01  1.492149772319704e-02  9.001358743495682e-01
            0.000000000000000e+00  4.473150397094575e-01  8.943764617037541e-01
            1.867521834397767e-01  2.810821046509452e-01  9.413375974779034e-01
            2.583151304391211e-01  2.026396151888366e-01  9.445689385864539e-01
            3.760289618386373e-01  4.338377686329129e-02  9.255917392477273e-01
            2.893450195110867e-02  3.708320874997564e-01  9.282490815925508e-01
            2.993557270225542e-01  9.007476735123482e-02  9.498803529842160e-01
            1.019182861137411e-01  2.882034349797995e-01  9.521299507007865e-01
            3.732232653462813e-01  0.000000000000000e+00  9.277415557170323e-01
            2.239919122252355e-01  1.510299241452372e-01  9.628175243888981e-01
            1.573557703075303e-01  2.167747158107036e-01  9.634562180691515e-01
            0.000000000000000e+00  3.542182371619501e-01  9.351627882149077e-01
            3.309523673647153e-01  1.322105945503851e-02  9.435548389588052e-01
            4.638253789823402e-02  2.832180562533878e-01  9.579332924531707e-01
            2.794399517543434e-01  4.021591679018307e-02  9.593205894800003e-01
            1.380684125468161e-02  2.987653472311761e-01  9.542267227595352e-01
            2.152274727843957e-01  8.491512314643659e-02  9.728651277643102e-01
            9.091072987567535e-02  2.070521970935019e-01  9.740968262304449e-01
            1.465169638956799e-01  1.434315518538695e-01  9.787543967837808e-01
            2.721705589074409e-01  0.000000000000000e+00  9.622490253900033e-01
            0.000000000000000e+00  2.659847301661426e-01  9.639772421164539e-01
            2.444560701282328e-01  1.310102803703342e-02  9.695718605868435e-01
            4.303530891061882e-02  1.980525773414009e-01  9.792462094873771e-01
            1.925372766591358e-01  3.966119595671506e-02  9.804878309453752e-01
            1.386669421943437e-01  8.349473974029821e-02  9.868131067117879e-01
            8.550974309158517e-02  1.359732386839580e-01  9.870153809329449e-01
            1.214961628582628e-02  1.957750541901713e-01  9.805735642882397e-01
            0.000000000000000e+00  1.892213270808951e-01  9.819344628730294e-01
            1.892213270808951e-01  0.000000000000000e+00  9.819344628730294e-01
            1.602893201058634e-01  1.132816505474243e-02  9.870050691544054e-01
            3.700618062656568e-02  1.288848975962694e-01  9.909688318847536e-01
            1.220292098823054e-01  3.899036747115291e-02  9.917603658041416e-01
            7.647247785112699e-02  8.198519301529610e-02  9.936953196315023e-01
            0.000000000000000e+00  1.223295538898647e-01  9.924895365922538e-01
            1.223295538898647e-01  0.000000000000000e+00  9.924895365922538e-01
            1.094333462788031e-02  1.004180340173448e-01  9.948851500908602e-01
            3.454727541988027e-02  7.318768609515523e-02  9.967196438141971e-01
            6.590951824131723e-02  3.832015526094779e-02  9.970895150917868e-01
            9.058906532716454e-02  1.111255438189663e-02  9.958263565392613e-01
            0.000000000000000e+00  7.220033682441107e-02  9.973901500227690e-01
            6.858201340028881e-02  2.902213268364818e-13  9.976454818411009e-01
            1.320074133223669e-02  4.311747767823291e-02  9.989827944198771e-01
            4.235070450016300e-02  1.243717016664426e-02  9.990253923832896e-01
            0.000000000000000e+00  3.476858371321837e-02  9.993953900166725e-01
            3.224895587017881e-02  2.148426434485888e-13  9.994798671535526e-01
            1.208224703726278e-02  1.229388527871748e-02  9.998514288089427e-01
            0.000000000000000e+00  1.075329407447682e-02  9.999421816617938e-01
            9.368222093577823e-03  2.129333007243589e-13  9.999561172445546e-01
            0.000000000000000e+00  0.000000000000000e+00  1.000000000000000e+00
            7.742559546191622e-01  6.328725912352104e-01  0.000000000000000e+00
            8.345182750129935e-01  5.509802615968542e-01  0.000000000000000e+00
            8.943764617037541e-01  4.473150397094575e-01  0.000000000000000e+00
            9.351627882149077e-01  3.542182371619501e-01  0.000000000000000e+00
            9.639772421164539e-01  2.659847301661426e-01  0.000000000000000e+00
            9.819344628730294e-01  1.892213270808951e-01  0.000000000000000e+00
            9.924895365922538e-01  1.223295538898647e-01  0.000000000000000e+00
            9.973901500227690e-01  7.220033682441107e-02  0.000000000000000e+00
            9.993953900166725e-01  3.476858371321837e-02  0.000000000000000e+00
            9.999421816617938e-01  1.075329407447682e-02  0.000000000000000e+00
            1.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
            7.118899484714633e-01  7.022771923634694e-01  4.409801739297424e-03
            9.999561172445546e-01  2.129333007243589e-13  9.368222093577823e-03
            9.939663650859851e-01  1.091497994073265e-01  1.082526522050800e-02
            9.794233321149709e-01  2.014568992218552e-01  1.204384758797844e-02
            8.105716323618622e-01  5.855082447223632e-01  1.239855525306913e-02
            9.998514288089427e-01  1.229388527871748e-02  1.208224703726278e-02
            9.989827944198771e-01  4.311747767823291e-02  1.320074133223669e-02
            9.162032399315387e-01  4.004627960730868e-01  1.418351508888178e-02
            9.577725606393859e-01  2.868291901838313e-01  2.001843512269573e-02
            8.731219068913778e-01  4.867779441526009e-01  2.655877995939272e-02
            9.968052007718987e-01  7.312153641043068e-02  3.213460171019398e-02
            9.994798671535526e-01  2.148426434485888e-13  3.224895587017881e-02
            9.908573932652318e-01  1.290027094890988e-01  3.949591315694347e-02
            7.667409252636974e-01  6.406405410446000e-01  4.108589412257072e-02
            9.792462094873771e-01  1.980525773414009e-01  4.303530891061882e-02
            9.390455172337852e-01  3.407625713435368e-01  4.554543373900315e-02
            9.990253923832896e-01  1.243717016664426e-02  4.235070450016300e-02
            8.330198631105734e-01  5.505589699679753e-01  5.443094938583824e-02
            9.975127204981244e-01  3.823228865000661e-02  5.921709676278695e-02
            9.076973244641302e-01  4.140600483047905e-01  6.811639713383458e-02
            9.976454818411009e-01  2.902213268364818e-13  6.858201340028881e-02
            9.939818749157993e-01  7.809122011738211e-02  7.682313245013526e-02
            9.870153809329449e-01  1.359732386839580e-01  8.550974309158517e-02
            9.740968262304449e-01  2.070521970935019e-01  9.091072987567535e-02
            9.958209507105041e-01  1.264170691136106e-02  9.044789313408501e-02
            9.521299507007865e-01  2.882034349797995e-01  1.019182861137411e-01
            8.741119349791479e-01  4.742673633178849e-01  1.048751315542036e-01
            9.923082135397456e-01  3.894079893390521e-02  1.175075466510461e-01
            9.253409745920073e-01  3.559014784060593e-01  1.306836577751606e-01
            9.924895365922538e-01  0.000000000000000e+00  1.223295538898647e-01
            8.205937933523270e-01  5.559769596682423e-01  1.323459354483399e-01
            9.874625862966406e-01  8.339300058752953e-02  1.340270424853055e-01
            9.787543967837808e-01  1.434315518538695e-01  1.465169638956799e-01
            9.634562180691516e-01  2.167747158107036e-01  1.573557703075303e-01
            9.878302771039232e-01  1.131402906859655e-02  1.551236164580402e-01
            8.971976670926152e-01  4.055162394729583e-01  1.749083350995012e-01
            9.418265467097005e-01  2.749605513160095e-01  1.932859310267473e-01
            8.537095934645602e-01  4.829632968056201e-01  1.947469742132639e-01
            9.815419763886776e-01  3.961635821856754e-02  1.870986177087014e-01
            7.896234722710715e-01  5.818553782233573e-01  1.947795956231820e-01
            9.819344628730294e-01  0.000000000000000e+00  1.892213270808951e-01
            9.740632912905167e-01  8.483026271610440e-02  2.097725699127576e-01
            9.632574489283915e-01  1.458106200737299e-01  2.255534308266705e-01
            9.172577106895500e-01  3.166293109308171e-01  2.416281681427924e-01
            9.710583757061461e-01  1.308894692584500e-02  2.384833546378312e-01
            8.806850074774903e-01  3.972832707263531e-01  2.579920936876635e-01
            8.209406191718392e-01  5.103856909312827e-01  2.560526240567637e-01
            9.442939662464236e-01  1.910957213796337e-01  2.679390426589520e-01
            9.610575066996291e-01  4.018746961702565e-02  2.734107461349553e-01
            9.622490253900033e-01  0.000000000000000e+00  2.721705589074409e-01
            9.498151700771714e-01  8.590570133307530e-02  3.007845627184786e-01
            8.509304155809109e-01  4.186980830272602e-01  3.171897588330935e-01
            9.182011388458675e-01  2.344257056322059e-01  3.192980694601741e-01
            8.913331828245734e-01  3.123731170922788e-01  3.285547030767773e-01
            9.435548389588052e-01  1.322105945503851e-02  3.309523673647153e-01
            9.287763238500607e-01  1.271705560825754e-01  3.481410488885444e-01
            8.555530998632951e-01  3.390732459855849e-01  3.912265675680854e-01
            9.252720117731869e-01  4.045608754377988e-02  3.771405695623975e-01
            9.277415557170323e-01  0.000000000000000e+00  3.732232653462813e-01
            8.775266181491069e-01  2.471639036696268e-01  4.109221813951917e-01
            8.975532203295111e-01  1.693656352954984e-01  4.070792284765660e-01
            8.983558680656374e-01  7.408529469637057e-02  4.329758693296741e-01
            8.972415090403990e-01  1.491547359156617e-02  4.412881180163895e-01
            8.295674963046556e-01  2.772365386676419e-01  4.847243244385516e-01
            8.499661095389294e-01  1.849265925009932e-01  4.933150798640038e-01
            8.791201377995146e-01  0.000000000000000e+00  4.766002342795926e-01
            8.634318737357770e-01  1.072696840264604e-01  4.929286097458622e-01
            8.570997633692103e-01  3.722225851006572e-02  5.138039500664172e-01
            8.041436757492081e-01  2.301206907106806e-01  5.480852273683279e-01
            8.118657817496955e-01  1.341279697635710e-01  5.682285105052882e-01
            8.091095562299540e-01  6.850694949105407e-02  5.836510292022085e-01
            8.155014871254748e-01  0.000000000000000e+00  5.787549779450188e-01
            7.835775105102831e-01  2.405675180607368e-02  6.208281225226899e-01
            7.493306364116992e-01  7.240345695103207e-14  6.621960414672062e-01
            4.453726137922331e-01  8.126179738669047e-01  3.758926222105467e-01
            1.265125044617474e-01  7.502734977253046e-01  6.489100591190229e-01
            6.588408248109752e-01  7.436715995900898e-01  1.134959009194219e-01
            3.520875065755893e-01  8.023395400283249e-01  4.819602164292405e-01
            5.310056369689388e-01  7.855003132097517e-01  3.178400092099695e-01
            7.044969160098101e-01  7.062386136375318e-01  7.007935459180305e-02
            7.762806103068899e-02  7.046537302834521e-01  7.052921412707158e-01
            2.920869351744425e-01  7.636866951972164e-01  5.757324499098125e-01
            6.050195366377151e-01  7.520678000875131e-01  2.614295016982835e-01
            4.412876646778531e-01  7.743582172328051e-01  4.534694569727915e-01
            2.187406002984079e-01  7.315391530543754e-01  6.457577079134086e-01
            5.183158722596223e-01  7.525750536111125e-01  4.061766182905880e-01
            6.780487295005478e-01  7.090511215844058e-01  1.936399426838096e-01
            3.950731604667277e-01  7.470219468574394e-01  5.346731794209921e-01
            1.758689693180086e-01  6.822664419723392e-01  7.096355457482566e-01
            7.308572435310354e-01  6.671603329965279e-01  1.440304816841863e-01
            5.996181347328624e-01  7.199705935906773e-01  3.494287293056635e-01
            1.215927461486920e-01  6.527637866587562e-01  7.477396892708997e-01
            3.454554744213688e-01  7.133047421383899e-01  6.098006723800755e-01
            4.916002163798176e-01  7.196392632001941e-01  4.903555425566211e-01
            6.695949639118485e-01  6.845062379930290e-01  2.882599425041940e-01
            2.803715216235913e-01  6.821953611923807e-01  6.752786824934349e-01
            5.743225407365701e-01  6.872596749893644e-01  4.447783249388440e-01
            4.440960092529121e-01  6.870722637211013e-01  5.750742899754767e-01
            7.330092718856617e-01  6.357898302164398e-01  2.418030171916866e-01
            6.449652927252409e-01  6.555055130751698e-01  3.928514903979653e-01
            2.515878465020664e-01  6.231721097896555e-01  7.405133875040762e-01
            3.919520603585099e-01  6.521377912280945e-01  6.489143885235257e-01
            5.324817080777715e-01  6.581080853757051e-01  5.323128577497472e-01
            7.098979235668059e-01  6.173671191673702e-01  3.389731232509734e-01
            3.380981287043914e-01  6.157428868594080e-01  7.117235085682017e-01
            4.907627753345674e-01  6.181120582935078e-01  6.140760390522303e-01
            6.127383309501797e-01  6.178522184064105e-01  4.927579263641176e-01
            7.715321180396051e-01  5.589955424037423e-01  3.037468920105468e-01
            6.795787163678060e-01  5.834461242562421e-01  4.447059571787352e-01
            4.442666906387546e-01  5.788383089498095e-01  6.837933311176806e-01
            5.694982738862041e-01  5.835735420488444e-01  5.788900042850971e-01
            7.426102000501174e-01  5.432641244505011e-01  3.916556930092490e-01
            3.953014127116769e-01  5.377377850131667e-01  7.446978364929535e-01
            6.450815058852835e-01  5.429560819499774e-01  5.376509498162396e-01
            5.330158849037714e-01  5.413983442233790e-01  6.502168094662221e-01
            3.460644594565078e-01  4.984961258810456e-01  7.948213650768730e-01
            7.112104415729141e-01  5.057765884188586e-01  4.882312468544397e-01
            4.923895888831147e-01  4.983678018394134e-01  7.135699172815994e-01
            8.018818709102994e-01  4.746459240104142e-01  3.629004159899766e-01
            6.131024456088501e-01  4.979949838188428e-01  6.132751317962578e-01
            7.690080493001850e-01  4.613963537100162e-01  4.424251630441309e-01
            4.419957501189791e-01  4.592737234769567e-01  7.705241098112199e-01
            6.854730196748471e-01  4.525643120469028e-01  5.703615368863509e-01
            5.749113659070153e-01  4.495365919194989e-01  6.836620319107476e-01
            7.483292317258530e-01  4.139948370181836e-01  5.182775664321987e-01
            5.188850165417044e-01  4.098203209212735e-01  7.502037351070038e-01
            6.518179144887046e-01  3.991281365907632e-01  6.448489256664546e-01
            8.077132604719887e-01  3.715641808707065e-01  4.577546814087108e-01
            4.596072392415065e-01  3.700231316891229e-01  8.073686070511874e-01
            7.177889718823314e-01  3.590644555247261e-01  5.965330742069864e-01
            6.013332705207685e-01  3.583035733971642e-01  7.141546380551058e-01
            5.515835942532590e-01  3.147699432017039e-01  7.724476819872348e-01
            7.704618884897190e-01  3.126505078607838e-01  5.555521022543699e-01
            6.784675186849193e-01  3.040744608184868e-01  6.687455034372008e-01
            6.335523514975044e-01  2.555321059277041e-01  7.302840274524256e-01
            7.359155601275823e-01  2.530741871222311e-01  6.279982039580437e-01
            6.943651943111773e-01  1.893476285961353e-01  6.942654049239533e-01
            7.707876290105894e-01  1.847802230385820e-01  6.097070609219200e-01
            6.475382271430949e-01  1.197704539183907e-01  7.525618132463010e-01
            7.388917229425961e-01  1.109407122672995e-01  6.646286031525772e-01
            6.952673547865620e-01  5.504897722267827e-02  7.166400180528811e-01
            0.000000000000000e+00  1.000000000000000e+00  0.000000000000000e+00
            8.078413196197513e-03  9.999673690877275e-01  0.000000000000000e+00
            2.525282816154280e-02  9.996810964851959e-01  0.000000000000000e+00
            5.500576715696934e-02  9.984860367473716e-01  0.000000000000000e+00
            9.574862815097512e-02  9.954055455979770e-01  0.000000000000000e+00
            1.517310355796234e-01  9.884218192866520e-01  0.000000000000000e+00
            2.236804205706301e-01  9.746625413205054e-01  0.000000000000000e+00
            3.161201630990678e-01  9.487191589096422e-01  0.000000000000000e+00
            4.169637417616839e-01  9.089231199920573e-01  0.000000000000000e+00
            5.206375156621563e-01  8.537778266534789e-01  0.000000000000000e+00
            6.152960244860282e-01  7.882961386761254e-01  0.000000000000000e+00
            0.000000000000000e+00  9.999673690877275e-01  8.078413196197513e-03
            1.304126940577356e-01  9.913938958000916e-01  1.143121161209125e-02
            2.362813320540053e-01  9.716100417836383e-01  1.204403703006746e-02
            4.678075391217192e-02  9.988388099633450e-01  1.151489359123986e-02
            1.376927905088106e-02  9.998392087263024e-01  1.148754316556262e-02
            3.535122984447324e-01  9.353035123883140e-01  1.537512804516745e-02
            4.633538352390074e-01  8.860106298894939e-01  1.698196372994424e-02
            5.635223572237132e-01  8.257933466136786e-01  2.253667228342454e-02
            0.000000000000000e+00  9.996810964851959e-01  2.525282816154280e-02
            7.197917000351640e-02  9.970074961230144e-01  2.819666221598341e-02
            6.715463148581330e-01  7.403867134464822e-01  2.920721747064814e-02
            1.200499854523505e-01  9.920577425719286e-01  3.754246124030208e-02
            1.851700677142735e-01  9.818852193478794e-01  4.016792313349003e-02
            1.061168863177834e-02  9.992148904100342e-01  3.817060187166688e-02
            3.347401012632853e-02  9.986853816133208e-01  3.882008755681151e-02
            2.649645357610038e-01  9.633493103986891e-01  4.185571577844161e-02
            3.796669516427995e-01  9.240647004611938e-01  4.424291120426306e-02
            0.000000000000000e+00  9.984860367473716e-01  5.500576715696934e-02
            6.086705717923442e-01  7.911489383759226e-01  6.002909578389079e-02
            4.988269830856226e-01  8.642915443782511e-01  6.458921939421168e-02
            7.432659916606604e-02  9.945500953411034e-01  7.311405140880134e-02
            1.341407013076167e-01  9.877190379948665e-01  8.010851537256380e-02
            1.709076577122736e-02  9.967449829606468e-01  7.878670362524856e-02
            3.020523986532109e-01  9.492792263181568e-01  8.736875270165873e-02
            2.083841020038832e-01  9.741002838205006e-01  8.777643814176590e-02
            3.894405631705647e-01  9.164497942819613e-01  9.195554533547255e-02
            0.000000000000000e+00  9.954055455979770e-01  9.574862815097512e-02
            5.465275038612262e-01  8.297094414140406e-01  1.135338291066507e-01
            3.865571219161151e-02  9.921473691756368e-01  1.189509720549685e-01
            4.395096311168302e-01  8.884542659847534e-01  1.322130909140279e-01
            8.182445455825307e-02  9.878073531804789e-01  1.324439188442448e-01
            2.300428229393794e-01  9.627469961716226e-01  1.421215007541049e-01
            1.431374760582878e-01  9.796358290566696e-01  1.408023628214908e-01
            1.197079229224603e-02  9.893315788238458e-01  1.451885920925357e-01
            3.118679572161910e-01  9.370955941689860e-01  1.568127056423523e-01
            0.000000000000000e+00  9.884218192866520e-01  1.517310355796234e-01
            5.921386644319226e-01  7.874237943749152e-01  1.712762976508728e-01
            4.846369640188781e-01  8.553577167708208e-01  1.830032498814512e-01
            4.016792313349003e-02  9.818852193478794e-01  1.851700677142735e-01
            3.613208338901741e-01  9.104014844913690e-01  2.015350888377030e-01
            8.802473995390483e-02  9.755031168803771e-01  2.016068305209840e-01
            1.543458335586899e-01  9.651712212687278e-01  2.112389104727293e-01
            2.235307336739937e-01  9.495709518243389e-01  2.198841025508325e-01
            5.365199335021674e-01  8.107230353596636e-01  2.342531128758883e-01
            0.000000000000000e+00  9.746625413205054e-01  2.236804205706301e-01
            4.069349704499031e-01  8.781792617679322e-01  2.514062728447048e-01
            1.264145476075192e-02  9.686771537436979e-01  2.480015432140291e-01
            2.722795231817665e-01  9.241898469577475e-01  2.678376150508457e-01
            4.748668801918811e-01  8.362869952811685e-01  2.740903274842522e-01
            4.185571577844161e-02  9.633493103986891e-01  2.649645357610038e-01
            9.399509403549836e-02  9.526304118547367e-01  2.892407659835187e-01
            3.197577812579618e-01  8.937665899262129e-01  3.145413232894115e-01
            1.605491356019994e-01  9.376135760741658e-01  3.083905916510187e-01
            0.000000000000000e+00  9.487191589096422e-01  3.161201630990678e-01
            3.775894967634435e-01  8.581850661112130e-01  3.477708501838851e-01
            2.061267232910495e-01  9.110313274026206e-01  3.571185999584931e-01
            5.081608317773282e-02  9.336145601024813e-01  3.546569876022804e-01
            1.537512804516745e-02  9.353035123883140e-01  3.535122984447324e-01
            9.389032506636169e-02  9.196123436188843e-01  3.814416656878429e-01
            2.514062728447048e-01  8.781792617679322e-01  4.069349704499031e-01
            3.121610272757648e-01  8.485478335149254e-01  4.272260142913419e-01
            1.405621316900073e-01  8.905922515863527e-01  4.325363898553642e-01
            0.000000000000000e+00  9.089231199920573e-01  4.169637417616839e-01
            2.808017813040093e-02  8.962320386615001e-01  4.426958735665111e-01
            1.842910531590948e-01  8.531392402967549e-01  4.880473792485596e-01
            2.544597604217006e-01  8.241029733915363e-01  5.060677025590150e-01
            6.700339564253828e-02  8.681934682858000e-01  4.916814482957874e-01
            0.000000000000000e+00  8.537778266534789e-01  5.206375156621563e-01
            1.127979606049508e-01  8.321320224275228e-01  5.429851907133793e-01
            2.425887682359314e-02  8.296398241742717e-01  5.577716997476130e-01
            1.813827552844898e-01  7.941592255541841e-01  5.800098452203941e-01
            6.299834652638610e-02  7.948999092507009e-01  6.034611359550578e-01
            0.000000000000000e+00  7.912087296876310e-01  6.115461929127557e-01
            2.636485300517772e-02  7.514660220389231e-01  6.592448044899649e-01
            ];
        
        
    case 18
        pts=[
            5.318883027960986e-01  2.605473559854457e-01  8.057356319771884e-01
            2.657475074647247e-01  5.246402974708048e-01  8.087835436914079e-01
            6.583251963512415e-01  6.621492344727994e-02  7.498156571864648e-01
            4.806180907437007e-01  2.996425368861368e-01  8.241484095345449e-01
            6.730347059433314e-01  2.299580107215627e-02  7.392533244624764e-01
            2.175124021682849e-02  6.713538826061265e-01  7.408176886783341e-01
            3.262849068525435e-01  4.397185503808809e-01  8.367710296199097e-01
            3.911472524835763e-01  3.649504537498212e-01  8.448757264724494e-01
            5.497030787414839e-01  1.696375804303680e-01  8.179545320663394e-01
            1.973178354490195e-01  5.100002618877048e-01  8.372367674010658e-01
            9.264326219181955e-02  5.832974442390543e-01  8.069580642850316e-01
            5.736912325204964e-01  1.027492476137048e-01  8.126013548130051e-01
            4.801261308480630e-01  2.216337786641685e-01  8.487386916076767e-01
            6.285685920482699e-01  0.000000000000000e+00  7.777541546597200e-01
            2.556938723569562e-01  4.378648767444634e-01  8.619135648965390e-01
            0.000000000000000e+00  6.253001760639154e-01  7.803843218661152e-01
            3.975202478810025e-01  2.833183833145185e-01  8.727590424628517e-01
            3.173103927910481e-01  3.585691028510420e-01  8.779193089956442e-01
            5.688129757326192e-01  4.058161473455740e-02  8.214651125785797e-01
            3.452268774929357e-02  5.698707669079750e-01  8.210088264167940e-01
            1.227120129516119e-01  5.030020661314802e-01  8.555294754389385e-01
            4.834766724807102e-01  1.461705652248474e-01  8.630668995094347e-01
            1.826039131306526e-01  4.334697254331943e-01  8.824736868837757e-01
            1.091921762117361e-02  5.611940139260675e-01  8.276122578962267e-01
            3.983049286444325e-01  2.058955952160693e-01  8.938457292442439e-01
            5.485102714158364e-01  1.312913006219688e-02  8.360407335143040e-01
            2.462240015773118e-01  3.500978594596322e-01  9.037727755631056e-01
            4.900293067752873e-01  7.663367390608440e-02  8.683309038177711e-01
            3.184148648983379e-01  2.707583339166858e-01  9.084612806424023e-01
            6.928802400608434e-02  4.907681808277140e-01  8.685308068320827e-01
            0.000000000000000e+00  5.407462269734356e-01  8.411857809152470e-01
            5.407462269734356e-01  0.000000000000000e+00  8.411857809152470e-01
            1.174878781938549e-01  4.154646019574647e-01  9.019898907403737e-01
            4.086582951984504e-01  1.230916558585044e-01  9.043488497385882e-01
            2.826991244222659e-02  4.681153225390804e-01  8.832150682900748e-01
            1.810538994674153e-01  3.339531192501575e-01  9.250377287606885e-01
            4.601359221771637e-01  3.353215811708003e-02  8.872150401645490e-01
            3.252457076549517e-01  1.834466097404450e-01  9.276651179314475e-01
            2.457439167198083e-01  2.567176780407582e-01  9.347223979217409e-01
            3.861919067189404e-01  6.641332958896470e-02  9.200245001290437e-01
            4.410535061655606e-01  0.000000000000000e+00  8.974808102121549e-01
            6.049568824041476e-02  3.908242926567814e-01  9.184751733028199e-01
            0.000000000000000e+00  4.353473073043945e-01  9.002625850399498e-01
            1.117356124255846e-01  3.286347440668227e-01  9.378242681377005e-01
            3.109538374814204e-01  1.182523977236757e-01  9.430398090156004e-01
            3.960806241006871e-01  1.183835405769964e-02  9.181394189256959e-01
            1.688700766592110e-01  2.532463245832642e-01  9.525487894560468e-01
            1.303323324852923e-02  3.905260299125513e-01  9.204996223746268e-01
            2.366850070439961e-01  1.817354307480195e-01  9.544382854073988e-01
            3.347591448509326e-01  3.613882602899180e-02  9.416104822015942e-01
            4.044266872145370e-02  3.215167834025320e-01  9.460398239699933e-01
            2.759877074070537e-01  7.671272612190151e-02  9.580949551120415e-01
            9.304296672693298e-02  2.601555071426107e-01  9.610734199040268e-01
            3.407591309333717e-01  0.000000000000000e+00  9.401506340398506e-01
            0.000000000000000e+00  3.347509299698200e-01  9.423066458878133e-01
            2.078090045474834e-01  1.303977443815789e-01  9.694389335534139e-01
            1.476240043163145e-01  1.892701211306789e-01  9.707646339853935e-01
            2.958505861458854e-01  1.036257216388221e-02  9.551780188924389e-01
            1.156622715899517e-02  2.823113584713098e-01  9.592531049037006e-01
            4.224898830842275e-02  2.442774443302208e-01  9.687845752170141e-01
            2.485487069622850e-01  3.582558908963837e-02  9.679566454308564e-01
            8.412351678936915e-02  1.859474307078851e-01  9.789518818287878e-01
            1.910381893176527e-01  7.566688815334525e-02  9.786618068870481e-01
            1.342398210261236e-01  1.282606383622733e-01  9.826132907190785e-01
            0.000000000000000e+00  2.461209946455008e-01  9.692391118783380e-01
            2.461209946455008e-01  0.000000000000000e+00  9.692391118783381e-01
            2.157603015741147e-01  1.024757465837950e-02  9.763925847108160e-01
            1.056980838056636e-02  2.133397637706519e-01  9.769208895018473e-01
            3.768043831462555e-02  1.726516126580120e-01  9.842619596504812e-01
            1.740212354431176e-01  3.533318358942144e-02  9.841078069765971e-01
            1.257489630737922e-01  7.449060415874365e-02  9.892615165758403e-01
            7.802945287106243e-02  1.216533611989201e-01  9.895008156609310e-01
            0.000000000000000e+00  1.701560271189622e-01  9.854171332157216e-01
            1.701560271189622e-01  0.000000000000000e+00  9.854171332157216e-01
            1.151354179886387e-02  1.559411877451389e-01  9.876992377843983e-01
            1.441121645222624e-01  1.008834352881619e-02  9.895099339377816e-01
            3.368099632692695e-02  1.154187772968562e-01  9.927457359937258e-01
            1.101864191510650e-01  3.232554183553664e-02  9.933851279235586e-01
            7.274773057947154e-02  6.980904304390795e-02  9.949042492646367e-01
            0.000000000000000e+00  1.096610511512588e-01  9.939690406951320e-01
            1.096610511512587e-01  0.000000000000000e+00  9.939690406951320e-01
            3.117682681307636e-02  6.542367510341375e-02  9.973704167488779e-01
            9.956079805640231e-03  8.610293564386599e-02  9.962364985024450e-01
            5.924744952176854e-02  3.419606009862211e-02  9.976574408076636e-01
            8.122258096036625e-02  9.906491416673793e-03  9.966467547581480e-01
            0.000000000000000e+00  6.462233182091234e-02  9.979097926315924e-01
            6.137842534285868e-02  2.895100275752153e-13  9.981145670224592e-01
            1.186217049265689e-02  3.854786620957250e-02  9.991863444432636e-01
            3.793424302933981e-02  1.110247857411674e-02  9.992185587624473e-01
            0.000000000000000e+00  3.109634792381645e-02  9.995163916343749e-01
            2.884177988551446e-02  7.154825856809223e-14  9.995839893340807e-01
            1.081765431476669e-02  1.098685741697095e-02  9.998811265941694e-01
            0.000000000000000e+00  9.614798851684926e-03  9.999537767532266e-01
            8.376270106276151e-03  -1.419511908163572e-13  9.999649184341952e-01
            0.000000000000000e+00  0.000000000000000e+00  1.000000000000000e+00
            7.830475460196847e-01  6.219618482451715e-01  0.000000000000000e+00
            8.442229520402291e-01  5.359921708835691e-01  0.000000000000000e+00
            9.002625850399498e-01  4.353473073043945e-01  0.000000000000000e+00
            9.423066458878133e-01  3.347509299698200e-01  0.000000000000000e+00
            9.692391118783380e-01  2.461209946455008e-01  0.000000000000000e+00
            9.854171332157216e-01  1.701560271189622e-01  0.000000000000000e+00
            9.939690406951320e-01  1.096610511512588e-01  0.000000000000000e+00
            9.979097926315924e-01  6.462233182091234e-02  0.000000000000000e+00
            9.995163916343749e-01  3.109634792381645e-02  0.000000000000000e+00
            9.999537767532266e-01  9.614798851684926e-03  0.000000000000000e+00
            1.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
            7.120901574839104e-01  7.020739040158452e-01  4.454314143544034e-03
            9.999649184341952e-01  -1.419511908163572e-13  8.376270106276151e-03
            9.962364985024449e-01  8.610293564386598e-02  9.956079805640229e-03
            9.769208895018472e-01  2.133397637706519e-01  1.056980838056636e-02
            9.592531049037007e-01  2.823113584713098e-01  1.156622715899517e-02
            9.998811265941694e-01  1.098685741697095e-02  1.081765431476669e-02
            9.876992377843982e-01  1.559411877451388e-01  1.151354179886387e-02
            8.275142025426839e-01  5.613244625689704e-01  1.162292182725642e-02
            9.991863444432636e-01  3.854786620957250e-02  1.186217049265689e-02
            9.229108996723105e-01  3.847457617769088e-01  1.435862321924787e-02
            7.506439591042124e-01  6.601506421059130e-01  2.710675907415305e-02
            8.801593868176383e-01  4.737873471684829e-01  2.906894321866910e-02
            9.995839893340807e-01  7.154825856809223e-14  2.884177988551446e-02
            9.973704167488779e-01  6.542367510341375e-02  3.117682681307636e-02
            9.927457359937258e-01  1.154187772968562e-01  3.368099632692695e-02
            9.842619596504812e-01  1.726516126580120e-01  3.768043831462555e-02
            9.460398239699933e-01  3.215167834025320e-01  4.044266872145370e-02
            9.992185587624473e-01  1.110247857411674e-02  3.793424302933981e-02
            8.200399880986522e-01  5.708769261055519e-01  4.042218647523727e-02
            9.687845752170141e-01  2.442774443302208e-01  4.224898830842275e-02
            9.187352702265917e-01  3.905506278792850e-01  5.827272350566565e-02
            9.976574408076636e-01  3.419606009862211e-02  5.924744952176854e-02
            9.981145670224592e-01  2.895100275752153e-13  6.137842534285868e-02
            8.643994313502883e-01  4.970917456067311e-01  7.558716512048384e-02
            9.949042492646367e-01  6.980904304390795e-02  7.274773057947154e-02
            9.895008156609310e-01  1.216533611989201e-01  7.802945287106243e-02
            9.789518818287879e-01  1.859474307078851e-01  8.412351678936916e-02
            9.966467547581481e-01  9.906491416673793e-03  8.122258096036626e-02
            9.610734199040268e-01  2.601555071426107e-01  9.304296672693298e-02
            8.082252509410703e-01  5.800663349516730e-01  1.014642340777143e-01
            9.378242681377005e-01  3.286347440668227e-01  1.117356124255846e-01
            9.019898907403737e-01  4.154646019574647e-01  1.174878781938549e-01
            9.933851279235586e-01  3.232554183553664e-02  1.101864191510650e-01
            9.939690406951320e-01  0.000000000000000e+00  1.096610511512587e-01
            9.892615165758403e-01  7.449060415874365e-02  1.257489630737922e-01
            9.826132907190785e-01  1.282606383622733e-01  1.342398210261236e-01
            9.707646339853935e-01  1.892701211306789e-01  1.476240043163145e-01
            8.681906300259460e-01  4.723283110895955e-01  1.521545151429996e-01
            9.895099339377816e-01  1.008834352881619e-02  1.441121645222624e-01
            8.196522417567937e-01  5.491502613253614e-01  1.631079184753148e-01
            9.525487894560468e-01  2.532463245832642e-01  1.688700766592110e-01
            9.240654729140512e-01  3.398161287977570e-01  1.750085722958660e-01
            9.854171332157216e-01  0.000000000000000e+00  1.701560271189622e-01
            9.841078069765971e-01  3.533318358942144e-02  1.740212354431176e-01
            9.786618068870481e-01  7.566688815334525e-02  1.910381893176527e-01
            9.694389335534138e-01  1.303977443815789e-01  2.078090045474834e-01
            8.941526286815950e-01  3.925606354201360e-01  2.153769350240017e-01
            8.493811518651848e-01  4.778836399047121e-01  2.240064409064957e-01
            9.763925847108160e-01  1.024757465837950e-02  2.157603015741147e-01
            9.544382854073988e-01  1.817354307480195e-01  2.366850070439961e-01
            9.337242581040359e-01  2.626849584204837e-01  2.432192888068227e-01
            9.679566454308564e-01  3.582558908963837e-02  2.485487069622850e-01
            9.692391118783381e-01  0.000000000000000e+00  2.461209946455008e-01
            9.066803730448978e-01  3.135268659108696e-01  2.821907253742981e-01
            8.698879919400629e-01  4.019345313241750e-01  2.859082265477871e-01
            9.580949551120415e-01  7.671272612190151e-02  2.759877074070537e-01
            8.212923486260636e-01  4.866210829585539e-01  2.977898583036850e-01
            9.551780188924389e-01  1.036257216388221e-02  2.958505861458854e-01
            9.430398090156004e-01  1.182523977236757e-01  3.109538374814204e-01
            9.291374784924092e-01  1.888322213399577e-01  3.178772376949709e-01
            9.416104822015942e-01  3.613882602899180e-02  3.347591448509326e-01
            8.770380827353003e-01  3.209896170651769e-01  3.574491112988529e-01
            9.026366004762464e-01  2.408598915380786e-01  3.566983040735546e-01
            8.380598459235691e-01  4.090722720627641e-01  3.609924803648569e-01
            9.401506340398506e-01  0.000000000000000e+00  3.407591309333717e-01
            9.200245001290437e-01  6.641332958896470e-02  3.861919067189404e-01
            9.069528168392000e-01  1.277717122035577e-01  4.013863196323610e-01
            9.181394189256961e-01  1.183835405769964e-02  3.960806241006871e-01
            8.383152061704250e-01  3.325886051020480e-01  4.319866142135794e-01
            8.620555944087874e-01  2.521474508786472e-01  4.396382776373234e-01
            8.800845143645354e-01  1.778684542340877e-01  4.402431834385581e-01
            8.974808102121549e-01  0.000000000000000e+00  4.410535061655606e-01
            8.872150401645490e-01  3.353215811708003e-02  4.601359221771637e-01
            8.716804392404293e-01  8.044168936668210e-02  4.834277055128784e-01
            8.123552371142557e-01  2.734975430074238e-01  5.150515146098918e-01
            8.333904581740820e-01  1.922258405888934e-01  5.181790910817293e-01
            8.433199054064037e-01  1.261632346424290e-01  5.223929319677802e-01
            8.411857809152470e-01  0.000000000000000e+00  5.407462269734356e-01
            8.250237226225779e-01  4.337896399734866e-02  5.634306723923540e-01
            7.967723924759983e-01  8.597920679254453e-02  5.981315328482512e-01
            8.098668076883772e-01  1.300008379833459e-02  5.864697363256466e-01
            7.803843218661152e-01  0.000000000000000e+00  6.253001760639154e-01
            7.516927323278122e-01  4.472261147436471e-02  6.579953831057336e-01
            7.107545891092425e-01  2.409715989315684e-13  7.034400571904842e-01
            2.057495381089435e-01  7.858852965975158e-01  5.831392871002528e-01
            4.025390232951133e-01  8.136965628409839e-01  4.193569342998695e-01
            6.220197902769098e-01  7.633705789423927e-01  1.742318561831484e-01
            4.617758907174600e-01  8.015343080319086e-01  3.798760058228291e-01
            1.415117282757778e-01  7.424841543371986e-01  6.547455317286078e-01
            3.669533373914953e-01  7.922474546171659e-01  4.875338130118413e-01
            5.487874608145267e-01  7.704299300365632e-01  3.244534569959156e-01
            6.933771572407829e-01  7.092059512956431e-01  1.274952409446428e-01
            3.093095848168172e-01  7.581660026370552e-01  5.740312649898061e-01
            7.646630617597855e-02  6.819084725063539e-01  7.274295423914627e-01
            4.444059462428087e-01  7.679994305117678e-01  4.611726679646513e-01
            6.253497477231821e-01  7.364317347483772e-01  2.580813691029405e-01
            7.356368990949997e-01  6.731720401935827e-01  7.535089243998797e-02
            2.446642482009118e-01  7.254310952506272e-01  6.433421575614007e-01
            5.178754241690375e-01  7.460155528933744e-01  4.186476321238809e-01
            4.077742833170499e-01  7.379463715355947e-01  5.377316120544862e-01
            6.930618390951164e-01  6.911444829766710e-01  2.049014173718799e-01
            1.902731090366400e-01  6.852674290004190e-01  7.029969379226957e-01
            5.899889727322254e-01  7.188592215320916e-01  3.676335562386119e-01
            1.315637261986897e-01  6.461092694918724e-01  7.518203228334513e-01
            3.606073986958111e-01  7.049631205526369e-01  6.107285015999568e-01
            4.988426686455287e-01  7.118425774644234e-01  4.944048309304975e-01
            6.648571957515971e-01  6.798701261731694e-01  3.094212675214834e-01
            3.050473649159925e-01  6.734040782315657e-01  6.734040782315657e-01
            7.570764578427172e-01  6.286290429170969e-01  1.779347166279230e-01
            4.539943128748704e-01  6.803225374230371e-01  5.753698019113922e-01
            5.770174163296805e-01  6.797608633507564e-01  4.527428297707811e-01
            2.574362080278589e-01  6.347226281354444e-01  7.285971343129695e-01
            7.287321330261078e-01  6.317966334519831e-01  2.641637602964487e-01
            6.435547748070906e-01  6.528029015725206e-01  3.996068361796291e-01
            4.119232618244384e-01  6.443288082834397e-01  6.443288082834397e-01
            5.372620397433306e-01  6.515839507438193e-01  5.355257750882882e-01
            2.061280761365203e-01  5.937236176261456e-01  7.778196976813967e-01
            7.071350389482626e-01  6.119996839641897e-01  3.541418127239019e-01
            3.606073986958111e-01  6.107285015999568e-01  7.049631205526369e-01
            4.978614376430706e-01  6.132430141909384e-01  6.132430141909384e-01
            6.130033205729545e-01  6.126397011034800e-01  4.988983118816604e-01
            7.923096010169129e-01  5.615540904899755e-01  2.385424481940194e-01
            3.159713397737277e-01  5.679617522130967e-01  7.599878686299040e-01
            6.762895801130226e-01  5.843372811818622e-01  4.485335501961263e-01
            7.660264243621421e-01  5.563825983538740e-01  3.219346539718005e-01
            4.539943128748704e-01  5.753698019113922e-01  6.803225374230371e-01
            5.719217536029145e-01  5.800454756981417e-01  5.800454756981417e-01
            7.386231728598919e-01  5.353820715061040e-01  4.096362362196726e-01
            4.075468573649075e-01  5.346830501842949e-01  7.402834557773169e-01
            6.433743752156440e-01  5.413268020871864e-01  5.413268020871864e-01
            5.375080203725384e-01  5.398589106078638e-01  6.477943228158807e-01
            7.066841297133599e-01  5.111668725849653e-01  4.891890934832632e-01
            7.912375954651498e-01  4.840597386073330e-01  3.736699572910945e-01
            3.736579454498611e-01  4.821359248113049e-01  7.924169923774581e-01
            4.992170568078203e-01  4.982827351032270e-01  7.088699782683597e-01
            6.130033205729545e-01  4.988983118816604e-01  6.126397011034800e-01
            7.663738945562623e-01  4.601618649277289e-01  4.482433622586079e-01
            4.584399701113203e-01  4.564833612498990e-01  7.625324482973337e-01
            6.823036795002144e-01  4.613919224379269e-01  5.670795207459909e-01
            5.770174163296805e-01  4.527428297707811e-01  6.797608633507564e-01
            4.167818070496513e-01  4.172075347102400e-01  8.076080722067055e-01
            7.433857788632854e-01  4.245761766279736e-01  5.168294244949664e-01
            5.313522270633509e-01  4.153961183952310e-01  7.383162436361485e-01
            6.507518250211358e-01  4.107511349346840e-01  6.385965607341856e-01
            7.939405509809252e-01  3.846169197990411e-01  4.708802677033760e-01
            4.893013976472249e-01  3.734967575448214e-01  7.880890269277814e-01
            7.144508363817795e-01  3.731896977350598e-01  5.918525592559268e-01
            6.083355771707488e-01  3.655371797595196e-01  7.044930061837296e-01
            7.679811665702881e-01  3.341820053179213e-01  5.463765323611842e-01
            5.674048959695379e-01  3.193381986882507e-01  7.589959149352131e-01
            6.773435225876495e-01  3.204826000757692e-01  6.621907998886943e-01
            7.341033092498959e-01  2.718115965071377e-01  6.222626353498920e-01
            6.386675328217823e-01  2.666866100438837e-01  7.217908523545024e-01
            5.972066937565375e-01  2.189838751692184e-01  7.716153363874110e-01
            7.759104165023695e-01  2.128740318335426e-01  5.938414537012817e-01
            7.014422541980124e-01  2.059747928842919e-01  6.823145526235564e-01
            6.407855422287192e-01  1.552043528062672e-01  7.518680055306478e-01
            7.642689981144709e-01  1.452135597552938e-01  6.283358342354018e-01
            7.029470768868916e-01  1.177145134218782e-01  7.014333185884634e-01
            0.000000000000000e+00  1.000000000000000e+00  0.000000000000000e+00
            7.222955193124928e-03  9.999739141189025e-01  0.000000000000000e+00
            2.258269328289889e-02  9.997449784640533e-01  0.000000000000000e+00
            4.921354935445554e-02  9.987882791462546e-01  0.000000000000000e+00
            8.575484589765472e-02  9.963162682627789e-01  0.000000000000000e+00
            1.361842881800728e-01  9.906835214400647e-01  0.000000000000000e+00
            2.015633688564060e-01  9.794754761275325e-01  0.000000000000000e+00
            2.810382547890751e-01  9.596965662880694e-01  0.000000000000000e+00
            3.767241953286081e-01  9.263254723119799e-01  0.000000000000000e+00
            4.744679133924928e-01  8.802727981489454e-01  0.000000000000000e+00
            5.679373203184634e-01  8.230718074320630e-01  0.000000000000000e+00
            6.494961155257708e-01  7.603649097091045e-01  0.000000000000000e+00
            0.000000000000000e+00  9.999739141189025e-01  7.222955193124928e-03
            9.123937945994771e-03  9.999112341873492e-01  9.709660256138094e-03
            1.169723651230253e-01  9.930823369975892e-01  1.024391238406219e-02
            2.022550280805570e-01  9.792750348530023e-01  1.064470430704386e-02
            6.250645543155744e-01  7.804948152386855e-01  1.105198279959416e-02
            2.969579700253218e-02  9.994954599329001e-01  1.126877162360205e-02
            3.177120658891386e-01  9.481072432544099e-01  1.231659356229777e-02
            6.450391968851873e-02  9.978197665176739e-01  1.396273223376431e-02
            5.140265388376739e-01  8.576097463204598e-01  1.680001150945927e-02
            4.084835736646887e-01  9.125771645923719e-01  1.854962831627522e-02
            0.000000000000000e+00  9.997449784640533e-01  2.258269328289889e-02
            1.110606190552533e-02  9.994089816507337e-01  3.253218075681352e-02
            2.368120430773113e-01  9.709363722011352e-01  3.467877435043525e-02
            1.027994090768738e-01  9.941257030009165e-01  3.385805851461379e-02
            1.622002898690621e-01  9.861330158320616e-01  3.511041230682600e-02
            3.170265897498817e-01  9.475636531728771e-01  4.021522817580113e-02
            3.925840450256737e-02  9.984575881587687e-01  3.925840450256737e-02
            5.692868428676293e-01  8.207913889424702e-01  4.705301664822246e-02
            6.683286605242955e-01  7.422515064340903e-01  4.898471923084356e-02
            0.000000000000000e+00  9.987882791462546e-01  4.921354935445554e-02
            4.482238178945213e-01  8.922826856114731e-01  5.410192260942386e-02
            6.608175802066397e-02  9.956236249275110e-01  6.608175802066397e-02
            1.560272885147150e-02  9.976631609994235e-01  6.651895998154143e-02
            1.199761802376349e-01  9.901216732778526e-01  7.255886080315559e-02
            3.401381110306438e-01  9.372453547351968e-01  7.666296662535721e-02
            1.839029057334871e-01  9.798937804211987e-01  7.738152463367376e-02
            2.594251740754128e-01  9.622409313293699e-01  8.240733662926224e-02
            5.016628690282849e-01  8.601706972139194e-01  9.187348634306677e-02
            0.000000000000000e+00  9.963162682627789e-01  8.575484589765472e-02
            6.105142632392927e-01  7.864512903349087e-01  9.363066971853246e-02
            3.385805851461379e-02  9.941257030009165e-01  1.027994090768738e-01
            3.894129429534255e-01  9.143822692709874e-01  1.107367396268809e-01
            1.024391238406219e-02  9.930823369975892e-01  1.169723651230253e-01
            7.110567531951864e-02  9.900516150261740e-01  1.214157424777352e-01
            1.249675426070393e-01  9.842592273326757e-01  1.249675426070393e-01
            1.900216546842275e-01  9.724908727553757e-01  1.347340831362136e-01
            5.489440019351280e-01  8.241776936087030e-01  1.392537687004744e-01
            2.745245888349092e-01  9.511622476346617e-01  1.411617115212288e-01
            0.000000000000000e+00  9.906835214400647e-01  1.361842881800728e-01
            4.364363172690483e-01  8.863906405330029e-01  1.543857938546266e-01
            3.393940978056737e-02  9.859855855307408e-01  1.633417937618817e-01
            3.234316532578314e-01  9.294466882416832e-01  1.775410357846132e-01
            7.738152463367376e-02  9.798937804211987e-01  1.839029057334871e-01
            1.987568534155134e-01  9.596829822606673e-01  1.987568534155134e-01
            4.840725932048322e-01  8.509912566130003e-01  2.036850649315641e-01
            1.272422071776492e-01  9.707163234251523e-01  2.037627054897810e-01
            1.064470430704386e-02  9.792750348530023e-01  2.022550280805570e-01
            0.000000000000000e+00  9.794754761275325e-01  2.015633688564060e-01
            3.700711020915224e-01  9.016408414878799e-01  2.238105724888654e-01
            5.603028988627156e-01  7.963357841626302e-01  2.278376184657101e-01
            2.420136099891974e-01  9.396056753553553e-01  2.420136099891974e-01
            3.327220055509146e-02  9.706603991485181e-01  2.381414499726191e-01
            4.159209677230604e-01  8.689681063825920e-01  2.681495453998852e-01
            7.559085698351892e-02  9.610544541076953e-01  2.658201621026083e-01
            1.411617115212288e-01  9.511622476346617e-01  2.745245888349092e-01
            4.952196121231099e-01  8.221357030735248e-01  2.808031721694710e-01
            2.865703998185197e-01  9.141962655227309e-01  2.865703998185197e-01
            0.000000000000000e+00  9.579463438804395e-01  2.869473858499130e-01
            1.775410357846132e-01  9.294466882416832e-01  3.234316532578314e-01
            3.316079333526214e-01  8.832170498100718e-01  3.316079333526214e-01
            3.912795474348228e-02  9.451901818532510e-01  3.241674309455073e-01
            1.254342844936271e-02  9.461233564272418e-01  3.235633737393436e-01
            3.903601316355313e-01  8.492285760371501e-01  3.555696742853715e-01
            7.782721571000756e-02  9.352584211363958e-01  3.453036492542241e-01
            2.238105724888654e-01  9.016408414878799e-01  3.700711020915224e-01
            1.120842290266939e-01  9.121851450059743e-01  3.941514770160341e-01
            0.000000000000000e+00  9.238795325112867e-01  3.826834323650897e-01
            2.699599734262308e-01  8.670568420556775e-01  4.187290835279355e-01
            3.319952294712177e-01  8.415719510013644e-01  4.260702041871863e-01
            1.744830561141147e-02  9.095354170903618e-01  4.152600169647354e-01
            1.558097075555451e-01  8.841475596371348e-01  4.404616076562801e-01
            5.471150359391403e-02  8.896905432118997e-01  4.532740767943916e-01
            2.049278024461021e-01  8.490054309450404e-01  4.870260506486668e-01
            0.000000000000000e+00  8.773320056379267e-01  4.798838941695511e-01
            2.715158732958290e-01  8.155627613415031e-01  5.110151786996410e-01
            9.615966526052977e-02  8.588460999715656e-01  5.031269177261485e-01
            1.846131391927117e-02  8.553213685044370e-01  5.177688060013574e-01
            1.392537687004744e-01  8.241776936087030e-01  5.489440019351280e-01
            5.002514689215443e-02  8.192689513322708e-01  5.712231350893795e-01
            0.000000000000000e+00  8.200858945133798e-01  5.722404438871738e-01
            8.942767049436240e-02  7.868135786733105e-01  6.106775615373877e-01
            1.245413415845994e-02  7.786110268186598e-01  6.273832667984980e-01
            4.594687192927929e-02  7.433628270686177e-01  6.673084686203726e-01
            0.000000000000000e+00  7.320066287480680e-01  6.812975087793057e-01
            ];
        
        
    case 19
        pts=[
            2.070210157085863e-01  5.804900215981619e-01  7.875110373067483e-01
            4.760682987942426e-01  3.258727176919926e-01  8.168022690634440e-01
            3.998467972894820e-01  4.055486526322917e-01  8.219810393466972e-01
            3.825780820593905e-02  6.785044320124197e-01  7.335993973898708e-01
            3.294519341359735e-01  4.693529314564488e-01  8.192491982463604e-01
            7.521764587445910e-02  6.441091463726748e-01  7.612264533686205e-01
            5.607718296122300e-01  1.924876567328602e-01  8.052847056282918e-01
            6.030057619013640e-01  1.283883811459634e-01  7.873375862363452e-01
            1.264765901293029e-01  6.021801285153351e-01  7.882783550057167e-01
            0.000000000000000e+00  6.625303808873522e-01  7.490350421717665e-01
            2.300927581943471e-01  5.043743570135498e-01  8.322642793089741e-01
            6.602236347229071e-01  -7.238820143749766e-14  7.510690728243796e-01
            4.883066830877159e-01  2.386824329072404e-01  8.393969737099092e-01
            2.781472180301839e-01  4.400291290066534e-01  8.538199404603499e-01
            1.657754130626809e-01  5.253871650584541e-01  8.345578705013442e-01
            4.113289278487418e-01  2.983684543936515e-01  8.612692834053401e-01
            6.192593708297233e-01  2.303605652587070e-02  7.848485024126073e-01
            3.411804565145897e-01  3.644546398426556e-01  8.664691059637708e-01
            1.549512454623512e-02  6.212210335419593e-01  7.834821814185416e-01
            5.681729846060659e-01  7.125783464780720e-02  8.198181387143987e-01
            4.942084852709802e-01  1.695993524946261e-01  8.526394506000570e-01
            5.129288181278852e-02  5.711938370286900e-01  8.192109867523638e-01
            1.035061002258211e-01  5.235878605643981e-01  8.456608300528284e-01
            2.024986033845560e-01  4.419514603412052e-01  8.738839867680266e-01
            4.132715296251877e-01  2.237355411690628e-01  8.826941998331269e-01
            5.823287563867023e-01  0.000000000000000e+00  8.129533931813784e-01
            2.679970168465893e-01  3.628918538750634e-01  8.924612604211168e-01
            0.000000000000000e+00  5.744166613913418e-01  8.185630697240284e-01
            3.364188898831431e-01  2.867871942946383e-01  8.969812906178161e-01
            4.901900994349412e-01  1.102033875038411e-01  8.646206565879864e-01
            5.298126038651872e-01  3.210920619409592e-02  8.475066982998867e-01
            1.396131110089533e-01  4.424257763849073e-01  8.858711032789215e-01
            1.991247680940144e-02  5.255820884293273e-01  8.505098245109117e-01
            4.094746645989919e-01  1.561559439406287e-01  8.988580645594466e-01
            1.962151306378211e-01  3.593314035883195e-01  9.123489271676879e-01
            7.175871799847611e-02  4.623085188649422e-01  8.838107941047781e-01
            3.312189557030524e-01  2.127589071398009e-01  9.192538554804418e-01
            4.584780030908159e-01  6.595027390512129e-02  8.862553142597777e-01
            2.575461125628161e-01  2.850219766963225e-01  9.232726968257550e-01
            4.978764883271529e-01  0.000000000000000e+00  8.672479474585237e-01
            4.883315494238625e-01  1.057573184107828e-02  8.725940933408358e-01
            0.000000000000000e+00  4.878799401564635e-01  8.729107422829241e-01
            1.135508318296629e-01  3.822072408771002e-01  9.170735159254715e-01
            3.754994080131468e-01  1.068865079998212e-01  9.206386201921906e-01
            2.996815714943371e-02  4.345774880607808e-01  9.001357211153488e-01
            4.233076723188023e-01  3.024859724873852e-02  9.054808871094525e-01
            1.640133977992589e-01  3.038602003540329e-01  9.384927191955988e-01
            8.603414167312355e-03  4.367812336424878e-01  8.995266172840091e-01
            2.964189896006212e-01  1.654450523071279e-01  9.406187948745434e-01
            2.248071588464443e-01  2.322722004546580e-01  9.463146232767095e-01
            6.270599740638839e-02  3.651147497418789e-01  9.288483069964627e-01
            4.079102323627030e-01  0.000000000000000e+00  9.130220382519830e-01
            3.473178792161373e-01  5.974218356948538e-02  9.358424879642697e-01
            0.000000000000000e+00  3.967447280977595e-01  9.179289845770395e-01
            1.052886748513732e-01  2.936781918245939e-01  9.500881088586882e-01
            2.833369675821152e-01  1.063199005019068e-01  9.531087249409881e-01
            3.648615317985048e-01  1.064720173278289e-02  9.310009128399982e-01
            2.006024293905793e-02  3.541378334578916e-01  9.349780647517762e-01
            1.553623109290977e-01  2.291086130346787e-01  9.609223671952360e-01
            2.161527660494333e-01  1.636831223620675e-01  9.625413327140728e-01
            4.890592868585181e-02  2.942872783485455e-01  9.544648804128836e-01
            3.080683989960089e-01  3.018340859705853e-02  9.508852840303602e-01
            3.173100852546694e-01  0.000000000000000e+00  9.483218387212615e-01
            2.544457994049930e-01  6.558822395788580e-02  9.648603629765317e-01
            8.829436670916559e-02  2.304305925864815e-01  9.690747374726421e-01
            0.000000000000000e+00  3.059626848190958e-01  9.520435050449588e-01
            1.925603434138589e-01  1.130335435405980e-01  9.747532673343509e-01
            1.331934503406057e-01  1.704931499466872e-01  9.763153131072057e-01
            1.166114897583846e-02  2.735045283079290e-01  9.618000263046474e-01
            2.698105712349171e-01  9.293663119370361e-03  9.628685701982962e-01
            3.742346922385664e-02  2.212271082678363e-01  9.745040023102532e-01
            2.213853280184025e-01  3.209105314640093e-02  9.746582482317271e-01
            1.744243760327655e-01  6.788350031940360e-02  9.823278309352566e-01
            7.480748613078886e-02  1.676026977665404e-01  9.830122968305989e-01
            1.193182287300090e-01  1.151904665746017e-01  9.861512646156566e-01
            2.286525663659358e-01  0.000000000000000e+00  9.735080913347722e-01
            0.000000000000000e+00  2.233482676195105e-01  9.747387092710351e-01
            1.084457702772187e-02  1.982844158901186e-01  9.800845298055696e-01
            1.956410617674203e-01  9.181598944409045e-03  9.806325882772510e-01
            3.472454163148690e-02  1.558236218881663e-01  9.871743539365966e-01
            1.533481900796825e-01  3.163439347521708e-02  9.876657317882102e-01
            6.834905020806230e-02  1.093300774152813e-01  9.916528331568586e-01
            1.105520751056437e-01  6.677888729351414e-02  9.916243335566530e-01
            0.000000000000000e+00  1.537318130320867e-01  9.881126098081471e-01
            1.537318130320867e-01  0.000000000000000e+00  9.881126098081471e-01
            1.063653954076172e-02  1.363131017942192e-01  9.906087029225196e-01
            1.301932193959806e-01  9.040679400452304e-03  9.914474225793763e-01
            3.089151710628435e-02  1.000456264732205e-01  9.945031859146823e-01
            9.966917328177213e-02  2.899092723609339e-02  9.945982013030787e-01
            6.303507642845270e-02  6.264041604263026e-02  9.960435519683191e-01
            0.000000000000000e+00  9.883441277585207e-02  9.951038934961779e-01
            9.883441277585207e-02  0.000000000000000e+00  9.951038934961779e-01
            9.009862049447849e-03  8.095687845793455e-02  9.966768815499821e-01
            7.654537194985579e-02  8.896749109733563e-03  9.970264058129737e-01
            2.835346805350485e-02  5.587300964738473e-02  9.980352136283981e-01
            5.364949320800846e-02  2.855688810388430e-02  9.981514093665079e-01
            0.000000000000000e+00  5.817123814857412e-02  9.983066197578087e-01
            5.524737714495754e-02  -7.216311520705926e-14  9.984726973325825e-01
            2.340534542423426e-02  2.421929172287222e-02  9.994326469122443e-01
            9.467984889904362e-03  3.698935273296578e-02  9.992708066617981e-01
            3.652214373634379e-02  8.772990440208716e-03  9.992943348461643e-01
            0.000000000000000e+00  2.797574007422290e-02  9.996086023876043e-01
            2.594666192419851e-02  2.143278222131490e-13  9.996633286937114e-01
            9.740965431978282e-03  9.877853838668077e-03  9.999037661675222e-01
            0.000000000000000e+00  8.647939190712417e-03  9.999626058747166e-01
            7.533882278378184e-03  -2.127754189635783e-13  9.999716199061929e-01
            0.000000000000000e+00  0.000000000000000e+00  1.000000000000000e+00
            7.596070217632693e-01  6.503823279332981e-01  0.000000000000000e+00
            8.185630697240284e-01  5.744166613913418e-01  0.000000000000000e+00
            8.729107422829241e-01  4.878799401564635e-01  0.000000000000000e+00
            9.179289845770395e-01  3.967447280977595e-01  0.000000000000000e+00
            9.520435050449588e-01  3.059626848190958e-01  0.000000000000000e+00
            9.747387092710351e-01  2.233482676195105e-01  0.000000000000000e+00
            9.881126098081471e-01  1.537318130320867e-01  0.000000000000000e+00
            9.951038934961779e-01  9.883441277585207e-02  0.000000000000000e+00
            9.983066197578087e-01  5.817123814857412e-02  0.000000000000000e+00
            9.996086023876043e-01  2.797574007422290e-02  0.000000000000000e+00
            9.999626058747166e-01  8.647939190712417e-03  0.000000000000000e+00
            1.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
            9.999716199061929e-01  -2.127754189635783e-13  7.533882278378184e-03
            9.047331159100096e-01  4.258858173672447e-01  8.902782778382239e-03
            9.966768815499821e-01  8.095687845793455e-02  9.009862049447849e-03
            9.992708066617981e-01  3.698935273296578e-02  9.467984889904362e-03
            9.999037661675221e-01  9.877853838668075e-03  9.740965431978280e-03
            9.906087029225196e-01  1.363131017942192e-01  1.063653954076172e-02
            9.800845298055696e-01  1.982844158901186e-01  1.084457702772187e-02
            9.618000263046474e-01  2.735045283079290e-01  1.166114897583846e-02
            7.858967301508317e-01  6.181332335193415e-01  1.666238749861767e-02
            8.478960898037636e-01  5.298703310441443e-01  1.759696492742125e-02
            9.369158665410718e-01  3.487906413330476e-01  2.310297690934511e-02
            9.996633286937114e-01  2.143278222131490e-13  2.594666192419851e-02
            9.980352136283981e-01  5.587300964738473e-02  2.835346805350485e-02
            8.999834785803170e-01  4.347905181888879e-01  3.141565812632870e-02
            9.945031859146823e-01  1.000456264732205e-01  3.089151710628435e-02
            9.871743539365967e-01  1.558236218881664e-01  3.472454163148690e-02
            9.745040023102532e-01  2.212271082678363e-01  3.742346922385664e-02
            9.992943348461641e-01  8.772990440208715e-03  3.652214373634378e-02
            8.144445288358009e-01  5.784933483357215e-01  4.500617047423486e-02
            9.559768231521849e-01  2.888557584810602e-01  5.167847122533364e-02
            9.981514093665079e-01  2.855688810388430e-02  5.364949320800846e-02
            9.984726973325825e-01  -7.216311520705926e-14  5.524737714495754e-02
            9.288483069964627e-01  3.651147497418789e-01  6.270599740638839e-02
            9.960435519683190e-01  6.264041604263025e-02  6.303507642845270e-02
            9.916528331568586e-01  1.093300774152813e-01  6.834905020806230e-02
            8.838107941047781e-01  4.623085188649422e-01  7.175871799847611e-02
            7.648574161690647e-01  6.403250826641881e-01  7.054729932664211e-02
            9.830122968305989e-01  1.676026977665404e-01  7.480748613078886e-02
            9.970264058129739e-01  8.896749109733563e-03  7.654537194985579e-02
            9.699249764988225e-01  2.252725062448898e-01  9.218371816055600e-02
            8.326346043126202e-01  5.461142921077383e-01  9.208037606803360e-02
            9.505003183785429e-01  2.934254056487197e-01  1.022285482738217e-01
            9.945552595977638e-01  3.116974028976679e-02  9.943984561881213e-02
            9.951038934961779e-01  0.000000000000000e+00  9.883441277585207e-02
            9.170735159254715e-01  3.822072408771002e-01  1.135508318296629e-01
            9.916243335566530e-01  6.677888729351414e-02  1.105520751056437e-01
            9.861512646156566e-01  1.151904665746017e-01  1.193182287300090e-01
            8.816935376476751e-01  4.529196144163428e-01  1.322131935446653e-01
            9.914474225793763e-01  9.040679400452304e-03  1.301932193959806e-01
            9.764554968908391e-01  1.657937334623012e-01  1.380112333699542e-01
            7.881458481027244e-01  5.968106463384534e-01  1.504764916374472e-01
            9.609223671952360e-01  2.291086130346787e-01  1.553623109290977e-01
            8.398391600938071e-01  5.195458403475649e-01  1.572968688514533e-01
            9.876657317882103e-01  3.163439347521709e-02  1.533481900796825e-01
            9.384927191955988e-01  3.038602003540329e-01  1.640133977992589e-01
            9.881126098081471e-01  0.000000000000000e+00  1.537318130320867e-01
            9.823278309352566e-01  6.788350031940360e-02  1.744243760327655e-01
            9.123489271676879e-01  3.593314035883195e-01  1.962151306378211e-01
            9.747532673343509e-01  1.130335435405980e-01  1.925603434138589e-01
            8.746154287041108e-01  4.417611646682230e-01  1.997371404213541e-01
            9.806325882772511e-01  9.181598944409047e-03  1.956410617674203e-01
            9.625413327140728e-01  1.636831223620675e-01  2.161527660494333e-01
            8.258661568244398e-01  5.193685962538088e-01  2.195480636156427e-01
            9.463146232767095e-01  2.322722004546580e-01  2.248071588464443e-01
            9.746582482317271e-01  3.209105314640093e-02  2.213853280184025e-01
            9.735080913347722e-01  0.000000000000000e+00  2.286525663659358e-01
            9.232726968257550e-01  2.850219766963225e-01  2.575461125628161e-01
            8.921773804986167e-01  3.686219616547317e-01  2.610313604003244e-01
            9.648603629765317e-01  6.558822395788580e-02  2.544457994049930e-01
            8.532554422887425e-01  4.455312852108174e-01  2.710295631532467e-01
            9.628685701982963e-01  9.293663119370361e-03  2.698105712349171e-01
            9.531087249409881e-01  1.063199005019068e-01  2.833369675821152e-01
            9.406187948745434e-01  1.654450523071279e-01  2.964189896006212e-01
            9.508852840303602e-01  3.018340859705853e-02  3.080683989960089e-01
            8.978205568792691e-01  2.926046036762477e-01  3.290908591141131e-01
            8.649290068637993e-01  3.763555684110825e-01  3.320456282072887e-01
            9.192538554804418e-01  2.127589071398009e-01  3.312189557030524e-01
            9.483218387212615e-01  0.000000000000000e+00  3.173100852546694e-01
            8.261001448192945e-01  4.468276884829683e-01  3.433708891774432e-01
            9.338250981051107e-01  5.975400434561128e-02  3.527040474869051e-01
            9.208807131672057e-01  1.110299591709310e-01  3.736991574557800e-01
            9.310009128399982e-01  1.064720173278289e-02  3.648615317985048e-01
            8.626613708054556e-01  3.043983998505685e-01  4.039269407807130e-01
            8.846231298216531e-01  2.293489097255561e-01  4.060061524068832e-01
            8.311110103394703e-01  3.757722795358357e-01  4.099386325109485e-01
            8.988580645594466e-01  1.561559439406287e-01  4.094746645989919e-01
            9.130220382519830e-01  0.000000000000000e+00  4.079102323627030e-01
            9.026269412727649e-01  2.804572952542538e-02  4.295090708517800e-01
            8.892804150954775e-01  6.929721440381090e-02  4.520821157748748e-01
            8.431908723259043e-01  2.446199734778440e-01  4.787381553646832e-01
            8.145616006027565e-01  3.195859457922273e-01  4.841014584522165e-01
            8.554199066945370e-01  1.747719282766861e-01  4.875567211280739e-01
            8.646206565879864e-01  1.102033875038411e-01  4.901900994349412e-01
            8.670099290364477e-01  1.056092159116330e-02  4.981789336045424e-01
            8.672479474585237e-01  0.000000000000000e+00  4.978764883271529e-01
            8.508344099258479e-01  3.447246552511076e-02  5.243018748838825e-01
            8.078765748107801e-01  1.926760578617216e-01  5.569662257254639e-01
            8.198181387143987e-01  7.125783464780720e-02  5.681729846060659e-01
            8.021584120368478e-01  1.247986050231983e-01  5.839239592470811e-01
            8.101712499839877e-01  0.000000000000000e+00  5.861932665080545e-01
            7.848485024126073e-01  2.303605652587070e-02  6.192593708297233e-01
            7.490350421719102e-01  2.894890309457068e-13  6.625303808871897e-01
            5.477746044858169e-01  7.954308421358722e-01  2.592928037170025e-01
            6.719838857593311e-01  7.361704267495084e-01  8.056525342377581e-02
            2.132705234381851e-01  7.744944617275341e-01  5.955451389993707e-01
            4.516002168196094e-01  7.980736485599244e-01  3.989181565719117e-01
            6.208093319257876e-01  7.586441780569207e-01  1.976228339392911e-01
            7.177426751521532e-01  6.952775377563958e-01  3.787608423311883e-02
            3.802485194725472e-01  7.836739573091931e-01  4.911885504307740e-01
            1.607754783310757e-01  7.236068089290495e-01  6.712260659710196e-01
            5.421139647488205e-01  7.664766587284585e-01  3.444212258975522e-01
            6.881836538092091e-01  7.099396219174290e-01  1.496295153422098e-01
            3.311814415428789e-01  7.572283203930104e-01  5.629601438577700e-01
            1.142179273367936e-01  6.936150448178946e-01  7.112330382351181e-01
            4.539244282281653e-01  7.591515584772843e-01  4.665206584056527e-01
            6.128146175662917e-01  7.374744310038739e-01  2.838832649392920e-01
            2.748817956097341e-01  7.284730728716656e-01  6.275085501754389e-01
            7.368810404549591e-01  6.663891226719707e-01  1.137183775935018e-01
            5.233811975672731e-01  7.384289256989711e-01  4.251997691957402e-01
            4.121122209452415e-01  7.345343760574647e-01  5.390943959432813e-01
            6.782349495202120e-01  6.977061883757126e-01  2.306586828011253e-01
            2.207858788119573e-01  6.920948130049890e-01  6.872105685514602e-01
            5.972593214336621e-01  7.096546645276164e-01  3.737265846508616e-01
            3.673372247426147e-01  7.028807062638665e-01  6.091158149977737e-01
            4.989386121817680e-01  7.060940077468787e-01  5.024853366000664e-01
            1.812860162312364e-01  6.473612531790637e-01  7.403099271260924e-01
            7.347897565217378e-01  6.501808894153120e-01  1.932584403068568e-01
            6.591599411188578e-01  6.785873146145801e-01  3.240793552023283e-01
            3.144107937981382e-01  6.700869691491359e-01  6.724056116063799e-01
            4.559486780373987e-01  6.788702190574911e-01  5.755397715821059e-01
            5.731510841562975e-01  6.782389514050212e-01  4.598801577883940e-01
            7.188049566284166e-01  6.372678264519058e-01  2.778653481376974e-01
            2.685695499986300e-01  6.280441151130082e-01  7.303635986859228e-01
            6.380510026446869e-01  6.488877452018278e-01  4.145305925393172e-01
            4.161038633671827e-01  6.445167440977516e-01  6.414481596111552e-01
            5.352053684384614e-01  6.478909586604443e-01  5.420263086610293e-01
            6.998048417684113e-01  6.134337827568321e-01  3.660220998930696e-01
            7.716790823982848e-01  5.850369891358367e-01  2.494857012572386e-01
            3.673372247426147e-01  6.091158149977737e-01  7.028807062638665e-01
            4.975637839237168e-01  6.151957053553776e-01  6.115263894876592e-01
            6.073484703275380e-01  6.146559299051583e-01  5.033149346316130e-01
            7.558611992700015e-01  5.655621317243553e-01  3.298686444594548e-01
            3.311814415428789e-01  5.629601438577700e-01  7.572283203930104e-01
            6.690896942639073e-01  5.832475522581556e-01  4.605879653385454e-01
            2.714664870828510e-01  5.477762819430135e-01  7.913577517985052e-01
            4.560983990127058e-01  5.790103082328563e-01  6.758115960666400e-01
            5.740813350499495e-01  5.810907451846972e-01  5.768571457544415e-01
            7.263663322004406e-01  5.479976584595936e-01  4.148379415729496e-01
            4.190028616233181e-01  5.381073573917913e-01  7.313529065179774e-01
            8.063323851153721e-01  5.125166956887803e-01  2.952197848288787e-01
            5.354169900443546e-01  5.461167346657466e-01  6.442710290629760e-01
            6.418285880837330e-01  5.446049554606927e-01  5.398717495906771e-01
            7.780967659623537e-01  5.001028740484733e-01  3.800822781548528e-01
            7.026067928182467e-01  5.108733931414650e-01  4.953302644355418e-01
            4.992756510868505e-01  5.061971677413721e-01  7.031985861777701e-01
            3.868728482549290e-01  4.883204882062511e-01  7.822227944013952e-01
            6.076350129141338e-01  5.079634348810396e-01  6.105348801704096e-01
            7.554665983113276e-01  4.715681686314022e-01  4.548556707017476e-01
            4.606156194148399e-01  4.645844007773960e-01  7.563032366090940e-01
            6.744691276978787e-01  4.674430126796656e-01  5.714791559448346e-01
            5.736334521737059e-01  4.641902374263657e-01  6.748867208838316e-01
            7.975243412902981e-01  4.353183969894885e-01  4.176754940045899e-01
            7.312152395124055e-01  4.285796866283435e-01  5.307011642293302e-01
            5.303203025948967e-01  4.274432328437010e-01  7.321561714223154e-01
            6.442269202761139e-01  4.202089752827380e-01  6.390587549540220e-01
            7.836376005438931e-01  3.938783844338964e-01  4.803872701160530e-01
            4.846031912199917e-01  3.917448637417489e-01  7.821097805240379e-01
            5.987080775184819e-01  3.820066540584545e-01  7.040025242633635e-01
            7.059879843408144e-01  3.784726302302645e-01  5.986145956564870e-01
            7.610261565023992e-01  3.445629653283819e-01  5.496503907424227e-01
            5.544607693867988e-01  3.425761261257289e-01  7.584292010594580e-01
            6.661359248446999e-01  3.338637585098215e-01  6.669317209317548e-01
            7.252267890437546e-01  2.899860544700693e-01  6.244631235438707e-01
            6.249332837932050e-01  2.884535289928721e-01  7.254329413660505e-01
            7.838399179754881e-01  2.636066123598358e-01  5.622335252440496e-01
            5.662317142972935e-01  2.601810937363959e-01  7.821044969734422e-01
            6.880500682032673e-01  2.352118208846478e-01  6.864856174470138e-01
            7.461933114954168e-01  2.047207140871082e-01  6.334705763515526e-01
            6.410026909243546e-01  1.984956401082899e-01  7.414276978139788e-01
            7.008159211414942e-01  1.461679636272499e-01  6.982062525383612e-01
            7.443835221281663e-01  8.919238771221123e-02  6.617687586750074e-01
            6.632673893589006e-01  8.489608966595076e-02  7.435516284512187e-01
            7.097691815867293e-01  4.479166447443889e-02  7.030088304305386e-01
            7.065477003771322e-01  1.205282060661996e-02  7.075627722027290e-01
            0.000000000000000e+00  1.000000000000000e+00  0.000000000000000e+00
            6.496497089736730e-03  9.999788975401246e-01  0.000000000000000e+00
            1.858889985751580e-02  9.998272114731060e-01  0.000000000000000e+00
            4.173243500394541e-02  9.991288224591669e-01  0.000000000000000e+00
            7.387752081802558e-02  9.972673221948978e-01  0.000000000000000e+00
            1.186907634579470e-01  9.929312678477648e-01  0.000000000000000e+00
            1.774966726987764e-01  9.841214006314787e-01  0.000000000000000e+00
            2.447773099013451e-01  9.695793255621020e-01  0.000000000000000e+00
            3.286883662110162e-01  9.444384352182692e-01  0.000000000000000e+00
            4.189859761744590e-01  9.079927046893800e-01  0.000000000000000e+00
            5.125124202913994e-01  8.586798117150838e-01  0.000000000000000e+00
            5.974169652032914e-01  8.019307761192915e-01  0.000000000000000e+00
            6.731531886909344e-01  7.395030659539061e-01  0.000000000000000e+00
            4.755207784019883e-01  8.796536291814793e-01  9.459491308710743e-03
            2.036644051830884e-01  9.789936261573408e-01  9.606768692938042e-03
            1.219769571799693e-01  9.924869664191285e-01  9.552141397177687e-03
            3.641365588741698e-01  9.312727085643784e-01  1.164941090547126e-02
            6.281169773920231e-02  9.979634733693249e-01  1.111739392807010e-02
            6.904421887558856e-01  7.233044428602983e-01  1.096662776496947e-02
            9.185826798644752e-03  9.998958599343634e-01  1.113058274060382e-02
            0.000000000000000e+00  9.999383276678874e-01  1.110589306398587e-02
            2.911019715329034e-02  9.994963170515681e-01  1.263758766726224e-02
            2.807177123537984e-01  9.596700368983961e-01  1.519823181429426e-02
            0.000000000000000e+00  9.997554148810600e-01  2.211584083862613e-02
            5.442245827331080e-01  8.385467254033510e-01  2.567085632174059e-02
            5.018406980161243e-02  9.983707654369647e-01  2.715462868382337e-02
            4.326170809338130e-01  9.010734284093056e-01  3.015191368730531e-02
            9.000681586114344e-02  9.955190419413424e-01  2.899327906135813e-02
            1.425880532269572e-01  9.893025954333500e-01  3.080619654848379e-02
            2.096340800346638e-01  9.772788000626009e-01  3.130015073802446e-02
            6.287869542453720e-01  7.769266998309243e-01  3.180989249678741e-02
            9.701334434200064e-03  9.992595548950765e-01  3.723205690113494e-02
            0.000000000000000e+00  9.992293378832414e-01  3.925213769234535e-02
            3.128269260058494e-02  9.985983497484218e-01  4.269343068185188e-02
            3.273682695610219e-01  9.437389172637891e-01  4.676400460175636e-02
            5.705952121143462e-02  9.966899967654671e-01  5.790735175066251e-02
            1.006537298559055e-01  9.928955355875553e-01  6.346087043522258e-02
            2.336907880468030e-01  9.701060830689096e-01  6.544312931669824e-02
            1.589069137153244e-01  9.850311612978052e-01  6.679973088095045e-02
            4.799572290615782e-01  8.746087334356226e-01  6.856107984613398e-02
            3.848184905093791e-01  9.200302819811714e-01  7.388511081218700e-02
            5.727511809846018e-01  8.163167659621747e-01  7.471962452930378e-02
            1.052719103239549e-02  9.972252709426146e-01  7.369489291936274e-02
            0.000000000000000e+00  9.972673221948978e-01  7.387752081802558e-02
            2.745637445978953e-01  9.565703323875865e-01  9.791807467615028e-02
            3.001645627049928e-02  9.951964173855942e-01  9.318317002463128e-02
            6.412106403113572e-02  9.924204668471257e-01  1.048337070337978e-01
            1.792824871598726e-01  9.776671524421228e-01  1.096573245774366e-01
            1.122593479689257e-01  9.871263301628139e-01  1.139273763978040e-01
            5.104200201868303e-01  8.510027867169264e-01  1.235542795394045e-01
            6.127174845642339e-01  7.807620807795409e-01  1.224249048440693e-01
            3.251083101872795e-01  9.369663557973145e-01  1.280571542361918e-01
            0.000000000000000e+00  9.929312678477648e-01  1.186907634579470e-01
            4.151382894701864e-01  9.005389113412091e-01  1.291892788746710e-01
            9.869359440330025e-03  9.919776277504145e-01  1.260277024582201e-01
            2.118581684188854e-01  9.656173020597401e-01  1.506630095181422e-01
            3.256604156349684e-02  9.880378733003534e-01  1.507335857100177e-01
            1.291285869060440e-01  9.776286634472909e-01  1.660361540445692e-01
            5.463421004076801e-01  8.201242162522053e-01  1.700193496012450e-01
            6.845703913643209e-02  9.833703283313685e-01  1.682154307729510e-01
            4.426732337879797e-01  8.783997921679663e-01  1.801505292997117e-01
            2.528839938853428e-01  9.495869289933506e-01  1.852953046398507e-01
            3.394825590012959e-01  9.213370072746901e-01  1.894458000591436e-01
            0.000000000000000e+00  9.841214006314787e-01  1.774966726987764e-01
            1.001978094606671e-02  9.801384286660987e-01  1.980612648695950e-01
            1.558681328008619e-01  9.631543812736876e-01  2.191774692126745e-01
            4.870213618266019e-01  8.438140927390523e-01  2.253618646078621e-01
            3.400634177182366e-02  9.753427866399030e-01  2.180596644700862e-01
            8.193146660297468e-02  9.697979787424207e-01  2.297370566700133e-01
            3.729590848914023e-01  8.956344611131720e-01  2.423642569841632e-01
            2.625113660392374e-01  9.316718261724846e-01  2.511481455568432e-01
            0.000000000000000e+00  9.695793255621020e-01  2.447773099013451e-01
            1.831799305736061e-01  9.442640591416190e-01  2.735150812084081e-01
            4.152451526911960e-01  8.633893879848513e-01  2.865837188006480e-01
            1.134427091511260e-02  9.603400219746215e-01  2.786006994090071e-01
            1.070319674262177e-01  9.509408883658854e-01  2.902681256748211e-01
            2.958176681596211e-01  9.068428643214138e-01  3.002131353454376e-01
            3.995298692485384e-02  9.554136832750341e-01  2.925550420803157e-01
            4.750061061214962e-01  8.204673139296587e-01  3.181235387712528e-01
            2.118152569161350e-01  9.177518980242915e-01  3.359549830116563e-01
            3.388759144131035e-01  8.757215429920516e-01  3.439111713368775e-01
            0.000000000000000e+00  9.444384352182692e-01  3.286883662110162e-01
            1.252693373441134e-01  9.278610063760336e-01  3.512570938333071e-01
            3.881033194582179e-01  8.435101725854633e-01  3.713036522448362e-01
            6.357997423721282e-02  9.310854618988769e-01  3.592178301762740e-01
            1.494351706365454e-02  9.301034470982031e-01  3.669935544308759e-01
            2.458136432547758e-01  8.874514219238930e-01  3.898789895789129e-01
            1.518185561478044e-01  8.985716167137857e-01  4.117282788995301e-01
            2.838492767266639e-01  8.536025409797559e-01  4.367977680055773e-01
            0.000000000000000e+00  9.079927046893800e-01  4.189859761744590e-01
            3.225833293874366e-02  8.992122239168389e-01  4.363218723769711e-01
            8.269903946256142e-02  8.899577516610265e-01  4.484819607636638e-01
            1.897124779796077e-01  8.641153923516934e-01  4.661692443734525e-01
            3.107873918485238e-01  8.126678200389849e-01  4.929322583693183e-01
            2.338347437745980e-01  8.306389652028213e-01  5.053317940627268e-01
            1.180337378932168e-01  8.542882470945993e-01  5.062209276541145e-01
            0.000000000000000e+00  8.586798117150838e-01  5.125124202913994e-01
            4.558959248450051e-02  8.523419153023237e-01  5.209940963925249e-01
            1.598644294960756e-01  8.190835543453671e-01  5.509496303500478e-01
            1.193828455593087e-02  8.410391912898585e-01  5.408424503276000e-01
            7.513475469467921e-02  8.140366143225026e-01  5.759332940361477e-01
            0.000000000000000e+00  8.019307761192915e-01  5.974169652032914e-01
            1.184805337854933e-01  7.779246016869525e-01  6.170864422462228e-01
            2.905393210810626e-02  7.872523478855501e-01  6.159461094752905e-01
            6.823546006347296e-02  7.426295667894842e-01  6.662171181529257e-01
            0.000000000000000e+00  7.531440351912135e-01  6.578556545746918e-01
            1.246343909027796e-02  7.149936354639941e-01  6.990198594689739e-01
            ];
        
        
    case 20
        pts=[
            2.226771044581247e-01  5.649594673281226e-01  7.945034344963334e-01
            3.540713829076438e-01  4.555662830035194e-01  8.167575023201353e-01
            4.391321606573095e-01  3.653557143877710e-01  8.207789881817423e-01
            6.065602810685716e-01  1.530489703832562e-01  7.801670578117488e-01
            1.075390778306140e-01  6.301538643848198e-01  7.689872911435008e-01
            1.592694420310459e-01  5.931463695444517e-01  7.891835205649926e-01
            5.109637512334098e-01  2.515832325574434e-01  8.219622388050618e-01
            6.581140591697620e-01  3.608180667050554e-02  7.520531818631521e-01
            2.582507950188626e-01  5.007985575977363e-01  8.261400193551650e-01
            9.537826417427500e-03  6.628338062400191e-01  7.487058001462256e-01
            6.606632814354102e-01  9.032258626060007e-03  7.506280349594650e-01
            3.024142358526840e-01  4.335138626298488e-01  8.488883088259526e-01
            4.301667348523495e-01  3.038088196483428e-01  8.500922193093812e-01
            3.609518238109742e-01  3.725544799026784e-01  8.549368049113200e-01
            6.060832914452932e-01  7.246240695113279e-02  7.920935824823279e-01
            5.423669450258676e-02  6.123718845860875e-01  7.887072054558122e-01
            5.199802822125106e-01  1.799440312496168e-01  8.350093722395185e-01
            2.067556581094041e-01  4.929034104516242e-01  8.451617157709552e-01
            6.334027803649004e-01  0.000000000000000e+00  7.738222779333855e-01
            1.001923432132206e-01  5.660950787198891e-01  8.182284865552940e-01
            5.498475415284060e-01  1.171527902868913e-01  8.270084067306472e-01
            4.536539576241135e-01  2.218935855911870e-01  8.631114200411587e-01
            0.000000000000000e+00  6.155432358354807e-01  7.881031181369514e-01
            2.461880326973936e-01  4.205567555499170e-01  8.732258974159632e-01
            1.437642887595417e-01  5.025655820781002e-01  8.525020029231388e-01
            5.836909923226172e-01  2.450649091658046e-02  8.116059742167957e-01
            3.779541273676137e-01  2.766773009140419e-01  8.835159018176789e-01
            3.037020765164107e-01  3.492771412153760e-01  8.864369844179758e-01
            1.323303768947025e-02  5.762959571239359e-01  8.171339281391489e-01
            5.282287699586182e-01  6.150605027032256e-02  8.468715205792138e-01
            4.557109051162935e-01  1.534294429710361e-01  8.768049823009025e-01
            4.160395650031278e-02  5.359241410585063e-01  8.432404318070987e-01
            5.580981334226240e-01  0.000000000000000e+00  8.297749535085901e-01
            1.820634913642729e-01  4.166216388603433e-01  8.906622789506543e-01
            8.731665046190551e-02  4.910549979894296e-01  8.667414790476539e-01
            3.779977765911792e-01  2.072756591099252e-01  9.023050936532893e-01
            0.000000000000000e+00  5.373295258860219e-01  8.433723854923773e-01
            2.372702731003693e-01  3.413336795557341e-01  9.095021367230643e-01
            3.040118769770844e-01  2.705330573460532e-01  9.134487635001031e-01
            4.553292862034969e-01  9.937884826693053e-02  8.847593376972928e-01
            1.224515102221701e-01  4.113804147551098e-01  9.032008536312527e-01
            4.821891560912876e-01  3.328520091153218e-02  8.754345853050648e-01
            1.826068524145082e-02  4.857232051298609e-01  8.739219160616626e-01
            3.752024733419952e-01  1.449831474412016e-01  9.155342653096564e-01
            1.703065804054822e-01  3.374610238970095e-01  9.258054471761187e-01
            6.443822217744340e-02  4.262982564823772e-01  9.022846070075095e-01
            3.002238618668512e-01  2.015563586491486e-01  9.323307712683572e-01
            4.728945767759929e-01  0.000000000000000e+00  8.811190153752526e-01
            2.301977885726281e-01  2.682958723671428e-01  9.354284061364746e-01
            4.158117554669685e-01  6.535678670399606e-02  9.070992638334606e-01
            0.000000000000000e+00  4.580466116680228e-01  8.889281756921892e-01
            4.390904690584452e-01  9.525948687137988e-03  8.983923509712471e-01
            9.998063825628661e-02  3.483845832509909e-01  9.320043208735135e-01
            3.413234004149723e-01  1.034239053025321e-01  9.342386376837202e-01
            3.019615372064913e-02  3.949984030818406e-01  9.181854136628803e-01
            3.911473769009670e-01  2.714142708032056e-02  9.199277539456762e-01
            1.480807789842246e-01  2.803466706485457e-01  9.484080488648866e-01
            2.701458508613482e-01  1.529858052372660e-01  9.505874829063886e-01
            8.671267275269887e-03  3.972882827804123e-01  9.176528916149242e-01
            2.056495972454161e-01  2.141942175448185e-01  9.548974187435848e-01
            3.853534338360887e-01  0.000000000000000e+00  9.227690561731766e-01
            5.915972960465398e-02  3.276706365220350e-01  9.429380045126767e-01
            0.000000000000000e+00  3.746550192466093e-01  9.271642877900997e-01
            3.236283642308674e-01  5.634705503202889e-02  9.445049980039653e-01
            9.682471068719337e-02  2.658196372549201e-01  9.591480051848119e-01
            3.392771977462532e-01  9.533900572504986e-03  9.406381279904209e-01
            2.609246269687284e-01  9.520849160068522e-02  9.606527375531453e-01
            1.463117811926537e-01  2.014495521322088e-01  9.685096492188220e-01
            2.000435630252140e-01  1.468552151168489e-01  9.687188026900073e-01
            2.082135415906235e-02  3.179281882923883e-01  9.478861420551007e-01
            2.856930055417873e-01  2.903110078732346e-02  9.578813610106298e-01
            4.666244887387211e-02  2.615960482509325e-01  9.640488179571557e-01
            2.993260626524835e-01  0.000000000000000e+00  9.541508833601536e-01
            0.000000000000000e+00  2.886582687796079e-01  9.574321928289020e-01
            2.322626739436354e-01  5.863216127021096e-02  9.708842979250084e-01
            8.288522979000394e-02  2.028306720524829e-01  9.756996244528314e-01
            1.763075348114974e-01  1.011673917342986e-01  9.791224703878324e-01
            1.271510677277677e-01  1.487874687691968e-01  9.806604382317784e-01
            2.547156223669489e-01  9.457227695635019e-03  9.669697578345099e-01
            9.932319543940051e-03  2.477035962547871e-01  9.687849490113492e-01
            2.054487138370905e-01  2.868387240779449e-02  9.782474438741859e-01
            3.284113975845971e-02  1.994043962841095e-01  9.793668088525030e-01
            2.213776454540274e-01  0.000000000000000e+00  9.751881552260727e-01
            1.584350149344610e-01  6.066679135910633e-02  9.855038744058330e-01
            6.602408922238075e-02  1.504297894676365e-01  9.864135532742226e-01
            0.000000000000000e+00  2.114681667339786e-01  9.773848855277895e-01
            1.088647760778090e-01  1.031557011383637e-01  9.886897197059252e-01
            1.811899205131794e-01  8.203945952891742e-03  9.834139047091158e-01
            8.985196555931883e-03  1.786627251678459e-01  9.838693494963903e-01
            1.426143004158936e-01  2.828194055274269e-02  9.893741926872039e-01
            2.992323205982711e-02  1.399455125552891e-01  9.897069534456808e-01
            6.218996025627060e-02  9.798009786977618e-02  9.932433283263233e-01
            1.001083755638356e-01  5.971559955292890e-02  9.931829440299528e-01
            1.467805571904562e-01  0.000000000000000e+00  9.891690795970420e-01
            0.000000000000000e+00  1.425187759623112e-01  9.897920986238496e-01
            8.660007694468938e-03  1.224480960607464e-01  9.924371355596433e-01
            1.210354186048990e-01  8.082138899785677e-03  9.926152862382996e-01
            2.804340749137362e-02  8.972584001232749e-02  9.955716151690721e-01
            8.978249964978244e-02  2.590889351202738e-02  9.956243428088826e-01
            5.696416276586793e-02  5.606648749921521e-02  9.968006988058766e-01
            0.000000000000000e+00  9.219213460366529e-02  9.957412366258713e-01
            9.219213460366528e-02  0.000000000000000e+00  9.957412366258713e-01
            8.154164418524710e-03  7.262092639225805e-02  9.973262809394756e-01
            7.180249733258169e-02  7.961062722318687e-03  9.973870977996137e-01
            2.558219392989631e-02  5.005480355005544e-02  9.984187838754329e-01
            4.826608196631837e-02  2.554983314472652e-02  9.985076821726998e-01
            0.000000000000000e+00  5.217188884751622e-02  9.986381196479946e-01
            5.217188884730039e-02  2.164145764756187e-13  9.986381196480060e-01
            7.472145932651135e-03  3.529974413446273e-02  9.993488355420257e-01
            2.103546429228987e-02  2.168948220639737e-02  9.995434335753630e-01
            3.277368823546649e-02  7.851610641313247e-03  9.994319574487207e-01
            0.000000000000000e+00  2.507785374790263e-02  9.996855011709427e-01
            2.507785374783124e-02  7.144516164720338e-14  9.996855011709445e-01
            8.739404969798288e-03  8.849361139184846e-03  9.999226528128073e-01
            0.000000000000000e+00  7.750561216674956e-03  9.999699639493311e-01
            6.752047728679511e-03  -2.835580643380256e-13  9.999772046659212e-01
            0.000000000000000e+00  0.000000000000000e+00  1.000000000000000e+00
            7.881031181369514e-01  6.155432358354807e-01  0.000000000000000e+00
            8.433723854923773e-01  5.373295258860219e-01  0.000000000000000e+00
            8.889281756921892e-01  4.580466116680228e-01  0.000000000000000e+00
            9.271642877900997e-01  3.746550192466093e-01  0.000000000000000e+00
            9.574321928289020e-01  2.886582687796079e-01  0.000000000000000e+00
            9.773848855277895e-01  2.114681667339786e-01  0.000000000000000e+00
            9.897920986238496e-01  1.425187759623112e-01  0.000000000000000e+00
            9.957412366258713e-01  9.219213460366529e-02  0.000000000000000e+00
            9.986381196479946e-01  5.217188884751622e-02  0.000000000000000e+00
            9.996855011709427e-01  2.507785374790263e-02  0.000000000000000e+00
            9.999699639493311e-01  7.750561216674956e-03  0.000000000000000e+00
            1.000000000000000e+00  0.000000000000000e+00  0.000000000000000e+00
            7.243890300003225e-01  6.893904518438584e-01  1.156772109168095e-03
            9.999772046659212e-01  -2.835580643380256e-13  6.752047728679511e-03
            9.993488355420257e-01  3.529974413446273e-02  7.472145932651135e-03
            9.973262809394756e-01  7.262092639225805e-02  8.154164418524710e-03
            9.221824650365383e-01  3.866521222550802e-01  8.923986484539490e-03
            9.924371355596433e-01  1.224480960607464e-01  8.660007694468938e-03
            9.688182495211884e-01  2.476101900437718e-01  8.966224466714728e-03
            9.838693494963903e-01  1.786627251678459e-01  8.985196555931883e-03
            9.999226528128075e-01  8.849361139184848e-03  8.739404969798288e-03
            8.174095139539712e-01  5.759450267062485e-01  1.135837619870760e-02
            8.739219160616626e-01  4.857232051298609e-01  1.826068524145082e-02
            9.495864155827072e-01  3.127022021066175e-01  2.242704034103175e-02
            9.995434335753630e-01  2.168948220639737e-02  2.103546429228987e-02
            9.996855011709445e-01  7.144516164720338e-14  2.507785374783124e-02
            9.984187838754329e-01  5.005480355005544e-02  2.558219392989631e-02
            7.736666628479768e-01  6.329941742003362e-01  2.753670688570686e-02
            9.183157787245806e-01  3.948021176023765e-01  2.876488279389339e-02
            9.955716151690721e-01  8.972584001232749e-02  2.804340749137362e-02
            9.897069534456808e-01  1.399455125552891e-01  2.992323205982711e-02
            9.793668088525030e-01  1.994043962841095e-01  3.284113975845971e-02
            9.994319574487207e-01  7.851610641313247e-03  3.277368823546649e-02
            8.407654620678965e-01  5.399598724938917e-01  3.945597407410952e-02
            9.652752419587374e-01  2.565539810402181e-01  4.923171816945218e-02
            9.985076821726998e-01  2.554983314472652e-02  4.826608196631837e-02
            9.986381196480060e-01  2.164145764756187e-13  5.217188884730039e-02
            9.410838263890798e-01  3.330818620170530e-01  5.846114012009394e-02
            9.968006988058766e-01  5.606648749921521e-02  5.696416276586793e-02
            9.022846070075093e-01  4.262982564823772e-01  6.443822217744340e-02
            9.932433283263232e-01  9.798009786977617e-02  6.218996025627060e-02
            7.946417965168782e-01  6.036212003413431e-01  6.469823588711128e-02
            9.864135532742226e-01  1.504297894676365e-01  6.602408922238075e-02
            9.973870977996137e-01  7.961062722318687e-03  7.180249733258169e-02
            9.756996244528314e-01  2.028306720524829e-01  8.288522979000394e-02
            8.638974726163487e-01  4.960063115808923e-01  8.751511685990926e-02
            9.956243428088826e-01  2.590889351202738e-02  8.978249964978244e-02
            9.591480051848119e-01  2.658196372549201e-01  9.682471068719337e-02
            9.957412366258713e-01  0.000000000000000e+00  9.219213460366528e-02
            9.316178181358908e-01  3.486419728113940e-01  1.026499670038990e-01
            9.931829440299528e-01  5.971559955292890e-02  1.001083755638356e-01
            8.192745758083209e-01  5.629903836272672e-01  1.087703883293543e-01
            9.886897197059255e-01  1.031557011383637e-01  1.088647760778090e-01
            9.014876935959825e-01  4.163872283463993e-01  1.180746135500760e-01
            9.926152862382996e-01  8.082138899785677e-03  1.210354186048990e-01
            9.806604382317784e-01  1.487874687691968e-01  1.271510677277677e-01
            9.685096492188220e-01  2.014495521322088e-01  1.463117811926537e-01
            9.484080488648866e-01  2.803466706485457e-01  1.480807789842246e-01
            9.893741926872039e-01  2.828194055274269e-02  1.426143004158936e-01
            9.891690795970420e-01  0.000000000000000e+00  1.467805571904562e-01
            9.855038744058330e-01  6.066679135910633e-02  1.584350149344610e-01
            8.412523519250876e-01  5.145155665833063e-01  1.660367794314493e-01
            9.258054471761187e-01  3.374610238970095e-01  1.703065804054822e-01
            8.880440841457600e-01  4.267338267567115e-01  1.711021499435096e-01
            7.930934097190597e-01  5.827750242092391e-01  1.771330421409751e-01
            9.791224703878323e-01  1.011673917342986e-01  1.763075348114974e-01
            9.834139047091158e-01  8.203945952891742e-03  1.811899205131794e-01
            9.687188026900073e-01  1.468552151168489e-01  2.000435630252140e-01
            9.548974187435849e-01  2.141942175448185e-01  2.056495972454161e-01
            9.782474438741859e-01  2.868387240779449e-02  2.054487138370905e-01
            9.085627822618970e-01  3.520569813096967e-01  2.248767497978049e-01
            8.675962149419294e-01  4.415906255454911e-01  2.286362334556345e-01
            9.354284061364746e-01  2.682958723671428e-01  2.301977885726281e-01
            9.751881552260727e-01  0.000000000000000e+00  2.213776454540274e-01
            9.708842979250083e-01  5.863216127021095e-02  2.322626739436354e-01
            8.213513800743220e-01  5.151288829281299e-01  2.449982539187245e-01
            9.606527375531453e-01  9.520849160068522e-02  2.609246269687284e-01
            9.669697578345099e-01  9.457227695635019e-03  2.547156223669489e-01
            9.505874829063886e-01  1.529858052372660e-01  2.701458508613482e-01
            8.844745881762188e-01  3.659705429792708e-01  2.894309322480331e-01
            9.125464672780373e-01  2.868808693614086e-01  2.914760913914148e-01
            8.485821252166701e-01  4.388310573092319e-01  2.955261069746986e-01
            9.578813610106297e-01  2.903110078732346e-02  2.856930055417873e-01
            9.323307712683572e-01  2.015563586491486e-01  3.002238618668512e-01
            9.541508833601536e-01  0.000000000000000e+00  2.993260626524835e-01
            9.445049980039653e-01  5.634705503202889e-02  3.236283642308674e-01
            8.139579717958659e-01  4.662349473527461e-01  3.465507091565999e-01
            8.580560763504274e-01  3.725612807688558e-01  3.534655031399518e-01
            9.342386376837202e-01  1.034239053025321e-01  3.413234004149723e-01
            9.406381279904209e-01  9.533900572504986e-03  3.392771977462532e-01
            8.841131455051752e-01  2.933840747658951e-01  3.636890576010014e-01
            9.053791368568169e-01  2.227566893963340e-01  3.614803948675367e-01
            9.155342653096564e-01  1.449831474412016e-01  3.752024733419952e-01
            9.227690561731766e-01  0.000000000000000e+00  3.853534338360887e-01
            9.199277539456762e-01  2.714142708032056e-02  3.911473769009670e-01
            8.514812801668405e-01  3.095718987812748e-01  4.232550874004878e-01
            9.070992638334606e-01  6.535678670399606e-02  4.158117554669685e-01
            8.675664829292830e-01  2.380068621342250e-01  4.366705065317948e-01
            8.826402788290680e-01  1.722889361518981e-01  4.373358671183880e-01
            8.959067295217881e-01  9.522474491058613e-03  4.441401293253525e-01
            8.830666672403809e-01  1.031414631095067e-01  4.577718862016287e-01
            8.811190153752526e-01  0.000000000000000e+00  4.728945767759929e-01
            8.262854094170957e-01  2.573930592707632e-01  5.010002347540967e-01
            8.754345853050648e-01  3.328520091153218e-02  4.821891560912876e-01
            8.385127576313212e-01  1.899620283754013e-01  5.106963707184736e-01
            8.421993087563945e-01  1.301805297139344e-01  5.232144436210171e-01
            8.476067520727886e-01  6.453526856184959e-02  5.266858579383616e-01
            7.962350933911592e-01  2.174722441912724e-01  5.645489341578669e-01
            8.297749535085901e-01  0.000000000000000e+00  5.580981334226240e-01
            7.882546264114290e-01  1.581347321969647e-01  5.946831512780338e-01
            8.141025610303834e-01  2.453095875000633e-02  5.802027681652133e-01
            8.023729872156851e-01  8.614790309137134e-02  5.905727120173587e-01
            7.750230840882365e-01  4.614593485387566e-02  6.302458027046434e-01
            7.738222779333855e-01  0.000000000000000e+00  6.334027803649004e-01
            7.416249056460098e-01  1.547950614856060e-02  6.706361787250548e-01
            7.074965716182945e-01  -6.281803297100776e-15  7.067167757654825e-01
            3.885583561772673e-01  8.143076812317444e-01  4.311906818703296e-01
            5.038974432046159e-01  8.044156957494286e-01  3.146470326632900e-01
            3.308800042520754e-01  8.043776473069713e-01  4.934521489456180e-01
            9.460883299315313e-02  7.400303675710199e-01  6.658860441489781e-01
            6.754699849154874e-01  7.314313330626374e-01  9.353344050383396e-02
            2.126535499920770e-01  7.675668873931808e-01  6.046648171121843e-01
            3.335335198487230e-02  6.969388064860209e-01  7.163545588081462e-01
            5.743869197991486e-01  7.757655568314196e-01  2.612804378396590e-01
            2.742610579117203e-01  7.747622556466163e-01  5.696703602422293e-01
            7.212698772415913e-01  6.905675162282481e-01  5.372401431620762e-02
            4.815850878953014e-01  7.803890655314709e-01  3.988341879977099e-01
            3.954042715886484e-01  7.759362631872214e-01  4.915062334096095e-01
            6.756691079334691e-02  6.863464124186784e-01  7.241293494437672e-01
            6.457170809833829e-01  7.349087910672055e-01  2.072643725738645e-01
            1.774059985891511e-01  7.181802886615747e-01  6.728626788896553e-01
            5.535811751373597e-01  7.566615624292857e-01  3.478665871790680e-01
            6.957658076076398e-01  7.011495002872691e-01  1.558823890341739e-01
            3.427511783058791e-01  7.479754693935567e-01  5.683786827067144e-01
            1.307695252854096e-01  6.868536765120804e-01  7.149345133076644e-01
            4.653033991387301e-01  7.505469461972621e-01  4.692249229355872e-01
            6.211894756946905e-01  7.252533704426865e-01  2.968689676400668e-01
            2.887180573603313e-01  7.201321120306641e-01  6.309133257241691e-01
            5.305643925736759e-01  7.313386865023427e-01  4.285383891297890e-01
            4.258877801136857e-01  7.262748865783306e-01  5.395779720072622e-01
            2.362925759526320e-01  6.879072133180217e-01  6.862575933384658e-01
            6.838989054388313e-01  6.855473918788723e-01  2.496138229899228e-01
            7.559939685766563e-01  6.431470732104442e-01  1.217988575338742e-01
            5.955769137316694e-01  7.047086186128357e-01  3.855825497641827e-01
            3.834395268421660e-01  6.953700676149629e-01  6.078113180257650e-01
            5.073040940876822e-01  7.023896026571693e-01  4.992908993772868e-01
            7.330903325189250e-01  6.484348743546907e-01  2.052091081991937e-01
            6.604190504673774e-01  6.697469687896709e-01  3.395374435563996e-01
            2.080758232742010e-01  6.363036032158984e-01  7.428473438757307e-01
            3.328338746021210e-01  6.656286140256993e-01  6.679522139401639e-01
            4.672136897510185e-01  6.733323939261791e-01  5.730051094003261e-01
            5.775272673631863e-01  6.721623015172247e-01  4.633142517461320e-01
            2.826337454952277e-01  6.312043450653347e-01  7.222875055530040e-01
            7.184103269160400e-01  6.292879005693565e-01  2.964512445199046e-01
            6.389234917450337e-01  6.437916779209182e-01  4.210808083208049e-01
            4.296471955445710e-01  6.400131648902598e-01  6.370136859815795e-01
            5.415482250998455e-01  6.463912177801644e-01  5.374978264773573e-01
            7.683467828476523e-01  5.825371131015217e-01  2.651296534660115e-01
            3.834395268421660e-01  6.078113180257650e-01  6.953700676149629e-01
            6.987450413034518e-01  6.057449126635095e-01  3.805633561394408e-01
            5.063903867221206e-01  6.115063062608389e-01  6.079710631589683e-01
            6.096301653851640e-01  6.109394402333942e-01  5.050782729634729e-01
            3.427511783058791e-01  5.683786827067144e-01  7.479754693935567e-01
            6.680991019029944e-01  5.809382306829465e-01  4.649240391369110e-01
            7.534860989355732e-01  5.589347998728961e-01  3.461944369886628e-01
            4.673585519854105e-01  5.763742256089923e-01  6.703497116727468e-01
            5.725456920910313e-01  5.817327266264281e-01  5.777356361172327e-01
            2.970830314644339e-01  5.428020708901963e-01  7.855619544333957e-01
            4.260980737819792e-01  5.425270859257505e-01  7.239508219183126e-01
            7.235232779397206e-01  5.425157801372236e-01  4.268380191377772e-01
            7.993605199389600e-01  5.185281837136794e-01  3.035642960848796e-01
            6.371493542937137e-01  5.472152487762779e-01  5.427671432850557e-01
            5.417596051845261e-01  5.414177596693331e-01  6.429333866777698e-01
            6.959357878044905e-01  5.150112157415564e-01  5.004366362621219e-01
            3.894967562851848e-01  4.982478586745351e-01  7.746233589103545e-01
            7.744543676529850e-01  4.956088334653176e-01  3.931822943805608e-01
            6.098904152166451e-01  5.094920674289303e-01  6.070020713752652e-01
            5.076344362730820e-01  5.028733731858067e-01  6.995896294617573e-01
            7.483197354143440e-01  4.716557767071867e-01  4.664315618481950e-01
            4.653033991387301e-01  4.692249229355872e-01  7.505469461972621e-01
            6.731791764355439e-01  4.714038940732734e-01  5.697439469324066e-01
            5.779741921531306e-01  4.674448023931997e-01  6.689104498514868e-01
            4.275593319023379e-01  4.296426915828636e-01  7.953616631901860e-01
            8.022195676768172e-01  4.249543009523054e-01  4.193537973341340e-01
            7.276792789728070e-01  4.345038437025697e-01  5.307440784043741e-01
            5.371313488587605e-01  4.309738387514158e-01  7.250872115718475e-01
            6.447396085851269e-01  4.265474598280653e-01  6.343249180315420e-01
            7.773632583980424e-01  4.023192475359590e-01  4.835758343371573e-01
            4.939299367930059e-01  3.958140399934687e-01  7.741863233638954e-01
            6.018225461123071e-01  3.892108096510647e-01  6.973697503058636e-01
            7.038122172885458e-01  3.873603374411416e-01  5.954832758129028e-01
            7.567581005347983e-01  3.491396960587995e-01  5.526469487031780e-01
            5.597609092750033e-01  3.489439049886660e-01  7.516022057038433e-01
            6.661264806435265e-01  3.446209515066129e-01  6.614468320040139e-01
            8.085928592641571e-01  3.333262342466372e-01  4.848414271800328e-01
            5.048034209630843e-01  3.189082898060267e-01  8.021664471149129e-01
            7.233934734437677e-01  3.031897989479058e-01  6.203046254808111e-01
            6.278570256740996e-01  3.032570558939049e-01  7.168198611661329e-01
            7.723358791210246e-01  2.738567863498432e-01  5.731489774853397e-01
            5.826733286498262e-01  2.717807833062579e-01  7.659157903487619e-01
            6.880743782731227e-01  2.500474063901721e-01  6.811974343181305e-01
            6.457170809833829e-01  2.072643725738645e-01  7.349087910672055e-01
            7.382926722343014e-01  2.045869380619375e-01  6.427037536062594e-01
            7.002734323273934e-01  1.594085700369799e-01  6.958491415351296e-01
            7.449550956984822e-01  1.142156567477827e-01  6.572645503498100e-01
            6.638464109390771e-01  1.073517957436622e-01  7.401239994986766e-01
            7.112049582862375e-01  6.720739270674529e-02  6.997647273724451e-01
            0.000000000000000e+00  1.000000000000000e+00  0.000000000000000e+00
            1.666151664818924e-02  9.998611872970078e-01  0.000000000000000e+00
            3.741709958519279e-02  9.992997351438815e-01  0.000000000000000e+00
            6.628180216075540e-02  9.978009434262540e-01  0.000000000000000e+00
            1.066321305816965e-01  9.942985410467060e-01  0.000000000000000e+00
            1.598743471077528e-01  9.871373729815268e-01  0.000000000000000e+00
            2.213776454540274e-01  9.751881552260728e-01  0.000000000000000e+00
            2.993260626524835e-01  9.541508833601536e-01  0.000000000000000e+00
            3.853534338360887e-01  9.227690561731766e-01  0.000000000000000e+00
            4.728945767759929e-01  8.811190153752526e-01  0.000000000000000e+00
            5.580981334226240e-01  8.297749535085901e-01  0.000000000000000e+00
            6.305670045578411e-01  7.761348161002388e-01  0.000000000000000e+00
            5.821987808053102e-03  9.999830520853253e-01  2.837658448827513e-07
            9.671607923477635e-07  9.999876976595038e-01  4.960295224030716e-03
            3.358785110733907e-01  9.418768414218873e-01  7.324028416856129e-03
            2.613658870625681e-02  9.996345447651188e-01  6.903306673889727e-03
            5.269715873657940e-01  8.498412899090350e-01  8.409998509101808e-03
            1.790025057229628e-01  9.838105650765291e-01  8.653033497065166e-03
            1.096480967026972e-01  9.939337162503635e-01  8.547665775989999e-03
            5.858099615871423e-02  9.982246554096491e-01  1.076123698001436e-02
            4.125384342232439e-01  9.108637444272750e-01  1.180166838027493e-02
            2.617924305301957e-01  9.650517214543635e-01  1.182785843093626e-02
            8.055252659757780e-03  9.998982828800469e-01  1.177016559446530e-02
            0.000000000000000e+00  9.999051491891021e-01  1.377289458027808e-02
            2.840935575531015e-02  9.993722345725154e-01  2.116707989084314e-02
            6.740809887877913e-01  7.383083661659562e-01  2.270632079905864e-02
            5.864690321922438e-01  8.095946013023850e-01  2.471145122256270e-02
            4.755849787363553e-01  8.792292878248014e-01  2.783500370815974e-02
            1.945150757425699e-01  9.804978718203419e-01  2.806792946839167e-02
            8.298340761139752e-02  9.961669617205495e-01  2.766113587056408e-02
            1.322370008195712e-01  9.908159599446895e-01  2.823312120769415e-02
            3.191832113251111e-01  9.471485990077377e-01  3.211867067406680e-02
            0.000000000000000e+00  9.993805741878506e-01  3.519187315221695e-02
            8.553177806938919e-03  9.993167933104399e-01  3.595538564863924e-02
            3.930159878747673e-01  9.182956489737412e-01  4.766061634847282e-02
            2.362611319360214e-01  9.703794171463183e-01  5.044268346431965e-02
            2.407784718893451e-02  9.985384611146016e-01  4.838593751938128e-02
            5.384153940251683e-02  9.971369068081448e-01  5.309498767164643e-02
            5.267756538931938e-01  8.481831076274590e-01  5.561318549430624e-02
            6.264423696558967e-01  7.775766299190437e-01  5.426363518644137e-02
            1.534772707046633e-01  9.863333525719603e-01  5.992699709817502e-02
            9.708795370389205e-02  9.935098407597169e-01  5.926318890502578e-02
            4.554067312038765e-01  8.878549465911527e-01  6.571379602352576e-02
            0.000000000000000e+00  9.978009434262540e-01  6.628180216075540e-02
            7.806958112581365e-03  9.969553609219433e-01  7.758259942813474e-02
            2.833380712044879e-02  9.962035281190399e-01  8.231479780232967e-02
            1.870111456213308e-01  9.781954206357587e-01  9.033576512449865e-02
            2.585282356363959e-01  9.616251923981383e-01  9.187023851049705e-02
            3.353258314335466e-01  9.373202443506605e-01  9.480161551270465e-02
            5.757394585978265e-01  8.122139140552076e-01  9.398209206333734e-02
            6.139317268066573e-02  9.935852298417280e-01  9.496983409779357e-02
            4.109715804221749e-01  9.060058771602216e-01  1.012704825526053e-01
            1.080461994940141e-01  9.890266134365761e-01  1.007590030174833e-01
            4.908780080876381e-01  8.644212360785734e-01  1.086954819314221e-01
            0.000000000000000e+00  9.942985410467060e-01  1.066321305816965e-01
            6.190998207863235e-01  7.732543988370957e-01  1.370877331544434e-01
            3.080833246809657e-02  9.904740879867507e-01  1.342085231173853e-01
            1.999793350078456e-01  9.696302160691621e-01  1.408030882313661e-01
            1.333663474147063e-01  9.812606352815459e-01  1.390718628052297e-01
            2.700930324722101e-01  9.515756665639766e-01  1.468111188339943e-01
            3.418678465424848e-01  9.267872908250178e-01  1.555367900711211e-01
            5.258943214754765e-01  8.365386290226435e-01  1.537474708499753e-01
            6.400728165857732e-02  9.866916633613940e-01  1.494745106959878e-01
            4.253986448232148e-01  8.905694568248197e-01  1.610032159719740e-01
            0.000000000000000e+00  9.871373729815268e-01  1.598743471077528e-01
            9.297164868059643e-03  9.855721476266821e-01  1.690003093131655e-01
            8.669408175419695e-02  9.778414460218249e-01  1.905524668713133e-01
            5.664879805991972e-01  8.006680498787162e-01  1.949924145705603e-01
            3.017388263887028e-02  9.808357381647679e-01  1.924858216733651e-01
            4.633527091077681e-01  8.622467520334390e-01  2.045355850953013e-01
            1.408030882313661e-01  9.696302160691621e-01  1.999793350078456e-01
            2.018317939172908e-01  9.577965579213452e-01  2.046696865638665e-01
            2.705122399650061e-01  9.388046108608796e-01  2.132346844569790e-01
            3.556216729063792e-01  9.090721020712476e-01  2.170740403526672e-01
            0.000000000000000e+00  9.751881552260728e-01  2.213776454540274e-01
            5.035075465162711e-01  8.290503434100267e-01  2.432194044332853e-01
            4.831312950821098e-02  9.686404336649593e-01  2.437243356468173e-01
            3.926993819017346e-01  8.817910080350529e-01  2.612122003324516e-01
            9.722108956571466e-03  9.687178204942357e-01  2.479743229738401e-01
            9.187023851049705e-02  9.616251923981383e-01  2.585282356363959e-01
            1.468111188339943e-01  9.515756665639766e-01  2.700930324722101e-01
            2.814232861650754e-01  9.185765866529602e-01  2.775211495671039e-01
            2.055313296635376e-01  9.366094512854617e-01  2.837597721479992e-01
            4.358966538922894e-01  8.491173082771719e-01  2.983184605579006e-01
            2.655270455353128e-02  9.562650484573713e-01  2.912938567490126e-01
            0.000000000000000e+00  9.541508833601536e-01  2.993260626524835e-01
            3.190071818574203e-01  8.908349620205768e-01  3.234926403570630e-01
            5.086372418429114e-02  9.445271518384046e-01  3.244708631019676e-01
            9.606408748347824e-02  9.355819161118938e-01  3.397913614857859e-01
            2.271950108461294e-01  9.082207023964749e-01  3.514506832901038e-01
            9.552011353084021e-03  9.425602617307361e-01  3.338995538858904e-01
            3.624699079496285e-01  8.607260607084298e-01  3.574440015559590e-01
            1.489987514029041e-01  9.214637011103539e-01  3.587534245361064e-01
            4.294011320702813e-01  8.246433312024810e-01  3.682092395364840e-01
            2.601567218543875e-01  8.777020505971581e-01  4.024395488163688e-01
            0.000000000000000e+00  9.227690561731766e-01  3.853534338360887e-01
            6.520855208946051e-02  9.144236585789886e-01  3.994711721331258e-01
            2.464709300241245e-02  9.177115361139808e-01  3.964821021053133e-01
            1.715448135487783e-01  8.883385088625986e-01  4.259425672743802e-01
            3.009760067051896e-01  8.461720670494495e-01  4.397798043715281e-01
            9.841147902453981e-02  8.980690133689120e-01  4.287041264354607e-01
            2.094737855020615e-01  8.549461088040718e-01  4.745396550639497e-01
            4.074169541968645e-02  8.815446597923531e-01  4.703393743308272e-01
            0.000000000000000e+00  8.811190153752526e-01  4.728945767759929e-01
            1.261119828550907e-01  8.601286034942861e-01  4.942413916613281e-01
            2.474110193785199e-01  8.224684661137052e-01  5.121849370477920e-01
            1.105860631623485e-02  8.617894902083874e-01  5.071455232896278e-01
            6.679891401761077e-02  8.473462638410841e-01  5.268227541029559e-01
            1.634587918755191e-01  8.250885342837116e-01  5.408420600805306e-01
            0.000000000000000e+00  8.297749535085901e-01  5.580981334226240e-01
            9.832482067470925e-02  8.095378762079312e-01  5.787751347665504e-01
            2.773585107482998e-02  8.185519055927098e-01  5.737625819236546e-01
            1.418529850133060e-01  7.733179943074047e-01  6.179457988555206e-01
            5.125703571507665e-02  7.802283190766218e-01  6.233911183202505e-01
            0.000000000000000e+00  7.761348161002388e-01  6.305670045578411e-01
            1.582649878201551e-02  7.507606060542449e-01  6.603847623418986e-01
            0.000000000000000e+00  7.125660168857518e-01  7.016050680971272e-01
            ];
        
        
end


leb=[
   1.6723
    3.0917
    3.5711
    3.9711
    9.3703
    8.9005
   10.9596
   20.8522
   15.2127
   14.6268
   19.4030
   22.0000
   18.5753
   28.0068
   33.0277
   35.6216
   73.6567
   56.1632
   53.5567
   70.4705
    ];


AE_L2err=[
    1.403e-01 9.463e-01 5.322e-02 5.720e-02 5.445e-01 1.917e-01
    9.602e-02 1.323e+00 1.228e-02 3.253e-03 6.499e-02 1.534e-02
    1.349e-02 2.180e-01 1.350e-03 1.390e-04 3.824e-03 1.040e-03
    1.137e-03 2.133e-01 1.038e-04 5.155e-06 5.079e-04 1.954e-04
    5.574e-04 2.664e-02 1.805e-05 1.906e-07 2.949e-04 6.240e-05
    1.747e-15 2.112e-02 5.673e-07 6.050e-09 3.148e-05 2.625e-05
    2.577e-15 1.906e-03 3.541e-08 1.528e-10 1.240e-05 1.061e-05
    2.117e-15 1.005e-03 3.713e-09 3.583e-12 8.669e-06 4.968e-06
    2.299e-15 8.373e-05 9.590e-11 8.375e-14 2.171e-06 2.799e-06
    2.279e-15 3.516e-05 3.769e-12 1.700e-15 6.255e-07 1.693e-06
    3.368e-15 2.191e-06 1.690e-13 8.971e-16 3.472e-07 9.663e-07
    2.971e-15 6.817e-07 5.400e-15 8.627e-16 1.431e-07 5.672e-07
    3.716e-15 3.969e-08 7.945e-16 1.075e-15 6.183e-08 3.741e-07
    2.986e-15 1.188e-08 5.283e-16 8.564e-16 4.731e-08 2.990e-07
    3.043e-15 5.836e-10 5.123e-16 8.168e-16 1.965e-08 1.891e-07
    3.898e-15 1.348e-10 7.254e-16 1.005e-15 8.439e-09 1.269e-07
    3.595e-15 6.525e-12 5.484e-16 9.428e-16 4.798e-09 1.385e-07
    3.694e-15 1.704e-12 6.067e-16 1.035e-15 2.587e-09 8.047e-08
    4.615e-15 5.657e-14 8.102e-16 1.332e-15 1.101e-09 4.740e-08
    3.720e-15 1.082e-14 5.781e-16 1.046e-15 7.050e-10 3.281e-08
    ];


RE_L2err=[
    4.640e-02 1.090e+00 8.572e-02 5.797e-02 1.881e-01 1.292e+00
    3.175e-02 1.524e+00 1.977e-02 3.297e-03 2.245e-02 1.034e-01
    4.461e-03 2.511e-01 2.174e-03 1.409e-04 1.321e-03 7.006e-03
    3.760e-04 2.457e-01 1.671e-04 5.224e-06 1.755e-04 1.317e-03
    1.843e-04 3.068e-02 2.906e-05 1.931e-07 1.019e-04 4.204e-04
    5.777e-16 2.433e-02 9.137e-07 6.131e-09 1.088e-05 1.769e-04
    8.523e-16 2.195e-03 5.702e-08 1.549e-10 4.285e-06 7.149e-05
    7.000e-16 1.158e-03 5.980e-09 3.631e-12 2.995e-06 3.347e-05
    7.601e-16 9.644e-05 1.545e-10 8.488e-14 7.501e-07 1.886e-05
    7.536e-16 4.050e-05 6.070e-12 1.723e-15 2.161e-07 1.141e-05
    1.114e-15 2.523e-06 2.722e-13 9.092e-16 1.199e-07 6.511e-06
    9.826e-16 7.852e-07 8.698e-15 8.744e-16 4.943e-08 3.822e-06
    1.229e-15 4.572e-08 1.280e-15 1.090e-15 2.136e-08 2.521e-06
    9.874e-16 1.369e-08 8.508e-16 8.679e-16 1.634e-08 2.015e-06
    1.006e-15 6.721e-10 8.251e-16 8.277e-16 6.788e-09 1.274e-06
    1.289e-15 1.552e-10 1.168e-15 1.019e-15 2.916e-09 8.554e-07
    1.189e-15 7.516e-12 8.832e-16 9.555e-16 1.658e-09 9.332e-07
    1.222e-15 1.963e-12 9.771e-16 1.049e-15 8.939e-10 5.422e-07
    1.526e-15 6.516e-14 1.305e-15 1.350e-15 3.803e-10 3.194e-07
    1.230e-15 1.246e-14 9.311e-16 1.060e-15 2.436e-10 2.211e-07
    ];


AE_inf=[
    2.756e-01 1.542e+00 1.161e-01 5.943e-02 1.083e+00 2.134e-01
    2.387e-01 2.122e+00 2.626e-02 4.942e-03 1.300e-01 2.330e-02
    2.966e-02 6.450e-01 2.413e-03 2.530e-04 6.704e-03 1.727e-03
    3.888e-03 3.704e-01 2.644e-04 9.268e-06 1.300e-03 3.224e-04
    1.707e-03 6.835e-02 5.571e-05 3.533e-07 9.032e-04 1.238e-04
    4.885e-15 5.219e-02 2.249e-06 1.498e-08 1.032e-04 5.615e-05
    9.548e-15 6.179e-03 1.445e-07 3.966e-10 4.086e-05 2.592e-05
    6.661e-15 2.053e-03 2.173e-08 7.216e-12 5.284e-05 1.078e-05
    7.327e-15 2.312e-04 4.524e-10 1.892e-13 1.368e-05 7.926e-06
    7.994e-15 9.368e-05 2.042e-11 4.996e-15 2.789e-06 3.862e-06
    1.399e-14 6.716e-06 1.149e-12 4.108e-15 2.291e-06 2.354e-06
    1.021e-14 1.400e-06 2.287e-14 2.554e-15 7.728e-07 1.511e-06
    1.599e-14 1.660e-07 3.331e-15 4.441e-15 3.418e-07 1.229e-06
    9.770e-15 4.550e-08 2.442e-15 2.776e-15 2.162e-07 1.504e-06
    9.326e-15 2.784e-09 1.887e-15 2.442e-15 1.145e-07 1.076e-06
    1.488e-14 3.936e-10 2.776e-15 4.552e-15 4.964e-08 4.014e-07
    1.243e-14 2.624e-11 2.276e-15 3.997e-15 2.809e-08 7.199e-07
    1.155e-14 8.682e-12 1.887e-15 4.441e-15 1.608e-08 3.360e-07
    2.331e-14 2.133e-13 3.997e-15 7.438e-15 6.714e-09 2.658e-07
    1.377e-14 7.205e-14 2.554e-15 4.774e-15 4.586e-09 1.213e-07
    ];


RE_inf=[
    8.755e-02 1.542e+00 1.161e-01 5.943e-02 1.917e-01 3.265e-01
    7.584e-02 2.122e+00 2.626e-02 4.942e-03 2.301e-02 3.565e-02
    9.422e-03 6.450e-01 2.413e-03 2.530e-04 1.186e-03 2.643e-03
    1.235e-03 3.704e-01 2.644e-04 9.268e-06 2.301e-04 4.933e-04
    5.424e-04 6.835e-02 5.571e-05 3.533e-07 1.598e-04 1.894e-04
    1.552e-15 5.219e-02 2.249e-06 1.498e-08 1.826e-05 8.591e-05
    3.033e-15 6.179e-03 1.445e-07 3.966e-10 7.232e-06 3.966e-05
    2.116e-15 2.053e-03 2.173e-08 7.216e-12 9.351e-06 1.649e-05
    2.328e-15 2.312e-04 4.524e-10 1.892e-13 2.421e-06 1.213e-05
    2.540e-15 9.368e-05 2.042e-11 4.996e-15 4.935e-07 5.909e-06
    4.444e-15 6.716e-06 1.149e-12 4.108e-15 4.055e-07 3.602e-06
    3.245e-15 1.400e-06 2.287e-14 2.554e-15 1.368e-07 2.312e-06
    5.079e-15 1.660e-07 3.331e-15 4.441e-15 6.049e-08 1.880e-06
    3.104e-15 4.550e-08 2.442e-15 2.776e-15 3.827e-08 2.301e-06
    2.963e-15 2.784e-09 1.887e-15 2.442e-15 2.026e-08 1.646e-06
    4.726e-15 3.936e-10 2.776e-15 4.552e-15 8.785e-09 6.141e-07
    3.950e-15 2.624e-11 2.276e-15 3.997e-15 4.971e-09 1.101e-06
    3.668e-15 8.682e-12 1.887e-15 4.441e-15 2.846e-09 5.140e-07
    7.407e-15 2.133e-13 3.997e-15 7.438e-15 1.188e-09 4.066e-07
    4.374e-15 7.205e-14 2.554e-15 4.774e-15 8.117e-10 1.855e-07
    ];



% LEBESGUE CONSTANT BASED ON DIFFERENT TEST POINTS
%
%     1.6722    1.6723
%     3.0873    3.0917
%     3.5711    3.5709
%     3.9647    3.9711
%     9.3609    9.3703
%     8.8919    8.9005
%    10.9246   10.9596
%    20.8352   20.8522
%    15.1427   15.2127
%    14.5867   14.6268
%    19.2480   19.4030
%    21.7256   22.0000
%    18.3165   18.5753
%    27.7882   28.0068
%    33.0277   33.0035
%    35.6216   35.6163
%    73.2983   73.6567
%    56.0164   56.1632
%    53.3415   53.5567
%    67.7325   70.4705