function [pts,leb,AE_L2err,RE_L2err,AE_inf,RE_inf]=...
    octant_hyperinterpolation(deg)
 

%  	 .........................................................................
%  	 ** Domain:  0
%  	 ** Hyperinterpolation on compressed pointset 
%  	
%  	 .........................................................................
%  	 |  n  |  hypset  |  initset  |  dimpoly |  cpus   |    leb   |
%  	 .........................................................................
%  	 |   1 |       9  |    4959   |     4    | 3.0e-02 | 3.60e+00 |
%  	 |   2 |      25  |    5310   |     9    | 2.7e-02 | 6.25e+00 |
%  	 |   3 |      49  |    5673   |    16    | 2.7e-02 | 9.73e+00 |
%  	 |   4 |      81  |    6048   |    25    | 5.2e-02 | 1.30e+01 |
%  	 |   5 |     121  |    6435   |    36    | 1.6e-01 | 1.62e+01 |
%  	 |   6 |     169  |    6834   |    49    | 1.4e-01 | 1.97e+01 |
%  	 |   7 |     225  |    7245   |    64    | 2.9e-01 | 2.62e+01 |
%  	 |   8 |     289  |    7668   |    81    | 4.6e-01 | 2.59e+01 |
%  	 |   9 |     361  |    8103   |   100    | 6.6e-01 | 3.20e+01 |
%  	 |  10 |     441  |    8550   |   121    | 1.6e+00 | 3.44e+01 |
%  	 |  11 |     529  |    9009   |   144    | 2.0e+00 | 3.55e+01 |
%  	 |  12 |     625  |    9480   |   169    | 2.3e+00 | 3.98e+01 |
%  	 |  13 |     729  |    9963   |   196    | 5.8e+00 | 4.34e+01 |
%  	 |  14 |     841  |   10458   |   225    | 2.3e+01 | 4.90e+01 |
%  	 |  15 |     961  |   10965   |   256    | 2.9e+01 | 5.18e+01 |
%  	 .........................................................................
%  
% 
%  	 .........................................................................
%  	 For each function "f" and each degree we display the L2 relative weighted
%  	 hyperinterp. errors REL, evaluated w.r.t. to a high order cubature.
%  	 Next we compute RELinf, i.e. "maximum absolute error / norm(f,inf)".
%  	 .........................................................................
%  
%  
%  	 *** 1+x+y.^2+x.^2.*y+x.^4+y.^5+x.^2.*y.^2.*z.^2
% 
%  	 .....................................
%  	 |  deg  |   REL2   |  RELinf  |
%  	 .....................................
%  	 |    1  | 5.48e-02 | 9.12e-02 |
%  	 |    2  | 1.93e-02 | 5.85e-02 |
%  	 |    3  | 2.83e-03 | 1.61e-02 |
%  	 |    4  | 2.86e-04 | 1.33e-03 |
%  	 |    5  | 4.70e-05 | 2.25e-04 |
%  	 |    6  | 5.14e-16 | 4.02e-15 |
%  	 |    7  | 5.53e-16 | 3.39e-15 |
%  	 |    8  | 5.82e-16 | 6.35e-15 |
%  	 |    9  | 7.43e-16 | 3.74e-15 |
%  	 |   10  | 6.73e-16 | 4.80e-15 |
%  	 |   11  | 8.83e-16 | 5.08e-15 |
%  	 |   12  | 8.45e-16 | 7.05e-15 |
%  	 |   13  | 1.10e-15 | 8.04e-15 |
%  	 |   14  | 9.42e-16 | 6.91e-15 |
%  	 |   15  | 9.85e-16 | 7.34e-15 |
%  	 .....................................
%  
%  
%  	 *** cos(10*(x+y+z))
% 
%  	 .....................................
%  	 |  deg  |   REL2   |  RELinf  |
%  	 .....................................
%  	 |    1  | 9.11e-01 | 1.66e+00 |
%  	 |    2  | 6.66e-01 | 3.80e+00 |
%  	 |    3  | 1.33e-01 | 1.82e+00 |
%  	 |    4  | 1.23e-01 | 1.48e+00 |
%  	 |    5  | 1.34e-02 | 3.74e-01 |
%  	 |    6  | 1.03e-02 | 1.69e-01 |
%  	 |    7  | 8.59e-04 | 3.76e-02 |
%  	 |    8  | 5.00e-04 | 1.17e-02 |
%  	 |    9  | 3.33e-05 | 1.58e-03 |
%  	 |   10  | 1.53e-05 | 5.26e-04 |
%  	 |   11  | 8.57e-07 | 4.35e-05 |
%  	 |   12  | 3.32e-07 | 1.32e-05 |
%  	 |   13  | 1.66e-08 | 9.78e-07 |
%  	 |   14  | 5.29e-09 | 2.42e-07 |
%  	 |   15  | 2.41e-10 | 1.65e-08 |
%  	 .....................................
%  
%  
%  	 *** exp(-g(x,y,z)), g=@(x,y,z) (x-x0).^2+(y-y0).^2+(z-z0).^2, x0=0;y0=0;z0=1;
% 
%  	 .....................................
%  	 |  deg  |   REL2   |  RELinf  |
%  	 .....................................
%  	 |    1  | 1.12e-01 | 1.33e-01 |
%  	 |    2  | 1.22e-02 | 2.80e-02 |
%  	 |    3  | 1.37e-03 | 2.99e-03 |
%  	 |    4  | 1.13e-04 | 2.96e-04 |
%  	 |    5  | 8.35e-06 | 2.18e-05 |
%  	 |    6  | 5.43e-07 | 1.65e-06 |
%  	 |    7  | 2.97e-08 | 1.06e-07 |
%  	 |    8  | 1.51e-09 | 5.83e-09 |
%  	 |    9  | 6.99e-11 | 2.76e-10 |
%  	 |   10  | 2.86e-12 | 1.39e-11 |
%  	 |   11  | 1.10e-13 | 5.80e-13 |
%  	 |   12  | 3.98e-15 | 1.98e-14 |
%  	 |   13  | 8.60e-16 | 2.94e-15 |
%  	 |   14  | 8.81e-16 | 4.39e-15 |
%  	 |   15  | 7.36e-16 | 3.64e-15 |
%  	 .....................................
%  
%  
%  	 *** exp(-g(x,y,z)), g=@(x,y,z) (x-x0).^2+(y-y0).^2+(z-z0).^2  centroid=(5.774e-01,5.774e-01,5.774e-01)
% 
%  	 .....................................
%  	 |  deg  |   REL2   |  RELinf  |
%  	 .....................................
%  	 |    1  | 2.36e-02 | 1.24e-01 |
%  	 |    2  | 1.25e-03 | 1.11e-02 |
%  	 |    3  | 5.96e-05 | 7.54e-04 |
%  	 |    4  | 2.47e-06 | 3.81e-05 |
%  	 |    5  | 8.45e-08 | 1.86e-06 |
%  	 |    6  | 2.49e-09 | 5.18e-08 |
%  	 |    7  | 6.69e-11 | 2.25e-09 |
%  	 |    8  | 1.52e-12 | 4.40e-11 |
%  	 |    9  | 3.19e-14 | 1.24e-12 |
%  	 |   10  | 9.24e-16 | 2.61e-14 |
%  	 |   11  | 6.99e-16 | 4.16e-15 |
%  	 |   12  | 7.57e-16 | 5.77e-15 |
%  	 |   13  | 8.94e-16 | 8.49e-15 |
%  	 |   14  | 8.81e-16 | 7.16e-15 |
%  	 |   15  | 9.66e-16 | 9.49e-15 |
%  	 .....................................
%  
%  
%  	 *** ((x-x0).^2 + (y-y0).^2 + (z-z0).^2).^(5/2), x0=0; y0=0; z0=1;
% 
%  	 .....................................
%  	 |  deg  |   REL2   |  RELinf  |
%  	 .....................................
%  	 |    1  | 2.52e-01 | 2.74e-01 |
%  	 |    2  | 1.38e-02 | 2.40e-02 |
%  	 |    3  | 8.51e-04 | 1.40e-03 |
%  	 |    4  | 1.23e-04 | 2.75e-04 |
%  	 |    5  | 2.57e-05 | 6.98e-05 |
%  	 |    6  | 7.60e-06 | 1.85e-05 |
%  	 |    7  | 2.45e-06 | 7.48e-06 |
%  	 |    8  | 8.11e-07 | 3.12e-06 |
%  	 |    9  | 3.20e-07 | 1.27e-06 |
%  	 |   10  | 1.35e-07 | 5.59e-07 |
%  	 |   11  | 5.54e-08 | 2.91e-07 |
%  	 |   12  | 2.44e-08 | 1.27e-07 |
%  	 |   13  | 1.15e-08 | 5.04e-08 |
%  	 |   14  | 5.34e-09 | 2.92e-08 |
%  	 |   15  | 2.60e-09 | 1.68e-08 |
%  	 .....................................
%  
%  
%  	 *** ((x-x0).^2 + (y-y0).^2 + (z-z0).^2).^(5/2),  
%      centroid=(5.774e-01,5.774e-01,5.774e-01)
% 
%  	 .....................................
%  	 |  deg  |   REL2   |  RELinf  |
%  	 .....................................
%  	 |    1  | 4.58e-01 | 6.61e-01 |
%  	 |    2  | 3.92e-02 | 7.83e-02 |
%  	 |    3  | 3.03e-03 | 7.31e-03 |
%  	 |    4  | 6.48e-04 | 1.82e-03 |
%  	 |    5  | 1.99e-04 | 6.73e-04 |
%  	 |    6  | 7.49e-05 | 2.21e-04 |
%  	 |    7  | 3.34e-05 | 1.45e-04 |
%  	 |    8  | 1.63e-05 | 6.08e-05 |
%  	 |    9  | 8.62e-06 | 3.98e-05 |
%  	 |   10  | 4.84e-06 | 2.21e-05 |
%  	 |   11  | 2.88e-06 | 1.23e-05 |
%  	 |   12  | 1.79e-06 | 9.33e-06 |
%  	 |   13  | 1.17e-06 | 6.07e-06 |
%  	 |   14  | 7.63e-07 | 3.84e-06 |
%  	 |   15  | 5.22e-07 | 3.06e-06 |
%  	 .....................................
         
 
 
 
 switch deg
 	 case  1
 	 pts=[
 	 6.283738271416106e-01  5.196754164545513e-01  5.788642283784635e-01 
 	 9.442919658434197e-01  3.074458036406993e-02  3.276697331488019e-01 
 	 6.135584751682498e-01  1.182719416783692e-03  7.896484019638065e-01 
 	 2.378454404894541e-03  1.656339765898346e-03  9.999957997377907e-01 
 	 7.081935257374957e-01  6.693425622305499e-01  2.245939992300269e-01 
 	 8.141989296346349e-01  5.805847803688656e-01  1.189867997282910e-03 
 	 1.941492475232882e-01  6.724464956286162e-01  7.142281009614044e-01 
 	 1.196209504370804e-01  9.176348362783835e-01  3.789949016344071e-01 
 	 1.238402973730838e-03  4.442807525930105e-01  8.958867558087142e-01 
 	 ]; 
 

 	  
 

 	 case  2
 	 pts=[
 	 4.174600993231823e-01  3.955762172640921e-01  8.180748876527812e-01 
 	 8.934748195051737e-01  3.165435110925064e-01  3.185952800896861e-01 
 	 2.563448440277797e-01  2.189194919957479e-01  9.414677779747413e-01 
 	 6.298577379338502e-01  1.560504637337993e-01  7.608728426835325e-01 
 	 2.951491590966386e-01  6.520066772095262e-03  9.554289416873630e-01 
 	 9.882953352052239e-01  1.361256160243383e-03  1.525466400589019e-01 
 	 9.073672424974298e-01  1.169488870106883e-03  4.203371498433050e-01 
 	 1.776920545097552e-01  1.336697707719914e-03  9.840852336069983e-01 
 	 6.724369321075885e-01  5.253165179119190e-01  5.214126277207245e-01 
 	 4.174600993231824e-01  8.180748876527812e-01  3.955762172640920e-01 
 	 2.563448440277799e-01  9.414677779747413e-01  2.189194919957479e-01 
 	 6.298577379338501e-01  7.608728426835325e-01  1.560504637337993e-01 
 	 9.722075265983513e-01  1.690459459786418e-01  1.619752863053562e-01 
 	 1.749267978169132e-01  9.795941115867780e-01  9.897470358648035e-02 
 	 9.927040757500040e-01  1.159250255146852e-01  3.316634512197316e-02 
 	 1.776920545097554e-01  9.840852336069982e-01  1.336697707719922e-03 
 	 4.867124185649817e-01  8.735615139619904e-01  1.141463561072685e-03 
 	 9.073672424974298e-01  4.203371498433048e-01  1.169488870106819e-03 
 	 4.396116916034901e-01  6.351147772668803e-01  6.351147772668803e-01 
 	 1.283186005548819e-01  7.012611270959046e-01  7.012611270959045e-01 
 	 1.323952728114516e-01  1.398033129596574e-01  9.812881969241682e-01 
 	 6.396540863146666e-02  3.880320224665384e-01  9.194235020049994e-01 
 	 6.396540863146648e-02  9.194235020049996e-01  3.880320224665381e-01 
 	 1.288744658232319e-03  2.323181538371948e-01  9.726389949692966e-01 
 	 1.288744658232079e-03  9.726389949692966e-01  2.323181538371945e-01 
 	 ]; 
 

 	  
 

 	 case  3
 	 pts=[
 	 5.299832476870265e-01  3.832969997953763e-01  7.564397974187866e-01 
 	 8.370051633122443e-01  3.867829094067657e-01  3.870676137052554e-01 
 	 3.392059922700508e-01  3.308844328447278e-01  8.805991068069017e-01 
 	 7.844757696907745e-01  2.338866291142178e-01  5.743647025102215e-01 
 	 7.207159684701169e-01  1.468387204624571e-01  6.775004671327762e-01 
 	 1.390054196720370e-01  9.582501088727330e-02  9.856444899608858e-01 
 	 9.927600265571633e-01  7.306930773959719e-02  9.533313136930122e-02 
 	 4.248791565706009e-01  5.916841378694801e-02  9.033143423647115e-01 
 	 9.081084707235462e-01  4.109634101185868e-02  4.167134460940506e-01 
 	 9.978837666717825e-01  3.278801126621544e-02  5.615099758812897e-02 
 	 2.034469696285675e-01  1.581295245739060e-02  9.789582631979430e-01 
 	 9.859537848085775e-01  1.262825071585892e-03  1.670135907478185e-01 
 	 6.789629740610299e-01  1.030141906621617e-03  7.341717909739202e-01 
 	 8.181173201418702e-02  1.350177195900028e-03  9.966468870800623e-01 
 	 7.121035773349093e-01  4.990769887607266e-01  4.937921166202942e-01 
 	 5.299832476870268e-01  7.564397974187866e-01  3.832969997953764e-01 
 	 3.392059922700508e-01  8.805991068069017e-01  3.308844328447278e-01 
 	 8.107742827627022e-01  5.354355471561733e-01  2.365456346081980e-01 
 	 9.206788936312681e-01  2.786302555840292e-01  2.733414631831086e-01 
 	 7.207159684701171e-01  6.775004671327760e-01  1.468387204624571e-01 
 	 9.757790002209887e-01  1.549451970895787e-01  1.544258029818827e-01 
 	 1.390054196720370e-01  9.856444899608858e-01  9.582501088727330e-02 
 	 4.248791565706011e-01  9.033143423647114e-01  5.916841378694802e-02 
 	 9.081084707235462e-01  4.167134460940504e-01  4.109634101185868e-02 
 	 9.961809246611838e-01  8.702673965202609e-02  7.064837346116262e-03 
 	 8.181173201418702e-02  9.966468870800622e-01  1.350177195899853e-03 
 	 2.186753041237777e-01  9.757969182418875e-01  1.218899507025181e-03 
 	 6.789629740610301e-01  7.341717909739199e-01  1.030141906621562e-03 
 	 9.691747457147929e-01  2.463714221906318e-01  1.197746397174938e-03 
 	 5.513736947092013e-01  5.959169754895760e-01  5.838407377924912e-01 
 	 4.178622917661158e-01  4.946581628229083e-01  7.620396361559120e-01 
 	 4.178622917661158e-01  7.620396361559121e-01  4.946581628229083e-01 
 	 3.170685379970509e-01  6.706219285903247e-01  6.706219285903244e-01 
 	 2.144222503617396e-01  4.467473653148780e-01  8.685849930398419e-01 
 	 2.071310858336926e-01  2.541192705889882e-01  9.447328244518003e-01 
 	 2.071310858336926e-01  9.447328244518003e-01  2.541192705889884e-01 
 	 1.467584427645286e-01  6.994504841221182e-01  6.994504841221179e-01 
 	 1.506128051264253e-01  8.302509651718983e-01  5.366554926236019e-01 
 	 5.085686877971457e-02  8.423688803179512e-02  9.951470874160471e-01 
 	 4.109634101185888e-02  4.167134460940506e-01  9.081084707235462e-01 
 	 4.109634101185876e-02  9.081084707235463e-01  4.167134460940504e-01 
 	 5.131972836906255e-02  9.959230034704895e-01  7.418663382608118e-02 
 	 1.319530243309438e-02  7.070452192023150e-01  7.070452192023148e-01 
 	 1.350177195900162e-03  8.181173201418708e-02  9.966468870800623e-01 
 	 1.197746397175199e-03  2.463714221906322e-01  9.691747457147927e-01 
 	 1.067617573375730e-03  4.942462084734877e-01  8.693213132106555e-01 
 	 1.079208869151377e-03  8.868201833097790e-01  4.621134035955102e-01 
 	 1.218899507025202e-03  9.757969182418876e-01  2.186753041237776e-01 
 	 1.350177195899923e-03  9.966468870800623e-01  8.181173201418696e-02 
 	 ]; 
 

 	  
 

 	 case  4
 	 pts=[
 	 6.025152560207548e-01  5.544964060367248e-01  5.740288337310243e-01 
 	 6.216785701989944e-01  4.331465006054519e-01  6.526100400458035e-01 
 	 4.674724018664975e-01  4.362577776558098e-01  7.688619544027276e-01 
 	 7.767995281107104e-01  4.045438562923043e-01  4.826248661881494e-01 
 	 3.470615318058546e-01  3.128927523350221e-01  8.841076963112515e-01 
 	 8.219692362767609e-01  2.561308193468037e-01  5.086880950005941e-01 
 	 6.683819441877055e-01  2.471325872357409e-01  7.015632979354264e-01 
 	 2.787927120966964e-01  2.249885432288322e-01  9.336245386115001e-01 
 	 9.158604877835587e-01  1.829002737288931e-01  3.574172027012102e-01 
 	 5.683675724733757e-01  1.675464551989100e-01  8.055349079406813e-01 
 	 8.371924028698011e-01  1.175467109711285e-01  5.341269992398423e-01 
 	 2.308859224347129e-01  1.370657454212030e-01  9.632780866673972e-01 
 	 4.951703949951176e-01  7.362257065237419e-02  8.656708364100730e-01 
 	 9.524535648084559e-01  5.933002514532837e-02  2.988513928358358e-01 
 	 1.519704858524294e-01  6.556934486840019e-02  9.862077024862995e-01 
 	 7.086873297229092e-02  7.032021981830816e-02  9.950038639983299e-01 
 	 9.947406361942631e-01  4.756245986620018e-02  9.071316947008713e-02 
 	 8.644830554393663e-01  5.253509670501207e-03  5.026345068679223e-01 
 	 9.999971514018703e-01  1.365396173617570e-03  1.957774612638783e-03 
 	 9.970396404607489e-01  1.273788238404592e-03  7.687868894189233e-02 
 	 9.908675627502359e-01  1.215128888443598e-03  1.348332175363025e-01 
 	 9.260819458309700e-01  1.049317725423266e-03  3.773209887327175e-01 
 	 7.071064505550348e-01  9.670402887348060e-04  7.071064505550350e-01 
 	 5.013006010292169e-01  1.000776266431367e-03  8.652726193834002e-01 
 	 2.880859112399187e-01  1.097974783883054e-03  9.576039380643961e-01 
 	 1.572468403166009e-01  1.194829287084496e-03  9.875586076752205e-01 
 	 4.675590911203794e-02  1.308252398959105e-03  9.989054877408410e-01 
 	 7.139055135784995e-01  5.427139114535268e-01  4.424935344126875e-01 
 	 4.391273607579697e-01  7.960935583643037e-01  4.164159067141900e-01 
 	 6.369285497513694e-01  6.826605087652039e-01  3.581852206387785e-01 
 	 8.162593970431241e-01  5.018084419105765e-01  2.861972822478839e-01 
 	 9.031109659997620e-01  3.215724513322085e-01  2.845729109299953e-01 
 	 5.765867871674587e-01  7.862063682182283e-01  2.223223412907736e-01 
 	 7.409838307071602e-01  6.345052884149796e-01  2.198772421237950e-01 
 	 3.930952170515624e-01  8.954281628200056e-01  2.090085059512521e-01 
 	 5.091335306861816e-01  8.524961380135443e-01  1.184625789142501e-01 
 	 9.664517740208634e-01  2.162637583549849e-01  1.385675117554717e-01 
 	 8.269902558592247e-01  5.543662977511864e-01  9.362224432012428e-02 
 	 7.053281832112194e-01  7.053281832112193e-01  7.088235278206494e-02 
 	 2.988513928358359e-01  9.524535648084559e-01  5.933002514532842e-02 
 	 9.348234532056187e-01  3.503954936386248e-01  5.768976836898145e-02 
 	 9.801825017512816e-01  1.875370108267962e-01  6.381326531959404e-02 
 	 6.226700896731103e-02  9.968657393050558e-01  4.880079296537437e-02 
 	 1.521909734111576e-01  9.873165217619420e-01  4.521054598282357e-02 
 	 1.957774612638664e-03  9.999971514018703e-01  1.365396173617497e-03 
 	 4.675590911203800e-02  9.989054877408410e-01  1.308252398959049e-03 
 	 1.348332175363024e-01  9.908675627502359e-01  1.215128888443589e-03 
 	 2.880859112399187e-01  9.576039380643960e-01  1.097974783882935e-03 
 	 5.013006010292169e-01  8.652726193834002e-01  1.000776266431534e-03 
 	 7.333386613785143e-01  6.798628326513239e-01  9.677328590315649e-04 
 	 8.652726193834001e-01  5.013006010292170e-01  1.000776266431423e-03 
 	 9.576039380643960e-01  2.880859112399186e-01  1.097974783882935e-03 
 	 9.834721054517022e-01  1.810558979343311e-01  1.174572939061554e-03 
 	 9.981417561552589e-01  6.092098315521823e-02  1.291677474179980e-03 
 	 5.139089582094730e-01  6.272971896830116e-01  5.851459804936284e-01 
 	 5.074813104460262e-01  5.378288498408550e-01  6.732034223225898e-01 
 	 3.579084225593143e-01  6.716195329630522e-01  6.487131600357703e-01 
 	 3.009490409785748e-01  8.638250862356364e-01  4.040246219280103e-01 
 	 2.597976156381869e-01  4.744387987662361e-01  8.410784892826376e-01 
 	 2.205175643120413e-01  6.153724649336846e-01  7.567620056737294e-01 
 	 1.936586268184891e-01  7.811584564600886e-01  5.935383746310504e-01 
 	 2.193195464059241e-01  9.236049323602290e-01  3.144087554190509e-01 
 	 1.306899529037273e-01  3.013880186645932e-01  9.445027254674558e-01 
 	 1.175467109711287e-01  5.341269992398422e-01  8.371924028698011e-01 
 	 1.194872100168393e-01  8.667431241717121e-01  4.842304857642193e-01 
 	 1.464169598205403e-01  9.779350380785290e-01  1.490138757809362e-01 
 	 6.199562455271108e-02  2.285568401817280e-01  9.715545858789734e-01 
 	 5.693021585310788e-02  3.772356306754492e-01  9.243658526102176e-01 
 	 5.849159039504717e-02  9.441688334584712e-01  3.242282340863109e-01 
 	 6.639603293594906e-02  9.884259925906234e-01  1.364024339284655e-01 
 	 4.584776575541652e-02  1.344425428639296e-01  9.898601845935198e-01 
 	 3.679065119285764e-02  5.702973488500940e-01  8.206140273474245e-01 
 	 3.628878280827356e-02  7.555046655931306e-01  6.541374660645161e-01 
 	 1.365396173617745e-03  1.957774612638783e-03  9.999971514018703e-01 
 	 1.308252398959292e-03  4.675590911203799e-02  9.989054877408410e-01 
 	 1.154577394583638e-03  2.061575859200867e-01  9.785181228360780e-01 
 	 1.011005362408245e-03  4.701945318410587e-01  8.825622244889733e-01 
 	 9.781031709972994e-04  8.051277332577724e-01  5.931006461414353e-01 
 	 1.022530438644319e-03  8.984533821439603e-01  4.390677334370871e-01 
 	 1.116119981563126e-03  9.656638695422977e-01  2.597923119277843e-01 
 	 1.194829287084634e-03  9.875586076752205e-01  1.572468403166009e-01 
 	 ]; 
 

 	  
 

 	 case  5
 	 pts=[
 	 5.847711891382312e-01  5.542298093699686e-01  5.923444730556598e-01 
 	 6.943429781172145e-01  5.002199240972508e-01  5.173662689772671e-01 
 	 5.831993473029519e-01  4.440701306480899e-01  6.802060278853749e-01 
 	 4.652425780364650e-01  4.474409801718583e-01  7.637708510049532e-01 
 	 7.154300376921389e-01  3.724416235062690e-01  5.911405063500887e-01 
 	 6.029806603608913e-01  3.193162226589658e-01  7.310618805392285e-01 
 	 8.632431245236444e-01  3.207927318308103e-01  3.897477789124418e-01 
 	 3.727265215357304e-01  3.246151496965181e-01  8.693100394746295e-01 
 	 5.188551578142534e-01  2.714518999459903e-01  8.106190173103875e-01 
 	 7.637655822260928e-01  2.377155840052294e-01  6.001278501518572e-01 
 	 5.958128008936545e-01  1.839745821165340e-01  7.817675226218501e-01 
 	 8.345409503103762e-01  1.608770343804055e-01  5.269345140186017e-01 
 	 3.253538825662584e-01  1.767650047290499e-01  9.289235620879688e-01 
 	 2.152289820125100e-01  1.913178004306257e-01  9.576397989537850e-01 
 	 9.603963399875987e-01  1.583975631917884e-01  2.292358656784062e-01 
 	 4.968931702524873e-01  1.368332629093797e-01  8.569561456212361e-01 
 	 9.015286307602354e-01  1.162261984711890e-01  4.168184241471472e-01 
 	 7.451542467882933e-01  1.085903557617706e-01  6.579918564305361e-01 
 	 8.250404089664981e-01  8.842688236533870e-02  5.581120049304980e-01 
 	 5.771352201216481e-01  5.008395675041775e-02  8.151113635395835e-01 
 	 3.855976696001572e-01  5.349762624039825e-02  9.211147817647758e-01 
 	 2.605535704280939e-01  5.726874944911111e-02  9.637593720808670e-01 
 	 9.961393923990685e-01  4.544369345719811e-02  7.510780009947741e-02 
 	 9.679474805685349e-01  3.984018642692944e-02  2.479726485048170e-01 
 	 8.712215508466653e-01  3.547706140068545e-02  4.896063596959333e-01 
 	 6.815733311497778e-01  3.414580047947519e-02  7.309527061137480e-01 
 	 2.027053507609139e-01  4.105694334226219e-02  9.783786936438698e-01 
 	 1.692815125785455e-01  2.644684579240687e-02  9.852128368260091e-01 
 	 4.652801644106565e-02  1.585802208006837e-02  9.987911026945364e-01 
 	 9.997440677898924e-01  1.259490133772318e-03  2.258788621190468e-02 
 	 9.973767791731546e-01  1.203595486572621e-03  7.237480033885557e-02 
 	 9.889427071284944e-01  1.132099355979374e-03  1.482937637542899e-01 
 	 9.443594981201096e-01  1.011043915352679e-03  3.289135389438022e-01 
 	 8.024290690006690e-01  9.200037566137861e-04  5.967467995857266e-01 
 	 4.475955660729710e-01  9.593487390785378e-04  8.942355891384628e-01 
 	 3.289135389438021e-01  1.011043915352790e-03  9.443594981201096e-01 
 	 2.196153635890035e-01  1.077144046402213e-03  9.755859428242973e-01 
 	 5.733382490022276e-02  1.219647705900649e-03  9.983543183568567e-01 
 	 3.239502326950708e-02  1.247834670452438e-03  9.994743645416841e-01 
 	 5.997941095126523e-01  6.244691143554685e-01  5.002852700310306e-01 
 	 4.798901958619131e-01  7.419803169194535e-01  4.681566075788335e-01 
 	 6.855329764185629e-01  6.111456912656487e-01  3.956582898033839e-01 
 	 7.882162651103981e-01  4.428153253236815e-01  4.273519709488850e-01 
 	 4.299103159950649e-01  8.223291902604525e-01  3.727624217200711e-01 
 	 5.778832132837768e-01  7.382842795156122e-01  3.478323079084669e-01 
 	 3.727265215357305e-01  8.693100394746295e-01  3.246151496965180e-01 
 	 6.974621282735772e-01  6.666651379919256e-01  2.628767266425439e-01 
 	 8.201209276842655e-01  5.027833109338607e-01  2.731494210513439e-01 
 	 5.460388026569872e-01  8.023342041868343e-01  2.410424252798729e-01 
 	 9.175831698360406e-01  2.833978850112961e-01  2.787952029801947e-01 
 	 8.830774394760014e-01  4.114088743310658e-01  2.256478983065304e-01 
 	 2.774562983268523e-01  9.366957910650464e-01  2.135860424273732e-01 
 	 5.490205414237121e-01  8.203861701550277e-01  1.598217035110683e-01 
 	 7.727586358190870e-01  6.148597591190559e-01  1.574533816184342e-01 
 	 8.697632697690236e-01  4.737796555972516e-01  1.380025090454743e-01 
 	 9.452918668758273e-01  2.887124346668517e-01  1.518829038672627e-01 
 	 2.503451642275809e-01  9.627817799105404e-01  1.018751344546715e-01 
 	 9.196268838549351e-01  3.812706935630291e-01  9.444073655594065e-02 
 	 9.858971404323713e-01  1.240246345660376e-01  1.123597726414304e-01 
 	 3.951778062159739e-01  9.157514467990929e-01  7.234493181763471e-02 
 	 5.272678717424834e-01  8.469063289093611e-01  6.883503091755735e-02 
 	 7.285707992411110e-01  6.816873517792743e-01  6.698466180648045e-02 
 	 9.736327545175748e-01  2.134797030720226e-01  8.040942548483442e-02 
 	 2.247831945535167e-01  9.735690827817686e-01  4.044448661785511e-02 
 	 7.978107172326657e-01  6.019220656791823e-01  3.446572670357548e-02 
 	 9.539982357836612e-01  2.973069966169572e-01  3.867707181608821e-02 
 	 9.886514048501286e-01  1.439778494994622e-01  4.288098111491116e-02 
 	 3.029165475590199e-02  9.990982343238702e-01  2.975119868297762e-02 
 	 8.281044906907502e-02  9.961620965335176e-01  2.834619824465037e-02 
 	 6.000400901943564e-01  7.996746793777433e-01  2.173240257431087e-02 
 	 9.986698166845028e-01  4.235215829501512e-02  2.940904505581989e-02 
 	 1.460443799779451e-02  9.998925439504385e-01  1.269229328685080e-03 
 	 1.946500695534485e-01  9.808721379340679e-01  1.095192900100732e-03 
 	 3.004017550944908e-01  9.538122100275319e-01  1.026420257530882e-03 
 	 4.174853604419246e-01  9.086831304600953e-01  9.706873429711079e-04 
 	 7.569715770465872e-01  6.534471658715354e-01  9.126653607664787e-04 
 	 8.430248899421883e-01  5.378737453732707e-01  9.321888710234432e-04 
 	 9.443594981201096e-01  3.289135389438020e-01  1.011043915352734e-03 
 	 9.852975091422187e-01  1.708437252011858e-01  1.113569719964644e-03 
 	 9.942238316888108e-01  1.073201116339599e-01  1.168820299960040e-03 
 	 9.983543183568568e-01  5.733382490022276e-02  1.219647705900714e-03 
 	 9.999974773256050e-01  1.842113945067180e-03  1.285285431267057e-03 
 	 5.435877166735839e-01  5.989904117915653e-01  5.879820412762370e-01 
 	 4.885719833399058e-01  5.582371401710757e-01  6.705734206102488e-01 
 	 3.943878408562675e-01  6.497915938917382e-01  6.497915938917381e-01 
 	 3.609454404705486e-01  7.970550736574570e-01  4.841710426702815e-01 
 	 2.944436016009562e-01  5.720246255839816e-01  7.655656687716365e-01 
 	 2.788566864498802e-01  4.566809936057282e-01  8.447966728754784e-01 
 	 2.731494210513440e-01  8.201209276842655e-01  5.027833109338609e-01 
 	 2.731702350375805e-01  3.090624433742455e-01  9.109656573027626e-01 
 	 2.369290259560251e-01  7.495968006939944e-01  6.180366275948841e-01 
 	 2.276688137533298e-01  8.900362064107900e-01  3.949714705165950e-01 
 	 1.598217035110685e-01  5.490205414237121e-01  8.203861701550277e-01 
 	 1.598217035110684e-01  8.203861701550277e-01  5.490205414237120e-01 
 	 1.822726032664545e-01  9.428471534713661e-01  2.789550918865114e-01 
 	 1.261810625470411e-01  2.690853872335285e-01  9.548148479322480e-01 
 	 1.150288813936881e-01  4.405260661962201e-01  8.903399021985932e-01 
 	 1.084184072051398e-01  6.807729112260946e-01  7.244264574957547e-01 
 	 1.150288813936880e-01  8.903399021985933e-01  4.405260661962199e-01 
 	 1.345499971759208e-01  9.740876522664649e-01  1.817953353691076e-01 
 	 1.131948277671696e-01  1.157593797159106e-01  9.868063117828891e-01 
 	 6.833839244679754e-02  8.297969553398360e-01  5.538653961266453e-01 
 	 8.535686628403497e-02  9.870114375193390e-01  1.360978603218194e-01 
 	 5.418209877281889e-02  3.591978536368144e-01  9.316872877287090e-01 
 	 4.581709919202372e-02  6.612993782137233e-02  9.967585589024905e-01 
 	 3.446572670357564e-02  6.019220656791823e-01  7.978107172326658e-01 
 	 3.414580047947540e-02  7.309527061137480e-01  6.815733311497777e-01 
 	 3.622096448882438e-02  9.007124298266430e-01  4.329031768043334e-01 
 	 3.812732355902478e-02  9.455459557447666e-01  3.232478194403499e-01 
 	 4.105694334226197e-02  9.783786936438698e-01  2.027053507609138e-01 
 	 4.401556294733595e-02  9.927556863482144e-01  1.117979312944325e-01 
 	 2.604122735448518e-02  1.907808033904170e-01  9.812871850460390e-01 
 	 1.585802208006857e-02  4.652801644106588e-02  9.987911026945364e-01 
 	 1.186570093150755e-03  8.905792377549113e-02  9.960257417678585e-01 
 	 1.026420257531018e-03  3.004017550944907e-01  9.538122100275318e-01 
 	 9.400745258693299e-04  5.079183501700246e-01  8.614047050141102e-01 
 	 9.157253149548146e-04  6.254252213281316e-01  7.802835727950481e-01 
 	 1.026420257530907e-03  9.538122100275318e-01  3.004017550944908e-01 
 	 1.113569719964655e-03  9.852975091422186e-01  1.708437252011858e-01 
 	 1.219647705900662e-03  9.983543183568567e-01  5.733382490022275e-02 
 	 1.259490133772311e-03  9.997440677898923e-01  2.258788621190450e-02 
 	 ]; 
 

 	  
 

 	 case  6
 	 pts=[
 	 6.168411295273103e-01  5.353225646905641e-01  5.770067353650118e-01 
 	 7.094090297010931e-01  4.891093581907208e-01  5.074552830632615e-01 
 	 6.120225224388846e-01  4.488179486427815e-01  6.511458216126635e-01 
 	 5.230767975215741e-01  4.628130615432319e-01  7.156778143547240e-01 
 	 7.681886171408325e-01  4.281851022289828e-01  4.759661403129545e-01 
 	 5.144494669208263e-01  3.938335869879924e-01  7.617327955031535e-01 
 	 8.043614940895525e-01  3.467951898063509e-01  4.824268681916461e-01 
 	 6.793809356348108e-01  3.301106432928862e-01  6.553384678780316e-01 
 	 6.500653990585372e-01  2.779661000443200e-01  7.072127149401485e-01 
 	 4.432353782615101e-01  2.969025564155516e-01  8.458080582799422e-01 
 	 5.533964125249672e-01  2.564074834638342e-01  7.924693136192972e-01 
 	 8.898469145993406e-01  2.474155584047306e-01  3.833510271765413e-01 
 	 8.158090188647252e-01  2.311557511108753e-01  5.301157076217808e-01 
 	 3.569492289740349e-01  2.514979449670365e-01  8.996310530501932e-01 
 	 7.498067691167730e-01  1.737910368802692e-01  6.384250030244329e-01 
 	 5.158275649915843e-01  1.788985657096301e-01  8.378050049873718e-01 
 	 8.712248964736462e-01  1.562453677205696e-01  4.653542358573182e-01 
 	 9.639470564347671e-01  1.512493858772162e-01  2.189285172436723e-01 
 	 6.593274074156226e-01  1.251542945879615e-01  7.413661527051146e-01 
 	 4.332009473202167e-01  1.331191112779611e-01  8.914124979230619e-01 
 	 9.194363934986913e-01  1.122409024865541e-01  3.768802172031896e-01 
 	 3.336784529664453e-01  1.148604810694842e-01  9.356632727185600e-01 
 	 9.877635928864702e-01  1.072514267549738e-01  1.132263928023586e-01 
 	 7.476068502677448e-01  8.226374546717338e-02  6.590270659194917e-01 
 	 5.617204768988268e-01  8.364288227188818e-02  8.230880718840515e-01 
 	 3.056633215726818e-01  7.165439280758665e-02  9.494396146340911e-01 
 	 2.029994637135368e-01  7.657742291981080e-02  9.761798584436051e-01 
 	 1.292369145305870e-01  8.112281310472719e-02  9.882898912346465e-01 
 	 9.613353804454312e-01  5.378577250200777e-02  2.700766131678199e-01 
 	 9.178728523919563e-01  5.036393287940897e-02  3.936659765674100e-01 
 	 9.965413755265141e-01  4.304844358759355e-02  7.107825524314063e-02 
 	 8.339716538567332e-01  3.291048478496991e-02  5.508249999361717e-01 
 	 6.823027696165747e-01  3.224601106883818e-02  7.303582171398496e-01 
 	 5.780467470751405e-01  3.270250835522134e-02  8.153480877166053e-01 
 	 9.790176657058141e-01  2.437743063075135e-02  2.023120142546699e-01 
 	 4.351755644966757e-01  2.151796499444357e-02  9.000884430140726e-01 
 	 1.602618836099730e-01  2.512276463789889e-02  9.867547696153955e-01 
 	 6.631745339197845e-02  2.713889257823528e-02  9.974294340379322e-01 
 	 9.912721553556740e-01  1.391730125101759e-02  1.310947090557243e-01 
 	 9.476828198425401e-01  1.231531886902594e-02  3.189758703984456e-01 
 	 9.999977579556232e-01  1.212018716627849e-03  1.736402705980244e-03 
 	 9.991393584446282e-01  1.166696024665418e-03  4.146301034950002e-02 
 	 9.976674531387402e-01  1.138955194283422e-03  6.825214816198344e-02 
 	 9.868802293996515e-01  1.057138587757474e-03  1.614505970199477e-01 
 	 9.660716354059318e-01  9.914513804362547e-04  2.582723606742867e-01 
 	 9.176990955471386e-01  9.230691176675486e-04  3.972751162297581e-01 
 	 7.318170485648793e-01  8.587983206131420e-04  6.815006015369566e-01 
 	 5.718744032623373e-01  8.718236641864605e-04  8.203407260503675e-01 
 	 3.972751162297578e-01  9.230691176675313e-04  9.176990955471387e-01 
 	 3.121182646633256e-01  9.617223786792294e-04  9.500427695391511e-01 
 	 2.325568934028418e-01  1.007264042119750e-03  9.725822724839112e-01 
 	 5.405240055763264e-02  1.153394395658503e-03  9.985374342884323e-01 
 	 2.128221395522046e-02  1.189057365286953e-03  9.997728009461682e-01 
 	 6.175502942845343e-01  6.175502942845341e-01  4.870967748386048e-01 
 	 5.400357469799033e-01  7.329508927299514e-01  4.136960005006393e-01 
 	 6.539975574660629e-01  6.539975574660628e-01  3.802293908377514e-01 
 	 7.444134003709995e-01  5.426776575110936e-01  3.890368226612467e-01 
 	 4.935753738267266e-01  7.983917956067677e-01  3.448969281678346e-01 
 	 7.983917956067678e-01  4.935753738267265e-01  3.448969281678346e-01 
 	 6.198582393761677e-01  7.334423576144843e-01  2.789947510875150e-01 
 	 7.334423576144844e-01  6.198582393761676e-01  2.789947510875150e-01 
 	 3.458635917491080e-01  8.941445121110569e-01  2.844010677970221e-01 
 	 8.941445121110569e-01  3.458635917491080e-01  2.844010677970221e-01 
 	 5.480673227037774e-01  8.042357348852928e-01  2.298414508260569e-01 
 	 6.890247728803270e-01  6.890247728803268e-01  2.246991871690409e-01 
 	 8.042357348852929e-01  5.480673227037772e-01  2.298414508260569e-01 
 	 2.804334443154638e-01  9.310516321921888e-01  2.334522253087917e-01 
 	 8.849463370728499e-01  4.133015980172141e-01  2.145967604083608e-01 
 	 9.310516321921889e-01  2.804334443154636e-01  2.334522253087917e-01 
 	 2.216890706634067e-01  9.582784282202292e-01  1.804339490122687e-01 
 	 5.083920563585272e-01  8.472870954810648e-01  1.537598610262408e-01 
 	 6.169325345209200e-01  7.726774167438619e-01  1.495455031207095e-01 
 	 6.992691166311916e-01  6.992691166311915e-01  1.484769512472087e-01 
 	 7.892325306326791e-01  5.954574653423321e-01  1.501413319483436e-01 
 	 8.472870954810651e-01  5.083920563585269e-01  1.537598610262409e-01 
 	 9.582784282202292e-01  2.216890706634065e-01  1.804339490122689e-01 
 	 1.963738905739984e-01  9.724157515053214e-01  1.258765320668317e-01 
 	 3.994035625710458e-01  9.100292104734964e-01  1.110118475233232e-01 
 	 9.100292104734965e-01  3.994035625710456e-01  1.110118475233232e-01 
 	 6.590270659194918e-01  7.476068502677448e-01  8.226374546717344e-02 
 	 5.835467402610182e-01  8.095383934676751e-01  6.419339087877843e-02 
 	 8.095383934676753e-01  5.835467402610179e-01  6.419339087877843e-02 
 	 1.519654445102641e-01  9.866592220592606e-01  5.839591766735504e-02 
 	 2.700766131678199e-01  9.613353804454312e-01  5.378577250200776e-02 
 	 9.613353804454314e-01  2.700766131678197e-01  5.378577250200776e-02 
 	 9.866592220592606e-01  1.519654445102641e-01  5.839591766735511e-02 
 	 4.130271468036344e-01  9.100655647599285e-01  3.448541490893597e-02 
 	 9.100655647599286e-01  4.130271468036341e-01  3.448541490893591e-02 
 	 6.631745339197845e-02  9.974294340379322e-01  2.713889257823517e-02 
 	 2.250342459752732e-01  9.740550080551951e-01  2.400894460266868e-02 
 	 7.069610283210174e-01  7.069610283210171e-01  2.030292763568039e-02 
 	 9.740550080551952e-01  2.250342459752732e-01  2.400894460266857e-02 
 	 9.974294340379323e-01  6.631745339197832e-02  2.713889257823517e-02 
 	 9.991948286881507e-01  2.862360226324947e-02  2.811376382365973e-02 
 	 2.760619131348957e-02  9.995029006095054e-01  1.522661729827650e-02 
 	 1.715756826933637e-01  9.850784438942685e-01  1.349979567077693e-02 
 	 6.017728397211498e-01  7.985897460450319e-01  1.112955011107201e-02 
 	 9.850784438942685e-01  1.715756826933635e-01  1.349979567077693e-02 
 	 1.736402705980189e-03  9.999977579556232e-01  1.212018716627896e-03 
 	 2.128221395522051e-02  9.997728009461682e-01  1.189057365286897e-03 
 	 5.405240055763311e-02  9.985374342884323e-01  1.153394395658465e-03 
 	 2.325568934028421e-01  9.725822724839110e-01  1.007264042119758e-03 
 	 3.400320224330855e-01  9.404133798792031e-01  9.479790290553595e-04 
 	 4.849205851677780e-01  8.745577333332685e-01  8.928311796974628e-04 
 	 7.071065207589440e-01  7.071065207589438e-01  8.582542528396354e-04 
 	 8.745577333332686e-01  4.849205851677778e-01  8.928311796974628e-04 
 	 9.176990955471388e-01  3.972751162297579e-01  9.230691176676596e-04 
 	 9.725822724839112e-01  2.325568934028418e-01  1.007264042119694e-03 
 	 9.985374342884323e-01  5.405240055763264e-02  1.153394395658568e-03 
 	 9.997728009461682e-01  2.128221395522039e-02  1.189057365286897e-03 
 	 5.481584343737563e-01  6.112098709482475e-01  5.709157770462635e-01 
 	 4.906907858277321e-01  5.746843879474735e-01  6.549506904746346e-01 
 	 4.859588279242195e-01  7.048700113086133e-01  5.167226380954433e-01 
 	 4.379468017676352e-01  4.448540620175029e-01  7.812217753800949e-01 
 	 4.075287803470146e-01  5.839654605449401e-01  7.020716730358880e-01 
 	 4.216408788723200e-01  7.556312803076581e-01  5.012388028518813e-01 
 	 3.412990596814581e-01  5.169099423306446e-01  7.850599106948986e-01 
 	 3.301106432928864e-01  6.793809356348108e-01  6.553384678780316e-01 
 	 3.352739947624109e-01  7.527331255432530e-01  5.665546665114852e-01 
 	 3.467951898063510e-01  8.043614940895525e-01  4.824268681916460e-01 
 	 3.478043424801222e-01  3.480788000110229e-01  8.705591814086255e-01 
 	 3.053694011665679e-01  6.190387102816700e-01  7.235610575507627e-01 
 	 3.332650705212053e-01  8.509332673989334e-01  4.060135061845497e-01 
 	 2.564074834638343e-01  5.533964125249672e-01  7.924693136192971e-01 
 	 2.474155584047308e-01  3.833510271765412e-01  8.898469145993405e-01 
 	 2.311557511108755e-01  8.158090188647255e-01  5.301157076217806e-01 
 	 2.474155584047308e-01  8.898469145993406e-01  3.833510271765412e-01 
 	 2.409027554141442e-01  2.412698397079758e-01  9.400822979298997e-01 
 	 1.788985657096303e-01  5.158275649915846e-01  8.378050049873715e-01 
 	 1.737910368802693e-01  7.498067691167731e-01  6.384250030244328e-01 
 	 1.674217981501013e-01  3.286711315949035e-01  9.294865403868485e-01 
 	 1.562453677205696e-01  8.712248964736463e-01  4.653542358573179e-01 
 	 1.588570683436878e-01  1.592852290234447e-01  9.743678194871779e-01 
 	 1.331191112779612e-01  4.332009473202167e-01  8.914124979230618e-01 
 	 1.251542945879616e-01  6.593274074156227e-01  7.413661527051144e-01 
 	 1.435688267156772e-01  9.452726219456877e-01  2.929977170481178e-01 
 	 1.232493056013154e-01  2.243700684351822e-01  9.666786855306085e-01 
 	 1.122409024865543e-01  9.194363934986914e-01  3.768802172031895e-01 
 	 1.232493056013152e-01  9.666786855306085e-01  2.243700684351822e-01 
 	 8.226374546717354e-02  7.476068502677449e-01  6.590270659194916e-01 
 	 8.364288227188828e-02  8.230880718840515e-01  5.617204768988268e-01 
 	 1.072514267549738e-01  9.877635928864703e-01  1.132263928023585e-01 
 	 7.851448033626143e-02  1.696243156115054e-01  9.823762354265576e-01 
 	 7.165439280758691e-02  3.056633215726819e-01  9.494396146340911e-01 
 	 6.743799919606154e-02  4.279385828309692e-01  9.012883476385644e-01 
 	 6.290509561758903e-02  6.548421786304599e-02  9.958688498774360e-01 
 	 5.378577250200790e-02  9.613353804454313e-01  2.700766131678197e-01 
 	 3.270250835522154e-02  5.780467470751408e-01  8.153480877166052e-01 
 	 3.222691427382315e-02  7.067394944377977e-01  7.067394944377975e-01 
 	 3.291048478496999e-02  8.339716538567332e-01  5.508249999361715e-01 
 	 2.512276463789901e-02  1.602618836099730e-01  9.867547696153954e-01 
 	 2.400894460266882e-02  2.250342459752732e-01  9.740550080551952e-01 
 	 2.151796499444389e-02  4.351755644966759e-01  9.000884430140724e-01 
 	 2.176694937751061e-02  9.131131160395276e-01  4.071248423166794e-01 
 	 2.437743063075136e-02  9.790176657058142e-01  2.023120142546698e-01 
 	 2.685126498198577e-02  9.965695113356862e-01  7.828293968048805e-02 
 	 1.512067610426698e-02  3.492350087084133e-02  9.992755947390460e-01 
 	 1.468448943342017e-02  6.681914257579025e-02  9.976570392452087e-01 
 	 1.231531886902595e-02  9.476828198425401e-01  3.189758703984453e-01 
 	 1.391730125101772e-02  9.912721553556739e-01  1.310947090557244e-01 
 	 1.212018716628089e-03  1.736402705980253e-03  9.999977579556233e-01 
 	 1.153394395658588e-03  5.405240055763298e-02  9.985374342884323e-01 
 	 9.617223786794300e-04  3.121182646633257e-01  9.500427695391510e-01 
 	 9.230691176678549e-04  3.972751162297581e-01  9.176990955471386e-01 
 	 8.928311796976696e-04  4.849205851677780e-01  8.745577333332685e-01 
 	 8.587983206132881e-04  7.318170485648793e-01  6.815006015369566e-01 
 	 9.230691176676157e-04  9.176990955471387e-01  3.972751162297578e-01 
 	 1.166696024665587e-03  9.991393584446282e-01  4.146301034949985e-02 
 	 1.197738126672659e-03  9.999046257275175e-01  1.375881070780302e-02 
 	 ]; 
 

 	  
 

 	 case  7
 	 pts=[
 	 6.039165176712368e-01  5.607227633165525e-01  5.664581382436802e-01 
 	 5.634725942574036e-01  5.135511583127913e-01  6.471196514682751e-01 
 	 6.225353337680370e-01  4.742357182041834e-01  6.225353337680369e-01 
 	 7.048681593990445e-01  4.671796606167817e-01  5.337640326692985e-01 
 	 7.466075579890181e-01  4.612527061795541e-01  4.793986810533723e-01 
 	 5.861859776669814e-01  4.375722077132658e-01  6.818479028519071e-01 
 	 7.952809320633126e-01  4.264833688852862e-01  4.308598091731995e-01 
 	 4.834674772866571e-01  4.111399591432118e-01  7.728021301742082e-01 
 	 7.300830152628478e-01  3.712726929428439e-01  5.737032144756355e-01 
 	 6.678645047568640e-01  3.666502935083770e-01  6.477071603402959e-01 
 	 8.396981442677971e-01  3.838838718075985e-01  3.841096190922914e-01 
 	 4.115875059878670e-01  3.758495490419680e-01  8.302607068864796e-01 
 	 7.831985532091760e-01  3.262705264878545e-01  5.292896841960854e-01 
 	 5.938986809301960e-01  3.199316685950029e-01  7.381924438920995e-01 
 	 8.984104855290093e-01  3.103850270626301e-01  3.106762534646964e-01 
 	 6.816587935823547e-01  2.658619533963015e-01  6.816587935823548e-01 
 	 5.290563511829754e-01  2.736176329734555e-01  8.032638222893893e-01 
 	 3.735534563973491e-01  2.961533003547849e-01  8.790625904351534e-01 
 	 8.778632082344952e-01  2.621147334367079e-01  4.008142389482225e-01 
 	 8.483002134745775e-01  2.249274682104420e-01  4.793687326718618e-01 
 	 7.379994391513612e-01  2.152332875667633e-01  6.395556736793752e-01 
 	 6.400532305720601e-01  1.900383562241834e-01  7.444577121622689e-01 
 	 5.640190003429825e-01  1.928792255434357e-01  8.029197790600674e-01 
 	 9.573289372417663e-01  2.041676429902259e-01  2.045406548228642e-01 
 	 9.292862952027801e-01  1.875449353744982e-01  3.182041463646675e-01 
 	 4.586896999698997e-01  1.740690043755009e-01  8.713803652006655e-01 
 	 3.182041463646674e-01  1.875449353744982e-01  9.292862952027802e-01 
 	 8.812903442592859e-01  1.496196527104652e-01  4.482647528393787e-01 
 	 7.375406155099352e-01  1.414588673321968e-01  6.603205504346491e-01 
 	 2.319010215692778e-01  1.699399795758511e-01  9.577798909649776e-01 
 	 9.449524641541808e-01  1.358612879597779e-01  2.976685252472152e-01 
 	 5.501543879469937e-01  1.212994063603452e-01  8.262061506907925e-01 
 	 3.949704214426016e-01  1.286776735363720e-01  9.096375225982712e-01 
 	 1.654706263114479e-01  1.498069217867049e-01  9.747704129757372e-01 
 	 9.838322253431285e-01  1.264250797189375e-01  1.268497205138741e-01 
 	 9.749138994843071e-01  1.201460755538541e-01  1.873707797958635e-01 
 	 8.471834963061309e-01  1.004222408170876e-01  5.217235830742126e-01 
 	 7.820305054635457e-01  9.821163223955041e-02  6.154532994608725e-01 
 	 6.382329317976694e-01  9.788439391960609e-02  7.635950302326114e-01 
 	 9.601596853124974e-01  9.047538413622748e-02  2.644004227795563e-01 
 	 9.333130786614170e-01  8.612944541536650e-02  3.485805729411625e-01 
 	 2.106064605741660e-01  9.386561925322180e-02  9.730540397565962e-01 
 	 9.784335110485934e-01  7.300557343973260e-02  1.932305635862452e-01 
 	 3.369677946517066e-01  6.668377182216642e-02  9.391517342491226e-01 
 	 9.899613294493388e-01  5.623500873695216e-02  1.296695414785319e-01 
 	 8.901156946186491e-01  4.649299481879405e-02  4.533568700553014e-01 
 	 7.064177659327168e-01  4.413479295588391e-02  7.064177659327169e-01 
 	 5.581950217040609e-01  4.499477457175644e-02  8.284888581061546e-01 
 	 1.163029371127322e-01  5.686314233046597e-02  9.915846962631367e-01 
 	 9.739898698662874e-01  3.613345630822368e-02  2.236919907664869e-01 
 	 9.389563367652876e-01  3.370829461131309e-02  3.423809990678642e-01 
 	 8.128712471914238e-01  3.090814935417800e-02  5.816227486893538e-01 
 	 4.476367251139124e-01  3.216408385052603e-02  8.936368580353812e-01 
 	 2.236919907664869e-01  3.613345630822384e-02  9.739898698662875e-01 
 	 9.945605601664265e-01  2.488224358009057e-02  1.011442836539220e-01 
 	 6.322825288767849e-01  1.929237422852078e-02  7.744976487852008e-01 
 	 1.519238863537345e-01  2.389371572606736e-02  9.881033463681719e-01 
 	 7.411073604730632e-02  2.546915727695418e-02  9.969247317777448e-01 
 	 9.997481305053681e-01  1.453267262483213e-02  1.710195829140502e-02 
 	 9.993524146264611e-01  1.431115011511720e-02  3.301427513431839e-02 
 	 8.984217328128445e-01  1.101572717118031e-02  4.389954940138405e-01 
 	 7.070684401750554e-01  1.041354007185841e-02  7.070684401750554e-01 
 	 2.776673792481171e-01  1.190597843549984e-02  9.606034947776193e-01 
 	 1.504995305870197e-02  1.456201212113241e-02  9.997806993115614e-01 
 	 9.876931143491534e-01  5.269021177365671e-03  1.563155439586945e-01 
 	 9.357389430785676e-01  4.676227772288145e-03  3.526623928065296e-01 
 	 3.340472250714204e-02  5.839272302582114e-03  9.994248483068635e-01 
 	 9.992328957070525e-01  1.104286520875840e-03  3.914588979929461e-02 
 	 9.911829288525401e-01  1.020378573288014e-03  1.324966428965945e-01 
 	 9.627563169054929e-01  9.297434285301357e-04  2.703690252890061e-01 
 	 8.541708488590842e-01  8.342578455009464e-04  5.199917931786989e-01 
 	 5.481337110090452e-01  8.280107504389828e-04  8.363903091581405e-01 
 	 4.347611426879863e-01  8.585493230233113e-04  9.005453968022358e-01 
 	 3.232681488603319e-01  9.030310094850979e-04  9.463069736969132e-01 
 	 2.204543437004987e-01  9.587460384187829e-04  9.753968234260435e-01 
 	 1.134519505214591e-01  1.035772061207505e-03  9.935429442651755e-01 
 	 2.008629208296236e-02  1.124333881690849e-03  9.997976178925815e-01 
 	 1.639532157769680e-03  1.144838589000593e-03  9.999980006374556e-01 
 	 5.936986802706723e-01  6.359837053860418e-01  4.929975694953297e-01 
 	 7.048681593990446e-01  5.337640326692984e-01  4.671796606167817e-01 
 	 5.861859776669816e-01  6.818479028519070e-01  4.375722077132657e-01 
 	 4.834674772866572e-01  7.728021301742082e-01  4.111399591432118e-01 
 	 7.567448938256071e-01  5.135812225886355e-01  4.044397278621786e-01 
 	 6.678645047568640e-01  6.477071603402959e-01  3.666502935083770e-01 
 	 4.174739637904312e-01  8.280322518705591e-01  3.742700621466760e-01 
 	 7.353108514343337e-01  5.828123772602070e-01  3.459012643446414e-01 
 	 5.938986809301960e-01  7.381924438920995e-01  3.199316685950029e-01 
 	 7.831985532091761e-01  5.292896841960852e-01  3.262705264878545e-01 
 	 8.538060268952383e-01  4.122776167846324e-01  3.178717274872858e-01 
 	 3.735534563973492e-01  8.790625904351533e-01  2.961533003547849e-01 
 	 5.290563511829756e-01  8.032638222893893e-01  2.736176329734555e-01 
 	 6.671054865251850e-01  6.958767673340905e-01  2.659432167449516e-01 
 	 7.379994391513612e-01  6.395556736793749e-01  2.152332875667633e-01 
 	 8.483002134745775e-01  4.793687326718617e-01  2.249274682104420e-01 
 	 9.310861036429948e-01  2.581188689505388e-01  2.577854090025287e-01 
 	 5.640190003429825e-01  8.029197790600673e-01  1.928792255434356e-01 
 	 6.400532305720602e-01  7.444577121622689e-01  1.900383562241835e-01 
 	 3.182041463646675e-01  9.292862952027801e-01  1.875449353744982e-01 
 	 4.586896999698998e-01  8.713803652006655e-01  1.740690043755009e-01 
 	 8.115519642868841e-01  5.595722543044602e-01  1.681139538370460e-01 
 	 9.187121996443121e-01  3.494659112814831e-01  1.839605149941478e-01 
 	 2.319010215692780e-01  9.577798909649777e-01  1.699399795758512e-01 
 	 7.190812092354747e-01  6.804142538229105e-01  1.412751135871401e-01 
 	 8.812903442592859e-01  4.482647528393785e-01  1.496196527104652e-01 
 	 1.654706263114480e-01  9.747704129757372e-01  1.498069217867048e-01 
 	 3.949704214426018e-01  9.096375225982712e-01  1.286776735363720e-01 
 	 5.501543879469938e-01  8.262061506907925e-01  1.212994063603452e-01 
 	 9.449524641541809e-01  2.976685252472151e-01  1.358612879597779e-01 
 	 3.193242417805141e-01  9.412586745737503e-01  1.098368615309383e-01 
 	 6.382329317976696e-01  7.635950302326113e-01  9.788439391960614e-02 
 	 7.820305054635458e-01  6.154532994608723e-01  9.821163223955047e-02 
 	 9.333130786614170e-01  3.485805729411623e-01  8.612944541536649e-02 
 	 9.650659605001867e-01  2.454700014840460e-01  9.160878918135909e-02 
 	 2.296067015765500e-01  9.706791155087278e-01  7.115347712045469e-02 
 	 3.369677946517067e-01  9.391517342491225e-01  6.668377182216649e-02 
 	 1.163029371127323e-01  9.915846962631366e-01  5.686314233046592e-02 
 	 5.581950217040610e-01  8.284888581061546e-01  4.499477457175644e-02 
 	 7.289588122839445e-01  6.831317940171702e-01  4.415882693713114e-02 
 	 8.901156946186491e-01  4.533568700553012e-01  4.649299481879398e-02 
 	 9.957640499629711e-01  7.033418641814078e-02  5.922042740676477e-02 
 	 2.236919907664870e-01  9.739898698662874e-01  3.613345630822379e-02 
 	 4.476367251139125e-01  8.936368580353811e-01  3.216408385052597e-02 
 	 8.128712471914239e-01  5.816227486893535e-01  3.090814935417799e-02 
 	 9.291801869524376e-01  3.681256077072234e-01  3.328238460838375e-02 
 	 9.739898698662874e-01  2.236919907664868e-01  3.613345630822379e-02 
 	 9.908398362338428e-01  1.293726531898915e-01  3.871867170629351e-02 
 	 7.411073604730674e-02  9.969247317777448e-01  2.546915727695425e-02 
 	 1.519238863537348e-01  9.881033463681719e-01  2.389371572606737e-02 
 	 3.615367820597924e-01  9.321211834238857e-01  2.100606175143505e-02 
 	 9.989355721217003e-01  3.787315769150004e-02  2.633147691198081e-02 
 	 2.078748917986048e-02  9.996790472532543e-01  1.448042735635998e-02 
 	 2.776673792481174e-01  9.606034947776192e-01  1.190597843549979e-02 
 	 7.070684401750554e-01  7.070684401750553e-01  1.041354007185847e-02 
 	 8.984217328128447e-01  4.389954940138404e-01  1.101572717118054e-02 
 	 9.829265608941853e-01  1.835631880829431e-01  1.264641726163299e-02 
 	 9.957734214641807e-01  9.083321604934477e-02  1.358749305987636e-02 
 	 9.995556130129021e-01  2.609672089838110e-02  1.440616717775577e-02 
 	 9.906692772580236e-01  1.361828353084114e-01  5.349622830376732e-03 
 	 1.298443502673184e-02  9.999150577960040e-01  1.132095336298024e-03 
 	 3.914588979929468e-02  9.992328957070525e-01  1.104286520875951e-03 
 	 1.134519505214591e-01  9.935429442651755e-01  1.035772061207569e-03 
 	 1.742713763279090e-01  9.846971659921063e-01  9.892825129559236e-04 
 	 3.232681488603322e-01  9.463069736969131e-01  9.030310094850424e-04 
 	 4.347611426879866e-01  9.005453968022357e-01  8.585493230234309e-04 
 	 5.759664597712497e-01  8.174729110906096e-01  8.227099232439715e-04 
 	 7.763475557426734e-01  6.303045363185551e-01  8.149776855427799e-04 
 	 8.363903091581404e-01  5.481337110090452e-01  8.280107504389828e-04 
 	 9.365296508179618e-01  3.505872498610301e-01  8.907152553636181e-04 
 	 9.627563169054930e-01  2.703690252890057e-01  9.297434285302381e-04 
 	 9.992328957070525e-01  3.914588979929455e-02  1.104286520875951e-03 
 	 9.995841124349042e-01  2.881594894124251e-02  1.115013157111156e-03 
 	 5.260422764783866e-01  5.719631285413347e-01  6.293947115655211e-01 
 	 5.166530975016825e-01  6.549242889069737e-01  5.514922960854590e-01 
 	 4.758231054989952e-01  5.036036154514955e-01  7.210934549539847e-01 
 	 4.734706977996977e-01  7.174425657506112e-01  5.109810790765614e-01 
 	 4.346396144608595e-01  6.368235256102414e-01  6.368235256102414e-01 
 	 4.153484322390803e-01  5.943580522361293e-01  6.886393726607656e-01 
 	 3.737674370437237e-01  5.527294462248437e-01  7.448409644224355e-01 
 	 3.737674370437236e-01  7.448409644224355e-01  5.527294462248435e-01 
 	 3.370520368639033e-01  4.592153262805795e-01  8.218985390879551e-01 
 	 3.170685379970509e-01  6.706219285903245e-01  6.706219285903245e-01 
 	 3.370520368639033e-01  8.218985390879552e-01  4.592153262805794e-01 
 	 3.236361339244386e-01  3.848816386693347e-01  8.643643774668472e-01 
 	 3.236361339244385e-01  8.643643774668474e-01  3.848816386693348e-01 
 	 2.737603804034552e-01  3.335858059310806e-01  9.020952079479565e-01 
 	 2.429329496462692e-01  5.887760134619233e-01  7.709256695350390e-01 
 	 2.429329496462691e-01  7.709256695350392e-01  5.887760134619232e-01 
 	 2.737603804034551e-01  9.020952079479566e-01  3.335858059310806e-01 
 	 2.545937036286733e-01  2.732661772357016e-01  9.276355116378531e-01 
 	 2.301525929805559e-01  4.293943640959882e-01  8.732984965216237e-01 
 	 2.145455380345709e-01  6.906410833817579e-01  6.906410833817579e-01 
 	 2.301525929805559e-01  8.732984965216238e-01  4.293943640959882e-01 
 	 2.545937036286732e-01  9.276355116378531e-01  2.732661772357015e-01 
 	 1.950866223807339e-01  5.256145997021038e-01  8.280522340698527e-01 
 	 1.950866223807338e-01  8.280522340698528e-01  5.256145997021038e-01 
 	 1.659385590683703e-01  7.666169068282040e-01  6.202926025509815e-01 
 	 1.412137863964502e-01  7.000209520191442e-01  7.000209520191440e-01 
 	 1.403558062284090e-01  2.489630151736960e-01  9.582889254987743e-01 
 	 1.286776735363721e-01  3.949704214426016e-01  9.096375225982712e-01 
 	 1.229747166096775e-01  5.049024410218264e-01  8.543715492249088e-01 
 	 1.229747166096774e-01  8.543715492249089e-01  5.049024410218262e-01 
 	 1.286776735363722e-01  9.096375225982712e-01  3.949704214426016e-01 
 	 1.418064525476695e-01  9.616763688862052e-01  2.346688976871221e-01 
 	 1.016360637002213e-01  1.121600325261105e-01  9.884787492198639e-01 
 	 9.603657141770207e-02  1.801009797809214e-01  9.789487290110165e-01 
 	 8.166101753397891e-02  4.669332494571836e-01  8.805139514889418e-01 
 	 7.880268409301114e-02  5.894862328180629e-01  8.039254432456442e-01 
 	 7.782549495869565e-02  7.049621239238439e-01  7.049621239238438e-01 
 	 7.880268409301107e-02  8.039254432456444e-01  5.894862328180626e-01 
 	 8.243937672555245e-02  8.929429950810606e-01  4.425568400790655e-01 
 	 9.496750771074770e-02  9.762377727012594e-01  1.947844542834290e-01 
 	 1.016360637002211e-01  9.884787492198639e-01  1.121600325261104e-01 
 	 6.840728547717997e-02  2.915690620918675e-01  9.541005844901849e-01 
 	 6.840728547717979e-02  9.541005844901849e-01  2.915690620918673e-01 
 	 5.557243942893354e-02  1.443480326903270e-01  9.879652572000442e-01 
 	 4.158755852614941e-02  4.771030506099797e-02  9.979950910534684e-01 
 	 3.561907614392519e-02  2.457916289261683e-01  9.686680321784517e-01 
 	 3.109455821269074e-02  5.551535252299452e-01  8.311664645991934e-01 
 	 3.109455821269057e-02  8.311664645991935e-01  5.551535252299451e-01 
 	 3.561907614392495e-02  9.686680321784518e-01  2.457916289261682e-01 
 	 3.920221680264818e-02  9.926850996415667e-01  1.141905387822080e-01 
 	 4.158755852614927e-02  9.979950910534685e-01  4.771030506099755e-02 
 	 2.488224358009063e-02  1.011442836539218e-01  9.945605601664264e-01 
 	 2.355066565834601e-02  1.713610856436845e-01  9.849267711226386e-01 
 	 2.028058522577368e-02  4.428102589294399e-01  8.963859506093024e-01 
 	 1.919315515702792e-02  7.069765281800798e-01  7.069765281800797e-01 
 	 2.028058522577356e-02  8.963859506093025e-01  4.428102589294396e-01 
 	 2.355066565834595e-02  9.849267711226387e-01  1.713610856436844e-01 
 	 1.431115011511750e-02  3.301427513431840e-02  9.993524146264611e-01 
 	 1.358749305987631e-02  9.957734214641807e-01  9.083321604934481e-02 
 	 4.676227772288338e-03  9.357389430785676e-01  3.526623928065295e-01 
 	 5.927481160293356e-03  9.998253852382359e-01  1.772185092780637e-02 
 	 1.104286520876017e-03  3.914588979929466e-02  9.992328957070524e-01 
 	 1.079304384668984e-03  6.446925536056813e-02  9.979191100561704e-01 
 	 1.050843292571464e-03  9.572614500433042e-02  9.954071533252030e-01 
 	 9.587460384191629e-04  2.204543437004990e-01  9.753968234260434e-01 
 	 9.160617172941086e-04  2.964946563555406e-01  9.550340724725689e-01 
 	 8.414402425177277e-04  4.916446485391231e-01  8.707955164911910e-01 
 	 8.111027080843128e-04  6.822479280958612e-01  7.311204461108317e-01 
 	 8.183635716575863e-04  7.974464850820646e-01  6.033891229640497e-01 
 	 8.495435737640577e-04  8.862541518313271e-01  4.631985067305931e-01 
 	 9.160617172939334e-04  9.550340724725690e-01  2.964946563555405e-01 
 	 1.004830170274566e-03  9.882575873638942e-01  1.527937542376124e-01 
 	 1.050843292571345e-03  9.954071533252031e-01  9.572614500433030e-02 
 	 1.092323476543444e-03  9.986958513422968e-01  5.104315175523156e-02 
 	 ]; 
 

 	  
 

 	 case  8
 	 pts=[
 	 6.089831374942348e-01  5.259365709049096e-01  5.937425886968720e-01 
 	 6.722368371777616e-01  4.863904718828522e-01  5.581415085825602e-01 
 	 5.272576279437615e-01  4.944930489525798e-01  6.909963952964585e-01 
 	 7.367400143306329e-01  4.657690381077293e-01  4.901768603517503e-01 
 	 6.145018939660353e-01  4.424328221101287e-01  6.531773267894583e-01 
 	 6.763429062188006e-01  4.227914392151711e-01  6.031647139329944e-01 
 	 5.572870520751306e-01  4.282319605146912e-01  7.113708804717512e-01 
 	 4.553703565752197e-01  4.292823483781126e-01  7.799708351749635e-01 
 	 7.944309593320051e-01  4.042497537318666e-01  4.532787083710806e-01 
 	 7.223215845261026e-01  3.812446160918422e-01  5.769783975407435e-01 
 	 5.424648609934921e-01  3.617866000943858e-01  7.581835731400781e-01 
 	 6.444761683787941e-01  3.296217523656109e-01  6.899275097857832e-01 
 	 4.610266712817628e-01  3.500094243453325e-01  8.154433219030655e-01 
 	 8.032110233095883e-01  3.167014688494261e-01  5.045316953993872e-01 
 	 5.956484713404513e-01  3.074426533044413e-01  7.420794522953109e-01 
 	 3.790909771721844e-01  3.404023851026551e-01  8.604744314871082e-01 
 	 8.550372842030484e-01  3.030788478404149e-01  4.207783913349188e-01 
 	 7.740889276891962e-01  2.845958250413199e-01  5.655011480077126e-01 
 	 5.304480275235047e-01  2.620439798588955e-01  8.061996295683432e-01 
 	 4.428188071397453e-01  2.720925642730390e-01  8.543284734284907e-01 
 	 3.358343512654272e-01  2.908220580306985e-01  8.959005631614029e-01 
 	 6.404540683061379e-01  2.304106952273129e-01  7.326182484179486e-01 
 	 8.951033755298294e-01  2.250639848731512e-01  3.848845928692433e-01 
 	 8.497551469662122e-01  2.146851073901761e-01  4.814836392540245e-01 
 	 7.945746250502658e-01  2.084292777534967e-01  5.702704633780231e-01 
 	 6.920881411184979e-01  2.050073409570601e-01  6.920881411184979e-01 
 	 5.882111482480934e-01  2.075339520022295e-01  7.816247845628975e-01 
 	 3.317740021964245e-01  2.325814339709050e-01  9.142384196907306e-01 
 	 9.232142816683085e-01  2.051949171655086e-01  3.249160446840217e-01 
 	 5.092106880520655e-01  1.872003969934085e-01  8.400360031207307e-01 
 	 4.356175236243241e-01  1.929284008720017e-01  8.792132876887062e-01 
 	 2.285401613515397e-01  2.203771176915254e-01  9.482633182019580e-01 
 	 8.712396166436280e-01  1.656371193057857e-01  4.620669595402218e-01 
 	 6.417387003150685e-01  1.577003179784742e-01  7.505345096845413e-01 
 	 9.405877075143281e-01  1.537791267921331e-01  3.027321334711432e-01 
 	 9.082461354609981e-01  1.461585725913975e-01  3.920798758903696e-01 
 	 7.883578549860237e-01  1.358399123073095e-01  6.000328413563529e-01 
 	 3.027321334711430e-01  1.537791267921330e-01  9.405877075143280e-01 
 	 9.649598252359355e-01  1.357078308474512e-01  2.245794298846456e-01 
 	 8.249307152778325e-01  1.152619582470511e-01  5.533570239657745e-01 
 	 5.755319355531472e-01  1.146313859954553e-01  8.097052775567225e-01 
 	 4.645663804344927e-01  1.186647954824445e-01  8.775515622931247e-01 
 	 9.853077089116465e-01  1.205632177993537e-01  1.209678852966674e-01 
 	 3.888367198590844e-01  1.005349101545880e-01  9.158049667529855e-01 
 	 2.510794220884804e-01  1.088570705796519e-01  9.618260040093173e-01 
 	 9.783898625905482e-01  9.068509505641063e-02  1.858211245113377e-01 
 	 9.528272087721693e-01  8.440139038000592e-02  2.915419618603106e-01 
 	 9.222278136285795e-01  8.051867886751835e-02  3.781700703695090e-01 
 	 8.504649172774741e-01  7.612338079968528e-02  5.204946256935273e-01 
 	 7.051744645257568e-01  7.387793419975960e-02  7.051744645257568e-01 
 	 8.055690028071427e-01  5.759984247038543e-02  5.896955484516503e-01 
 	 4.657370114881607e-01  5.968142996023100e-02  8.829083548409647e-01 
 	 3.682619571621378e-01  6.223051777641159e-02  9.276370484000688e-01 
 	 2.009964122683051e-01  6.881522324465014e-02  9.771718924043296e-01 
 	 9.811598924124739e-01  5.099162846688416e-02  1.863467717655388e-01 
 	 9.682809912920071e-01  4.898452343824941e-02  2.450151798687091e-01 
 	 6.365062962611919e-01  4.202671218612176e-02  7.701256327916145e-01 
 	 2.886231885448430e-01  4.769163438139803e-02  9.562542355693067e-01 
 	 1.232829594578259e-01  5.355087108925164e-02  9.909256360155904e-01 
 	 9.947365457018468e-01  3.771675259602990e-02  9.527146067300345e-02 
 	 9.149489874293285e-01  3.103401787101762e-02  4.023745023443058e-01 
 	 8.763293278794763e-01  3.010344588740534e-02  4.807709346913657e-01 
 	 7.068119570797423e-01  2.887411744467440e-02  7.068119570797423e-01 
 	 5.592656070264593e-01  2.942440627348496e-02  8.284661641327176e-01 
 	 7.298759118707249e-02  3.846376679529650e-02  9.965908639841254e-01 
 	 9.987968523083333e-01  2.481718366631939e-02  4.229604253163025e-02 
 	 3.448228422594691e-01  2.005028142104865e-02  9.384536182843765e-01 
 	 1.627108512044063e-01  2.243499150826666e-02  9.864186991619539e-01 
 	 3.589244372887043e-02  2.496845766953522e-02  9.990436970447162e-01 
 	 9.947840826163475e-01  1.274611046629055e-02  1.012035851199598e-01 
 	 9.879622735825451e-01  1.222500245277509e-02  1.542112035250296e-01 
 	 9.706316475280499e-01  1.152403140289468e-02  2.402944059215872e-01 
 	 9.573724783904691e-01  1.119654819738537e-02  2.886391777443846e-01 
 	 9.305973801310786e-01  1.075694517065776e-02  3.658863269155711e-01 
 	 7.940515677155665e-01  9.942624365004203e-03  6.077690778817129e-01 
 	 6.335076630842784e-01  9.904483324858137e-03  7.736730200954173e-01 
 	 5.009753381694216e-01  1.020245194434022e-02  8.654014216075433e-01 
 	 2.173295633793345e-01  1.169535161652309e-02  9.760282166166682e-01 
 	 1.176464365275114e-01  1.257621810970400e-02  9.929759084239835e-01 
 	 7.225639015823762e-02  1.306493784651720e-02  9.973005171363180e-01 
 	 9.999982113640237e-01  1.083089497369081e-03  1.550543741425168e-03 
 	 9.998191412512651e-01  1.064722628088497e-03  1.898818457114932e-02 
 	 9.993140920983978e-01  1.046700534517126e-03  3.701688468180416e-02 
 	 9.958856607626740e-01  9.983247571888980e-04  9.061321115031333e-02 
 	 9.894604448959504e-01  9.562507147232054e-04  1.448002540428650e-01 
 	 9.426140357211567e-01  8.496228670142891e-04  3.338832996758865e-01 
 	 8.332996347028756e-01  7.823896431101258e-04  5.528210439830420e-01 
 	 7.951422910027858e-01  7.737636023845132e-04  6.064224091742725e-01 
 	 6.064224091742725e-01  7.737636023845687e-04  7.951422910027857e-01 
 	 4.151184597345997e-01  8.185729711179694e-04  9.097670000202605e-01 
 	 3.338832996758864e-01  8.496228670142249e-04  9.426140357211567e-01 
 	 2.092384603456842e-01  9.136511894953893e-04  9.778642195896481e-01 
 	 1.255117109433234e-01  9.705154542183498e-04  9.920916633637402e-01 
 	 9.061321115031340e-02  9.983247571888980e-04  9.958856607626740e-01 
 	 2.724415237023223e-02  1.056351628599816e-03  9.996282510427885e-01 
 	 7.119969906209033e-03  1.077119358884461e-03  9.999740725850953e-01 
 	 5.976565766026027e-01  6.168836123136405e-01  5.121144650393417e-01 
 	 5.495089702339447e-01  6.779189880981138e-01  4.883295375138178e-01 
 	 6.751622763473764e-01  5.537615782993769e-01  4.873438365228517e-01 
 	 4.883760692607355e-01  7.514890986162908e-01  4.435684272288868e-01 
 	 6.412990671065374e-01  6.412990671065373e-01  4.212730860814276e-01 
 	 7.370853316162803e-01  5.160743509074464e-01  4.363169470139522e-01 
 	 6.164387093223243e-01  6.907333111153302e-01  3.780090085760913e-01 
 	 4.744758042508254e-01  7.971469683238035e-01  3.734024933937928e-01 
 	 5.531216706009930e-01  7.511045618370186e-01  3.604141433118110e-01 
 	 6.717289735355246e-01  6.510100473099411e-01  3.535054517463893e-01 
 	 7.436486573649111e-01  5.639166381676401e-01  3.591443993675412e-01 
 	 8.144569609409311e-01  4.365370924213045e-01  3.822240517225676e-01 
 	 3.996016113768112e-01  8.412767480229119e-01  3.641043606180104e-01 
 	 6.609457378192128e-01  6.857490347314377e-01  3.047933611867521e-01 
 	 8.224982259662567e-01  4.688008587005968e-01  3.220596577715745e-01 
 	 4.687155463028589e-01  8.324938043027141e-01  2.953977021772628e-01 
 	 8.763851394452438e-01  3.649234729778502e-01  3.142927715193666e-01 
 	 5.771234321068575e-01  7.746981757632723e-01  2.584013943117558e-01 
 	 7.119317311064859e-01  6.542971519886670e-01  2.550459706469430e-01 
 	 7.746981757632724e-01  5.771234321068575e-01  2.584013943117558e-01 
 	 8.619090523442039e-01  4.440028586919980e-01  2.448964004644617e-01 
 	 9.219907859237477e-01  2.739517588119673e-01  2.736483592414535e-01 
 	 2.684091795117528e-01  9.319942382656273e-01  2.436047047852334e-01 
 	 4.814836392540245e-01  8.497551469662121e-01  2.146851073901760e-01 
 	 7.816247845628975e-01  5.882111482480933e-01  2.075339520022294e-01 
 	 9.056528390929492e-01  3.569678622688507e-01  2.288381094793595e-01 
 	 4.010773410480174e-01  8.947746178516488e-01  1.962532795809745e-01 
 	 6.954618660790995e-01  6.954618660790995e-01  1.807362322821665e-01 
 	 9.395453827003304e-01  2.676215221104945e-01  2.136192752299094e-01 
 	 8.248302135557951e-01  5.419640935069828e-01  1.610280725670394e-01 
 	 9.129885043461623e-01  3.693885882915177e-01  1.732168056851215e-01 
 	 9.578728417325856e-01  2.128600900821942e-01  1.927957497491612e-01 
 	 2.582884233163976e-01  9.529852211917637e-01  1.584495458207901e-01 
 	 4.117393093062000e-01  8.997303964734280e-01  1.447617174318597e-01 
 	 6.000328413563529e-01  7.883578549860236e-01  1.358399123073093e-01 
 	 7.552398128123438e-01  6.414055580506208e-01  1.349508623349532e-01 
 	 5.533570239657745e-01  8.249307152778325e-01  1.152619582470511e-01 
 	 9.443732442886095e-01  3.026427566593922e-01  1.287110613483176e-01 
 	 9.776988975929798e-01  1.531032200807298e-01  1.437507205073550e-01 
 	 1.789329901755023e-01  9.771429090822513e-01  1.147811842469333e-01 
 	 3.671858053606753e-01  9.245796514054586e-01  1.016221065939539e-01 
 	 4.562648421547877e-01  8.844739971523048e-01  9.761220300193656e-02 
 	 6.398919580564904e-01  7.628184607032529e-01  9.298536457395114e-02 
 	 8.844739971523049e-01  4.562648421547875e-01  9.761220300193656e-02 
 	 9.693221032010023e-01  2.191380049128777e-01  1.113247279304525e-01 
 	 2.915419618603106e-01  9.528272087721692e-01  8.440139038000598e-02 
 	 7.051744645257569e-01  7.051744645257569e-01  7.387793419975966e-02 
 	 7.844181802326365e-01  6.157483448916727e-01  7.444524352626215e-02 
 	 9.125203036664673e-01  4.012016045979954e-01  7.964902927501387e-02 
 	 9.463433692517962e-01  3.122206868513475e-01  8.338147381302027e-02 
 	 1.536713219807400e-01  9.855446431587274e-01  7.132237476296258e-02 
 	 5.404526626654010e-01  8.393539949243165e-01  5.827341265507641e-02 
 	 9.934366431054620e-01  8.586439119634984e-02  7.557077781676627e-02 
 	 9.911369337088102e-02  9.935737020717688e-01  5.466053729870291e-02 
 	 2.049142525072019e-01  9.774855424464343e-01  5.032060639156722e-02 
 	 4.089301334279317e-01  9.114621637093131e-01  4.486502090661793e-02 
 	 8.732071246663977e-01  4.853985852095621e-01  4.356065780492434e-02 
 	 9.774855424464342e-01  2.049142525072015e-01  5.032060639156715e-02 
 	 9.891178487286931e-01  1.372694622368470e-01  5.294313990999230e-02 
 	 3.023857853541610e-01  9.526274739233620e-01  3.261491594564610e-02 
 	 7.068119570797423e-01  7.068119570797423e-01  2.887411744467445e-02 
 	 7.915463864232035e-01  6.104149239651298e-01  2.911938771700894e-02 
 	 9.149489874293285e-01  4.023745023443058e-01  3.103401787101773e-02 
 	 1.268662986946479e-01  9.916517022083385e-01  2.306173807034657e-02 
 	 4.233712069222086e-01  9.057496699139754e-01  1.934829708158131e-02 
 	 5.036607072191001e-01  8.636969766870423e-01  1.879958683638298e-02 
 	 8.475667247400269e-01  5.303609131064418e-01  1.865339010380306e-02 
 	 9.829884227557806e-01  1.823309875694332e-01  2.211722631927663e-02 
 	 9.951076682404602e-01  9.592261034684037e-02  2.365547364316879e-02 
 	 1.968121469559226e-02  9.997122135324917e-01  1.371640995566348e-02 
 	 4.884832566306817e-02  9.987170836385383e-01  1.334271068590556e-02 
 	 2.173295633793346e-01  9.760282166166682e-01  1.169535161652309e-02 
 	 6.077690778817129e-01  7.940515677155665e-01  9.942624365004258e-03 
 	 9.494090532158934e-01  3.138479191683165e-01  1.104234148261361e-02 
 	 9.879622735825451e-01  1.542112035250294e-01  1.222500245277519e-02 
 	 9.973005171363180e-01  7.225639015823743e-02  1.306493784651702e-02 
 	 9.994193611825789e-01  3.125622465348863e-02  1.356425131795212e-02 
 	 1.676304009713709e-02  9.998437350603957e-01  5.613015871961000e-03 
 	 2.843585064957523e-01  9.587070492125077e-01  4.586237428596695e-03 
 	 7.527457828053247e-01  6.582989262133252e-01  4.038590742080065e-03 
 	 9.999161542832999e-01  1.165599848664709e-02  5.641108275445262e-03 
 	 1.550543741425048e-03  9.999982113640236e-01  1.083089497369008e-03 
 	 4.827697077247860e-02  9.988334500676318e-01  1.035914583841365e-03 
 	 9.061321115031340e-02  9.958856607626740e-01  9.983247571889536e-04 
 	 1.448002540428650e-01  9.894604448959504e-01  9.562507147232609e-04 
 	 2.569282414729325e-01  9.664300764956445e-01  8.865541432321113e-04 
 	 3.877258198011438e-01  9.217743773561140e-01  8.281964014378483e-04 
 	 4.703496505583366e-01  8.824797808277584e-01  8.016544407509939e-04 
 	 6.064224091742725e-01  7.951422910027857e-01  7.737636023846242e-04 
 	 6.829529415773390e-01  7.304619708673294e-01  7.672727523374592e-04 
 	 9.097670000202606e-01  4.151184597345995e-01  8.185729711179694e-04 
 	 9.664300764956446e-01  2.569282414729324e-01  8.865541432321113e-04 
 	 9.778642195896481e-01  2.092384603456841e-01  9.136511894953338e-04 
 	 9.996282510427885e-01  2.724415237023229e-02  1.056351628599889e-03 
 	 9.999241030006841e-01  1.227353798132694e-02  1.071682647990209e-03 
 	 5.447772374856452e-01  5.582761377971487e-01  6.257359790549109e-01 
 	 5.411123477104253e-01  6.176804476407327e-01  5.706735421917298e-01 
 	 4.796516860483488e-01  6.157016856454407e-01  6.251765305610402e-01 
 	 4.883295375138179e-01  6.779189880981139e-01  5.495089702339446e-01 
 	 4.334464113747158e-01  5.290050207869329e-01  7.295737772484681e-01 
 	 4.234460979797096e-01  6.827765798829527e-01  5.954070406613413e-01 
 	 4.018939216880311e-01  5.962332693144605e-01  6.949727795193168e-01 
 	 3.925287983748554e-01  7.698898913177261e-01  5.031805815938963e-01 
 	 4.111261816402114e-01  8.039357248136892e-01  4.297238801116690e-01 
 	 3.604141433118112e-01  5.531216706009930e-01  7.511045618370187e-01 
 	 3.556169988477903e-01  4.343131852129338e-01  8.275920536597040e-01 
 	 3.311906674938850e-01  7.210885235979989e-01  6.085590217063692e-01 
 	 3.167014688494263e-01  5.045316953993872e-01  8.032110233095883e-01 
 	 3.335158124964263e-01  8.495895650793341e-01  4.086132324376638e-01 
 	 2.797960742709016e-01  6.788645508577510e-01  6.788645508577510e-01 
 	 2.684256231164858e-01  4.707133905562877e-01  8.404621281209106e-01 
 	 2.559535124214170e-01  6.238301594308682e-01  7.384603792104198e-01 
 	 2.620439798588955e-01  8.061996295683432e-01  5.304480275235047e-01 
 	 2.992141698583052e-01  9.059645495811049e-01  2.994981059344294e-01 
 	 2.582410062753587e-01  3.516024622589158e-01  8.998262561246797e-01 
 	 2.315825556765386e-01  7.598838242280072e-01  6.074093295158891e-01 
 	 2.146851073901762e-01  4.814836392540244e-01  8.497551469662122e-01 
 	 2.084292777534968e-01  5.702704633780231e-01  7.945746250502657e-01 
 	 2.052914519586859e-01  6.585563777795842e-01  7.239882022785510e-01 
 	 2.146851073901761e-01  8.497551469662122e-01  4.814836392540244e-01 
 	 2.307214011887647e-01  9.101774523933293e-01  3.440125581839736e-01 
 	 2.104348661808457e-01  2.880037275728505e-01  9.342221470290633e-01 
 	 1.810039030321972e-01  7.291398867710598e-01  6.599944034661180e-01 
 	 1.684747708500061e-01  8.900275991867720e-01  4.236356031695974e-01 
 	 1.782856080166607e-01  9.302690644700612e-01  3.206457697586648e-01 
 	 1.893440271370697e-01  9.533038867089040e-01  2.352882040672966e-01 
 	 1.672632652132887e-01  1.882568057028847e-01  9.677718611412173e-01 
 	 1.584495458207902e-01  2.582884233163975e-01  9.529852211917637e-01 
 	 1.358399123073095e-01  6.000328413563528e-01  7.883578549860236e-01 
 	 1.358399123073095e-01  7.883578549860237e-01  6.000328413563528e-01 
 	 1.208421893154419e-01  4.212214642043554e-01  8.988713163601283e-01 
 	 1.220324219572169e-01  9.083174620099884e-01  4.000843363579597e-01 
 	 1.382617342484754e-01  9.699642086178109e-01  2.001327730358721e-01 
 	 1.191070504348459e-01  1.346230984329574e-01  9.837124233763754e-01 
 	 1.027560197125665e-01  3.460761443324011e-01  9.325623318239107e-01 
 	 9.599307251259261e-02  5.024730967580364e-01  8.592474131843406e-01 
 	 9.298536457395118e-02  7.628184607032530e-01  6.398919580564902e-01 
 	 9.467031912847924e-02  8.304997680415205e-01  5.489149897380218e-01 
 	 1.027560197125663e-01  9.325623318239108e-01  3.460761443324010e-01 
 	 1.088570705796518e-01  9.618260040093174e-01  2.510794220884804e-01 
 	 1.184368831367197e-01  9.828842521827840e-01  1.411072341304610e-01 
 	 9.068509505641087e-02  1.858211245113376e-01  9.783898625905481e-01 
 	 8.440139038000617e-02  2.915419618603105e-01  9.528272087721692e-01 
 	 7.387793419975976e-02  7.051744645257569e-01  7.051744645257569e-01 
 	 7.557077781676651e-02  8.586439119634989e-02  9.934366431054620e-01 
 	 7.210068574570133e-02  1.401976204393705e-01  9.874948700313019e-01 
 	 5.099162846688435e-02  1.863467717655389e-01  9.811598924124739e-01 
 	 4.707285463750590e-02  3.115583229146618e-01  9.490603551823665e-01 
 	 4.486502090661808e-02  4.089301334279318e-01  9.114621637093131e-01 
 	 4.288398368821712e-02  5.366413932172346e-01  8.427199885067959e-01 
 	 4.202671218612204e-02  6.365062962611919e-01  7.701256327916145e-01 
 	 4.395813968273560e-02  8.869525113296837e-01  4.597639879346798e-01 
 	 4.537107981815368e-02  9.222530088064931e-01  3.839151636279887e-01 
 	 4.898452343824936e-02  9.682809912920071e-01  2.450151798687088e-01 
 	 5.165671456846767e-02  9.842874944250697e-01  1.688481926418229e-01 
 	 5.466053729870299e-02  9.935737020717689e-01  9.911369337088090e-02 
 	 5.668514811786077e-02  9.966471947592552e-01  5.900138270721734e-02 
 	 3.905736279866411e-02  5.626012300920849e-02  9.976519037070004e-01 
 	 3.729787131511075e-02  1.084234655770562e-01  9.934048625347183e-01 
 	 2.911938771700897e-02  7.915463864232035e-01  6.104149239651298e-01 
 	 2.211722631927677e-02  1.823309875694335e-01  9.829884227557805e-01 
 	 2.088087460719804e-02  2.705712821126818e-01  9.624734647622956e-01 
 	 1.956621837086721e-02  3.968665957316044e-01  9.176677330554185e-01 
 	 1.896442284203719e-02  4.768649769147547e-01  8.787719524759304e-01 
 	 1.817150747976177e-02  7.069900269154837e-01  7.069900269154837e-01 
 	 2.005028142104861e-02  9.384536182843763e-01  3.448228422594690e-01 
 	 2.180041927326287e-02  9.789363191695505e-01  2.029985830745669e-01 
 	 2.275085211933449e-02  9.892865982697819e-01  1.442027226221719e-01 
 	 2.481718366631951e-02  9.987968523083334e-01  4.229604253163014e-02 
 	 1.371640995566360e-02  1.968121469559225e-02  9.997122135324916e-01 
 	 1.320993352351653e-02  5.984085276708040e-02  9.981205187733658e-01 
 	 1.257621810970424e-02  1.176464365275112e-01  9.929759084239835e-01 
 	 9.942624365004404e-03  6.077690778817129e-01  7.940515677155664e-01 
 	 9.991577041109714e-03  8.134440227322615e-01  5.815573834707868e-01 
 	 1.290967127627585e-02  9.962064903651678e-01  8.605793944693950e-02 
 	 4.173330494014747e-03  8.665532633732077e-01  4.990671548497575e-01 
 	 1.077119358884718e-03  7.119969906209383e-03  9.999740725850952e-01 
 	 1.064722628088545e-03  1.898818457114908e-02  9.998191412512650e-01 
 	 9.983247571891984e-04  9.061321115031339e-02  9.958856607626740e-01 
 	 9.562507147233893e-04  1.448002540428650e-01  9.894604448959504e-01 
 	 8.999061586764283e-04  2.326636005538878e-01  9.725568565108192e-01 
 	 8.281964014380519e-04  3.877258198011438e-01  9.217743773561140e-01 
 	 7.944024873033835e-04  4.979887505746773e-01  8.671831255425582e-01 
 	 7.672727523376053e-04  6.829529415773390e-01  7.304619708673294e-01 
 	 7.685722622361006e-04  7.529561445173866e-01  6.580702498443386e-01 
 	 7.776495933224937e-04  8.147427771847642e-01  5.798220436361210e-01 
 	 8.385583844927111e-04  9.327145406179632e-01  3.606145900260522e-01 
 	 8.999061586764924e-04  9.725568565108194e-01  2.326636005538878e-01 
 	 9.276957674535499e-04  9.824098971127103e-01  1.867349282688077e-01 
 	 9.705154542184215e-04  9.920916633637402e-01  1.255117109433234e-01 
 	 1.011564840209529e-03  9.971742190237426e-01  7.511693318395667e-02 
 	 1.046700534517129e-03  9.993140920983978e-01  3.701688468180415e-02 
 	 1.071682647990275e-03  9.999241030006842e-01  1.227353798132699e-02 
 	 ]; 
 

 	  
 

 	 case  9
 	 pts=[
 	 5.808904357982326e-01  5.591035291498204e-01  5.915822388225961e-01 
 	 6.514498755689332e-01  5.250095636601738e-01  5.477024901226719e-01 
 	 6.141266951885018e-01  4.846171403720230e-01  6.228921491835421e-01 
 	 5.520487356702507e-01  4.753248777286161e-01  6.850609126618987e-01 
 	 6.934607546977788e-01  4.555293670809581e-01  5.582160669676293e-01 
 	 7.403736622874276e-01  4.483892617035031e-01  5.007932808855261e-01 
 	 6.455470701331391e-01  4.290337633924359e-01  6.318219765977150e-01 
 	 4.799269620758674e-01  4.547020543675584e-01  7.502773839231400e-01 
 	 6.136136574665819e-01  4.091847678283648e-01  6.753118576981536e-01 
 	 7.817259484515527e-01  4.106663588092808e-01  4.693161868717585e-01 
 	 5.617091663524090e-01  3.926975874393659e-01  7.281973752046784e-01 
 	 7.492997685286603e-01  3.717860205835131e-01  5.480191709982160e-01 
 	 6.774918534863926e-01  3.642739934717162e-01  6.389908028600570e-01 
 	 6.098121113391949e-01  3.425535607099836e-01  7.146931137970653e-01 
 	 4.812188060938881e-01  3.585101164040509e-01  7.999368456931628e-01 
 	 4.187114191651016e-01  3.724208594153568e-01  8.282411792063189e-01 
 	 8.444847305228785e-01  3.479929996481415e-01  4.071196533079554e-01 
 	 7.705237724245546e-01  3.239839002530038e-01  5.489331002093834e-01 
 	 6.706219285903245e-01  3.170685379970508e-01  6.706219285903247e-01 
 	 8.215293405065199e-01  3.077792074816637e-01  4.799598963756050e-01 
 	 7.238039052928317e-01  2.941106161346378e-01  6.241849502829665e-01 
 	 4.053999547593465e-01  3.208074368933537e-01  8.559985193416146e-01 
 	 8.907861701994757e-01  3.079946898779155e-01  3.341246324178412e-01 
 	 6.251477136270828e-01  2.697670338036677e-01  7.324043170405277e-01 
 	 5.670216193240195e-01  2.731457479985223e-01  7.770958007668647e-01 
 	 8.845516931588400e-01  2.700365574931414e-01  3.803269116787331e-01 
 	 8.181880230996366e-01  2.524616722621781e-01  5.165573181118366e-01 
 	 7.652463593312234e-01  2.467617774337965e-01  5.945642393619226e-01 
 	 9.032980232711031e-01  2.470265807545719e-01  3.507571090587080e-01 
 	 4.765829381357740e-01  2.309231307977714e-01  8.482589290661362e-01 
 	 3.292024067612547e-01  2.506326962743237e-01  9.103894918884224e-01 
 	 8.508357714622354e-01  2.050606822132805e-01  4.837650324387726e-01 
 	 6.769145129892893e-01  1.961079603460940e-01  7.094564186709204e-01 
 	 4.331869944594448e-01  2.096811565585076e-01  8.765744922226972e-01 
 	 9.462735344079207e-01  2.066170430651061e-01  2.487484584759753e-01 
 	 9.147135988798342e-01  1.921054998566469e-01  3.555200542151312e-01 
 	 7.611352599684805e-01  1.736123236553718e-01  6.249254972456284e-01 
 	 6.063208190576896e-01  1.741620134018386e-01  7.759140786614392e-01 
 	 9.613187885488930e-01  1.848868663678255e-01  2.041642315087895e-01 
 	 4.086306080868238e-01  1.618253424739539e-01  8.982391578348052e-01 
 	 2.678636219636769e-01  1.760196843449704e-01  9.472413371214314e-01 
 	 9.351631073878891e-01  1.445806356983645e-01  3.233672870926871e-01 
 	 8.988457114477902e-01  1.376328052926700e-01  4.160932562769865e-01 
 	 8.446663414373421e-01  1.322059909548735e-01  5.187102732725614e-01 
 	 8.030942917037016e-01  1.299676777714500e-01  5.815049108714615e-01 
 	 6.628061219036029e-01  1.283404877202754e-01  7.377104879143499e-01 
 	 5.606345247697817e-01  1.306204529963354e-01  8.176962925776252e-01 
 	 3.407452784063264e-01  1.431152017192721e-01  9.291989530131032e-01 
 	 9.617519999422854e-01  1.274078612396161e-01  2.424877883551275e-01 
 	 7.408373885179355e-01  1.076376458274073e-01  6.630038468777228e-01 
 	 4.052173963803277e-01  1.158675992839787e-01  9.068481466634398e-01 
 	 1.915618654270992e-01  1.323557010630754e-01  9.725153058488034e-01 
 	 9.791359375940917e-01  1.097525437782136e-01  1.710181126253892e-01 
 	 9.448203023556618e-01  9.958423039413782e-02  3.120858492680549e-01 
 	 9.138291429168605e-01  9.533543195288578e-02  3.947498612668443e-01 
 	 3.318875738576888e-01  9.846619160151063e-02  9.381657888829414e-01 
 	 8.481912991145052e-01  7.225587226144968e-02  5.247386101957671e-01 
 	 5.717542303315776e-01  7.137059242735688e-02  8.173147121118727e-01 
 	 5.011034814943756e-01  7.278793036274131e-02  8.623208324212773e-01 
 	 4.075770605740660e-01  7.546884992073814e-02  9.100469176836133e-01 
 	 1.516080532908048e-01  8.846627640481466e-02  9.844738270347462e-01 
 	 1.018602162457950e-01  9.232611609019779e-02  9.905051159050412e-01 
 	 9.922595588430134e-01  7.066928211146367e-02  1.021118036787064e-01 
 	 9.847373657543431e-01  6.732948688610012e-02  1.604962949193894e-01 
 	 9.717701626707239e-01  6.414574786625472e-02  2.270420092705170e-01 
 	 8.800918910515295e-01  5.655939783247736e-02  4.714226318518981e-01 
 	 6.621752747200055e-01  5.413484731906602e-02  7.473910113556534e-01 
 	 2.460692935946816e-01  6.334009282522074e-02  9.671804047801562e-01 
 	 9.083107694579723e-01  4.244592637145183e-02  4.161368638094151e-01 
 	 8.235785147804089e-01  4.040246262697215e-02  5.657614965741060e-01 
 	 7.487772794769749e-01  3.978140682118469e-02  6.616268022158621e-01 
 	 3.435914854612854e-01  4.391153421372435e-02  9.380920361465095e-01 
 	 2.140364506283941e-01  4.744178764810907e-02  9.756729342290635e-01 
 	 9.969209440126173e-01  3.658898365805823e-02  6.935328156520321e-02 
 	 9.884101714562841e-01  3.426157923242982e-02  1.478900846921759e-01 
 	 9.786956303678549e-01  3.291662689782372e-02  2.026606986382330e-01 
 	 9.569634774535214e-01  3.117683625398118e-02  2.885288680552713e-01 
 	 7.068415075790760e-01  2.738916440268450e-02  7.068415075790764e-01 
 	 6.129639962244067e-01  2.761007026054642e-02  7.896282817584570e-01 
 	 4.354939447332526e-01  2.903346515225104e-02  8.997233363661986e-01 
 	 2.885288680552711e-01  3.117683625398117e-02  9.569634774535215e-01 
 	 1.478900846921758e-01  3.426157923242992e-02  9.884101714562841e-01 
 	 7.930342111691439e-02  3.626432158411033e-02  9.961906777214881e-01 
 	 9.991385204248915e-01  2.370730136898724e-02  3.406142781738158e-02 
 	 9.942024259880659e-01  2.224930219393633e-02  1.051974558215523e-01 
 	 7.712368624699903e-01  1.730891830648462e-02  6.363128973347190e-01 
 	 5.091946334627683e-01  1.779393409659458e-02  8.604674317846569e-01 
 	 3.047469859752135e-01  1.941299688379812e-02  9.522354803781534e-01 
 	 1.051974558215520e-01  2.224930219393637e-02  9.942024259880657e-01 
 	 3.406142781738171e-02  2.370730136898724e-02  9.991385204248915e-01 
 	 9.997412194853548e-01  1.301087758050726e-02  1.866041603289584e-02 
 	 9.975712736595294e-01  1.242163875555172e-02  6.853653667884821e-02 
 	 9.891453948140364e-01  1.165312700944963e-02  1.464772765622221e-01 
 	 9.734454207614999e-01  1.100256618860509e-02  2.286546661140591e-01 
 	 9.369656585701767e-01  1.027685813168527e-02  3.492702976880462e-01 
 	 8.770727631928972e-01  9.734568832272176e-03  4.802588950085422e-01 
 	 5.850560908704983e-01  9.463103320985948e-03  8.109376179527422e-01 
 	 2.066968213074917e-01  1.116247402342633e-02  9.783413633466874e-01 
 	 1.464772765622219e-01  1.165312700944961e-02  9.891453948140364e-01 
 	 8.164450893694671e-02  1.228036387063275e-02  9.965858552195338e-01 
 	 2.342444132608017e-02  1.295079394260993e-02  9.996417220608677e-01 
 	 9.998597413545919e-01  5.322788676542616e-03  1.587972099986517e-02 
 	 9.995379719380334e-01  5.251400551060814e-03  2.993769273433593e-02 
 	 9.944175110881865e-01  4.913962652317461e-03  1.054024032564157e-01 
 	 6.837187698827738e-01  3.820213506491932e-03  7.297356025840809e-01 
 	 9.876204978977475e-01  8.978607083224584e-04  1.568596378242469e-01 
 	 9.752263521769856e-01  8.588434235062406e-04  2.212076499751847e-01 
 	 9.633112236497756e-01  8.342383347911160e-04  2.683855257586983e-01 
 	 9.289727120072637e-01  7.909149097069689e-04  3.701473690295191e-01 
 	 8.303473942153290e-01  7.404583428550443e-04  5.572455981353783e-01 
 	 5.834607839321685e-01  7.362069145798093e-04  8.121409801337686e-01 
 	 4.502010207982651e-01  7.649854126758911e-04  8.929269038782057e-01 
 	 3.701473690295190e-01  7.909149097070244e-04  9.289727120072638e-01 
 	 2.444190690836522e-01  8.463459687542121e-04  9.696693262998382e-01 
 	 1.773559817230700e-01  8.846921480606176e-04  9.841463677049512e-01 
 	 1.190559323318592e-01  9.241549721863162e-04  9.928871189184494e-01 
 	 8.589481771195789e-02  9.495775914645585e-04  9.963037581945716e-01 
 	 3.505625561873131e-02  9.934583474603723e-04  9.993848467845137e-01 
 	 1.161937676726939e-02  1.015961031876794e-03  9.999319766397722e-01 
 	 5.840868854294405e-01  6.053761590481450e-01  5.407052952630025e-01 
 	 6.548012769198012e-01  5.608430365842745e-01  5.066462040311049e-01 
 	 4.971213339632388e-01  7.287572234068107e-01  4.709387313133268e-01 
 	 6.258909657836139e-01  6.378808069890575e-01  4.487411002186493e-01 
 	 7.213591933463008e-01  5.120687632640214e-01  4.662901412897660e-01 
 	 6.831350136908184e-01  5.890536421991459e-01  4.316739043323861e-01 
 	 7.622326628805957e-01  4.831580584651768e-01  4.307663614746596e-01 
 	 4.819240398478200e-01  7.756982706766008e-01  4.074817943001720e-01 
 	 5.528222300773097e-01  7.343155501170345e-01  3.939140195381056e-01 
 	 7.281973752046785e-01  5.617091663524089e-01  3.926975874393659e-01 
 	 4.363766907245215e-01  8.087744243990603e-01  3.942832918477320e-01 
 	 6.087150148749038e-01  7.040864663095777e-01  3.656887729005879e-01 
 	 6.585981788169193e-01  6.585981788169191e-01  3.640012056546993e-01 
 	 8.038748786500705e-01  4.480844669527931e-01  3.911591619161767e-01 
 	 7.041546784849319e-01  6.349973859168198e-01  3.177176555474810e-01 
 	 3.674027928967394e-01  8.698088555456153e-01  3.293140485708173e-01 
 	 4.799598963756050e-01  8.215293405065198e-01  3.077792074816637e-01 
 	 5.973839676000029e-01  7.455123679769508e-01  2.955396833724338e-01 
 	 7.923011950866407e-01  5.305275901979142e-01  3.013292091767327e-01 
 	 8.481417892324794e-01  4.244218451010338e-01  3.170514197390744e-01 
 	 7.201396575948761e-01  6.394501146862840e-01  2.692627422924177e-01 
 	 8.763310853269225e-01  3.781350826635718e-01  2.984253476981334e-01 
 	 3.320702739066917e-01  9.010541847817660e-01  2.789815213859185e-01 
 	 3.918532580765185e-01  8.800879122926561e-01  2.681348369219698e-01 
 	 5.788843143078826e-01  7.768895044831110e-01  2.476603490110576e-01 
 	 7.982554419358646e-01  5.589981074471367e-01  2.242974928310540e-01 
 	 8.482589290661363e-01  4.765829381357739e-01  2.309231307977713e-01 
 	 9.272572782122075e-01  2.666535296746750e-01  2.628494533274247e-01 
 	 2.582730629531412e-01  9.372315947562253e-01  2.342903385620189e-01 
 	 3.717946600196808e-01  9.026795012335096e-01  2.166528302000051e-01 
 	 5.366255485357277e-01  8.194734035714917e-01  2.012370778402542e-01 
 	 6.600872892883172e-01  7.250854326830368e-01  1.963055929688572e-01 
 	 9.125670483539671e-01  3.445270452292120e-01  2.202782271677272e-01 
 	 4.384722564959894e-01  8.797175995457234e-01  1.839538674038290e-01 
 	 7.759140786614394e-01  6.063208190576896e-01  1.741620134018386e-01 
 	 8.287112733416165e-01  5.307809457462374e-01  1.775083464776969e-01 
 	 8.879376250360261e-01  4.209070992305595e-01  1.854831201557094e-01 
 	 9.328887339944566e-01  3.002082541673077e-01  1.989814416372473e-01 
 	 2.941161323249422e-01  9.400079517322115e-01  1.728604968939674e-01 
 	 3.728492900464204e-01  9.131333175390289e-01  1.648361347279386e-01 
 	 5.247796108050894e-01  8.371130184947483e-01  1.544284764862685e-01 
 	 8.603285843395350e-01  4.851000700385095e-01  1.565651590136353e-01 
 	 9.131333175390290e-01  3.728492900464203e-01  1.648361347279386e-01 
 	 1.747139372582724e-01  9.713759516446867e-01  1.609465771431371e-01 
 	 2.352532961692003e-01  9.597586198148365e-01  1.533599632650150e-01 
 	 4.360874209446712e-01  8.895072208919094e-01  1.363989196254027e-01 
 	 3.645865141824454e-01  9.236336518358192e-01  1.182266927251288e-01 
 	 5.782680413572682e-01  8.085227944321510e-01  1.090732012386840e-01 
 	 6.832549254089274e-01  7.222229887817783e-01  1.075019133762580e-01 
 	 7.926854775445653e-01  5.998830029167510e-01  1.085823028929010e-01 
 	 9.617519999422853e-01  2.424877883551272e-01  1.274078612396161e-01 
 	 1.710181126253892e-01  9.791359375940917e-01  1.097525437782136e-01 
 	 5.067650426043407e-01  8.572491051920165e-01  9.117654984538349e-02 
 	 7.434666891666721e-01  6.629258155059639e-01  8.824196980632100e-02 
 	 8.572491051920165e-01  5.067650426043407e-01  9.117654984538349e-02 
 	 9.041650207861908e-01  4.166256586938052e-01  9.438578126317478e-02 
 	 9.448203023556618e-01  3.120858492680547e-01  9.958423039413787e-02 
 	 9.771120848357381e-01  1.828385257287834e-01  1.087292379136472e-01 
 	 9.857446154747321e-01  1.235050972700319e-01  1.142542953717373e-01 
 	 1.213710676876082e-01  9.884506579362895e-01  9.074337856662869e-02 
 	 2.789280158414780e-01  9.569066979363484e-01  8.080057811235104e-02 
 	 6.626292228084790e-01  7.456365949847285e-01  7.034615341161954e-02 
 	 9.621995917361922e-01  2.597760635264744e-01  8.178228708830601e-02 
 	 8.727590211073921e-02  9.936067880278184e-01  7.161332065892959e-02 
 	 2.089187753565137e-01  9.757734776305693e-01  6.495433516155384e-02 
 	 3.991823029184295e-01  9.150200880236173e-01  5.823854007434244e-02 
 	 5.201818448518464e-01  8.522398106728352e-01  5.566105811839966e-02 
 	 7.857196258917446e-01  6.161823257546170e-01  5.444273060903524e-02 
 	 8.800918910515295e-01  4.714226318518980e-01  5.655939783247742e-02 
 	 9.792375191432287e-01  1.917540212268099e-01  6.575923087721686e-02 
 	 9.943677386210334e-01  7.753592060448747e-02  7.225635892921020e-02 
 	 1.608253868355738e-01  9.857505765457021e-01  4.930512943907682e-02 
 	 3.203041779824833e-01  9.462711304201042e-01  4.445426076793613e-02 
 	 7.280281266588728e-01  6.843954555852148e-01  3.972287965239402e-02 
 	 9.083107694579722e-01  4.161368638094151e-01  4.244592637145194e-02 
 	 9.901378057409904e-01  1.306820212946928e-01  5.049093931340606e-02 
 	 7.930342111691439e-02  9.961906777214881e-01  3.626432158411033e-02 
 	 4.100933199629151e-01  9.115715861607500e-01  2.933789743946413e-02 
 	 5.378380450521120e-01  8.425809888413721e-01  2.806268942239816e-02 
 	 9.414684341277834e-01  3.357290765760502e-01  3.038378979607604e-02 
 	 9.634871058776771e-01  2.658839320858990e-01  3.159638374876147e-02 
 	 9.856955889611445e-01  1.651079695008029e-01  3.381662771277379e-02 
 	 9.969209440126173e-01  6.935328156520310e-02  3.658898365805829e-02 
 	 2.809367698345945e-01  9.595245690648011e-01  1.967568844822900e-02 
 	 6.363128973347191e-01  7.712368624699905e-01  1.730891830648474e-02 
 	 8.097791269950779e-01  5.864752665407786e-01  1.745070826678265e-02 
 	 9.903279846856080e-01  1.370408151306021e-01  2.168634909066889e-02 
 	 9.985913679135394e-01  4.761777181552240e-02  2.340572015322734e-02 
 	 2.963391685401470e-02  9.994779125313766e-01  1.287374591216840e-02 
 	 6.853653667884810e-02  9.975712736595292e-01  1.242163875555182e-02 
 	 1.116714594083493e-01  9.936730175160088e-01  1.197578449368268e-02 
 	 1.856366024762941e-01  9.825532023737416e-01  1.132503095641131e-02 
 	 2.286546661140591e-01  9.734454207614999e-01  1.100256618860503e-02 
 	 3.239710424738677e-01  9.460097285009248e-01  1.040947741253038e-02 
 	 4.273234025129427e-01  9.040443505352705e-01  9.925821377725375e-03 
 	 8.910690472480637e-01  4.537614001058918e-01  9.825721875194262e-03 
 	 9.269741251327064e-01  3.749878843443206e-01  1.015174514180341e-02 
 	 9.541393998475030e-01  2.991767422993084e-01  1.054905331393263e-02 
 	 9.783413633466875e-01  2.066968213074917e-01  1.116247402342640e-02 
 	 9.965858552195339e-01  8.164450893694658e-02  1.228036387063264e-02 
 	 9.980840686036446e-01  6.166178081497997e-02  5.100665282167518e-03 
 	 6.740380729966248e-03  9.999767623019929e-01  1.020844571215590e-03 
 	 2.579715271046737e-02  9.996666957439264e-01  1.002163885318946e-03 
 	 4.572851546568975e-02  9.989534199286283e-01  9.837104258030409e-04 
 	 1.018679432885569e-01  9.947974889823864e-01  9.370402863120140e-04 
 	 1.988286695074073e-01  9.800338771699516e-01  8.716542584748447e-04 
 	 2.683855257586981e-01  9.633112236497755e-01  8.342383347910434e-04 
 	 3.701473690295191e-01  9.289727120072637e-01  7.909149097070244e-04 
 	 5.039830571785858e-01  8.637132126586987e-01  7.512361252361045e-04 
 	 5.834607839321688e-01  8.121409801337683e-01  7.362069145796896e-04 
 	 6.594397979966802e-01  7.517570237361753e-01  7.280669097919049e-04 
 	 7.728097640834123e-01  6.346373260581126e-01  7.300076366393645e-04 
 	 8.303473942153291e-01  5.572455981353780e-01  7.404583428549802e-04 
 	 8.788422482936699e-01  4.771118615548095e-01  7.577452288745543e-04 
 	 9.389713421561851e-01  3.439944435611859e-01  8.008797927851489e-04 
 	 9.633112236497756e-01  2.683855257586980e-01  8.342383347910434e-04 
 	 9.800338771699517e-01  1.988286695074070e-01  8.716542584747806e-04 
 	 9.963037581945715e-01  8.589481771195788e-02  9.495775914644475e-04 
 	 9.996666957439263e-01  2.579715271046759e-02  1.002163885318844e-03 
 	 9.998378812920259e-01  1.797753139413072e-02  1.009702157000411e-03 
 	 5.508498613984965e-01  5.810565679388068e-01  5.991140918493172e-01 
 	 5.306785523738601e-01  6.591206036127253e-01  5.328604920085378e-01 
 	 5.098614615839103e-01  5.483262566232661e-01  6.628571537586623e-01 
 	 4.860919703222792e-01  5.125013400232001e-01  7.078537792952925e-01 
 	 4.807372553860220e-01  6.985654497836158e-01  5.299981166499832e-01 
 	 4.511433912185691e-01  5.886257377764710e-01  6.708124785563507e-01 
 	 4.511433912185691e-01  6.708124785563507e-01  5.886257377764709e-01 
 	 4.218349148133896e-01  5.199939144124944e-01  7.427392770133755e-01 
 	 3.865162338740458e-01  6.521522831945864e-01  6.521522831945863e-01 
 	 4.010710788390754e-01  7.603071171551243e-01  5.109550638971340e-01 
 	 3.911591619161768e-01  4.480844669527931e-01  8.038748786500703e-01 
 	 3.861356429388320e-01  7.944968562847569e-01  4.686939412941597e-01 
 	 3.518255653691735e-01  5.212257837344719e-01  7.775232819170412e-01 
 	 3.496647254722934e-01  4.001820941157554e-01  8.471061747558652e-01 
 	 3.196333881545471e-01  5.981722148432873e-01  7.348635918089294e-01 
 	 3.173576839179120e-01  6.932584788713606e-01  6.470523795885661e-01 
 	 3.205388115833097e-01  7.443738448302031e-01  5.858006908509584e-01 
 	 3.268187104404942e-01  7.858894827699159e-01  5.249449984309276e-01 
 	 3.426442857591132e-01  8.347808966441953e-01  4.309707043808670e-01 
 	 3.342980692554825e-01  3.477466883592480e-01  8.759663473143432e-01 
 	 2.834413491922067e-01  4.688228949263726e-01  8.365799990203907e-01 
 	 2.731457479985224e-01  5.670216193240195e-01  7.770958007668646e-01 
 	 2.697670338036678e-01  7.324043170405277e-01  6.251477136270828e-01 
 	 3.002290294692595e-01  8.795127077989457e-01  3.692152850087776e-01 
 	 2.442240331782353e-01  6.856947650442421e-01  6.856947650442419e-01 
 	 2.476603490110576e-01  7.768895044831111e-01  5.788843143078825e-01 
 	 2.539316968488615e-01  8.271585848684680e-01  5.013256115678225e-01 
 	 2.583418539634473e-01  2.881017243078528e-01  9.220937495404525e-01 
 	 2.395712069705132e-01  4.015719722631886e-01  8.839375475017137e-01 
 	 2.242974928310542e-01  5.589981074471368e-01  7.982554419358645e-01 
 	 2.210730437654977e-01  6.258226117483470e-01  7.479791226663589e-01 
 	 2.342067913681697e-01  8.641865349597992e-01  4.453412305987423e-01 
 	 2.202782271677274e-01  3.445270452292121e-01  9.125670483539668e-01 
 	 2.024108029596467e-01  8.305586685743072e-01  5.188469571090355e-01 
 	 2.184647317151091e-01  9.078672355456003e-01  3.578410871035283e-01 
 	 1.854831201557096e-01  4.209070992305598e-01  8.879376250360260e-01 
 	 1.798173755061332e-01  4.932020831881742e-01  8.511271447938501e-01 
 	 1.728744463740275e-01  6.613866633032534e-01  7.298507432314243e-01 
 	 1.741620134018387e-01  7.759140786614392e-01  6.063208190576895e-01 
 	 1.839538674038290e-01  8.797175995457235e-01  4.384722564959893e-01 
 	 1.989814416372473e-01  9.328887339944565e-01  3.002082541673077e-01 
 	 1.803712237249059e-01  2.349679541748015e-01  9.551210824617412e-01 
 	 1.816636915697488e-01  9.570779782771657e-01  2.258318991244249e-01 
 	 1.601838598201149e-01  1.803020219866444e-01  9.704804541672426e-01 
 	 1.445806356983647e-01  3.233672870926870e-01  9.351631073878890e-01 
 	 1.306204529963357e-01  5.606345247697818e-01  8.176962925776251e-01 
 	 1.389289926514358e-01  9.074620598401856e-01  3.964988587013394e-01 
 	 1.078634377580696e-01  6.423167997299828e-01  7.588113122375313e-01 
 	 1.074566266442828e-01  7.030124726454829e-01  7.030124726454826e-01 
 	 1.103100611977976e-01  8.378816102386377e-01  5.345896534936359e-01 
 	 1.194753082922774e-01  9.309489191398662e-01  3.450503740916390e-01 
 	 1.097525437782137e-01  1.710181126253891e-01  9.791359375940917e-01 
 	 9.846619160151077e-02  3.318875738576888e-01  9.381657888829413e-01 
 	 9.265598059277341e-02  4.613205149748599e-01  8.823821460816859e-01 
 	 9.265598059277347e-02  8.823821460816860e-01  4.613205149748598e-01 
 	 1.107142669670325e-01  9.808432467775335e-01  1.602774979242539e-01 
 	 8.178228708830622e-02  2.597760635264747e-01  9.621995917361922e-01 
 	 7.034615341161964e-02  6.626292228084789e-01  7.456365949847285e-01 
 	 7.101991027046196e-02  8.005974886332373e-01  5.949788513378680e-01 
 	 7.626432569514538e-02  9.198237384737978e-01  3.848480775141680e-01 
 	 7.983561647879230e-02  9.509563532324806e-01  2.988449239793653e-01 
 	 8.277366804884789e-02  9.668770105811153e-01  2.414484754299867e-01 
 	 7.117619389215825e-02  9.406383182410825e-02  9.930186025274611e-01 
 	 6.807985544916638e-02  1.464906953826171e-01  9.868665611157051e-01 
 	 5.887860001871453e-02  3.756720490296664e-01  9.248804366174517e-01 
 	 5.608703015141266e-02  4.957976756671711e-01  8.666250110929324e-01 
 	 5.444273060903540e-02  6.161823257546173e-01  7.857196258917444e-01 
 	 5.426328221838143e-02  7.669509161897655e-01  6.394073727746400e-01 
 	 6.807985544916614e-02  9.868665611157051e-01  1.464906953826168e-01 
 	 4.806662423535752e-02  1.952996373731115e-01  9.795650316730116e-01 
 	 4.501980297476234e-02  2.975969596650663e-01  9.536295228956696e-01 
 	 4.162431215025844e-02  8.838543116507398e-01  4.659066134048912e-01 
 	 5.104905827472670e-02  9.917785816856837e-01  1.173423988113306e-01 
 	 5.324949373291173e-02  9.961759282761525e-01  6.926767890101654e-02 
 	 3.687817315438978e-02  6.072795842016618e-02  9.974728644985353e-01 
 	 3.512050830452571e-02  1.168275721999845e-01  9.925310414643409e-01 
 	 3.381662771277393e-02  1.651079695008031e-01  9.856955889611446e-01 
 	 2.875296476282825e-02  4.610561615997826e-01  8.869050021666484e-01 
 	 2.788489512763991e-02  8.258665927636288e-01  5.631756418567081e-01 
 	 3.038378979607606e-02  9.414684341277835e-01  3.357290765760502e-01 
 	 3.159638374876150e-02  9.634871058776771e-01  2.658839320858991e-01 
 	 3.381662771277381e-02  9.856955889611445e-01  1.651079695008029e-01 
 	 2.022885658682494e-02  2.353972007057420e-01  9.716887110906920e-01 
 	 1.941299688379821e-02  3.047469859752136e-01  9.522354803781534e-01 
 	 1.848488666366027e-02  4.050237950061767e-01  9.141192670783316e-01 
 	 1.766235282340632e-02  5.351809429963181e-01  8.445527807936655e-01 
 	 1.723783311887396e-02  6.840750742034242e-01  7.292078921425258e-01 
 	 1.848488666366015e-02  9.141192670783316e-01  4.050237950061767e-01 
 	 2.051599577690322e-02  9.766578393600165e-01  2.138189859060846e-01 
 	 2.224930219393638e-02  9.942024259880657e-01  1.051974558215520e-01 
 	 2.381386207019708e-02  9.992840451388485e-01  2.939893032477828e-02 
 	 1.278088407579202e-02  3.727242305835519e-02  9.992234061918286e-01 
 	 1.242163875555207e-02  6.853653667884822e-02  9.975712736595294e-01 
 	 1.165312700944981e-02  1.464772765622220e-01  9.891453948140363e-01 
 	 1.132503095641156e-02  1.856366024762941e-01  9.825532023737414e-01 
 	 9.463103320986150e-03  8.109376179527421e-01  5.850560908704983e-01 
 	 9.825721875194348e-03  8.910690472480638e-01  4.537614001058918e-01 
 	 1.054905331393259e-02  9.541393998475030e-01  2.991767422993083e-01 
 	 1.148902528959501e-02  9.861358018669485e-01  1.655420870175482e-01 
 	 1.228036387063271e-02  9.965858552195339e-01  8.164450893694664e-02 
 	 1.301087758050744e-02  9.997412194853548e-01  1.866041603289584e-02 
 	 5.348047959537529e-03  1.104251073035816e-02  9.999247278369469e-01 
 	 4.154131599847820e-03  9.282669514897918e-01  3.718913953864752e-01 
 	 5.206338402264376e-03  9.992209637778886e-01  3.911981067474984e-02 
 	 1.020844571215719e-03  6.740380729966248e-03  9.999767623019931e-01 
 	 1.002163885319132e-03  2.579715271046748e-02  9.996666957439263e-01 
 	 9.730541721666352e-04  5.778321493515740e-02  9.983286799633352e-01 
 	 9.241549721863320e-04  1.190559323318592e-01  9.928871189184494e-01 
 	 8.978607083226983e-04  1.568596378242469e-01  9.876204978977474e-01 
 	 8.342383347913616e-04  2.683855257586982e-01  9.633112236497755e-01 
 	 7.729409277520053e-04  4.233420725474484e-01  9.059695867817822e-01 
 	 7.577452288746967e-04  4.771118615548096e-01  8.788422482936697e-01 
 	 7.280669097919954e-04  6.594397979966802e-01  7.517570237361753e-01 
 	 7.269017333968298e-04  7.298385814686177e-01  6.836191312520049e-01 
 	 7.404583428552443e-04  8.303473942153291e-01  5.572455981353781e-01 
 	 7.729409277520053e-04  9.059695867817822e-01  4.233420725474483e-01 
 	 8.225874685167979e-04  9.561040058585499e-01  2.930263696855466e-01 
 	 8.588434235061250e-04  9.752263521769857e-01  2.212076499751844e-01 
 	 9.370402863119648e-04  9.947974889823864e-01  1.018679432885567e-01 
 	 9.616292551361378e-04  9.974626525637968e-01  7.118519515720936e-02 
 	 1.002163885318846e-03  9.996666957439263e-01  2.579715271046753e-02 
 	 1.026201775047253e-03  9.999983950528746e-01  1.468605322019645e-03 
 	 ]; 
 

 	  
 

 	 case 10
 	 pts=[
 	 5.991399722776622e-01  5.184321929030129e-01  6.101306048551370e-01 
 	 5.435326275361544e-01  5.152380385888630e-01  6.626477543874615e-01 
 	 6.920699576091149e-01  4.851124357779714e-01  5.345138898368136e-01 
 	 6.543787147760236e-01  4.746811019762597e-01  5.886139219171452e-01 
 	 5.836686547895011e-01  4.752741048406708e-01  6.583657241109330e-01 
 	 6.928528638975124e-01  4.410713534512273e-01  5.704480433428778e-01 
 	 6.356478752810683e-01  4.163436536504537e-01  6.500844104542537e-01 
 	 5.464397270650605e-01  4.250166224408677e-01  7.216401425461439e-01 
 	 7.793299356412390e-01  4.224564414418117e-01  4.627908885206616e-01 
 	 7.421946637544903e-01  4.061993624087958e-01  5.330564314151429e-01 
 	 7.172114488406451e-01  3.539165936295189e-01  6.002922474974841e-01 
 	 5.793074097947003e-01  3.556846782483534e-01  7.334107543636925e-01 
 	 4.735151532310540e-01  3.715977772724403e-01  7.985602617127610e-01 
 	 8.239441648531751e-01  3.529349470529994e-01  4.433429105704751e-01 
 	 8.011900059420075e-01  3.441516322079421e-01  4.895449197236708e-01 
 	 7.538824986603128e-01  3.339995232655239e-01  5.657786640304550e-01 
 	 6.458285005281736e-01  3.289573013410233e-01  6.889794204473468e-01 
 	 8.590490656420526e-01  3.403540506535512e-01  3.823530083878460e-01 
 	 5.498154375687716e-01  3.119762357594595e-01  7.748379268804660e-01 
 	 4.473112027541633e-01  3.264863239815050e-01  8.326580139190805e-01 
 	 8.534455799422428e-01  3.049056839102031e-01  4.226856586120473e-01 
 	 6.656942120057849e-01  2.818140494041750e-01  6.909645849538298e-01 
 	 5.991002564842295e-01  2.842020277057757e-01  7.485373004256074e-01 
 	 5.182130686442751e-01  2.911378084412002e-01  8.041728620031510e-01 
 	 8.967258292566124e-01  2.963162299425916e-01  3.287544357368431e-01 
 	 8.329378313011558e-01  2.704110628371393e-01  4.827964646542224e-01 
 	 7.994004595294889e-01  2.645890288501435e-01  5.393992501998681e-01 
 	 7.580718406528365e-01  2.604300713524751e-01  5.979157652584226e-01 
 	 4.188256033380890e-01  2.792190480373815e-01  8.640728193859498e-01 
 	 9.162720828074465e-01  2.755951565580286e-01  2.906764179452123e-01 
 	 3.683072865248640e-01  2.606649056644171e-01  8.924144494839000e-01 
 	 3.209685959683007e-01  2.692476099046281e-01  9.080115004573361e-01 
 	 9.019012394441850e-01  2.345965737543975e-01  3.626825083619837e-01 
 	 8.582179797372983e-01  2.225310036433935e-01  4.625384866939121e-01 
 	 8.107084777329915e-01  2.158371717461040e-01  5.442114289726911e-01 
 	 7.353752422103577e-01  2.113340598164401e-01  6.438642467986238e-01 
 	 6.599416878200646e-01  2.110128311240788e-01  7.210759694915686e-01 
 	 5.944277018681294e-01  2.130498328294434e-01  7.754131002137639e-01 
 	 4.945966134840253e-01  2.195824313350929e-01  8.409267184357404e-01 
 	 4.354750241475465e-01  2.003511663225654e-01  8.776223068592101e-01 
 	 2.977346322723711e-01  2.172193293382864e-01  9.296073642713149e-01 
 	 9.343793972017097e-01  1.897968158393553e-01  3.015166840859915e-01 
 	 8.959538194633314e-01  1.784667527330379e-01  4.067141152677060e-01 
 	 7.761139246967318e-01  1.664387198979131e-01  6.082313115999372e-01 
 	 6.448060019046152e-01  1.655328741288590e-01  7.462064643853098e-01 
 	 9.482040733327290e-01  1.676369527600132e-01  2.698275141355264e-01 
 	 8.365176260989925e-01  1.473213763728373e-01  5.277638423474261e-01 
 	 7.173215642396401e-01  1.432205970530526e-01  6.818633543874923e-01 
 	 5.868883574586434e-01  1.450378354638761e-01  7.965714545246078e-01 
 	 4.123684229593904e-01  1.541873688439230e-01  8.978744561657679e-01 
 	 3.593641898091764e-01  1.584773278404330e-01  9.196424933871586e-01 
 	 2.575221623503035e-01  1.691112032232984e-01  9.513588896114821e-01 
 	 9.737471383724168e-01  1.542261940381562e-01  1.674239874809892e-01 
 	 9.653680938146149e-01  1.484145703130489e-01  2.145636473485899e-01 
 	 9.145089337286713e-01  1.334512064525165e-01  3.819217009110856e-01 
 	 5.220801027833546e-01  1.259801266767233e-01  8.435409734922416e-01 
 	 2.145636473485895e-01  1.484145703130489e-01  9.653680938146150e-01 
 	 9.364394143058273e-01  1.146777857492671e-01  3.315572782947227e-01 
 	 8.956787985910331e-01  1.091287344698014e-01  4.311037103384094e-01 
 	 8.624036850077340e-01  1.064631401704264e-01  4.948994684480205e-01 
 	 7.582598462628810e-01  1.027906963636575e-01  6.437981657992405e-01 
 	 6.839843583160212e-01  1.024601773461642e-01  7.222654011076629e-01 
 	 2.786205033003671e-01  1.184109978417432e-01  9.530736858872837e-01 
 	 1.648523926650427e-01  1.287471758237369e-01  9.778792631761972e-01 
 	 9.680156275114430e-01  9.989037663567271e-02  2.301470346304962e-01 
 	 9.493597814747053e-01  9.550583986926318e-02  2.993236373378594e-01 
 	 4.441214172105305e-01  8.882464403905568e-02  8.915527743135820e-01 
 	 1.440394270410248e-01  1.067471164915659e-01  9.837975892318649e-01 
 	 9.872915558370039e-01  8.533487105028856e-02  1.340646991410450e-01 
 	 9.767604418212031e-01  8.113111953840653e-02  1.983854347871657e-01 
 	 7.989715117762801e-01  6.754649397721769e-02  5.975633811750107e-01 
 	 7.255743894400858e-01  6.684607945700936e-02  6.848893392730492e-01 
 	 5.975633811750107e-01  6.754649397721775e-02  7.989715117762802e-01 
 	 4.137983581935025e-01  7.160370803614301e-02  9.075482509221405e-01 
 	 3.266395106761097e-01  7.474887455812988e-02  9.421885351762482e-01 
 	 2.486192386369960e-01  7.834875247763200e-02  9.654273391430135e-01 
 	 9.941898066294006e-01  6.829235260550391e-02  8.320326297568252e-02 
 	 9.742540339331042e-01  6.139280421663987e-02  2.169331716347022e-01 
 	 9.312054502946021e-01  5.640519378295605e-02  3.601039620108817e-01 
 	 8.898120793574339e-01  5.414457975442085e-02  4.531035509823522e-01 
 	 5.246079453372366e-01  5.285763838627548e-02  8.497014615459176e-01 
 	 2.169331716347021e-01  6.139280421663986e-02  9.742540339331042e-01 
 	 8.968447669519994e-02  6.789245650260019e-02  9.936535155626184e-01 
 	 9.972522929938176e-01  5.132673410820151e-02  5.341751102736710e-02 
 	 9.637315668571312e-01  4.365327936616574e-02  2.632790501420082e-01 
 	 8.374786228692176e-01  3.859066562976611e-02  5.451057849292470e-01 
 	 7.674193744320336e-01  3.788999704676135e-02  6.400248837897966e-01 
 	 6.849784172557901e-01  3.774891188144022e-02  7.275847631345230e-01 
 	 4.473656351941739e-01  3.982862298506528e-02  8.934638600628605e-01 
 	 1.693277970112211e-01  4.653630748983864e-02  9.844604965383517e-01 
 	 1.245429192451030e-01  4.820058347887182e-02  9.910427664930530e-01 
 	 6.050247098223722e-02  5.098508323842248e-02  9.968650722601402e-01 
 	 9.965506041127471e-01  3.454917661514116e-02  7.545361381494474e-02 
 	 9.894906367042681e-01  3.271148159354971e-02  1.408482830798340e-01 
 	 9.766562542516573e-01  3.104754467817328e-02  2.125526076071030e-01 
 	 9.383421743378705e-01  2.872707996807003e-02  3.445122911238228e-01 
 	 9.082576811066163e-01  2.777744511312844e-02  4.174882013348633e-01 
 	 3.209753066432299e-01  2.908046936061364e-02  9.466409978587718e-01 
 	 9.983141332450898e-01  2.209168767121512e-02  5.367353816307015e-02 
 	 9.860737234161310e-01  2.015297130836353e-02  1.650832206364169e-01 
 	 8.416531023191851e-01  1.674838338082816e-02  5.397587859503726e-01 
 	 7.070121750022353e-01  1.635753029088377e-02  7.070121750022353e-01 
 	 6.617061413570077e-01  1.638959157421416e-02  7.495841272188535e-01 
 	 5.896794467008438e-01  1.655748127470725e-02  8.074676463812185e-01 
 	 4.890254192699720e-01  1.700108946741954e-02  8.721038368593209e-01 
 	 2.037268855132477e-01  1.960868468071243e-02  9.788313724049533e-01 
 	 1.000389482158061e-01  2.121043107812049e-02  9.947574209089146e-01 
 	 6.339047511875498e-02  2.189713459279853e-02  9.977485470602517e-01 
 	 3.814192539544838e-02  2.241438189504530e-02  9.990209152021748e-01 
 	 9.992998156282261e-01  1.215010896183778e-02  3.538719171690131e-02 
 	 9.969192632939288e-01  1.169511760596150e-02  7.755776361959552e-02 
 	 9.924459628324369e-01  1.126963852725699e-02  1.221638494197939e-01 
 	 9.708090209617467e-01  1.036938986014920e-02  2.396295486229169e-01 
 	 9.583415551444244e-01  1.008905195988053e-02  2.854464480667384e-01 
 	 9.004745717958045e-01  9.392667852524066e-03  4.348072254916826e-01 
 	 7.501021263898096e-01  8.883036031477914e-03  6.612623470728918e-01 
 	 3.836710844156663e-01  9.596727062841185e-03  9.234199487844023e-01 
 	 2.622000789765571e-01  1.022690442135379e-02  9.649593405997186e-01 
 	 1.766706192764796e-01  1.081612953652166e-02  9.842105992247362e-01 
 	 1.221638494197939e-01  1.126963852725692e-02  9.924459628324369e-01 
 	 9.995841203930299e-01  4.989913144597000e-03  2.840223626586529e-02 
 	 9.851675980804615e-01  4.432361690685395e-03  1.715376281234447e-01 
 	 2.131610352955278e-01  4.307279877174479e-03  9.770075846030053e-01 
 	 9.999388560377039e-01  9.644588913937177e-04  1.101607938673669e-02 
 	 9.990583960777080e-01  9.353078942684100e-04  4.337564323189467e-02 
 	 9.953110474329945e-01  8.927916925771265e-04  9.672187850134552e-02 
 	 9.888225460743925e-01  8.567638693782853e-04  1.490947293858108e-01 
 	 9.601805292369433e-01  7.864636385493560e-04  2.793791916897330e-01 
 	 9.253075298739792e-01  7.472751091685584e-04  3.792168465910056e-01 
 	 9.022828048791102e-01  7.310686756511976e-04  4.311440658968614e-01 
 	 8.603787159165387e-01  7.115246067723673e-04  5.096547448327564e-01 
 	 8.096589643982712e-01  6.980033481541926e-04  5.869002250475330e-01 
 	 6.842496135339947e-01  6.896350473366055e-04  7.292475510977602e-01 
 	 5.096547448327564e-01  7.115246067724228e-04  8.603787159165386e-01 
 	 4.311440658968614e-01  7.310686756512531e-04  9.022828048791102e-01 
 	 3.536309289111340e-01  7.562711528403743e-04  9.353847305635216e-01 
 	 2.793791916897329e-01  7.864636385494030e-04  9.601805292369434e-01 
 	 1.305529892139437e-01  8.689324170680808e-04  9.914409523333997e-01 
 	 1.130781494130235e-01  8.809788469349554e-04  9.935857064197317e-01 
 	 5.482115149295431e-02  9.256357465474099e-04  9.984957609060997e-01 
 	 3.324677511462312e-02  9.441379090548497e-04  9.994467272186579e-01 
 	 6.390328530510621e-03  9.688576469163750e-04  9.999791122899179e-01 
 	 5.873532140805593e-01  5.922181557938105e-01  5.516283693370153e-01 
 	 6.289661933839029e-01  5.630494275224519e-01  5.360754328886953e-01 
 	 5.599018984296988e-01  6.524732690516771e-01  5.106745512631671e-01 
 	 5.272928288870909e-01  6.961419368714442e-01  4.871844376959543e-01 
 	 6.460042353702072e-01  5.985611565757383e-01  4.737120113766046e-01 
 	 7.011496292229945e-01  5.177980103974915e-01  4.901779451065261e-01 
 	 6.126730043113657e-01  6.459492912420862e-01  4.553913733613449e-01 
 	 4.761329445019672e-01  7.469282271319934e-01  4.641073611497062e-01 
 	 5.639998275002734e-01  6.974982584395580e-01  4.420411452042053e-01 
 	 6.974982584395580e-01  5.639998275002733e-01  4.420411452042053e-01 
 	 7.632311464597148e-01  4.696303866583693e-01  4.437629062922001e-01 
 	 4.365426426798001e-01  7.898586442440891e-01  4.307596118893063e-01 
 	 5.179213844777321e-01  7.512913322155168e-01  4.090461754356140e-01 
 	 6.494536989454308e-01  6.494536989454307e-01  3.954994132134656e-01 
 	 7.279019681993625e-01  5.715245360293297e-01  3.788382628615456e-01 
 	 7.681792965332512e-01  5.090976120629211e-01  3.882269822790667e-01 
 	 4.151571741427338e-01  8.238584160412051e-01  3.858780002486488e-01 
 	 4.654612537068691e-01  8.024868307942107e-01  3.733104709213142e-01 
 	 5.688699519301477e-01  7.410309239543050e-01  3.567354026928369e-01 
 	 6.212203692609027e-01  6.998148233990098e-01  3.526251065456916e-01 
 	 8.200273259194769e-01  4.251994620072070e-01  3.830934641234874e-01 
 	 7.692930190287610e-01  5.431108456392710e-01  3.364801037544570e-01 
 	 8.011900059420076e-01  4.895449197236708e-01  3.441516322079422e-01 
 	 3.712378794310543e-01  8.627984270038233e-01  3.431636799477216e-01 
 	 7.385012453037956e-01  5.998914332319071e-01  3.078086727493420e-01 
 	 4.443809160122304e-01  8.436803094432803e-01  3.012127768568619e-01 
 	 5.182130686442751e-01  8.041728620031510e-01  2.911378084412002e-01 
 	 5.991002564842296e-01  7.485373004256073e-01  2.842020277057757e-01 
 	 6.656942120057850e-01  6.909645849538297e-01  2.818140494041750e-01 
 	 8.652527011534082e-01  3.936703075715413e-01  3.104214104781742e-01 
 	 4.188256033380889e-01  8.640728193859498e-01  2.792190480373813e-01 
 	 7.994004595294889e-01  5.393992501998681e-01  2.645890288501434e-01 
 	 8.459963329830664e-01  4.728129798989541e-01  2.464509902968048e-01 
 	 8.835570268580590e-01  3.915183081826140e-01  2.569832575238529e-01 
 	 3.389985532570212e-01  9.101389151386666e-01  2.381745915076956e-01 
 	 4.945966134840253e-01  8.409267184357404e-01  2.195824313350929e-01 
 	 5.944277018681294e-01  7.754131002137638e-01  2.130498328294434e-01 
 	 7.353752422103578e-01  6.438642467986236e-01  2.113340598164401e-01 
 	 7.994970685092885e-01  5.609523736874824e-01  2.147949531516824e-01 
 	 9.101389151386667e-01  3.389985532570211e-01  2.381745915076956e-01 
 	 3.325813767069227e-01  9.188998652340297e-01  2.121618852211913e-01 
 	 4.354750241475467e-01  8.776223068592101e-01  2.003511663225654e-01 
 	 6.945511594912605e-01  6.945511594912603e-01  1.876096311458755e-01 
 	 8.695429942202855e-01  4.520629157408848e-01  1.988318420532041e-01 
 	 9.406133150414091e-01  2.547931115012876e-01  2.243369383278270e-01 
 	 2.392302313953436e-01  9.504326731183149e-01  1.986117575968374e-01 
 	 4.067141152677061e-01  8.959538194633314e-01  1.784667527330380e-01 
 	 4.960668087179642e-01  8.511415539872410e-01  1.716851081618880e-01 
 	 6.448060019046155e-01  7.462064643853097e-01  1.655328741288590e-01 
 	 7.761139246967318e-01  6.082313115999370e-01  1.664387198979132e-01 
 	 8.959538194633314e-01  4.067141152677060e-01  1.784667527330380e-01 
 	 3.765331372604866e-01  9.130020956469400e-01  1.570030887883141e-01 
 	 5.868883574586435e-01  7.965714545246078e-01  1.450378354638760e-01 
 	 7.173215642396402e-01  6.818633543874923e-01  1.432205970530527e-01 
 	 8.365176260989925e-01  5.277638423474261e-01  1.473213763728373e-01 
 	 9.541360565079497e-01  2.460510853313447e-01  1.705381162049292e-01 
 	 2.145636473485899e-01  9.653680938146149e-01  1.484145703130488e-01 
 	 5.220801027833546e-01  8.435409734922416e-01  1.259801266767233e-01 
 	 9.145089337286713e-01  3.819217009110855e-01  1.334512064525166e-01 
 	 9.674121140357709e-01  2.042806357698912e-01  1.496102385075616e-01 
 	 1.446684559214049e-01  9.807723667049757e-01  1.309832148377686e-01 
 	 3.132329782239988e-01  9.425770867801161e-01  1.159031355487565e-01 
 	 6.839843583160213e-01  7.222654011076629e-01  1.024601773461644e-01 
 	 7.582598462628812e-01  6.437981657992404e-01  1.027906963636575e-01 
 	 8.222119641252449e-01  5.595201775038431e-01  1.044253657660574e-01 
 	 8.624036850077340e-01  4.948994684480205e-01  1.064631401704264e-01 
 	 9.425770867801161e-01  3.132329782239989e-01  1.159031355487564e-01 
 	 9.822728291431380e-01  1.327302856543465e-01  1.323735638156322e-01 
 	 4.441214172105306e-01  8.915527743135820e-01  8.882464403905568e-02 
 	 9.768805639568752e-01  1.872905176579227e-01  1.030855264269667e-01 
 	 9.876506086941592e-01  1.117500904849626e-01  1.098098011229396e-01 
 	 1.158809520174853e-01  9.894741798634515e-01  8.667440419795959e-02 
 	 1.983854347871657e-01  9.767604418212031e-01  8.113111953840670e-02 
 	 2.486192386369963e-01  9.654273391430135e-01  7.834875247763212e-02 
 	 3.913850344933522e-01  9.173798664020683e-01  7.233211938524214e-02 
 	 5.975633811750107e-01  7.989715117762801e-01  6.754649397721775e-02 
 	 7.989715117762802e-01  5.975633811750106e-01  6.754649397721775e-02 
 	 9.421885351762483e-01  3.266395106761097e-01  7.474887455813001e-02 
 	 9.697185184997381e-01  2.309994496974996e-01  7.927956305458365e-02 
 	 1.062439614087466e-01  9.920866528637299e-01  6.690511096932632e-02 
 	 2.947347486638430e-01  9.537909727714627e-01  5.843122615287148e-02 
 	 5.483678651257516e-01  8.345866946922561e-01  5.251412705244393e-02 
 	 7.267187468138814e-01  6.850092004160712e-01  5.140290239467601e-02 
 	 8.898120793574339e-01  4.531035509823521e-01  5.414457975442085e-02 
 	 9.779142967656523e-01  1.995527044799716e-01  6.214777804611184e-02 
 	 9.936535155626184e-01  8.968447669519992e-02  6.789245650260019e-02 
 	 1.693277970112211e-01  9.844604965383517e-01  4.653630748983859e-02 
 	 4.717959860567865e-01  8.808238134297305e-01  3.947096699869261e-02 
 	 6.849784172557902e-01  7.275847631345230e-01  3.774891188144034e-02 
 	 9.434613840949075e-01  3.288049871398465e-01  4.204636909040600e-02 
 	 9.870499918758396e-01  1.533404586443647e-01  4.710644627480000e-02 
 	 8.616910611155937e-02  9.956925227082999e-01  3.422404673203482e-02 
 	 1.254744780254972e-01  9.915440775369176e-01  3.311340613244386e-02 
 	 2.125526076071029e-01  9.766562542516571e-01  3.104754467817326e-02 
 	 2.755412151965775e-01  9.608262102846831e-01  2.983341009618889e-02 
 	 3.445122911238228e-01  9.383421743378704e-01  2.872707996807014e-02 
 	 8.060114183427254e-01  5.913142254013340e-01  2.632641903428083e-02 
 	 8.699828308236301e-01  4.923413376042218e-01  2.701631651777555e-02 
 	 9.667872087631703e-01  2.537886778680717e-01  3.022912433224420e-02 
 	 9.915440775369176e-01  1.254744780254970e-01  3.311340613244386e-02 
 	 2.793515614430932e-02  9.993534406447474e-01  2.263465755646916e-02 
 	 5.367353816307004e-02  9.983141332450899e-01  2.209168767121517e-02 
 	 5.896794467008438e-01  8.074676463812185e-01  1.655748127470719e-02 
 	 7.495841272188535e-01  6.617061413570077e-01  1.638959157421429e-02 
 	 9.106479218410385e-01  4.128128081479517e-01  1.749136574428587e-02 
 	 9.491035731396544e-01  3.144301401767585e-01  1.833287762367633e-02 
 	 9.743082492061554e-01  2.243866889373167e-01  1.934035564781354e-02 
 	 9.960118311115972e-01  8.660348395554614e-02  2.145387732986083e-02 
 	 9.983141332450899e-01  5.367353816306969e-02  2.209168767121516e-02 
 	 9.992219470487668e-01  3.236555444448806e-02  2.253822134890890e-02 
 	 4.398033639571251e-02  9.989596884808049e-01  1.205283372710122e-02 
 	 1.221638494197940e-01  9.924459628324370e-01  1.126963852725704e-02 
 	 1.766706192764798e-01  9.842105992247363e-01  1.081612953652173e-02 
 	 2.396295486229169e-01  9.708090209617468e-01  1.036938986014919e-02 
 	 3.336674743169468e-01  9.426395855531172e-01  9.829971067953349e-03 
 	 4.091389773807355e-01  9.124227202084012e-01  9.490881694970589e-03 
 	 5.121790367730316e-01  8.588300068304565e-01  9.146237360122884e-03 
 	 6.612623470728919e-01  7.501021263898094e-01  8.883036031478034e-03 
 	 8.262449882058350e-01  5.632386616572199e-01  9.023828418309383e-03 
 	 8.736816926939291e-01  4.864106173962440e-01  9.220148354309250e-03 
 	 9.234199487844023e-01  3.836710844156663e-01  9.596727062841129e-03 
 	 9.583415551444244e-01  2.854464480667382e-01  1.008905195988052e-02 
 	 9.842105992247362e-01  1.766706192764796e-01  1.081612953652173e-02 
 	 9.924459628324370e-01  1.221638494197939e-01  1.126963852725693e-02 
 	 9.998168830609083e-01  1.457862438543049e-02  1.239613074303096e-02 
 	 1.506419712848888e-02  9.998737536131681e-01  5.054384273844953e-03 
 	 4.584970544628421e-01  8.886877868941663e-01  3.803744739901244e-03 
 	 9.719291208576382e-01  2.352355243989855e-01  4.246420802598924e-03 
 	 9.992986559270099e-01  3.711741309077029e-02  4.949132037082993e-03 
 	 6.390328530510797e-03  9.999791122899179e-01  9.688576469163281e-04 
 	 5.482115149295431e-02  9.984957609060998e-01  9.256357465473544e-04 
 	 8.153185937209438e-02  9.966703257510627e-01  9.042536145297530e-04 
 	 1.130781494130236e-01  9.935857064197317e-01  8.809788469350194e-04 
 	 1.686477868571093e-01  9.856760170953014e-01  8.445776116932590e-04 
 	 2.327627036308921e-01  9.725332228685497e-01  8.088357987716791e-04 
 	 2.793791916897329e-01  9.601805292369434e-01  7.864636385493475e-04 
 	 3.536309289111341e-01  9.353847305635216e-01  7.562711528402633e-04 
 	 5.869002250475330e-01  8.096589643982712e-01  6.980033481543037e-04 
 	 6.842496135339948e-01  7.292475510977601e-01  6.896350473366055e-04 
 	 7.908643267731378e-01  6.119911223169013e-01  6.948690315240370e-04 
 	 8.603787159165386e-01  5.096547448327564e-01  7.115246067724783e-04 
 	 8.893038091644792e-01  4.573163139130387e-01  7.239022990635077e-04 
 	 9.667475945565041e-01  2.557312113871397e-01  7.974595157735797e-04 
 	 9.856760170953015e-01  1.686477868571091e-01  8.445776116932590e-04 
 	 9.966703257510630e-01  8.153185937209374e-02  9.042536145297358e-04 
 	 9.984957609060998e-01  5.482115149295418e-02  9.256357465473544e-04 
 	 9.994467272186579e-01  3.324677511462311e-02  9.441379090549138e-04 
 	 9.999791122899179e-01  6.390328530510556e-03  9.688576469163195e-04 
 	 9.999985557611126e-01  1.392991703235219e-03  9.736784908584595e-04 
 	 5.318674933301182e-01  6.135595227864231e-01  5.836623009385080e-01 
 	 5.063666705834649e-01  5.828339419909141e-01  6.355292211893554e-01 
 	 5.194408984710317e-01  6.690519188567328e-01  5.315549669316723e-01 
 	 4.746657454040557e-01  5.067396978753518e-01  7.196577719563719e-01 
 	 4.586247648656047e-01  6.749387517893436e-01  5.780320115573289e-01 
 	 4.712858253237372e-01  7.139388685541539e-01  5.178619148156566e-01 
 	 4.673254091367631e-01  4.674442226651206e-01  7.504017994862207e-01 
 	 4.420411452042055e-01  5.639998275002733e-01  6.974982584395579e-01 
 	 4.369670395059065e-01  6.101794797075942e-01  6.608636840750238e-01 
 	 4.300803035623708e-01  4.385320962854301e-01  7.891264366470087e-01 
 	 4.061993624087959e-01  5.330564314151429e-01  7.421946637544902e-01 
 	 3.898016388086258e-01  5.009890867715755e-01  7.726995647196215e-01 
 	 3.769291090241710e-01  5.904285388973364e-01  7.136655990208586e-01 
 	 3.754577158561186e-01  6.983172010623966e-01  6.094133164810944e-01 
 	 3.866918793290658e-01  7.633540715792393e-01  5.174552655682934e-01 
 	 3.711252630950010e-01  3.721853356110676e-01  8.507315176063147e-01 
 	 3.287537578250107e-01  6.785165755639507e-01  6.569141674533315e-01 
 	 3.329165135685996e-01  7.456216843259703e-01  5.772476928115274e-01 
 	 3.564332511568761e-01  8.307314341852875e-01  4.275986689948820e-01 
 	 3.228822277340191e-01  4.680013107151698e-01  8.226310474218682e-01 
 	 3.119762357594597e-01  5.498154375687715e-01  7.748379268804660e-01 
 	 3.059792312262292e-01  6.372376005811147e-01  7.073223808588482e-01 
 	 3.132916219734826e-01  7.829103450934684e-01  5.374939545212120e-01 
 	 2.828457605021610e-01  7.265966959975706e-01  6.261433678730201e-01 
 	 2.949180042441901e-01  3.350246550577222e-01  8.948641524142523e-01 
 	 2.829387460098793e-01  3.962834731950011e-01  8.734443742327634e-01 
 	 2.720696635851105e-01  4.692685076832493e-01  8.400983072554193e-01 
 	 2.622764977034189e-01  5.685952087620488e-01  7.796861723317084e-01 
 	 2.633771953595085e-01  7.897857045678841e-01  5.539593792190635e-01 
 	 2.704110628371395e-01  8.329378313011560e-01  4.827964646542224e-01 
 	 2.847901319638522e-01  8.775326721212467e-01  3.857861973888594e-01 
 	 2.997672501056729e-01  9.008859567205585e-01  3.139173278870841e-01 
 	 2.343426089627769e-01  6.728325751326573e-01  7.016978462735056e-01 
 	 2.489455765247360e-01  2.778113446955425e-01  9.278183856160759e-01 
 	 2.345965737543977e-01  3.626825083619837e-01  9.019012394441850e-01 
 	 2.123546801878632e-01  6.110597634105281e-01  7.625689839896321e-01 
 	 2.123546801878631e-01  7.625689839896321e-01  6.110597634105280e-01 
 	 2.241178901742375e-01  8.660222955689453e-01  4.469637064475623e-01 
 	 2.416212666039461e-01  9.168087810337715e-01  3.179321036700679e-01 
 	 2.526572236050907e-01  9.321090499678182e-01  2.594938271486600e-01 
 	 2.264273298332735e-01  2.432987313453088e-01  9.431523692544790e-01 
 	 2.138818987584691e-01  3.202609156237607e-01  9.228691561143987e-01 
 	 2.003511663225656e-01  4.354750241475466e-01  8.776223068592101e-01 
 	 1.914491298146149e-01  5.566786391328211e-01  8.083663299683239e-01 
 	 1.914491298146149e-01  8.083663299683238e-01  5.566786391328212e-01 
 	 1.655328741288592e-01  7.462064643853098e-01  6.448060019046152e-01 
 	 1.800106321584740e-01  9.030600765558719e-01  3.899726534525327e-01 
 	 1.792995512850797e-01  1.835716504679675e-01  9.665159698905319e-01 
 	 1.630540912270154e-01  3.114497944417940e-01  9.361689958956644e-01 
 	 1.528620319195370e-01  4.309259687070298e-01  8.893458318850651e-01 
 	 1.436390256170903e-01  6.447527619183072e-01  7.507740714212816e-01 
 	 1.431681684482384e-01  6.998224330296854e-01  6.998224330296853e-01 
 	 1.599838857739307e-01  9.256991407529780e-01  3.427626833566804e-01 
 	 1.676369527600134e-01  9.482040733327290e-01  2.698275141355263e-01 
 	 1.755242451820203e-01  9.620415798694073e-01  2.089670738553249e-01 
 	 1.268335325255621e-01  5.014343448145038e-01  8.558486156251797e-01 
 	 1.239219104697662e-01  5.839572557787726e-01  8.022700814120195e-01 
 	 1.226632512818608e-01  7.547855789522994e-01  6.444008508611744e-01 
 	 1.239219104697662e-01  8.022700814120196e-01  5.839572557787724e-01 
 	 1.268335325255620e-01  8.558486156251797e-01  5.014343448145038e-01 
 	 1.309920584104124e-01  8.977866243691766e-01  4.205000092000028e-01 
 	 1.535181281723249e-01  9.729183479823799e-01  1.728064596064121e-01 
 	 1.112074003291480e-01  3.899422834999828e-01  9.140995184611201e-01 
 	 1.146777857492672e-01  9.364394143058273e-01  3.315572782947226e-01 
 	 1.209362922992047e-01  9.614272666171644e-01  2.470466033159925e-01 
 	 1.074930089151172e-01  1.358773270090549e-01  9.848769491866732e-01 
 	 1.040841739594486e-01  1.749316281289429e-01  9.790635373719810e-01 
 	 9.768723930026717e-02  2.631642299744535e-01  9.597925772477329e-01 
 	 9.340604865738611e-02  3.382053992905758e-01  9.364253403047763e-01 
 	 8.882464403905577e-02  4.441214172105304e-01  8.915527743135820e-01 
 	 8.560354644299963e-02  5.556612980241213e-01  8.269900572041540e-01 
 	 8.420387772788203e-02  6.429989861590605e-01  7.612240214115739e-01 
 	 8.420387772788203e-02  7.612240214115740e-01  6.429989861590603e-01 
 	 8.612218410998362e-02  8.415114997802241e-01  5.333304464792573e-01 
 	 1.040841739594484e-01  9.790635373719812e-01  1.749316281289424e-01 
 	 8.667440419795985e-02  1.158809520174853e-01  9.894741798634515e-01 
 	 7.091938604421132e-02  8.969007411484794e-01  4.365083060039300e-01 
 	 7.561834625721475e-02  9.489857010898078e-01  3.061176323513724e-01 
 	 7.834875247763219e-02  9.654273391430135e-01  2.486192386369960e-01 
 	 6.289713827796409e-02  1.831040516806165e-01  9.810794342226244e-01 
 	 5.520315168808505e-02  4.060146556489345e-01  9.121977370296307e-01 
 	 5.285763838627575e-02  5.246079453372365e-01  8.497014615459177e-01 
 	 5.137957132689865e-02  7.061728328285733e-01  7.061728328285732e-01 
 	 5.221491863984119e-02  8.186149097070888e-01  5.719643624184024e-01 
 	 5.578737545905287e-02  9.221143940532230e-01  3.828744089375104e-01 
 	 6.214777804611186e-02  9.779142967656524e-01  1.995527044799716e-01 
 	 6.435332149311238e-02  9.861007753149378e-01  1.531793423934270e-01 
 	 6.742816635097394e-02  9.929614759193360e-01  9.737016854580816e-02 
 	 4.919708615057436e-02  1.002281135604436e-01  9.937474387219359e-01 
 	 4.155087321035082e-02  3.517794870306038e-01  9.351602629709748e-01 
 	 3.780185370010544e-02  6.627656930296646e-01  7.478720853192370e-01 
 	 4.421929622653165e-02  9.690683511524694e-01  2.427986503995946e-01 
 	 4.820058347887184e-02  9.910427664930530e-01  1.245429192451031e-01 
 	 5.072689152727770e-02  9.965321227357288e-01  6.595840228357693e-02 
 	 3.533567104445158e-02  5.083999793799188e-02  9.980815021637778e-01 
 	 3.422404673203513e-02  8.616910611155944e-02  9.956925227082999e-01 
 	 3.188355134017928e-02  1.747568463520067e-01  9.840952615509533e-01 
 	 3.022912433224450e-02  2.537886778680715e-01  9.667872087631704e-01 
 	 2.632641903428086e-02  5.913142254013340e-01  8.060114183427253e-01 
 	 2.606502054401651e-02  7.488535321065916e-01  6.622227738121984e-01 
 	 2.724768857056123e-02  8.836702570595467e-01  4.673162101360023e-01 
 	 2.872707996807023e-02  9.383421743378705e-01  3.445122911238226e-01 
 	 3.422404673203483e-02  9.956925227082998e-01  8.616910611155919e-02 
 	 2.069326054226506e-02  1.303869132269597e-01  9.912472152935792e-01 
 	 1.715002919182844e-02  4.635542403260869e-01  8.859025582841624e-01 
 	 1.635753029088391e-02  7.070121750022355e-01  7.070121750022352e-01 
 	 1.664511395092919e-02  8.250189086405971e-01  5.648599300419873e-01 
 	 1.934035564781356e-02  9.743082492061556e-01  2.243866889373167e-01 
 	 2.095600914933781e-02  9.931852571610440e-01  1.146468082350473e-01 
 	 1.239613074303109e-02  1.457862438543067e-02  9.998168830609083e-01 
 	 1.205283372710135e-02  4.398033639571251e-02  9.989596884808050e-01 
 	 1.169511760596168e-02  7.755776361959546e-02  9.969192632939288e-01 
 	 1.126963852725724e-02  1.221638494197940e-01  9.924459628324370e-01 
 	 1.081612953652192e-02  1.766706192764798e-01  9.842105992247362e-01 
 	 1.036938986014951e-02  2.396295486229170e-01  9.708090209617467e-01 
 	 9.956536522736417e-03  3.092944788250786e-01  9.509141878996203e-01 
 	 9.490881694970555e-03  4.091389773807353e-01  9.124227202084011e-01 
 	 8.935935199378645e-03  6.131331291893625e-01  7.899290569111718e-01 
 	 8.883036031478060e-03  7.501021263898096e-01  6.612623470728917e-01 
 	 9.392667852524262e-03  9.004745717958045e-01  4.348072254916825e-01 
 	 1.022690442135387e-02  9.649593405997186e-01  2.622000789765571e-01 
 	 1.096812151174513e-02  9.874605344101438e-01  1.574845811276034e-01 
 	 1.194362667329510e-02  9.984753874945369e-01  5.389109712673625e-02 
 	 1.230379322578906e-02  9.996769766532069e-01  2.223868300418745e-02 
 	 5.093144845616519e-03  7.292097567202777e-03  9.999604418119008e-01 
 	 4.989913144597112e-03  2.840223626586516e-02  9.995841203930299e-01 
 	 3.769721889554568e-03  4.845588798644225e-01  8.747505250878170e-01 
 	 3.712055224362900e-03  8.439340950369458e-01  5.364340256547702e-01 
 	 4.369398704712813e-03  9.814035031421701e-01  1.919064156698151e-01 
 	 5.054384273845066e-03  9.998737536131680e-01  1.506419712848847e-02 
 	 9.688576469165123e-04  6.390328530510851e-03  9.999791122899179e-01 
 	 9.588154854268103e-04  1.704530579286927e-02  9.998542584913525e-01 
 	 9.256357465476611e-04  5.482115149295443e-02  9.984957609060998e-01 
 	 9.042536145298777e-04  8.153185937209431e-02  9.966703257510627e-01 
 	 8.809788469350819e-04  1.130781494130234e-01  9.935857064197317e-01 
 	 8.445776116935081e-04  1.686477868571093e-01  9.856760170953014e-01 
 	 7.974595157737691e-04  2.557312113871397e-01  9.667475945565041e-01 
 	 7.759030672027776e-04  3.036309385022229e-01  9.527894054609810e-01 
 	 7.562711528404570e-04  3.536309289111340e-01  9.353847305635214e-01 
 	 7.310686756513942e-04  4.311440658968614e-01  9.022828048791101e-01 
 	 7.018274634143353e-04  5.614284485800008e-01  8.275249872742605e-01 
 	 6.896350473368072e-04  6.842496135339947e-01  7.292475510977601e-01 
 	 7.388662347747754e-04  9.142797686847254e-01  4.050826565659064e-01 
 	 7.562711528403459e-04  9.353847305635216e-01  3.536309289111340e-01 
 	 7.759030672025938e-04  9.527894054609811e-01  3.036309385022227e-01 
 	 7.974595157737136e-04  9.667475945565039e-01  2.557312113871397e-01 
 	 8.567638693782301e-04  9.888225460743924e-01  1.490947293858107e-01 
 	 8.927916925772435e-04  9.953110474329945e-01  9.672187850134535e-02 
 	 9.353078942683402e-04  9.990583960777080e-01  4.337564323189436e-02 
 	 9.520096866760985e-04  9.997003043153438e-01  2.446211825180789e-02 
 	 ]; 
 

 	  
 

 	 case 11
 	 pts=[
 	 6.022837138235358e-01  5.442310096511355e-01  5.840093631073350e-01 
 	 6.397377516845922e-01  4.950609797398848e-01  5.879202627980502e-01 
 	 5.879202627980503e-01  4.950609797398848e-01  6.397377516845921e-01 
 	 5.422252556065978e-01  4.882260532360029e-01  6.838326499399947e-01 
 	 6.776832951926783e-01  4.657254996370390e-01  5.690739059249016e-01 
 	 7.068967243662071e-01  4.524095985552564e-01  5.437118503540256e-01 
 	 5.727595157475914e-01  4.473590952912182e-01  6.868889116740838e-01 
 	 4.881754003377725e-01  4.674383382866839e-01  7.370116541852233e-01 
 	 7.547751062718788e-01  4.496715614576667e-01  4.776086533643396e-01 
 	 6.536790440189317e-01  4.240242725919474e-01  6.268230401503804e-01 
 	 5.311842730229972e-01  4.151477978457511e-01  7.385767218352155e-01 
 	 4.814485412870128e-01  4.265077542439883e-01  7.657012718171214e-01 
 	 6.361271439645554e-01  3.833817194400768e-01  6.695974267503335e-01 
 	 7.800917893780134e-01  3.772982385056735e-01  4.991020330208295e-01 
 	 7.334836177747156e-01  3.665046574100105e-01  5.724300119253758e-01 
 	 6.946562054234828e-01  3.626618101916265e-01  6.212319757507502e-01 
 	 5.821657773676964e-01  3.655214003690531e-01  7.262761964529144e-01 
 	 5.075923692406792e-01  3.757367775407891e-01  7.753527330782407e-01 
 	 8.135455418132579e-01  3.625681289383396e-01  4.546295230997699e-01 
 	 4.546295230997699e-01  3.625681289383396e-01  8.135455418132579e-01 
 	 8.485578260171738e-01  3.506408169786571e-01  3.962330543676889e-01 
 	 7.125770689963355e-01  3.181039080475903e-01  6.253349697765526e-01 
 	 6.706219285903245e-01  3.170685379970508e-01  6.706219285903245e-01 
 	 4.092327101015544e-01  3.474945153965063e-01  8.436682705615307e-01 
 	 8.090935569907067e-01  3.060691189625447e-01  5.016864662850870e-01 
 	 5.016864662850871e-01  3.060691189625447e-01  8.090935569907067e-01 
 	 3.448339397362185e-01  3.365836898478907e-01  8.762425313429935e-01 
 	 8.423371223131552e-01  2.879383379870915e-01  4.555871880226926e-01 
 	 7.511961912204693e-01  2.734071666758933e-01  6.007934782486578e-01 
 	 6.806305565526402e-01  2.710794919828623e-01  6.806305565526400e-01 
 	 6.007934782486576e-01  2.734071666758933e-01  7.511961912204694e-01 
 	 8.816613597555343e-01  2.735406735356038e-01  3.845110487823603e-01 
 	 5.119182233343730e-01  2.567372402996316e-01  8.197717499777046e-01 
 	 3.845110487823603e-01  2.735406735356039e-01  8.816613597555343e-01 
 	 3.384724229845686e-01  2.821055767302922e-01  8.976930780933006e-01 
 	 9.164500699196385e-01  2.613837272694839e-01  3.029815447564452e-01 
 	 8.996721961691446e-01  2.517310218134561e-01  3.566811350449327e-01 
 	 8.557082471779569e-01  2.378812370106809e-01  4.595388044440827e-01 
 	 8.022295875297355e-01  2.298066427963174e-01  5.510141521036971e-01 
 	 7.171242619744580e-01  2.251137961302250e-01  6.595881833988754e-01 
 	 6.595881833988753e-01  2.251137961302250e-01  7.171242619744581e-01 
 	 4.595388044440827e-01  2.378812370106810e-01  8.557082471779569e-01 
 	 7.635614160586029e-01  2.035505573481454e-01  6.128141108932139e-01 
 	 6.128141108932138e-01  2.035505573481455e-01  7.635614160586032e-01 
 	 5.130472862284960e-01  2.090562981822687e-01  8.325130306991608e-01 
 	 2.892923117969725e-01  2.360924142217345e-01  9.276693000644768e-01 
 	 8.859502992661669e-01  1.930633859096568e-01  4.216854233327118e-01 
 	 8.087496218505836e-01  1.832433734803841e-01  5.588791597761240e-01 
 	 6.460113596094245e-01  1.801834636343837e-01  7.417568622455066e-01 
 	 5.588791597761238e-01  1.832433734803841e-01  8.087496218505839e-01 
 	 4.216854233327118e-01  1.930633859096569e-01  8.859502992661669e-01 
 	 9.425734750345326e-01  1.842327863344199e-01  2.785920397297478e-01 
 	 9.160818368472869e-01  1.748701087159976e-01  3.608524813218775e-01 
 	 8.400382529547934e-01  1.630173679269336e-01  5.174563472669295e-01 
 	 6.982389213402420e-01  1.578759558996574e-01  6.982389213402420e-01 
 	 4.806424757811903e-01  1.651812077466016e-01  8.612188915033749e-01 
 	 3.608524813218776e-01  1.748701087159976e-01  9.160818368472868e-01 
 	 2.673287964060709e-01  1.857200777051059e-01  9.455386651794262e-01 
 	 9.691851785812223e-01  1.721190249607824e-01  1.762246602068904e-01 
 	 8.695258426657683e-01  1.435330520808661e-01  4.725707057115761e-01 
 	 7.815767511325978e-01  1.380376809610617e-01  6.083447877017649e-01 
 	 6.083447877017648e-01  1.380376809610617e-01  7.815767511325979e-01 
 	 9.572754622856234e-01  1.374845519533570e-01  2.544045740155443e-01 
 	 9.397039148926962e-01  1.321526331711837e-01  3.154238955457605e-01 
 	 8.545846173180262e-01  1.209543300134271e-01  5.050298821796644e-01 
 	 5.050298821796644e-01  1.209543300134272e-01  8.545846173180262e-01 
 	 4.055550372622319e-01  1.259151234085703e-01  9.053565559757295e-01 
 	 3.154238955457604e-01  1.321526331711839e-01  9.397039148926962e-01 
 	 2.544045740155442e-01  1.374845519533570e-01  9.572754622856235e-01 
 	 9.807846189885346e-01  1.241664539541766e-01  1.504799749732840e-01 
 	 7.576800600348341e-01  9.805708585278113e-02  6.452175869733173e-01 
 	 7.037227707314530e-01  9.771654879340477e-02  7.037227707314530e-01 
 	 6.452175869733171e-01  9.805708585278118e-02  7.576800600348343e-01 
 	 3.753721331228397e-01  1.068331520002941e-01  9.206967140749939e-01 
 	 1.758876503396660e-01  1.215746915414760e-01  9.768741622310350e-01 
 	 1.341297807558640e-01  1.259447061961500e-01  9.829278370742937e-01 
 	 9.671039476170110e-01  9.477240688932508e-02  2.360680948285851e-01 
 	 9.415109841603501e-01  8.967339588235160e-02  3.248318777095872e-01 
 	 8.999004578292147e-01  8.524511271285948e-02  4.276826355574210e-01 
 	 4.930108162485845e-01  8.314088068105766e-02  8.660415284623957e-01 
 	 4.276826355574209e-01  8.524511271285946e-02  8.999004578292147e-01 
 	 3.248318777095870e-01  8.967339588235153e-02  9.415109841603501e-01 
 	 2.523731612520900e-01  9.373437465202931e-02  9.630792565974099e-01 
 	 9.835618398456815e-01  7.939120753505761e-02  1.621824385237304e-01 
 	 9.149097752111953e-01  6.869134227695246e-02  3.977707916868591e-01 
 	 8.135992817629192e-01  6.460836435790412e-02  5.778252053777668e-01 
 	 5.778252053777666e-01  6.460836435790412e-02  8.135992817629193e-01 
 	 2.050645547970759e-01  7.686793705416199e-02  9.757252936246525e-01 
 	 1.621824385237303e-01  7.939120753505753e-02  9.835618398456814e-01 
 	 9.935867990078644e-01  6.439861302421036e-02  9.294133352746582e-02 
 	 9.890937016944279e-01  6.220563267056740e-02  1.335069606143010e-01 
 	 9.798286003573093e-01  5.951504485525088e-02  1.907717834421895e-01 
 	 9.632782530696136e-01  5.670514770284873e-02  2.624491062799639e-01 
 	 9.369027705266707e-01  5.409122420363229e-02  3.453799907979631e-01 
 	 8.472203687543188e-01  5.025894876817795e-02  5.288588515251622e-01 
 	 7.062603302246633e-01  4.891515002429071e-02  7.062603302246634e-01 
 	 6.204738156220199e-01  4.925356145761637e-02  7.826789449136808e-01 
 	 3.674258681835742e-01  5.349654774911806e-02  9.285129782445010e-01 
 	 2.822683246668853e-01  5.602295987763702e-02  9.576982932303360e-01 
 	 8.559517226430584e-02  6.482451353041586e-02  9.942189139875527e-01 
 	 9.975780176961524e-01  4.899453331269031e-02  4.937240438632566e-02 
 	 8.778627519282760e-01  3.748008693663904e-02  4.774434331521758e-01 
 	 8.021618316972594e-01  3.630007597152634e-02  5.960022653082445e-01 
 	 6.638508087386742e-01  3.596508414763669e-02  7.469997432792475e-01 
 	 5.013805748534316e-01  3.718379908160702e-02  8.644274892930588e-01 
 	 2.517639354218274e-01  4.182441335465759e-02  9.668845015142464e-01 
 	 1.779150856972322e-01  4.398173884413820e-02  9.830624745811389e-01 
 	 1.188137286678541e-01  4.605841271697798e-02  9.918477305000168e-01 
 	 9.988221098322776e-01  3.411761213102533e-02  3.450190505862601e-02 
 	 9.960898837245135e-01  3.265285688065276e-02  8.208979521972685e-02 
 	 9.923182586487295e-01  3.163262622266198e-02  1.195987061410390e-01 
 	 9.581338714948084e-01  2.821303862111867e-02  2.849271990283362e-01 
 	 8.371562960774036e-01  2.529201362874698e-02  5.463786690424194e-01 
 	 6.176961563574115e-01  2.492173515825821e-02  7.860218607252485e-01 
 	 5.463786690424195e-01  2.529201362874704e-02  8.371562960774036e-01 
 	 4.004352338956809e-01  2.660835558834045e-02  9.159386545330400e-01 
 	 3.070983176966695e-01  2.786202747171400e-02  9.512698516683059e-01 
 	 9.899218213144523e-01  1.951748995665661e-02  1.402635208144630e-01 
 	 9.807614573348362e-01  1.875966070240435e-02  1.943065591707567e-01 
 	 9.072551988372899e-01  1.657638762434704e-02  4.202537656655050e-01 
 	 7.485795453620354e-01  1.557930131840616e-02  6.628619385935496e-01 
 	 4.698220232500838e-01  1.626714233878982e-02  8.826112658182690e-01 
 	 2.140986922610766e-01  1.850890250744678e-02  9.766366624799965e-01 
 	 1.402635208144626e-01  1.951748995665660e-02  9.899218213144525e-01 
 	 8.243693858366373e-02  2.046425205288923e-02  9.963861528267387e-01 
 	 4.305320505697739e-02  2.120424698078535e-02  9.988477368669860e-01 
 	 2.657700748978987e-02  2.154003967454282e-02  9.994146733782262e-01 
 	 9.997890842223484e-01  1.175283681795002e-02  1.684214643591608e-02 
 	 9.990595638440178e-01  1.147603633029059e-02  4.181253976915289e-02 
 	 9.972131964713100e-01  1.114997387978460e-02  7.376665144869053e-02 
 	 9.948278432437030e-01  1.089468432750812e-02  1.009894457875991e-01 
 	 9.681309342322340e-01  9.789319673394479e-03  2.502531985868597e-01 
 	 9.477052961840516e-01  9.412973704080230e-03  3.190079427079290e-01 
 	 8.557258358580400e-01  8.678938023172690e-03  5.173567143469280e-01 
 	 7.880068913432428e-01  8.488987125732674e-03  6.156078916754869e-01 
 	 6.624501206830652e-01  8.441226392482244e-03  7.490584645433114e-01 
 	 5.173567143469275e-01  8.678938023172562e-03  8.557258358580402e-01 
 	 4.168628221338977e-01  8.990618463778213e-03  9.089249453624877e-01 
 	 3.429563758390851e-01  9.297994962833445e-03  9.393053132826361e-01 
 	 2.502531985868598e-01  9.789319673394479e-03  9.681309342322337e-01 
 	 1.683204065219376e-01  1.034030568863393e-02  9.856781010180532e-01 
 	 1.326222000259885e-01  1.062143315276462e-02  9.911097503395111e-01 
 	 9.865594456512093e-01  4.236276804251939e-03  1.633478318044545e-01 
 	 9.791374138672664e-01  4.119817380844125e-03  2.031574558564611e-01 
 	 9.631983317231969e-01  3.953182382197514e-03  2.687626203821942e-01 
 	 9.312221655114270e-01  3.758265504256729e-03  3.644326465900221e-01 
 	 8.714071836729286e-01  3.574819800710594e-03  4.905473890528899e-01 
 	 5.906474414932932e-01  3.483489946702483e-03  8.069222175372407e-01 
 	 6.763909615968051e-02  4.573957674627816e-03  9.976993693402298e-01 
 	 2.698142416838794e-02  4.747313563147047e-03  9.996246624427483e-01 
 	 1.430972541294014e-02  4.805679379711611e-03  9.998860621112317e-01 
 	 9.999986968532000e-01  9.250845890332054e-04  1.323068556414316e-03 
 	 9.999811727382194e-01  9.207347139571859e-04  6.066829211525885e-03 
 	 9.998686211264607e-01  9.116608121264176e-04  1.618361397320951e-02 
 	 9.991505664940048e-01  8.903505969841234e-04  4.119894113352530e-02 
 	 9.969927646208250e-01  8.620436938050396e-04  7.748989724083009e-02 
 	 9.922579056929326e-01  8.296152636939918e-04  1.241916274488319e-01 
 	 9.836395612572530e-01  7.958477603778360e-04  1.801459967803364e-01 
 	 9.697975740716105e-01  7.630920541132335e-04  2.439099895767620e-01 
 	 8.414584494886873e-01  6.702254605054827e-04  5.403214122926523e-01 
 	 7.495369142085245e-01  6.561071540435246e-04  6.619622223074104e-01 
 	 6.619622223074101e-01  6.561071540435160e-04  7.495369142085246e-01 
 	 3.381052268221921e-01  7.239930623968350e-04  9.411080338779176e-01 
 	 2.899272433262323e-01  7.427212108550704e-04  9.570484010448241e-01 
 	 2.439099895767622e-01  7.630920541132975e-04  9.697975740716105e-01 
 	 1.801459967803362e-01  7.958477603779385e-04  9.836395612572532e-01 
 	 1.418805805493850e-01  8.183811267159847e-04  9.898834431968750e-01 
 	 1.075331101601705e-01  8.407043965993989e-04  9.942011483776300e-01 
 	 7.748989724083016e-02  8.620436938050951e-04  9.969927646208249e-01 
 	 5.207976058456422e-02  8.815535860572413e-04  9.986425393506575e-01 
 	 2.322782037910810e-02  9.055012661771684e-04  9.997297877066047e-01 
 	 1.045851328346892e-02  9.167622242784983e-04  9.999448880047959e-01 
 	 1.323068556414231e-03  9.250845890332871e-04  9.999986968532000e-01 
 	 5.808173658950335e-01  5.899827577659325e-01  5.608667693968503e-01 
 	 5.629988262228696e-01  6.370003031229784e-01  5.265576278935713e-01 
 	 6.338346269758157e-01  5.675944883905365e-01  5.254428250486570e-01 
 	 6.827444046934456e-01  5.220714298856575e-01  5.111765839286241e-01 
 	 5.848894884738959e-01  6.656458639192627e-01  4.634866450286597e-01 
 	 6.522652277277443e-01  6.010153737726529e-01  4.618772490458826e-01 
 	 5.182147080464622e-01  7.220417323573842e-01  4.583767588989077e-01 
 	 7.165594092446685e-01  5.278853628584445e-01  4.559382158831833e-01 
 	 7.356924922914873e-01  4.911026269998577e-01  4.664491039114325e-01 
 	 6.336860103420531e-01  6.471299286087435e-01  4.238689606418638e-01 
 	 5.842565100317051e-01  7.019312408922278e-01  4.073534872135862e-01 
 	 6.688617868490070e-01  6.237711180269794e-01  4.043927576113666e-01 
 	 7.388821947685253e-01  5.487220129827270e-01  3.910975002761216e-01 
 	 7.989788693975393e-01  4.328581203560791e-01  4.174525289156027e-01 
 	 4.542900663510552e-01  8.024003175770803e-01  3.870068035150732e-01 
 	 5.075923692406793e-01  7.753527330782407e-01  3.757367775407891e-01 
 	 5.627603650756178e-01  7.403929865790055e-01  3.675853600520263e-01 
 	 6.683878541397792e-01  6.499228731866337e-01  3.617429133338375e-01 
 	 7.800917893780134e-01  4.991020330208296e-01  3.772982385056735e-01 
 	 6.127742779510530e-01  7.128084099727512e-01  3.411918154846098e-01 
 	 7.606579672130395e-01  5.486642707172569e-01  3.469394398935171e-01 
 	 8.232575731808948e-01  4.325785394243023e-01  3.675904996457893e-01 
 	 4.164297862129565e-01  8.408243378030962e-01  3.458332923716514e-01 
 	 5.210723659966765e-01  7.882543792268280e-01  3.273203675672411e-01 
 	 5.902725446383759e-01  7.409806654447092e-01  3.201967777527632e-01 
 	 6.814867786667514e-01  6.595468317638564e-01  3.171336425115970e-01 
 	 8.068262260187506e-01  4.886754420995710e-01  3.320056525077982e-01 
 	 8.506297451535967e-01  3.904520449636883e-01  3.521025947697647e-01 
 	 3.514045067356361e-01  8.743006377524446e-01  3.348331935032027e-01 
 	 4.672332083054825e-01  8.276269443859670e-01  3.110092763615149e-01 
 	 7.417387817179041e-01  6.015856987083468e-01  2.965100787582603e-01 
 	 4.008775949553283e-01  8.666866607732339e-01  2.969029907235242e-01 
 	 6.677914162353830e-01  6.932063290880272e-01  2.711449975836603e-01 
 	 8.625826005364773e-01  4.109392826710305e-01  2.950934821536168e-01 
 	 8.909722201543232e-01  3.298358183098553e-01  3.120526171547748e-01 
 	 3.551533635039544e-01  8.922571304212792e-01  2.788248582967672e-01 
 	 4.977078156379516e-01  8.280317550653035e-01  2.581672768891751e-01 
 	 5.555034680875811e-01  7.920899859424386e-01  2.530006938970267e-01 
 	 7.819063128971822e-01  5.702092070908686e-01  2.519602706784081e-01 
 	 8.110273375480223e-01  5.263155331291347e-01  2.553950221456189e-01 
 	 8.816613597555343e-01  3.845110487823601e-01  2.735406735356039e-01 
 	 4.451667064284250e-01  8.628260071100390e-01  2.394950624589482e-01 
 	 6.889980216484792e-01  6.889980216484790e-01  2.248631858018642e-01 
 	 7.437147911456585e-01  6.291858445208190e-01  2.258616445654137e-01 
 	 8.628260071100390e-01  4.451667064284249e-01  2.394950624589482e-01 
 	 9.182365498059124e-01  2.963501436589909e-01  2.627132104669078e-01 
 	 3.170680444482802e-01  9.197345025758549e-01  2.314223411023411e-01 
 	 5.462349789889335e-01  8.117009234463116e-01  2.068065729259217e-01 
 	 6.454355680345689e-01  7.364556468046302e-01  2.025981436377615e-01 
 	 8.117009234463117e-01  5.462349789889333e-01  2.068065729259217e-01 
 	 9.086749103052228e-01  3.508389100275627e-01  2.263227045447869e-01 
 	 9.343681879072430e-01  2.623716361323522e-01  2.410751210311172e-01 
 	 2.454415480158545e-01  9.450400818565519e-01  2.160039124463783e-01 
 	 4.216854233327119e-01  8.859502992661668e-01  1.930633859096568e-01 
 	 5.941189964150090e-01  7.835868120076503e-01  1.816984483877331e-01 
 	 7.268129551158657e-01  6.628565668874774e-01  1.799002501662789e-01 
 	 7.835868120076507e-01  5.941189964150086e-01  1.816984483877331e-01 
 	 8.859502992661669e-01  4.216854233327117e-01  1.930633859096568e-01 
 	 9.463361356956476e-01  2.394520229940904e-01  2.170498720586274e-01 
 	 1.967058959041810e-01  9.605900527933430e-01  1.964014790957958e-01 
 	 5.360255129508348e-01  8.284998268076016e-01  1.620638344775559e-01 
 	 6.812653573524833e-01  7.147978734744846e-01  1.579288224098056e-01 
 	 8.284998268076017e-01  5.360255129508347e-01  1.620638344775559e-01 
 	 8.612188915033751e-01  4.806424757811902e-01  1.651812077466015e-01 
 	 9.392382736244994e-01  2.906032880307904e-01  1.827052115966135e-01 
 	 2.723049163627033e-01  9.488549570451693e-01  1.597632717977167e-01 
 	 3.631671177580105e-01  9.193968545426842e-01  1.510598174113750e-01 
 	 9.193968545426842e-01  3.631671177580103e-01  1.510598174113750e-01 
 	 1.718946486770140e-01  9.741657459771257e-01  1.464695501496341e-01 
 	 5.050298821796645e-01  8.545846173180262e-01  1.209543300134272e-01 
 	 5.661170106694389e-01  8.157157633955637e-01  1.188247599563791e-01 
 	 6.458028980042558e-01  7.544683045131590e-01  1.171161577850974e-01 
 	 7.202025260050809e-01  6.838661736403856e-01  1.167706216749680e-01 
 	 8.545846173180263e-01  5.050298821796644e-01  1.209543300134272e-01 
 	 8.965814195547016e-01  4.249316800573850e-01  1.247991401928889e-01 
 	 9.535909748050134e-01  2.685614704471044e-01  1.361579573940259e-01 
 	 9.659346966887918e-01  2.168065261111639e-01  1.412978838070162e-01 
 	 2.839308414062762e-01  9.522203037001106e-01  1.125156456658052e-01 
 	 7.744656131212105e-01  6.249287783777824e-01  9.832108648728446e-02 
 	 9.282438761914645e-01  3.559761255011964e-01  1.079087780776043e-01 
 	 9.471009206500356e-01  3.010068497380044e-01  1.113315881260002e-01 
 	 1.378414001837311e-01  9.851687333315350e-01  1.021876473030241e-01 
 	 2.523731612520902e-01  9.630792565974098e-01  9.373437465202937e-02 
 	 3.646839131404563e-01  9.269840040787063e-01  8.778553228620882e-02 
 	 4.492877583583008e-01  8.893827819954773e-01  8.449128522728562e-02 
 	 5.149947256623918e-01  8.532092990111039e-01  8.254892259077967e-02 
 	 6.851851435083445e-01  7.239618329343622e-01  8.000364722791152e-02 
 	 8.893827819954773e-01  4.492877583583007e-01  8.449128522728562e-02 
 	 9.788090154158189e-01  1.793696517940098e-01  9.878987476462721e-02 
 	 9.861611206941380e-01  1.300097694731114e-01  1.028771299795548e-01 
 	 1.107410176807442e-01  9.903888262662383e-01  8.286374243308106e-02 
 	 2.211708326182649e-01  9.722694380057999e-01  7.599738626314405e-02 
 	 3.337235352926972e-01  9.399998899382557e-01  7.091409526893275e-02 
 	 6.000462996741768e-01  7.973754917491442e-01  6.431767568202727e-02 
 	 8.290545579876412e-01  5.553827323415573e-01  6.495044647069825e-02 
 	 9.531979356015227e-01  2.935149477091699e-01  7.254426949303752e-02 
 	 9.722694380058000e-01  2.211708326182644e-01  7.599738626314409e-02 
 	 9.927521202996841e-01  8.516072945289369e-02  8.479904362392657e-02 
 	 1.217299736010913e-01  9.905735661857336e-01  6.281579022153275e-02 
 	 1.907717834421894e-01  9.798286003573095e-01  5.951504485525081e-02 
 	 4.821730558790231e-01  8.745901430694372e-01  5.100221397219749e-02 
 	 7.062603302246634e-01  7.062603302246633e-01  4.891515002429077e-02 
 	 8.870208964158484e-01  4.588559402507041e-01  5.143107444208349e-02 
 	 9.285129782445010e-01  3.674258681835742e-01  5.349654774911813e-02 
 	 2.517639354218276e-01  9.668845015142463e-01  4.182441335465747e-02 
 	 3.827500546243675e-01  9.230307271653544e-01  3.894447834598361e-02 
 	 5.960022653082445e-01  8.021618316972593e-01  3.630007597152640e-02 
 	 6.638508087386743e-01  7.469997432792473e-01  3.596508414763674e-02 
 	 8.021618316972595e-01  5.960022653082443e-01  3.630007597152640e-02 
 	 9.130074207766598e-01  4.061184904099108e-01  3.853856969227863e-02 
 	 9.482783233108093e-01  3.148714306390146e-01  4.030141072196531e-02 
 	 9.858439275021502e-01  1.616470667458600e-01  4.451939374693424e-02 
 	 9.943121781344216e-01  9.558579016110037e-02  4.697498411772340e-02 
 	 8.208979521972680e-02  9.960898837245136e-01  3.265285688065270e-02 
 	 1.667044896715736e-01  9.855352200775160e-01  3.049496860307209e-02 
 	 4.004352338956812e-01  9.159386545330400e-01  2.660835558834063e-02 
 	 5.221184658287120e-01  8.524928927363457e-01  2.545929053782703e-02 
 	 8.805226426708187e-01  4.732982663779458e-01  2.585781869432900e-02 
 	 9.581338714948086e-01  2.849271990283360e-01  2.821303862111873e-02 
 	 9.787491646807294e-01  2.028965688262225e-01  2.971624127174485e-02 
 	 9.904496654197822e-01  1.342838794995366e-01  3.126179739547129e-02 
 	 9.974705260685827e-01  6.284051144005903e-02  3.322077281486524e-02 
 	 6.032315145115651e-02  9.979607148079370e-01  2.086933393839200e-02 
 	 1.091755379043653e-01  9.938211142168366e-01  2.000737014447587e-02 
 	 2.346870487332281e-01  9.718994233121953e-01  1.826198571649722e-02 
 	 3.006108664217923e-01  9.535852340487916e-01  1.755871274469770e-02 
 	 7.070212823524881e-01  7.070212823524881e-01  1.555032479682733e-02 
 	 9.938211142168365e-01  1.091755379043652e-01  2.000737014447587e-02 
 	 9.995232768082639e-01  2.202529266148399e-02  2.163574823402968e-02 
 	 4.181253976915289e-02  9.990595638440176e-01  1.147603633029059e-02 
 	 8.680753182299115e-02  9.961640912323139e-01  1.102523279113034e-02 
 	 1.326222000259888e-01  9.911097503395110e-01  1.062143315276463e-02 
 	 1.875707661136325e-01  9.821981340327667e-01  1.019966676398960e-02 
 	 3.672986359410234e-01  9.300576722055456e-01  9.189037352497096e-03 
 	 4.419314419597012e-01  8.970046597919948e-01  8.901736845517920e-03 
 	 6.156078916754869e-01  7.880068913432426e-01  8.488987125732730e-03 
 	 7.689315678648447e-01  6.392750996827160e-01  8.461138609261619e-03 
 	 8.401302792249949e-01  5.423161562135265e-01  8.619781848620131e-03 
 	 8.841668126539070e-01  4.670880582421620e-01  8.820048128980372e-03 
 	 9.199375789500452e-01  3.919595474488243e-01  9.086473421636520e-03 
 	 9.477052961840516e-01  3.190079427079288e-01  9.412973704080157e-03 
 	 9.681309342322337e-01  2.502531985868598e-01  9.789319673394543e-03 
 	 9.781445281402569e-01  2.076826216431824e-01  1.006035469996354e-02 
 	 9.911097503395111e-01  1.326222000259885e-01  1.062143315276463e-02 
 	 9.961640912323139e-01  8.680753182299109e-02  1.102523279113034e-02 
 	 9.980187020878769e-01  6.190082546145995e-02  1.126756806146070e-02 
 	 9.998558695261996e-01  1.220018564391687e-02  1.180659325381509e-02 
 	 5.245209965508554e-03  9.999744881365344e-01  4.848798665002828e-03 
 	 5.561900496846289e-02  9.984413618846767e-01  4.623111959505917e-03 
 	 1.106818093924488e-01  9.938461048279856e-01  4.411007578120529e-03 
 	 2.919428395665610e-01  9.564278123317366e-01  3.901054234662166e-03 
 	 9.989842564121461e-01  4.481805687973084e-02  4.668749104104306e-03 
 	 9.996246624427485e-01  2.698142416838789e-02  4.747313563147111e-03 
 	 1.045851328346909e-02  9.999448880047958e-01  9.167622242784428e-04 
 	 2.322782037910804e-02  9.997297877066046e-01  9.055012661771043e-04 
 	 4.119894113352513e-02  9.991505664940048e-01  8.903505969841062e-04 
 	 1.418805805493850e-01  9.898834431968750e-01  8.183811267158095e-04 
 	 2.006119893128301e-01  9.796704619226163e-01  7.847166856242686e-04 
 	 2.439099895767619e-01  9.697975740716104e-01  7.630920541131607e-04 
 	 3.381052268221921e-01  9.411080338779176e-01  7.239930623968350e-04 
 	 3.878522479411510e-01  9.217212884793994e-01  7.071993154831532e-04 
 	 4.640672957183601e-01  8.857996807071302e-01  6.860785626780360e-04 
 	 5.901560926339217e-01  8.072888870436387e-01  6.627087635049174e-04 
 	 6.619622223074104e-01  7.495369142085245e-01  6.561071540435801e-04 
 	 7.696131945402132e-01  6.385100611936301e-01  6.576808609487777e-04 
 	 8.072888870436389e-01  5.901560926339214e-01  6.627087635049174e-04 
 	 8.571728809013447e-01  5.150283455780222e-01  6.749062560591039e-04 
 	 8.857996807071303e-01  4.640672957183600e-01  6.860785626780360e-04 
 	 9.318587303788465e-01  3.628206098144021e-01  7.153395204963180e-04 
 	 9.570484010448241e-01  2.899272433262322e-01  7.427212108551259e-04 
 	 9.697975740716105e-01  2.439099895767622e-01  7.630920541132975e-04 
 	 9.898834431968750e-01  1.418805805493848e-01  8.183811267158095e-04 
 	 9.942011483776300e-01  1.075331101601704e-01  8.407043965993434e-04 
 	 9.969927646208250e-01  7.748989724083009e-02  8.620436938050396e-04 
 	 9.995010336067522e-01  3.157335516174484e-02  8.983667760713934e-04 
 	 9.998686211264608e-01  1.618361397320945e-02  9.116608121262980e-04 
 	 5.457058407323250e-01  5.747564210838683e-01  6.098034042324539e-01 
 	 5.230779544178705e-01  6.245006768441428e-01  5.799899638987071e-01 
 	 5.193610748181168e-01  5.422219211097795e-01  6.604994036574072e-01 
 	 5.207084172715967e-01  6.625920633241381e-01  5.383627975653316e-01 
 	 4.946437698519118e-01  5.918171193304367e-01  6.364589839212835e-01 
 	 4.780592810327710e-01  6.342429245232497e-01  6.076143814218237e-01 
 	 4.715701339799115e-01  5.398263573881552e-01  6.972869657516939e-01 
 	 4.748454933615025e-01  7.048090853900357e-01  5.270350183677862e-01 
 	 4.620048296012856e-01  5.052344913517178e-01  7.288961833990202e-01 
 	 4.451004744160862e-01  5.911411062395293e-01  6.726349382751989e-01 
 	 4.447887312065478e-01  7.472269771886918e-01  4.937760921238690e-01 
 	 4.113871406372597e-01  5.532329792233123e-01  7.243575713817021e-01 
 	 4.039492388660167e-01  6.543430765089567e-01  6.392653210087026e-01 
 	 4.073534872135863e-01  7.019312408922279e-01  5.842565100317050e-01 
 	 4.395876225879605e-01  7.832018157006405e-01  4.397245023314995e-01 
 	 4.141613499670842e-01  4.434478466912991e-01  7.948738160603182e-01 
 	 3.923680807163070e-01  7.443716258593520e-01  5.403315388264011e-01 
 	 3.788932254386174e-01  4.908727923429803e-01  7.845277722643899e-01 
 	 3.687574729611353e-01  5.531835577104315e-01  7.469979100467063e-01 
 	 3.617429133338376e-01  6.499228731866338e-01  6.683878541397790e-01 
 	 3.626618101916266e-01  6.946562054234828e-01  6.212319757507502e-01 
 	 3.757367775407892e-01  7.753527330782408e-01  5.075923692406792e-01 
 	 3.791934700252289e-01  8.393566655843645e-01  3.894774707596360e-01 
 	 3.506408169786573e-01  3.962330543676889e-01  8.485578260171737e-01 
 	 3.320056525077984e-01  4.886754420995710e-01  8.068262260187504e-01 
 	 3.245628483241995e-01  5.436964893052424e-01  7.739851968899903e-01 
 	 3.170685379970509e-01  6.706219285903245e-01  6.706219285903245e-01 
 	 3.201967777527633e-01  7.409806654447093e-01  5.902725446383758e-01 
 	 2.965100787582604e-01  6.015856987083469e-01  7.417387817179039e-01 
 	 3.017543234717200e-01  7.868804932837796e-01  5.382967746100659e-01 
 	 3.110092763615150e-01  8.276269443859670e-01  4.672332083054826e-01 
 	 2.950934821536169e-01  4.109392826710306e-01  8.625826005364772e-01 
 	 2.713412250099699e-01  6.547200065435804e-01  7.054896545249001e-01 
 	 2.711449975836605e-01  6.932063290880274e-01  6.677914162353827e-01 
 	 3.155979538638461e-01  8.947905779081442e-01  3.158286769813073e-01 
 	 2.864120284338210e-01  3.180901969418002e-01  9.037625664841129e-01 
 	 2.553950221456190e-01  5.263155331291348e-01  8.110273375480221e-01 
 	 2.495227125052326e-01  7.486112840884241e-01  6.142634298731382e-01 
 	 2.530006938970268e-01  7.920899859424387e-01  5.555034680875811e-01 
 	 2.581672768891753e-01  8.280317550653036e-01  4.977078156379514e-01 
 	 2.770990389550270e-01  8.890690968620775e-01  3.643792853813870e-01 
 	 2.394950624589484e-01  4.451667064284250e-01  8.628260071100389e-01 
 	 2.258616445654139e-01  6.291858445208190e-01  7.437147911456585e-01 
 	 2.394950624589483e-01  8.628260071100389e-01  4.451667064284249e-01 
 	 2.659923501333446e-01  9.222142720183539e-01  2.806579878717114e-01 
 	 2.346045588926532e-01  2.978519417640438e-01  9.253350321554741e-01 
 	 2.263227045447871e-01  3.508389100275628e-01  9.086749103052227e-01 
 	 2.090562981822688e-01  5.130472862284960e-01  8.325130306991608e-01 
 	 2.025981436377617e-01  7.364556468046305e-01  6.454355680345687e-01 
 	 2.078832379838092e-01  8.223850254785837e-01  5.295917571431377e-01 
 	 2.160039124463784e-01  2.454415480158544e-01  9.450400818565519e-01 
 	 1.930633859096570e-01  4.216854233327118e-01  8.859502992661668e-01 
 	 1.816984483877331e-01  5.941189964150090e-01  7.835868120076505e-01 
 	 1.799002501662790e-01  6.628565668874775e-01  7.268129551158656e-01 
 	 1.816984483877331e-01  7.835868120076506e-01  5.941189964150086e-01 
 	 1.930633859096569e-01  8.859502992661668e-01  4.216854233327117e-01 
 	 2.027999716804276e-01  9.205773653961240e-01  3.337805953118740e-01 
 	 2.107823607222552e-01  9.373729904192336e-01  2.773133124118934e-01 
 	 1.651812077466017e-01  4.806424757811902e-01  8.612188915033749e-01 
 	 1.620638344775561e-01  5.360255129508348e-01  8.284998268076015e-01 
 	 1.579288224098057e-01  7.147978734744848e-01  6.812653573524831e-01 
 	 1.620638344775560e-01  8.284998268076016e-01  5.360255129508347e-01 
 	 1.710795221187485e-01  1.832637268986401e-01  9.680631195923339e-01 
 	 1.625795109808887e-01  2.477003928072748e-01  9.550981195732388e-01 
 	 1.510598174113753e-01  3.631671177580104e-01  9.193968545426842e-01 
 	 1.458103553180435e-01  4.347036434654856e-01  8.886912189505745e-01 
 	 1.458103553180433e-01  8.886912189505746e-01  4.347036434654856e-01 
 	 1.496768195081057e-01  9.126325536156855e-01  3.803927861866609e-01 
 	 1.625795109808885e-01  9.550981195732389e-01  2.477003928072747e-01 
 	 1.209543300134274e-01  5.050298821796645e-01  8.545846173180262e-01 
 	 1.167706216749681e-01  6.838661736403858e-01  7.202025260050807e-01 
 	 1.171161577850976e-01  7.544683045131593e-01  6.458028980042556e-01 
 	 1.209543300134273e-01  8.545846173180262e-01  5.050298821796644e-01 
 	 1.334824948121084e-01  9.448362337860454e-01  2.991102052818274e-01 
 	 1.446401508016856e-01  9.716387155896912e-01  1.870760089997671e-01 
 	 1.160889259866389e-01  2.370944534489904e-01  9.645255732260256e-01 
 	 1.113315881260004e-01  3.010068497380046e-01  9.471009206500355e-01 
 	 1.068331520002943e-01  3.753721331228398e-01  9.206967140749939e-01 
 	 9.832108648728449e-02  6.249287783777824e-01  7.744656131212104e-01 
 	 9.907110811617909e-02  8.060479583702030e-01  5.834994467382636e-01 
 	 1.149027932253264e-01  9.608991563148579e-01  2.519328472081642e-01 
 	 1.233824259978470e-01  9.797068308609678e-01  1.579598129881300e-01 
 	 1.006004167940588e-01  1.566040937565449e-01  9.825246632830917e-01 
 	 9.782220116775010e-02  1.921937636239973e-01  9.764693411381329e-01 
 	 8.449128522728577e-02  4.492877583583007e-01  8.893827819954773e-01 
 	 7.997133211289641e-02  7.048420340899403e-01  7.048420340899402e-01 
 	 8.449128522728577e-02  8.893827819954773e-01  4.492877583583007e-01 
 	 8.689571381244346e-02  9.186841677848746e-01  3.853161491326806e-01 
 	 9.066165532737022e-02  9.477919963998346e-01  3.057299393479759e-01 
 	 9.580508017378490e-02  9.706528691090668e-01  2.205774111354822e-01 
 	 1.028771299795548e-01  9.861611206941381e-01  1.300097694731114e-01 
 	 8.383088163626204e-02  9.770995589989791e-02  9.916779456063985e-01 
 	 7.512357317790588e-02  2.381160870487150e-01  9.683269994385123e-01 
 	 6.495044647069835e-02  5.553827323415574e-01  8.290545579876412e-01 
 	 6.389291149417554e-02  6.435699483799042e-01  7.627158169351707e-01 
 	 6.431767568202743e-02  7.973754917491443e-01  6.000462996741766e-01 
 	 6.534312091349005e-02  8.437241748213773e-01  5.327849410139808e-01 
 	 6.281579022153294e-02  1.217299736010912e-01  9.905735661857337e-01 
 	 5.880997764385933e-02  2.074487906912671e-01  9.764765157290058e-01 
 	 5.535753368608166e-02  3.027371821850266e-01  9.514650503233759e-01 
 	 5.349654774911827e-02  3.674258681835743e-01  9.285129782445009e-01 
 	 5.239707888261717e-02  4.126310512058978e-01  9.093899942847867e-01 
 	 5.061116076176326e-02  5.055311361224368e-01  8.613226926170616e-01 
 	 4.891515002429086e-02  7.062603302246634e-01  7.062603302246633e-01 
 	 5.189651255793909e-02  8.986181532282868e-01  4.356514279477424e-01 
 	 5.349654774911815e-02  9.285129782445010e-01  3.674258681835742e-01 
 	 5.740005698428540e-02  9.682418763725376e-01  2.433370138240140e-01 
 	 6.021299615609868e-02  9.827255082051164e-01  1.749999160482694e-01 
 	 6.220563267056747e-02  9.890937016944280e-01  1.335069606143009e-01 
 	 6.519093636181988e-02  9.947087883180541e-01  7.940131144444533e-02 
 	 4.892265314776942e-02  5.091260742258181e-02  9.975041255124798e-01 
 	 4.775919529874156e-02  7.688396349310986e-02  9.958955343920398e-01 
 	 4.398173884413840e-02  1.779150856972323e-01  9.830624745811389e-01 
 	 3.630007597152654e-02  5.960022653082445e-01  8.021618316972593e-01 
 	 3.604500604972165e-02  7.661398574678219e-01  6.416622759193977e-01 
 	 4.605841271697800e-02  9.918477305000168e-01  1.188137286678541e-01 
 	 4.879432054545516e-02  9.973652964748461e-01  5.368034715004912e-02 
 	 3.199045291511367e-02  1.059822329587062e-01  9.938532976347023e-01 
 	 2.821303862111893e-02  2.849271990283362e-01  9.581338714948086e-01 
 	 2.720241774524682e-02  3.529774053464738e-01  9.352363229599693e-01 
 	 2.585781869432914e-02  4.732982663779459e-01  8.805226426708186e-01 
 	 2.502301293010610e-02  8.039004575929762e-01  5.942372447984923e-01 
 	 2.545929053782711e-02  8.524928927363459e-01  5.221184658287117e-01 
 	 2.660835558834054e-02  9.159386545330400e-01  4.004352338956809e-01 
 	 2.752465671526939e-02  9.436478151370203e-01  3.298047820451280e-01 
 	 2.821303862111874e-02  9.581338714948086e-01  2.849271990283360e-01 
 	 2.932984904102436e-02  9.745409621897870e-01  2.222828670173093e-01 
 	 3.049496860307210e-02  9.855352200775160e-01  1.667044896715734e-01 
 	 3.411761213102545e-02  9.988221098322777e-01  3.450190505862577e-02 
 	 2.120424698078559e-02  4.305320505697733e-02  9.988477368669859e-01 
 	 1.850890250744693e-02  2.140986922610768e-01  9.766366624799965e-01 
 	 1.657638762434730e-02  4.202537656655050e-01  9.072551988372898e-01 
 	 1.555757092073664e-02  7.281504031457364e-01  6.852407988333354e-01 
 	 1.626714233878996e-02  8.826112658182690e-01  4.698220232500838e-01 
 	 1.875966070240430e-02  9.807614573348363e-01  1.943065591707565e-01 
 	 1.976539958741389e-02  9.920609117735232e-01  1.241953151702420e-01 
 	 2.067444306825407e-02  9.972771803439843e-01  7.078695479373054e-02 
 	 1.170372337022653e-02  2.114018542134466e-02  9.997080150822161e-01 
 	 1.126756806146084e-02  6.190082546146006e-02  9.980187020878769e-01 
 	 1.102523279113059e-02  8.680753182299114e-02  9.961640912323139e-01 
 	 1.048125963117950e-02  1.499868999944506e-01  9.886324256398829e-01 
 	 1.006035469996367e-02  2.076826216431825e-01  9.781445281402568e-01 
 	 9.533537392631223e-03  2.955270360475866e-01  9.552868064773593e-01 
 	 9.189037352497180e-03  3.672986359410234e-01  9.300576722055455e-01 
 	 8.619781848620394e-03  5.423161562135266e-01  8.401302792249949e-01 
 	 8.461138609261711e-03  6.392750996827162e-01  7.689315678648445e-01 
 	 8.461138609261711e-03  7.689315678648447e-01  6.392750996827160e-01 
 	 8.990618463778242e-03  9.089249453624877e-01  4.168628221338977e-01 
 	 9.412973704080240e-03  9.477052961840515e-01  3.190079427079288e-01 
 	 1.048125963117944e-02  9.886324256398830e-01  1.499868999944504e-01 
 	 1.089468432750812e-02  9.948278432437030e-01  1.009894457875988e-01 
 	 1.164062359975202e-02  9.995745351250422e-01  2.674405750376348e-02 
 	 1.180659325381509e-02  9.998558695261998e-01  1.220018564391680e-02 
 	 4.411007578120839e-03  1.106818093924488e-01  9.938461048279856e-01 
 	 3.851059459363449e-03  9.488634356197597e-01  3.156633489730894e-01 
 	 4.062853628271009e-03  9.745109725207527e-01  2.243030487020896e-01 
 	 4.668749104104308e-03  9.989842564121458e-01  4.481805687973082e-02 
 	 4.779241657305713e-03  9.997887401389242e-01  1.999084642040034e-02 
 	 4.826263056605617e-03  9.999388303473417e-01  9.952022332114063e-03 
 	 9.207347139573614e-04  6.066829211525885e-03  9.999811727382194e-01 
 	 9.116608121265297e-04  1.618361397320945e-02  9.998686211264607e-01 
 	 8.983667760715065e-04  3.157335516174478e-02  9.995010336067521e-01 
 	 8.815535860573729e-04  5.207976058456433e-02  9.986425393506575e-01 
 	 8.515486931315134e-04  9.195155852016865e-02  9.957631172877087e-01 
 	 8.296152636942941e-04  1.241916274488320e-01  9.922579056929327e-01 
 	 7.958477603781968e-04  1.801459967803364e-01  9.836395612572530e-01 
 	 7.527231488681202e-04  2.666127291595650e-01  9.638034478346451e-01 
 	 7.239930623969725e-04  3.381052268221921e-01  9.411080338779175e-01 
 	 6.995963848175556e-04  4.131227069003241e-01  9.106751010147621e-01 
 	 6.801934937183743e-04  4.895847097611128e-01  8.719554743821143e-01 
 	 6.627087635051267e-04  5.901560926339217e-01  8.072888870436387e-01 
 	 6.551623933900852e-04  7.286864279138594e-01  6.848471804252232e-01 
 	 6.598821028431223e-04  7.888753963425221e-01  6.145528240932906e-01 
 	 6.749062560591364e-04  8.571728809013447e-01  5.150283455780224e-01 
 	 6.925506584819500e-04  8.987046403367875e-01  4.385538619265720e-01 
 	 7.630920541133754e-04  9.697975740716105e-01  2.439099895767622e-01 
 	 7.847166856242802e-04  9.796704619226163e-01  2.006119893128299e-01 
 	 8.296152636940463e-04  9.922579056929326e-01  1.241916274488316e-01 
 	 8.515486931313383e-04  9.957631172877088e-01  9.195155852016858e-02 
 	 8.720817197043840e-04  9.979374805549089e-01  6.418741603457040e-02 
 	 ]; 
 

 	  
 

 	 case 12
 	 pts=[
 	 6.012921830864808e-01  5.558397304447540e-01  5.740121119089712e-01 
 	 5.693042405036263e-01  5.153460796072156e-01  6.405553059479427e-01 
 	 6.759001520626862e-01  5.127283780396021e-01  5.294039996019263e-01 
 	 6.237076920996828e-01  4.977096465152069e-01  6.027220110311179e-01 
 	 5.389301218049066e-01  4.939227089570171e-01  6.823449870761199e-01 
 	 5.808785990456655e-01  4.693408994327786e-01  6.650557670529407e-01 
 	 7.172846900681300e-01  4.646513323666012e-01  5.192319450147582e-01 
 	 6.426909197660654e-01  4.492209606991804e-01  6.206036658921331e-01 
 	 4.791025873865454e-01  4.778372922206844e-01  7.362962942475821e-01 
 	 6.789768199185809e-01  4.331446313730910e-01  5.927699438449289e-01 
 	 7.615953745943022e-01  4.355820348667271e-01  4.798341133120134e-01 
 	 5.860160321315890e-01  4.149532069351362e-01  6.959878203955832e-01 
 	 5.363770741105349e-01  4.222151370486064e-01  7.307763080557882e-01 
 	 7.900061081680431e-01  4.245171053975302e-01  4.423523214385615e-01 
 	 7.461650846345189e-01  4.029769526668294e-01  5.299502260511992e-01 
 	 6.346785639294341e-01  3.920393941398568e-01  6.659491226294431e-01 
 	 4.295446685187326e-01  4.288151219342388e-01  7.947383021772991e-01 
 	 4.705302895488567e-01  3.935301844205157e-01  7.897691058575437e-01 
 	 7.234397374495889e-01  3.527688417451900e-01  5.934552136198882e-01 
 	 5.834175531229147e-01  3.536245467102633e-01  7.311454292218695e-01 
 	 5.438397481405005e-01  3.580045392591031e-01  7.589934638798640e-01 
 	 8.333914588559667e-01  3.571449540177652e-01  4.217892342456977e-01 
 	 7.914524821613881e-01  3.407004382611323e-01  5.074703733709486e-01 
 	 6.978624374456566e-01  3.286648617728093e-01  6.363705108176112e-01 
 	 4.438714877580366e-01  3.521900767589245e-01  8.239783080809895e-01 
 	 8.174808189940119e-01  3.219542386763538e-01  4.775673552235422e-01 
 	 6.732015615719158e-01  3.059400513078798e-01  6.732015615719158e-01 
 	 6.155481578472823e-01  3.074819543285666e-01  7.256413116224175e-01 
 	 5.213400991780486e-01  3.157882046880638e-01  7.927687624830535e-01 
 	 3.743631859037092e-01  3.430505632114799e-01  8.614920290521041e-01 
 	 8.762745227795221e-01  3.197205659530921e-01  3.604465569736452e-01 
 	 8.475636122958153e-01  3.047910884243998e-01  4.344402324015797e-01 
 	 7.903775868415973e-01  2.907264943585243e-01  5.392414818024077e-01 
 	 7.446146466774652e-01  2.857200135563857e-01  6.032521046848757e-01 
 	 4.147623780570263e-01  3.083108318709968e-01  8.561054845633770e-01 
 	 8.397187599168457e-01  2.753539704070534e-01  4.680305494567490e-01 
 	 7.075690204024804e-01  2.611763909412078e-01  6.566071688472490e-01 
 	 6.161798388789995e-01  2.624644249534193e-01  7.425865820178285e-01 
 	 3.711207441125650e-01  2.909096910402070e-01  8.818395233534428e-01 
 	 9.066563028040598e-01  2.742710417216679e-01  3.205460095814393e-01 
 	 7.837975411019990e-01  2.421691846488039e-01  5.718526913191839e-01 
 	 6.867248261112435e-01  2.383653213136604e-01  6.867248261112435e-01 
 	 5.424056876921024e-01  2.442358210741653e-01  8.038314087316356e-01 
 	 4.848755777733830e-01  2.494816612426054e-01  8.382449372245311e-01 
 	 4.187243797738432e-01  2.575668024302961e-01  8.708210126477445e-01 
 	 3.357285859211995e-01  2.712638493185239e-01  9.020544554782981e-01 
 	 8.984628105804029e-01  2.397873521497948e-01  3.677860842296148e-01 
 	 8.777901064088740e-01  2.329738213191540e-01  4.185782216869967e-01 
 	 8.138259868981473e-01  2.216462936666150e-01  5.371779812623647e-01 
 	 7.184596352654203e-01  2.161895874189893e-01  6.611186087124507e-01 
 	 9.187431186195955e-01  2.201075476039506e-01  3.278166400244421e-01 
 	 8.605657809595433e-01  2.041924483881173e-01  4.666175957491932e-01 
 	 6.469266230427179e-01  1.943513374287652e-01  7.373693118364743e-01 
 	 5.649138269805546e-01  1.973714363547603e-01  8.011971568830251e-01 
 	 4.057232695334060e-01  2.101906339772727e-01  8.894990308861248e-01 
 	 9.476492880571401e-01  2.069927134430135e-01  2.431354425547496e-01 
 	 8.936429514800993e-01  1.861699112102939e-01  4.083418169008509e-01 
 	 8.317681750819128e-01  1.773335696797196e-01  5.260366032754302e-01 
 	 7.838694647293202e-01  1.740807007934932e-01  5.960239692128291e-01 
 	 7.423060905283035e-01  1.726720095950837e-01  6.474303399339432e-01 
 	 6.965442956685051e-01  1.721978174755189e-01  6.965442956685052e-01 
 	 4.741679818298307e-01  1.806975011245889e-01  8.616920204427767e-01 
 	 2.874363572528513e-01  2.002408571190953e-01  9.366343681871925e-01 
 	 9.467894708246950e-01  1.774305916385367e-01  2.685294827133379e-01 
 	 9.033235150718323e-01  1.641797595450841e-01  3.962974055857391e-01 
 	 5.937401653076706e-01  1.529081981704354e-01  7.899947462057523e-01 
 	 5.202438506397652e-01  1.559307883113270e-01  8.396617921092503e-01 
 	 3.484970852896456e-01  1.685042947216160e-01  9.220390903887927e-01 
 	 2.084351249379176e-01  1.858186030410787e-01  9.602219771781818e-01 
 	 9.705565313273458e-01  1.643647071999813e-01  1.760802729578059e-01 
 	 9.189336015718857e-01  1.441157273718041e-01  3.671398820970264e-01 
 	 8.580476589382077e-01  1.361358121245885e-01  4.951981983487418e-01 
 	 7.661843995329409e-01  1.316093505975059e-01  6.289995586227780e-01 
 	 6.475056219396931e-01  1.312991061501515e-01  7.506643819182195e-01 
 	 5.721494000408056e-01  1.330581558620554e-01  8.092839990952095e-01 
 	 4.951981983487417e-01  1.361358121245887e-01  8.580476589382078e-01 
 	 4.201335722404372e-01  1.403605898180320e-01  8.965415139871793e-01 
 	 3.341296190549458e-01  1.468083975576839e-01  9.310234648368115e-01 
 	 2.621882143225243e-01  1.537410708730224e-01  9.526914628552007e-01 
 	 9.685920565595475e-01  1.357678183403849e-01  2.083183320613879e-01 
 	 8.857606465002424e-01  1.180363417377052e-01  4.488825003724831e-01 
 	 7.026923045003225e-01  1.115663497298904e-01  7.026923045003225e-01 
 	 2.083183320613878e-01  1.357678183403850e-01  9.685920565595474e-01 
 	 1.590689486533251e-01  1.413120831755927e-01  9.771018190152448e-01 
 	 9.843300840796775e-01  1.207065417320263e-01  1.285465532746390e-01 
 	 9.770680849472926e-01  1.157119963841396e-01  1.787419684076100e-01 
 	 9.459390784869040e-01  1.059119572939868e-01  3.065647029478500e-01 
 	 8.193612157392018e-01  9.500883835085401e-02  5.653499082670823e-01 
 	 7.570791065420147e-01  9.363402460109160e-02  6.465786076530423e-01 
 	 6.266653101583691e-01  9.387617871937942e-02  7.736135030576717e-01 
 	 4.204765521911143e-01  9.985240787207861e-02  9.017920856270703e-01 
 	 3.065647029478498e-01  1.059119572939869e-01  9.459390784869041e-01 
 	 1.687175049967300e-01  1.166494447723189e-01  9.787376106710052e-01 
 	 9.165824017478844e-01  8.267488425847097e-02  3.912052713332583e-01 
 	 8.871904820335754e-01  8.046119120917561e-02  4.543336277431296e-01 
 	 5.619793198350727e-01  7.775460894758389e-02  8.234885942532035e-01 
 	 2.758294867905226e-01  8.806305556685960e-02  9.571640363391769e-01 
 	 2.264691769677675e-01  9.098855370699724e-02  9.697591427657957e-01 
 	 9.918701715787109e-01  7.976988306562742e-02  9.914801303160119e-02 
 	 9.828942604081283e-01  7.531528944471873e-02  1.680668915420782e-01 
 	 9.668236632978225e-01  7.127031785595435e-02  2.453009292279380e-01 
 	 9.448124135959649e-01  6.810238300912971e-02  3.204552520141386e-01 
 	 8.415406689504027e-01  6.224798197293892e-02  5.365952769479110e-01 
 	 7.791182125771297e-01  6.109359145414802e-02  6.238929266419457e-01 
 	 7.058027059112258e-01  6.070486518215145e-02  7.058027059112260e-01 
 	 6.450138277979068e-01  6.092375280551324e-02  7.617384448047668e-01 
 	 4.039984993623814e-01  6.531468503503726e-02  9.124249034477948e-01 
 	 3.406963938128637e-01  6.736068433015098e-02  9.377571676342890e-01 
 	 1.680668915420781e-01  7.531528944471871e-02  9.828942604081283e-01 
 	 1.137510915865053e-01  7.874899127078022e-02  9.903834033023338e-01 
 	 9.884071223950092e-01  5.894745629776130e-02  1.399162527901635e-01 
 	 9.709082760480028e-01  5.506092650042311e-02  2.330352202445160e-01 
 	 9.612122844391747e-01  5.376133552668806e-02  2.705192470890193e-01 
 	 9.258165178691995e-01  5.080515195957987e-02  3.745432041499543e-01 
 	 8.719128234101500e-01  4.852370884648011e-02  4.872509395093279e-01 
 	 5.781887586002260e-01  4.731295938055737e-02  8.145300751371820e-01 
 	 4.872509395093277e-01  4.852370884648011e-02  8.719128234101501e-01 
 	 2.705192470890190e-01  5.376133552668817e-02  9.612122844391748e-01 
 	 1.985419898742044e-01  5.638343784364519e-02  9.784692055418623e-01 
 	 9.956230163419741e-01  4.527384175321648e-02  8.176239100597432e-02 
 	 9.925654938645361e-01  4.405216488845749e-02  1.134598922883757e-01 
 	 9.815664634655152e-01  4.162203506692896e-02  1.865338682295754e-01 
 	 9.455734903811953e-01  3.821351300858351e-02  3.231570851952134e-01 
 	 8.991420550064683e-01  3.625393428716982e-02  4.361527452251639e-01 
 	 8.325550348072583e-01  3.490828458290579e-02  5.528413205292851e-01 
 	 7.649069290622992e-01  3.433044435396123e-02  6.432253185804664e-01 
 	 7.066931383341771e-01  3.419965588691062e-02  7.066931383341772e-01 
 	 6.432253185804663e-01  3.433044435396117e-02  7.649069290622992e-01 
 	 5.296150070162208e-01  3.512340566992188e-02  8.475106434242313e-01 
 	 3.900381923581960e-01  3.697134983380138e-02  9.200561546956890e-01 
 	 1.700472519945062e-01  4.212769315300181e-02  9.845350118501238e-01 
 	 1.261310800181156e-01  4.359410590652674e-02  9.910552479976453e-01 
 	 1.018242947923924e-01  4.448767200359089e-02  9.938071543462207e-01 
 	 7.337986324498766e-02  4.561621558765423e-02  9.962602855406852e-01 
 	 9.892540238790571e-01  2.955202583722152e-02  1.431892244828847e-01 
 	 9.723607518227481e-01  2.774838668923656e-02  2.318288061282395e-01 
 	 9.554200926099309e-01  2.672064204736995e-02  2.940381844689690e-01 
 	 9.228616801433871e-01  2.551732800991658e-02  3.842852915402292e-01 
 	 8.497149949460620e-01  2.420979371212956e-02  5.266861620094362e-01 
 	 4.790177468539511e-01  2.457186562984802e-02  8.774612365332344e-01 
 	 3.383304221075995e-01  2.609053341463009e-02  9.406656204744774e-01 
 	 2.318288061282393e-01  2.774838668923655e-02  9.723607518227481e-01 
 	 1.591784609411552e-01  2.919333038307508e-02  9.868181023033321e-01 
 	 3.440251990705356e-02  3.247578465710364e-02  9.988802681177309e-01 
 	 9.989541666359099e-01  2.021662146779226e-02  4.101050081604331e-02 
 	 9.967179157923891e-01  1.954019270243394e-02  7.855938650236387e-02 
 	 9.943851830192842e-01  1.912033407704704e-02  1.040793957346351e-01 
 	 9.824796021979605e-01  1.796394843542446e-02  1.855023660807236e-01 
 	 8.794180668406802e-01  1.545108717875606e-02  4.757994615583285e-01 
 	 7.476197730626233e-01  1.482744469943830e-02  6.639614610875219e-01 
 	 5.482534615366182e-01  1.512142938847389e-02  8.361755104560079e-01 
 	 2.044747123624868e-01  1.772957533814042e-02  9.787112721137974e-01 
 	 1.184251922812885e-01  1.889723851299253e-02  9.927831425894191e-01 
 	 7.855938650236370e-02  1.954019270243387e-02  9.967179157923891e-01 
 	 2.531465229822862e-02  2.052218428340159e-02  9.994688631124323e-01 
 	 9.997354261746467e-01  1.114618558946781e-02  2.012064109819736e-02 
 	 9.996144878379928e-01  1.108888502566760e-02  2.545412212736679e-02 
 	 9.953070784917365e-01  1.040715449251483e-02  9.620556449402168e-02 
 	 9.896719360137395e-01  1.002553646583957e-02  1.429998170816618e-01 
 	 9.758401445967774e-01  9.505386342915999e-03  2.182788579405082e-01 
 	 9.654218831364461e-01  9.256682021443237e-03  2.605281201698433e-01 
 	 9.266891994554044e-01  8.709433790570889e-03  3.757276585184398e-01 
 	 8.040560083902869e-01  8.107121074677646e-03  5.944982842358414e-01 
 	 6.410048098259069e-01  8.049547908129506e-03  7.674946505080850e-01 
 	 4.487190170391734e-01  8.448660572015773e-03  8.936329581444146e-01 
 	 3.283333177805759e-01  8.913131792763941e-03  9.445198719544466e-01 
 	 2.605281201698430e-01  9.256682021443164e-03  9.654218831364461e-01 
 	 1.605327332385724e-01  9.894731184497321e-03  9.869809197009535e-01 
 	 4.877899058412563e-02  1.084860189655780e-02  9.987506785552057e-01 
 	 9.998088625475082e-01  4.550826212507054e-03  1.901389892266134e-02 
 	 9.985888651711172e-01  4.408746209403866e-03  5.292297528598652e-02 
 	 8.946661249509171e-01  3.453208168486455e-03  4.467220614863958e-01 
 	 8.381603979593563e-01  3.347658964270754e-03  5.454135499527606e-01 
 	 4.962356729323467e-01  3.394778091020587e-03  8.681812209389775e-01 
 	 1.938187451446677e-01  3.944261930833754e-03  9.810294270960312e-01 
 	 1.054100718168391e-01  4.214297253661269e-03  9.944199095242545e-01 
 	 7.695787440834709e-02  4.316125411247440e-03  9.970250030104478e-01 
 	 3.354549645028861e-02  4.488214215020829e-03  9.994271137011761e-01 
 	 1.901389892266141e-02  4.550826212507110e-03  9.998088625475082e-01 
 	 6.590994281356431e-03  4.606527704627518e-03  9.999676688257925e-01 
 	 9.999988211328321e-01  8.800378738532724e-04  1.258279097309583e-03 
 	 9.999829853990885e-01  8.761029026261908e-04  5.767265905993696e-03 
 	 9.998812590881636e-01  8.678837501558822e-04  1.538552898227828e-02 
 	 9.987718963321305e-01  8.405055992297024e-04  4.953779009460906e-02 
 	 9.981333544145209e-01  8.318571264297909e-04  6.106647868460839e-02 
 	 9.908224466715020e-01  7.824785960570941e-04  1.351675512064391e-01 
 	 9.851402328952036e-01  7.615646899020402e-04  1.717502301320357e-01 
 	 9.725112289748179e-01  7.309182510586744e-04  2.328548373480777e-01 
 	 9.539237787984571e-01  7.025705072821667e-04  3.000482138549646e-01 
 	 9.071650008283345e-01  6.634164914516375e-04  4.207745490766840e-01 
 	 8.540892712178670e-01  6.410657825419639e-04  5.201260480164354e-01 
 	 8.050235493760093e-01  6.300341736893422e-04  5.932425203970059e-01 
 	 7.485073511273352e-01  6.240654063866106e-04  6.631261990380931e-01 
 	 6.631261990380928e-01  6.240654063866106e-04  7.485073511273355e-01 
 	 6.169813729308889e-01  6.274783509565876e-04  7.869775039524538e-01 
 	 5.447480628903686e-01  6.368317907608544e-04  8.385995125341187e-01 
 	 4.455984441748835e-01  6.570348434476579e-04  8.952327043032653e-01 
 	 3.960808316295385e-01  6.703067154603416e-04  9.182154025633421e-01 
 	 2.770778118969893e-01  7.116829857749548e-04  9.608472197293930e-01 
 	 2.328548373480775e-01  7.309182510587127e-04  9.725112289748178e-01 
 	 1.717502301320355e-01  7.615646899019675e-04  9.851402328952036e-01 
 	 8.752173742520583e-02  8.130483124641056e-04  9.961622781607999e-01 
 	 4.953779009460890e-02  8.405055992297493e-04  9.987718963321306e-01 
 	 3.002273741754372e-02  8.558153287751162e-04  9.995488496407168e-01 
 	 9.942176499288627e-03  8.725064127581377e-04  9.999501946892239e-01 
 	 1.258279097309301e-03  8.800378738532122e-04  9.999988211328321e-01 
 	 5.704536755350772e-01  5.970221076907175e-01  5.640453944471615e-01 
 	 5.646149579251765e-01  6.337030293891408e-01  5.288009264649380e-01 
 	 6.405553059479429e-01  5.693042405036263e-01  5.153460796072156e-01 
 	 5.492553958670341e-01  6.760378817781842e-01  4.912141004814639e-01 
 	 6.275561370121998e-01  6.110012521194332e-01  4.825461271285989e-01 
 	 6.803727149515063e-01  5.422480608507886e-01  4.930111654446336e-01 
 	 5.861567419283262e-01  6.725497023758125e-01  4.517711497275756e-01 
 	 6.854791041615158e-01  5.691631982401134e-01  4.540612860914385e-01 
 	 7.355767510815988e-01  4.808975086895214e-01  4.771419384255079e-01 
 	 4.923047414380547e-01  7.433272755266123e-01  4.528803407256645e-01 
 	 7.225764997171494e-01  5.307497455425104e-01  4.429310439143692e-01 
 	 4.476421661245943e-01  7.750305520214533e-01  4.460315398495969e-01 
 	 5.363770741105349e-01  7.307763080557882e-01  4.222151370486064e-01 
 	 6.372939729727900e-01  6.513675194522295e-01  4.117969725668298e-01 
 	 6.102187923402639e-01  6.877828792164189e-01  3.931764699617246e-01 
 	 7.461650846345190e-01  5.299502260511990e-01  4.029769526668294e-01 
 	 7.749887933574992e-01  4.770874509064084e-01  4.144634294577905e-01 
 	 4.290052130376980e-01  8.075869764310746e-01  4.046699923213906e-01 
 	 5.575463039325331e-01  7.392017817754419e-01  3.777867715936906e-01 
 	 7.051464796235423e-01  6.028940372248480e-01  3.732120337733618e-01 
 	 5.064132276339243e-01  7.818737762959644e-01  3.636193625456149e-01 
 	 6.034973906054936e-01  7.154536544391750e-01  3.520184198049727e-01 
 	 7.868150008818920e-01  4.975746243035278e-01  3.651597563210263e-01 
 	 7.424837195247035e-01  5.818348336990536e-01  3.319429959121838e-01 
 	 8.383662253679575e-01  4.091054056225417e-01  3.602427504512741e-01 
 	 3.498875383150676e-01  8.690770833176077e-01  3.496909117835090e-01 
 	 4.477149098352157e-01  8.322210445759129e-01  3.270466212579193e-01 
 	 5.213400991780486e-01  7.927687624830534e-01  3.157882046880638e-01 
 	 6.732015615719159e-01  6.732015615719157e-01  3.059400513078798e-01 
 	 7.703085719759715e-01  5.561687932861251e-01  3.119310457697262e-01 
 	 8.322210445759132e-01  4.477149098352154e-01  3.270466212579193e-01 
 	 4.055650790884576e-01  8.598712013875748e-01  3.100620641875785e-01 
 	 5.647189576835246e-01  7.732471285685273e-01  2.884118184009822e-01 
 	 7.236974704118619e-01  6.287488199146825e-01  2.844940997197768e-01 
 	 7.545379378658734e-01  5.904118579212976e-01  2.865071348972602e-01 
 	 8.664608503624999e-01  3.885483406630484e-01  3.134896836533628e-01 
 	 3.711207441125650e-01  8.818395233534428e-01  2.909096910402069e-01 
 	 4.936239341262451e-01  8.259679422777325e-01  2.722358719699092e-01 
 	 8.259679422777326e-01  4.936239341262450e-01  2.722358719699092e-01 
 	 8.874456297701617e-01  3.548159481791558e-01  2.941868404935333e-01 
 	 5.424056876921025e-01  8.038314087316355e-01  2.442358210741653e-01 
 	 6.304915655019523e-01  7.383771108252876e-01  2.393316277473548e-01 
 	 6.867248261112436e-01  6.867248261112435e-01  2.383653213136605e-01 
 	 7.503672337168001e-01  6.159635172131667e-01  2.398707152333981e-01 
 	 7.837975411019991e-01  5.718526913191838e-01  2.421691846488039e-01 
 	 8.526284165055921e-01  4.574257902378131e-01  2.525597548947156e-01 
 	 8.760283029948777e-01  4.066162482439448e-01  2.593022156016672e-01 
 	 3.000493254007605e-01  9.202876212267543e-01  2.510798608876274e-01 
 	 4.323763347636062e-01  8.715118490346411e-01  2.313391495804613e-01 
 	 8.235805057938234e-01  5.216111669144653e-01  2.227934941296983e-01 
 	 9.202876212267544e-01  3.000493254007603e-01  2.510798608876275e-01 
 	 3.914700516362162e-01  8.954827604262814e-01  2.118061010718661e-01 
 	 4.988138802341843e-01  8.429414595255382e-01  2.015797824650879e-01 
 	 5.482914046300800e-01  8.124406737299401e-01  1.982843596404288e-01 
 	 5.980744709388099e-01  7.771429008155252e-01  1.958464677324903e-01 
 	 7.086405826531696e-01  6.784024235926248e-01  1.939037809859033e-01 
 	 8.011971568830252e-01  5.649138269805546e-01  1.973714363547603e-01 
 	 8.605657809595434e-01  4.666175957491930e-01  2.041924483881173e-01 
 	 9.378426769915745e-01  2.585944996306129e-01  2.314735362283777e-01 
 	 2.675095955016857e-01  9.418952263239558e-01  2.031551105502111e-01 
 	 3.630591215277978e-01  9.120260890979511e-01  1.907786337097523e-01 
 	 4.243007812246553e-01  8.864814711370544e-01  1.847145050688516e-01 
 	 6.641125555543524e-01  7.274817533070983e-01  1.724088517457771e-01 
 	 9.063976487853276e-01  3.776806823470698e-01  1.892104766081456e-01 
 	 9.218850161187185e-01  3.354190869844010e-01  1.939640511598499e-01 
 	 2.380251446269470e-01  9.541526266161232e-01  1.814849736117947e-01 
 	 5.019137317371651e-01  8.505676986800234e-01  1.568986802233909e-01 
 	 5.937401653076706e-01  7.899947462057522e-01  1.529081981704355e-01 
 	 7.312789171573481e-01  6.650729359459379e-01  1.513576400233131e-01 
 	 8.160218755171909e-01  5.570611758833225e-01  1.542437843185142e-01 
 	 8.505676986800235e-01  5.019137317371649e-01  1.568986802233909e-01 
 	 9.541526266161233e-01  2.380251446269468e-01  1.814849736117948e-01 
 	 9.612041226498401e-01  2.031013251688810e-01  1.866453490328533e-01 
 	 2.177117060526452e-01  9.629964157936700e-01  1.588694942907279e-01 
 	 2.752204731438382e-01  9.492300982818465e-01  1.523676858074509e-01 
 	 3.503722425839029e-01  9.252481860752090e-01  1.454478799820129e-01 
 	 4.201335722404374e-01  8.965415139871792e-01  1.403605898180320e-01 
 	 6.475056219396931e-01  7.506643819182195e-01  1.312991061501514e-01 
 	 7.811426811414700e-01  6.102379282292421e-01  1.320067522878967e-01 
 	 8.686293546865897e-01  4.761180878548278e-01  1.370934374586223e-01 
 	 9.045993875165615e-01  4.020685874048517e-01  1.415655294445958e-01 
 	 9.362834259183002e-01  3.184544958024235e-01  1.481893398794771e-01 
 	 9.608977200318332e-01  2.276356906182078e-01  1.576628174123388e-01 
 	 1.796390597961940e-01  9.738780542236766e-01  1.388932816843390e-01 
 	 5.286580605252271e-01  8.410449840574368e-01  1.147344317697662e-01 
 	 7.203416794696156e-01  6.845815749105899e-01  1.116061472851291e-01 
 	 8.410449840574369e-01  5.286580605252271e-01  1.147344317697662e-01 
 	 9.723759916644062e-01  1.883175089355970e-01  1.379182608031065e-01 
 	 2.276826367165249e-01  9.673285326462515e-01  1.115173836953716e-01 
 	 3.426512468079562e-01  9.337157506704096e-01  1.037546144079701e-01 
 	 5.028581895245194e-01  8.589396012560241e-01  9.672849953485742e-02 
 	 5.445722547651437e-01  8.332570139379943e-01  9.551862678632160e-02 
 	 6.266653101583693e-01  7.736135030576715e-01  9.387617871937942e-02 
 	 6.853041947366695e-01  7.222483823347821e-01  9.335649356694722e-02 
 	 7.570791065420147e-01  6.465786076530423e-01  9.363402460109166e-02 
 	 8.589396012560241e-01  5.028581895245193e-01  9.672849953485742e-02 
 	 9.107620753976794e-01  4.004485038828438e-01  1.007642682467546e-01 
 	 9.459390784869041e-01  3.065647029478497e-01  1.059119572939869e-01 
 	 9.639756098707375e-01  2.419971773147173e-01  1.104010405116243e-01 
 	 1.009705687044377e-01  9.897867198458425e-01  1.006339578487793e-01 
 	 1.605023859770985e-01  9.823936850809826e-01  9.561188006030184e-02 
 	 1.974656114408578e-01  9.758968220551906e-01  9.291245880326197e-02 
 	 8.234885942532036e-01  5.619793198350727e-01  7.775460894758390e-02 
 	 8.871904820335754e-01  4.543336277431295e-01  8.046119120917561e-02 
 	 9.823936850809827e-01  1.605023859770984e-01  9.561188006030195e-02 
 	 8.525021163326088e-02  9.930792216946338e-01  8.078403836689997e-02 
 	 1.680668915420782e-01  9.828942604081284e-01  7.531528944471878e-02 
 	 2.453009292279381e-01  9.668236632978227e-01  7.127031785595440e-02 
 	 2.816094187289383e-01  9.569975831188841e-01  6.965458482945619e-02 
 	 4.477353216612469e-01  8.918636467918691e-01  6.412735194913399e-02 
 	 7.058027059112260e-01  7.058027059112257e-01  6.070486518215145e-02 
 	 7.791182125771298e-01  6.238929266419455e-01  6.109359145414790e-02 
 	 8.552775324528129e-01  5.143685802805322e-01  6.265226333993963e-02 
 	 9.124249034477948e-01  4.039984993623815e-01  6.531468503503733e-02 
 	 9.448124135959650e-01  3.204552520141385e-01  6.810238300912977e-02 
 	 9.777414442956690e-01  1.964338050438331e-01  7.372535752792554e-02 
 	 9.881480991674362e-01  1.325023097517133e-01  7.750143238833505e-02 
 	 1.276301649011554e-01  9.900330251406918e-01  5.954116339201233e-02 
 	 5.329421559317056e-01  8.447978711090417e-01  4.784574589759026e-02 
 	 6.004854939266829e-01  7.982471624724550e-01  4.710243293399787e-02 
 	 8.842722839684516e-01  4.644026575575405e-01  4.891522726832447e-02 
 	 9.913876880008523e-01  1.163522338021009e-01  6.010498955649139e-02 
 	 9.951718815223950e-01  7.584724134779888e-02  6.229062696028106e-02 
 	 8.176239100597422e-02  9.956230163419740e-01  4.527384175321652e-02 
 	 1.700472519945065e-01  9.845350118501238e-01  4.212769315300188e-02 
 	 2.409453217357699e-01  9.697095995771938e-01  4.010790971223251e-02 
 	 3.017353415852212e-01  9.526073417278955e-01  3.866569700085884e-02 
 	 3.673727515968361e-01  9.293229496231192e-01  3.736464489266231e-02 
 	 4.361527452251639e-01  8.991420550064683e-01  3.625393428716999e-02 
 	 7.829492555999426e-01  6.211319520658803e-01  3.443198045893703e-02 
 	 8.167974618601800e-01  5.758787626877148e-01  3.472113166408298e-02 
 	 9.455734903811954e-01  3.231570851952129e-01  3.821351300858356e-02 
 	 9.646414911571485e-01  2.605713331157850e-01  3.961532400947476e-02 
 	 9.815664634655153e-01  1.865338682295752e-01  4.162203506692895e-02 
 	 9.870791704008154e-01  1.544590435800349e-01  4.262763443095195e-02 
 	 9.971295727113156e-01  5.999974846653170e-02  4.618057392997619e-02 
 	 3.440251990705367e-02  9.988802681177309e-01  3.247578465710353e-02 
 	 5.991714629444849e-02  9.976997126824134e-01  3.170518716802188e-02 
 	 1.141163767654410e-01  9.930068444613015e-01  3.024664290357910e-02 
 	 2.519208734074280e-01  9.673599528092620e-01  2.739699331132672e-02 
 	 5.266861620094362e-01  8.497149949460620e-01  2.420979371212962e-02 
 	 5.970233139493480e-01  8.018703566069237e-01  2.381373124949661e-02 
 	 6.859384477472172e-01  7.272777891028327e-01  2.356827061610399e-02 
 	 9.228616801433872e-01  3.842852915402292e-01  2.551732800991663e-02 
 	 9.554200926099310e-01  2.940381844689687e-01  2.672064204737000e-02 
 	 9.944057935855268e-01  1.011048986316830e-01  3.057641503210777e-02 
 	 9.989296925968237e-01  3.288921482350736e-02  3.252335770963043e-02 
 	 2.097973337746036e-02  9.995674638458697e-01  2.060912439058844e-02 
 	 2.932932623259192e-02  9.993607396880779e-01  2.044266599149839e-02 
 	 1.337812700287432e-01  9.908350383953631e-01  1.866811392604249e-02 
 	 4.033215340459627e-01  9.149203560261302e-01  1.588969174749731e-02 
 	 8.514459458109052e-01  5.242215077335929e-01  1.521881045587863e-02 
 	 8.921102736099806e-01  4.515488348372010e-01  1.558555346118693e-02 
 	 9.638602407066638e-01  2.658623096392097e-01  1.704900871596639e-02 
 	 9.787112721137974e-01  2.044747123624868e-01  1.772957533814043e-02 
 	 9.943851830192841e-01  1.040793957346348e-01  1.912033407704691e-02 
 	 9.986141036716518e-01  4.865130767193760e-02  2.007292230527858e-02 
 	 7.024367507677978e-02  9.974731007018002e-01  1.064140442066898e-02 
 	 1.789574383342046e-01  9.838083669125468e-01  9.763834171426126e-03 
 	 2.182788579405082e-01  9.758401445967773e-01  9.505386342916054e-03 
 	 2.826024811022244e-01  9.591935886371562e-01  9.137679806211893e-03 
 	 3.283333177805762e-01  9.445198719544464e-01  8.913131792763885e-03 
 	 4.487190170391736e-01  8.936329581444143e-01  8.448660572015773e-03 
 	 5.465922533934121e-01  8.373588122476237e-01  8.193172862870459e-03 
 	 6.179580862982675e-01  7.861695757960915e-01  8.074755177493930e-03 
 	 7.480634349202697e-01  6.635786252856912e-01  8.031525337050486e-03 
 	 7.861695757960917e-01  6.179580862982673e-01  8.074755177493866e-03 
 	 9.165288647406674e-01  3.998757305352719e-01  8.616276809961989e-03 
 	 9.522371700376677e-01  3.052260759356278e-01  9.023002138551279e-03 
 	 9.709578927266105e-01  2.390665102319287e-01  9.379458269382392e-03 
 	 9.838083669125468e-01  1.789574383342045e-01  9.763834171426126e-03 
 	 9.896719360137395e-01  1.429998170816617e-01  1.002553646583962e-02 
 	 9.982039483014926e-01  5.893502533939075e-02  1.074897127897266e-02 
 	 9.994265150063583e-01  3.201889779877614e-02  1.101958647123906e-02 
 	 9.998693888093274e-01  1.161375505994411e-02  1.123948466211389e-02 
 	 1.361037832768944e-02  9.998969090823436e-01  4.574801564292486e-03 
 	 3.354549645028866e-02  9.994271137011762e-01  4.488214215020829e-03 
 	 5.292297528598641e-02  9.985888651711173e-01  4.408746209403858e-03 
 	 9.064886168615116e-02  9.958737792213221e-01  4.266114678052867e-03 
 	 1.212032986603716e-01  9.926189828817227e-01  4.161155692739192e-03 
 	 2.350900309827536e-01  9.719660188983229e-01  3.838676786700876e-03 
 	 8.218452559344159e-01  5.697010591772304e-01  3.328433631068594e-03 
 	 8.681812209389775e-01  4.962356729323467e-01  3.394778091020587e-03 
 	 9.065805376383569e-01  4.220184508308044e-01  3.486536062611555e-03 
 	 9.990806288498970e-01  4.263908190956585e-02  4.450365243843640e-03 
 	 9.998969090823435e-01  1.361037832768932e-02  4.574801564292486e-03 
 	 1.258279097309527e-03  9.999988211328320e-01  8.800378738533193e-04 
 	 9.942176499288746e-03  9.999501946892237e-01  8.725064127581462e-04 
 	 3.002273741754383e-02  9.995488496407168e-01  8.558153287751248e-04 
 	 4.953779009460901e-02  9.987718963321305e-01  8.405055992298134e-04 
 	 7.373851572530485e-02  9.972772706265984e-01  8.226725905077980e-04 
 	 1.023806894067952e-01  9.947449670641688e-01  8.030797563508676e-04 
 	 1.530082178089686e-01  9.882246147852919e-01  7.720203264979848e-04 
 	 1.913421088647511e-01  9.815231189818652e-01  7.511852641462887e-04 
 	 3.235029242616799e-01  9.462269160043643e-01  6.938465332582553e-04 
 	 3.715897973261157e-01  9.283967703847242e-01  6.776889772512112e-04 
 	 4.455984441748836e-01  8.952327043032653e-01  6.570348434477775e-04 
 	 5.201260480164354e-01  8.540892712178670e-01  6.410657825420194e-04 
 	 5.932425203970060e-01  8.050235493760094e-01  6.300341736894532e-04 
 	 6.631261990380930e-01  7.485073511273352e-01  6.240654063866661e-04 
 	 7.071066439945807e-01  7.071066439945805e-01  6.229265150744526e-04 
 	 8.540892712178672e-01  5.201260480164352e-01  6.410657825420194e-04 
 	 9.539237787984574e-01  3.000482138549642e-01  7.025705072823332e-04 
 	 9.670307921598236e-01  2.546584515825506e-01  7.211465329756372e-04 
 	 9.815231189818652e-01  1.913421088647508e-01  7.511852641462247e-04 
 	 9.882246147852920e-01  1.530082178089684e-01  7.720203264979848e-04 
 	 9.947449670641689e-01  1.023806894067950e-01  8.030797563508121e-04 
 	 9.961622781607998e-01  8.752173742520571e-02  8.130483124641056e-04 
 	 9.972772706265984e-01  7.373851572530474e-02  8.226725905079176e-04 
 	 9.992317564349814e-01  3.918133409330429e-02  8.485225577757041e-04 
 	 9.997557380338638e-01  2.208439978555096e-02  8.622960490235702e-04 
 	 9.999501946892239e-01  9.942176499288625e-03  8.725064127581462e-04 
 	 5.604288204445929e-01  5.608731777488090e-01  6.093774000543793e-01 
 	 5.178142049666645e-01  5.586632450646831e-01  6.478918333707711e-01 
 	 5.122114151970313e-01  6.243285867715045e-01  5.897908797885487e-01 
 	 5.043382555904178e-01  6.595629325189505e-01  5.573326313746726e-01 
 	 4.957434652527350e-01  5.326978834657400e-01  6.859091642559758e-01 
 	 5.054861097722531e-01  6.992091510561765e-01  5.055594484396613e-01 
 	 4.662548901741098e-01  6.255423156704624e-01  6.255423156704623e-01 
 	 4.742458280789861e-01  6.855158934684251e-01  5.524118521102380e-01 
 	 4.363309328725667e-01  5.668629039782841e-01  6.987716115526319e-01 
 	 4.312789053559934e-01  6.564402516351650e-01  6.189383667442967e-01 
 	 4.380628909659258e-01  4.715116979146587e-01  7.653611058109832e-01 
 	 4.222151370486065e-01  5.363770741105348e-01  7.307763080557882e-01 
 	 4.122077465218215e-01  6.228468699149013e-01  6.649410126805323e-01 
 	 4.222151370486065e-01  7.307763080557882e-01  5.363770741105348e-01 
 	 3.920393941398570e-01  6.659491226294432e-01  6.346785639294341e-01 
 	 4.158945882909245e-01  7.775457673031868e-01  4.716505816589448e-01 
 	 3.873319238861286e-01  4.989858294239923e-01  7.752335923918163e-01 
 	 3.739341115905033e-01  7.124770667947994e-01  5.937589658106225e-01 
 	 3.909166520452926e-01  3.917977885794295e-01  8.328737383409135e-01 
 	 3.715983671395311e-01  4.649286331812081e-01  8.035894596045222e-01 
 	 3.520184198049728e-01  6.034973906054935e-01  7.154536544391750e-01 
 	 3.764387597950187e-01  8.132361805691478e-01  4.437800972748696e-01 
 	 3.290901514470150e-01  7.073541239613095e-01  6.255795836946000e-01 
 	 3.319429959121839e-01  7.424837195247035e-01  5.818348336990536e-01 
 	 3.438349401493409e-01  8.023702351120238e-01  4.878314665320135e-01 
 	 3.698251455199194e-01  8.504191340923468e-01  3.741879983521563e-01 
 	 3.270466212579194e-01  4.477149098352156e-01  8.322210445759131e-01 
 	 3.131289960083551e-01  5.444292368023858e-01  7.781690291791181e-01 
 	 3.089345764565112e-01  5.917876805566245e-01  7.445446720050091e-01 
 	 3.059400513078799e-01  6.732015615719158e-01  6.732015615719158e-01 
 	 3.197205659530923e-01  3.604465569736452e-01  8.762745227795220e-01 
 	 3.100620641875786e-01  4.055650790884575e-01  8.598712013875747e-01 
 	 3.047910884243999e-01  8.475636122958153e-01  4.344402324015796e-01 
 	 2.737633974492432e-01  4.806926426786938e-01  8.330595329816599e-01 
 	 2.658063742419158e-01  5.610805970461347e-01  7.839231690865628e-01 
 	 2.619147126992112e-01  6.298007731758871e-01  7.312671668950715e-01 
 	 2.609908548386800e-01  6.952349971688018e-01  6.697253708814317e-01 
 	 2.681095341527956e-01  8.020591396146906e-01  5.336838148725452e-01 
 	 2.856988459589019e-01  8.710968228264122e-01  3.994577508066176e-01 
 	 2.998505720343356e-01  8.954905950651729e-01  3.289167502583357e-01 
 	 2.712638493185240e-01  3.357285859211994e-01  9.020544554782981e-01 
 	 2.610536598235939e-01  3.949543814662937e-01  8.808303033236792e-01 
 	 2.466885748718258e-01  5.133059288256775e-01  8.219864782708510e-01 
 	 2.405252075091331e-01  6.013215182484194e-01  7.619449168044263e-01 
 	 2.393316277473549e-01  7.383771108252877e-01  6.304915655019521e-01 
 	 2.421691846488041e-01  7.837975411019990e-01  5.718526913191838e-01 
 	 2.466885748718257e-01  8.219864782708510e-01  5.133059288256775e-01 
 	 2.645604006701386e-01  8.892818504219318e-01  3.730758433715600e-01 
 	 2.576018442207525e-01  2.673517323444405e-01  9.285280507698697e-01 
 	 2.196403666333493e-01  5.685206690332019e-01  7.928066335666021e-01 
 	 2.160136007141222e-01  7.046144685384977e-01  6.759116621517415e-01 
 	 2.282185715720045e-01  8.575248777563507e-01  4.610502875160037e-01 
 	 2.481096695116692e-01  9.156299214363020e-01  3.163280557670496e-01 
 	 2.184525350103348e-01  3.394292427416475e-01  9.149132631672744e-01 
 	 2.041924483881175e-01  4.666175957491931e-01  8.605657809595433e-01 
 	 1.943513374287653e-01  6.469266230427179e-01  7.373693118364741e-01 
 	 1.973714363547604e-01  8.011971568830252e-01  5.649138269805546e-01 
 	 2.003929363891740e-01  8.333168733527551e-01  5.151947783420486e-01 
 	 2.101906339772728e-01  8.894990308861248e-01  4.057232695334059e-01 
 	 2.263605743008647e-01  9.305831176992178e-01  2.877081011292285e-01 
 	 2.090716446393925e-01  2.307190973670184e-01  9.502935049330432e-01 
 	 1.833127129139587e-01  4.406216579698499e-01  8.787769932195683e-01 
 	 1.763808485865004e-01  5.435435407796990e-01  8.206401254682674e-01 
 	 1.721978174755192e-01  6.965442956685052e-01  6.965442956685051e-01 
 	 1.726720095950840e-01  7.423060905283035e-01  6.474303399339431e-01 
 	 1.907786337097525e-01  9.120260890979511e-01  3.630591215277977e-01 
 	 2.099389062910635e-01  9.513095075321522e-01  2.256897793526457e-01 
 	 1.759827772376849e-01  2.801872225353713e-01  9.436764182936997e-01 
 	 1.699977105546333e-01  3.336017075076412e-01  9.272597689720876e-01 
 	 1.641797595450841e-01  3.962974055857390e-01  9.033235150718322e-01 
 	 1.579446686703545e-01  4.837059060166292e-01  8.608612420844859e-01 
 	 1.529081981704356e-01  5.937401653076706e-01  7.899947462057522e-01 
 	 1.529081981704355e-01  7.899947462057522e-01  5.937401653076705e-01 
 	 1.559307883113271e-01  8.396617921092502e-01  5.202438506397652e-01 
 	 1.550882486334534e-01  2.498962434388229e-01  9.557716791425516e-01 
 	 1.344405497131629e-01  5.336579240132212e-01  8.349460813314364e-01 
 	 1.316093505975060e-01  6.289995586227780e-01  7.661843995329409e-01 
 	 1.309433202245420e-01  7.180511437921840e-01  6.835615566920868e-01 
 	 1.370934374586222e-01  8.686293546865897e-01  4.761180878548278e-01 
 	 1.415655294445960e-01  9.045993875165615e-01  4.020685874048519e-01 
 	 1.481893398794772e-01  9.362834259183003e-01  3.184544958024235e-01 
 	 1.523676858074509e-01  9.492300982818465e-01  2.752204731438380e-01 
 	 1.620459072710634e-01  9.677292147896581e-01  1.929800268921368e-01 
 	 1.346112500679675e-01  2.196028217097568e-01  9.662579428145737e-01 
 	 1.258795052615117e-01  3.201012118718415e-01  9.389832609334925e-01 
 	 1.190173121303117e-01  4.293652631996816e-01  8.952543494285543e-01 
 	 1.122011354915340e-01  7.701524769970409e-01  6.279140604969226e-01 
 	 1.234420647872957e-01  9.268024562927891e-01  3.546819189791071e-01 
 	 1.321834865356584e-01  9.605653825507807e-01  2.446255745672345e-01 
 	 1.197014270990411e-01  1.380462551540315e-01  9.831657031184524e-01 
 	 9.817959161626513e-02  4.613323962083168e-01  8.817784234141568e-01 
 	 9.500883835085423e-02  5.653499082670824e-01  8.193612157392018e-01 
 	 9.418656281449229e-02  6.064531268637187e-01  7.895210550089276e-01 
 	 9.332174412797778e-02  7.040209698840342e-01  7.040209698840341e-01 
 	 9.985240787207864e-02  9.017920856270703e-01  4.204765521911142e-01 
 	 1.081458812043985e-01  9.559455484091222e-01  2.728966413411985e-01 
 	 1.115173836953716e-01  9.673285326462516e-01  2.276826367165247e-01 
 	 1.183307889848291e-01  9.813540304996967e-01  1.514664688973377e-01 
 	 9.854072377519224e-02  1.244974466080764e-01  9.873145960361016e-01 
 	 9.384479632445630e-02  1.842424684442295e-01  9.783904471244588e-01 
 	 8.903439755126641e-02  2.586483103017411e-01  9.618596195031462e-01 
 	 8.524443420616203e-02  3.311928749334015e-01  9.397045631634549e-01 
 	 8.115432450671842e-02  4.330447766141821e-01  8.977116447172953e-01 
 	 7.775460894758404e-02  8.234885942532036e-01  5.619793198350727e-01 
 	 7.922129615605665e-02  8.639315287366452e-01  4.973392201406578e-01 
 	 9.910465521196429e-02  9.880568776739398e-01  1.179909903193588e-01 
 	 7.976988306562749e-02  9.914801303160106e-02  9.918701715787109e-01 
 	 7.208995282944117e-02  2.282215325626516e-01  9.709366461184806e-01 
 	 6.596383991501954e-02  3.825282715630926e-01  9.215860748072415e-01 
 	 6.092375280551340e-02  6.450138277979069e-01  7.617384448047668e-01 
 	 6.109359145414805e-02  7.791182125771298e-01  6.238929266419455e-01 
 	 6.664677890382943e-02  9.300231403999999e-01  3.614072013425663e-01 
 	 6.965458482945633e-02  9.569975831188842e-01  2.816094187289381e-01 
 	 7.208995282944099e-02  9.709366461184805e-01  2.282215325626514e-01 
 	 7.531528944471885e-02  9.828942604081284e-01  1.680668915420780e-01 
 	 6.229062696028113e-02  7.584724134779876e-02  9.951718815223950e-01 
 	 5.704209898354674e-02  1.825312247810642e-01  9.815439628073089e-01 
 	 5.313013024281224e-02  2.902574376070594e-01  9.554725580434877e-01 
 	 4.934045023104686e-02  4.416413043502634e-01  8.958339568596380e-01 
 	 4.784574589759029e-02  5.329421559317055e-01  8.447978711090416e-01 
 	 4.669873127310555e-02  7.450740634485512e-01  6.653449244367514e-01 
 	 4.891522726832449e-02  8.842722839684516e-01  4.644026575575404e-01 
 	 6.010498955649146e-02  9.913876880008522e-01  1.163522338021009e-01 
 	 6.195435082372389e-02  9.947236113127564e-01  8.177160577437022e-02 
 	 4.618057392997631e-02  5.999974846653158e-02  9.971295727113156e-01 
 	 4.405216488845785e-02  1.134598922883757e-01  9.925654938645361e-01 
 	 4.212769315300201e-02  1.700472519945064e-01  9.845350118501238e-01 
 	 3.961532400947491e-02  2.605713331157852e-01  9.646414911571485e-01 
 	 3.736464489266263e-02  3.673727515968361e-01  9.293229496231192e-01 
 	 3.456227663425534e-02  5.986630828408915e-01  8.002549358031458e-01 
 	 3.425781716557699e-02  6.648857509051177e-01  7.461590582485665e-01 
 	 3.443198045893724e-02  7.829492555999427e-01  6.211319520658803e-01 
 	 3.490828458290599e-02  8.325550348072585e-01  5.528413205292850e-01 
 	 3.736464489266244e-02  9.293229496231193e-01  3.673727515968357e-01 
 	 3.866569700085875e-02  9.526073417278956e-01  3.017353415852210e-01 
 	 4.111449048985758e-02  9.781328848980609e-01  2.038765757823988e-01 
 	 4.262763443095201e-02  9.870791704008154e-01  1.544590435800349e-01 
 	 4.405216488845754e-02  9.925654938645361e-01  1.134598922883754e-01 
 	 4.618057392997614e-02  9.971295727113156e-01  5.999974846653169e-02 
 	 3.089028840703249e-02  8.915275011702076e-02  9.955388376295032e-01 
 	 2.955202583722176e-02  1.431892244828847e-01  9.892540238790573e-01 
 	 2.774838668923675e-02  2.318288061282394e-01  9.723607518227481e-01 
 	 2.609053341463013e-02  3.383304221075997e-01  9.406656204744773e-01 
 	 2.478132469322899e-02  4.551547736128433e-01  8.900674232910056e-01 
 	 2.500912149680263e-02  9.018306650082737e-01  4.313652692239988e-01 
 	 2.774838668923656e-02  9.723607518227481e-01  2.318288061282392e-01 
 	 3.089028840703237e-02  9.955388376295032e-01  8.915275011702063e-02 
 	 2.034037979542662e-02  3.456508471277500e-02  9.991954382745032e-01 
 	 1.991101028867965e-02  5.747033372074250e-02  9.981486424432537e-01 
 	 1.486023453306475e-02  6.416234242334664e-01  7.668758406055987e-01 
 	 1.480119219957861e-02  7.070293221322124e-01  7.070293221322121e-01 
 	 1.486023453306475e-02  7.668758406055988e-01  6.416234242334663e-01 
 	 1.503677196794119e-02  8.200635114779008e-01  5.720749362026963e-01 
 	 1.545108717875608e-02  8.794180668406804e-01  4.757994615583283e-01 
 	 1.662648461892310e-02  9.506133807099383e-01  3.099318641644296e-01 
 	 1.796394843542465e-02  9.824796021979605e-01  1.855023660807235e-01 
 	 1.866811392604251e-02  9.908350383953631e-01  1.337812700287432e-01 
 	 1.119074753358477e-02  1.603056247071802e-02  9.998088758540363e-01 
 	 1.101958647123930e-02  3.201889779877608e-02  9.994265150063582e-01 
 	 1.064140442066917e-02  7.024367507677984e-02  9.974731007018002e-01 
 	 1.015525593344140e-02  1.264056660859508e-01  9.919266496865045e-01 
 	 9.633769374856259e-03  1.982238446369624e-01  9.801094315967852e-01 
 	 9.137679806212095e-03  2.826024811022244e-01  9.591935886371562e-01 
 	 8.709433790571085e-03  3.757276585184398e-01  9.266891994554044e-01 
 	 8.529279189979406e-03  4.242300303901074e-01  9.055142918318341e-01 
 	 8.307258833738998e-03  4.978143262246543e-01  8.672438446343466e-01 
 	 8.193172862870603e-03  5.465922533934121e-01  8.373588122476237e-01 
 	 8.448660572015916e-03  8.936329581444145e-01  4.487190170391734e-01 
 	 8.709433790571085e-03  9.266891994554046e-01  3.757276585184396e-01 
 	 9.137679806211855e-03  9.591935886371563e-01  2.826024811022242e-01 
 	 9.379458269382525e-03  9.709578927266105e-01  2.390665102319288e-01 
 	 9.894731184497275e-03  9.869809197009534e-01  1.605327332385723e-01 
 	 1.028283224294844e-02  9.937901881669349e-01  1.107940669178264e-01 
 	 1.052707089433733e-02  9.965207587821158e-01  8.267743401135437e-02 
 	 1.084860189655781e-02  9.987506785552057e-01  4.877899058412562e-02 
 	 1.123948466211400e-02  9.998693888093272e-01  1.161375505994399e-02 
 	 4.408746209403981e-03  5.292297528598634e-02  9.985888651711172e-01 
 	 4.161155692739439e-03  1.212032986603716e-01  9.926189828817226e-01 
 	 4.052734280505364e-03  1.557166686239742e-01  9.877934472639019e-01 
 	 3.838676786701073e-03  2.350900309827536e-01  9.719660188983230e-01 
 	 4.214297253661284e-03  9.944199095242544e-01  1.054100718168391e-01 
 	 4.363835267247326e-03  9.979164285837017e-01  6.437203200544556e-02 
 	 4.521840211002821e-03  9.996603940280403e-01  2.566416904575701e-02 
 	 8.761029026263664e-04  5.767265905993585e-03  9.999829853990886e-01 
 	 8.622960490236913e-04  2.208439978555090e-02  9.997557380338639e-01 
 	 8.558153287753104e-04  3.002273741754389e-02  9.995488496407168e-01 
 	 8.130483124642392e-04  8.752173742520589e-02  9.961622781607999e-01 
 	 7.511852641464836e-04  1.913421088647511e-01  9.815231189818651e-01 
 	 7.116829857751537e-04  2.770778118969894e-01  9.608472197293929e-01 
 	 6.776889772514056e-04  3.715897973261157e-01  9.283967703847242e-01 
 	 6.634164914518892e-04  4.207745490766840e-01  9.071650008283345e-01 
 	 6.511754258478984e-04  4.704798587805364e-01  8.824104931676705e-01 
 	 6.410657825421630e-04  5.201260480164352e-01  8.540892712178670e-01 
 	 6.254881607373061e-04  6.402960954241910e-01  7.681279313689199e-01 
 	 6.232112941358035e-04  6.854143406067567e-01  7.281530012973152e-01 
 	 6.300341736895860e-04  8.050235493760094e-01  5.932425203970058e-01 
 	 6.410657825421630e-04  8.540892712178670e-01  5.201260480164352e-01 
 	 6.570348434478634e-04  8.952327043032654e-01  4.455984441748835e-01 
 	 6.703067154604259e-04  9.182154025633421e-01  3.960808316295385e-01 
 	 7.025705072823496e-04  9.539237787984572e-01  3.000482138549641e-01 
 	 7.211465329757625e-04  9.670307921598236e-01  2.546584515825505e-01 
 	 7.511852641463554e-04  9.815231189818652e-01  1.913421088647508e-01 
 	 7.824785960573328e-04  9.908224466715020e-01  1.351675512064390e-01 
 	 8.130483124640000e-04  9.961622781607999e-01  8.752173742520575e-02 
 	 8.485225577758262e-04  9.992317564349813e-01  3.918133409330429e-02 
 	 8.622960490236358e-04  9.997557380338639e-01  2.208439978555096e-02 
 	 8.761029026261827e-04  9.999829853990884e-01  5.767265905993456e-03 
 	 ]; 
 

 	  
 

 	 case 13
 	 pts=[
 	 6.440909902904971e-01  5.384405422947554e-01  5.433494075085908e-01 
 	 5.743258817378513e-01  5.290806484556736e-01  6.246786765976277e-01 
 	 6.169403573299447e-01  5.147450547695127e-01  5.953336241872548e-01 
 	 6.929909525365162e-01  5.079112111469990e-01  5.116539272728398e-01 
 	 5.591861830170910e-01  4.933056236422255e-01  6.663035152284065e-01 
 	 6.641914255135287e-01  4.748099354709610e-01  5.774125695309796e-01 
 	 6.245276252324974e-01  4.549014805216846e-01  6.348463501829690e-01 
 	 7.442946306369740e-01  4.641162973375308e-01  4.802307417801062e-01 
 	 7.155283567385168e-01  4.486533783598604e-01  5.354711166714430e-01 
 	 6.638552636739474e-01  4.385197736001211e-01  6.058024406141760e-01 
 	 5.996845950737570e-01  4.389936370516725e-01  6.690762087082223e-01 
 	 5.302711802465546e-01  4.498089920267723e-01  7.186684535248401e-01 
 	 4.779474376691437e-01  4.649219748573361e-01  7.452608966799844e-01 
 	 5.738459198692151e-01  4.236750975444115e-01  7.008568127443635e-01 
 	 7.018371951588940e-01  4.031317555215830e-01  5.872898255389610e-01 
 	 4.702857037380887e-01  4.252742019823313e-01  7.732872752010485e-01 
 	 7.835764595833740e-01  4.026251199304135e-01  4.731817249089457e-01 
 	 6.540395215035530e-01  3.800850018388084e-01  6.540395215035529e-01 
 	 5.289694392634378e-01  3.910888660343236e-01  7.531539226408577e-01 
 	 8.110618865999024e-01  3.891449765239002e-01  4.367434067633081e-01 
 	 7.625240769068558e-01  3.697180356044025e-01  5.309101678120031e-01 
 	 7.382852736311764e-01  3.649611088464748e-01  5.672197490998446e-01 
 	 6.938712484185481e-01  3.604694524827359e-01  6.233814758595914e-01 
 	 4.672711531431292e-01  3.816356883517898e-01  7.975035240151268e-01 
 	 8.405056030020400e-01  3.784117063984922e-01  3.877562530543621e-01 
 	 7.929160761926665e-01  3.533995675158187e-01  4.963797354796607e-01 
 	 6.457514051595004e-01  3.387682414447140e-01  6.842815219797965e-01 
 	 6.052300824407038e-01  3.405880793766468e-01  7.195111587010629e-01 
 	 5.541401999807838e-01  3.452043762590444e-01  7.574711726375210e-01 
 	 4.010840606958871e-01  3.745451756955159e-01  8.359709849144964e-01 
 	 8.338077417257903e-01  3.421690640716360e-01  4.332262473932972e-01 
 	 7.698729687194208e-01  3.238786267072570e-01  5.499074896720058e-01 
 	 7.290835722071143e-01  3.191607966621011e-01  6.054531613690084e-01 
 	 4.498220085111080e-01  3.388268795743346e-01  8.263513213742397e-01 
 	 3.828073122522123e-01  3.540972811329198e-01  8.532723347094474e-01 
 	 8.641316550160972e-01  3.288508311612309e-01  3.809640582045877e-01 
 	 8.101875443324004e-01  3.075865610009773e-01  4.989856215365598e-01 
 	 6.755761404313038e-01  2.952858902146983e-01  6.755761404313038e-01 
 	 5.933014763042512e-01  2.981473435931082e-01  7.477309139814731e-01 
 	 5.334784118149494e-01  3.034066077217992e-01  7.895221431461878e-01 
 	 4.770644235405093e-01  3.106898411728179e-01  8.221200389140084e-01 
 	 7.849669207762388e-01  2.790399411322407e-01  5.531398056007051e-01 
 	 6.432161999932503e-01  2.738424689155227e-01  7.150407137250955e-01 
 	 4.132364401365332e-01  2.971837006165018e-01  8.607656432683444e-01 
 	 3.443257198713112e-01  3.112858326406687e-01  8.857431507114852e-01 
 	 8.749626404628053e-01  2.749812828914038e-01  3.985293864368769e-01 
 	 8.359281220642233e-01  2.634633995290313e-01  4.814677682366568e-01 
 	 7.661690650509586e-01  2.540914081932084e-01  5.902732587889548e-01 
 	 6.178563133594908e-01  2.527201487929625e-01  7.445710862207058e-01 
 	 4.814677682366566e-01  2.634633995290314e-01  8.359281220642234e-01 
 	 9.107682930700766e-01  2.639032630195642e-01  3.175786266514893e-01 
 	 8.677189174956640e-01  2.458808302263070e-01  4.319797420567023e-01 
 	 8.238436229491319e-01  2.371478157867666e-01  5.148228806042079e-01 
 	 7.147530927142297e-01  2.295211257061625e-01  6.606421643446774e-01 
 	 4.585076118418240e-01  2.427279497256366e-01  8.548999428617925e-01 
 	 3.724927241240064e-01  2.542844488542601e-01  8.925181172085875e-01 
 	 3.175786266514892e-01  2.639032630195642e-01  9.107682930700766e-01 
 	 8.511648432941982e-01  2.176764935085341e-01  4.776351680035634e-01 
 	 7.938562898230842e-01  2.109768762804141e-01  5.703340677035574e-01 
 	 6.772714401521193e-01  2.075754156260971e-01  7.058440643526922e-01 
 	 6.324016986085819e-01  2.083967538893828e-01  7.460823577631014e-01 
 	 5.859747058121458e-01  2.101785673194971e-01  7.825973511250168e-01 
 	 5.546787775335295e-01  2.118727202249769e-01  8.046374364758193e-01 
 	 4.338616576674197e-01  2.220302154890563e-01  8.731933608405196e-01 
 	 3.564916194679200e-01  2.317883495614101e-01  9.050899879330989e-01 
 	 2.506348166458012e-01  2.503881456415779e-01  9.351406125321997e-01 
 	 9.392811275053734e-01  2.211093536517614e-01  2.624149714477713e-01 
 	 8.967196122780234e-01  2.029919381041990e-01  3.933042207002772e-01 
 	 7.649865801503425e-01  1.873916365558426e-01  6.161817156803719e-01 
 	 7.240643855870921e-01  1.863010428909727e-01  6.640953899419290e-01 
 	 5.010641561432730e-01  1.933278955660585e-01  8.435395878229005e-01 
 	 9.180259230548090e-01  1.840985358538071e-01  3.511924453855043e-01 
 	 8.867509065462299e-01  1.768520306253192e-01  4.270786684009641e-01 
 	 8.423136190091682e-01  1.709063333950400e-01  5.111739356003406e-01 
 	 8.089679289670527e-01  1.682427545628527e-01  5.632630517261551e-01 
 	 7.427384551588163e-01  1.655925969996795e-01  6.487824589546152e-01 
 	 6.652929559047595e-01  1.653479336775394e-01  7.280421304100991e-01 
 	 5.806182570933162e-01  1.675275889692125e-01  7.967540062428820e-01 
 	 5.284941362569481e-01  1.699351361679192e-01  8.317547700119386e-01 
 	 3.802334368493392e-01  1.810982253511962e-01  9.069873021582976e-01 
 	 2.996090130508245e-01  1.901974538721435e-01  9.349114224563013e-01 
 	 9.477343404928362e-01  1.696053248754429e-01  2.702473933722660e-01 
 	 8.700490260600647e-01  1.521915591341310e-01  4.688842304665995e-01 
 	 4.867977570522588e-01  1.511472492747474e-01  8.603385686841940e-01 
 	 2.589346677808337e-01  1.709770274348899e-01  9.506417274193040e-01 
 	 2.134367306120135e-01  1.770204502193501e-01  9.607853674103252e-01 
 	 9.657800937925546e-01  1.528694183917973e-01  2.095226750368515e-01 
 	 9.561886930020381e-01  1.480377970461184e-01  2.525628516246726e-01 
 	 9.306062335685428e-01  1.401419095728460e-01  3.381305712659639e-01 
 	 8.956305753996509e-01  1.340986878441057e-01  4.241030704059799e-01 
 	 7.948712520697990e-01  1.267935257516527e-01  5.933827554458041e-01 
 	 6.843209523194245e-01  1.253642101611607e-01  7.183234988689319e-01 
 	 6.305619841135885e-01  1.259794239388474e-01  7.658464395260781e-01 
 	 5.745309916320510e-01  1.273188069015642e-01  8.085196726508602e-01 
 	 4.985436338653847e-01  1.301697403899696e-01  8.570356374265338e-01 
 	 3.712434797959443e-01  1.376099830324589e-01  9.182819671967890e-01 
 	 3.223418930052169e-01  1.414459345557789e-01  9.359961279895637e-01 
 	 1.856134371124896e-01  1.558467038497826e-01  9.701852693493371e-01 
 	 9.804609563462064e-01  1.371193568599249e-01  1.410482011760608e-01 
 	 8.397069885315561e-01  1.096496899274845e-01  5.318544151457913e-01 
 	 7.373301773786350e-01  1.068753602071643e-01  6.670246374065799e-01 
 	 4.337818738814946e-01  1.136131417563790e-01  8.938262358602503e-01 
 	 2.771759710619068e-01  1.235896831821891e-01  9.528373792399284e-01 
 	 9.698681800077672e-01  1.072013942277014e-01  2.187774542407383e-01 
 	 9.549326527628327e-01  1.029559109124863e-01  2.783948797940066e-01 
 	 9.386984251617854e-01  9.983912595590801e-02  3.299657793274087e-01 
 	 8.999557534304624e-01  9.522506125228780e-02  4.254548502213917e-01 
 	 8.688823080489915e-01  9.298380910841882e-02  4.862073076406264e-01 
 	 7.884343521320930e-01  9.000338614018981e-02  6.084986958583779e-01 
 	 6.859034783185726e-01  8.924087661792748e-02  7.221997537876534e-01 
 	 6.283386739894398e-01  8.971820406872934e-02  7.727490890501745e-01 
 	 5.681392935622158e-01  9.075926479074109e-02  8.179122807277505e-01 
 	 4.056363126778263e-01  9.606894126402270e-02  9.089719139563919e-01 
 	 3.482393099459537e-01  9.884546689995567e-02  9.321796804702920e-01 
 	 2.624334721384617e-01  1.040208529597492e-01  9.593270218496285e-01 
 	 1.619514493491822e-01  1.120044703146621e-01  9.804217085944350e-01 
 	 1.167688448453847e-01  1.164554946029753e-01  9.863078396982611e-01 
 	 9.852659716026945e-01  9.250579195358001e-02  1.438528541838480e-01 
 	 9.751793069096913e-01  8.833077293089059e-02  2.030344648786640e-01 
 	 9.228835774648386e-01  7.950663040490684e-02  3.767818973456113e-01 
 	 7.588115540126301e-01  7.314838652120008e-02  6.471895696365034e-01 
 	 2.822626044386735e-01  8.375101909443773e-02  9.556744157589132e-01 
 	 1.035255057939541e-01  9.580021577540869e-02  9.900024183341629e-01 
 	 9.891303494419676e-01  7.428164604077998e-02  1.268991287372902e-01 
 	 9.604305146220007e-01  6.693413442147481e-02  2.703572603651823e-01 
 	 9.354729215226126e-01  6.406282687051858e-02  3.475433315592543e-01 
 	 8.529942886309763e-01  5.973508595333279e-02  5.184905621793735e-01 
 	 8.100249510285589e-01  5.875078975984446e-02  5.834448760712321e-01 
 	 6.666845709203829e-01  5.804252342453926e-02  7.430765427405286e-01 
 	 6.047256436688485e-01  5.850806425402741e-02  7.942818783697281e-01 
 	 4.966623844216472e-01  6.014621912404839e-02  8.658573255598673e-01 
 	 4.314856617770179e-01  6.161462744887339e-02  9.000132006616267e-01 
 	 3.680345747752972e-01  6.340417266570081e-02  9.276478117575356e-01 
 	 2.032025431118873e-01  7.000294628109935e-02  9.766311043504744e-01 
 	 1.268991287372898e-01  7.428164604077990e-02  9.891303494419676e-01 
 	 7.790730299736000e-02  7.757719892947379e-02  9.939377396728299e-01 
 	 9.939747572947262e-01  5.849875682728560e-02  9.269345883368778e-02 
 	 9.908749778383440e-01  5.703927414097065e-02  1.221200208783663e-01 
 	 9.855227940492421e-01  5.532272392640066e-02  1.602629671094927e-01 
 	 9.643781088820361e-01  5.163411195724010e-02  2.594393601431649e-01 
 	 9.531988817902625e-01  5.045167703510027e-02  2.981048809364571e-01 
 	 9.138541697283105e-01  4.783482222598272e-02  4.032150620361165e-01 
 	 7.443449683791823e-01  4.455400931608262e-02  6.663073677383858e-01 
 	 5.590783428613780e-01  4.534083409517835e-02  8.278741542691914e-01 
 	 2.594393601431647e-01  5.163411195724037e-02  9.643781088820361e-01 
 	 1.747900688661257e-01  5.471632540316779e-02  9.830842057322199e-01 
 	 1.113118177075123e-01  5.756085404523615e-02  9.921171439503668e-01 
 	 6.058024186005720e-02  6.024302672074579e-02  9.963437218288178e-01 
 	 9.973805155310297e-01  4.412871186225185e-02  5.731286093396402e-02 
 	 9.350070243259029e-01  3.588434317717112e-02  3.528089828447732e-01 
 	 8.845656490608330e-01  3.419450570460295e-02  4.651605618291443e-01 
 	 6.012073213462278e-01  3.294555778832668e-02  7.984136440352892e-01 
 	 4.880572333471727e-01  3.392420053761922e-02  8.721521000349577e-01 
 	 3.100298606048352e-01  3.669858370894716e-02  9.500182627124091e-01 
 	 1.477241419758945e-01  4.085098464368971e-02  9.881845854551299e-01 
 	 9.731375022517945e-02  4.257273741645692e-02  9.943427960446944e-01 
 	 9.959324312802813e-01  2.954101482311532e-02  8.512297438041316e-02 
 	 9.920643666633964e-01  2.863098218471949e-02  1.224277715875471e-01 
 	 9.853418675924667e-01  2.763414322310310e-02  1.683382253016673e-01 
 	 9.787575952838824e-01  2.695642918156451e-02  2.032410406386739e-01 
 	 9.649479646950578e-01  2.596541702584442e-02  2.611536378255903e-01 
 	 9.455538899158470e-01  2.504841993474705e-02  3.245002587422434e-01 
 	 9.197616808842355e-01  2.424187865055455e-02  3.917279434716108e-01 
 	 8.321017448895384e-01  2.291187384960256e-02  5.541495576001894e-01 
 	 7.826960903232939e-01  2.260617579242006e-02  6.219934010973688e-01 
 	 5.310491431021358e-01  2.305009133837957e-02  8.470274499092575e-01 
 	 4.378764327239862e-01  2.377817436627909e-02  8.987206618792756e-01 
 	 3.689892408524497e-01  2.449671195918093e-02  9.291107852340977e-01 
 	 2.817388307626224e-01  2.564946183581068e-02  9.591482348146420e-01 
 	 2.218525238288890e-01  2.662066273059948e-02  9.747167783446306e-01 
 	 1.683382253016672e-01  2.763414322310314e-02  9.853418675924667e-01 
 	 1.368196750355514e-01  2.830470237043551e-02  9.901915069050466e-01 
 	 8.512297438041271e-02  2.954101482311535e-02  9.959324312802812e-01 
 	 6.542182261947399e-02  3.006229760824934e-02  9.974047540430411e-01 
 	 9.990486605473929e-01  1.929552267694780e-02  3.910826847462730e-02 
 	 9.977502187464350e-01  1.885284236881673e-02  6.433561475619570e-02 
 	 9.948868901880333e-01  1.828975731535229e-02  9.932552798414759e-02 
 	 9.895139267999881e-01  1.765561168027140e-02  1.433543443536445e-01 
 	 8.763204544815115e-01  1.469526571771028e-02  4.815044238870532e-01 
 	 7.271859415423475e-01  1.411067534904912e-02  6.862954868453991e-01 
 	 6.650086458464061e-01  1.412855387020463e-02  7.467020054312603e-01 
 	 2.544530933021237e-01  1.635779683118323e-02  9.669467647144854e-01 
 	 2.144259504616992e-01  1.678089965641238e-02  9.765960849682525e-01 
 	 3.910826847462684e-02  1.929552267694783e-02  9.990486605473928e-01 
 	 9.994791502779637e-01  1.051200527207532e-02  3.051107839456365e-02 
 	 9.977035699471951e-01  1.016625657982463e-02  6.696442146226340e-02 
 	 9.926526467163344e-01  9.718512019642149e-03  1.206079329529379e-01 
 	 9.818613312390315e-01  9.233521817387158e-03  1.893754690881707e-01 
 	 9.684078430278157e-01  8.879140027167441e-03  2.492135839688344e-01 
 	 9.492000636197466e-01  8.552740718575248e-03  3.145569739339282e-01 
 	 9.327652436451546e-01  8.357041809867185e-03  3.603875137956138e-01 
 	 9.021902695747773e-01  8.102906260695108e-03  4.312621713003833e-01 
 	 8.498532755428334e-01  7.846224257425269e-03  5.269609537850211e-01 
 	 8.019536556008873e-01  7.719491048276134e-03  5.973363740191360e-01 
 	 5.506594413841615e-01  7.797588477987293e-03  8.346935828364869e-01 
 	 4.791615607986906e-01  7.962334613223369e-03  8.776906060112925e-01 
 	 3.603875137956133e-01  8.357041809867342e-03  9.327652436451547e-01 
 	 2.922605539230161e-01  8.657563475854897e-03  9.562995426200273e-01 
 	 1.709069778520919e-01  9.354990264128621e-03  9.852427564202757e-01 
 	 1.206079329529376e-01  9.718512019642188e-03  9.926526467163344e-01 
 	 6.696442146226295e-02  1.016625657982466e-02  9.977035699471950e-01 
 	 4.648918495043826e-02  1.035594769596732e-02  9.988651110284923e-01 
 	 9.999706636652580e-01  4.388900488519707e-03  6.277687581045030e-03 
 	 9.996919826059646e-01  4.311930633350674e-03  2.444068672458356e-02 
 	 9.991658733192482e-01  4.246772778779554e-03  4.061431416568801e-02 
 	 9.962516433092092e-01  4.077934135893044e-03  8.640621306875641e-02 
 	 9.860459005422955e-01  3.830039983894131e-03  1.664296031884216e-01 
 	 9.636965577184070e-01  3.585943954255262e-03  2.669758147241993e-01 
 	 7.665042436422947e-01  3.131599234999994e-03  6.422316074163471e-01 
 	 4.051919459040124e-01  3.344115353860496e-03  9.142255213387012e-01 
 	 2.455254909180096e-01  3.632610543261507e-03  9.693833284362340e-01 
 	 1.005009258202404e-01  4.030211932437730e-03  9.949288021265914e-01 
 	 7.334007327464456e-02  4.123890310980161e-03  9.972984644432040e-01 
 	 2.444068672458321e-02  4.311930633350649e-03  9.996919826059644e-01 
 	 4.754190796977488e-03  4.395547942511183e-03  9.999790381943769e-01 
 	 9.999548781969937e-01  8.313693427865809e-04  9.463107050610519e-03 
 	 9.995910826685822e-01  8.161910384029475e-04  2.858323427536694e-02 
 	 9.993034954028958e-01  8.095428807777567e-04  3.730775677897278e-02 
 	 9.965157522774384e-01  7.770556107151935e-04  8.340114895796588e-02 
 	 9.936210617356281e-01  7.584504134748091e-04  1.127679494729482e-01 
 	 9.892880993250357e-01  7.391478079981206e-04  1.459743477271827e-01 
 	 9.831719245443481e-01  7.197412096985342e-04  1.826812764361848e-01 
 	 9.578879191950281e-01  6.739444235577128e-04  2.871415679749855e-01 
 	 9.343956357984798e-01  6.501193860175398e-04  3.562364006464507e-01 
 	 9.147905676049654e-01  6.362661681593642e-04  4.039279794546899e-01 
 	 8.918643364710255e-01  6.242144459186194e-04  4.523025709493846e-01 
 	 8.358542402565055e-01  6.058881337600949e-04  5.489511107054885e-01 
 	 7.851646303115063e-01  5.974090719086967e-04  6.192868046472462e-01 
 	 6.859533544457689e-01  5.935416950164854e-04  7.276452729406366e-01 
 	 6.192868046472461e-01  5.974090719086967e-04  7.851646303115064e-01 
 	 5.727067660638153e-01  6.025530258806636e-04  8.197600850459709e-01 
 	 5.489511107054885e-01  6.058881337601504e-04  8.358542402565055e-01 
 	 4.523025709493843e-01  6.242144459184357e-04  8.918643364710256e-01 
 	 3.799632575043976e-01  6.429755100237816e-04  9.250013565012433e-01 
 	 3.328137687781402e-01  6.576781853618699e-04  9.429923450225326e-01 
 	 2.650188529036040e-01  6.825938283630959e-04  9.642429889147877e-01 
 	 2.225047088523077e-01  7.007464713133358e-04  9.749313634779284e-01 
 	 1.639132243328655e-01  7.294233039549154e-04  9.864744917282187e-01 
 	 1.289113088459796e-01  7.488475486857622e-04  9.916558443729181e-01 
 	 8.340114895796578e-02  7.770556107153600e-04  9.965157522774385e-01 
 	 2.858323427536677e-02  8.161910384028748e-04  9.995910826685822e-01 
 	 2.102317140510446e-02  8.220905152407283e-04  9.997786507178759e-01 
 	 1.198132986645032e-03  8.382014895963079e-04  9.999989309472331e-01 
 	 5.858728427039059e-01  5.777962335914988e-01  5.682468870390073e-01 
 	 5.944867322849654e-01  6.076886621053047e-01  5.265928361512417e-01 
 	 5.497369497421365e-01  6.509607507771191e-01  5.234877143122858e-01 
 	 6.215133642538975e-01  6.137889748254945e-01  4.868102632817745e-01 
 	 5.912840612399382e-01  6.531318942932839e-01  4.730770419080508e-01 
 	 6.641914255135287e-01  5.774125695309796e-01  4.748099354709610e-01 
 	 4.854822567639318e-01  7.293304158545686e-01  4.820623640949392e-01 
 	 7.056957758426178e-01  5.326382193975038e-01  4.672151530022784e-01 
 	 5.693672948592561e-01  6.928301178936807e-01  4.425011991894275e-01 
 	 6.358690241927093e-01  6.358690241927092e-01  4.374256144128091e-01 
 	 6.838251493751403e-01  5.813812193447079e-01  4.408843871984216e-01 
 	 4.873184434657841e-01  7.533942781865998e-01  4.414949560909814e-01 
 	 5.410328853724330e-01  7.234492171388129e-01  4.288410511679338e-01 
 	 7.310371560492527e-01  5.287769031358475e-01  4.312535949826777e-01 
 	 4.544343353575913e-01  7.801005813057761e-01  4.300378098429188e-01 
 	 5.796227658319048e-01  7.077178904421745e-01  4.039465767616445e-01 
 	 6.256753009137260e-01  6.694774929827902e-01  4.004126674020147e-01 
 	 6.894568898322944e-01  6.026901346641351e-01  4.017633614969217e-01 
 	 7.188258203652338e-01  5.644488290038880e-01  4.058164109697737e-01 
 	 7.851729931048910e-01  4.414276129865231e-01  4.343328601334777e-01 
 	 7.740019961588609e-01  4.923135498639175e-01  3.981812132214260e-01 
 	 4.743304560004695e-01  7.940741199860785e-01  3.800748748322121e-01 
 	 6.772113383903162e-01  6.418153151157082e-01  3.598025909280265e-01 
 	 8.088000087762833e-01  4.421767675911313e-01  3.877141369696786e-01 
 	 3.854878962456624e-01  8.412402855026055e-01  3.790961143240432e-01 
 	 5.441198298153659e-01  7.641605066473727e-01  3.463990919187407e-01 
 	 6.052300824407038e-01  7.195111587010627e-01  3.405880793766468e-01 
 	 7.195111587010629e-01  6.052300824407036e-01  3.405880793766469e-01 
 	 7.504729696871932e-01  5.642606770524503e-01  3.440933159786682e-01 
 	 7.877885939307029e-01  5.055342826285361e-01  3.518866584000275e-01 
 	 4.869564645117649e-01  8.077524425550172e-01  3.322790893459982e-01 
 	 5.831488021623499e-01  7.463626775584135e-01  3.207494786970860e-01 
 	 6.385643662434677e-01  7.009763233417007e-01  3.175968266189542e-01 
 	 6.910834833289833e-01  6.494012177430249e-01  3.173037621329995e-01 
 	 4.463246791568620e-01  8.373507876354680e-01  3.156547785505326e-01 
 	 7.738898552968996e-01  5.572095082247769e-01  3.010183645767250e-01 
 	 8.036706224446960e-01  5.102965931252359e-01  3.061223900078731e-01 
 	 8.458219921633430e-01  4.275327726900839e-01  3.190625108795496e-01 
 	 8.738464376855507e-01  3.511885069679668e-01  3.362425254453744e-01 
 	 3.777518799785234e-01  8.745978025752217e-01  3.039444042967148e-01 
 	 4.667493304004799e-01  8.359256261193106e-01  2.887445413644076e-01 
 	 5.275866384364577e-01  8.015287859148489e-01  2.814319532199335e-01 
 	 6.177647091779890e-01  7.367920038607437e-01  2.747804708146205e-01 
 	 7.260784924705765e-01  6.305511168261088e-01  2.742541008645119e-01 
 	 3.520296015285948e-01  8.920668211375512e-01  2.833583354573551e-01 
 	 5.764131185754410e-01  7.763729015120768e-01  2.549373149067307e-01 
 	 6.583682312549637e-01  7.094348256768518e-01  2.515024854570339e-01 
 	 7.555639793961123e-01  6.040994666176172e-01  2.533513518247368e-01 
 	 8.129895241259500e-01  5.213545920932799e-01  2.593017990001437e-01 
 	 8.705449925964176e-01  4.092440187258565e-01  2.732594902330273e-01 
 	 9.022606004570801e-01  3.187822706189415e-01  2.903509476510470e-01 
 	 3.038916907744710e-01  9.146382222475424e-01  2.666210094536599e-01 
 	 4.450789904866534e-01  8.615287190490726e-01  2.442804914049536e-01 
 	 5.004262227032894e-01  8.322995791789755e-01  2.384344902261796e-01 
 	 7.016671265068101e-01  6.745826673004680e-01  2.293501004086596e-01 
 	 8.548999428617925e-01  4.585076118418239e-01  2.427279497256366e-01 
 	 8.925181172085876e-01  3.724927241240064e-01  2.542844488542602e-01 
 	 2.832190867174310e-01  9.275232979492812e-01  2.439005548993953e-01 
 	 3.452788689479033e-01  9.090028428909019e-01  2.334444993447367e-01 
 	 3.931836753836142e-01  8.910459287977607e-01  2.268121473483475e-01 
 	 6.475809994877710e-01  7.330544882066233e-01  2.080143418674420e-01 
 	 7.460823577631014e-01  6.324016986085819e-01  2.083967538893828e-01 
 	 8.046374364758193e-01  5.546787775335295e-01  2.118727202249769e-01 
 	 8.795925317472011e-01  4.199115163562921e-01  2.235873353432803e-01 
 	 9.236321133482271e-01  2.978494352036787e-01  2.412248601217079e-01 
 	 4.848750075599745e-01  8.526770850500147e-01  1.945199621486821e-01 
 	 5.834108409836419e-01  7.899704316346945e-01  1.886226597353935e-01 
 	 6.947552810727092e-01  6.947552810727091e-01  1.860919096660619e-01 
 	 8.612887384193840e-01  4.688815632372918e-01  1.957850574688974e-01 
 	 8.967196122780234e-01  3.933042207002770e-01  2.029919381041990e-01 
 	 9.374659624422613e-01  2.698600672988010e-01  2.198479323070634e-01 
 	 2.581481858229687e-01  9.460344042713767e-01  1.959041094291065e-01 
 	 3.116170294666160e-01  9.312857518961400e-01  1.886840620233814e-01 
 	 3.802334368493392e-01  9.069873021582975e-01  1.810982253511961e-01 
 	 5.111739356003406e-01  8.423136190091682e-01  1.709063333950401e-01 
 	 6.320178804348595e-01  7.569803657634508e-01  1.659340973376473e-01 
 	 7.427384551588164e-01  6.487824589546149e-01  1.655925969996795e-01 
 	 7.840076710745356e-01  5.978923984330087e-01  1.669031203791804e-01 
 	 8.423136190091685e-01  5.111739356003404e-01  1.709063333950401e-01 
 	 9.272775878822613e-01  3.242355569820233e-01  1.871565617332514e-01 
 	 9.480789778054747e-01  2.495226927707237e-01  1.971919816721087e-01 
 	 4.688842304665994e-01  8.700490260600646e-01  1.521915591341309e-01 
 	 5.957209384680789e-01  7.897243681751092e-01  1.464649643468906e-01 
 	 6.830838285733526e-01  7.158232194562352e-01  1.448916893023238e-01 
 	 8.700490260600647e-01  4.688842304665993e-01  1.521915591341309e-01 
 	 8.956880101945410e-01  4.165334009269150e-01  1.557013625695089e-01 
 	 9.631865398420549e-01  2.006837180348542e-01  1.788791066133680e-01 
 	 2.406614596753423e-01  9.590560559009210e-01  1.493102255932362e-01 
 	 3.884831673484766e-01  9.113051728791457e-01  1.363954199033311e-01 
 	 4.241030704059799e-01  8.956305753996507e-01  1.340986878441056e-01 
 	 6.487944223111036e-01  7.505112355274862e-01  1.256928117475597e-01 
 	 7.658464395260781e-01  6.305619841135884e-01  1.259794239388474e-01 
 	 9.113051728791458e-01  3.884831673484764e-01  1.363954199033311e-01 
 	 9.359961279895637e-01  3.223418930052169e-01  1.414459345557790e-01 
 	 9.561886930020381e-01  2.525628516246725e-01  1.480377970461185e-01 
 	 9.689380651322644e-01  1.927551207900840e-01  1.549338224757393e-01 
 	 2.111750457211071e-01  9.688376422351175e-01  1.294554867627748e-01 
 	 3.084093174096809e-01  9.435018749761130e-01  1.211936667134619e-01 
 	 5.120574211733699e-01  8.518372314495681e-01  1.103201184626491e-01 
 	 5.713433444630323e-01  8.135065389753662e-01  1.085075747683904e-01 
 	 7.030679017672241e-01  7.030679017672241e-01  1.067288668039994e-01 
 	 8.135065389753663e-01  5.713433444630324e-01  1.085075747683904e-01 
 	 9.759066768401982e-01  1.726073868511155e-01  1.334647822579069e-01 
 	 1.384192522673214e-01  9.837621777136095e-01  1.142457364715733e-01 
 	 1.716051116340375e-01  9.788778127162082e-01  1.111301643704418e-01 
 	 3.482393099459539e-01  9.321796804702920e-01  9.884546689995581e-02 
 	 4.657961650040378e-01  8.799193307781884e-01  9.367979499548514e-02 
 	 6.283386739894399e-01  7.727490890501744e-01  8.971820406872939e-02 
 	 7.727490890501745e-01  6.283386739894397e-01  8.971820406872939e-02 
 	 8.799193307781885e-01  4.657961650040376e-01  9.367979499548514e-02 
 	 9.089719139563920e-01  4.056363126778263e-01  9.606894126402277e-02 
 	 9.386984251617855e-01  3.299657793274086e-01  9.983912595590801e-02 
 	 9.549326527628328e-01  2.783948797940065e-01  1.029559109124864e-01 
 	 9.726018107400934e-01  2.057460659170479e-01  1.082325002240501e-01 
 	 9.851228665701496e-01  1.273831751388571e-01  1.153536494964698e-01 
 	 2.030344648786641e-01  9.751793069096913e-01  8.833077293089059e-02 
 	 2.650176707712973e-01  9.605197371875314e-01  8.466090391764076e-02 
 	 3.185561423416192e-01  9.443524097324999e-01  8.197871924375751e-02 
 	 4.175129450249743e-01  9.053147676047828e-01  7.802635640135337e-02 
 	 5.649830207081598e-01  8.217574916239020e-01  7.422136667749747e-02 
 	 7.415075302434161e-01  6.669600009827271e-01  7.301328428053377e-02 
 	 9.903116329587327e-01  1.002516611170507e-01  9.608576413746368e-02 
 	 7.790730299736023e-02  9.939377396728301e-01  7.757719892947373e-02 
 	 1.174139569268006e-01  9.902557948300464e-01  7.488273181651729e-02 
 	 1.487366465150427e-01  9.861816811219238e-01  7.295959020577945e-02 
 	 3.078884430043969e-01  9.491680574702503e-01  6.545766068597131e-02 
 	 3.888939866392062e-01  9.191413169633926e-01  6.277504764367089e-02 
 	 4.748452260271066e-01  8.779806228337456e-01  6.059733696899745e-02 
 	 6.463976310562439e-01  7.607813479887158e-01  5.815361654573411e-02 
 	 8.393952674194530e-01  5.402697377814208e-01  5.936493469565760e-02 
 	 8.658573255598672e-01  4.966623844216472e-01  6.014621912404845e-02 
 	 9.099348767588749e-01  4.100639426864437e-01  6.217783339953523e-02 
 	 9.550891856675419e-01  2.888318944365381e-01  6.618749260330195e-02 
 	 9.652227372259734e-01  2.525126744588167e-01  6.769355050265161e-02 
 	 9.766311043504744e-01  2.032025431118874e-01  7.000294628109942e-02 
 	 9.842989782565936e-01  1.610446551252707e-01  7.225053950392762e-02 
 	 1.747900688661259e-01  9.830842057322200e-01  5.471632540316780e-02 
 	 2.594393601431650e-01  9.643781088820361e-01  5.163411195724021e-02 
 	 5.368653749022796e-01  8.424346391479716e-01  4.560096484353869e-02 
 	 6.029064948637403e-01  7.965461325129330e-01  4.492234666407893e-02 
 	 6.866059302369809e-01  7.256665465450494e-01  4.450123356483360e-02 
 	 8.125725316934145e-01  5.811114896311549e-01  4.511449164087965e-02 
 	 8.930875199524557e-01  4.474245456242409e-01  4.696762372223626e-02 
 	 9.908749778383440e-01  1.221200208783658e-01  5.703927414097046e-02 
 	 9.951751609418460e-01  7.819187936025561e-02  5.926574935392458e-02 
 	 4.639502410179023e-02  9.979276311219076e-01  4.458637439860060e-02 
 	 6.316423764299868e-02  9.970376073900683e-01  4.388950367533134e-02 
 	 1.084502881373150e-01  9.932070066473432e-01  4.217080684025101e-02 
 	 1.626712106284162e-01  9.858534697858586e-01  4.038580621788820e-02 
 	 3.312040983498115e-01  9.428612808198095e-01  3.628292114916843e-02 
 	 6.447187006438351e-01  7.637187020278816e-01  3.273440411818639e-02 
 	 7.814167443450201e-01  6.231454628108739e-01  3.282687672397720e-02 
 	 8.449675931057904e-01  5.337699908986155e-01  3.345688893336266e-02 
 	 9.070399154170564e-01  4.196035978103466e-01  3.480535224404289e-02 
 	 9.350070243259030e-01  3.528089828447729e-01  3.588434317717123e-02 
 	 9.565046877689242e-01  2.893443868490874e-01  3.712961183474073e-02 
 	 9.722459843911593e-01  2.307724536281590e-01  3.849442143616364e-02 
 	 9.831319256284506e-01  1.784894264501022e-01  3.991417612338023e-02 
 	 9.881845854551298e-01  1.477241419758945e-01  4.085098464368966e-02 
 	 9.918250915792710e-01  1.205825498098416e-01  4.174729206939867e-02 
 	 6.542182261947399e-02  9.974047540430411e-01  3.006229760824934e-02 
 	 2.032410406386739e-01  9.787575952838825e-01  2.695642918156450e-02 
 	 2.411737244563212e-01  9.701258092777237e-01  2.628970911037067e-02 
 	 3.917279434716108e-01  9.197616808842355e-01  2.424187865055460e-02 
 	 4.611572201913804e-01  8.870053256711171e-01  2.357054298132090e-02 
 	 5.541495576001894e-01  8.321017448895383e-01  2.291187384960267e-02 
 	 7.069284522081010e-01  7.069284522081009e-01  2.245722416768270e-02 
 	 8.744847199237658e-01  4.844892804713878e-01  2.337972900120841e-02 
 	 9.959324312802812e-01  8.512297438041269e-02  2.954101482311542e-02 
 	 9.982806561478466e-01  5.006086251173462e-02  3.049002469015464e-02 
 	 3.910826847462719e-02  9.990486605473929e-01  1.929552267694784e-02 
 	 8.661733913543571e-02  9.960700966174897e-01  1.848781180999639e-02 
 	 1.130400016740931e-01  9.934258569795962e-01  1.808382442615177e-02 
 	 1.598801007895408e-01  9.869824266100886e-01  1.743682695869625e-02 
 	 2.969175247037194e-01  9.547697962676446e-01  1.595680603556415e-02 
 	 3.413560331413993e-01  9.398048531936918e-01  1.558513880437032e-02 
 	 5.051758512583407e-01  8.628931945391435e-01  1.458403659632363e-02 
 	 6.209960105116920e-01  7.836850869663468e-01  1.419997870111190e-02 
 	 8.177291563647665e-01  5.754250621357084e-01  1.431868349686347e-02 
 	 9.218373813843698e-01  3.872768118609251e-01  1.524838605379714e-02 
 	 9.547697962676447e-01  2.969175247037192e-01  1.595680603556415e-02 
 	 9.765960849682526e-01  2.144259504616991e-01  1.678089965641233e-02 
 	 9.840127338361165e-01  1.772639572348478e-01  1.721711688448234e-02 
 	 9.895139267999881e-01  1.433543443536442e-01  1.765561168027144e-02 
 	 9.977502187464350e-01  6.433561475619518e-02  1.885284236881665e-02 
 	 9.987392066333924e-01  4.639750904535687e-02  1.916424503307466e-02 
 	 9.995765610132241e-01  2.148401287652972e-02  1.962487869255341e-02 
 	 2.425473954431863e-02  9.996498757838027e-01  1.057513380837166e-02 
 	 4.648918495043820e-02  9.988651110284923e-01  1.035594769596732e-02 
 	 1.056855753191408e-01  9.943509463916055e-01  9.836390576864024e-03 
 	 2.285808712665794e-01  9.734833726330934e-01  8.994915114061622e-03 
 	 2.922605539230163e-01  9.562995426200273e-01  8.657563475855017e-03 
 	 3.837939528027512e-01  9.233817528718632e-01  8.266816516955783e-03 
 	 4.312621713003831e-01  9.021902695747772e-01  8.102906260695037e-03 
 	 5.741385836443724e-01  8.187214066336423e-01  7.755326599443407e-03 
 	 7.844117895517645e-01  6.201927171691861e-01  7.690122398252965e-03 
 	 8.346935828364869e-01  5.506594413841615e-01  7.797588477987349e-03 
 	 9.131949279813448e-01  4.074408887958835e-01  8.182031921657293e-03 
 	 9.413639123515785e-01  3.372870299996896e-01  8.452450302626844e-03 
 	 9.734833726330935e-01  2.285808712665790e-01  8.994915114061613e-03 
 	 9.943509463916056e-01  1.056855753191409e-01  9.836390576864152e-03 
 	 9.992259497773595e-01  3.792803367082106e-02  1.043865668555474e-02 
 	 9.998637486766573e-01  1.257281028296005e-02  1.069619202572599e-02 
 	 4.754190796977774e-03  9.999790381943768e-01  4.395547942511136e-03 
 	 1.296092865350592e-02  9.999064975800901e-01  4.360094672812136e-03 
 	 3.194892978310701e-02  9.994803331540392e-01  4.281299336064767e-03 
 	 7.334007327464491e-02  9.972984644432040e-01  4.123890310980178e-03 
 	 1.316347869559220e-01  9.912904865367886e-01  3.931178541596721e-03 
 	 1.850896712806013e-01  9.827143675495444e-01  3.779602748675793e-03 
 	 3.114859283978485e-01  9.502443288013006e-01  3.497426353198402e-03 
 	 5.256863385581479e-01  8.506724390933033e-01  3.205436066841176e-03 
 	 7.071033407439765e-01  7.071033407439765e-01  3.119457872080115e-03 
 	 7.473827429644014e-01  6.643863866719022e-01  3.124855846490563e-03 
 	 9.860459005422955e-01  1.664296031884216e-01  3.830039983894187e-03 
 	 9.912904865367886e-01  1.316347869559218e-01  3.931178541596721e-03 
 	 9.972984644432041e-01  7.334007327464444e-02  4.123890310980105e-03 
 	 9.996919826059644e-01  2.444068672458321e-02  4.311930633350657e-03 
 	 9.999064975800902e-01  1.296092865350575e-02  4.360094672812136e-03 
 	 2.102317140510475e-02  9.997786507178759e-01  8.220905152408009e-04 
 	 3.730775677897279e-02  9.993034954028956e-01  8.095428807778677e-04 
 	 7.025077879032308e-02  9.975290524335838e-01  7.858945918589912e-04 
 	 8.340114895796584e-02  9.965157522774385e-01  7.770556107153045e-04 
 	 1.639132243328655e-01  9.864744917282185e-01  7.294233039547958e-04 
 	 2.225047088523081e-01  9.749313634779284e-01  7.007464713131779e-04 
 	 2.650188529036041e-01  9.642429889147878e-01  6.825938283631600e-04 
 	 4.523025709493845e-01  8.918643364710255e-01  6.242144459185553e-04 
 	 5.489511107054885e-01  8.358542402565055e-01  6.058881337601504e-04 
 	 7.667111301614693e-01  6.419919689068675e-01  5.956052434739718e-04 
 	 8.511217709574014e-01  5.249679601984945e-01  6.097272904432749e-04 
 	 8.791321691133556e-01  4.765776392113022e-01  6.188972678829671e-04 
 	 9.147905676049656e-01  4.039279794546898e-01  6.362661681595393e-04 
 	 9.429923450225326e-01  3.328137687781401e-01  6.576781853618144e-04 
 	 9.578879191950282e-01  2.871415679749853e-01  6.739444235577683e-04 
 	 9.699123060852397e-01  2.434535690330950e-01  6.915413655823009e-04 
 	 9.864744917282188e-01  1.639132243328655e-01  7.294233039549239e-04 
 	 9.952268759046922e-01  9.758522345883493e-02  7.678798575956514e-04 
 	 9.993034954028958e-01  3.730775677897272e-02  8.095428807778677e-04 
 	 9.995910826685822e-01  2.858323427536677e-02  8.161910384029389e-04 
 	 9.999845851695486e-01  5.489336094485418e-03  8.346331695098111e-04 
 	 9.999989309472331e-01  1.198132986644968e-03  8.382014895962524e-04 
 	 5.700674279213954e-01  5.900453231720872e-01  5.717251474492197e-01 
 	 5.372647308056909e-01  5.946359604543986e-01  5.981259763350556e-01 
 	 5.313971096704626e-01  6.319734436352349e-01  5.641158377263493e-01 
 	 5.253247561872970e-01  5.442426446694532e-01  6.540900887950806e-01 
 	 5.166450042653196e-01  6.727577339755839e-01  5.295988774003636e-01 
 	 5.053331668038974e-01  5.182031386478146e-01  6.900028243590732e-01 
 	 4.867780442979303e-01  6.176759407608015e-01  6.176759407608015e-01 
 	 4.735953474130920e-01  5.866314808975746e-01  6.569406004568383e-01 
 	 4.630717178620682e-01  5.510791103004654e-01  6.941731760207395e-01 
 	 4.587259475028502e-01  6.761574580875304e-01  5.765254521356553e-01 
 	 4.521739839439408e-01  5.203602722254600e-01  7.244058774842388e-01 
 	 4.381286328701125e-01  6.584955792071359e-01  6.119043007072468e-01 
 	 4.533694999459152e-01  7.270085461433586e-01  5.156691481495773e-01 
 	 4.195261514820320e-01  6.218945731107298e-01  6.612449985883435e-01 
 	 4.450319066990279e-01  7.587959203505388e-01  4.755789663969659e-01 
 	 4.239597783467305e-01  4.749673385167547e-01  7.711446905001044e-01 
 	 4.024027710416980e-01  6.957475015307352e-01  5.949852300450007e-01 
 	 4.103703755381894e-01  7.383079598042736e-01  5.352546229322048e-01 
 	 4.165889910783665e-01  4.244220733982721e-01  8.039399953507851e-01 
 	 3.938281802842020e-01  5.136815522047348e-01  7.622536502625412e-01 
 	 3.842958367220632e-01  5.782541153453961e-01  7.196797120693362e-01 
 	 3.801387152515019e-01  6.458908233342698e-01  6.620570983680460e-01 
 	 3.952547572714799e-01  7.664198401216407e-01  5.063341836397995e-01 
 	 4.082767470723698e-01  7.932647885164944e-01  4.517090580228444e-01 
 	 3.831895479420283e-01  4.605140919624841e-01  8.006825472382626e-01 
 	 3.600812160634309e-01  6.856419646993511e-01  6.326425642347300e-01 
 	 3.971621332500672e-01  8.215914665058923e-01  4.089617366905528e-01 
 	 3.399675588630296e-01  6.154654501035117e-01  7.110726676294021e-01 
 	 3.385376162314934e-01  6.653541472014352e-01  6.653541472014352e-01 
 	 3.430714234696516e-01  7.431706619066983e-01  5.744557125485540e-01 
 	 3.630089597193489e-01  8.174683183241732e-01  4.471801020838522e-01 
 	 3.485850512997618e-01  4.046368398106189e-01  8.454333148619222e-01 
 	 3.277806456563999e-01  5.176000842107867e-01  7.903480253395084e-01 
 	 3.251012851167257e-01  7.770397601932361e-01  5.389975561116132e-01 
 	 3.106898411728181e-01  4.770644235405092e-01  8.221200389140084e-01 
 	 2.999616257994649e-01  5.692050111596141e-01  7.655250997312403e-01 
 	 2.973979742819007e-01  6.053407006316582e-01  7.383204460475107e-01 
 	 3.075865610009775e-01  8.101875443324004e-01  4.989856215365597e-01 
 	 3.273267033920643e-01  8.617482518679018e-01  3.876173108222836e-01 
 	 3.022957796686734e-01  3.859352742419889e-01  8.715912033116613e-01 
 	 2.827554103529006e-01  5.150070620438232e-01  8.092077013728629e-01 
 	 2.733696470990833e-01  6.920714450370173e-01  6.680614874465504e-01 
 	 2.742541008645120e-01  7.260784924705765e-01  6.305511168261088e-01 
 	 2.779824655839819e-01  7.760905706848955e-01  5.660469723634636e-01 
 	 3.146065924824218e-01  8.897910324456689e-01  3.305973541120223e-01 
 	 2.914689032411191e-01  3.138453854035573e-01  9.036298758365129e-01 
 	 2.817502477097135e-01  3.603246414351807e-01  8.892597768313394e-01 
 	 2.665647207979719e-01  4.560660992089721e-01  8.490859572376706e-01 
 	 2.533513518247370e-01  6.040994666176174e-01  7.555639793961122e-01 
 	 2.533513518247369e-01  7.555639793961123e-01  6.040994666176172e-01 
 	 2.681902201568697e-01  8.550430862136887e-01  4.438190245250649e-01 
 	 2.784110613550622e-01  8.827558931825176e-01  3.784564888685136e-01 
 	 2.678409903333526e-01  2.979672460193581e-01  9.162296241646459e-01 
 	 2.475204401415269e-01  4.192420803093153e-01  8.734813734763108e-01 
 	 2.384344902261797e-01  5.004262227032894e-01  8.322995791789753e-01 
 	 2.338030019415478e-01  5.587544873103394e-01  7.956944006298400e-01 
 	 2.295211257061627e-01  6.606421643446773e-01  7.147530927142296e-01 
 	 2.328757244798712e-01  7.853966825652150e-01  5.735163013930206e-01 
 	 2.397977494079705e-01  8.402917483847512e-01  4.862168415176197e-01 
 	 2.624257740481817e-01  9.084594679433939e-01  3.253215458883998e-01 
 	 2.190674201167354e-01  4.627605278489759e-01  8.589890332875820e-01 
 	 2.094808030739865e-01  6.015596344837165e-01  7.708721030776085e-01 
 	 2.077402476949369e-01  7.196334532339951e-01  6.625493811589909e-01 
 	 2.139426597712136e-01  8.247341512261085e-01  5.234903228631539e-01 
 	 2.220302154890563e-01  8.731933608405197e-01  4.338616576674197e-01 
 	 2.268121473483476e-01  8.910459287977608e-01  3.931836753836141e-01 
 	 2.412248601217079e-01  9.236321133482270e-01  2.978494352036787e-01 
 	 2.156234903172748e-01  2.962661668574766e-01  9.304476711771458e-01 
 	 2.045592559422496e-01  3.793388937213635e-01  9.023621858869117e-01 
 	 1.911825690773049e-01  5.338551744841433e-01  8.236794752557007e-01 
 	 1.860919096660621e-01  6.947552810727092e-01  6.947552810727091e-01 
 	 1.873916365558428e-01  7.649865801503426e-01  6.161817156803717e-01 
 	 2.170945560919202e-01  9.330680746248305e-01  2.867994453118131e-01 
 	 2.023049092911609e-01  2.175232018158693e-01  9.548593510818584e-01 
 	 1.768520306253193e-01  4.270786684009640e-01  8.867509065462298e-01 
 	 1.719561448640446e-01  4.939591417266027e-01  8.523118270610901e-01 
 	 1.669031203791805e-01  5.978923984330088e-01  7.840076710745354e-01 
 	 1.655925969996796e-01  6.487824589546151e-01  7.427384551588162e-01 
 	 1.655925969996797e-01  7.427384551588164e-01  6.487824589546149e-01 
 	 1.675275889692126e-01  7.967540062428818e-01  5.806182570933162e-01 
 	 1.719561448640445e-01  8.523118270610902e-01  4.939591417266027e-01 
 	 1.810982253511962e-01  9.069873021582976e-01  3.802334368493391e-01 
 	 1.995300309949352e-01  9.514271570928862e-01  2.344656296289689e-01 
 	 1.596650635633839e-01  3.672402585366880e-01  9.163196276339426e-01 
 	 1.448916893023239e-01  7.158232194562352e-01  6.830838285733525e-01 
 	 1.484485818445360e-01  8.276566101546643e-01  5.412462971842266e-01 
 	 1.557013625695089e-01  8.956880101945410e-01  4.165334009269150e-01 
 	 1.803171757100854e-01  9.648526137864037e-01  1.911678576892122e-01 
 	 1.528694183917975e-01  2.095226750368514e-01  9.657800937925545e-01 
 	 1.480377970461186e-01  2.525628516246725e-01  9.561886930020380e-01 
 	 1.427656267109801e-01  3.071177986321206e-01  9.409020318785486e-01 
 	 1.330268670999976e-01  4.423879138283626e-01  8.869029182092867e-01 
 	 1.259794239388475e-01  6.305619841135885e-01  7.658464395260780e-01 
 	 1.263466553331112e-01  7.806405498399256e-01  6.120758569260469e-01 
 	 1.320121745147464e-01  8.775661166261844e-01  4.609235259015600e-01 
 	 1.363954199033311e-01  9.113051728791457e-01  3.884831673484764e-01 
 	 1.401419095728460e-01  9.306062335685428e-01  3.381305712659637e-01 
 	 1.440931255577493e-01  9.453485559264394e-01  2.924949212803437e-01 
 	 1.493102255932362e-01  9.590560559009210e-01  2.406614596753420e-01 
 	 1.591931959770286e-01  9.740741490338597e-01  1.607391630517639e-01 
 	 1.325539032192357e-01  1.809791558316164e-01  9.745132158651421e-01 
 	 1.177323141078502e-01  3.595279158223819e-01  9.256774708067733e-01 
 	 1.110541887971738e-01  4.922974114630676e-01  8.633135153681800e-01 
 	 1.085075747683905e-01  5.713433444630323e-01  8.135065389753662e-01 
 	 1.067288668039995e-01  7.030679017672241e-01  7.030679017672241e-01 
 	 1.085075747683905e-01  8.135065389753662e-01  5.713433444630323e-01 
 	 1.305407373760092e-01  9.710030357891181e-01  2.002803544375845e-01 
 	 1.128200339376330e-01  1.531926648585847e-01  9.817350189210104e-01 
 	 1.050881241659121e-01  2.471531671781721e-01  9.632610228349782e-01 
 	 1.008590540524645e-01  3.122035483274727e-01  9.446461748334015e-01 
 	 9.606894126402292e-02  4.056363126778267e-01  9.089719139563918e-01 
 	 9.367979499548541e-02  4.657961650040379e-01  8.799193307781885e-01 
 	 9.000338614019002e-02  6.084986958583779e-01  7.884343521320929e-01 
 	 8.971820406872955e-02  7.727490890501745e-01  6.283386739894397e-01 
 	 9.522506125228788e-02  8.999557534304624e-01  4.254548502213915e-01 
 	 9.983912595590803e-02  9.386984251617855e-01  3.299657793274085e-01 
 	 1.029559109124865e-01  9.549326527628328e-01  2.783948797940065e-01 
 	 1.102048089429640e-01  9.770779904658534e-01  1.821359399818013e-01 
 	 9.009654331473262e-02  1.767467733682711e-01  9.801240691803469e-01 
 	 8.375101909443783e-02  2.822626044386738e-01  9.556744157589131e-01 
 	 7.950663040490710e-02  3.767818973456113e-01  9.228835774648385e-01 
 	 7.461996524375926e-02  5.439135837413451e-01  8.358168903585682e-01 
 	 7.293212257114798e-02  6.863200057266485e-01  7.236337162105150e-01 
 	 7.506908645992393e-02  8.491754776674810e-01  5.227481615331402e-01 
 	 8.557967302999733e-02  9.648612618037170e-01  2.484328179500805e-01 
 	 8.833077293089048e-02  9.751793069096915e-01  2.030344648786638e-01 
 	 9.387151700687112e-02  9.875102750527096e-01  1.265369312104206e-01 
 	 7.363862738797977e-02  1.373469747740226e-01  9.877819400438733e-01 
 	 6.108726426075529e-02  4.530994947998806e-01  8.893644888105380e-01 
 	 5.815361654573432e-02  6.463976310562439e-01  7.607813479887159e-01 
 	 5.815361654573427e-02  7.607813479887161e-01  6.463976310562438e-01 
 	 5.875078975984473e-02  8.100249510285590e-01  5.834448760712319e-01 
 	 6.059733696899759e-02  8.779806228337457e-01  4.748452260271064e-01 
 	 6.217783339953525e-02  9.099348767588747e-01  4.100639426864437e-01 
 	 6.340417266570082e-02  9.276478117575355e-01  3.680345747752971e-01 
 	 6.545766068597127e-02  9.491680574702505e-01  3.078884430043968e-01 
 	 7.543615422435683e-02  9.911851736627084e-01  1.089097706685012e-01 
 	 5.471632540316793e-02  1.747900688661258e-01  9.830842057322199e-01 
 	 5.286013734886633e-02  2.233375336141360e-01  9.733068128594466e-01 
 	 5.163411195724034e-02  2.594393601431649e-01  9.643781088820360e-01 
 	 4.988458815159140e-02  3.182723796513758e-01  9.466859142376614e-01 
 	 4.560096484353896e-02  5.368653749022796e-01  8.424346391479716e-01 
 	 4.448363322021281e-02  7.064068255529280e-01  7.064068255529279e-01 
 	 5.163411195724045e-02  9.643781088820362e-01  2.594393601431647e-01 
 	 5.532272392640071e-02  9.855227940492421e-01  1.602629671094923e-01 
 	 6.002730562041226e-02  9.961179034686022e-01  6.438823626463051e-02 
 	 4.447917578301329e-02  4.892043123199538e-02  9.978118030619498e-01 
 	 4.257273741645706e-02  9.731375022517973e-02  9.943427960446944e-01 
 	 4.085098464368998e-02  1.477241419758950e-01  9.881845854551297e-01 
 	 3.712961183474087e-02  2.893443868490875e-01  9.565046877689242e-01 
 	 3.448846416915562e-02  4.423214777112777e-01  8.961932024929471e-01 
 	 3.294555778832689e-02  6.012073213462281e-01  7.984136440352890e-01 
 	 3.326081343969767e-02  8.302077625594512e-01  5.564609503598250e-01 
 	 3.419450570460291e-02  8.845656490608331e-01  4.651605618291440e-01 
 	 3.550436622978333e-02  9.264317636534942e-01  3.747847746007003e-01 
 	 3.669858370894717e-02  9.500182627124090e-01  3.100298606048351e-01 
 	 3.896529723679871e-02  9.763658538194333e-01  2.125827488454717e-01 
 	 4.085098464368966e-02  9.881845854551298e-01  1.477241419758944e-01 
 	 4.257273741645687e-02  9.943427960446946e-01  9.731375022517920e-02 
 	 3.103692023219782e-02  3.138562241274086e-02  9.990253511739655e-01 
 	 2.981204927710831e-02  7.473948998416552e-02  9.967573678457592e-01 
 	 2.662066273059974e-02  2.218525238288891e-01  9.747167783446308e-01 
 	 2.320613413881509e-02  5.078079626481010e-01  8.611576791793220e-01 
 	 2.249450414814951e-02  6.654275358157486e-01  7.461234427769372e-01 
 	 2.246654673239750e-02  7.268353672763825e-01  6.864441733703673e-01 
 	 2.260617579242020e-02  7.826960903232940e-01  6.219934010973687e-01 
 	 2.476586084470306e-02  9.377011160852577e-01  3.465591854634397e-01 
 	 2.564946183581083e-02  9.591482348146421e-01  2.817388307626225e-01 
 	 2.863098218471950e-02  9.920643666633963e-01  1.224277715875471e-01 
 	 3.028911629859136e-02  9.979037469676029e-01  5.718986992351707e-02 
 	 3.080531641183604e-02  9.987576879765182e-01  3.916775700198282e-02 
 	 1.962487869255371e-02  2.148401287653002e-02  9.995765610132241e-01 
 	 1.901613410186337e-02  5.481272528313483e-02  9.983155572216911e-01 
 	 1.808382442615208e-02  1.130400016740932e-01  9.934258569795962e-01 
 	 1.765561168027170e-02  1.433543443536446e-01  9.895139267999881e-01 
 	 1.699800356128494e-02  1.954616046949620e-01  9.805640361368557e-01 
 	 1.615404637280935e-02  2.754088424265717e-01  9.611914566302808e-01 
 	 1.576692202760114e-02  3.189201756097473e-01  9.476504238160945e-01 
 	 1.541210601874018e-02  3.641627812011751e-01  9.312077833522936e-01 
 	 1.495074477062989e-02  4.341675204089319e-01  9.007080767111857e-01 
 	 1.431868349686351e-02  5.754250621357088e-01  8.177291563647663e-01 
 	 1.419997870111204e-02  6.209960105116920e-01  7.836850869663468e-01 
 	 1.458403659632377e-02  8.628931945391435e-01  5.051758512583405e-01 
 	 1.509446184795430e-02  9.116755355522967e-01  4.106335045961952e-01 
 	 1.656710342195808e-02  9.720696167925821e-01  2.341072215736383e-01 
 	 1.721711688448236e-02  9.840127338361165e-01  1.772639572348479e-01 
 	 1.765561168027134e-02  9.895139267999882e-01  1.433543443536443e-01 
 	 1.867612655826088e-02  9.970127542427623e-01  7.494511441075477e-02 
 	 1.940845486276332e-02  9.992681872435186e-01  3.296061047511654e-02 
 	 1.066780352340198e-02  1.527596011995142e-02  9.998264064378375e-01 
 	 1.035594769596744e-02  4.648918495043813e-02  9.988651110284923e-01 
 	 1.016625657982498e-02  6.696442146226340e-02  9.977035699471950e-01 
 	 1.006130069192437e-02  7.883154650720205e-02  9.968371770272564e-01 
 	 8.029622913902464e-03  4.551912638581032e-01  8.903574779059943e-01 
 	 7.846224257425358e-03  5.269609537850209e-01  8.498532755428334e-01 
 	 7.641083308239860e-03  6.861474011208910e-01  7.274224067080445e-01 
 	 7.719491048276391e-03  8.019536556008875e-01  5.973363740191358e-01 
 	 7.962334613223505e-03  8.776906060112925e-01  4.791615607986905e-01 
 	 8.357041809867361e-03  9.327652436451547e-01  3.603875137956133e-01 
 	 8.552740718575376e-03  9.492000636197466e-01  3.145569739339280e-01 
 	 9.718512019642203e-03  9.926526467163345e-01  1.206079329529376e-01 
 	 1.016625657982473e-02  9.977035699471951e-01  6.696442146226288e-02 
 	 1.057513380837161e-02  9.996498757838026e-01  2.425473954431844e-02 
 	 1.069619202572587e-02  9.998637486766572e-01  1.257281028296004e-02 
 	 4.360094672812440e-03  1.296092865350599e-02  9.999064975800901e-01 
 	 4.030211932437984e-03  1.005009258202404e-01  9.949288021265915e-01 
 	 3.880681935346593e-03  1.485959044015631e-01  9.888903870009043e-01 
 	 3.779602748675932e-03  1.850896712806014e-01  9.827143675495444e-01 
 	 3.680606850991737e-03  2.246904569266966e-01  9.744232405373349e-01 
 	 3.540820017039616e-03  2.889828195783122e-01  9.573277351994851e-01 
 	 3.344115353860645e-03  4.051919459040125e-01  9.142255213387012e-01 
 	 3.153145982283503e-03  5.965933695318436e-01  8.025374814306528e-01 
 	 3.680606850991609e-03  9.744232405373351e-01  2.246904569266961e-01 
 	 3.779602748675748e-03  9.827143675495444e-01  1.850896712806011e-01 
 	 4.030211932437625e-03  9.949288021265914e-01  1.005009258202403e-01 
 	 4.167641411093908e-03  9.981085900749201e-01  6.133411109426408e-02 
 	 4.395547942511193e-03  9.999790381943769e-01  4.754190796977479e-03 
 	 8.369203350472870e-04  2.732494043968406e-03  9.999959165119888e-01 
 	 8.271707997266303e-04  1.464495226993735e-02  9.998924147934513e-01 
 	 8.095428807780538e-04  3.730775677897279e-02  9.993034954028958e-01 
 	 7.943120325849593e-04  5.816618702692049e-02  9.983065980725280e-01 
 	 7.678798575957129e-04  9.758522345883487e-02  9.952268759046922e-01 
 	 7.584504134748716e-04  1.127679494729482e-01  9.936210617356281e-01 
 	 6.915413655825539e-04  2.434535690330951e-01  9.699123060852396e-01 
 	 6.739444235579678e-04  2.871415679749855e-01  9.578879191950281e-01 
 	 6.576781853620159e-04  3.328137687781404e-01  9.429923450225324e-01 
 	 6.362661681597434e-04  4.039279794546901e-01  9.147905676049654e-01 
 	 6.242144459186415e-04  4.523025709493845e-01  8.918643364710254e-01 
 	 5.956052434740622e-04  6.419919689068677e-01  7.667111301614692e-01 
 	 5.932836045450342e-04  7.071066567408925e-01  7.071066567408925e-01 
 	 5.956052434742373e-04  7.667111301614694e-01  6.419919689068676e-01 
 	 6.025530258808640e-04  8.197600850459709e-01  5.727067660638153e-01 
 	 6.140656916809157e-04  8.655503089670863e-01  5.008216105264506e-01 
 	 6.242144459185775e-04  8.918643364710256e-01  4.523025709493842e-01 
 	 6.429755100239294e-04  9.250013565012434e-01  3.799632575043976e-01 
 	 6.576781853617766e-04  9.429923450225326e-01  3.328137687781401e-01 
 	 6.915413655824343e-04  9.699123060852397e-01  2.434535690330950e-01 
 	 7.101634358368003e-04  9.793379819018356e-01  2.022291098539824e-01 
 	 7.294233039549337e-04  9.864744917282187e-01  1.639132243328655e-01 
 	 7.488475486858426e-04  9.916558443729182e-01  1.289113088459796e-01 
 	 7.678798575955464e-04  9.952268759046923e-01  9.758522345883493e-02 
 	 7.858945918589869e-04  9.975290524335838e-01  7.025077879032267e-02 
 	 8.022227977149847e-04  9.988862483544432e-01  4.717646963231221e-02 
 	 8.161910384028852e-04  9.995910826685822e-01  2.858323427536676e-02 
 	 8.313693427864533e-04  9.999548781969937e-01  9.463107050610160e-03 
 	 8.346331695097475e-04  9.999845851695486e-01  5.489336094485345e-03 
 	 ]; 
 

 	  
 

 	 case 14
 	 pts=[
 	 5.973945068357364e-01  5.573021001602289e-01  5.766577601658420e-01 
 	 5.791876759445106e-01  5.304784394298280e-01  6.189784013470023e-01 
 	 6.565164721624530e-01  5.321795250779635e-01  5.345756025738178e-01 
 	 6.357878661572836e-01  5.211526715181469e-01  5.693625226660660e-01 
 	 5.682960330966125e-01  4.955000154440186e-01  6.569013270359797e-01 
 	 6.992748768959421e-01  4.943303121838584e-01  5.163837613620067e-01 
 	 6.721076197024138e-01  4.820989107575308e-01  5.620071065247823e-01 
 	 6.260025620583269e-01  4.761111621720683e-01  6.176074429211269e-01 
 	 6.508646357186109e-01  4.612215518380416e-01  6.030339178611669e-01 
 	 5.999222412176819e-01  4.450328673592934e-01  6.648601743692573e-01 
 	 5.715725815087352e-01  4.482857086850889e-01  6.872733862562611e-01 
 	 5.166790340978424e-01  4.595881820365654e-01  7.223721192405238e-01 
 	 7.361573448268277e-01  4.421503714344530e-01  5.124211282703812e-01 
 	 6.997364911705665e-01  4.310888456535970e-01  5.696764433231840e-01 
 	 7.649505507604524e-01  4.314684881751625e-01  4.782108307045337e-01 
 	 6.525105480106492e-01  4.076394310067773e-01  6.387958038554363e-01 
 	 5.816499482341323e-01  4.113087781972117e-01  7.017894461283585e-01 
 	 5.334696333387728e-01  4.185111228907656e-01  7.350228502040638e-01 
 	 4.782108307045339e-01  4.314684881751626e-01  7.649505507604523e-01 
 	 7.911966727335945e-01  4.199280108215992e-01  4.445990224716022e-01 
 	 7.497767368623944e-01  4.000429152865499e-01  5.270678426815831e-01 
 	 6.283740894088002e-01  3.889166625579052e-01  6.737134653133195e-01 
 	 4.413258782758076e-01  4.209537312897248e-01  7.924830757040463e-01 
 	 8.159826042899494e-01  4.078550277909047e-01  4.096665299995500e-01 
 	 6.655344645119196e-01  3.687504029975227e-01  6.489121796021377e-01 
 	 5.968411021513041e-01  3.712210896161148e-01  7.113196197259295e-01 
 	 5.122929661536519e-01  3.822186222675591e-01  7.690675143453806e-01 
 	 8.139050422060462e-01  3.746726703584406e-01  4.440483896582098e-01 
 	 7.839028078208040e-01  3.624137725987099e-01  5.041355426087613e-01 
 	 7.498470118621554e-01  3.546559010705616e-01  5.585236348062852e-01 
 	 7.215414675585953e-01  3.509890263547538e-01  5.968120424153075e-01 
 	 4.505324300420007e-01  3.731459803725938e-01  8.110379811156970e-01 
 	 8.125204923065884e-01  3.466908890020180e-01  4.686319206635945e-01 
 	 6.966571351942441e-01  3.280961231749981e-01  6.379825780853934e-01 
 	 6.581955789742998e-01  3.276525663605819e-01  6.778070341741893e-01 
 	 5.964691247797476e-01  3.302760717760360e-01  7.315342094507084e-01 
 	 5.548016890867506e-01  3.340405279809406e-01  7.619790098504701e-01 
 	 4.298221005718794e-01  3.546975869250978e-01  8.303267933106157e-01 
 	 8.542792492032742e-01  3.387807293797479e-01  3.942519267950583e-01 
 	 7.737849948201937e-01  3.130094696129317e-01  5.507103174299025e-01 
 	 7.498519229112480e-01  3.099974763707961e-01  5.844858067994820e-01 
 	 4.966345586271970e-01  3.196353605063772e-01  8.069618029938762e-01 
 	 4.076830846767928e-01  3.357148840299235e-01  8.491701944305335e-01 
 	 8.507014844074851e-01  3.080379834932904e-01  4.259337802432306e-01 
 	 7.210803530664900e-01  2.859914100399804e-01  6.310721335987273e-01 
 	 6.190571404442772e-01  2.864942483305014e-01  7.312245226594193e-01 
 	 8.967070876230787e-01  3.050463284339140e-01  3.207228344155199e-01 
 	 8.689584428819306e-01  2.881954101802717e-01  4.023116082034367e-01 
 	 8.195056337089301e-01  2.739207827310160e-01  5.033665871979908e-01 
 	 7.494189235004023e-01  2.655883459687231e-01  6.064932873372104e-01 
 	 6.940358929616531e-01  2.636425834974154e-01  6.699304198554721e-01 
 	 5.544198404955516e-01  2.690332732136375e-01  7.875530067042112e-01 
 	 4.669613006942331e-01  2.783287742173720e-01  8.393332098139601e-01 
 	 3.342597485845537e-01  3.018543831969628e-01  8.928350081739470e-01 
 	 8.899635484812489e-01  2.697398525433512e-01  3.677027254788233e-01 
 	 8.383907601974954e-01  2.536495848322821e-01  4.824549940977673e-01 
 	 6.057082634996757e-01  2.440425852271257e-01  7.573379140937477e-01 
 	 5.226768748428307e-01  2.496844201799215e-01  8.151481919405503e-01 
 	 3.980443309628635e-01  2.647375635613934e-01  8.783363439069931e-01 
 	 2.961980103567863e-01  2.840998540633473e-01  9.118958337342405e-01 
 	 9.165711317225785e-01  2.553797948022202e-01  3.076987502405030e-01 
 	 9.062156157403392e-01  2.493783115239125e-01  3.414435759094619e-01 
 	 8.698454817833912e-01  2.363952823884050e-01  4.329966608249151e-01 
 	 7.867365149347031e-01  2.240530582423921e-01  5.751920402444987e-01 
 	 7.288212797850403e-01  2.211616683624212e-01  6.480023600108619e-01 
 	 6.480023600108619e-01  2.211616683624211e-01  7.288212797850402e-01 
 	 5.604373379296483e-01  2.249277334347821e-01  7.970680679755153e-01 
 	 4.598124272876197e-01  2.333863415364763e-01  8.567983119124867e-01 
 	 3.321724736947166e-01  2.509546194417516e-01  9.092212198911651e-01 
 	 8.927378281615648e-01  2.177686924903683e-01  3.944565460737189e-01 
 	 8.438497937557211e-01  2.078354615636550e-01  4.946937906372480e-01 
 	 8.054753333874838e-01  2.036143723262420e-01  5.565524905042762e-01 
 	 7.069429336165695e-01  1.995826095518247e-01  6.785266911287149e-01 
 	 4.946937906372480e-01  2.078354615636550e-01  8.438497937557212e-01 
 	 9.505555890336865e-01  2.194696760529149e-01  2.197205803971264e-01 
 	 9.324140301800774e-01  2.068299863230120e-01  2.963535609385661e-01 
 	 9.034061060407595e-01  1.961508084851326e-01  3.812902672491142e-01 
 	 7.903435915328624e-01  1.811252388465751e-01  5.852782715731956e-01 
 	 7.523372570161297e-01  1.795396338685041e-01  6.338408093329189e-01 
 	 6.338408093329189e-01  1.795396338685041e-01  7.523372570161296e-01 
 	 4.399959994665018e-01  1.904145155785513e-01  8.775795307038901e-01 
 	 3.812902672491142e-01  1.961508084851327e-01  9.034061060407595e-01 
 	 3.295215872472677e-01  2.022919696669004e-01  9.222220353831972e-01 
 	 2.864968954610522e-01  2.082785537344176e-01  9.351682056964288e-01 
 	 2.245835283224960e-01  2.185657199177501e-01  9.496269082555813e-01 
 	 9.594132068040617e-01  1.962411874220011e-01  2.025233195687593e-01 
 	 8.867915705801866e-01  1.694438018739010e-01  4.299878002390812e-01 
 	 8.204833463248964e-01  1.621328303376653e-01  5.481970665100260e-01 
 	 7.285076585323231e-01  1.586877090804720e-01  6.664043835739254e-01 
 	 6.664043835739254e-01  1.586877090804720e-01  7.285076585323232e-01 
 	 5.826218208089022e-01  1.607169364494464e-01  7.966943455652388e-01 
 	 5.481970665100260e-01  1.621328303376653e-01  8.204833463248965e-01 
 	 9.541654343848393e-01  1.648498222169797e-01  2.497856279697079e-01 
 	 9.275195267906681e-01  1.553951464225011e-01  3.399409888353341e-01 
 	 9.096515506898475e-01  1.514571244663617e-01  3.867748644572666e-01 
 	 8.694024195222029e-01  1.457310286522460e-01  4.721248777780069e-01 
 	 7.757181815167519e-01  1.399452089599325e-01  6.153670785421531e-01 
 	 7.002523890977321e-01  1.388999032607189e-01  7.002523890977320e-01 
 	 6.153670785421532e-01  1.399452089599325e-01  7.757181815167518e-01 
 	 4.721248777780068e-01  1.457310286522459e-01  8.694024195222029e-01 
 	 4.032257216245962e-01  1.502131658245127e-01  9.026876659361759e-01 
 	 3.399409888353341e-01  1.553951464225012e-01  9.275195267906681e-01 
 	 2.607625036176168e-01  1.635505610477920e-01  9.514484382708422e-01 
 	 2.130107325255811e-01  1.695454592162314e-01  9.622269821035329e-01 
 	 1.752501367660002e-01  1.749776845230606e-01  9.688499365136206e-01 
 	 9.644157207423800e-01  1.449987226004199e-01  2.210829890091104e-01 
 	 8.206396559923276e-01  1.224865484041117e-01  5.581644923074573e-01 
 	 5.581644923074572e-01  1.224865484041118e-01  8.206396559923276e-01 
 	 3.754444847516247e-01  1.315100635791318e-01  9.174674610290001e-01 
 	 3.110792730092296e-01  1.363675255700538e-01  9.405496179755484e-01 
 	 2.685427059121980e-01  1.401526395386471e-01  9.530173412544521e-01 
 	 9.749427312797208e-01  1.265664507852234e-01  1.829415323552031e-01 
 	 9.521925356316073e-01  1.178986368298221e-01  2.818320182681875e-01 
 	 9.370619430934783e-01  1.145295187545717e-01  3.298452730292203e-01 
 	 9.012391671598586e-01  1.094495923694715e-01  4.192716903240201e-01 
 	 7.532747524137008e-01  1.024930490130642e-01  6.496709338427288e-01 
 	 6.496709338427288e-01  1.024930490130642e-01  7.532747524137008e-01 
 	 4.572842721673590e-01  1.077123223031940e-01  8.827735553653733e-01 
 	 4.192716903240200e-01  1.094495923694715e-01  9.012391671598587e-01 
 	 1.587187926848887e-01  1.291135400123705e-01  9.788452577573868e-01 
 	 9.850392477553261e-01  1.097064790550906e-01  1.328990926792056e-01 
 	 9.692968458281828e-01  1.021336273259041e-01  2.236791157814907e-01 
 	 8.430457550775758e-01  8.770032821090117e-02  5.306434841561520e-01 
 	 8.022090802914839e-01  8.640572095929253e-02  5.907576854205084e-01 
 	 7.045262501486369e-01  8.535529100765057e-02  7.045262501486368e-01 
 	 6.104757113057973e-01  8.608609442024379e-02  7.873427400142518e-01 
 	 5.708461049146836e-01  8.678189104261737e-02  8.164579768064009e-01 
 	 5.104556647341558e-01  8.824038307329167e-02  8.553646293458069e-01 
 	 3.538193201606675e-01  9.426420203233726e-02  9.305515294148142e-01 
 	 2.236791157814905e-01  1.021336273259041e-01  9.692968458281827e-01 
 	 1.183335239968946e-01  1.111258440865809e-01  9.867361470395828e-01 
 	 9.851002146011206e-01  8.809744394705281e-02  1.477037831703108e-01 
 	 9.743313568078348e-01  8.405303575109066e-02  2.088384407192063e-01 
 	 9.286271858835282e-01  7.652502827826441e-02  3.630364577904679e-01 
 	 6.678565728635423e-01  6.981028337050110e-02  7.410088544806293e-01 
 	 3.065563131642933e-01  7.889927867335463e-02  9.485768976123864e-01 
 	 2.547792540896135e-01  8.144968237269484e-02  9.635629096882712e-01 
 	 2.088384407192062e-01  8.405303575109065e-02  9.743313568078349e-01 
 	 1.696749851479622e-01  8.656057693548970e-02  9.816912273905855e-01 
 	 9.900147252260419e-01  7.125191030560714e-02  1.216306257215106e-01 
 	 9.811953290378237e-01  6.797703058354856e-02  1.806511820813806e-01 
 	 9.531158600483965e-01  6.296607674671881e-02  2.959821455820125e-01 
 	 9.331580243472387e-01  6.099742779359602e-02  3.542533209426885e-01 
 	 9.074477812902625e-01  5.925910593066618e-02  4.159650016475881e-01 
 	 8.755500595353668e-01  5.780609435943535e-02  4.796566987987592e-01 
 	 8.231350630950107e-01  5.637433821765320e-02  5.650403542173730e-01 
 	 7.766292794888660e-01  5.570759550462904e-02  6.274899409900510e-01 
 	 7.060215342201192e-01  5.538218517662707e-02  7.060215342201192e-01 
 	 6.069309322222251e-01  5.589003804182870e-02  7.927869494129832e-01 
 	 5.010656853034234e-01  5.739197619219331e-02  8.635041054217202e-01 
 	 4.370498868322090e-01  5.874091540165538e-02  8.975170757582994e-01 
 	 3.542533209426883e-01  6.099742779359590e-02  9.331580243472387e-01 
 	 1.806511820813803e-01  6.797703058354854e-02  9.811953290378238e-01 
 	 1.316644530856163e-01  7.065498384376286e-02  9.887731514618017e-01 
 	 9.715545854243553e-02  7.278411681809725e-02  9.926042963912752e-01 
 	 7.461370530597895e-02  7.429791771357619e-02  9.944408551562728e-01 
 	 9.964456906513749e-01  5.744465527797823e-02  6.161247570337183e-02 
 	 9.937122387397358e-01  5.562164630680463e-02  9.717108129985448e-02 
 	 9.886321950541294e-01  5.364373343438818e-02  1.404590074209351e-01 
 	 9.672352087900935e-01  4.963040056021280e-02  2.489836826320494e-01 
 	 8.537879546675401e-01  4.377796137044605e-02  5.187770412835038e-01 
 	 5.623675325489641e-01  4.327145188508522e-02  8.257544064590551e-01 
 	 4.530070240707295e-01  4.476111968990001e-02  8.903825460478704e-01 
 	 3.881602152633385e-01  4.599372077851881e-02  9.204434936136310e-01 
 	 2.673486535516205e-01  4.906361660450758e-02  9.623499669921651e-01 
 	 9.978365180314137e-01  4.238902528347317e-02  5.025389356518935e-02 
 	 9.956671680363008e-01  4.112312881415666e-02  8.340131156706523e-02 
 	 9.909907346439306e-01  3.960323541963263e-02  1.279411880286396e-01 
 	 9.816431039155231e-01  3.786317559247697e-02  1.869309938697989e-01 
 	 9.702364352080713e-01  3.653748638289857e-02  2.393872842979623e-01 
 	 9.540306779423362e-01  3.527425376149195e-02  2.976259272416573e-01 
 	 9.401492717395991e-01  3.449450458852345e-02  3.390125012454465e-01 
 	 9.142116649514852e-01  3.344942882387776e-02  4.038541412168381e-01 
 	 8.933019052530333e-01  3.284887600443502e-02  4.482551253656181e-01 
 	 8.279339600539692e-01  3.172680681475223e-02  5.599274663013878e-01 
 	 7.799384076705423e-01  3.133068287435795e-02  6.250715707428753e-01 
 	 6.870384861348794e-01  3.114970436103367e-02  7.259530387619528e-01 
 	 5.154382316190625e-01  3.210800314816081e-02  8.563249999382544e-01 
 	 3.603143667415207e-01  3.412825972190281e-02  9.322064251055189e-01 
 	 2.976259272416570e-01  3.527425376149182e-02  9.540306779423363e-01 
 	 2.393872842979620e-01  3.653748638289855e-02  9.702364352080713e-01 
 	 1.709350073313076e-01  3.830713416893906e-02  9.845373465442581e-01 
 	 1.279411880286396e-01  3.960323541963269e-02  9.909907346439307e-01 
 	 9.308922386366227e-02  4.077578072067794e-02  9.948224626068111e-01 
 	 6.039785454278081e-02  4.198837236039393e-02  9.972908681789651e-01 
 	 9.984302282588670e-01  2.914841169124180e-02  4.782728713636810e-02 
 	 9.970381466298357e-01  2.852588545517770e-02  7.142274164396339e-02 
 	 9.865856752708017e-01  2.650890047244003e-02  1.610775699661455e-01 
 	 9.427065611237488e-01  2.379898815113432e-02  3.327731175699412e-01 
 	 7.264105380422595e-01  2.143987055928866e-02  6.869265333145576e-01 
 	 6.454063108385237e-01  2.150777164180863e-02  7.635365804523125e-01 
 	 6.022194406339956e-01  2.164327991217425e-02  7.980371631428708e-01 
 	 2.124785822083685e-01  2.555984875697391e-02  9.768313806559668e-01 
 	 1.610775699661454e-01  2.650890047244002e-02  9.865856752708017e-01 
 	 1.170661887325376e-01  2.743555178611785e-02  9.927450820597548e-01 
 	 8.135531654919546e-02  2.827635002028453e-02  9.962839758315449e-01 
 	 4.782728713636805e-02  2.914841169124190e-02  9.984302282588670e-01 
 	 9.993329408891358e-01  1.853842894368093e-02  3.146426395406585e-02 
 	 9.984641990674218e-01  1.817930750184506e-02  5.233312487713084e-02 
 	 9.953342611725188e-01  1.751101910168886e-02  9.488452321731090e-02 
 	 9.785818857047013e-01  1.610668671943095e-02  2.052268686443204e-01 
 	 9.697168564034531e-01  1.570810915755634e-02  2.437262269713687e-01 
 	 9.084999288264377e-01  1.435792971957120e-02  4.176382755166551e-01 
 	 8.733157592124775e-01  1.399387478134418e-02  4.869535462235983e-01 
 	 8.154837998061473e-01  1.365085734305315e-02  5.786188956018694e-01 
 	 6.867859906423318e-01  1.346151211117863e-02  7.267350210008539e-01 
 	 5.100712713110543e-01  1.389252411039560e-02  8.600199392787162e-01 
 	 4.406759254064220e-01  1.422680171010588e-02  8.975535231284512e-01 
 	 3.947497575074910e-01  1.449846072061100e-02  9.186742750205373e-01 
 	 3.058968009877039e-01  1.514677671517127e-02  9.519441802441095e-01 
 	 2.639121954449296e-01  1.551522917466351e-02  9.644219153249759e-01 
 	 1.370352237319779e-01  1.692369001229721e-02  9.904215951669745e-01 
 	 8.273026285862096e-02  1.769368770230644e-02  9.964148920117747e-01 
 	 2.669755065273949e-02  1.862360811604779e-02  9.994700605870513e-01 
 	 9.996813086679808e-01  1.009598874032773e-02  2.313767730841702e-02 
 	 9.992953883859163e-01  9.971338883008218e-03  3.618423899325568e-02 
 	 9.914207142252366e-01  9.197400179035437e-03  1.303854870569131e-01 
 	 9.865235741785414e-01  8.970930843327739e-03  1.633730699650344e-01 
 	 9.599481603794067e-01  8.314475358112583e-03  2.800542784599306e-01 
 	 9.461818295489693e-01  8.118638111151636e-03  3.235336661718302e-01 
 	 9.201373555231254e-01  7.857462469850217e-03  3.915169309933409e-01 
 	 8.989519641135324e-01  7.708033229841768e-03  4.379793972781712e-01 
 	 8.470745931653526e-01  7.474332094889292e-03  5.314214598353058e-01 
 	 7.827286298701649e-01  7.332334363039508e-03  6.223199569790150e-01 
 	 6.442159120035809e-01  7.311535517715340e-03  7.648087343707365e-01 
 	 5.774234542732484e-01  7.391638148708640e-03  8.164113657590936e-01 
 	 3.458854637659576e-01  8.026942338379219e-03  9.382424069248335e-01 
 	 2.385862526000469e-01  8.524420770964058e-03  9.710838966437381e-01 
 	 1.633730699650343e-01  8.970930843327786e-03  9.865235741785414e-01 
 	 6.390716137085979e-02  9.721706593010138e-03  9.979084943753300e-01 
 	 3.618423899325551e-02  9.971338883008257e-03  9.992953883859161e-01 
 	 2.313767730841721e-02  1.009598874032791e-02  9.996813086679808e-01 
 	 1.199512585049791e-02  1.020632877650808e-02  9.998759662121780e-01 
 	 9.999543416065945e-01  4.175506252706519e-03  8.595338833095933e-03 
 	 9.995275293668212e-01  4.088235877983601e-03  3.046316407178326e-02 
 	 9.975413619266802e-01  3.944004085437883e-03  6.996910802088402e-02 
 	 9.920607387707721e-01  3.766072049904950e-03  1.257032509162151e-01 
 	 9.719961769145581e-01  3.486895162822847e-03  2.349707931331177e-01 
 	 8.328313594245326e-01  3.034654376072692e-03  5.535184889702447e-01 
 	 7.270909445163740e-01  2.975976198141507e-03  6.865347055815570e-01 
 	 5.067939812796642e-01  3.073524356094057e-03  8.620617228405051e-01 
 	 4.360803002365696e-01  3.149327971260009e-03  8.999022466239945e-01 
 	 2.985279521848516e-01  3.358648978338068e-03  9.543949817771252e-01 
 	 2.556152783826746e-01  3.442781970839285e-03  9.667724534292694e-01 
 	 1.103510527240070e-01  3.812367615585249e-03  9.938853611035163e-01 
 	 8.245126237955526e-02  3.901713317275128e-03  9.965874602688957e-01 
 	 5.850457554590469e-02  3.984187763422657e-03  9.982791898502439e-01 
 	 2.330231738520078e-02  4.116195288149933e-03  9.997199902676894e-01 
 	 8.595338833095529e-03  4.175506252706493e-03  9.999543416065945e-01 
 	 9.999962907462047e-01  7.981134119669908e-04  2.604133025323016e-03 
 	 9.999590242612895e-01  7.930656127956097e-04  9.017807125010083e-03 
 	 9.999022918582883e-01  7.892438410881779e-04  1.395649779500445e-02 
 	 9.984602673655109e-01  7.592165620284390e-04  5.546636893293645e-02 
 	 9.941907719800614e-01  7.261926531260666e-04  1.076298357980732e-01 
 	 9.923974618446076e-01  7.173011061676127e-04  1.230721869615698e-01 
 	 9.876637680084692e-01  6.992472015922244e-04  1.565879702169480e-01 
 	 9.811328283515580e-01  6.812475288737995e-04  1.933336727853600e-01 
 	 9.724907371503000e-01  6.637380317253924e-04  2.329406053239566e-01 
 	 9.549333583311178e-01  6.391633545779173e-04  2.968195960792669e-01 
 	 9.397958836080945e-01  6.243039370722009e-04  3.417357274238020e-01 
 	 9.114468939008568e-01  6.047886408554157e-04  4.114172988939335e-01 
 	 8.885966876750200e-01  5.938211083238168e-04  4.586889730846758e-01 
 	 8.482645814088885e-01  5.806484909316799e-04  5.295723395104142e-01 
 	 7.653581984400576e-01  5.678160747824803e-04  6.436043083024653e-01 
 	 6.864662639427452e-01  5.659414425061957e-04  7.271614319934555e-01 
 	 6.214781786837923e-01  5.694548461957638e-04  7.834312663795430e-01 
 	 4.823822386670049e-01  5.889851682910950e-04  8.759606320577884e-01 
 	 3.647163994132916e-01  6.174096572759555e-04  9.311184493953062e-01 
 	 2.968195960792667e-01  6.391633545777891e-04  9.549333583311178e-01 
 	 1.933336727853598e-01  6.812475288736714e-04  9.811328283515580e-01 
 	 1.565879702169479e-01  6.992472015923269e-04  9.876637680084692e-01 
 	 1.230721869615696e-01  7.173011061677151e-04  9.923974618446076e-01 
 	 6.700276877676180e-02  7.514897926082790e-04  9.977525065061673e-01 
 	 4.497917306134239e-02  7.664650675916093e-04  9.989876308153260e-01 
 	 2.003646092586046e-02  7.846150080027870e-04  9.997989420942871e-01 
 	 1.395649779500463e-02  7.892438410883530e-04  9.999022918582883e-01 
 	 5.231007392318968e-03  7.960342700820076e-04  9.999860013475700e-01 
 	 6.101734245623517e-01  6.000539450353397e-01  5.173235496334740e-01 
 	 5.380391456695325e-01  6.655553348150974e-01  5.172523310980467e-01 
 	 6.429219857180248e-01  5.731696428011560e-01  5.080628709634144e-01 
 	 5.023314879191604e-01  7.057249815562524e-01  4.996151785648126e-01 
 	 5.620071065247824e-01  6.721076197024137e-01  4.820989107575308e-01 
 	 6.260025620583269e-01  6.176074429211269e-01  4.761111621720684e-01 
 	 6.852959120462729e-01  5.588110420904460e-01  4.670114904051684e-01 
 	 7.174777965474165e-01  5.254288582953909e-01  4.573293412103209e-01 
 	 7.390257441222675e-01  4.822740214804397e-01  4.703750819607830e-01 
 	 4.984355667884602e-01  7.435042559544470e-01  4.458288989487902e-01 
 	 5.634228968329864e-01  7.042237019669148e-01  4.319995566112769e-01 
 	 6.016734447027913e-01  6.746706093399250e-01  4.275612644199324e-01 
 	 6.397393959227410e-01  6.397393959227409e-01  4.259894489407140e-01 
 	 6.691734705003463e-01  6.081155067002506e-01  4.270859361875778e-01 
 	 7.426208291250630e-01  5.208288497170498e-01  4.210126048612071e-01 
 	 4.383640887661086e-01  7.936229477094876e-01  4.218999200629971e-01 
 	 4.933808563366909e-01  7.687785572990073e-01  4.068843329961606e-01 
 	 5.570558331806507e-01  7.303680426402404e-01  3.952863784767636e-01 
 	 7.192631052274513e-01  5.727002421790871e-01  3.932874496682793e-01 
 	 7.823325753413958e-01  4.654957271652148e-01  4.138471572339568e-01 
 	 6.144126309871745e-01  6.968495062832476e-01  3.699971411730262e-01 
 	 6.572905802745608e-01  6.572905802745607e-01  3.686979606190717e-01 
 	 5.041355426087614e-01  7.839028078208040e-01  3.624137725987099e-01 
 	 6.976392843343524e-01  6.255647190009475e-01  3.492394755675797e-01 
 	 7.562361392088761e-01  5.491126914148281e-01  3.557838583769886e-01 
 	 7.839028078208041e-01  5.041355426087611e-01  3.624137725987099e-01 
 	 4.051626207171534e-01  8.401067836613613e-01  3.606436507409644e-01 
 	 4.443561955816815e-01  8.240053919345572e-01  3.515148439411217e-01 
 	 5.548016890867506e-01  7.619790098504701e-01  3.340405279809406e-01 
 	 6.069240581479278e-01  7.232038630778465e-01  3.295745136847362e-01 
 	 7.315342094507084e-01  5.964691247797475e-01  3.302760717760360e-01 
 	 7.753809417447228e-01  5.344111050093738e-01  3.364359761109487e-01 
 	 8.081247257824248e-01  4.773216844439750e-01  3.451064142241448e-01 
 	 8.437246017340962e-01  3.951859260602731e-01  3.632586960728192e-01 
 	 4.863874413153851e-01  8.125838183180544e-01  3.211460651141841e-01 
 	 6.516053338603112e-01  6.937948678249600e-01  3.066906752161513e-01 
 	 8.358592917171457e-01  4.392767553230028e-01  3.292038527766745e-01 
 	 8.644702126478704e-01  3.643631991108748e-01  3.463101364069997e-01 
 	 4.660578431921912e-01  8.318159080140315e-01  3.014504635488811e-01 
 	 5.583315063012514e-01  7.770694810698333e-01  2.905666027974235e-01 
 	 6.889646327127806e-01  6.663475917578898e-01  2.851466672247878e-01 
 	 7.210803530664900e-01  6.310721335987273e-01  2.859914100399804e-01 
 	 7.597532257363471e-01  5.826345201926809e-01  2.886382716533964e-01 
 	 7.851916851580454e-01  5.462630640599047e-01  2.916687888728473e-01 
 	 8.140206200440792e-01  4.992329198086518e-01  2.968786316365345e-01 
 	 8.615541457381062e-01  3.996694489641038e-01  3.130316046762883e-01 
 	 3.838740190353990e-01  8.761554434024870e-01  2.915345202644136e-01 
 	 6.449889107098555e-01  7.171089009904572e-01  2.640911380216549e-01 
 	 8.393332098139602e-01  4.669613006942331e-01  2.783287742173721e-01 
 	 8.871459902058683e-01  3.525331980556386e-01  2.978125859165683e-01 
 	 3.416957364712395e-01  8.988242744488977e-01  2.745158416900378e-01 
 	 4.956754639938828e-01  8.310670315840649e-01  2.522566617722908e-01 
 	 5.640717976343573e-01  7.880922975393795e-01  2.464417531033382e-01 
 	 6.331431174559724e-01  7.349169304974930e-01  2.429545185549671e-01 
 	 7.111083391964989e-01  6.600135623631656e-01  2.422953309948025e-01 
 	 7.463098190585288e-01  6.194802666640467e-01  2.434457910719914e-01 
 	 8.310670315840649e-01  4.956754639938827e-01  2.522566617722908e-01 
 	 8.825440790020574e-01  3.874789640751646e-01  2.664132147954517e-01 
 	 9.053205541248075e-01  3.204230931139289e-01  2.787897696804061e-01 
 	 3.836500402364155e-01  8.909779397204055e-01  2.428393657506505e-01 
 	 4.462513287467073e-01  8.635377888836748e-01  2.348664274895244e-01 
 	 5.310282035634437e-01  8.163963101308225e-01  2.269495799180066e-01 
 	 7.759707222994643e-01  5.899307284727634e-01  2.232737641050614e-01 
 	 8.163963101308226e-01  5.310282035634436e-01  2.269495799180065e-01 
 	 9.251273310206500e-01  2.747715577979872e-01  2.619923900113820e-01 
 	 3.241701361524588e-01  9.182800461730215e-01  2.273224133854160e-01 
 	 4.215044559254763e-01  8.810459973055135e-01  2.146903450714569e-01 
 	 4.946937906372481e-01  8.438497937557211e-01  2.078354615636550e-01 
 	 6.928879220303400e-01  6.928879220303400e-01  1.995310878258194e-01 
 	 8.675726605804287e-01  4.499647912805600e-01  2.117766871523828e-01 
 	 8.979483097094333e-01  3.815421395293446e-01  2.193500144822013e-01 
 	 9.182800461730215e-01  3.241701361524587e-01  2.273224133854160e-01 
 	 9.363318721688834e-01  2.573446506264460e-01  2.388647231272681e-01 
 	 2.535167808450997e-01  9.434784774144359e-01  2.134891202981447e-01 
 	 3.068230695385802e-01  9.293513585906433e-01  2.053427775322257e-01 
 	 3.953976423188339e-01  8.976461077972321e-01  1.946591112822295e-01 
 	 5.852782715731957e-01  7.903435915328623e-01  1.811252388465751e-01 
 	 6.338408093329189e-01  7.523372570161297e-01  1.795396338685041e-01 
 	 7.387751143799218e-01  6.496912711621851e-01  1.791998397002560e-01 
 	 7.781396303895187e-01  6.015954445927871e-01  1.805038411294065e-01 
 	 3.397818211705789e-01  9.235539557957492e-01  1.777537755886719e-01 
 	 4.299878002390812e-01  8.867915705801866e-01  1.694438018739010e-01 
 	 4.966606658090267e-01  8.521456634715465e-01  1.648513004643028e-01 
 	 5.481970665100261e-01  8.204833463248965e-01  1.621328303376653e-01 
 	 6.824477750679349e-01  7.135311134378306e-01  1.585508891838680e-01 
 	 8.421343458247993e-01  5.137669351339565e-01  1.638697041716320e-01 
 	 8.867915705801868e-01  4.299878002390810e-01  1.694438018739011e-01 
 	 9.073153097483485e-01  3.830062891830788e-01  1.734506014474042e-01 
 	 9.424604436566084e-01  2.784619158947628e-01  1.850061445974353e-01 
 	 9.517436463420235e-01  2.408285568777269e-01  1.902252292409733e-01 
 	 2.395047337832852e-01  9.565801577926263e-01  1.661080498134631e-01 
 	 3.252945612357524e-01  9.325296462097814e-01  1.567542897987147e-01 
 	 3.867748644572666e-01  9.096515506898474e-01  1.514571244663617e-01 
 	 5.257992820943834e-01  8.385004865256043e-01  1.430106606003755e-01 
 	 6.328871864122860e-01  7.615602193689837e-01  1.395702029439161e-01 
 	 7.317900427154902e-01  6.671907149816613e-01  1.390679086803300e-01 
 	 8.024764858720770e-01  5.797999652730170e-01  1.409378937397972e-01 
 	 9.275195267906680e-01  3.399409888353340e-01  1.553951464225011e-01 
 	 9.686947607813001e-01  1.762586559367358e-01  1.748237588036455e-01 
 	 1.545906907217738e-01  9.760436018321512e-01  1.531032516463516e-01 
 	 2.210829890091103e-01  9.644157207423798e-01  1.449987226004198e-01 
 	 3.422900570825359e-01  9.300060288083796e-01  1.338891452004287e-01 
 	 4.462528391858694e-01  8.858167712522244e-01  1.272283430955345e-01 
 	 6.850285011827747e-01  7.185450713749545e-01  1.201204935472822e-01 
 	 7.800822913933138e-01  6.138595769902631e-01  1.210290807694266e-01 
 	 8.330009895075097e-01  5.393998936026624e-01  1.231142000784070e-01 
 	 8.764541516643166e-01  4.646294112348573e-01  1.262839271084513e-01 
 	 9.104005699784600e-01  3.926497183510300e-01  1.303725464265848e-01 
 	 9.355165306138711e-01  3.264225007500203e-01  1.351191028400096e-01 
 	 9.451281561324569e-01  2.962961950020270e-01  1.376275165545852e-01 
 	 9.644157207423799e-01  2.210829890091101e-01  1.449987226004198e-01 
 	 9.742119233140719e-01  1.672788267158127e-01  1.514229923270504e-01 
 	 2.031859231940945e-01  9.711827921364201e-01  1.245771442675997e-01 
 	 2.818320182681875e-01  9.521925356316072e-01  1.178986368298221e-01 
 	 4.192716903240201e-01  9.012391671598586e-01  1.094495923694715e-01 
 	 5.154767199309683e-01  8.503836737558750e-01  1.055052539861007e-01 
 	 5.738572707170496e-01  8.123466469821906e-01  1.038304289790383e-01 
 	 7.205037969507858e-01  6.858751308549726e-01  1.022232040887727e-01 
 	 8.123466469821906e-01  5.738572707170495e-01  1.038304289790383e-01 
 	 8.618110722268184e-01  4.959904745083789e-01  1.061843914340269e-01 
 	 8.923149754410497e-01  4.381661008989917e-01  1.085562187376376e-01 
 	 9.711827921364202e-01  2.031859231940943e-01  1.245771442675997e-01 
 	 9.797658245324053e-01  1.523368712439386e-01  1.298168199346433e-01 
 	 1.222745146434093e-01  9.862994425970448e-01  1.107355074105741e-01 
 	 1.750109552240010e-01  9.788504000816753e-01  1.059389437908782e-01 
 	 2.525084613562619e-01  9.624006389626837e-01  1.001223604781241e-01 
 	 3.178893766736062e-01  9.432405990799723e-01  9.614320800410774e-02 
 	 3.724412652480281e-01  9.233470488978631e-01  9.336879153151331e-02 
 	 6.491384438486815e-01  7.558363949811305e-01  8.561906761721227e-02 
 	 7.558363949811305e-01  6.491384438486814e-01  8.561906761721227e-02 
 	 9.071217179042507e-01  4.107602613462342e-01  9.168531291987013e-02 
 	 9.432405990799724e-01  3.178893766736061e-01  9.614320800410774e-02 
 	 9.583232552660935e-01  2.679423918062414e-01  9.911313277940660e-02 
 	 9.926134909985927e-02  9.908121122641593e-01  9.186154127550136e-02 
 	 2.387665615300877e-01  9.675816248607526e-01  8.231845678172459e-02 
 	 2.887150700264188e-01  9.540890327055376e-01  7.973534981833126e-02 
 	 4.434025711076460e-01  8.932796771598907e-01  7.379416174908808e-02 
 	 5.056267406375737e-01  8.597295985311869e-01  7.215688852512851e-02 
 	 5.472199424194667e-01  8.339476580151854e-01  7.128561081608843e-02 
 	 6.086975099992401e-01  7.902791061845772e-01  7.032976360567794e-02 
 	 8.471783363386450e-01  5.264486705548458e-01  7.169842194582084e-02 
 	 9.711610149837271e-01  2.234413228816357e-01  8.318808931981600e-02 
 	 9.771230756702718e-01  1.949902923556395e-01  8.490748423861440e-02 
 	 9.864390867456485e-01  1.380265721905905e-01  8.880649474968950e-02 
 	 9.913942053778411e-01  9.272175662415715e-02  9.241323169205799e-02 
 	 1.426061204992441e-01  9.872994405207166e-01  7.002363275091528e-02 
 	 1.949846542636183e-01  9.784972324147544e-01  6.726180757579597e-02 
 	 3.343779695822165e-01  9.404216860416138e-01  6.163137091386717e-02 
 	 3.745119037660856e-01  9.252534632193150e-01  6.038926012268914e-02 
 	 7.060215342201192e-01  7.060215342201192e-01  5.538218517662714e-02 
 	 9.331580243472386e-01  3.542533209426882e-01  6.099742779359595e-02 
 	 9.470662452421670e-01  3.149375581127035e-01  6.228853516427327e-02 
 	 9.944408551562729e-01  7.461370530597877e-02  7.429791771357619e-02 
 	 9.717108129985449e-02  9.937122387397358e-01  5.562164630680462e-02 
 	 2.142011134928304e-01  9.754683927691945e-01  5.078678653661805e-02 
 	 2.673486535516206e-01  9.623499669921652e-01  4.906361660450764e-02 
 	 4.312116710147954e-01  9.011206201630297e-01  4.514557229258025e-02 
 	 4.749050213479130e-01  8.789160727159236e-01  4.440447973071578e-02 
 	 6.052285883631825e-01  7.948955349585971e-01  4.288874363740389e-02 
 	 6.672277517359333e-01  7.436373118580901e-01  4.255203550813352e-02 
 	 7.613535018687870e-01  6.469337892346310e-01  4.263235319164344e-02 
 	 7.948955349585971e-01  6.052285883631825e-01  4.288874363740389e-02 
 	 8.667177650313285e-01  4.968476391577734e-01  4.407651577025711e-02 
 	 8.903825460478704e-01  4.530070240707294e-01  4.476111968989995e-02 
 	 9.442534390690283e-01  3.257829534661182e-01  4.744375656718107e-02 
 	 9.672352087900936e-01  2.489836826320491e-01  4.963040056021267e-02 
 	 9.788817084763459e-01  1.978680270814734e-01  5.136968628788173e-02 
 	 9.867126033430317e-01  1.535560821347522e-01  5.309207138022014e-02 
 	 9.937122387397358e-01  9.717108129985443e-02  5.562164630680468e-02 
 	 4.435467397234991e-02  9.981059783801539e-01  4.262767667375435e-02 
 	 7.471250388403133e-02  9.963435709778413e-01  4.144309754955459e-02 
 	 1.153823068846898e-01  9.925149531897720e-01  4.001238499104975e-02 
 	 1.709350073313076e-01  9.845373465442582e-01  3.830713416893913e-02 
 	 2.976259272416572e-01  9.540306779423362e-01  3.527425376149189e-02 
 	 7.259530387619529e-01  6.870384861348793e-01  3.114970436103367e-02 
 	 8.817283156802961e-01  4.706311956643762e-01  3.257997843934064e-02 
 	 9.142116649514852e-01  4.038541412168380e-01  3.344942882387782e-02 
 	 9.540306779423363e-01  2.976259272416570e-01  3.527425376149189e-02 
 	 9.891759729876379e-01  1.414064745260275e-01  3.918039594082506e-02 
 	 9.956671680363010e-01  8.340131156706518e-02  4.112312881415666e-02 
 	 9.972908681789651e-01  6.039785454278074e-02  4.198837236039400e-02 
 	 3.384136446734122e-02  9.989906135204886e-01  2.953838433202294e-02 
 	 9.228929557858155e-02  9.953382029825689e-01  2.800977695447800e-02 
 	 1.610775699661454e-01  9.865856752708017e-01  2.650890047244002e-02 
 	 1.945888661592825e-01  9.805435489560232e-01  2.587511869676148e-02 
 	 3.765560617141728e-01  9.261009411308787e-01  2.329333000695544e-02 
 	 4.669080638670851e-01  8.840209312770182e-01  2.244666924074872e-02 
 	 5.352197117537671e-01  8.444270842389091e-01  2.197178995868898e-02 
 	 5.801277457950169e-01  8.142354303494530e-01  2.173620303625346e-02 
 	 6.869265333145576e-01  7.264105380422594e-01  2.143987055928872e-02 
 	 7.635365804523125e-01  6.454063108385237e-01  2.150777164180863e-02 
 	 8.444270842389092e-01  5.352197117537669e-01  2.197178995868898e-02 
 	 9.261009411308788e-01  3.765560617141726e-01  2.329333000695550e-02 
 	 9.768313806559668e-01  2.124785822083683e-01  2.555984875697385e-02 
 	 9.941695862665233e-01  1.042015096596929e-01  2.772866977139229e-02 
 	 9.984302282588671e-01  4.782728713636793e-02  2.914841169124179e-02 
 	 7.157116141555753e-02  9.972754570567819e-01  1.786705364113227e-02 
 	 2.639121954449298e-01  9.644219153249758e-01  1.551522917466357e-02 
 	 8.600199392787163e-01  5.100712713110542e-01  1.389252411039560e-02 
 	 8.975535231284512e-01  4.406759254064219e-01  1.422680171010583e-02 
 	 9.447027867540246e-01  3.275858093539741e-01  1.497271548789738e-02 
 	 9.697168564034530e-01  2.437262269713685e-01  1.570810915755633e-02 
 	 9.785818857047013e-01  2.052268686443202e-01  1.610668671943094e-02 
 	 9.881042809921110e-01  1.528736961653417e-01  1.672013474257702e-02 
 	 9.964148920117747e-01  8.273026285862095e-02  1.769368770230651e-02 
 	 9.972754570567820e-01  7.157116141555729e-02  1.786705364113227e-02 
 	 9.979484475591421e-01  6.143154231845856e-02  1.802946540176205e-02 
 	 9.991327805228789e-01  3.733404668879509e-02  1.843517947999724e-02 
 	 2.313767730841703e-02  9.996813086679808e-01  1.009598874032772e-02 
 	 3.618423899325562e-02  9.992953883859161e-01  9.971338883008145e-03 
 	 5.360324731503556e-02  9.985141027519974e-01  9.812159938393990e-03 
 	 1.009169169553736e-01  9.948502803424509e-01  9.417832806386211e-03 
 	 1.303854870569131e-01  9.914207142252366e-01  9.197400179035373e-03 
 	 1.995600262312798e-01  9.798465823390829e-01  8.744770379475398e-03 
 	 2.385862526000470e-01  9.710838966437381e-01  8.524420770964058e-03 
 	 3.235336661718303e-01  9.461818295489693e-01  8.118638111151747e-03 
 	 3.685666737505325e-01  9.295674083035267e-01  7.939799766559220e-03 
 	 4.613679492580665e-01  8.871759838208659e-01  7.641277961485608e-03 
 	 5.081503013189883e-01  8.612355402056979e-01  7.524330935119912e-03 
 	 5.774234542732484e-01  8.164113657590937e-01  7.391638148708760e-03 
 	 6.223199569790150e-01  7.827286298701648e-01  7.332334363039564e-03 
 	 6.656745451383044e-01  7.462065120418211e-01  7.296666450579027e-03 
 	 7.462065120418212e-01  6.656745451383042e-01  7.296666450579027e-03 
 	 8.164113657590936e-01  5.774234542732484e-01  7.391638148708760e-03 
 	 9.201373555231254e-01  3.915169309933408e-01  7.857462469850217e-03 
 	 9.599481603794068e-01  2.800542784599305e-01  8.314475358112638e-03 
 	 9.710838966437382e-01  2.385862526000468e-01  8.524420770964058e-03 
 	 9.914207142252367e-01  1.303854870569129e-01  9.197400179035373e-03 
 	 9.971186434374497e-01  7.524470853946733e-02  9.625214089604850e-03 
 	 9.997812709505883e-01  1.828985380274470e-02  1.014354495727501e-02 
 	 1.235675274902353e-02  9.999149985451451e-01  4.160089657945436e-03 
 	 2.330231738520084e-02  9.997199902676893e-01  4.116195288149878e-03 
 	 3.046316407178327e-02  9.995275293668211e-01  4.088235877983712e-03 
 	 4.808364441901195e-02  9.988352154727161e-01  4.021874060538686e-03 
 	 6.996910802088385e-02  9.975413619266802e-01  3.944004085437866e-03 
 	 1.103510527240072e-01  9.938853611035163e-01  3.812367615585313e-03 
 	 1.769203057759851e-01  9.842185048130055e-01  3.624939693786143e-03 
 	 2.768194644149917e-01  9.609159298808471e-01  3.399973856378382e-03 
 	 8.620617228405052e-01  5.067939812796642e-01  3.073524356094177e-03 
 	 8.999022466239945e-01  4.360803002365696e-01  3.149327971260073e-03 
 	 9.392464009646760e-01  3.432279606088039e-01  3.281056418981761e-03 
 	 9.806826303790074e-01  1.955729400595802e-01  3.578210357567248e-03 
 	 9.898679581909656e-01  1.419422173181160e-01  3.719178627765248e-03 
 	 9.938853611035163e-01  1.103510527240070e-01  3.812367615585313e-03 
 	 9.992414922407490e-01  3.872962088486723e-02  4.056679750196722e-03 
 	 9.995275293668212e-01  3.046316407178310e-02  4.088235877983712e-03 
 	 1.142197040317563e-03  9.999990282701322e-01  7.992776190538111e-04 
 	 5.231007392319319e-03  9.999860013475700e-01  7.960342700820247e-04 
 	 5.546636893293627e-02  9.984602673655107e-01  7.592165620284218e-04 
 	 6.700276877676185e-02  9.977525065061673e-01  7.514897926082235e-04 
 	 9.311494041561771e-02  9.956550947938437e-01  7.349030262591777e-04 
 	 1.230721869615697e-01  9.923974618446075e-01  7.173011061676596e-04 
 	 1.745792168546973e-01  9.846428899100138e-01  6.902116030276281e-04 
 	 2.128040149676469e-01  9.770946725278145e-01  6.724071777380547e-04 
 	 2.536916193228777e-01  9.672849284929751e-01  6.552828977885693e-04 
 	 3.190834068112817e-01  9.477264271013618e-01  6.315626598606515e-04 
 	 3.647163994132918e-01  9.311184493953062e-01  6.174096572758445e-04 
 	 4.114172988939334e-01  9.114468939008568e-01  6.047886408553515e-04 
 	 4.586889730846758e-01  8.885966876750199e-01  5.938211083238083e-04 
 	 5.529467267284786e-01  8.332164090363522e-01  5.771592739111420e-04 
 	 6.436043083024654e-01  7.653581984400576e-01  5.678160747824803e-04 
 	 6.864662639427455e-01  7.271614319934553e-01  5.659414425061957e-04 
 	 7.834312663795431e-01  6.214781786837923e-01  5.694548461958279e-04 
 	 8.332164090363522e-01  5.529467267284787e-01  5.771592739110309e-04 
 	 8.759606320577884e-01  4.823822386670049e-01  5.889851682910950e-04 
 	 9.114468939008569e-01  4.114172988939333e-01  6.047886408553515e-04 
 	 9.477264271013618e-01  3.190834068112816e-01  6.315626598606515e-04 
 	 9.672849284929752e-01  2.536916193228775e-01  6.552828977885693e-04 
 	 9.770946725278145e-01  2.128040149676466e-01  6.724071777379906e-04 
 	 9.846428899100138e-01  1.745792168546974e-01  6.902116030276922e-04 
 	 9.956550947938437e-01  9.311494041561753e-02  7.349030262591222e-04 
 	 9.977525065061672e-01  6.700276877676173e-02  7.514897926082235e-04 
 	 9.989876308153259e-01  4.497917306134225e-02  7.664650675914896e-04 
 	 9.996284956854050e-01  2.724451153394345e-02  7.792336047657115e-04 
 	 9.999022918582883e-01  1.395649779500457e-02  7.892438410882974e-04 
 	 9.999590242612895e-01  9.017807125009788e-03  7.930656127955370e-04 
 	 9.999990282701322e-01  1.142197040317221e-03  7.992776190539221e-04 
 	 5.634204014007362e-01  5.781452931263155e-01  5.901741025505268e-01 
 	 5.494939658643280e-01  5.495213723138023e-01  6.293509695305541e-01 
 	 5.399987286886675e-01  6.077464426915196e-01  5.822762526588446e-01 
 	 5.492945930046508e-01  6.291488959815779e-01  5.499519222450420e-01 
 	 5.177764499209483e-01  5.922512477973908e-01  6.173702352638111e-01 
 	 5.138464116470475e-01  5.486583569564882e-01  6.594966812496177e-01 
 	 5.099815076552864e-01  5.178160039066280e-01  6.868663974513617e-01 
 	 4.968827253965088e-01  6.617676021321218e-01  5.614011025735871e-01 
 	 4.679061829705601e-01  5.541946446754087e-01  6.884272654035561e-01 
 	 4.603366466750817e-01  6.228893737536862e-01  6.325337933997532e-01 
 	 4.710527506225766e-01  4.804162243589585e-01  7.398037290414179e-01 
 	 4.491247734526203e-01  6.912940884010054e-01  5.660383566622985e-01 
 	 4.562099312835814e-01  7.147883850576348e-01  5.300472273155745e-01 
 	 4.261664022188231e-01  6.272632614918128e-01  6.518611803156542e-01 
 	 4.266937961044817e-01  6.635331018679016e-01  6.145374090252830e-01 
 	 4.470286321551183e-01  7.456151623413212e-01  4.941896718065334e-01 
 	 4.585763899050421e-01  7.608639701056954e-01  4.591227652999339e-01 
 	 4.173162859373477e-01  5.400218731326829e-01  7.309059406173453e-01 
 	 4.113087781972118e-01  5.816499482341322e-01  7.017894461283584e-01 
 	 4.111116424465163e-01  4.758653761125104e-01  7.775212931246492e-01 
 	 4.013548015247857e-01  5.199416315074009e-01  7.540391389831314e-01 
 	 3.884669324193700e-01  6.515724988121754e-01  6.515724988121754e-01 
 	 3.902469515669114e-01  6.944147189703654e-01  6.045622506161306e-01 
 	 3.975536058715550e-01  7.405441768638001e-01  5.417983504696567e-01 
 	 4.081224121083490e-01  4.088600960645485e-01  8.162533421560682e-01 
 	 3.699971411730263e-01  6.144126309871744e-01  6.968495062832476e-01 
 	 3.880420687337511e-01  7.849930099913950e-01  4.829175158942576e-01 
 	 4.082716212596843e-01  8.164031939419478e-01  4.084116895919794e-01 
 	 3.684852081040613e-01  4.718562181001352e-01  8.009808742090814e-01 
 	 3.569861095115985e-01  5.398114790756537e-01  7.623414488757174e-01 
 	 3.509890263547539e-01  5.968120424153074e-01  7.215414675585952e-01 
 	 3.483756220888998e-01  6.628100881603162e-01  6.628100881603162e-01 
 	 3.582567611309379e-01  7.681608864448974e-01  5.306420126979765e-01 
 	 3.655428055163759e-01  3.868494024323728e-01  8.465967146008382e-01 
 	 3.499041716842148e-01  4.521327585638245e-01  8.204529476279856e-01 
 	 3.329637794048196e-01  5.651453198477809e-01  7.548151356846311e-01 
 	 3.280961231749983e-01  6.379825780853934e-01  6.966571351942440e-01 
 	 3.284821687341689e-01  7.057520039504585e-01  6.277050053517249e-01 
 	 3.302760717760360e-01  7.315342094507082e-01  5.964691247797475e-01 
 	 3.420252196297832e-01  7.984407941003219e-01  4.954907137915359e-01 
 	 3.562507010525328e-01  8.331147574536388e-01  4.230901073205839e-01 
 	 3.501999925081005e-01  3.503779298576131e-01  8.686744335572562e-01 
 	 3.308545627382887e-01  4.308199184507331e-01  8.396007719037420e-01 
 	 3.154473491317898e-01  5.286137220123646e-01  7.880739196458422e-01 
 	 3.064652859502325e-01  6.730821006784544e-01  6.730821006784544e-01 
 	 3.119145325567265e-01  7.661358482001475e-01  5.619120807408926e-01 
 	 3.387807293797480e-01  8.542792492032742e-01  3.942519267950582e-01 
 	 3.497277010143305e-01  8.681970654680954e-01  3.520289628082026e-01 
 	 2.954676707846774e-01  5.107459660373324e-01  8.073644862747368e-01 
 	 2.859914100399806e-01  7.210803530664899e-01  6.310721335987273e-01 
 	 3.030617074529647e-01  8.370406503024954e-01  4.555398459156668e-01 
 	 3.018543831969631e-01  3.342597485845537e-01  8.928350081739470e-01 
 	 2.898731529994771e-01  3.928749819716902e-01  8.727100341527453e-01 
 	 2.690332732136376e-01  5.544198404955516e-01  7.875530067042111e-01 
 	 2.655883459687232e-01  6.064932873372104e-01  7.494189235004022e-01 
 	 2.638110547711271e-01  6.575509580247234e-01  7.057127354535369e-01 
 	 2.636425834974156e-01  6.940358929616531e-01  6.699304198554720e-01 
 	 2.713154940924572e-01  8.043198833361350e-01  5.286373311974022e-01 
 	 2.881954101802719e-01  8.689584428819305e-01  4.023116082034366e-01 
 	 3.005899772026800e-01  8.911559423137304e-01  3.398334181392693e-01 
 	 2.566168780068276e-01  4.567369183871662e-01  8.517858682228909e-01 
 	 2.509329611095274e-01  5.090938656559089e-01  8.233201594643045e-01 
 	 2.440425852271258e-01  7.573379140937476e-01  6.057082634996754e-01 
 	 2.536495848322822e-01  8.383907601974955e-01  4.824549940977672e-01 
 	 2.863526796525329e-01  9.142651823455267e-01  2.865681754949679e-01 
 	 2.567199797073186e-01  3.006968645124457e-01  9.185185069945285e-01 
 	 2.461353333932015e-01  3.615609805668947e-01  8.992725143063827e-01 
 	 2.249277334347823e-01  5.604373379296483e-01  7.970680679755152e-01 
 	 2.208942255427083e-01  6.621260328285204e-01  7.160969611530635e-01 
 	 2.269495799180067e-01  8.163963101308225e-01  5.310282035634436e-01 
 	 2.379652975533467e-01  8.757313348219853e-01  4.200799285508071e-01 
 	 2.428393657506506e-01  8.909779397204056e-01  3.836500402364154e-01 
 	 2.509546194417516e-01  9.092212198911651e-01  3.321724736947166e-01 
 	 2.403895659068833e-01  2.495838732208965e-01  9.380409089326306e-01 
 	 2.132092432101558e-01  4.355748275673727e-01  8.745378140477438e-01 
 	 2.090837740732035e-01  4.795612539730930e-01  8.522352838899948e-01 
 	 1.999938027758159e-01  6.490073286300847e-01  7.340244997516835e-01 
 	 1.995826095518248e-01  7.069429336165696e-01  6.785266911287148e-01 
 	 2.103994410005722e-01  8.601410306519123e-01  4.646390885576815e-01 
 	 2.379277652970887e-01  9.352166090040440e-01  2.622218006644575e-01 
 	 2.068299863230123e-01  2.963535609385661e-01  9.324140301800773e-01 
 	 1.992035605493438e-01  3.544141979140049e-01  9.136238382296274e-01 
 	 1.946591112822296e-01  3.953976423188338e-01  8.976461077972321e-01 
 	 1.844882779842924e-01  5.196634140834269e-01  8.342146074899116e-01 
 	 1.818369337749984e-01  5.688850421599552e-01  8.020630513382180e-01 
 	 1.795396338685042e-01  7.523372570161296e-01  6.338408093329188e-01 
 	 1.811252388465751e-01  7.903435915328623e-01  5.852782715731956e-01 
 	 1.844882779842923e-01  8.342146074899116e-01  5.196634140834269e-01 
 	 1.946591112822295e-01  8.976461077972322e-01  3.953976423188337e-01 
 	 2.053427775322257e-01  9.293513585906433e-01  3.068230695385801e-01 
 	 1.969479996155924e-01  1.983274537727702e-01  9.601446279219742e-01 
 	 1.890070758865134e-01  2.492094584651779e-01  9.498268110957505e-01 
 	 1.792191244627445e-01  3.263687937936708e-01  9.280969323645412e-01 
 	 1.670229642713832e-01  4.628869594057993e-01  8.705394834342978e-01 
 	 1.596401147114800e-01  6.166921634503506e-01  7.708474617677817e-01 
 	 1.586877090804722e-01  6.664043835739255e-01  7.285076585323231e-01 
 	 1.585508891838681e-01  7.135311134378308e-01  6.824477750679346e-01 
 	 1.638697041716321e-01  8.421343458247993e-01  5.137669351339567e-01 
 	 1.694438018739012e-01  8.867915705801868e-01  4.299878002390810e-01 
 	 1.748615838613726e-01  9.131820723028410e-01  3.681330320878325e-01 
 	 1.924327987982221e-01  9.548831767955562e-01  2.262028660727122e-01 
 	 1.447569259222308e-01  4.899023623169514e-01  8.596750012614164e-01 
 	 1.409378937397973e-01  5.797999652730170e-01  8.024764858720770e-01 
 	 1.409378937397973e-01  8.024764858720770e-01  5.797999652730170e-01 
 	 1.635505610477919e-01  9.514484382708422e-01  2.607625036176167e-01 
 	 1.673160798001088e-01  9.587146566717832e-01  2.299381145504776e-01 
 	 1.722949767603806e-01  9.658887627579996e-01  1.933218532938286e-01 
 	 1.471843354058457e-01  2.017489372678433e-01  9.683151024963080e-01 
 	 1.426319469519376e-01  2.434035204964581e-01  9.593804531668497e-01 
 	 1.351191028400097e-01  3.264225007500203e-01  9.355165306138710e-01 
 	 1.292767010730395e-01  4.102163191230484e-01  9.027791014887360e-01 
 	 1.262839271084515e-01  4.646294112348575e-01  8.764541516643166e-01 
 	 1.210290807694268e-01  6.138595769902631e-01  7.800822913933139e-01 
 	 1.202345387359867e-01  6.676957334087177e-01  7.346605088629299e-01 
 	 1.201204935472823e-01  7.185450713749547e-01  6.850285011827745e-01 
 	 1.210290807694268e-01  7.800822913933138e-01  6.138595769902629e-01 
 	 1.231142000784070e-01  8.330009895075098e-01  5.393998936026624e-01 
 	 1.253974106959576e-01  8.664937976507080e-01  4.831811130659011e-01 
 	 1.351191028400096e-01  9.355165306138711e-01  3.264225007500202e-01 
 	 1.283327565955496e-01  1.659545966233256e-01  9.777472963113611e-01 
 	 1.156366632987857e-01  3.132875998724162e-01  9.425916623158218e-01 
 	 1.103891431551078e-01  4.006504727230371e-01  9.095567248832191e-01 
 	 1.038304289790384e-01  5.738572707170495e-01  8.123466469821906e-01 
 	 1.038304289790384e-01  8.123466469821906e-01  5.738572707170495e-01 
 	 1.094495923694715e-01  9.012391671598586e-01  4.192716903240198e-01 
 	 1.123916652340373e-01  9.244275067825198e-01  3.644199477111187e-01 
 	 1.245771442675996e-01  9.711827921364202e-01  2.031859231940942e-01 
 	 1.274813040458605e-01  9.764532632883958e-01  1.740331627369039e-01 
 	 1.076197364642535e-01  1.555618684459922e-01  9.819462803071034e-01 
 	 1.031225376507980e-01  2.103471660964499e-01  9.721727274222685e-01 
 	 8.883252083510335e-02  4.902801795862821e-01  8.670260254149953e-01 
 	 8.538463704646865e-02  6.864673540681365e-01  7.221302067876226e-01 
 	 8.561906761721243e-02  7.558363949811305e-01  6.491384438486814e-01 
 	 8.721376407942283e-02  8.300741256500520e-01  5.507909814815420e-01 
 	 8.883252083510329e-02  8.670260254149953e-01  4.902801795862821e-01 
 	 9.614320800410783e-02  9.432405990799724e-01  3.178893766736061e-01 
 	 9.911313277940668e-02  9.583232552660936e-01  2.679423918062415e-01 
 	 1.083798773972917e-01  9.831622193985607e-01  1.471252953188003e-01 
 	 9.062314997372602e-02  1.144339859013112e-01  9.892887887566391e-01 
 	 8.405303575109085e-02  2.088384407192063e-01  9.743313568078348e-01 
 	 8.144968237269505e-02  2.547792540896136e-01  9.635629096882711e-01 
 	 7.808301492676753e-02  3.249214738320570e-01  9.425121105973917e-01 
 	 7.579000258385350e-02  3.826882773498638e-01  9.207635732843329e-01 
 	 7.442217012033939e-02  4.229243434264600e-01  9.031037262307564e-01 
 	 7.091939525547775e-02  5.678868247020292e-01  8.200457265948310e-01 
 	 6.993426026113214e-02  6.484748088568032e-01  7.580169005502849e-01 
 	 7.169842194582092e-02  8.471783363386450e-01  5.264486705548458e-01 
 	 7.379416174908816e-02  8.932796771598907e-01  4.434025711076457e-01 
 	 7.652502827826442e-02  9.286271858835281e-01  3.630364577904677e-01 
 	 7.889927867335482e-02  9.485768976123865e-01  3.065563131642933e-01 
 	 8.405303575109067e-02  9.743313568078349e-01  2.088384407192062e-01 
 	 7.065498384376306e-02  1.316644530856165e-01  9.887731514618017e-01 
 	 6.867926417566174e-02  1.671246772801200e-01  9.835407977894488e-01 
 	 6.296607674671913e-02  2.959821455820126e-01  9.531158600483965e-01 
 	 5.667531999305088e-02  5.438131201579137e-01  8.372903907532915e-01 
 	 5.540256245741735e-02  6.870343629327690e-01  7.245097240359967e-01 
 	 5.570759550462924e-02  7.766292794888660e-01  6.274899409900510e-01 
 	 5.780609435943539e-02  8.755500595353669e-01  4.796566987987592e-01 
 	 6.366085176719233e-02  9.585967733108205e-01  2.775599433462241e-01 
 	 6.936325387450608e-02  9.855652316848059e-01  1.544341707848862e-01 
 	 7.278411681809734e-02  9.926042963912752e-01  9.715545854243544e-02 
 	 7.405435322359109e-02  9.941882811703024e-01  7.813843070010704e-02 
 	 5.744465527797835e-02  6.161247570337188e-02  9.964456906513750e-01 
 	 5.517032294224035e-02  1.065820408449569e-01  9.927721309725475e-01 
 	 4.963040056021287e-02  2.489836826320493e-01  9.672352087900935e-01 
 	 4.555682911788382e-02  4.095768866647483e-01  9.111373931689642e-01 
 	 4.440447973071587e-02  4.749050213479128e-01  8.789160727159236e-01 
 	 4.248771611864113e-02  7.064682561796467e-01  7.064682561796467e-01 
 	 4.255203550813368e-02  7.436373118580902e-01  6.672277517359332e-01 
 	 4.288874363740409e-02  7.948955349585971e-01  6.052285883631826e-01 
 	 4.476111968990022e-02  8.903825460478704e-01  4.530070240707295e-01 
 	 4.599372077851877e-02  9.204434936136310e-01  3.881602152633384e-01 
 	 4.796771100246380e-02  9.508875584342398e-01  3.057972366064717e-01 
 	 5.020586588808957e-02  9.715972727881825e-01  2.312533470914385e-01 
 	 5.136968628788175e-02  9.788817084763459e-01  1.978680270814734e-01 
 	 5.252635332552728e-02  9.844699560182846e-01  1.675108590619687e-01 
 	 5.744465527797810e-02  9.964456906513749e-01  6.161247570337140e-02 
 	 5.757174399136093e-02  9.965804950543089e-01  5.926897308965320e-02 
 	 4.238902528347330e-02  5.025389356518935e-02  9.978365180314137e-01 
 	 4.144309754955477e-02  7.471250388403132e-02  9.963435709778412e-01 
 	 3.960323541963282e-02  1.279411880286396e-01  9.909907346439306e-01 
 	 3.830713416893926e-02  1.709350073313077e-01  9.845373465442582e-01 
 	 3.697561961795802e-02  2.211985458394417e-01  9.745275813810425e-01 
 	 3.568467649826560e-02  2.776494183100187e-01  9.600194812478142e-01 
 	 3.412825972190308e-02  3.603143667415210e-01  9.322064251055187e-01 
 	 3.190587015843573e-02  5.377515512429987e-01  8.424994270533255e-01 
 	 3.143900142029573e-02  6.036418900645234e-01  7.966354610165332e-01 
 	 3.124629446435354e-02  7.625733047410385e-01  6.461467511166316e-01 
 	 3.960323541963270e-02  9.909907346439307e-01  1.279411880286395e-01 
 	 4.112312881415674e-02  9.956671680363010e-01  8.340131156706523e-02 
 	 2.964890539163631e-02  2.998161889790597e-02  9.991106269764818e-01 
 	 2.827635002028473e-02  8.135531654919559e-02  9.962839758315450e-01 
 	 2.772866977139246e-02  1.042015096596927e-01  9.941695862665232e-01 
 	 2.379898815113457e-02  3.327731175699412e-01  9.427065611237487e-01 
 	 2.306012935053397e-02  3.988851209787801e-01  9.167109090089856e-01 
 	 2.263627805205978e-02  4.441213320080173e-01  8.956806581429423e-01 
 	 2.150777164180878e-02  6.454063108385237e-01  7.635365804523124e-01 
 	 2.197178995868907e-02  8.444270842389091e-01  5.352197117537670e-01 
 	 2.284092439249122e-02  9.065746872181387e-01  4.214268959952965e-01 
 	 2.329333000695558e-02  9.261009411308788e-01  3.765560617141726e-01 
 	 2.406981154825863e-02  9.499624496894834e-01  3.114353678566183e-01 
 	 2.494187651459613e-02  9.678455101816617e-01  2.503057554614547e-01 
 	 2.587511869676150e-02  9.805435489560232e-01  1.945888661592825e-01 
 	 2.682325332000766e-02  9.889891818689082e-01  1.455366319096276e-01 
 	 2.772866977139229e-02  9.941695862665232e-01  1.042015096596927e-01 
 	 2.827635002028454e-02  9.962839758315449e-01  8.135531654919528e-02 
 	 2.914841169124185e-02  9.984302282588671e-01  4.782728713636786e-02 
 	 1.831503007437825e-02  4.429507247454706e-02  9.988505925451759e-01 
 	 1.817930750184524e-02  5.233312487713079e-02  9.984641990674218e-01 
 	 1.786705364113246e-02  7.157116141555758e-02  9.972754570567818e-01 
 	 1.651520482622383e-02  1.695457395700896e-01  9.853839303556655e-01 
 	 1.590559389261719e-02  2.241478114709089e-01  9.744253540911818e-01 
 	 1.532785125511307e-02  2.846537013787652e-01  9.585078650002147e-01 
 	 1.380148417598996e-02  5.330942193137281e-01  8.459433032826885e-01 
 	 1.359146861900641e-02  6.010054057325707e-01  7.991293851817781e-01 
 	 1.346151211117878e-02  6.867859906423319e-01  7.267350210008536e-01 
 	 1.347778382641367e-02  7.458236531359310e-01  6.660070778648699e-01 
 	 1.359146861900646e-02  7.991293851817780e-01  6.010054057325708e-01 
 	 1.532785125511283e-02  9.585078650002148e-01  2.846537013787649e-01 
 	 1.570810915755641e-02  9.697168564034532e-01  2.437262269713685e-01 
 	 1.712439658222845e-02  9.923740033707528e-01  1.220679830078301e-01 
 	 1.802946540176200e-02  9.979484475591422e-01  6.143154231845861e-02 
 	 1.868973047334778e-02  9.995597511836460e-01  2.304338925855532e-02 
 	 1.009598874032797e-02  2.313767730841703e-02  9.996813086679809e-01 
 	 9.721706593010334e-03  6.390716137085990e-02  9.979084943753301e-01 
 	 9.417832806386455e-03  1.009169169553735e-01  9.948502803424509e-01 
 	 9.197400179035619e-03  1.303854870569131e-01  9.914207142252366e-01 
 	 8.633560720205607e-03  2.187422419932083e-01  9.757444815099265e-01 
 	 8.026942338379429e-03  3.458854637659579e-01  9.382424069248333e-01 
 	 7.780146007669696e-03  4.146750716578407e-01  9.099362913268511e-01 
 	 7.524330935120056e-03  5.081503013189882e-01  8.612355402056978e-01 
 	 7.430082373014295e-03  8.321291291882865e-01  5.545321507651961e-01 
 	 7.524330935120001e-03  8.612355402056979e-01  5.081503013189882e-01 
 	 7.641277961485695e-03  8.871759838208659e-01  4.613679492580665e-01 
 	 8.970930843327686e-03  9.865235741785414e-01  1.633730699650342e-01 
 	 9.417832806386152e-03  9.948502803424509e-01  1.009169169553732e-01 
 	 9.625214089604919e-03  9.971186434374496e-01  7.524470853946738e-02 
 	 9.895662746369414e-03  9.989667945943367e-01  4.435559893323928e-02 
 	 1.014354495727496e-02  9.997812709505884e-01  1.828985380274474e-02 
 	 4.160089657945501e-03  1.235675274902346e-02  9.999149985451450e-01 
 	 4.116195288150063e-03  2.330231738520084e-02  9.997199902676894e-01 
 	 4.056679750196844e-03  3.872962088486740e-02  9.992414922407489e-01 
 	 3.766072049905069e-03  1.257032509162150e-01  9.920607387707719e-01 
 	 3.442781970839492e-03  2.556152783826747e-01  9.667724534292694e-01 
 	 3.358648978338333e-03  2.985279521848518e-01  9.543949817771252e-01 
 	 3.245044342032058e-03  3.661010376154868e-01  9.305694492858027e-01 
 	 3.096493580625718e-03  4.832449544919670e-01  8.754797117498279e-01 
 	 3.034654376072836e-03  5.535184889702447e-01  8.328313594245325e-01 
 	 3.005366035092943e-03  5.993477496528592e-01  8.004831308410245e-01 
 	 2.985783262141317e-03  6.438270150785470e-01  7.651652499645810e-01 
 	 2.985783262141317e-03  7.651652499645811e-01  6.438270150785470e-01 
 	 3.179099957550351e-03  9.109116840025511e-01  4.125891385762552e-01 
 	 3.245044342031938e-03  9.305694492858028e-01  3.661010376154866e-01 
 	 3.399973856378222e-03  9.609159298808472e-01  2.768194644149916e-01 
 	 3.532112710978860e-03  9.766209729281884e-01  2.149395250217965e-01 
 	 3.719178627765321e-03  9.898679581909658e-01  1.419422173181160e-01 
 	 3.812367615585320e-03  9.938853611035163e-01  1.103510527240070e-01 
 	 3.901713317275198e-03  9.965874602688957e-01  8.245126237955525e-02 
 	 4.056679750196716e-03  9.992414922407489e-01  3.872962088486716e-02 
 	 4.175506252706622e-03  9.999543416065945e-01  8.595338833095529e-03 
 	 7.981134119671107e-04  2.604133025323016e-03  9.999962907462048e-01 
 	 7.960342700823285e-04  5.231007392319327e-03  9.999860013475700e-01 
 	 7.892438410884735e-04  1.395649779500451e-02  9.999022918582883e-01 
 	 7.664650675916762e-04  4.497917306134232e-02  9.989876308153260e-01 
 	 7.514897926084113e-04  6.700276877676185e-02  9.977525065061672e-01 
 	 7.349030262592476e-04  9.311494041561764e-02  9.956550947938437e-01 
 	 7.082974738718502e-04  1.394048318597216e-01  9.902352201213868e-01 
 	 6.992472015924644e-04  1.565879702169480e-01  9.876637680084692e-01 
 	 6.724071777382421e-04  2.128040149676469e-01  9.770946725278143e-01 
 	 6.552828977888868e-04  2.536916193228778e-01  9.672849284929751e-01 
 	 5.990921254175546e-04  4.350131091404162e-01  9.004239201424035e-01 
 	 5.806484909318793e-04  5.295723395104140e-01  8.482645814088884e-01 
 	 5.666446429232651e-04  7.465907146973951e-01  6.652833859653202e-01 
 	 5.715596310176716e-04  8.007811576571526e-01  5.989567687745574e-01 
 	 5.771592739111199e-04  8.332164090363522e-01  5.529467267284787e-01 
 	 5.889851682911822e-04  8.759606320577885e-01  4.823822386670049e-01 
 	 6.174096572760386e-04  9.311184493953062e-01  3.647163994132916e-01 
 	 6.391633545778693e-04  9.549333583311178e-01  2.968195960792667e-01 
 	 6.552828977886390e-04  9.672849284929752e-01  2.536916193228775e-01 
 	 6.812475288737467e-04  9.811328283515580e-01  1.933336727853597e-01 
 	 7.082974738716024e-04  9.902352201213868e-01  1.394048318597212e-01 
 	 7.349030262591365e-04  9.956550947938438e-01  9.311494041561764e-02 
 	 7.514897926081722e-04  9.977525065061672e-01  6.700276877676166e-02 
 	 7.664650675915566e-04  9.989876308153259e-01  4.497917306134231e-02 
 	 7.731612141661838e-04  9.993670705485221e-01  3.556487768855656e-02 
 	 7.846150080027415e-04  9.997989420942871e-01  2.003646092586051e-02 
 	 7.892438410883070e-04  9.999022918582882e-01  1.395649779500468e-02 
 	 ]; 
 

 	  
 

 	 case 15
 	 pts=[
 	 5.931089139747235e-01  5.651477043548128e-01  5.734369088454364e-01 
 	 6.198299589426762e-01  5.331664568224136e-01  5.757988809615330e-01 
 	 6.674059938536274e-01  5.241922338454997e-01  5.289534396752862e-01 
 	 5.687206959360922e-01  5.120719601041166e-01  6.436917567353918e-01 
 	 6.145308545015490e-01  4.946753053581633e-01  6.145308545015489e-01 
 	 5.718489178477444e-01  4.846997565360289e-01  6.618572060273108e-01 
 	 7.001962331812820e-01  4.789483633966549e-01  5.294654854080760e-01 
 	 6.769483471154150e-01  4.708165754248474e-01  5.657496687077479e-01 
 	 6.475376330554401e-01  4.662434947250639e-01  6.027536954706438e-01 
 	 5.527328789896319e-01  4.733117249475203e-01  6.859025991429365e-01 
 	 4.923886453975621e-01  4.914278493107519e-01  7.183676571264624e-01 
 	 6.054063772017981e-01  4.502895973404930e-01  6.562944438057746e-01 
 	 5.133115399504474e-01  4.487422797492178e-01  7.315337513192232e-01 
 	 7.570143789233222e-01  4.372738156769023e-01  4.855109063931510e-01 
 	 7.278814511993993e-01  4.249707722411757e-01  5.381342172177822e-01 
 	 7.062053180323845e-01  4.198590462959744e-01  5.700810732046921e-01 
 	 6.682787165008063e-01  4.154684420259356e-01  6.170814620069031e-01 
 	 6.434160415115524e-01  4.147669165341042e-01  6.434160415115524e-01 
 	 6.103661779842832e-01  4.158592512450046e-01  6.741766919189676e-01 
 	 5.700810732046921e-01  4.198590462959745e-01  7.062053180323844e-01 
 	 4.736826443200015e-01  4.203422249007768e-01  7.739103090381183e-01 
 	 7.930041460293080e-01  4.039527236001428e-01  4.560335749441641e-01 
 	 7.650778792438829e-01  3.913536817039064e-01  5.113688830076386e-01 
 	 7.057503935381702e-01  3.796572207555993e-01  5.981444447195444e-01 
 	 6.702025730613275e-01  3.774888091655261e-01  6.390075977770289e-01 
 	 6.309452288136892e-01  3.777333216425257e-01  6.776619038710570e-01 
 	 5.898960202982531e-01  3.803639481507442e-01  7.122822138615150e-01 
 	 4.974203220804422e-01  3.941252977800328e-01  7.728119259115956e-01 
 	 8.216050924131851e-01  3.939518473193836e-01  4.120279288038209e-01 
 	 7.881659979955919e-01  3.752178893608904e-01  4.878584785644000e-01 
 	 7.362635118825126e-01  3.625899608773647e-01  5.713532719267302e-01 
 	 5.624296377147414e-01  3.635783283955296e-01  7.426194865078461e-01 
 	 4.189865674778747e-01  3.918909676647955e-01  8.190675953398830e-01 
 	 7.732913371246678e-01  3.471604901838410e-01  5.305658319033166e-01 
 	 6.925175049302329e-01  3.380304637301869e-01  6.373028408500621e-01 
 	 5.983207466877061e-01  3.400896405106467e-01  7.255007377669611e-01 
 	 4.545944059487392e-01  3.603197673127544e-01  8.145634360587242e-01 
 	 8.446766348645215e-01  3.481116399159230e-01  4.066198085054327e-01 
 	 6.400936383357257e-01  3.175486776078051e-01  6.996020093679459e-01 
 	 5.245384505271281e-01  3.268707963603566e-01  7.861392347449311e-01 
 	 4.196872819325225e-01  3.450996928622949e-01  8.395050847793842e-01 
 	 8.448196397817433e-01  3.199284634973050e-01  4.288654270086351e-01 
 	 8.274619490616212e-01  3.134948604667017e-01  4.658623136894703e-01 
 	 7.986095132626573e-01  3.062034834343350e-01  5.181334500484025e-01 
 	 7.695106071873800e-01  3.015171882226178e-01  5.629749644810471e-01 
 	 7.352103243150779e-01  2.982133168786827e-01  6.087155301589835e-01 
 	 6.753557563343434e-01  2.962924311759141e-01  6.753557563343434e-01 
 	 5.858392762828762e-01  2.996763250252274e-01  7.529850214869682e-01 
 	 5.072606783637948e-01  3.075550433689612e-01  8.050444083926173e-01 
 	 4.561495264875017e-01  3.150770467421277e-01  8.322584118538467e-01 
 	 3.780538229114148e-01  3.307156128537559e-01  8.646979185801417e-01 
 	 8.775382922288517e-01  3.085690020471705e-01  3.670309478064265e-01 
 	 8.298926129546141e-01  2.895074850721469e-01  4.769315119076990e-01 
 	 7.128616525354975e-01  2.758194575121864e-01  6.447882529963171e-01 
 	 6.207218183120961e-01  2.766731255147102e-01  7.335914434405887e-01 
 	 5.473319753792121e-01  2.816155155402470e-01  7.881119274154467e-01 
 	 4.996912233308244e-01  2.866160083733924e-01  8.174105119646111e-01 
 	 4.345600029129532e-01  2.958025854696335e-01  8.506811590118676e-01 
 	 8.917403488733413e-01  2.874438382895633e-01  3.495356777506625e-01 
 	 8.591002537873843e-01  2.730339604355322e-01  4.328963044325282e-01 
 	 7.514084471622567e-01  2.562065051921001e-01  6.080654341684424e-01 
 	 6.958241788844463e-01  2.543608971176909e-01  6.716615562150848e-01 
 	 6.592545720412424e-01  2.545205896462741e-01  7.075328110334046e-01 
 	 3.300156422731151e-01  2.915608887180046e-01  8.978206524830171e-01 
 	 8.856060853988031e-01  2.565795087340944e-01  3.871289413133285e-01 
 	 8.404892195831004e-01  2.443008164495122e-01  4.836269045935023e-01 
 	 8.169835175269211e-01  2.405271394374235e-01  5.241036417383390e-01 
 	 7.695524503800621e-01  2.358436949338598e-01  5.934364141793005e-01 
 	 6.072858208413882e-01  2.351817484332778e-01  7.588764570131742e-01 
 	 5.517214508156261e-01  2.383919505820688e-01  7.992325810473302e-01 
 	 4.450560621849530e-01  2.486301046100942e-01  8.602953984498563e-01 
 	 4.091886409339557e-01  2.533363052960136e-01  8.765759365563186e-01 
 	 2.775739336337121e-01  2.773636433095512e-01  9.197946079082870e-01 
 	 9.254142257886897e-01  2.496976348324123e-01  2.850606985661465e-01 
 	 9.121246599008405e-01  2.414658309671973e-01  3.312444071619879e-01 
 	 8.716155803144062e-01  2.273782938874157e-01  4.342641956482587e-01 
 	 8.266394110786158e-01  2.194859621186719e-01  5.181632913324141e-01 
 	 7.042752653389830e-01  2.125500810287021e-01  6.773616564925987e-01 
 	 4.893649994734398e-01  2.218647999638737e-01  8.433847922670592e-01 
 	 3.615807452596244e-01  2.367527803971982e-01  9.017801758919358e-01 
 	 9.264403491231902e-01  2.213868921075061e-01  3.044603808699597e-01 
 	 8.940984229064155e-01  2.091907175935661e-01  3.960142091250636e-01 
 	 8.530410687319717e-01  2.009435518404361e-01  4.816042192821461e-01 
 	 7.477715601808901e-01  1.927292011374179e-01  6.353685141817860e-01 
 	 6.353685141817859e-01  1.927292011374179e-01  7.477715601808900e-01 
 	 4.374827829941397e-01  2.048495091418759e-01  8.755829447790969e-01 
 	 3.044603808699597e-01  2.213868921075062e-01  9.264403491231902e-01 
 	 2.590108184448441e-01  2.290301810919176e-01  9.383275398694931e-01 
 	 9.438989724167555e-01  2.038817485199604e-01  2.597825292259601e-01 
 	 9.192313212231054e-01  1.925902982389546e-01  3.433988280507879e-01 
 	 8.702285293381777e-01  1.815216173960530e-01  4.579871277053900e-01 
 	 8.134456868311388e-01  1.754514738782627e-01  5.545474685631178e-01 
 	 6.965899663269945e-01  1.718279302823414e-01  6.965899663269945e-01 
 	 6.664534148081174e-01  1.720101851065619e-01  7.254325207145084e-01 
 	 5.871222184796591e-01  1.740370660176590e-01  7.905685297426710e-01 
 	 5.545474685631177e-01  1.754514738782627e-01  8.134456868311389e-01 
 	 4.737278164349476e-01  1.803393681254414e-01  8.620090882582927e-01 
 	 4.272387661472582e-01  1.840557228558385e-01  8.852064886708543e-01 
 	 3.834931927530796e-01  1.881973759654492e-01  9.041652054750662e-01 
 	 3.077340166159566e-01  1.970272997648606e-01  9.308490845270129e-01 
 	 9.580483327486037e-01  1.856798196781382e-01  2.183263536129225e-01 
 	 9.329167145729529e-01  1.731273716624534e-01  3.157424850280021e-01 
 	 9.074129215572063e-01  1.662380065344326e-01  3.859620641649553e-01 
 	 7.708505987233606e-01  1.532874747863716e-01  6.182979092002933e-01 
 	 6.988654351600837e-01  1.522307691533270e-01  6.988654351600838e-01 
 	 6.349074573929400e-01  1.529083863237650e-01  7.573054508840501e-01 
 	 5.505088102452049e-01  1.556116984018826e-01  8.201981767615010e-01 
 	 3.564801629483097e-01  1.689379681536017e-01  9.189025282044223e-01 
 	 2.589772408931485e-01  1.799610569537300e-01  9.489703929414597e-01 
 	 1.903359860828781e-01  1.900829368823269e-01  9.631410537964040e-01 
 	 9.633995005942032e-01  1.624420001272202e-01  2.132463337305195e-01 
 	 9.453163475512906e-01  1.539458161224465e-01  2.875372823664464e-01 
 	 9.156915063116551e-01  1.462246585272155e-01  3.743359647526425e-01 
 	 8.686265777978004e-01  1.396530965172472e-01  4.753786711416766e-01 
 	 8.263586520041765e-01  1.364037544239954e-01  5.463747743416407e-01 
 	 5.995472902633837e-01  1.346903673501943e-01  7.889243003488380e-01 
 	 4.930066176980696e-01  1.387441679028137e-01  8.588914545964846e-01 
 	 4.579047254509948e-01  1.406216017253174e-01  8.778091065475769e-01 
 	 3.006944201800317e-01  1.526354404391463e-01  9.414272611277742e-01 
 	 2.310887691958055e-01  1.602181160331617e-01  9.596500070579649e-01 
 	 9.528707861527355e-01  1.339583998576847e-01  2.721992138200192e-01 
 	 9.292462547999203e-01  1.280202492909894e-01  3.465720902089412e-01 
 	 8.436298156410518e-01  1.186065975276051e-01  5.236613497140780e-01 
 	 7.934142693310653e-01  1.164112094625309e-01  5.974464223119280e-01 
 	 7.500577948270776e-01  1.154682370636739e-01  6.512145503968326e-01 
 	 6.512145503968324e-01  1.154682370636739e-01  7.500577948270777e-01 
 	 4.143397168099798e-01  1.236962582298726e-01  9.016772342550045e-01 
 	 2.590457141980840e-01  1.351559291132353e-01  9.563619569917776e-01 
 	 1.861402608832098e-01  1.427362052119165e-01  9.720998811850726e-01 
 	 9.794199013663353e-01  1.234770522363100e-01  1.596561128757355e-01 
 	 9.733177360373108e-01  1.199573557552094e-01  1.956088380299366e-01 
 	 9.660146301656778e-01  1.168820294951211e-01  2.305522185687450e-01 
 	 8.996900009790491e-01  1.046492118551809e-01  4.238000054228504e-01 
 	 8.243348549094992e-01  9.989946173377333e-02  5.572182198444674e-01 
 	 7.830881592300787e-01  9.870145667163346e-02  6.140284662167909e-01 
 	 7.037082911664214e-01  9.792487879630032e-02  7.037082911664214e-01 
 	 6.140284662167907e-01  9.870145667163352e-02  7.830881592300787e-01 
 	 5.572182198444674e-01  9.989946173377327e-02  8.243348549094992e-01 
 	 4.614085308718844e-01  1.030354070968645e-01  8.811843578519950e-01 
 	 3.518765887859158e-01  1.083772322895938e-01  9.297511719732515e-01 
 	 1.674544420255689e-01  1.226806628990806e-01  9.782169824719603e-01 
 	 9.877693019016823e-01  1.067405878502222e-01  1.136584934180110e-01 
 	 9.685852291607603e-01  9.738768018713113e-02  2.288193470827293e-01 
 	 9.417385153287452e-01  9.173728728545649e-02  3.235936323043401e-01 
 	 9.215610147799791e-01  8.915069210604615e-02  3.778590347400842e-01 
 	 8.761167108712813e-01  8.554110264869344e-02  4.744493952886162e-01 
 	 8.535598235248635e-01  8.440028362091626e-02  5.141130418389647e-01 
 	 7.388743168611741e-01  8.184805743338111e-02  6.688539746292276e-01 
 	 6.688539746292274e-01  8.184805743338122e-02  7.388743168611742e-01 
 	 5.734717137324327e-01  8.305458546615098e-02  8.150043738421486e-01 
 	 5.141130418389644e-01  8.440028362091626e-02  8.535598235248635e-01 
 	 4.547389655723340e-01  8.618040087487888e-02  8.864453799841526e-01 
 	 3.966874954183265e-01  8.835090247546797e-02  9.136920427641392e-01 
 	 3.235936323043400e-01  9.173728728545653e-02  9.417385153287451e-01 
 	 2.735656718205398e-01  9.452489616549437e-02  9.571974024234913e-01 
 	 2.152339413283364e-01  9.833309426547618e-02  9.715991730505162e-01 
 	 1.413932446801473e-01  1.041859270082462e-01  9.844558105736653e-01 
 	 9.862623412452797e-01  8.465625508902767e-02  1.418446781366192e-01 
 	 9.811451291286847e-01  8.245871721548989e-02  1.747993007486945e-01 
 	 9.338680397355454e-01  7.371430134491114e-02  3.499381175832680e-01 
 	 9.008807262155826e-01  7.105799454932382e-02  4.282110210444294e-01 
 	 8.183567728741640e-01  6.782934254209974e-02  5.706937642740548e-01 
 	 7.733985248903852e-01  6.708274444163291e-02  6.303607118908623e-01 
 	 6.303607118908623e-01  6.708274444163291e-02  7.733985248903853e-01 
 	 3.690401405209771e-01  7.300408182722849e-02  9.265418386240423e-01 
 	 3.129522107118871e-01  7.521111207819622e-02  9.467862495994033e-01 
 	 2.007385942716276e-01  8.087068291612894e-02  9.763011571305905e-01 
 	 1.629978258544382e-01  8.322154286307563e-02  9.831103109876407e-01 
 	 1.165142135571584e-01  8.649626087206887e-02  9.894154005746565e-01 
 	 9.944342010672392e-01  7.078581634875912e-02  7.803837486520031e-02 
 	 9.896676313075087e-01  6.784330033495196e-02  1.263141565377632e-01 
 	 9.773369143555996e-01  6.399527628364121e-02  2.017849361356196e-01 
 	 9.566991398484535e-01  6.061531865962382e-02  2.846972759915727e-01 
 	 8.485453454683282e-01  5.447423496337445e-02  5.263110814045155e-01 
 	 7.061138633100724e-01  5.297569331918472e-02  7.061138633100726e-01 
 	 5.263110814045155e-01  5.447423496337445e-02  8.485453454683283e-01 
 	 2.330295905328497e-01  6.262807751306232e-02  9.704508920306634e-01 
 	 1.079222423484036e-01  6.891502462751602e-02  9.917678705156169e-01 
 	 8.213125843255693e-02  7.051958606270797e-02  9.941234552960859e-01 
 	 9.965521196981694e-01  5.485426688750404e-02  6.224855122266036e-02 
 	 9.833242470600674e-01  4.992357780988357e-02  1.748744164319418e-01 
 	 9.738469385685609e-01  4.828391122204059e-02  2.220153241507075e-01 
 	 9.264392542342962e-01  4.426371642231205e-02  3.738328926436065e-01 
 	 9.084479421682466e-01  4.343707264674549e-02  4.157349601490827e-01 
 	 8.763130468562753e-01  4.237851163850940e-02  4.798744686486001e-01 
 	 7.429507699726536e-01  4.068056257140339e-02  6.681087076411407e-01 
 	 4.369971737106085e-01  4.305903812527737e-02  8.984316275625354e-01 
 	 3.738328926436063e-01  4.426371642231193e-02  9.264392542342963e-01 
 	 3.133247373617058e-01  4.566046191618418e-02  9.485476957827786e-01 
 	 2.751373865809669e-01  4.667653333384778e-02  9.602711699001120e-01 
 	 1.898610463366905e-01  4.937877086379139e-02  9.805684678144195e-01 
 	 1.472462338747260e-01  5.099000298817004e-02  9.877846760326746e-01 
 	 1.229357103696253e-01  5.199991624926511e-02  9.910513709318932e-01 
 	 9.978060021509840e-01  4.040770806297085e-02  5.244424849846081e-02 
 	 9.960281618553052e-01  3.940837086103224e-02  7.984285251180287e-02 
 	 9.917344806464012e-01  3.800091133393930e-02  1.225506043836710e-01 
 	 9.726270507774437e-01  3.513093959565008e-02  2.297007557216537e-01 
 	 9.576587005577440e-01  3.393290657490716e-02  2.858992324184028e-01 
 	 9.448081750300791e-01  3.318717904582745e-02  3.259388340522061e-01 
 	 8.257313333080646e-01  3.029613025591747e-02  5.632494204922029e-01 
 	 7.949179055073524e-01  3.003288423969408e-02  6.059732249596916e-01 
 	 6.677211693387307e-01  2.980149458416467e-02  7.438147020175577e-01 
 	 6.059732249596914e-01  3.003288423969408e-02  7.949179055073526e-01 
 	 5.415690585202192e-01  3.045996374097696e-02  8.401042467827560e-01 
 	 4.321148314653493e-01  3.158946565141525e-02  9.012651541513912e-01 
 	 2.297007557216536e-01  3.513093959565013e-02  9.726270507774437e-01 
 	 9.935421221441271e-02  3.874392262251007e-02  9.942975656085428e-01 
 	 7.151762582848621e-02  3.970355038728657e-02  9.966488134154883e-01 
 	 9.987965310302369e-01  2.803726798760446e-02  4.024178432619839e-02 
 	 9.978312729626353e-01  2.753136325337873e-02  5.978941992675189e-02 
 	 9.946611917467473e-01  2.658333962989361e-02  9.971178309037552e-02 
 	 9.899090357704964e-01  2.574271032661393e-02  1.393463805233786e-01 
 	 9.851267325094272e-01  2.515364770974849e-02  1.699782777362849e-01 
 	 9.787331156613304e-01  2.456062272246404e-02  2.036621322665303e-01 
 	 9.655284361322076e-01  2.369428097245823e-02  2.592169363087445e-01 
 	 9.318469413756797e-01  2.240305991799337e-02  3.621593306199654e-01 
 	 8.927107684952776e-01  2.157504699683221e-02  4.501133203535031e-01 
 	 8.687796515542024e-01  2.124230816454159e-02  4.947430458219714e-01 
 	 7.623658534916997e-01  2.054361319282763e-02  6.468201182607538e-01 
 	 7.069585635193523e-01  2.047385975599307e-02  7.069585635193523e-01 
 	 6.468201182607536e-01  2.054361319282758e-02  7.623658534916999e-01 
 	 5.170244041527918e-01  2.109751971070926e-02  8.557106170736150e-01 
 	 4.724206841135873e-01  2.140157939873785e-02  8.811133125886191e-01 
 	 3.621593306199654e-01  2.240305991799342e-02  9.318469413756798e-01 
 	 2.592169363087444e-01  2.369428097245828e-02  9.655284361322076e-01 
 	 2.215522930971859e-01  2.426715849942565e-02  9.748464937833764e-01 
 	 1.699782777362849e-01  2.515364770974860e-02  9.851267325094271e-01 
 	 1.252623364280983e-01  2.603079295424862e-02  9.917821055507843e-01 
 	 9.971178309037530e-02  2.658333962989365e-02  9.946611917467473e-01 
 	 4.024178432619828e-02  2.803726798760451e-02  9.987965310302369e-01 
 	 9.995159936326299e-01  1.780295047586003e-02  2.551143717885815e-02 
 	 9.993907255199972e-01  1.772499629033440e-02  3.006663019230725e-02 
 	 9.957341513875928e-01  1.677995869642137e-02  9.072999915450700e-02 
 	 9.912341558005692e-01  1.623543572759201e-02  1.311154415050652e-01 
 	 9.673296670192985e-01  1.491401883846330e-02  2.530827677784858e-01 
 	 9.491253137556656e-01  1.439721226430904e-02  3.145693231502808e-01 
 	 8.828142057064550e-01  1.344362371070157e-02  4.695299215006494e-01 
 	 7.972472984709721e-01  1.297452838544735e-02  6.035133856791512e-01 
 	 5.816667154847628e-01  1.302870927093865e-02  8.133228662910575e-01 
 	 4.243520330777634e-01  1.367444180291610e-02  9.053940366846622e-01 
 	 3.576582709584100e-01  1.408484350160228e-02  9.337463137269009e-01 
 	 1.463062362038900e-01  1.604591155460579e-02  9.891092022472713e-01 
 	 7.909524694752969e-02  1.694865184863926e-02  9.967229731027689e-01 
 	 5.871735282705372e-02  1.725796736456220e-02  9.981254605706774e-01 
 	 5.001616281996957e-02  1.739568734951546e-02  9.985969024177895e-01 
 	 3.006663019230720e-02  1.772499629033457e-02  9.993907255199974e-01 
 	 9.997093035640292e-01  9.648433787036450e-03  2.209561252785375e-02 
 	 9.990573892695345e-01  9.465006148390539e-03  4.236444977281108e-02 
 	 9.980911803207275e-01  9.305219497986718e-03  6.105250736923976e-02 
 	 9.964488093470282e-01  9.122664990100240e-03  8.370512131505482e-02 
 	 9.921574173872931e-01  8.820572589413345e-03  1.246830245966603e-01 
 	 9.848293078850499e-01  8.503608833571567e-03  1.733174052640400e-01 
 	 9.777732055790633e-01  8.293501070765871e-03  2.095012560621820e-01 
 	 9.571995366518216e-01  7.896740774807008e-03  2.893210820501567e-01 
 	 9.431878551643568e-01  7.717085200775391e-03  3.321703124399654e-01 
 	 9.067529863525752e-01  7.407464329912220e-03  4.215971432693629e-01 
 	 8.296603007647843e-01  7.088050690719872e-03  5.582235617315823e-01 
 	 7.453389072751585e-01  6.966443537742545e-03  6.666493695836725e-01 
 	 6.666493695836724e-01  6.966443537742609e-03  7.453389072751587e-01 
 	 6.026124004496576e-01  7.023293811372269e-03  7.980031128813601e-01 
 	 5.356744755074481e-01  7.128395936567780e-03  8.443944826093974e-01 
 	 3.105442187831565e-01  7.805055809857619e-03  9.505268903530104e-01 
 	 2.685542196629722e-01  7.991817098056447e-03  9.632314166183967e-01 
 	 2.095012560621820e-01  8.293501070765926e-03  9.777732055790632e-01 
 	 1.246830245966602e-01  8.820572589413336e-03  9.921574173872932e-01 
 	 9.645910154793352e-02  9.024913334830287e-03  9.952960326796566e-01 
 	 6.105250736923953e-02  9.305219497986700e-03  9.980911803207276e-01 
 	 4.236444977281085e-02  9.465006148390402e-03  9.990573892695342e-01 
 	 2.209561252785358e-02  9.648433787036432e-03  9.997093035640291e-01 
 	 9.999225564721038e-01  3.973479881147894e-03  1.179374901914139e-02 
 	 9.989382820984866e-01  3.847016961128102e-03  4.590761395047022e-02 
 	 9.907412720118993e-01  3.567379818681165e-03  1.357166376442960e-01 
 	 9.361169770553474e-01  3.119296692552212e-03  3.516749568236303e-01 
 	 8.849513666973879e-01  2.973853625123368e-03  4.656739575873247e-01 
 	 7.985134403051823e-01  2.867760942056863e-03  6.019701500898207e-01 
 	 4.887147931270147e-01  2.950801646459748e-03  8.724386189001850e-01 
 	 4.196590671515952e-01  3.026151191175780e-03  9.076767650250948e-01 
 	 3.741206875973186e-01  3.086374659679687e-03  9.273748893533670e-01 
 	 2.449306171541127e-01  3.308131608955869e-03  9.695349653549187e-01 
 	 2.057870554255758e-01  3.392408869986008e-03  9.785909152354367e-01 
 	 1.692654740306722e-01  3.479468031784591e-03  9.855643523400123e-01 
 	 7.875887909621503e-02  3.736473087158054e-03  9.968866925244697e-01 
 	 3.697244294742377e-02  3.878930898028772e-03  9.993087572705384e-01 
 	 1.179374901914134e-02  3.973479881147996e-03  9.999225564721037e-01 
 	 9.999627051735209e-01  7.573416397638598e-04  8.603179394548728e-03 
 	 9.999110620295296e-01  7.538554700172726e-04  1.331539458328751e-02 
 	 9.994235694901142e-01  7.391538797825353e-04  3.394086621141181e-02 
 	 9.985969489192359e-01  7.263647364215280e-04  5.294908878784090e-02 
 	 9.960366053002963e-01  7.039680889432500e-04  8.894147137748400e-02 
 	 9.946986695280060e-01  6.959126542248689e-04  1.028303094656064e-01 
 	 9.827392677536515e-01  6.540495991533455e-04  1.849948751564184e-01 
 	 9.700155422824742e-01  6.295994048669389e-04  2.430420772932680e-01 
 	 9.586389569421828e-01  6.142953663151558e-04  2.846242661369664e-01 
 	 9.446656321449255e-01  6.000803517093556e-04  3.280342716055744e-01 
 	 8.971897695027373e-01  5.704250748420593e-04  4.416448710387781e-01 
 	 8.728918466687279e-01  5.612115513228735e-04  4.879134237350443e-01 
 	 8.151016041143270e-01  5.476775128524877e-04  5.793177668772060e-01 
 	 7.640649422893554e-01  5.419293256463877e-04  6.451391092446420e-01 
 	 7.071066780869287e-01  5.400090157426379e-04  7.071066780869288e-01 
 	 6.451391092446419e-01  5.419293256463877e-04  7.640649422893555e-01 
 	 5.339557939972307e-01  5.536158857222405e-04  8.455122137297828e-01 
 	 4.647785358063456e-01  5.656192492252994e-04  8.854267856398824e-01 
 	 3.956145349670432e-01  5.811971354699290e-04  9.184164643192649e-01 
 	 3.280342716055744e-01  6.000803517095221e-04  9.446656321449255e-01 
 	 2.846242661369664e-01  6.142953663150276e-04  9.586389569421828e-01 
 	 2.230669759094922e-01  6.375862882372453e-04  9.748029122557642e-01 
 	 1.497321114755545e-01  6.708783900310999e-04  9.887263750478481e-01 
 	 1.176146275936178e-01  6.876714573026458e-04  9.930590750222171e-01 
 	 8.894147137748393e-02  7.039680889431774e-04  9.960366053002961e-01 
 	 7.597946711412423e-02  7.117729805569617e-04  9.971091284088607e-01 
 	 4.293113299414312e-02  7.330175553126541e-04  9.990777649938480e-01 
 	 3.394086621141146e-02  7.391538797825095e-04  9.994235694901141e-01 
 	 1.331539458328734e-02  7.538554700173750e-04  9.999110620295295e-01 
 	 4.990480419875689e-03  7.600476748878804e-04  9.999872586351841e-01 
 	 1.090087419841790e-03  7.630021801683373e-04  9.999991147681532e-01 
 	 5.729659198830621e-01  5.934272677339315e-01  5.652911927161054e-01 
 	 5.508767608104579e-01  6.270682097594844e-01  5.507451812844237e-01 
 	 5.798467319503559e-01  6.256726575445173e-01  5.218347372949348e-01 
 	 6.359235900307901e-01  5.661270469590235e-01  5.245010527575775e-01 
 	 5.489466487029693e-01  6.567473996655102e-01  5.170497363990909e-01 
 	 6.147736376953450e-01  6.033856917508181e-01  5.079164118092853e-01 
 	 5.531007358399714e-01  6.749370979354085e-01  4.884050469065722e-01 
 	 6.120981659664827e-01  6.391080446001449e-01  4.657002711485657e-01 
 	 6.736987969270112e-01  5.702375715171417e-01  4.700628075580225e-01 
 	 7.186251096179833e-01  4.917575661751418e-01  4.916832801062512e-01 
 	 5.683242035187277e-01  6.858873749039490e-01  4.544954440279609e-01 
 	 6.609092005325541e-01  6.000601036368595e-01  4.506960180373704e-01 
 	 5.277091004965637e-01  7.233695301913924e-01  4.452635489727312e-01 
 	 6.375662869274162e-01  6.375662869274161e-01  4.324563094084480e-01 
 	 6.940649656069565e-01  5.719545451137736e-01  4.371976919434852e-01 
 	 7.289787494097323e-01  5.179448617557424e-01  4.475746899567130e-01 
 	 7.515370599847528e-01  4.712660760381608e-01  4.616279162324008e-01 
 	 4.944670930121220e-01  7.526218649642167e-01  4.348133189150558e-01 
 	 5.968773921196413e-01  6.855229454466333e-01  4.168880785566170e-01 
 	 6.741766919189677e-01  6.103661779842831e-01  4.158592512450046e-01 
 	 4.469691375128717e-01  7.853619740551560e-01  4.282816360984769e-01 
 	 5.462205784082421e-01  7.333012405467845e-01  4.048609271538961e-01 
 	 6.347720448849359e-01  6.631892027187208e-01  3.965407071536346e-01 
 	 7.285481784340172e-01  5.533438174561739e-01  4.037674719235120e-01 
 	 7.501564565549338e-01  5.190394729961944e-01  4.097112594996365e-01 
 	 7.813778685145151e-01  4.567808294653352e-01  4.252057154233391e-01 
 	 4.907650014240011e-01  7.763361197399057e-01  3.955400644239305e-01 
 	 6.146197562670991e-01  6.920786996527576e-01  3.785097471573484e-01 
 	 6.702025730613276e-01  6.390075977770288e-01  3.774888091655262e-01 
 	 8.017435016463780e-01  4.348563982730648e-01  4.100088663050860e-01 
 	 4.319916489484505e-01  8.140344246086230e-01  3.882411245487871e-01 
 	 5.713532719267305e-01  7.362635118825126e-01  3.625899608773648e-01 
 	 7.084038560450860e-01  6.074029509030158e-01  3.594796683746688e-01 
 	 7.487205302655707e-01  5.535822730514387e-01  3.646426120491747e-01 
 	 7.798559868464031e-01  5.031927979287129e-01  3.723192821927120e-01 
 	 4.115235632924889e-01  8.326680011832442e-01  3.705568197463833e-01 
 	 4.860301967807032e-01  7.989604810185950e-01  3.541705769651770e-01 
 	 5.305658319033167e-01  7.732913371246678e-01  3.471604901838412e-01 
 	 6.373028408500622e-01  6.925175049302329e-01  3.380304637301870e-01 
 	 7.255007377669612e-01  5.983207466877060e-01  3.400896405106467e-01 
 	 8.307147985407738e-01  4.166398188341902e-01  3.692210514680533e-01 
 	 4.584858181662647e-01  8.222504063772315e-01  3.371869270195519e-01 
 	 5.979599982083988e-01  7.350299998664680e-01  3.196478372191993e-01 
 	 7.922137565447365e-01  5.144700645872000e-01  3.282040776482204e-01 
 	 8.179860940509872e-01  4.671883174579823e-01  3.356096333092797e-01 
 	 8.508223644355936e-01  3.899054698488534e-01  3.522428548007339e-01 
 	 5.403358102113984e-01  7.847293989971582e-01  3.037054206838438e-01 
 	 6.425943850897029e-01  7.063964630739722e-01  2.967768407537368e-01 
 	 6.962742408846053e-01  6.536705186941429e-01  2.965080681376087e-01 
 	 7.352103243150780e-01  6.087155301589835e-01  2.982133168786827e-01 
 	 7.772859408660294e-01  5.516139253525018e-01  3.025700637690650e-01 
 	 8.484268461038100e-01  4.204479230647266e-01  3.215515989711444e-01 
 	 8.749888512792822e-01  3.456938099766840e-01  3.389547165636829e-01 
 	 3.605101339970802e-01  8.797333161324344e-01  3.100027996196770e-01 
 	 3.975553156065222e-01  8.663342206845193e-01  3.023487871712821e-01 
 	 4.882006559144138e-01  8.238302857054438e-01  2.880343380904833e-01 
 	 6.085443317317614e-01  7.435075011811521e-01  2.772551027564745e-01 
 	 7.623744034475627e-01  5.840388467693376e-01  2.787183065970283e-01 
 	 8.751128734589049e-01  3.740066115270848e-01  3.070773733776665e-01 
 	 3.111938332805847e-01  9.031257486130640e-01  2.958416473727594e-01 
 	 5.819330848307496e-01  7.713414702626855e-01  2.576552367648801e-01 
 	 6.958241788844464e-01  6.716615562150847e-01  2.543608971176909e-01 
 	 7.409188977270671e-01  6.210412140048617e-01  2.556305879551108e-01 
 	 7.984717041441813e-01  5.427417599365340e-01  2.605270037867106e-01 
 	 8.221356358994869e-01  5.043021294536582e-01  2.641445786168098e-01 
 	 8.591002537873844e-01  4.328963044325281e-01  2.730339604355322e-01 
 	 9.057956318121120e-01  3.008948134193496e-01  2.983229536046992e-01 
 	 4.091886409339557e-01  8.765759365563186e-01  2.533363052960136e-01 
 	 4.576502461214377e-01  8.540961659222445e-01  2.471355732829843e-01 
 	 4.969490563420076e-01  8.330699626390708e-01  2.429733992628105e-01 
 	 5.517214508156262e-01  7.992325810473302e-01  2.383919505820687e-01 
 	 6.210532602087206e-01  7.478284267041635e-01  2.346177576341885e-01 
 	 6.746861537647574e-01  7.002390374772365e-01  2.333749864725689e-01 
 	 7.695524503800623e-01  5.934364141793005e-01  2.358436949338599e-01 
 	 8.474962933105012e-01  4.705170825695894e-01  2.456902680920900e-01 
 	 9.025582661529761e-01  3.397156969852801e-01  2.645407745901164e-01 
 	 3.221579891543644e-01  9.149726757126367e-01  2.429799018916476e-01 
 	 3.726575010565746e-01  8.976792178120627e-01  2.351561370974448e-01 
 	 4.211989056117900e-01  8.776137116443036e-01  2.288791275877716e-01 
 	 5.915759122606898e-01  7.770703622498362e-01  2.149409038453153e-01 
 	 7.299789581576487e-01  6.494473143198671e-01  2.129528270997725e-01 
 	 7.981983954811528e-01  5.621450490102415e-01  2.165000353916521e-01 
 	 8.832068407103533e-01  4.084783090155833e-01  2.304151635335801e-01 
 	 8.976792178120628e-01  3.726575010565745e-01  2.351561370974447e-01 
 	 9.121246599008405e-01  3.312444071619879e-01  2.414658309671973e-01 
 	 2.536099121118847e-01  9.395596635760491e-01  2.300209796072167e-01 
 	 3.350468849908456e-01  9.169016943363884e-01  2.168752355180081e-01 
 	 5.120283394773885e-01  8.356808594251416e-01  1.986566907065678e-01 
 	 6.503624580116684e-01  7.348560955907366e-01  1.923933262412163e-01 
 	 7.840817292982681e-01  5.894613281317075e-01  1.942966402639034e-01 
 	 8.262926525575369e-01  5.274332722213803e-01  1.976223562334918e-01 
 	 8.445967618235389e-01  4.967395589059703e-01  1.997651634672432e-01 
 	 9.264403491231902e-01  3.044603808699597e-01  2.213868921075061e-01 
 	 9.369050714400314e-01  2.650474478628008e-01  2.279445930294585e-01 
 	 3.077340166159567e-01  9.308490845270130e-01  1.970272997648605e-01 
 	 4.272387661472583e-01  8.852064886708543e-01  1.840557228558385e-01 
 	 4.579871277053901e-01  8.702285293381777e-01  1.815216173960530e-01 
 	 5.382333989994452e-01  8.241541335813729e-01  1.762803797994561e-01 
 	 6.193653304409964e-01  7.658138909448835e-01  1.729614751428000e-01 
 	 7.254325207145085e-01  6.664534148081174e-01  1.720101851065619e-01 
 	 7.658138909448836e-01  6.193653304409962e-01  1.729614751428000e-01 
 	 9.146158904083805e-01  3.563069610562947e-01  1.911102365529209e-01 
 	 2.250789644382485e-01  9.566785781908321e-01  1.846769010953276e-01 
 	 2.691090045860422e-01  9.463958114441628e-01  1.786485704719023e-01 
 	 3.564801629483098e-01  9.189025282044223e-01  1.689379681536017e-01 
 	 5.845939215963389e-01  7.965200876845047e-01  1.542909483660094e-01 
 	 6.833173672049881e-01  7.140659849600988e-01  1.522732570053166e-01 
 	 7.965200876845048e-01  5.845939215963388e-01  1.542909483660094e-01 
 	 8.518207930388926e-01  4.993888933707805e-01  1.581520462229284e-01 
 	 8.787080298126095e-01  4.492839758276502e-01  1.612950941824995e-01 
 	 9.009731442577760e-01  4.013021180299269e-01  1.649363616397287e-01 
 	 9.329167145729530e-01  3.157424850280022e-01  1.731273716624533e-01 
 	 9.551030247643088e-01  2.325316608320537e-01  1.835953125674918e-01 
 	 9.610700915082871e-01  2.023528110509096e-01  1.881425498605980e-01 
 	 1.863267842134664e-01  9.683551088494117e-01  1.660443092969845e-01 
 	 3.434339728554477e-01  9.273249758365621e-01  1.487329670195645e-01 
 	 4.753786711416766e-01  8.686265777978004e-01  1.396530965172471e-01 
 	 5.463747743416407e-01  8.263586520041764e-01  1.364037544239954e-01 
 	 6.513745249591120e-01  7.468934500382731e-01  1.336465582206169e-01 
 	 8.263586520041766e-01  5.463747743416405e-01  1.364037544239954e-01 
 	 9.414272611277742e-01  3.006944201800316e-01  1.526354404391462e-01 
 	 9.711265521396262e-01  1.688221738443947e-01  1.685594653167100e-01 
 	 2.130744480303685e-01  9.669916058787246e-01  1.397373026669669e-01 
 	 2.859668768099768e-01  9.489989697674359e-01  1.327550403860159e-01 
 	 4.143397168099800e-01  9.016772342550045e-01  1.236962582298727e-01 
 	 5.791375196326831e-01  8.068104241826495e-01  1.168617678452484e-01 
 	 6.335266506400685e-01  7.650191756245281e-01  1.157136286508375e-01 
 	 6.856892697453222e-01  7.187226003831741e-01  1.151870177345302e-01 
 	 7.500577948270778e-01  6.512145503968324e-01  1.154682370636739e-01 
 	 7.934142693310654e-01  5.974464223119278e-01  1.164112094625308e-01 
 	 8.652917241544668e-01  4.866730960983152e-01  1.200813459446150e-01 
 	 9.093652224045835e-01  3.968622385471578e-01  1.247207115775128e-01 
 	 9.622969057179480e-01  2.346856938649949e-01  1.375037830052998e-01 
 	 9.720998811850726e-01  1.861402608832096e-01  1.427362052119165e-01 
 	 9.772260137570289e-01  1.532738965750445e-01  1.467529579437830e-01 
 	 1.465137621636724e-01  9.812965572898672e-01  1.248630615822839e-01 
 	 1.956088380299367e-01  9.733177360373106e-01  1.199573557552094e-01 
 	 3.348412185594749e-01  9.359031226746286e-01  1.093924280811300e-01 
 	 4.614085308718846e-01  8.811843578519948e-01  1.030354070968645e-01 
 	 4.996173312097744e-01  8.602651558894380e-01  1.016188167483929e-01 
 	 8.488930449496310e-01  5.188271743924981e-01  1.009899071592802e-01 
 	 8.907359650016881e-01  4.425054573653817e-01  1.038188848638144e-01 
 	 9.415468895435194e-01  3.182674658160985e-01  1.104322190029814e-01 
 	 9.594869783119925e-01  2.573351133317547e-01  1.147317649836135e-01 
 	 9.687557569406160e-01  2.181829548002116e-01  1.179342258594298e-01 
 	 1.087360589345240e-01  9.882717010401946e-01  1.072171367389941e-01 
 	 2.430902704867330e-01  9.651982255442598e-01  9.643394527291242e-02 
 	 3.593704437406040e-01  9.288464757580740e-01  8.998393544120446e-02 
 	 4.158090169538312e-01  9.052244392615026e-01  8.758753326579302e-02 
 	 4.942573546828560e-01  8.651552703107056e-01  8.494719298196725e-02 
 	 5.734717137324328e-01  8.150043738421485e-01  8.305458546615098e-02 
 	 6.315067287074575e-01  7.710039578872682e-01  8.217145805797460e-02 
 	 6.688539746292276e-01  7.388743168611740e-01  8.184805743338104e-02 
 	 7.047405808933487e-01  7.047405808933485e-01  8.173999806833461e-02 
 	 7.710039578872682e-01  6.315067287074574e-01  8.217145805797460e-02 
 	 8.009239198036189e-01  5.930263859268188e-01  8.270780060539600e-02 
 	 8.535598235248635e-01  5.141130418389644e-01  8.440028362091637e-02 
 	 9.288464757580740e-01  3.593704437406040e-01  8.998393544120441e-02 
 	 9.614111828895736e-01  2.580165234913520e-01  9.547780380961474e-02 
 	 9.833287035160707e-01  1.495232131105627e-01  1.034769036186184e-01 
 	 1.240835141942853e-01  9.885438791506085e-01  8.593183635337825e-02 
 	 1.520061353169545e-01  9.848073569345908e-01  8.395596794456696e-02 
 	 2.007385942716275e-01  9.763011571305904e-01  8.087068291612881e-02 
 	 4.483910396495137e-01  8.910546089433282e-01  7.047807774677642e-02 
 	 7.055312443081614e-01  7.055312443081613e-01  6.671826294167989e-02 
 	 8.805767987070414e-01  4.687147516102030e-01  6.993556464235100e-02 
 	 9.100629994456690e-01  4.082257080046208e-01  7.167362390781112e-02 
 	 9.406092904048070e-01  3.312268315858956e-01  7.445098281241187e-02 
 	 9.663266990255628e-01  2.450791563508765e-01  7.841503601160976e-02 
 	 9.763011571305904e-01  2.007385942716275e-01  8.087068291612881e-02 
 	 9.831103109876408e-01  1.629978258544381e-01  8.322154286307552e-02 
 	 9.911837195105994e-01  9.919412063370919e-02  8.783712545864919e-02 
 	 1.000809854703444e-01  9.925567185901233e-01  6.938988924109471e-02 
 	 2.017849361356196e-01  9.773369143555994e-01  6.399527628364132e-02 
 	 2.496501775049478e-01  9.663525206215806e-01  6.194832330310242e-02 
 	 3.030411659090205e-01  9.510887421360729e-01  5.996879477298306e-02 
 	 3.608183844662939e-01  9.308218901667400e-01  5.814380635588839e-02 
 	 5.263110814045155e-01  8.485453454683282e-01  5.447423496337450e-02 
 	 8.066054191277688e-01  5.886508640835549e-01  5.364567128297098e-02 
 	 8.485453454683283e-01  5.263110814045154e-01  5.447423496337450e-02 
 	 9.228486983491648e-01  3.808341108198681e-01  5.758176787223957e-02 
 	 9.510887421360730e-01  3.030411659090205e-01  5.996879477298307e-02 
 	 9.741023950902492e-01  2.170625442389272e-01  6.331173483615728e-02 
 	 9.908125040812401e-01  1.166717614476645e-01  6.839796661423372e-02 
 	 5.551218062369367e-02  9.969307523578869e-01  5.520392020083408e-02 
 	 9.310886486720907e-02  9.942261558532596e-01  5.333938788915517e-02 
 	 1.229357103696255e-01  9.910513709318932e-01  5.199991624926505e-02 
 	 1.748744164319418e-01  9.833242470600674e-01  4.992357780988362e-02 
 	 2.751373865809669e-01  9.602711699001120e-01  4.667653333384773e-02 
 	 3.946623868025467e-01  9.177797891856879e-01  4.383901237016365e-02 
 	 5.013811174176673e-01  8.642027829989671e-01  4.207760632273976e-02 
 	 6.280203737616906e-01  7.771236198835780e-01  4.085694016040138e-02 
 	 6.875457008445353e-01  7.250031671826669e-01  4.063639778940437e-02 
 	 7.603338946741162e-01  6.482526291914544e-01  4.075410845616167e-02 
 	 8.642027829989672e-01  5.013811174176672e-01  4.207760632273976e-02 
 	 9.177797891856880e-01  3.946623868025464e-01  4.383901237016365e-02 
 	 9.344413959457128e-01  3.532991709460285e-01  4.470987980163187e-02 
 	 9.653027116727649e-01  2.568316175682113e-01  4.720376102073575e-02 
 	 9.857191150666224e-01  1.606593360808787e-01  5.046190565492129e-02 
 	 9.954962422202280e-01  7.786945573951944e-02  5.407013582594612e-02 
 	 4.244384872331381e-02  9.982657140758290e-01  4.079318333040160e-02 
 	 5.780590028209006e-02  9.975179081804001e-01  4.020573033755227e-02 
 	 1.492442052863231e-01  9.881002081600231e-01  3.720411029137774e-02 
 	 1.792090147076348e-01  9.831382376771123e-01  3.637766711405087e-02 
 	 2.478565013624170e-01  9.681742835268681e-01  3.472335596710006e-02 
 	 4.539636544544828e-01  8.904694473433562e-01  3.132353400159017e-02 
 	 6.475134695631768e-01  7.614689001325731e-01  2.985667203735900e-02 
 	 7.949179055073526e-01  6.059732249596915e-01  3.003288423969414e-02 
 	 8.257313333080647e-01  5.632494204922027e-01  3.029613025591752e-02 
 	 8.904694473433562e-01  4.539636544544826e-01  3.132353400159017e-02 
 	 9.515385057936048e-01  3.056936768410167e-01  3.355365749801228e-02 
 	 9.726270507774437e-01  2.297007557216536e-01  3.513093959565013e-02 
 	 9.800766921966652e-01  1.953369505114140e-01  3.596043906495950e-02 
 	 9.881002081600230e-01  1.492442052863230e-01  3.720411029137774e-02 
 	 9.931344775067941e-01  1.105026348219635e-01  3.838068895565658e-02 
 	 9.960281618553052e-01  7.984285251180240e-02  3.940837086103216e-02 
 	 9.975179081804001e-01  5.780590028208989e-02  4.020573033755238e-02 
 	 3.577975394987721e-02  9.989629610943350e-01  2.815690979003432e-02 
 	 6.831832034469627e-02  9.972894509607101e-01  2.731955540935310e-02 
 	 7.782794687902866e-02  9.965987006426081e-01  2.708949172761203e-02 
 	 1.120413660247090e-01  9.933551352048527e-01  2.631173999312848e-02 
 	 1.699782777362849e-01  9.851267325094272e-01  2.515364770974849e-02 
 	 2.789002938523081e-01  9.600344991874482e-01  2.341765272185943e-02 
 	 3.407689008879605e-01  9.398744282227144e-01  2.264101059222072e-02 
 	 4.057688828186643e-01  9.137117894237223e-01  2.196314194718684e-02 
 	 5.612432195585725e-01  8.273881979031047e-01  2.085230131617881e-02 
 	 7.069585635193523e-01  7.069585635193522e-01  2.047385975599306e-02 
 	 9.398744282227145e-01  3.407689008879604e-01  2.264101059222072e-02 
 	 9.655284361322076e-01  2.592169363087445e-01  2.369428097245829e-02 
 	 9.933551352048529e-01  1.120413660247088e-01  2.631173999312830e-02 
 	 9.972894509607103e-01  6.831832034469575e-02  2.731955540935314e-02 
 	 9.987965310302369e-01  4.024178432619815e-02  2.803726798760445e-02 
 	 3.006663019230731e-02  9.993907255199973e-01  1.772499629033457e-02 
 	 5.001616281996974e-02  9.985969024177895e-01  1.739568734951540e-02 
 	 7.909524694752974e-02  9.967229731027689e-01  1.694865184863920e-02 
 	 1.167683002235344e-01  9.930234063366794e-01  1.642189180346486e-02 
 	 1.463062362038899e-01  9.891092022472712e-01  1.604591155460567e-02 
 	 2.336320145514883e-01  9.722078875940978e-01  1.509652530998408e-02 
 	 5.372304747228271e-01  8.433327156565432e-01  1.316615860628603e-02 
 	 6.250436615510157e-01  7.804826922953080e-01  1.293012692772513e-02 
 	 7.804826922953081e-01  6.250436615510155e-01  1.293012692772513e-02 
 	 8.433327156565432e-01  5.372304747228270e-01  1.316615860628585e-02 
 	 9.155704080985479e-01  4.019207703329067e-01  1.380297755055416e-02 
 	 9.722078875940979e-01  2.336320145514885e-01  1.509652530998405e-02 
 	 9.803645702016364e-01  1.965856755926302e-01  1.547196319636958e-02 
 	 9.891092022472712e-01  1.463062362038899e-01  1.604591155460573e-02 
 	 9.981254605706775e-01  5.871735282705377e-02  1.725796736456227e-02 
 	 9.989500170761046e-01  4.233088244666092e-02  1.752026754753886e-02 
 	 9.995979324512198e-01  2.201979814416566e-02  1.786342433401678e-02 
 	 1.391752904345785e-02  9.998558470557578e-01  9.725610198716660e-03 
 	 2.779635020142727e-02  9.995675489018885e-01  9.595733309676252e-03 
 	 4.236444977281102e-02  9.990573892695344e-01  9.465006148390411e-03 
 	 6.105250736923971e-02  9.980911803207276e-01  9.305219497986765e-03 
 	 8.370512131505484e-02  9.964488093470283e-01  9.122664990100351e-03 
 	 1.400898712914405e-01  9.901004326933692e-01  8.715568940164214e-03 
 	 1.733174052640400e-01  9.848293078850497e-01  8.503608833571558e-03 
 	 2.095012560621820e-01  9.777732055790633e-01  8.293501070765982e-03 
 	 2.893210820501567e-01  9.571995366518216e-01  7.896740774807063e-03 
 	 3.321703124399654e-01  9.431878551643568e-01  7.717085200775446e-03 
 	 3.989150552692544e-01  9.169573908471248e-01  7.478104730539589e-03 
 	 4.901401313247469e-01  8.716137070071491e-01  7.224778350592762e-03 
 	 5.805539649079974e-01  8.141912238316126e-01  7.053003983036714e-03 
 	 6.666493695836726e-01  7.453389072751585e-01  6.966443537742665e-03 
 	 7.453389072751587e-01  6.666493695836723e-01  6.966443537742665e-03 
 	 7.980031128813601e-01  6.026124004496577e-01  7.023293811372388e-03 
 	 8.716137070071492e-01  4.901401313247468e-01  7.224778350592762e-03 
 	 9.067529863525753e-01  4.215971432693627e-01  7.407464329912275e-03 
 	 9.351594661327068e-01  3.541447564320079e-01  7.633111692122406e-03 
 	 9.571995366518214e-01  2.893210820501567e-01  7.896740774807008e-03 
 	 9.686505625473854e-01  2.482954709493568e-01  8.089918582466951e-03 
 	 9.848293078850497e-01  1.733174052640401e-01  8.503608833571631e-03 
 	 9.938772933104135e-01  1.101285113439735e-01  8.923947059822610e-03 
 	 9.964488093470283e-01  8.370512131505466e-02  9.122664990100351e-03 
 	 9.993572425229532e-01  3.455716417065854e-02  9.534370529891666e-03 
 	 9.999014737788916e-01  1.008652378718247e-02  9.762416334665317e-03 
 	 8.204188007007908e-03  9.999583945395807e-01  3.987541720152202e-03 
 	 9.164578836327868e-02  9.957848112119617e-01  3.695840206355519e-03 
 	 1.201568686833744e-01  9.927483507183253e-01  3.610963064223943e-03 
 	 1.520989118465471e-01  9.883589966751497e-01  3.523450920269778e-03 
 	 2.449306171541126e-01  9.695349653549186e-01  3.308131608955750e-03 
 	 3.516749568236303e-01  9.361169770553472e-01  3.119296692552093e-03 
 	 4.196590671515955e-01  9.076767650250946e-01  3.026151191175900e-03 
 	 5.345749563799799e-01  8.451160521976030e-01  2.911070126417063e-03 
 	 6.238476575628773e-01  7.815407433531713e-01  2.857732017455088e-03 
 	 7.266341380240906e-01  6.870187466333664e-01  2.840991429973072e-03 
 	 9.178994571684486e-01  3.968012747719079e-01  3.055301827371465e-03 
 	 9.441429410346454e-01  3.295211059853744e-01  3.153982343953039e-03 
 	 9.581308083829488e-01  2.863126482580355e-01  3.228230925343339e-03 
 	 9.785909152354367e-01  2.057870554255757e-01  3.392408869985953e-03 
 	 9.907412720118993e-01  1.357166376442959e-01  3.567379818681221e-03 
 	 9.944173159417676e-01  1.054554447770035e-01  3.653891357866853e-03 
 	 9.984310559127969e-01  5.586494543148716e-02  3.812408791637501e-03 
 	 9.993087572705385e-01  3.697244294742364e-02  3.878930898028772e-03 
 	 9.995695002195527e-01  2.907822435770188e-02  3.907825359052179e-03 
 	 9.998564385460688e-01  1.647596459955685e-02  3.955361991722912e-03 
 	 9.999756827939534e-01  5.714432719859457e-03  3.997384076694770e-03 
 	 1.090087419841818e-03  9.999991147681532e-01  7.630021801683563e-04 
 	 4.990480419875929e-03  9.999872586351841e-01  7.600476748880087e-04 
 	 1.331539458328740e-02  9.999110620295295e-01  7.538554700173194e-04 
 	 2.599740522966495e-02  9.996617329512637e-01  7.447108169914197e-04 
 	 4.293113299414365e-02  9.990777649938481e-01  7.330175553126244e-04 
 	 6.397319400853811e-02  9.979513580892012e-01  7.192609157332392e-04 
 	 1.332606308933922e-01  9.910807952917023e-01  6.793068980579277e-04 
 	 1.849948751564183e-01  9.827392677536515e-01  6.540495991533369e-04 
 	 2.230669759094920e-01  9.748029122557642e-01  6.375862882372922e-04 
 	 2.846242661369664e-01  9.586389569421828e-01  6.142953663152027e-04 
 	 3.280342716055744e-01  9.446656321449255e-01  6.000803517094666e-04 
 	 3.956145349670434e-01  9.184164643192650e-01  5.811971354699931e-04 
 	 4.416448710387780e-01  8.971897695027373e-01  5.704250748420507e-04 
 	 5.793177668772060e-01  8.151016041143270e-01  5.476775128525987e-04 
 	 6.662847273008889e-01  7.456972372438323e-01  5.408627327213613e-04 
 	 7.640649422893555e-01  6.451391092446418e-01  5.419293256464432e-04 
 	 7.987924061044164e-01  6.016065113978549e-01  5.453380782532750e-04 
 	 8.306801970482143e-01  5.567495911541280e-01  5.504376905905585e-04 
 	 8.854267856398825e-01  4.647785358063456e-01  5.656192492254276e-04 
 	 9.278976471781557e-01  3.728345633461334e-01  5.871420107382907e-04 
 	 9.519902754467512e-01  3.061276644779314e-01  6.070388009470188e-04 
 	 9.790326983572690e-01  2.037021319343963e-01  6.457496933559730e-04 
 	 9.859582837330052e-01  1.669904904747598e-01  6.624418962644776e-04 
 	 9.930590750222171e-01  1.176146275936178e-01  6.876714573027739e-04 
 	 9.946986695280060e-01  1.028303094656062e-01  6.959126542248048e-04 
 	 9.979513580892011e-01  6.397319400853793e-02  7.192609157332392e-04 
 	 9.985969489192359e-01  5.294908878784067e-02  7.263647364215194e-04 
 	 9.999627051735208e-01  8.603179394548553e-03  7.573416397637957e-04 
 	 9.999872586351842e-01  4.990480419875753e-03  7.600476748880087e-04 
 	 9.999966230868894e-01  2.484604472066873e-03  7.619418841651598e-04 
 	 5.622554852021887e-01  5.640513759794216e-01  6.047435941089185e-01 
 	 5.360261592466226e-01  5.634773835114335e-01  6.286248443025645e-01 
 	 5.206265153179888e-01  6.175869822148603e-01  5.895204415001993e-01 
 	 5.148958044713312e-01  5.162267010926306e-01  6.843919225245433e-01 
 	 4.956407022081860e-01  5.938180008624224e-01  6.338142284347460e-01 
 	 5.136330867898348e-01  6.830408359711904e-01  5.192651235645657e-01 
 	 4.868304939023584e-01  5.603805507389790e-01  6.700520192942221e-01 
 	 4.840659978988953e-01  6.589002219939298e-01  5.757869459570064e-01 
 	 4.590666194349483e-01  5.435680639106895e-01  7.027030658940895e-01 
 	 4.493902097401317e-01  6.367913355227730e-01  6.265343042426678e-01 
 	 4.766350380353088e-01  7.344270876637108e-01  4.831520396550965e-01 
 	 4.616279162324009e-01  4.712660760381608e-01  7.515370599847527e-01 
 	 4.344324865075545e-01  5.958921206181490e-01  6.754117227677271e-01 
 	 4.441323065878165e-01  7.203103416157949e-01  5.328222086271580e-01 
 	 4.175212801858129e-01  6.909548463249923e-01  5.901333585995678e-01 
 	 4.348133189150559e-01  7.526218649642166e-01  4.944670930121219e-01 
 	 4.326122030841215e-01  4.341260310075292e-01  7.901779995319742e-01 
 	 4.084391731519492e-01  5.256089880806569e-01  7.462657927868461e-01 
 	 4.000304788557573e-01  5.826855148987496e-01  7.074271741413477e-01 
 	 3.967735993290629e-01  6.274377580885803e-01  6.699944556488782e-01 
 	 4.008598979628201e-01  7.130167276510881e-01  5.752551506027318e-01 
 	 4.072026176550891e-01  7.421602699985618e-01  5.323383903218941e-01 
 	 3.874474918155852e-01  5.336744416569233e-01  7.517153925575711e-01 
 	 3.773416718450704e-01  6.625930905199544e-01  6.469804163066937e-01 
 	 3.941252977800329e-01  7.728119259115956e-01  4.974203220804421e-01 
 	 4.039527236001429e-01  7.930041460293079e-01  4.560335749441641e-01 
 	 3.869047722653029e-01  4.369918712949035e-01  8.119992620812611e-01 
 	 3.781901978244283e-01  4.734705611656690e-01  7.954858904964853e-01 
 	 3.709165474647612e-01  5.111770083963700e-01  7.753186318564511e-01 
 	 3.601234185884287e-01  5.983781632619376e-01  7.157197056917277e-01 
 	 3.584773561306583e-01  6.253557482280905e-01  6.931263761390546e-01 
 	 3.589301859591420e-01  7.008691303006287e-01  6.164021283212575e-01 
 	 3.625899608773648e-01  7.362635118825126e-01  5.713532719267302e-01 
 	 3.730270155715240e-01  4.023944337182246e-01  8.360200747388732e-01 
 	 3.375591985234553e-01  6.656026545515734e-01  6.656026545515734e-01 
 	 3.447485077061037e-01  7.610292655777420e-01  5.495297292855204e-01 
 	 3.692210514680534e-01  8.307147985407737e-01  4.166398188341901e-01 
 	 3.566811479989040e-01  3.732946941541180e-01  8.564050618594962e-01 
 	 3.244043641928766e-01  5.451101697463622e-01  7.730567322853529e-01 
 	 3.183951665103194e-01  6.191554840900700e-01  7.178237976440018e-01 
 	 3.175486776078052e-01  6.996020093679458e-01  6.400936383357256e-01 
 	 3.204203339038100e-01  7.432225835080980e-01  5.873252940104989e-01 
 	 3.282040776482206e-01  7.922137565447365e-01  5.144700645872000e-01 
 	 3.356096333092798e-01  8.179860940509871e-01  4.671883174579823e-01 
 	 3.522428548007339e-01  8.508223644355936e-01  3.899054698488534e-01 
 	 3.199284634973052e-01  4.288654270086351e-01  8.448196397817433e-01 
 	 3.134948604667019e-01  4.658623136894703e-01  8.274619490616211e-01 
 	 3.062034834343352e-01  5.181334500484025e-01  7.986095132626573e-01 
 	 3.015171882226180e-01  5.629749644810471e-01  7.695106071873798e-01 
 	 2.965080681376088e-01  6.536705186941431e-01  6.962742408846051e-01 
 	 3.037054206838439e-01  7.847293989971582e-01  5.403358102113983e-01 
 	 3.199284634973051e-01  8.448196397817433e-01  4.288654270086351e-01 
 	 3.366142861551808e-01  8.723947750123687e-01  3.544265493545263e-01 
 	 3.159983551724606e-01  3.350030858610918e-01  8.876474367629557e-01 
 	 3.023487871712822e-01  3.975553156065221e-01  8.663342206845193e-01 
 	 2.766731255147103e-01  6.207218183120962e-01  7.335914434405887e-01 
 	 2.753894555636595e-01  6.910447599860792e-01  6.682946860929941e-01 
 	 2.772551027564746e-01  7.435075011811522e-01  6.085443317317611e-01 
 	 2.839696080402432e-01  8.034865833784048e-01  5.232308974443006e-01 
 	 3.023487871712822e-01  8.663342206845192e-01  3.975553156065221e-01 
 	 3.159983551724604e-01  8.876474367629557e-01  3.350030858610917e-01 
 	 2.987927769404655e-01  2.989916259553511e-01  9.062708668255758e-01 
 	 2.669045598883646e-01  4.794991752476226e-01  8.359679998945223e-01 
 	 2.628635544204094e-01  5.169805424541205e-01  8.146372631308438e-01 
 	 2.568822190867845e-01  5.950193171012381e-01  7.615533715987509e-01 
 	 2.545205896462742e-01  6.592545720412425e-01  7.075328110334044e-01 
 	 2.551565601796630e-01  7.300988268450527e-01  6.339170551710688e-01 
 	 2.683711493277711e-01  8.423087111361948e-01  4.674323067060872e-01 
 	 2.630027910018990e-01  3.482422522154269e-01  8.997537805961908e-01 
 	 2.501667968977200e-01  4.327630793772350e-01  8.661020094988049e-01 
 	 2.333749864725690e-01  7.002390374772365e-01  6.746861537647573e-01 
 	 2.374517217963821e-01  7.897399948387317e-01  5.656212693738220e-01 
 	 2.405271394374237e-01  8.169835175269211e-01  5.241036417383389e-01 
 	 2.630027910018989e-01  8.997537805961909e-01  3.482422522154269e-01 
 	 2.773636433095512e-01  9.197946079082872e-01  2.775739336337120e-01 
 	 2.429799018916478e-01  3.221579891543644e-01  9.149726757126366e-01 
 	 2.194859621186721e-01  5.181632913324140e-01  8.266394110786158e-01 
 	 2.165000353916522e-01  5.621450490102415e-01  7.981983954811527e-01 
 	 2.142995058325291e-01  6.062186163181954e-01  7.658816560208153e-01 
 	 2.129528270997727e-01  6.494473143198672e-01  7.299789581576485e-01 
 	 2.137532165141049e-01  7.542930381075070e-01  6.207669249343276e-01 
 	 2.288791275877716e-01  8.776137116443037e-01  4.211989056117900e-01 
 	 2.290301810919177e-01  2.590108184448444e-01  9.383275398694931e-01 
 	 2.199124277849618e-01  3.141079280611969e-01  9.235663125270571e-01 
 	 2.107034839300808e-01  3.829310944244766e-01  8.994263831924205e-01 
 	 2.062566418406910e-01  4.233209108727660e-01  8.821890977077719e-01 
 	 1.997651634672434e-01  4.967395589059705e-01  8.445967618235387e-01 
 	 1.919597682367741e-01  6.939565719043534e-01  6.939565719043533e-01 
 	 1.923933262412164e-01  7.348560955907367e-01  6.503624580116681e-01 
 	 1.950002727623887e-01  7.953208566738037e-01  5.739683166885093e-01 
 	 1.986566907065679e-01  8.356808594251417e-01  5.120283394773882e-01 
 	 2.048495091418759e-01  8.755829447790969e-01  4.374827829941397e-01 
 	 2.107034839300806e-01  8.994263831924205e-01  3.829310944244766e-01 
 	 2.184054271318435e-01  9.203925472155322e-01  3.243094639838024e-01 
 	 2.118742467120456e-01  2.121171705914818e-01  9.539997953461349e-01 
 	 1.771868992831475e-01  5.219545283180210e-01  8.343669894541226e-01 
 	 1.729614751428001e-01  6.193653304409963e-01  7.658138909448835e-01 
 	 1.720101851065621e-01  6.664534148081175e-01  7.254325207145083e-01 
 	 1.729614751428001e-01  7.658138909448836e-01  6.193653304409962e-01 
 	 1.762803797994562e-01  8.241541335813730e-01  5.382333989994451e-01 
 	 1.896433611193575e-01  9.095994011717762e-01  3.696813830466704e-01 
 	 1.998954888411528e-01  9.369226669442122e-01  2.867363069217104e-01 
 	 2.072732174359827e-01  9.487367555179765e-01  2.386134574221644e-01 
 	 1.786485704719026e-01  2.691090045860422e-01  9.463958114441627e-01 
 	 1.731273716624535e-01  3.157424850280020e-01  9.329167145729530e-01 
 	 1.675740091177070e-01  3.710099596046795e-01  9.133841258432033e-01 
 	 1.612950941824997e-01  4.492839758276504e-01  8.787080298126094e-01 
 	 1.542909483660095e-01  5.845939215963389e-01  7.965200876845047e-01 
 	 1.522732570053167e-01  7.140659849600989e-01  6.833173672049881e-01 
 	 1.542909483660095e-01  7.965200876845047e-01  5.845939215963388e-01 
 	 1.601862352712337e-01  8.702686615846210e-01  4.658034206544017e-01 
 	 1.636750441351558e-01  8.940505064695906e-01  4.169942107617605e-01 
 	 1.887597750066208e-01  9.617568463429654e-01  1.984779984075909e-01 
 	 1.577979156111374e-01  2.517113814829288e-01  9.548514011408978e-01 
 	 1.474651674478558e-01  3.586666212132362e-01  9.217441506280671e-01 
 	 1.427232951454299e-01  4.235917642541461e-01  8.945390311657119e-01 
 	 1.364037544239956e-01  5.463747743416407e-01  8.263586520041765e-01 
 	 1.364037544239954e-01  8.263586520041766e-01  5.463747743416405e-01 
 	 1.474651674478556e-01  9.217441506280671e-01  3.586666212132362e-01 
 	 1.513249640181348e-01  9.371464063007447e-01  3.144159162995884e-01 
 	 1.552483757435259e-01  9.488354084601901e-01  2.749714703040684e-01 
 	 1.590283748201216e-01  9.573921317223660e-01  2.410607436273573e-01 
 	 1.417937516322153e-01  1.943662147363062e-01  9.706267596595212e-01 
 	 1.339583998576848e-01  2.721992138200191e-01  9.528707861527355e-01 
 	 1.303588961559690e-01  3.152274143234033e-01  9.400203377863581e-01 
 	 1.247207115775129e-01  3.968622385471579e-01  9.093652224045835e-01 
 	 1.193141006581402e-01  5.051370089717691e-01  8.547518631457870e-01 
 	 1.160281940662428e-01  6.155902736492562e-01  7.794780774147275e-01 
 	 1.152925708362841e-01  6.686146022969041e-01  7.346170000111032e-01 
 	 1.151870177345304e-01  7.187226003831741e-01  6.856892697453221e-01 
 	 1.157136286508377e-01  7.650191756245283e-01  6.335266506400683e-01 
 	 1.168617678452485e-01  8.068104241826496e-01  5.791375196326830e-01 
 	 1.209059943992807e-01  8.752497428623793e-01  4.683157355221580e-01 
 	 1.236962582298727e-01  9.016772342550046e-01  4.143397168099799e-01 
 	 1.291793140415831e-01  9.348684502536441e-01  3.306564463973082e-01 
 	 1.463083488985961e-01  9.767413798370571e-01  1.567486649275468e-01 
 	 1.248630615822841e-01  1.465137621636724e-01  9.812965572898672e-01 
 	 1.023013055408501e-01  4.804617745826948e-01  8.710286597176269e-01 
 	 9.842264293414210e-02  6.325765489871917e-01  7.682186492329598e-01 
 	 1.016188167483929e-01  8.602651558894381e-01  4.996173312097742e-01 
 	 1.114916038282533e-01  9.467039358124616e-01  3.021941101229447e-01 
 	 1.136472879594227e-01  9.556498345470649e-01  2.716941067996056e-01 
 	 1.189617364798521e-01  9.711819278962700e-01  2.065278871760000e-01 
 	 1.242065719572653e-01  9.804406396703221e-01  1.526724584379068e-01 
 	 1.034769036186186e-01  1.495232131105628e-01  9.833287035160707e-01 
 	 9.833309426547632e-02  2.152339413283363e-01  9.715991730505162e-01 
 	 9.547780380961493e-02  2.580165234913520e-01  9.614111828895736e-01 
 	 9.084734246596933e-02  3.412672746017780e-01  9.355658221914402e-01 
 	 8.758753326579319e-02  4.158090169538313e-01  9.052244392615028e-01 
 	 8.440028362091652e-02  5.141130418389646e-01  8.535598235248634e-01 
 	 8.345286477156869e-02  5.537692303601662e-01  8.284776755397379e-01 
 	 8.198295033763014e-02  7.552036142871456e-01  6.503432146348341e-01 
 	 8.305458546615108e-02  8.150043738421486e-01  5.734717137324327e-01 
 	 8.998393544120449e-02  9.288464757580740e-01  3.593704437406040e-01 
 	 1.001741783797120e-01  9.766156013470411e-01  1.902290755681345e-01 
 	 1.041859270082462e-01  9.844558105736653e-01  1.413932446801472e-01 
 	 8.649626087206901e-02  1.165142135571585e-01  9.894154005746564e-01 
 	 8.531672556666035e-02  1.325317379733736e-01  9.875000733004228e-01 
 	 8.087068291612901e-02  2.007385942716275e-01  9.763011571305905e-01 
 	 7.521111207819649e-02  3.129522107118871e-01  9.467862495994034e-01 
 	 7.232304348500276e-02  3.884855377623712e-01  9.186121947429979e-01 
 	 6.671826294167998e-02  7.055312443081614e-01  7.055312443081613e-01 
 	 6.728706304359600e-02  7.889890788819210e-01  6.107116214319366e-01 
 	 6.943193346609963e-02  8.694424979900374e-01  4.891308100130300e-01 
 	 7.047807774677657e-02  8.910546089433283e-01  4.483910396495135e-01 
 	 7.371430134491123e-02  9.338680397355456e-01  3.499381175832680e-01 
 	 7.678812460516034e-02  9.575393452128633e-01  2.778884421650947e-01 
 	 7.923638188478092e-02  9.700507972875431e-01  2.296149961731838e-01 
 	 8.322154286307559e-02  9.831103109876406e-01  1.629978258544381e-01 
 	 7.019599629379654e-02  8.717491213302353e-02  9.937167890294099e-01 
 	 6.891502462751604e-02  1.079222423484038e-01  9.917678705156168e-01 
 	 6.534478553202799e-02  1.734300682044595e-01  9.826759742897806e-01 
 	 6.194832330310267e-02  2.496501775049478e-01  9.663525206215806e-01 
 	 6.061531865962401e-02  2.846972759915726e-01  9.566991398484533e-01 
 	 5.814380635588865e-02  3.608183844662939e-01  9.308218901667400e-01 
 	 5.606177180070640e-02  4.424493180039760e-01  8.950394844588601e-01 
 	 5.520155770435178e-02  4.843120550970663e-01  8.731521180840537e-01 
 	 5.388609409077021e-02  5.680270989604128e-01  8.212438759042640e-01 
 	 5.344159523293460e-02  6.090522856021807e-01  7.913275613181426e-01 
 	 5.314374456060820e-02  6.489983764059198e-01  7.589313867778542e-01 
 	 5.447423496337447e-02  8.485453454683283e-01  5.263110814045153e-01 
 	 5.996879477298315e-02  9.510887421360729e-01  3.030411659090205e-01 
 	 6.127623728980380e-02  9.617780386377300e-01  2.668861688768541e-01 
 	 6.784330033495203e-02  9.896676313075087e-01  1.263141565377630e-01 
 	 7.019599629379654e-02  9.937167890294100e-01  8.717491213302347e-02 
 	 5.520392020083420e-02  5.551218062369360e-02  9.969307523578868e-01 
 	 5.099000298817017e-02  1.472462338747260e-01  9.877846760326745e-01 
 	 4.828391122204077e-02  2.220153241507074e-01  9.738469385685609e-01 
 	 4.383901237016374e-02  3.946623868025467e-01  9.177797891856878e-01 
 	 4.063639778940447e-02  7.250031671826669e-01  6.875457008445353e-01 
 	 4.085694016040159e-02  7.771236198835781e-01  6.280203737616904e-01 
 	 4.133953393511956e-02  8.236926321777697e-01  5.655276214563568e-01 
 	 4.383901237016361e-02  9.177797891856880e-01  3.946623868025464e-01 
 	 4.470987980163189e-02  9.344413959457128e-01  3.532991709460284e-01 
 	 4.828391122204072e-02  9.738469385685609e-01  2.220153241507075e-01 
 	 4.992357780988376e-02  9.833242470600673e-01  1.748744164319418e-01 
 	 5.407013582594613e-02  9.954962422202279e-01  7.786945573951937e-02 
 	 4.057405229547656e-02  4.809198003778602e-02  9.980184906785891e-01 
 	 4.040770806297097e-02  5.244424849846070e-02  9.978060021509840e-01 
 	 3.908750450784064e-02  8.912762491253670e-02  9.952529494901282e-01 
 	 3.760769666941069e-02  1.354734745800067e-01  9.900669668443857e-01 
 	 3.596043906495975e-02  1.953369505114139e-01  9.800766921966652e-01 
 	 3.432337923614553e-02  2.666044369839680e-01  9.631946738942617e-01 
 	 3.283485312777737e-02  3.465842151645976e-01  9.374440005775370e-01 
 	 3.158946565141540e-02  4.321148314653495e-01  9.012651541513911e-01 
 	 3.045996374097723e-02  5.415690585202193e-01  8.401042467827559e-01 
 	 2.993383254193446e-02  6.269155100997315e-01  7.785119837650187e-01 
 	 2.976836345682206e-02  6.874949500682085e-01  7.255787608301486e-01 
 	 3.064495551101758e-02  8.537709209891000e-01  5.197461891877146e-01 
 	 3.132353400159026e-02  8.904694473433563e-01  4.539636544544826e-01 
 	 3.393290657490729e-02  9.576587005577439e-01  2.858992324184028e-01 
 	 3.472335596710008e-02  9.681742835268679e-01  2.478565013624171e-01 
 	 3.596043906495951e-02  9.800766921966652e-01  1.953369505114139e-01 
 	 3.800091133393907e-02  9.917344806464011e-01  1.225506043836709e-01 
 	 3.874392262251009e-02  9.942975656085428e-01  9.935421221441269e-02 
 	 4.020573033755233e-02  9.975179081804000e-01  5.780590028208981e-02 
 	 2.835090883966237e-02  2.866869769624348e-02  9.991868352517294e-01 
 	 2.684334256822231e-02  8.829947887049466e-02  9.957322114860822e-01 
 	 2.544964067091695e-02  1.542627518910290e-01  9.877020396702277e-01 
 	 2.485669299347218e-02  1.864573828562458e-01  9.821485575979978e-01 
 	 2.397789168629386e-02  2.400854160380090e-01  9.704555908005974e-01 
 	 2.314920365223029e-02  2.990870721999013e-01  9.539449866806569e-01 
 	 2.196314194718705e-02  4.057688828186644e-01  9.137117894237223e-01 
 	 2.075222697462766e-02  5.830725722955752e-01  8.121549855244470e-01 
 	 2.059779342771846e-02  7.796227247425987e-01  6.259106469543677e-01 
 	 2.085230131617890e-02  8.273881979031049e-01  5.612432195585724e-01 
 	 2.124230816454167e-02  8.687796515542026e-01  4.947430458219713e-01 
 	 2.217689005513860e-02  9.231314712743809e-01  3.838443334091037e-01 
 	 2.264101059222074e-02  9.398744282227144e-01  3.407689008879604e-01 
 	 2.341765272185940e-02  9.600344991874482e-01  2.789002938523080e-01 
 	 2.515364770974862e-02  9.851267325094271e-01  1.699782777362848e-01 
 	 2.631173999312831e-02  9.933551352048527e-01  1.120413660247088e-01 
 	 2.708949172761204e-02  9.965987006426081e-01  7.782794687902854e-02 
 	 2.803726798760434e-02  9.987965310302369e-01  4.024178432619809e-02 
 	 1.725796736456247e-02  5.871735282705424e-02  9.981254605706774e-01 
 	 1.710847794849243e-02  6.841697890483557e-02  9.975101087105941e-01 
 	 1.642189180346505e-02  1.167683002235344e-01  9.930234063366793e-01 
 	 1.604591155460586e-02  1.463062362038899e-01  9.891092022472713e-01 
 	 1.528281683584909e-02  2.147844470485468e-01  9.765418971122599e-01 
 	 1.408484350160254e-02  3.576582709584101e-01  9.337463137269009e-01 
 	 1.344362371070172e-02  4.695299215006494e-01  8.828142057064550e-01 
 	 1.289554966702477e-02  6.462082621514490e-01  7.630521520354880e-01 
 	 1.285598864255593e-02  7.263032815414039e-01  6.872541500625592e-01 
 	 1.367444180291619e-02  9.053940366846622e-01  4.243520330777633e-01 
 	 1.491401883846344e-02  9.673296670192986e-01  2.530827677784858e-01 
 	 1.547196319636960e-02  9.803645702016364e-01  1.965856755926301e-01 
 	 1.604591155460569e-02  9.891092022472712e-01  1.463062362038899e-01 
 	 1.780295047586014e-02  9.995159936326298e-01  2.551143717885797e-02 
 	 9.749208846276950e-03  1.145618829747185e-02  9.998868479365874e-01 
 	 9.725610198716910e-03  1.391752904345792e-02  9.998558470557579e-01 
 	 9.595733309676495e-03  2.779635020142727e-02  9.995675489018884e-01 
 	 9.024913334830412e-03  9.645910154793340e-02  9.952960326796566e-01 
 	 8.503608833571688e-03  1.733174052640399e-01  9.848293078850497e-01 
 	 8.089918582467086e-03  2.482954709493567e-01  9.686505625473854e-01 
 	 7.717085200775584e-03  3.321703124399654e-01  9.431878551643568e-01 
 	 7.407464329912361e-03  4.215971432693628e-01  9.067529863525752e-01 
 	 7.173991741276110e-03  5.129613905837009e-01  8.583817015832361e-01 
 	 6.998949738944498e-03  6.243472389238697e-01  7.811155740034198e-01 
 	 6.979994195827268e-03  7.635518863333780e-01  6.457087552122599e-01 
 	 7.088050690720073e-03  8.296603007647844e-01  5.582235617315821e-01 
 	 7.224778350592850e-03  8.716137070071492e-01  4.901401313247468e-01 
 	 7.478104730539730e-03  9.169573908471249e-01  3.989150552692542e-01 
 	 7.896740774807088e-03  9.571995366518216e-01  2.893210820501568e-01 
 	 8.398012762133745e-03  9.815423176801368e-01  1.910605976771574e-01 
 	 8.715568940164287e-03  9.901004326933692e-01  1.400898712914403e-01 
 	 8.923947059822617e-03  9.938772933104136e-01  1.101285113439734e-01 
 	 9.122664990100301e-03  9.964488093470283e-01  8.370512131505470e-02 
 	 9.305219497986657e-03  9.980911803207276e-01  6.105250736923958e-02 
 	 9.465006148390534e-03  9.990573892695344e-01  4.236444977281084e-02 
 	 9.648433787036259e-03  9.997093035640291e-01  2.209561252785338e-02 
 	 9.762416334665262e-03  9.999014737788916e-01  1.008652378718252e-02 
 	 3.997384076694963e-03  5.714432719859752e-03  9.999756827939535e-01 
 	 3.933395235787875e-03  2.224137458308864e-02  9.997448922893148e-01 
 	 3.847016961128336e-03  4.590761395047016e-02  9.989382820984865e-01 
 	 3.775445344376867e-03  6.682324167698395e-02  9.977576862065413e-01 
 	 3.653891357866924e-03  1.054554447770036e-01  9.944173159417676e-01 
 	 3.567379818681349e-03  1.357166376442959e-01  9.907412720118992e-01 
 	 3.349815068338028e-03  2.250543347643978e-01  9.743404564846738e-01 
 	 3.190332059656629e-03  3.077153037295105e-01  9.514731281712607e-01 
 	 3.119296692552351e-03  3.516749568236303e-01  9.361169770553474e-01 
 	 2.894443091613411e-03  5.572810121684787e-01  8.303189120305915e-01 
 	 2.844342018156978e-03  6.664186295078183e-01  7.455723438831440e-01 
 	 2.840991429973218e-03  7.266341380240906e-01  6.870187466333664e-01 
 	 2.998984514022057e-03  8.966963571726727e-01  4.426360233026038e-01 
 	 3.349815068337797e-03  9.743404564846736e-01  2.250543347643980e-01 
 	 3.523450920269962e-03  9.883589966751497e-01  1.520989118465470e-01 
 	 3.736473087158132e-03  9.968866925244698e-01  7.875887909621508e-02 
 	 3.987541720152138e-03  9.999583945395807e-01  8.204188007007602e-03 
 	 7.619418841653523e-04  2.484604472067335e-03  9.999966230868894e-01 
 	 7.573416397639159e-04  8.603179394548664e-03  9.999627051735209e-01 
 	 7.496293252106206e-04  1.911746718887430e-02  9.998169635008985e-01 
 	 7.330175553128663e-04  4.293113299414364e-02  9.990777649938481e-01 
 	 7.263647364218260e-04  5.294908878784090e-02  9.985969489192359e-01 
 	 7.039680889435417e-04  8.894147137748400e-02  9.960366053002961e-01 
 	 6.876714573029007e-04  1.176146275936179e-01  9.930590750222171e-01 
 	 6.708783900312926e-04  1.497321114755546e-01  9.887263750478481e-01 
 	 6.540495991534119e-04  1.849948751564182e-01  9.827392677536515e-01 
 	 6.218250520741138e-04  2.635781848361319e-01  9.646378355694404e-01 
 	 5.811971354702525e-04  3.956145349670434e-01  9.184164643192649e-01 
 	 5.756209483674800e-04  4.185707313784349e-01  9.081840185192899e-01 
 	 5.536158857225681e-04  5.339557939972308e-01  8.455122137297828e-01 
 	 5.453380782534843e-04  6.016065113978551e-01  7.987924061044163e-01 
 	 5.419293256465335e-04  7.640649422893555e-01  6.451391092446418e-01 
 	 5.453380782534843e-04  7.987924061044164e-01  6.016065113978550e-01 
 	 5.504376905905278e-04  8.306801970482143e-01  5.567495911541279e-01 
 	 5.656192492254500e-04  8.854267856398825e-01  4.647785358063456e-01 
 	 5.811971354701329e-04  9.184164643192650e-01  3.956145349670432e-01 
 	 5.934418067050265e-04  9.366415875352883e-01  3.502887156706551e-01 
 	 6.000803517094286e-04  9.446656321449256e-01  3.280342716055742e-01 
 	 6.218250520739387e-04  9.646378355694404e-01  2.635781848361318e-01 
 	 6.457496933558652e-04  9.790326983572689e-01  2.037021319343962e-01 
 	 6.624418962643678e-04  9.859582837330052e-01  1.669904904747597e-01 
 	 6.793068980580083e-04  9.910807952917025e-01  1.332606308933923e-01 
 	 7.039680889432470e-04  9.960366053002961e-01  8.894147137748386e-02 
 	 7.117729805568554e-04  9.971091284088608e-01  7.597946711412416e-02 
 	 7.330175553126099e-04  9.990777649938480e-01  4.293113299414310e-02 
 	 7.391538797825204e-04  9.994235694901141e-01  3.394086621141145e-02 
 	 7.447108169913488e-04  9.996617329512636e-01  2.599740522966453e-02 
 	 7.538554700172649e-04  9.999110620295295e-01  1.331539458328733e-02 
 	 7.600476748879449e-04  9.999872586351841e-01  4.990480419875625e-03 
 	 ]; 
 
 end
 	  
 

 	 leb=[
 	 3.602899109421521e+00 
 	 6.251875439438439e+00 
 	 9.731077263750082e+00 
 	 1.304603522874180e+01 
 	 1.623387657293628e+01 
 	 1.968062065004341e+01 
 	 2.619959635526113e+01 
 	 2.590257037507481e+01 
 	 3.199143399638841e+01 
 	 3.435790039092822e+01 
 	 3.550615899471642e+01 
 	 3.983102905093376e+01 
 	 4.341108284671206e+01 
 	 4.901927973825804e+01 
 	 5.177632629358060e+01 
 	 ]; 
 

 	 AE_L2err=[
 	1.657e-01 7.910e-01 6.941e-02 2.330e-02 7.286e-01 6.799e-02 
 	5.849e-02 5.780e-01 7.603e-03 1.232e-03 3.988e-02 5.810e-03 
 	8.560e-03 1.154e-01 8.532e-04 5.878e-05 2.465e-03 4.503e-04 
 	8.641e-04 1.070e-01 6.998e-05 2.436e-06 3.548e-04 9.622e-05 
 	1.422e-04 1.167e-02 5.182e-06 8.339e-08 7.433e-05 2.956e-05 
 	1.554e-15 8.906e-03 3.373e-07 2.452e-09 2.199e-05 1.111e-05 
 	1.673e-15 7.456e-04 1.843e-08 6.601e-11 7.093e-06 4.963e-06 
 	1.759e-15 4.339e-04 9.393e-10 1.500e-12 2.346e-06 2.424e-06 
 	2.247e-15 2.888e-05 4.339e-11 3.145e-14 9.264e-07 1.280e-06 
 	2.034e-15 1.329e-05 1.774e-12 9.115e-16 3.916e-07 7.181e-07 
 	2.670e-15 7.443e-07 6.806e-14 6.897e-16 1.604e-07 4.276e-07 
 	2.554e-15 2.883e-07 2.470e-15 7.471e-16 7.049e-08 2.659e-07 
 	3.340e-15 1.446e-08 5.341e-16 8.821e-16 3.337e-08 1.734e-07 
 	2.848e-15 4.592e-09 5.469e-16 8.688e-16 1.547e-08 1.133e-07 
 	2.978e-15 2.093e-10 4.570e-16 9.530e-16 7.515e-09 7.750e-08 
 	 ]; 
 

 	 RE_L2err=[
 	5.481e-02 9.111e-01 1.118e-01 2.361e-02 2.517e-01 4.582e-01 
 	1.934e-02 6.657e-01 1.225e-02 1.249e-03 1.378e-02 3.915e-02 
 	2.831e-03 1.329e-01 1.374e-03 5.957e-05 8.515e-04 3.035e-03 
 	2.858e-04 1.232e-01 1.127e-04 2.468e-06 1.226e-04 6.484e-04 
 	4.701e-05 1.345e-02 8.346e-06 8.451e-08 2.568e-05 1.992e-04 
 	5.138e-16 1.026e-02 5.432e-07 2.485e-09 7.597e-06 7.490e-05 
 	5.531e-16 8.588e-04 2.969e-08 6.690e-11 2.451e-06 3.344e-05 
 	5.816e-16 4.997e-04 1.513e-09 1.520e-12 8.105e-07 1.633e-05 
 	7.433e-16 3.326e-05 6.988e-11 3.188e-14 3.201e-07 8.623e-06 
 	6.726e-16 1.530e-05 2.856e-12 9.238e-16 1.353e-07 4.839e-06 
 	8.831e-16 8.573e-07 1.096e-13 6.990e-16 5.542e-08 2.881e-06 
 	8.446e-16 3.320e-07 3.979e-15 7.572e-16 2.435e-08 1.792e-06 
 	1.104e-15 1.665e-08 8.602e-16 8.939e-16 1.153e-08 1.168e-06 
 	9.417e-16 5.289e-09 8.808e-16 8.805e-16 5.344e-09 7.633e-07 
 	9.848e-16 2.410e-10 7.360e-16 9.659e-16 2.596e-09 5.222e-07 
 	 ]; 
 

 	 AE_inf=[
 	2.871e-01 1.662e+00 1.327e-01 1.237e-01 1.546e+00 4.320e-01 
 	1.842e-01 3.803e+00 2.796e-02 1.114e-02 1.357e-01 5.119e-02 
 	5.068e-02 1.823e+00 2.992e-03 7.542e-04 7.903e-03 4.777e-03 
 	4.201e-03 1.479e+00 2.964e-04 3.806e-05 1.553e-03 1.193e-03 
 	7.077e-04 3.735e-01 2.175e-05 1.858e-06 3.943e-04 4.397e-04 
 	1.266e-14 1.688e-01 1.647e-06 5.183e-08 1.048e-04 1.442e-04 
 	1.066e-14 3.763e-02 1.058e-07 2.252e-09 4.229e-05 9.461e-05 
 	1.998e-14 1.172e-02 5.831e-09 4.403e-11 1.763e-05 3.974e-05 
 	1.177e-14 1.575e-03 2.763e-10 1.239e-12 7.148e-06 2.598e-05 
 	1.510e-14 5.261e-04 1.393e-11 2.609e-14 3.157e-06 1.446e-05 
 	1.599e-14 4.354e-05 5.796e-13 4.163e-15 1.645e-06 8.021e-06 
 	2.220e-14 1.316e-05 1.979e-14 5.773e-15 7.201e-07 6.100e-06 
 	2.531e-14 9.775e-07 2.942e-15 8.493e-15 2.847e-07 3.969e-06 
 	2.176e-14 2.415e-07 4.385e-15 7.161e-15 1.648e-07 2.507e-06 
 	2.309e-14 1.651e-08 3.636e-15 9.492e-15 9.497e-08 1.999e-06 
 	 ]; 
 

 	 RE_inf=[
 	9.120e-02 1.662e+00 1.327e-01 1.237e-01 2.736e-01 6.609e-01 
 	5.851e-02 3.803e+00 2.796e-02 1.114e-02 2.402e-02 7.832e-02 
 	1.610e-02 1.823e+00 2.992e-03 7.542e-04 1.399e-03 7.308e-03 
 	1.335e-03 1.479e+00 2.964e-04 3.806e-05 2.749e-04 1.825e-03 
 	2.248e-04 3.735e-01 2.175e-05 1.858e-06 6.978e-05 6.727e-04 
 	4.021e-15 1.688e-01 1.647e-06 5.183e-08 1.854e-05 2.206e-04 
 	3.386e-15 3.763e-02 1.058e-07 2.252e-09 7.483e-06 1.448e-04 
 	6.349e-15 1.172e-02 5.831e-09 4.403e-11 3.120e-06 6.079e-05 
 	3.739e-15 1.575e-03 2.763e-10 1.239e-12 1.265e-06 3.975e-05 
 	4.797e-15 5.261e-04 1.393e-11 2.609e-14 5.586e-07 2.212e-05 
 	5.079e-15 4.354e-05 5.796e-13 4.163e-15 2.911e-07 1.227e-05 
 	7.054e-15 1.316e-05 1.979e-14 5.773e-15 1.274e-07 9.332e-06 
 	8.042e-15 9.775e-07 2.942e-15 8.493e-15 5.038e-08 6.073e-06 
 	6.913e-15 2.415e-07 4.385e-15 7.161e-15 2.917e-08 3.835e-06 
 	7.336e-15 1.651e-08 3.636e-15 9.492e-15 1.681e-08 3.059e-06 
 	 ]; 
 
