

function [rat,Mdub]=sector_filldistance(deg,w,w_star,s_star,set_type)



% .......................... troubleshooting ..............................
if nargin < 4, s_star=[]; end
if nargin < 5, set_type=1; end
if size(s_star,1) == 0
    s_star=1-2*(sin(w))^2-2*sin(w)*cos(w)*tan(w_star-w); 
end

% .................. sector distance from origin A, B .....................
L_up=1; L_low=s_star;

% ....................... extrema segment .......................
P_up=L_up*[cos(w) sin(w)]; P_low=L_low*[cos(w) -sin(w)];

% ....................... segment pointset .......................
switch set_type
    case 1
         t=gauss_lobatto_01(deg); % column vector
    otherwise
        t=gauss_chebyshev_01(deg);
        t=[0; t; 1]; 
        % extrema are added for fill distance analysis, but not counted
        % as gauss_chebyshev points
end

P=[t*P_low(1)+(1-t)*P_up(1) t*P_low(2)+(1-t)*P_up(2)];
theta=atan(P(:,2)./P(:,1));

% % ....................... radial pointset .......................
% norms_P=sqrt(P(:,1).^2+P(:,2).^2);
% Psph(:,1)=P(:,1)./norms_P;  Psph(:,2)=P(:,2)./norms_P;
% theta0=angle(Psph(:,1)+i* Psph(:,2));

 
% ....................... dubiner fill.dist segment ...............
dub=dubiner_filldistance(theta,w);
mdub=min(dub); [Mdub,imax]=max(dub);
rat=Mdub/(pi/deg);




function [t,c]=gauss_lobatto_01(deg)

j=(0:1:deg);
c=cos(j*pi/deg);
t=(c'+1)/2;


function [t,c]=gauss_chebyshev_01(deg)

n=deg+1;
k=(1:n);
c=cos((2*k-1)*pi/(2*n));
t=(c'+1)/2;





function dub=dubiner_filldistance(x,w)

F=@(t,w) 2*asin(sin(t/2)/sin(w/2));

x=sort(x);
L=length(x);

for k=1:L-1
    xm=x(k); xM=x(k+1);
    dub(k)=abs(F(xm,w)-F(xM,w))/2;
end


