function wam = wamquadrangle(deg,Q)

%--------------------------------------------------------------------------
% Object:
% The routine produces a polynomial Weakly Admissible Mesh for degree "deg" 
% in a convex quadrangle, namely
%    ||p||_quadrangle leq C(deg)*||p||_WAM with C(deg)=O(log^2(deg))
%
% Note: a grid for triangles can be obtained by collapsing some vertices of
% Q.
%
% Note: a AM at degree "m" can be obtained by a suitable degree "deg >= m".
%--------------------------------------------------------------------------
% Input:
% deg: polynomial degree
% Q  : 2-columns array of the convex quadrangle vertices
%--------------------------------------------------------------------------
% Output:
% wam = 2-columns array of mesh points coordinates
%--------------------------------------------------------------------------
% Data:
% First version: 01/09/2015 by A. Sommariva and M. Vianello.
%--------------------------------------------------------------------------

% FUNCTION BODY

% Chebyshev-Lobatto grid
j=(0:1:deg);
c=cos(j*pi/deg);

A=Q(1,:); B=Q(2,:); C=Q(3,:); D=Q(4,:);

[u,v]=meshgrid(c);

pts=0.25*((1-u(:)).*(1-v(:))*A+(1+u(:)).*(1-v(:))*B);
pts=pts+0.25*((1+u(:)).*(1+v(:))*C+(1-u(:)).*(1+v(:))*D);

% eliminating possible multiple nodes in degenerate cases 
% (triangle, segment)
dig=12;
wam=singlepts(pts,dig);




function [spts,ind] = singlepts(pts,dig)

% eliminates from an array of points pts those having dig digits 
% in common with a subset of other points, keeping only one per subset  

atol=100*eps;
m=10.^(floor(log10(abs(pts))-dig+1));
pts1=round(pts./m).*m;
pts1(find(abs(pts)<atol)) = 0;
[spts,ind]=unique(pts1,'rows');





