
clear;

% Zernike polynomials
rho=@(u,v) sqrt(u.^2+v.^2);
theta=@(u,v) angle(u+sqrt(-1)*v);
Z0=@(u,v) ones(length(u),1); 
Z1=@(u,v) rho(u,v).*cos(theta(u,v));
Z2=@(u,v) rho(u,v).*sin(theta(u,v));
Z3=@(u,v) -1*Z0(u,v)+2*rho(u,v).^2;
Z4=@(u,v) (rho(u,v).^2).*cos(2*theta(u,v));
Z5=@(u,v) (rho(u,v).^2).*sin(2*theta(u,v));
Z6=@(u,v) rho(u,v).*(-2*Z0(u,v)+3*rho(u,v).^2).*cos(theta(u,v));
Z7=@(u,v) rho(u,v).*(-2*Z0(u,v)+3*rho(u,v).^2).*sin(theta(u,v));
Z8=@(u,v) 1*Z0(u,v)-6*rho(u,v).^2+6*rho(u,v).^4;

% approx number of grid or Halton points in the circumscribed square
M=50000;

% polynomial exactness degree 
n=4;

% setting the circles parameters 
% c: circles [xcenter ycenter radius]
% intsct: 1-row array of sequential intersection modes 
% 1=intersection, 0=setdifference
% intsct(1)=1

% there are five circles with collinear centers on the y-axis  
% the circles are: 1 the main pupil, 2 & 3 the internal holes,
% 4 & 5 the upper circles

% WARNING: compatibility checks are still missing
% circles 2 & 3 are inside circle 1 
% circles 4 & 5 intersect circle 1    
% circles 4 & 5 do not intersect circles 2 & 3 
% check the plot!!!

% 5-circles model: upper lunette diff(disk4,disk5) active
% x=[0 0 0 0 0];y=[0 0 -0.5 -0.7 -1.8];r=[1 0.5 0.4 1.45 2.5];
% intsct=[1 0 0 1 1];
% y1=y;r1=r;
 
% 5-circles model: upper lunette not active 
% x=[0 0 0 0 0];y=[0 0 -0.5 -0.7 -1.8];r=[1 0.5 0.4 1.6 2.5];
% intsct=[1 0 0 1 1];
% y1=y;r1=r;

% 4-circles model: disk5 absent
 x=[0 0 0 0];y=[0 0 -0.5 -0.7];r=[1 0.5 0.4 1.6]; 
 intsct=[1 0 0 1];
 y1=[y 1];r1=[r 0]; 

% 3-circles model: disk3 and disk5 absent 
% x=[0 0 0];y=[0 0 -0.7];r=[1 0.5 1.6]; 
% intsct=[1 0 1]; 
% y1=[y(1) y(2) 1 y(3) 1];r1=[r(1) r(2) 0 r(3) 0]; 

c=[x' y' r']; 

% compressed formula
% halt=0 grid points, halt=1 Halton points
% pos=0 possible negative weights, pos=1 positive weights (slower)
halt=1; pos=0;
[X,xyw,momerr]=cmeanvap(c,intsct,M,2*n,halt,pos);

format short e

disp('number of grid or Halton points') 
N=length(X(:,1))

disp('number of compressed quadrature points') 
NC=length(xyw(:,1))

disp('moment compression error') 
momerror=momerr

disp('compression ratio N/NC') 
Cratio=N/NC

disp('sum(|weights|))/sum(weights): compressed formula') 
Cstabparm=sum(abs(xyw(:,3)))/sum(xyw(:,3))

% numerical tests

N=length(X(:,1));
weights=(1/N)*ones(N,1);

% GQ-like formula 
[xyw1,Cxyw,momerr]=vap(2*n,y1,r1);
area=sum(xyw1(:,3));

% test on random wavefronts 

ntrials=10;
for i=1:ntrials 

% wavefront 
a=rand(1,9); 
W=@(u,v) a(1)*Z0(u,v)+a(2)*Z1(u,v)+a(3)*Z2(u,v) ...
+a(4)*Z3(u,v)+a(5)*Z4(u,v)+a(6)*Z5(u,v)+a(7)*Z6(u,v) ...
+a(8)*Z7(u,v)+a(9)*Z8(u,v);

% RMSWE grid formula
mean=weights'*W(X(:,1),X(:,2));
mean2=weights'*W(X(:,1),X(:,2)).^2;
sigma(i)=sqrt(mean2-mean^2);

% RMSWE compressed formula 
cmean=(xyw(:,3))'*W(xyw(:,1),xyw(:,2));
cmean2=(xyw(:,3))'*W(xyw(:,1),xyw(:,2)).^2;
csigma(i)=sqrt(cmean2-cmean^2);

% RMSWE exact formula by GQ (lune subtraction) 
imean=(Cxyw(:,3))'*W(Cxyw(:,1),Cxyw(:,2))/area;
imean2=(Cxyw(:,3))'*W(Cxyw(:,1),Cxyw(:,2)).^2/area;
isigma(i)=sqrt(imean2-imean^2);

% relative errors
diff(i)=abs(sigma-csigma)/sigma;
err(i)=abs(isigma-sigma)/isigma;
Cerr(i)=abs(isigma-csigma)/isigma;

end;

disp('average relative error of grid/Halton RMSWE')
sum(err)/length(err)

disp('average relative diff of grid/Halton and compressed RMSWE')
sum(diff)/length(diff)

disp('average relative error of compressed RMSWE')
sum(Cerr)/length(Cerr)

% plots
% plot(X(:,1),X(:,2),'.','MarkerSize',3);
% hold on;
% points of compressed formula and circles  
plot(xyw(:,1),xyw(:,2),'o');  
hold on;
t=linspace(0,2*pi,1000);
for i=1:length(x)
plot(x(i)*ones(1,length(t))+r(i)*cos(t),y(i)*ones(1,length(t))+r(i)*sin(t),'-');
end;
s=1.3;
axis([s*(x(1)-r(1)) s*(x(1)+r(1)) s*(y(1)-r(1)) s*(y(1)+r(1))]);
axis square;
hold off;





