
function demo_zernike

r=rand(5,1);
theta=2*pi*rand(5,1);
pts=r.*[cos(theta) sin(theta)];

V=vandermonde_zernike(pts,4);
W=zernike_marco(pts(:,1),pts(:,2));
V0=demozernike(pts(:,1),pts(:,2));
format short e
V
V0
W


function W=zernike_marco(u,v)


% #   nw   mw  | #    n    m    Zernike function           Normalization
% ------------------------------------------------------
% 0    0   0   | 0      0    0    1                                 1
% 1    1   1   | 1      1    1    r * cos(theta)                    2
% 2    1   1   | 2      1   -1    r * sin(theta)                    2
% 3    1   0   | 4      2   -2    r^2 * cos(2*theta)             sqrt(6)
% 4    2   2   | 3      2    0    (2*r^2 - 1)                    sqrt(3)
% 5    2   2   | 5      2    2    r^2 * sin(2*theta)             sqrt(6)
% 6    2   1   | 9      3   -3    r^3 * cos(3*theta)             sqrt(8)
% 7    2   1   | 6      3   -1    (3*r^3 - 2*r) * cos(theta)     sqrt(8)
% 8    2   0   | 7      3    1    (3*r^3 - 2*r) * sin(theta)     sqrt(8)
% 9    3   3   | 10     3    3    r^3 * sin(3*theta)             sqrt(8)
% 10   3   3   | 16     4   -4    r^4 * cos(4*theta)             sqrt(10)
% 11   3   2   | 11     4   -2    (4*r^4 - 3*r^2) * sin(2*theta) sqrt(10)
% 12   3   2   | 8      4    0    6*r^4 - 6*r^2 + 1              sqrt(5)
% 13   3   1   |        4    2    (4*r^4 - 3*r^2) * cos(2*theta) sqrt(10)
% 14   3   1   | 17     4    4    r^4 * sin(4*theta)             sqrt(10)
% --------------------------------------------------

rho=@(u,v) sqrt(u.^2+v.^2);
theta=@(u,v) angle(u+sqrt(-1)*v);
Z0=@(u,v) ones(length(u),1); % 0 0
Z1=@(u,v) rho(u,v).*cos(theta(u,v)); % 1 1
Z2=@(u,v) rho(u,v).*sin(theta(u,v)); % 1 -1
Z3=@(u,v) -1*Z0(u,v)+2*rho(u,v).^2; % 2 0
Z4=@(u,v) (rho(u,v).^2).*cos(2*theta(u,v)); % 2 -2
Z5=@(u,v) (rho(u,v).^2).*sin(2*theta(u,v)); % 2 2
Z6=@(u,v) rho(u,v).*(-2*Z0(u,v)+3*rho(u,v).^2).*cos(theta(u,v)); % 3 -1
Z7=@(u,v) rho(u,v).*(-2*Z0(u,v)+3*rho(u,v).^2).*sin(theta(u,v)); % 3 1 
Z8=@(u,v) 1*Z0(u,v)-6*rho(u,v).^2+6*rho(u,v).^4; % 4 0

W=[Z0(u,v) Z1(u,v) Z2(u,v) Z3(u,v) Z4(u,v) Z5(u,v) Z6(u,v) Z7(u,v) Z8(u,v)];



function W=demozernike(u,v)

X= sqrt(u.^2+v.^2);
Y=angle(u+sqrt(-1)*v);

Z0=@(r,theta) ones(length(r),1);                              
Z1=@(r,theta)  r .* cos(theta);                    
Z2=@(r,theta) r .* sin(theta);                    
Z3=@(r,theta) r.^2 .* cos(2*theta);             
Z4=@(r,theta) (2*r.^2 - 1);                    
Z5=@(r,theta) r.^2 .* sin(2*theta);             
Z6=@(r,theta) r.^3 .* cos(3*theta);             
Z7=@(r,theta) (3*r.^3 - 2*r) .* cos(theta);     
Z8=@(r,theta) (3*r.^3 - 2*r) .* sin(theta);     
Z9=@(r,theta) r.^3 .* sin(3*theta);             
Z10=@(r,theta) r.^4 .* cos(4*theta);             
Z11=@(r,theta) (4*r.^4 - 3*r.^2) .* cos(2*theta); 
Z12=@(r,theta) 6*r.^4 - 6*r.^2 + 1              
Z13=@(r,theta) (4*r.^4 - 3*r.^2) .* sin(2*theta); 
Z14=@(r,theta) r.^4 .* sin(4*theta);             

W=[Z0(X,Y) Z1(X,Y) Z2(X,Y) Z3(X,Y) Z4(X,Y) Z5(X,Y) Z6(X,Y) Z7(X,Y) Z8(X,Y)];


