
function V=zernike_wyant(R,TH,NV)

% ZERNIKE POLYNOMIALS 
% see: James C. Wyant, 2003, ZernikePolynomialsForTheWeb,
% available at: 
% http://www.mpia.de/AO/INSTRUMENTS/FPRAKT/ZernikePolynomialsForTheWeb.pdf
%
% INPUT: 
% R: column vector of radii
% TH: column vector of angles
% NV: vector of indices of Zernike polynomials; the index ranges from 0 to
%     47.
%
% OUTPUT:
% V: Vandermonde matrix, whose columns are evaluation of the choosen
% Zernike polynomials at points of polar coordinates (R,TH)

V=[];
for kk=1:length(NV)
    VL=sub_zernike_wyant(R,TH,NV(kk));
    V=[V VL];
end


% ZERNIKE POLYNOMIALS.

function res=sub_zernike_wyant(R,TH,N)
switch N
    case 0
        Z0=@(r,th) ones(size(r));
        res=feval(Z0,R,TH);
    case 1
        Z1=@(r,th) r.*cos(th);
        res=feval(Z1,R,TH);
    case 2
        Z2=@(r,th) r.*sin(th);
        res=feval(Z2,R,TH);
    case 3
        Z3=@(r,th) -1+2*(r.^2);
        res=feval(Z3,R,TH);
    case 4
        Z4=@(r,th) (r.^2).*cos(2*th);
        res=feval(Z4,R,TH);
    case 5
        Z5=@(r,th) (r.^2).*sin(2*th);
        res=feval(Z5,R,TH);
    case 6
        Z6=@(r,th) r.*(-2+3*r.^2).*cos(th);
        res=feval(Z6,R,TH);
    case 7
        Z7=@(r,th) r.*(-2+3*r.^2).*sin(th);
        res=feval(Z7,R,TH);
    case 8
        Z8=@(r,th) 1-6*(r.^2)+6*(r.^4);
        res=feval(Z8,R,TH);
    case 9
        Z9=@(r,th) (r.^3).*cos(3*th);
        res=feval(Z9,R,TH);
    case 10
        Z10=@(r,th) (r.^3).*sin(3*th);
        res=feval(Z10,R,TH);
    case 11
        Z11=@(r,th) (r.^2).*(-3+4*r.^2).*cos(2*th);
        res=feval(Z11,R,TH);
    case 12
        Z12=@(r,th) (r.^2).*(-3+4*r.^2).*sin(2*th);
        res=feval(Z12,R,TH);
    case 13
        Z13=@(r,th) r.*(3-12*r.^2+10*r.^4).*cos(th);
        res=feval(Z13,R,TH);
    case 14
        Z14=@(r,th) r.*(3-12*r.^2+10*r.^4).*sin(th);
        res=feval(Z14,R,TH);
    case 15
        Z15=@(r,th)  -1+12*r.^2-30*r.^4+20*r.^6;
        res=feval(Z15,R,TH);
    case 16
        Z16=@(r,th) (r.^4).*cos(4*th);
        res=feval(Z16,R,TH);
    case 17
        Z17=@(r,th) (r.^4).*sin(4*th);
        res=feval(Z17,R,TH);
    case 18
        Z18=@(r,th) (r.^3).*(-4+5*r.^2).*cos(3*th);
        res=feval(Z18,R,TH);
    case 19
        Z19=@(r,th) (r.^3).*(-4+5*r.^2).*sin(3*th);
        res=feval(Z19,R,TH);
    case 20
        Z20=@(r,th) (r.^2).*(6-20*r.^2+15*r.^4).*cos(2*th);
        res=feval(Z20,R,TH);
    case 21
        Z21=@(r,th) (r.^2).*(6-20*r.^2+15*r.^4).*sin(2*th);
        res=feval(Z21,R,TH);
    case 22
        Z22=@(r,th) r.*(-4+30*r.^2-60*r.^4+35*r.^6).*cos(th);
        res=feval(Z22,R,TH);
    case 23
        Z23=@(r,th) r.*(-4+30*r.^2-60*r.^4+35*r.^6).*sin(th);
        res=feval(Z23,R,TH);
    case 24
        Z24=@(r,th) 1-20*(r.^2)+90*(r.^4)-140*r.^6+70*r.^8;
        res=feval(Z24,R,TH);
    case 25
        Z25=@(r,th) (r.^5).*cos(5*th);
        res=feval(Z25,R,TH);
    case 26
        Z26=@(r,th) (r.^5).*sin(5*th);
        res=feval(Z26,R,TH);
    case 27
        Z27=@(r,th) (r.^4).*(-5+6*r.^6).*cos(4*th);
        res=feval(Z27,R,TH);
    case 28
        Z28=@(r,th) (r.^4).*(-5+6*r.^6).*sin(4*th);
        res=feval(Z28,R,TH);
    case 29
        Z29=@(r,th) (r.^3).*(10-30*r.^2+21*r.^4).*cos(3*th);
        res=feval(Z29,R,TH);
    case 30
        Z30=@(r,th) (r.^3).*(10-30*r.^2+21*r.^4).*sin(3*th);
        res=feval(Z30,R,TH);
    case 31
        Z31=@(r,th) (r.^2).*(-10+60*r.^2-105*r.^4+56*r.^6).*cos(2*th);
        res=feval(Z31,R,TH);
    case 32
        Z32=@(r,th) (r.^2).*(-10+60*r.^2-105*r.^4+56*r.^6).*sin(2*th);
        res=feval(Z32,R,TH);
    case 33
        Z33=@(r,th) r.*(5-60*r.^2+210*r.^4-280*r.^6+126*r.^8).*cos(th);
        res=feval(Z33,R,TH);
    case 34
        Z34=@(r,th) r.*(5-60*r.^2+210*r.^4-280*r.^6+126*r.^8).*sin(th);
        res=feval(Z34,R,TH);
    case 35
        Z35=@(r,th) (r.^6).*cos(6*th);
        res=feval(Z35,R,TH);
    case 36
        Z36=@(r,th) (r.^6).*sin(6*th);
        res=feval(Z36,R,TH);
    case 37
        Z37=@(r,th) (r.^5).*(-6+7*r.^2).*cos(5*th);
        res=feval(Z37,R,TH);
    case 38
        Z38=@(r,th) (r.^5).*(-6+7*r.^2).*sin(5*th);
        res=feval(Z38,R,TH);
    case 39
        Z39=@(r,th) (r.^4).*(15-42*r.^2+28*r.^4).*cos(4*th);
        res=feval(Z39,R,TH);
    case 40
        Z40=@(r,th) (r.^4).*(15-42*r.^2+28*r.^4).*sin(4*th);
        res=feval(Z40,R,TH);
    case 41
        Z41=@(r,th) (r.^3).*(-20+105*r.^2-168*r.^4+84*r.^6).*cos(3*th);
        res=feval(Z41,R,TH);
    case 42
        Z42=@(r,th) (r.^3).*(-20+105*r.^2-168*r.^4+84*r.^6).*sin(3*th);
        res=feval(Z42,R,TH);
    case 43
        Z43=@(r,th) (r.^2).*(15-140*r.^2+420*r.^4-504*r.^6+210*r.^8).*cos(2*th);
        res=feval(Z43,R,TH);
    case 44
        Z44=@(r,th) (r.^2).*(15-140*r.^2+420*r.^4-504*r.^6+210*r.^8).*sin(2*th);
        res=feval(Z44,R,TH);
    case 45
        Z45=@(r,th) r.*(-6+105*r.^2-560*r.^4+1260*r.^6-1260*r.^8+462*r.^10).*cos(th);
        res=feval(Z45,R,TH);
    case 46
        Z46=@(r,th) r.*(-6+105*r.^2-560*r.^4+1260*r.^6-1260*r.^8+462*r.^10).*sin(th);
        res=feval(Z46,R,TH);
    case 47
        Z47=@(r,th)  1-42*r.^2+420*r.^4-1680*r.^6+3150*r.^8-2772*r.^10+924*r.^12;
        res=feval(Z47,R,TH);
end


