
function ADE_estimates(example)

example=2;

switch example
    case 1
        polygon_sides=[0.1 0; 0.7 0.2; 1 0.5; 0.75 0.85; 0.5 1; 0 0.25; 0.1 0];
        xv=polygon_sides(:,1); yv=polygon_sides(:,2);
        iv=length(xv); % This variable depends on the holes or not connected domain.
        % In these simple cases the domains are without holes and
        % domains are connected.
        
    case 2
        polygon_sides=(1/4)*[1 2; 1 0; 3 2; 3 0; 4 2; 3 3; 3 0.85*4; 2 4;
            0 3; 1 2];
        xv=polygon_sides(:,1); yv=polygon_sides(:,2);
        iv=length(xv); % This variable depends on the holes or not connected domain.
        % In these simple cases the domains are without holes and
        % domains are connected.
    case 3
        % fprintf('\n \t [POLYGON]: QUATERFOIL LIKE');
        warning off;
        M=129;
        th=linspace(0,2*pi,M);
        %th=(th(1:end-1))';
        polygon_sides=[cos(th').*(sin(2*th')) sin(th').*(sin(2*th'))];
        polygon_sides=polygon_sides(1:end-1,:);
        xv=polygon_sides(:,1); yv=polygon_sides(:,2);
        iv=length(xv); % This variable depends on the holes or not connected domain.
        % In these simple cases the domains are without holes and
        % domains are connected.
        
    case 4 % domain not simply connected (optics)
        Nsides=100;
        y=[0         0   -0.1184   -0.1184   -0.3761];
        r=[1.0000    0.6120    0.5663    1.0761    1.2810];
        th=linspace(0,2*pi,Nsides); th=(th(1:end-1))';
        C1=[0 y(1)]; P1v=C1+r(1)*[cos(th) sin(th)]; P1=polyshape(P1v);
        C2=[0 y(2)]; P2v=C2+r(2)*[cos(th) sin(th)]; P2=polyshape(P2v);
        C3=[0 y(3)]; P3v=C3+r(3)*[cos(th) sin(th)]; P3=polyshape(P3v);
        C4=[0 y(4)]; P4v=C4+r(4)*[cos(th) sin(th)]; P4=polyshape(P4v);
        C5=[0 y(5)]; P5v=C5+r(5)*[cos(th) sin(th)]; P5=polyshape(P5v);
        Pout=intersect(P1,P4);
        Pout=intersect(Pout,P5);
        Pin=union(P2,P3);
        xv=subtract(Pout,Pin);
        yv=[]; iv=[];
        
        
end

%--------------------------
% REFERENCE RULE
%--------------------------
[xyw,xvc,yvc,P,tri]=polygauss_2018(100,xv,yv,iv);
XR=xyw(:,1); YR=xyw(:,2); WR=xyw(:,3);

% x0=0.5; y0=0.5;
% f=@(x,y) exp(-((x-x0).^2+(y-y0).^2));
% f=@(x,y) x+y;
% f=@(x,y) x+y;
f=@(x,y) 1./(x.^2+y.^2);

fxyR=feval(f,XR,YR);
a=min(fxyR);
b=max(fxyR);

% g=@(x) exp(x);
% g=@(x) sqrt(x);
% g=@(x) cos(x);
g=@(x) 1./x;

F=chebfun(g,[a,b]);
degs=1:30;

fprintf('\n \t *** UPPER BOUND ABSOLUTE ERROR (CUBATURE) *** \n');

for ii=1:length(degs)
    deg=degs(ii);
    [p,errrem]=minimax(F,deg);
    ER(ii)=2*sum(WR)*errrem; % upper bound quadrature error estimate
    fprintf('\n \t DEG: %3.0f U.B.CUB.EST.: %1.1e',ii,ER(ii));
end

fprintf('\n');