
function bin(example)

example=2;

switch example
    case 1
        polygon_sides=[0.1 0; 0.7 0.2; 1 0.5; 0.75 0.85; 0.5 1; 0 0.25; 0.1 0];
    case 2
        polygon_sides=(1/4)*[1 2; 1 0; 3 2; 3 0; 4 2; 3 3; 3 0.85*4; 2 4;
            0 3; 1 2];
end

xv=polygon_sides(:,1); yv=polygon_sides(:,2);
iv=length(xv); % This variable depends on the holes or not connected domain.
% In these simple cases the domains are without holes and
% domains are connected.

%--------------------------
% REFERENCE RULE
%--------------------------
[xyw,xvc,yvc,P,tri]=polygauss_2018(100,xv,yv,iv);
XR=xyw(:,1); YR=xyw(:,2); WR=xyw(:,3);

%x0=0.5; y0=0.5;
%f=@(x,y) exp(-((x-x0).^2+(y-y0).^2));
f=@(x,y) x+y;
fxyR=feval(f,XR,YR);
minf=min(fxyR);
maxf=max(fxyR);

C=30;
a=min(C*minf,C*maxf);
b=max(C*minf,C*maxf);
%g=@(x) exp(x);
%g=@(x) sqrt(x);
g=@(x) cos(x);
f=chebfun(g,[a,b]);
degs=1:30;
for ii=degs
    [p,errrem]=minimax(f,ii);
    ER(ii)=errrem;
end

format short g;
[degs' ER']