
function demo_polygauss_III(example,test_functionV)

if nargin < 1 example=1; end
if nargin < 2 test_functionV=1:9; end

adeV=5:5:30;
pos=0;

%--------------------------
% defining domain
%--------------------------

switch example
    case 1
        polygon_sides=[0.1 0; 0.7 0.2; 1 0.5; 0.75 0.85; 0.5 1; 0 0.25; 0.1 0];
        xv=polygon_sides(:,1); yv=polygon_sides(:,2);
        iv=length(xv); % This variable depends on the holes or not connected domain.
        % In these simple cases the domains are without holes and
        % domains are connected.
        
    case 2
        polygon_sides=(1/4)*[1 2; 1 0; 3 2; 3 0; 4 2; 3 3; 3 0.85*4; 2 4;
            0 3; 1 2];
        xv=polygon_sides(:,1); yv=polygon_sides(:,2);
        iv=length(xv); % This variable depends on the holes or not connected domain.
        % In these simple cases the domains are without holes and
        % domains are connected.
    case 3
        % fprintf('\n \t [POLYGON]: QUATERFOIL LIKE');
        warning off;
        M=129;
        th=linspace(0,2*pi,M);
        %th=(th(1:end-1))';
        polygon_sides=[cos(th').*(sin(2*th')) sin(th').*(sin(2*th'))];
        polygon_sides=polygon_sides(1:end-1,:);
        xv=polygon_sides(:,1); yv=polygon_sides(:,2);
        iv=length(xv); % This variable depends on the holes or not connected domain.
        % In these simple cases the domains are without holes and
        % domains are connected.
        
    case 4 % domain not simply connected (optics)
        Nsides=100;
        y=[0         0   -0.1184   -0.1184   -0.3761];
        r=[1.0000    0.6120    0.5663    1.0761    1.2810];
        th=linspace(0,2*pi,Nsides); th=(th(1:end-1))';
        C1=[0 y(1)]; P1v=C1+r(1)*[cos(th) sin(th)]; P1=polyshape(P1v);
        C2=[0 y(2)]; P2v=C2+r(2)*[cos(th) sin(th)]; P2=polyshape(P2v);
        C3=[0 y(3)]; P3v=C3+r(3)*[cos(th) sin(th)]; P3=polyshape(P3v);
        C4=[0 y(4)]; P4v=C4+r(4)*[cos(th) sin(th)]; P4=polyshape(P4v);
        C5=[0 y(5)]; P5v=C5+r(5)*[cos(th) sin(th)]; P5=polyshape(P5v);
        Pout=intersect(P1,P4);
        Pout=intersect(Pout,P5);
        Pin=union(P2,P3);
        xv=subtract(Pout,Pin);
        yv=[]; iv=[];
        
        
end



%--------------------------
% REFERENCE RULE
%--------------------------
[xyw,xvc,yvc,P,tri]=polygauss_2018(50,xv,yv,iv);
XR=xyw(:,1); YR=xyw(:,2); WR=xyw(:,3);

for ii=1:length(adeV)
    
    ade=adeV(ii);
    
    %--------------------------
    % FULL RULE
    %--------------------------
    tic
    [xyw,xvc,yvc,P,tri]=polygauss_2018(ade,xv,yv,iv);
    toc
    X=xyw(:,1); Y=xyw(:,2); W=xyw(:,3);
    cardF(ii)=length(W);
    
    %------------------------------
    % COMPRESSED RULE
    %------------------------------
    [pts,w,momerr] = comprexcub(ade,xyw(:,1:2),xyw(:,3),pos);
    
    % compressed rule result.
    Xc=pts(:,1); Yc=pts(:,2); Wc=w;
    cardC(ii)=length(Wc);
    
    for jj=1:length(test_functionV)
        
        
        test_function=test_functionV(jj);
        f=define_function(test_function,ade);
        
        % ----------------------- REFERENCE VALUE -----------------------
        fXYR=feval(f,XR,YR);
        IREF(jj,ii)=WR'*fXYR;
        
        % ----------------------- FULL RULE VALUE -----------------------
        fXY=feval(f,X,Y);
        IF(jj,ii)=W'*fXY;
        
        % relative/absolute errors
        
        if abs(IREF(jj)) > 0
            EF(jj,ii)=abs(IF(jj,ii)-IREF(jj,ii))/abs(IREF(jj,ii));
            AF(jj,ii)=abs(IF(jj,ii)-IREF(jj,ii));
        else
            EF(jj,ii)=abs(IF(jj,ii)-IREF(jj,ii));
            AF(jj,ii)=EF(jj,ii);
        end
        
        
        
        % ----------------------- COMP RULE VALUE -----------------------
        fXYc=feval(f,Xc,Yc);
        IC(jj,ii)=Wc'*fXYc;
        
        % errors
        
        if abs(IREF(jj)) > 0
            EC(jj,ii)=abs(IC(jj,ii)-IREF(jj,ii))/abs(IREF(jj,ii));
            AC(jj,ii)=abs(IC(jj,ii)-IREF(jj,ii));
        else
            EC(jj,ii)=abs(IC(jj,ii)-IREF(jj,ii));
            AC(jj,ii)=EC(jj,ii);
        end
        
        
        
    end
    
    
    %     %------------------------------
    %     % determining Gauss-Green rule
    %     %------------------------------
    %     ade17=floor(ade/2);
    %     xyw17=polygauss_2017(polygon_sides,ade17,'quadrangulation');
    %
    %     % Gauss-Green rule result.
    %     X=xyw17(:,1); Y=xyw17(:,2); W=xyw17(:,3);
    %
    %     for jj=1:length(test_functionV)
    %         test_function=test_functionV(jj);
    %         f=define_function(test_function);
    %         fXY=feval(f,X,Y);
    %         IGG(jj,ii)=W'*fXY;
    %     end
    
end

format short e;
IREF
EF
EC

AF
AC


%--------------------------------------------------------------------------
% plots
%--------------------------------------------------------------------------

clf;
close;

% plotting triangulation

clf(figure(1));
figure(1)
hold on;
axis on
axis equal
titlestr1='Domain triangulation.';
titlestr2=strcat('Triangles: ',num2str(size(tri,1)),'.');
title({[titlestr1];[ titlestr2]})
triplot(tri);
plot(P,'FaceColor',[0.5 0.5 0.5]);
hold off;




function f=define_function(test_function,ade)

switch test_function
    case 1
        % f=@(x,y) (x+y).^ade;
        f=@(x,y) (1+x+0.5*y).^ade;
    case 2
        x0=0.5; y0=0.5;
        f=@(x,y) exp(-((x-x0).^2+(y-y0).^2));
    case 3
        x0=0.5; y0=0.5;
        f=@(x,y) ((x-x0).^2 + (y-y0).^2).^(3/2);
    case 4 % franke
        f=@(x,y) .75*exp(-((9*x-2).^2 + (9*y-2).^2)/4) + ...
            .75*exp(-((9*x+1).^2)/49 - (9*y+1)/10) + ...
            .5*exp(-((9*x-7).^2 + (9*y-3).^2)/4) - ...
            .2*exp(-(9*x-4).^2 - (9*y-7).^2);
    case 5
        f=@(x,y) sqrt((x-0.5).^2+(y-0.5).^2);
    case 6
        f=@(x,y) (0.2*x+0.5*y).^19;
    case 7
        f=@(x,y) exp((x-0.5).^2+(y-0.5).^2);
    case 8
        f=@(x,y) exp(-100*((x-0.5).^2+(y-0.5).^2));
    case 9
        f=@(x,y) cos(30*(x+y));
    case 10
        f=@(x,y) cos(5*(x+y));
    case 11
        f=@(x,y) exp((x-0.5).^1+(y-0.5).^1);
    case 12
        f=@(x,y) exp((x-0.5).^3+(y-0.5).^3);
    case 13
        f=@(x,y) (0.2*x+0.5*y).^15;
    case 14
        f=@(x,y) 1./(x.^2+y.^2);
end

















