
function demo_polygauss_IV(example)

%--------------------------------------------------------------------------
% OBJECT.
%--------------------------------------------------------------------------
% IN THIS DEMO WE TEST WEIGHTS AND NODES OF A RULE.
%--------------------------------------------------------------------------
% IMPORTANT:
% * THE CODE REQUIRES THE TOOLBOX CONTAINING POLYSHAPE (AVAILABLE FROM
% MATLAB R2017b VERSIONS).
% * COMPRESSION COMES FROM comprexcub.m THAT MUST BE APPLIED SEPARATELY
% FROM polygauss_2018.
% * IN THIS DEMO WE SHOW HOW TO TREAT DOMAINS THAT MAY BE NOT SIMPLY
% CONNECTED AND/OR EVEN NOT CONNECTED, VIA polyshape OPERATIONS.
%--------------------------------------------------------------------------
% INPUT:
% example: 1: convex 
%          2: concave and simple
%          3: concave and not simple
%--------------------------------------------------------------------------
% ROUTINES:
% 1. polygauss_2018 (external)
% 2. comprexcub (external)
%--------------------------------------------------------------------------
% EXAMPLE:
%  
% >> demo_polygauss_II(2)
% 
%  
% >>
%--------------------------------------------------------------------------
%% Copyright (C) 2018- Brian J. Bauman, Alvise Sommariva, Marco Vianello.
%%
%% This program is free software; you can redistribute it and/or modify
%% it under the terms of the GNU General Public License as published by
%% the Free Software Foundation; either version 2 of the License, or
%% (at your option) any later version.
%%
%% This program is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%% GNU General Public License for more details.
%%
%% You should have received a copy of the GNU General Public License
%% along with this program; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
%%
%% Author:  Brian J. Bauman  <bauman3@llnl.gov>
%%          Alvise Sommariva <alvise@math.unipd.it>
%%          Marco Vianello   <marcov@math.unipd.it>
%%
%% Date: December 07, 2018
%--------------------------------------------------------------------------

if nargin < 1, example=1; end

adeV=1:12; adeV=adeV';
pos=1;


switch example
    case 1
        polygon_sides=[0.1 0; 0.7 0.2; 1 0.5; 0.75 0.85; 0.5 1; 0 0.25; 0.1 0];
    case 2
        polygon_sides=(1/4)*[1 2; 1 0; 3 2; 3 0; 4 2; 3 3; 3 0.85*4; 2 4;
            0 3; 1 2];
    case 3
        % fprintf('\n \t [POLYGON]: QUATERFOIL LIKE');
        warning off;
        M=129;
        th=linspace(0,2*pi,M);
        %th=(th(1:end-1))';
        polygon_sides=[cos(th').*(sin(2*th')) sin(th').*(sin(2*th'))];
        polygon_sides=polygon_sides(1:end-1,:);
end
xv=polygon_sides(:,1); yv=polygon_sides(:,2);
iv=length(xv); % This variable depends on the holes or not connected domain.
% In these simple cases the domains are without holes and
% domains are connected.

%--------------------------
% REFERENCE RULE
%--------------------------

for ii=1:length(adeV)
    
    ade=adeV(ii);
    
    %--------------------------
    % FULL RULE
    %--------------------------
    [xyw,xvc,yvc,P,tri]=polygauss_2018(ade,xv,yv,iv);
    X=xyw(:,1); Y=xyw(:,2); W=xyw(:,3);
    cardF(ii)=length(W);
    [in on] = inpolygon(X,Y,xv,yv);
    [in on]
    inF(ii,1)=cardF(ii)-sum(in);
    onF(ii,1)=sum(on);
    %------------------------------
    % COMPRESSED RULE
    %------------------------------
    [pts,w,momerr] = comprexcub(ade,xyw(:,1:2),xyw(:,3),pos);
    
    % compressed rule result.
    Xc=pts(:,1); Yc=pts(:,2); Wc=w;
    cardC(ii)=length(Wc);
       
    [in on] = inpolygon(Xc,Yc,xv,yv);
    inC(ii,1)=cardC(ii)-sum(in);
    onC(ii,1)=sum(on);
    
end

[adeV inF inC onF onC]



%--------------------------------------------------------------------------
% plots
%--------------------------------------------------------------------------

clf;
close;

% plotting triangulation

clf(figure(1));
figure(1)
hold on;
axis off
axis equal
titlestr1='Domain triangulation.';
titlestr2=strcat('Triangles: ',num2str(size(tri,1)),'.');
title({[titlestr1];[ titlestr2]})
triplot(tri);
plot(P,'FaceColor',[0.5 0.5 0.5]);
hold off;




% plotting full cub. nodes

clf(figure(2));
figure(2)
hold on;
axis off;
axis equal;
titlestr1='Quadrature points of the new formula (before compression).';
titlestr2=strcat('Cardinality: ',num2str(size(xyw,1)),'. Ade: ',num2str(ade),'.');
title({[titlestr1];[ titlestr2]});
plot(P,'FaceColor',[0.5 0.5 0.5]);
plot(xyw(:,1),xyw(:,2),'ko','LineWidth',1,...
    'MarkerEdgeColor','k',...
    'MarkerFaceColor','g',...
    'MarkerSize',2)
% plot(xywc(:,1),xywc(:,2),'ko','LineWidth',1,...
%     'MarkerEdgeColor','k',...
%     'MarkerFaceColor','g',...
%     'MarkerSize',6)
hold off;





% plotting compressed cub. nodes

clf(figure(3));
figure(3)
hold on;
axis off
axis equal
titlestr1='Quadrature points of the new formula (after compression).';
titlestr2=strcat('Cardinality: ',num2str(size(pts,1)),'. Ade: ',num2str(ade),'.');
title({[titlestr1];[ titlestr2]})
plot(P,'FaceColor',[0.5 0.5 0.5]);
plot(pts(:,1),pts(:,2),'ko','LineWidth',1,...
    'MarkerEdgeColor','k',...
    'MarkerFaceColor','c',...
    'MarkerSize',6)
hold off;












