
function demo_polygauss_newtests(example,test_functionV)

if nargin < 1 example=2; end
if nargin < 2 test_functionV=1:6; end

adeV=5:5:30;
pos=2;

%--------------------------
% defining domain
%--------------------------

switch example
    case 1
        polygon_sides=[0.1 0; 0.7 0.2; 1 0.5; 0.75 0.85; 0.5 1; 0 0.25; 0.1 0];
    case 2
        polygon_sides=(1/4)*[1 2; 1 0; 3 2; 3 0; 4 2; 3 3; 3 0.85*4; 2 4;
            0 3; 1 2];
end
xv=polygon_sides(:,1); yv=polygon_sides(:,2);
iv=length(xv); % This variable depends on the holes or not connected domain.
% In these simple cases the domains are without holes and
% domains are connected.

%--------------------------
% determining reference rule
%--------------------------
[xyw,xvc,yvc,P,tri]=polygauss_2018(50,xv,yv,iv);

% full rule result.
X=xyw(:,1); Y=xyw(:,2); W=xyw(:,3);

for jj=1:length(test_functionV)
    test_function=test_functionV(jj);
    f=define_function(test_function);
    fXY=feval(f,X,Y);
    IREF(jj,1)=W'*fXY;
end




for ii=1:length(adeV)
    
    ade=adeV(ii);
    
    %--------------------------
    % determining full rule
    %--------------------------
    [xyw,xvc,yvc,P,tri]=polygauss_2018(ade,xv,yv,iv);
    
    % full rule result.
    X=xyw(:,1); Y=xyw(:,2); W=xyw(:,3);
    posF(ii)=sum(abs(W))-sum(W);
    cardF(ii)=length(W);
    [IN ON] = inpolygon(X,Y,xv,yv);
    insideF(ii)=length(X)-sum(IN)-sum(ON);

    %------------------------------
    % determining compressed rule.
    %------------------------------
    [pts,w,momerr] = comprexcub(ade,xyw(:,1:2),xyw(:,3),pos);
    
    % compressed rule result.
    Xc=pts(:,1); Yc=pts(:,2); Wc=w;
    cardC(ii)=length(Wc);
    [IN ON] = inpolygon(Xc,Yc,xv,yv);
    insideC(ii)=length(Xc)-sum(IN)-sum(ON);
    posC(ii)=sum(abs(Wc))-sum(Wc);
    momerrC(ii)=momerr;
    
    for jj=1:length(test_functionV)
        test_function=test_functionV(jj);
        f=define_function(test_function);
        
        % full rule
        fXY=feval(f,X,Y);
        IF(jj,ii)=W'*fXY;
        if abs(IREF(jj)) > 0
            EF(jj,ii)=abs(IF(jj,ii)-IREF(jj))/abs(IREF(jj));
        else
            EF(jj,ii)=abs(IF(jj,ii)-IREF(jj));
        end
        
        % compressed rule
        fXYc=feval(f,Xc,Yc);
        IC(jj,ii)=Wc'*fXYc;
        if abs(IREF(jj)) > 0
            EC(jj,ii)=abs(IC(jj,ii)-IREF(jj))/abs(IREF(jj));
            EFC(jj,ii)=abs(IC(jj,ii)-IF(jj,ii))/abs(IREF(jj));
        else
            EC(jj,ii)=abs(IC(jj,ii)-IREF(jj));
            EFC(jj,ii)=abs(IC(jj,ii)-IF(jj,ii));
        end
        
        
        
    end
    
    
    %     %------------------------------
    %     % determining Gauss-Green rule
    %     %------------------------------
    %     ade17=floor(ade/2);
    %     xyw17=polygauss_2017(polygon_sides,ade17,'quadrangulation');
    %
    %     % Gauss-Green rule result.
    %     X=xyw17(:,1); Y=xyw17(:,2); W=xyw17(:,3);
    %
    %     for jj=1:length(test_functionV)
    %         test_function=test_functionV(jj);
    %         f=define_function(test_function);
    %         fXY=feval(f,X,Y);
    %         IGG(jj,ii)=W'*fXY;
    %     end
    
end

format short e;
EF
EC
EFC
IREF
%insideF
%insideC
[adeV' posF' posC']

%--------------------------------------------------------------------------
% plots
%--------------------------------------------------------------------------

clf;
close;

% plotting triangulation

clf(figure(1));
figure(1)
hold on;
axis off
axis equal
titlestr1='Domain triangulation.';
titlestr2=strcat('Triangles: ',num2str(size(tri,1)),'.');
title({[titlestr1];[ titlestr2]})
triplot(tri);
plot(P,'FaceColor',[0.5 0.5 0.5]);
hold off;




function f=define_function(test_function)

switch test_function
    case 1 % franke
        f=@(x,y) .75*exp(-((9*x-2).^2 + (9*y-2).^2)/4) + ...
            .75*exp(-((9*x+1).^2)/49 - (9*y+1)/10) + ...
            .5*exp(-((9*x-7).^2 + (9*y-3).^2)/4) - ...
            .2*exp(-(9*x-4).^2 - (9*y-7).^2);
    case 2
        f=@(x,y) sqrt((x-0.5).^2+(y-0.5).^2);
    case 3
        f=@(x,y) (0.2*x+0.5*y).^19;
    case 4
        f=@(x,y) exp((x-0.5).^2+(y-0.5).^2);
    case 5
        f=@(x,y) exp(-100*((x-0.5).^2+(y-0.5).^2));
    case 6
        f=@(x,y) cos(30*(x+y));
end

















