
function demo_polygauss_newtests_poly(example,test_functionV)

if nargin < 1 example=2; end
if nargin < 2 test_functionV=1:6; end

adeV=5:5:30;
pos=2;

%--------------------------
% defining domain
%--------------------------

switch example
    case 1
        polygon_sides=[0.1 0; 0.7 0.2; 1 0.5; 0.75 0.85; 0.5 1; 0 0.25; 0.1 0];
    case 2
        polygon_sides=(1/4)*[1 2; 1 0; 3 2; 3 0; 4 2; 3 3; 3 0.85*4; 2 4;
            0 3; 1 2];
end
xv=polygon_sides(:,1); yv=polygon_sides(:,2);
iv=length(xv); % This variable depends on the holes or not connected domain.
% In these simple cases the domains are without holes and
% domains are connected.

%--------------------------
% determining reference rule
%--------------------------





    %--------------------------
    % determining ref rule
    %--------------------------
    [xyw,xvc,yvc,P,tri]=polygauss_2018(50,xv,yv,iv);

% full rule result.
XR=xyw(:,1); YR=xyw(:,2); WR=xyw(:,3);

for ii=1:length(adeV)
    
    ade=adeV(ii);
    
    
    %--------------------------
    % determining full rule
    %--------------------------
    [xyw,xvc,yvc,P,tri]=polygauss_2018(ade,xv,yv,iv);
    
    % full rule result.
    X=xyw(:,1); Y=xyw(:,2); W=xyw(:,3);
    cardF(ii)=length(W);

    %------------------------------
    % determining compressed rule.
    %------------------------------
    [pts,w,momerr] = comprexcub(ade,xyw(:,1:2),xyw(:,3),pos);
    
    % compressed rule result.
    Xc=pts(:,1); Yc=pts(:,2); Wc=w;
    cardC(ii)=length(Wc);
    momerrC(ii)=momerr;
    
    for jj=1:length(test_functionV)
        test_function=test_functionV(jj);
        f=define_function(test_function);
        
        
        % full rule
        fXY=feval(f,X,Y);
        IF(jj,ii)=W'*fXY;
        if abs(IREF(jj)) > 0
            EF(jj,ii)=abs(IF(jj,ii)-IREF(jj))/abs(IREF(jj));
        else
            EF(jj,ii)=abs(IF(jj,ii)-IREF(jj));
        end
        
        % full rule
        fXY=feval(f,X,Y);
        IF(jj,ii)=W'*fXY;
        if abs(IREF(jj)) > 0
            EF(jj,ii)=abs(IF(jj,ii)-IREF(jj))/abs(IREF(jj));
        else
            EF(jj,ii)=abs(IF(jj,ii)-IREF(jj));
        end
        
        % compressed rule
        fXYc=feval(f,Xc,Yc);
        IC(jj,ii)=Wc'*fXYc;
        if abs(IREF(jj)) > 0
            EC(jj,ii)=abs(IC(jj,ii)-IREF(jj))/abs(IREF(jj));
        else
            EC(jj,ii)=abs(IC(jj,ii)-IREF(jj));
        end
        
        
        
    end
    
    
    %     %------------------------------
    %     % determining Gauss-Green rule
    %     %------------------------------
    %     ade17=floor(ade/2);
    %     xyw17=polygauss_2017(polygon_sides,ade17,'quadrangulation');
    %
    %     % Gauss-Green rule result.
    %     X=xyw17(:,1); Y=xyw17(:,2); W=xyw17(:,3);
    %
    %     for jj=1:length(test_functionV)
    %         test_function=test_functionV(jj);
    %         f=define_function(test_function);
    %         fXY=feval(f,X,Y);
    %         IGG(jj,ii)=W'*fXY;
    %     end
    
end

format short e;
EF
EC

%--------------------------------------------------------------------------
% plots
%--------------------------------------------------------------------------

clf;
close;

% plotting triangulation

clf(figure(1));
figure(1)
hold on;
axis off
axis equal
titlestr1='Domain triangulation.';
titlestr2=strcat('Triangles: ',num2str(size(tri,1)),'.');
title({[titlestr1];[ titlestr2]})
triplot(tri);
plot(P,'FaceColor',[0.5 0.5 0.5]);
hold off;




function f=define_function(test_function)

a =[

     2.383060875508688e-01
     9.845640009630318e-01
     8.465979021173318e-01
     7.945115963949447e-01
     9.002780666829862e-01
     7.801047187222937e-01
     8.365107716467481e-01
     3.210932644447022e-01
     7.427455759016700e-01
     6.644942849965509e-01
     2.891836906020334e-01
     3.373722329778035e-01
     9.086370591754401e-01
     3.225098044129771e-02
     6.963577279556656e-01
     2.087698158888892e-01
     8.241493563279357e-01
     2.182322637339749e-01
     9.964230296161369e-02
     6.195058164458230e-01
     1.038147826511059e-01
     7.990618035896366e-01
     9.029251192829391e-01
     3.125128459866667e-01
     2.815891661592237e-01
     6.781941268059088e-03
     4.958716656667858e-01
     9.884822430122869e-01
     7.379407514955191e-01
     3.107198173915697e-01
     6.004075003511505e-01
     7.816798266611155e-01
     1.115331246849433e-01
     5.793292893889059e-01
     8.703712203117199e-01
     6.897762496111239e-01
     2.429702509216287e-01
     3.427222518697588e-01
     5.454397879754257e-01
     6.757269268931632e-02
     4.104483996985445e-01
     2.375113972293935e-01
     4.889735564247273e-01
     8.060665883017875e-01
     3.778479516711788e-01
     5.179781445073883e-01
     9.459788934495161e-02
     9.090951928498356e-01
     2.076305939973421e-01
     3.820645235405298e-01
     6.602802651786851e-01
     7.583733022775722e-01
     1.730694123920961e-01
     5.173797615063259e-01
     9.953381123034661e-01
     7.076094065907088e-01
     8.056730092393083e-02
     4.330809637510247e-02
     4.911555629842604e-01
     4.465964401692026e-01
     4.867985658453455e-01
     1.658911220853418e-01
     3.606565048131117e-01
     8.807219417637134e-01
     7.443521799961995e-01
     4.167710509194508e-01
     9.073548084752534e-01
     9.430687377153024e-02
     1.813262610181446e-01
     9.465872321832016e-01
     1.008490568603813e-01
     3.880380699742065e-01
     2.892248620249862e-01
     7.308686079759297e-02
     1.946080054370831e-01
     4.174852311032832e-01
     2.929265591439401e-01
     7.021385117912492e-01
     2.397131779353223e-01
     9.594826207080054e-01
     3.054622023071188e-01
     1.549154582130844e-01
     5.555084193239769e-01
     7.905436891122322e-01
     4.438722935878439e-01
     9.958187217274933e-01
     4.365866981625556e-01
     3.044411729730888e-01
     2.465103409167718e-01
     9.608252516545627e-01
     2.228809584386662e-01
     3.956091814662299e-01
     2.245245533360168e-01
     2.700246690154953e-01
     4.184414790025891e-01
     9.977359797733240e-01
     9.110304039307808e-01
     5.504268887160374e-01
     5.963358157763801e-01
     7.914523930290729e-02];
 
 b =[

     5.766360373905486e-01
     8.981723119716376e-01
     4.633105672593452e-01
     3.983964268730992e-01
     1.044611147983914e-01
     6.522363886787104e-01
     9.917000053536016e-01
     6.780728159732941e-01
     4.284775936338511e-01
     6.548013215758780e-01
     5.887455286050384e-01
     7.450549102477880e-01
     6.408702881697659e-01
     5.036761862070240e-01
     9.380414758051940e-01
     6.053435806214843e-01
     6.389237481797020e-01
     7.026574142299672e-01
     8.609490891038369e-01
     3.796624173441944e-01
     7.121228834053774e-01
     5.235204355185613e-01
     3.634894387939657e-01
     4.346758731174332e-01
     6.875976215327535e-01
     2.268511459140403e-01
     9.790036049710639e-01
     9.756709391498699e-01
     2.895138010801485e-01
     3.384333196129237e-01
     9.964446650382341e-01
     7.889705269451158e-01
     7.949215479689165e-01
     6.323688737283483e-01
     8.114507855762982e-01
     4.480932509508988e-01
     8.306135526164272e-01
     1.266633142608106e-01
     5.132681278281680e-01
     7.159312523532481e-01
     2.481463529364285e-01
     5.319003251689717e-01
     3.822096829365791e-01
     8.017612429730357e-01
     6.708607713321380e-01
     9.828591845946677e-01
     9.368213286285900e-01
     5.762723540620367e-01
     8.018618703008662e-02
     4.138248421084407e-01
     1.808450244722333e-01
     9.956311872326238e-01
     5.203861943496564e-01
     8.852826954983734e-01
     6.482515214307186e-01
     4.662535903679803e-01
     9.528087700930543e-02
     9.678207995524121e-01
     6.201114093756263e-01
     1.560031568910335e-01
     3.983670641395350e-01
     8.825049457846119e-01
     5.390139202139694e-01
     5.436760690376757e-01
     4.424525198446765e-01
     1.837452864550069e-01
     2.492307978080140e-01
     2.851115520655817e-01
     5.295095094211840e-01
     5.598373737970647e-01
     4.151456820773225e-01
     9.056803223001387e-01
     3.051431860776300e-01
     6.497696795072665e-01
     2.887819465887381e-01
     2.552514503810984e-01
     3.581831098758829e-01
     8.059175117964145e-01
     5.389265559303570e-01
     5.900636133920345e-01
     2.311417413817853e-01
     1.019462506405334e-01
     6.446444893426710e-01
     9.801387267093835e-01
     1.017224189210626e-01
     1.878661273947947e-01
     9.385358493663620e-03
     8.383034056388474e-01
     4.813423685198637e-01
     4.685304754154280e-01
     9.085495250201894e-01
     4.171474878676767e-01
     5.441380059590479e-01
     6.990088618515664e-01
     7.905025558218415e-02
     5.094158657574641e-01
     4.868982988716907e-01
     8.558802831579221e-01
     6.144047705991091e-01
     1.174152534372086e-01];



















