
function demo_reeger

%--------------------------
% defining domain.
%--------------------------
Polygon_Vertices=[-1/2,1/2;-1/2,-1/2;1/2,-1/2;1/2,1/2;-1/2,1/2];

for ade=5:5:30
    
    xv=Polygon_Vertices(:,1);
    yv=Polygon_Vertices(:,2);
    iv=[];
    
    [xyw,xvc,yvc,pgon,tri]=polygauss_2018(ade+30,xv,yv,iv);
    % reference rule result.
    X=xyw(:,1); Y=xyw(:,2); W=xyw(:,3);
    IR=compute_integrals(X,Y,W);
    
    %--------------------------
    % determining full rule
    %--------------------------
    [xyw,xvc,yvc,pgon,tri]=polygauss_2018(ade,pgon);
    
    % full rule result.
    X=xyw(:,1); Y=xyw(:,2); W=xyw(:,3);
    
    IF=compute_integrals(X,Y,W);
    REF=abs(IF-IR)./abs(IR);
    CF=length(W);
    
    %------------------------------
    % determining compressed rule.
    %------------------------------
    [pts,w,momerr] = comprexcub(ade,xyw(:,1:2),xyw(:,3),1);
    
    % compressed rule result
    X=pts(:,1); Y=pts(:,2); W=w;

    IC=compute_integrals(X,Y,W);
    REC=abs(IC-IR)./abs(IR);
    CC=length(W);
    
    %------------------------------
    % Reeger-Fornberg RBF method.
    %------------------------------
    NN=CC;
    [F1_Square,F2_Square,F3_Square,CERF]=Bounded_Smooth_Surface_Quadrature_RBF_Test(NN);
    
    IRF=[F1_Square F2_Square F3_Square];
    RERF=abs(IRF-IR)./abs(IR);
    
    fprintf('\n \n \t ** ADE: %3.0f PTS: %6.0f ** %6.0f ** %6.0f',...
        ade,CF,CC,CERF)
    
    
    fprintf('\n \t RE FULL RULE: %1.2e - %1.2e - %1.2e',REF(1),REF(2),REF(3));
    fprintf('\n \t RE COMP RULE: %1.2e - %1.2e - %1.2e',REC(1),REC(2),REC(3));
    fprintf('\n \t RE RBF  RULE: %1.2e - %1.2e - %1.2e',RERF(1),RERF(2),RERF(3));
    
end


function I=compute_integrals(X,Y,W)

f1_Plane=@(x,y) exp(-x.^2-y.^2);

f2_Plane=@(x,y) 1./(1+25*(x.^2+y.^2));

f3_Plane=@(x,y) 1./(1+25*(abs(x)+abs(y)));

f1XY=feval(f1_Plane,X,Y);
I(1)=W'*f1XY;

f2XY=feval(f2_Plane,X,Y);
I(2)=W'*f2XY;

f3XY=feval(f3_Plane,X,Y);
I(3)=W'*f3XY;




