
function demo_reeger_2

%--------------------------
% defining domain.
%--------------------------
Polygon_Vertices=[-1/2,1/2;-1/2,-1/2;1/2,-1/2;1/2,1/2;-1/2,1/2];

xv=Polygon_Vertices(:,1);
yv=Polygon_Vertices(:,2);
iv=[];

pos=0; % 0: QR, 1: lsqnonneg, 2: NNLS


%--------------------------
% determining reference rule
%--------------------------
% [xyw,xvc,yvc,pgon,tri]=polygauss_2018(100,xv,yv,iv);
% % reference rule result.
% X=xyw(:,1); Y=xyw(:,2); W=xyw(:,3);
% IR=compute_integrals(X,Y,W);

IR=[8.5112066750879455945266727e-01 2.7337301704599370477666298e-01 9.2402486281985149463302776e-02];

for ade=5:5:30
    
    
    %--------------------------
    % determining full rule
    %--------------------------
    tic;
    [xyw,xvc,yvc,pgon,tri]=polygauss_2018(ade,xv,yv,iv);
    CPU1=toc;
    
    % full rule result.
    X=xyw(:,1); Y=xyw(:,2); W=xyw(:,3);
    
    IF=compute_integrals(X,Y,W);
    REF=abs(IF-IR)./abs(IR);
    CF=length(W);
    stab_ratio(1)=sum(abs(W))/sum(W);
    
    %------------------------------
    % determining compressed rule.
    %------------------------------
    tic;
    [pts,w,momerr] = comprexcub(ade,xyw(:,1:2),xyw(:,3),pos);
    CPU2=toc;
    CPU2=CPU1+CPU2;
    
    % compressed rule result
    X=pts(:,1); Y=pts(:,2); W=w;
    stab_ratio(2)=sum(abs(W))/sum(W);
    
    IC=compute_integrals(X,Y,W);
    REC=abs(IC-IR)./abs(IR);
    CC=length(W);
    
    %------------------------------
    % Reeger-Fornberg RBF method.
    %------------------------------
    NN=CF;
    [F1_Square,F2_Square,F3_Square,CERF,CPU3,W]=Bounded_Smooth_Surface_Quadrature_RBF_Test(NN);
    stab_ratio(3)=sum(abs(W))/sum(W);
    
    ipos=find(W > 0); Wpos=W(ipos);
    ineg=find(W < 0); Wneg=W(ineg);
    
    
    
    IRF=[F1_Square F2_Square F3_Square];
    RERF=abs(IRF-IR)./abs(IR);
    
    fprintf('\n \n \t ** ADE: %3.0f',ade);
    fprintf('\n \t NODES FULL RULE: %6.0f',CF);
    fprintf('\n \t NODES FULL RULE: %6.0f',CC);
    fprintf('\n \t NODES RBF RULE: %6.0f',CERF);
    
    fprintf('\n \t RE FULL RULE: %1.2e - %1.2e - %1.2e',REF(1),REF(2),REF(3));
    fprintf('\n \t RE COMP RULE: %1.2e - %1.2e - %1.2e',REC(1),REC(2),REC(3));
    fprintf('\n \t RE RBF  RULE: %1.2e - %1.2e - %1.2e',RERF(1),RERF(2),RERF(3));
    fprintf('\n \t CPUTIMES    : %1.2e - %1.2e - %1.2e',CPU1,CPU2,CPU3);
    fprintf('\n \t CPUTIMES RAT: [1 vs 3]: %1.4f - [2 vs 3]: %1.4f',100*CPU1/CPU3,100*CPU2/CPU3)
    fprintf('\n \t STAB. RAT   : %1.2e - %1.2e - %1.2e',stab_ratio(1),stab_ratio(2),stab_ratio(3));
    fprintf('\n \t WEIGHTS RBF : %1.2e - %1.2e',sum(Wpos),-sum(Wneg));
end

fprintf('\n \n');





function I=compute_integrals(X,Y,W)

f1_Plane=@(x,y) exp(-x.^2-y.^2);

f2_Plane=@(x,y) 1./(1+25*(x.^2+y.^2));

f3_Plane=@(x,y) 1./(1+25*(abs(x)+abs(y)));

f1XY=feval(f1_Plane,X,Y);
I(1)=W'*f1XY;

f2XY=feval(f2_Plane,X,Y);
I(2)=W'*f2XY;

f3XY=feval(f3_Plane,X,Y);
I(3)=W'*f3XY;




