function america_pshape=coastline_america

%--------------------------------------------------------------------------
% Polyshape object that is a coarse approximation of South and North
% America.
%--------------------------------------------------------------------------
% Information:
% Authors: A. Sommariva, M. Dessole and M. Vianello.
% Date: June 7, 2021.
%--------------------------------------------------------------------------

% In vertices we store, respectively, Longitude and Latitute, in degrees.
% Column 1: Longitude. Column 2: Latitude.

america_coord=[
    -73.361721999999986 -53.000416999999999
    -73.362611000000015 -53.000000000000000
    -72.890889000000016 -52.501666999999998
    -73.703389000000016 -52.796305999999994
    -73.739193999999998 -52.043360999999997
    -72.998333000000002 -52.083805999999996
    -72.988389000000041 -52.363777999999996
    -72.770805999999993 -51.969221999999995
    -72.918361000000004 -52.476278000000001
    -72.479221999999993 -51.792527999999997
    -73.144167000000039 -51.521667000000001
    -72.933528000000024 -51.156889000000000
    -73.425860999999998 -51.465027999999997
    -72.603053999999986 -51.772177999999997
    -73.362556000000041 -51.555028000000000
    -73.171013000000016 -52.036414000000001
    -73.402556000000004 -51.634194000000001
    -73.389763000000016 -52.042663999999995
    -73.930860999999993 -51.628332999999998
    -73.660861000000011 -51.111694000000000
    -74.237472000000025 -50.923333000000000
    -73.339249999999993 -50.694193999999996
    -73.569972000000007 -50.387082999999997
    -74.036667000000023 -50.851278000000001
    -73.962389000000030 -50.375028000000000
    -74.700917000000004 -50.210000000000001
    -73.861556000000007 -50.301277999999996
    -74.319194000000039 -49.640000000000001
    -73.649306000000024 -49.724166999999994
    -74.038333000000023 -49.192943999999997
    -74.412528000000009 -49.395832999999996
    -74.052972000000011 -48.744999999999997
    -74.395443999999998 -48.601693999999995
    -73.841361000000006 -48.407556000000000
    -74.652139000000034 -48.010027999999998
    -73.386806000000036 -48.288778000000001
    -73.678778000000023 -47.921666999999999
    -73.227222000000040 -48.019221999999999
    -73.730888999999991 -47.625471999999995
    -74.729611000000034 -47.714193999999999
    -73.915416999999991 -47.509194000000001
    -74.513750000000016 -47.454194000000001
    -73.923778000000027 -47.211666999999998
    -74.211694000000023 -46.754666999999998
    -74.850028000000009 -46.808749999999996
    -74.869250000000022 -46.437110999999994
    -75.522110999999995 -46.716667000000001
    -75.298361000000000 -46.947111000000000
    -75.622083000000032 -46.729194000000000
    -74.854611000000034 -46.372499999999995
    -74.563778000000013 -46.047556000000000
    -75.091250000000002 -45.884999999999998
    -74.727500000000020 -45.813749999999999
    -74.430889000000036 -46.047944000000001
    -74.084249999999997 -45.814639000000000
    -74.333750000000009 -46.132528000000001
    -73.994583000000034 -46.152527999999997
    -74.459610999999995 -46.199193999999999
    -73.869167000000004 -46.144610999999998
    -73.637472000000002 -46.539611000000001
    -73.141305999999986 -45.653360999999997
    -73.572528000000034 -45.784610999999998
    -73.492917000000034 -45.458388999999997
    -72.772110999999995 -45.407527999999999
    -73.516250000000014 -45.200027999999996
    -72.549639000000013 -44.527499999999996
    -73.287111000000039 -44.165028000000000
    -72.740388999999993 -43.845027999999999
    -73.102944000000036 -43.459193999999997
    -72.825444000000005 -42.515861000000001
    -72.496278000000018 -42.619166999999997
    -72.844583000000000 -42.302527999999995
    -72.489167000000009 -42.512943999999997
    -72.352944000000036 -42.175806000000001
    -72.884611000000007 -41.914138999999999
    -72.282916999999998 -41.393305999999995
    -72.578463999999997 -41.587474999999998
    -72.950861000000032 -41.474582999999996
    -73.765028000000029 -41.748750000000001
    -73.486278000000027 -41.569167000000000
    -73.959610999999995 -41.006721999999996
    -73.193750000000023 -39.442499999999995
    -73.685444000000018 -37.332499999999996
    -73.155417000000000 -37.114999999999995
    -71.618806000000006 -33.625833000000000
    -71.719583000000000 -30.599166999999998
    -71.277139000000034 -29.910027999999997
    -71.520443999999998 -28.913332999999998
    -70.449611000000004 -25.367500000000000
    -70.628805999999997 -23.504999999999999
    -70.057083000000034 -21.440027999999998
    -70.122944000000018 -20.009221999999998
    -70.307166999999993 -18.439222000000001
    -71.476721999999995 -17.291221999999998
    -75.143333000000041 -15.406277999999999
    -75.916278000000034 -14.654193999999999
    -76.398806000000036 -13.907499999999999
    -76.202111000000002 -13.395833000000000
    -77.657916999999998 -11.289999999999999
    -78.984611000000029 -8.212527999999999
    -79.981278000000032 -6.750861000000000
    -81.152139000000034 -5.979166999999999
    -80.852111000000036 -5.656694000000000
    -81.255417000000023 -4.272527999999999
    -80.004667000000040 -3.375028000000000
    -79.714639000000034 -2.596694000000000
    -79.877528000000041 -2.217111000000000
    -80.247500000000002 -2.738778000000000
    -80.898806000000036 -2.330833000000000
    -80.911249999999995 -1.054194000000000
    -80.275417000000004 -0.670000000000000
    -80.500444000000016 -0.392500000000000
    -79.948361000000034 0.170306000000000
    -80.090833000000032 0.775472000000000
    -78.928499999999985 1.063750000000000
    -79.033389000000000 1.635722000000000
    -78.530361000000028 1.766500000000000
    -78.562500000000000 2.441528000000000
    -77.767667000000017 2.663417000000000
    -77.131889000000001 3.637167000000000
    -77.023472000000027 3.919472000000000
    -77.530806000000041 4.205667000000000
    -77.294110999999987 6.558167000000000
    -78.401638999999989 7.923806000000000
    -78.058943999999997 8.424166999999999
    -78.420999999999992 8.347443999999999
    -79.087778000000014 9.040778000000000
    -80.473388999999997 8.230777999999999
    -79.992472000000021 7.516471999999999
    -80.439639000000000 7.239833000000000
    -80.890028000000029 7.205639000000000
    -81.056221999999991 7.914889000000000
    -81.515639000000021 7.709055999999999
    -81.760721999999987 8.213528000000000
    -82.718083000000036 8.326694000000000
    -82.892694000000006 8.033222000000000
    -83.380389000000037 8.744778000000000
    -83.277250000000038 8.386417000000000
    -83.569194000000039 8.440555999999999
    -83.622444000000030 9.041167000000000
    -84.741417000000013 9.968943999999999
    -85.282639000000017 10.267693999999999
    -84.862444000000039 9.829749999999999
    -85.110111000000018 9.554943999999999
    -85.672555999999986 9.904888999999999
    -85.661056000000031 10.776000000000000
    -85.952583000000004 10.892610999999999
    -85.670667000000037 11.060333000000000
    -87.692361000000005 12.909471999999999
    -87.303471999999999 12.924971999999999
    -87.404083000000014 13.417721999999999
    -88.717500000000030 13.264222000000000
    -88.467889000000014 13.157444000000000
    -91.305333000000019 13.948832999999999
    -94.319139000000007 16.139972000000000
    -96.563417000000015 15.645000000000000
    -101.071722000000022 17.266472000000000
    -101.950139000000036 17.960943999999998
    -103.509917000000030 18.312666999999998
    -105.519306000000000 20.032471999999999
    -105.695278000000002 20.409889000000000
    -105.246778000000006 20.582360999999999
    -105.540333000000004 20.770139000000000
    -105.190333000000010 21.460916999999998
    -105.973444000000001 22.879943999999998
    -107.995583000000011 24.646722000000000
    -108.044194000000005 25.068749999999998
    -109.399639000000008 25.681639000000001
    -109.093389000000002 26.286360999999999
    -110.523944000000000 27.291360999999998
    -110.501500000000021 27.869166999999997
    -111.106417000000022 27.936055999999997
    -112.174889000000007 28.967806000000000
    -113.107250000000022 31.205138999999999
    -114.954750000000018 31.881000000000000
    -114.565694000000008 30.011305999999998
    -112.845750000000010 28.441167000000000
    -112.703944000000007 27.753499999999999
    -111.441917000000018 26.519389000000000
    -110.681722000000008 24.359860999999999
    -109.826833000000022 24.061166999999998
    -109.459056000000004 23.198332999999998
    -110.008750000000020 22.892388999999998
    -110.328389000000016 23.560278000000000
    -112.176083000000006 24.814111000000000
    -112.238917000000015 26.083971999999999
    -113.167139000000020 26.992832999999997
    -113.626472000000007 26.719221999999998
    -115.026806000000022 27.740416999999997
    -113.957778000000019 27.656056000000000
    -114.277556000000004 27.903167000000000
    -114.047500000000014 28.465138999999997
    -115.699972000000002 29.754832999999998
    -117.435028000000017 33.254249999999999
    -118.534556000000009 34.033833000000001
    -120.638694000000015 34.559388999999996
    -120.641444000000007 35.135138999999995
    -122.407111000000015 37.196638999999998
    -122.478389000000021 37.809556000000001
    -122.008944000000014 37.464166999999996
    -122.256972000000019 38.060832999999995
    -123.023028000000011 37.994416999999999
    -123.731667000000016 38.921555999999995
    -124.412500000000023 40.441666999999995
    -124.064028000000008 41.444693999999998
    -124.568444000000000 42.839166999999996
    -124.023361000000023 46.229917000000000
    -123.431306000000006 46.244166999999997
    -124.088306000000017 46.270638999999996
    -123.806250000000006 46.971666999999997
    -124.173861000000016 46.927332999999997
    -124.731278000000003 48.381667000000000
    -122.756806000000012 48.145305999999998
    -123.158556000000004 47.353499999999997
    -122.605889000000019 47.942028000000001
    -122.494583000000006 47.511666999999996
    -122.907799000000011 47.046512999999997
    -122.200974000000002 47.506671999999995
    -122.491417000000013 48.752417000000001
    -123.161333000000013 49.017471999999998
    -123.170833000000016 49.692889000000001
    -123.969611000000015 49.512471999999995
    -123.526306000000005 49.704166999999998
    -123.851806000000010 50.162693999999995
    -124.265833000000015 49.742055999999998
    -124.808306000000016 50.010749999999994
    -124.339806000000010 50.506777999999997
    -125.080889000000013 50.324166999999996
    -124.821528000000001 50.929193999999995
    -125.117556000000008 50.428305999999999
    -125.595889000000000 50.449193999999999
    -125.471694000000014 50.721249999999998
    -125.706750000000000 50.421250000000001
    -126.299167000000011 50.631667000000000
    -125.536721999999997 50.996221999999996
    -126.222739000000018 50.695924999999995
    -126.585917000000023 50.849166999999994
    -126.193361000000010 50.947944000000000
    -127.530861000000016 51.014167000000000
    -126.656610999999998 51.195916999999994
    -127.785888999999997 51.162499999999994
    -127.060917000000018 51.351666999999999
    -127.782528000000013 51.321666999999998
    -127.245806000000016 51.681638999999997
    -127.678361000000024 51.462083000000000
    -127.899139000000019 51.819167000000000
    -127.004111000000023 52.666221999999998
    -127.876444000000021 52.196249999999999
    -128.019136000000003 52.524808999999998
    -128.410861000000011 52.290832999999999
    -127.831806000000000 52.736193999999998
    -128.988639000000006 53.544999999999995
    -128.121278000000018 53.491360999999998
    -128.769889000000006 53.547360999999995
    -128.686000000000007 53.997610999999999
    -129.315222000000006 53.371221999999996
    -130.110889000000014 53.949999999999996
    -129.557528000000019 54.220832999999999
    -130.489249999999998 54.364138999999994
    -130.448472000000010 54.648721999999999
    -129.987556000000012 54.304138999999999
    -130.442556000000025 54.654139000000001
    -129.660832999999997 54.978305999999996
    -130.171806000000004 55.073749999999997
    -129.933110999999997 55.948777999999997
    -130.138001000000003 55.328924000000001
    -130.866750000000025 54.770443999999998
    -130.705083000000002 55.755806000000000
    -131.030861000000016 56.101999999999997
    -132.185889000000003 55.589166999999996
    -131.491111000000018 56.236556000000000
    -133.572500000000019 57.183332999999998
    -133.057472000000018 57.357555999999995
    -133.662528000000009 57.714166999999996
    -132.893694000000011 57.495916999999999
    -133.589194000000020 57.770083000000000
    -133.135778000000016 57.864221999999998
    -134.055971999999997 58.062388999999996
    -133.713333000000006 58.538166999999994
    -134.146861000000001 58.201971999999998
    -134.782694000000021 58.393305999999995
    -135.349556000000007 59.480750000000000
    -135.090889000000004 58.240832999999995
    -135.920889000000017 58.380806000000000
    -136.185721999999998 59.068138999999995
    -136.236750000000001 58.751221999999999
    -137.048083000000020 59.067499999999995
    -136.039222000000024 58.384971999999998
    -136.686694000000017 58.210360999999999
    -139.862722000000019 59.535750000000000
    -139.505167000000000 59.991194000000000
    -139.300194000000005 59.561194000000000
    -138.885778000000016 59.806638999999997
    -139.514944000000014 60.056638999999997
    -140.314972000000012 59.692028000000001
    -141.411250000000024 60.139832999999996
    -144.251750000000015 60.024583000000000
    -144.878306000000009 60.457305999999996
    -145.948444000000023 60.453721999999999
    -146.045139000000006 60.795777999999999
    -146.656610999999998 60.684888999999998
    -146.053028000000012 60.824805999999995
    -146.738500000000016 60.908221999999995
    -146.315556000000015 61.133944000000000
    -147.385028000000005 60.871221999999996
    -147.519971999999996 61.154638999999996
    -147.876666999999998 60.825416999999995
    -147.721083000000021 61.276638999999996
    -148.714194000000020 60.786666999999994
    -147.935889000000003 60.438333000000000
    -148.426333000000000 59.948888999999994
    -149.426749999999998 60.122916999999994
    -149.525917000000021 59.704999999999998
    -149.723332999999997 59.954193999999994
    -149.740611000000001 59.636555999999999
    -151.742638999999997 59.156582999999998
    -150.929972000000021 59.791499999999999
    -151.866722000000010 59.760693999999994
    -151.414222000000024 60.719971999999999
    -150.390417000000014 61.039999999999999
    -148.969166999999999 60.807471999999997
    -150.078972000000022 61.157305999999998
    -149.153389000000004 61.502972000000000
    -150.581333000000001 61.359943999999999
    -154.141306000000014 59.373528000000000
    -154.165500000000009 59.010306000000000
    -153.249972000000014 58.852499999999999
    -154.212472000000020 58.134416999999999
    -155.614889000000005 57.792443999999996
    -159.600028000000009 55.563167000000000
    -159.816889000000003 55.855860999999997
    -161.236694000000000 55.354917000000000
    -161.579611000000000 55.620805999999995
    -161.962056000000018 55.106249999999996
    -162.645194000000004 55.303360999999995
    -162.552582999999998 54.957499999999996
    -162.973872999999998 55.028807000000000
    -163.356694000000005 54.811249999999994
    -161.803917000000013 55.896499999999996
    -160.256721999999996 55.767888999999997
    -160.334861000000018 56.294305999999999
    -157.400889000000006 57.486666999999997
    -157.535527999999999 58.399138999999998
    -156.841667000000001 59.035693999999999
    -158.188806000000000 58.611694000000000
    -158.539417000000014 59.141582999999997
    -158.885111000000023 58.391721999999994
    -160.339250000000021 59.077249999999999
    -162.136194000000017 58.633916999999997
    -161.520972000000000 59.104582999999998
    -162.195444000000009 60.157610999999996
    -164.128028000000000 59.836555999999995
    -164.492306000000013 60.554361000000000
    -163.418250000000000 60.726471999999994
    -165.128917000000001 60.916582999999996
    -164.783389000000000 61.139333000000001
    -165.562111000000016 61.087582999999995
    -166.125139000000019 61.493499999999997
    -164.426722000000012 63.211610999999998
    -163.308278000000001 63.003749999999997
    -162.313361000000015 63.543721999999995
    -161.143028000000015 63.503471999999995
    -160.728694000000019 63.870749999999994
    -161.536083000000019 64.417444000000003
    -160.786278000000010 64.717860999999999
    -161.747278000000023 64.845416999999998
    -162.793833000000006 64.323388999999992
    -163.134388999999999 64.652861000000001
    -163.167667000000023 64.395916999999997
    -166.212361000000016 64.578693999999999
    -166.960167000000013 65.163777999999994
    -166.053500000000014 65.251694000000001
    -168.105333000000002 65.685110999999992
    -164.404055999999997 66.582443999999995
    -163.760972000000010 66.061332999999991
    -161.091806000000020 66.112416999999994
    -162.471500000000020 66.952416999999997
    -161.583472000000000 66.441721999999999
    -160.211749999999995 66.457999999999998
    -161.488360999999998 66.525806000000003
    -161.653528000000023 67.022306000000000
    -163.697917000000018 67.106583000000001
    -164.169306000000006 67.626277999999999
    -166.848000000000013 68.337778000000000
    -166.230389000000002 68.877082999999999
    -163.951778000000019 68.989527999999993
    -161.925167000000016 70.294556000000000
    -160.127667000000002 70.607111000000003
    -159.843722000000014 70.310833000000002
    -159.657472000000013 70.796222000000000
    -157.816777999999999 70.866833000000000
    -156.485083000000003 71.388722000000001
    -155.568916999999999 71.161610999999994
    -155.997472000000016 70.749832999999995
    -155.075111000000021 71.130443999999997
    -154.187583000000018 70.768749999999997
    -152.262583000000006 70.840443999999991
    -152.603889000000009 70.545805999999999
    -151.200028000000003 70.352055999999990
    -143.255055999999996 70.117888999999991
    -135.294972000000001 68.639916999999997
    -135.999361000000022 69.206305999999998
    -134.498444000000006 69.708832999999998
    -134.205889000000013 69.247944000000004
    -133.021111000000019 69.359693999999990
    -129.667972000000020 70.255639000000002
    -130.881000000000000 69.305916999999994
    -127.449083000000002 70.140917000000002
    -128.040139000000011 70.577305999999993
    -125.464472000000001 69.311388999999991
    -124.525750000000016 70.200527999999991
    -124.374278000000004 69.335916999999995
    -121.880167000000000 69.817250000000001
    -117.069667000000010 68.878610999999992
    -114.977833000000004 68.870999999999995
    -113.888722000000001 68.397971999999996
    -115.248556000000008 68.188861000000003
    -115.097750000000019 67.802555999999996
    -111.866083000000003 67.668194000000000
    -110.036028000000016 68.010916999999992
    -107.964306000000022 67.283305999999996
    -108.536000000000001 67.062305999999992
    -107.206693999999999 66.347250000000003
    -107.762694000000010 66.961556000000002
    -107.066472000000005 66.818610999999990
    -107.043917000000022 67.137917000000002
    -108.028778000000017 67.775250000000000
    -105.740896000000021 68.595101999999997
    -107.559917000000013 68.166639000000004
    -108.811333000000019 68.265833000000001
    -106.188917000000004 68.946749999999994
    -104.996639000000016 68.154805999999994
    -103.384111000000019 68.158610999999993
    -102.216749999999990 67.659360999999990
    -98.886250000000018 67.688166999999993
    -98.563889000000017 68.105638999999996
    -97.311278000000016 67.520027999999996
    -97.206500000000005 67.950221999999997
    -98.067341999999996 67.916919999999990
    -98.680971999999997 68.398832999999996
    -97.303750000000036 68.507110999999995
    -96.367888999999991 68.320499999999996
    -96.667750000000012 68.006305999999995
    -95.882277999999985 68.301000000000002
    -96.446111000000030 67.465861000000004
    -95.303971999999987 67.166471999999999
    -95.468389000000002 68.062749999999994
    -93.455582999999990 68.579471999999996
    -93.822222000000011 69.014222000000004
    -94.615860999999995 68.751666999999998
    -94.260889000000020 69.321805999999995
    -93.341833000000008 69.377471999999997
    -96.185860999999989 69.862250000000003
    -95.754055999999991 70.716943999999998
    -96.599889000000019 70.823749999999990
    -94.483556000000021 71.994193999999993
    -91.504972000000009 70.183916999999994
    -92.357806000000039 70.244500000000002
    -92.876221999999984 69.690888999999999
    -90.349139000000037 69.459277999999998
    -91.427444000000037 69.358333000000002
    -90.248389000000032 68.186722000000003
    -89.330916999999999 69.244638999999992
    -88.225888999999995 68.918916999999993
    -87.499722000000020 67.107056000000000
    -86.512278000000038 67.334082999999993
    -85.620889000000034 68.737055999999995
    -84.711277999999993 68.728222000000002
    -85.542250000000024 69.861943999999994
    -82.547861000000012 69.701110999999997
    -83.255306000000019 69.537416999999991
    -81.321750000000009 69.199083000000002
    -82.041528000000028 68.881416999999999
    -81.237972000000013 68.640056000000001
    -82.643694000000039 68.438471999999990
    -81.188417000000015 67.454388999999992
    -83.349832999999990 66.345167000000004
    -83.910139000000015 66.916721999999993
    -85.177305999999987 66.910167000000001
    -83.807028000000003 66.143610999999993
    -86.769444000000021 66.539943999999991
    -85.857833000000028 66.159306000000001
    -87.340193999999997 65.320278000000002
    -89.821777999999995 65.992417000000003
    -90.923528000000033 65.925916999999998
    -86.910527999999999 65.140833000000001
    -88.113167000000033 64.145443999999998
    -89.980277999999998 64.162166999999997
    -90.650332999999989 63.445416999999999
    -93.807667000000038 64.214388999999997
    -93.948778000000004 63.917666999999994
    -92.227389000000016 63.745805999999995
    -92.462943999999993 63.517221999999997
    -91.717544000000032 63.684903999999996
    -90.629222000000027 63.158193999999995
    -91.386361000000022 62.780555999999997
    -92.400028000000020 62.839610999999998
    -91.850583000000029 62.572139000000000
    -93.641222000000027 61.953082999999999
    -93.261444000000040 61.734860999999995
    -94.757194000000027 60.515639000000000
    -94.968888999999990 59.059360999999996
    -94.256750000000011 58.405999999999999
    -94.201583000000028 58.789027999999995
    -93.176750000000027 58.737027999999995
    -92.428167000000030 57.350943999999998
    -92.811861000000022 56.913916999999998
    -90.803167000000030 57.323194000000001
    -85.208583000000033 55.235471999999994
    -82.326500000000010 55.151360999999994
    -82.330778000000009 52.943832999999998
    -80.568582999999990 51.700888999999997
    -80.628805999999997 51.270527999999999
    -79.757806000000016 51.132556000000001
    -79.311332999999991 51.663860999999997
    -78.859472000000039 51.172556000000000
    -79.045722000000012 51.763027999999998
    -78.405972000000020 52.232999999999997
    -79.031971999999996 54.169750000000001
    -79.761361000000022 54.634332999999998
    -77.631555999999989 55.278193999999999
    -76.525417000000004 56.375749999999996
    -77.002000000000010 58.021055999999994
    -78.600611000000015 58.677527999999995
    -77.195556000000010 60.043721999999995
    -77.509444000000030 60.840388999999995
    -78.226472000000001 60.783777999999998
    -77.483499999999992 61.533193999999995
    -78.194556000000034 62.254694000000001
    -77.427888999999993 62.581888999999997
    -74.532194000000004 62.106943999999999
    -73.694749999999999 62.482194000000000
    -72.270722000000035 61.574166999999996
    -71.554583000000036 61.617193999999998
    -71.619694000000038 61.153555999999995
    -69.897417000000019 60.799277999999994
    -69.504083000000037 61.067639000000000
    -69.617305999999985 60.071444000000000
    -70.874722000000020 60.045916999999996
    -69.717500000000030 59.966639000000001
    -69.761167000000000 59.321555999999994
    -69.238027999999986 59.322944000000000
    -69.546110999999996 58.809110999999994
    -69.846388999999988 59.059943999999994
    -70.255556000000013 58.777221999999995
    -68.348472000000015 58.781582999999998
    -68.684777999999994 58.002582999999994
    -68.007639000000040 58.584860999999997
    -67.674666999999999 58.015110999999997
    -66.376944000000037 58.854832999999999
    -65.970944000000031 58.272666999999998
    -66.086417000000040 58.818360999999996
    -65.315472000000000 59.045721999999998
    -65.747667000000035 59.270527999999999
    -65.013889000000006 59.383471999999998
    -65.536667000000023 59.745694000000000
    -64.848444000000029 60.372916999999994
    -64.367527999999993 60.246666999999995
    -64.699166999999989 60.024971999999998
    -63.357555999999988 59.197499999999998
    -64.050889000000041 59.019166999999996
    -63.138306000000000 59.054555999999998
    -62.852500000000020 58.700806000000000
    -63.607555999999988 58.291666999999997
    -62.557583000000022 58.479971999999997
    -63.355861000000004 57.969138999999998
    -62.449999999999989 58.172888999999998
    -62.679193999999995 57.929138999999999
    -61.892500000000041 57.632500000000000
    -62.532556000000000 57.489138999999994
    -61.362500000000011 57.099971999999994
    -61.671694000000002 56.618721999999998
    -62.539221999999995 56.755806000000000
    -61.650833000000034 56.539193999999995
    -62.224250000000040 56.471638999999996
    -61.580805999999995 56.282499999999999
    -62.026749999999993 56.226278000000001
    -61.320861000000036 56.224139000000001
    -61.753306000000009 55.964555999999995
    -60.595000000000027 55.812082999999994
    -60.670000000000016 55.548749999999998
    -60.322583000000009 55.777499999999996
    -60.695832999999993 54.986666999999997
    -59.778333000000032 55.335388999999999
    -59.987527999999998 55.107471999999994
    -59.415888999999993 55.158332999999999
    -59.935027999999988 54.744555999999996
    -59.196639000000005 55.239528000000000
    -59.405000000000030 54.968693999999999
    -59.028416999999990 55.154555999999999
    -58.973361000000011 54.827082999999995
    -57.943361000000039 54.930388999999998
    -58.189193999999986 54.748332999999995
    -57.334194000000025 54.580805999999995
    -59.593361000000016 54.037110999999996
    -58.380889000000025 54.227499999999999
    -60.772500000000036 53.245805999999995
    -58.175056000000041 54.237888999999996
    -57.127528000000041 53.939999999999998
    -57.371693999999991 53.425388999999996
    -56.483361000000002 53.788750000000000
    -55.800889000000041 53.334972000000000
    -56.194222000000025 52.831610999999995
    -55.765861000000029 52.593305999999998
    -56.540833000000021 52.603277999999996
    -55.627528000000041 52.444944000000000
    -56.250806000000011 52.449999999999996
    -55.692528000000038 52.088332999999999
    -56.958361000000025 51.423749999999998
    -58.690028000000041 51.261249999999997
    -59.905028000000016 50.262916999999995
    -66.456694000000027 50.267888999999997
    -67.376693999999986 49.317889000000001
    -69.989193999999998 48.257360999999996
    -69.906250000000000 47.769027999999999
    -71.193444000000000 46.813055999999996
    -68.184139000000016 48.635416999999997
    -66.171721999999988 49.207082999999997
    -64.603333000000021 49.111249999999998
    -64.316694000000041 48.417916999999996
    -65.243389000000036 48.011221999999997
    -66.795500000000004 47.987055999999995
    -65.830861000000027 47.910083000000000
    -65.669582999999989 47.601222000000000
    -64.805722000000003 47.805082999999996
    -65.418889000000036 47.070277999999995
    -64.796861000000035 47.074638999999998
    -64.709249999999997 46.314610999999999
    -63.281361000000004 45.707888999999994
    -61.909249999999986 45.882888999999999
    -60.960417000000007 45.322499999999998
    -61.311250000000030 45.190805999999995
    -63.662500000000023 44.726278000000001
    -63.648389000000009 44.431249999999999
    -64.305694000000017 44.566193999999996
    -65.469278000000031 43.450389000000001
    -66.170500000000004 43.800193999999998
    -66.111694000000000 44.498694000000000
    -64.495639000000040 45.336694000000001
    -64.103417000000036 45.002471999999997
    -63.377250000000004 45.360889000000000
    -64.943693999999994 45.330166999999996
    -64.338000000000022 45.880666999999995
    -66.458333000000039 45.058721999999996
    -67.187166999999988 45.226472000000001
    -66.948750000000018 44.816638999999995
    -68.058889000000022 44.331610999999995
    -68.244361000000026 44.586416999999997
    -68.824917000000028 44.309971999999995
    -68.825693999999999 44.666443999999998
    -69.210916999999995 43.932555999999998
    -69.790193999999985 44.089917000000000
    -69.780278000000010 43.742638999999997
    -70.259778000000040 43.716471999999996
    -71.059193999999991 42.370778000000001
    -70.334306000000026 41.708694000000001
    -70.056556000000000 42.041610999999996
    -69.954583000000014 41.646611000000000
    -71.194556000000034 41.452777999999995
    -71.405056000000002 41.819389000000001
    -71.482305999999994 41.359027999999995
    -73.589194000000020 41.042888999999995
    -74.290888999999993 40.509000000000000
    -74.097139000000027 39.766638999999998
    -74.862527999999998 38.942056000000001
    -75.537139000000025 39.731667000000002
    -75.052917000000036 38.409999999999997
    -75.948306000000002 37.119527999999995
    -75.641250000000014 37.975833000000002
    -76.379222000000027 38.852360999999995
    -75.876167000000009 39.539471999999996
    -76.631082999999990 39.260750000000002
    -76.323778000000004 38.037416999999998
    -77.236110999999994 38.662388999999997
    -77.337750000000028 38.345027999999999
    -76.237639000000001 37.890833000000001
    -76.363056000000029 37.608221999999998
    -76.929611000000023 37.983944000000001
    -76.298639000000037 37.561082999999996
    -76.503832999999986 37.245528000000000
    -76.809250000000020 37.531999999999996
    -76.410672000000034 37.090803999999999
    -76.986056000000019 37.242332999999995
    -75.996611000000030 36.923166999999999
    -75.538417000000038 35.776693999999999
    -75.955943999999988 36.720749999999995
    -75.796417000000019 36.071528000000001
    -76.210028000000023 36.300416999999996
    -76.737055999999995 35.933306000000002
    -76.058306000000016 35.992888999999998
    -76.034194000000014 35.648750000000000
    -75.849389000000031 35.974916999999998
    -75.727805999999987 35.625527999999996
    -76.154138999999986 35.326250000000002
    -76.995528000000036 35.483638999999997
    -76.466250000000002 35.262471999999995
    -76.975861000000009 35.000388999999998
    -76.330861000000027 34.885388999999996
    -78.777444000000003 33.766610999999997
    -80.617556000000036 32.255721999999999
    -80.826833000000022 32.497306000000002
    -80.669332999999995 32.215666999999996
    -81.602111000000036 31.209999999999997
    -80.031667000000027 26.805944000000000
    -80.566666999999995 24.954556000000000
    -80.552928000000009 25.168876999999998
    -81.090000000000032 25.117055999999998
    -81.026277999999991 25.564138999999997
    -81.732082999999989 25.910805999999997
    -82.000472000000002 26.976666999999999
    -82.358806000000016 26.914971999999999
    -82.693778000000009 27.474166999999998
    -82.404583000000002 27.945833000000000
    -82.853778000000034 27.869971999999997
    -82.626278000000013 28.871638999999998
    -83.682194000000038 29.924944000000000
    -84.208333000000039 30.139582999999998
    -85.356639000000030 29.663332999999998
    -85.582528000000025 30.311249999999998
    -86.515889000000016 30.389972000000000
    -86.199361000000010 30.493805999999999
    -87.186389000000020 30.342443999999997
    -87.027693999999997 30.606582999999997
    -88.030222000000037 30.221693999999999
    -87.776417000000038 30.374881999999999
    -88.001193999999998 30.775055999999999
    -88.136694000000034 30.310721999999998
    -90.407556000000000 30.212416999999999
    -89.237944000000027 29.887471999999999
    -89.707943999999998 29.562500000000000
    -88.998639000000026 29.182610999999998
    -89.414167000000020 28.919556000000000
    -89.766694000000030 29.479555999999999
    -90.196055999999999 29.569110999999999
    -90.114944000000037 29.140722000000000
    -90.444972000000007 29.349860999999997
    -90.858277999999984 29.088277999999999
    -91.828805999999986 29.832749999999997
    -92.323582999999985 29.532332999999998
    -93.835417000000007 29.693082999999998
    -93.862917000000039 29.990471999999997
    -93.842194000000006 29.678916999999998
    -94.771500000000003 29.360806000000000
    -94.468611000000010 29.557361000000000
    -94.991500000000030 29.714250000000000
    -95.122583000000020 29.068360999999999
    -96.217528000000016 28.490361000000000
    -95.973500000000001 28.658138999999998
    -96.663388999999995 28.722027999999998
    -96.401250000000005 28.443306000000000
    -97.192778000000033 28.170166999999999
    -97.404583000000002 27.330805999999999
    -97.782110999999986 27.281638999999998
    -97.422111000000029 27.263306000000000
    -97.144528000000037 25.960055999999998
    -97.527500000000032 25.015388999999999
    -97.410028000000011 25.424610999999999
    -97.809611000000018 25.258277999999997
    -97.866278000000023 24.524999999999999
    -97.891111000000024 22.597500000000000
    -97.773250000000019 22.073028000000001
    -95.857416999999998 18.716556000000001
    -95.185806000000014 18.719138999999998
    -94.416832999999997 18.060805999999999
    -92.345082999999988 18.679193999999999
    -91.556250000000034 18.439667000000000
    -90.719194000000016 19.363056000000000
    -90.282167000000015 21.053221999999998
    -88.136806000000036 21.630027999999999
    -86.789889000000016 21.342582999999998
    -87.743556000000012 19.671861000000000
    -87.415222000000028 19.592333000000000
    -87.839249999999993 18.188193999999999
    -88.052000000000021 18.856832999999998
    -88.398193999999990 18.378305999999998
    -88.093139000000008 18.355221999999998
    -88.217361000000039 16.957443999999999
    -88.936528000000010 15.890582999999999
    -88.146556000000032 15.681666999999999
    -85.021778000000040 15.987305999999998
    -83.385167000000024 15.250860999999999
    -83.197444000000019 14.328082999999999
    -83.880028000000038 11.292610999999999
    -82.244916999999987 8.998305999999999
    -81.789194000000009 8.943332999999999
    -81.894833000000006 9.188250000000000
    -81.082583000000000 8.808389000000000
    -79.624333000000036 9.616500000000000
    -78.971000000000004 9.564722000000000
    -77.872944000000018 9.116555999999999
    -76.771028000000001 7.914028000000000
    -76.937139000000002 8.557499999999999
    -75.619583000000034 9.451611000000000
    -75.702528000000029 10.147667000000000
    -75.258833000000038 10.807556000000000
    -74.843333000000030 11.113721999999999
    -74.276694000000020 11.002082999999999
    -74.142528000000027 11.341194000000000
    -73.271722000000011 11.292083000000000
    -71.665888999999993 12.464499999999999
    -71.109611000000029 12.051527999999999
    -71.964667000000020 11.557444000000000
    -71.578750000000014 10.704972000000000
    -72.131167000000005 9.813388999999999
    -71.709388999999987 9.052056000000000
    -71.072278000000040 9.311527999999999
    -71.025000000000034 9.716583000000000
    -71.590443999999991 10.796666999999999
    -70.137499999999989 11.571221999999999
    -69.788333000000023 11.431250000000000
    -69.803360999999995 11.697056000000000
    -70.235444000000030 11.635833000000000
    -70.019889000000035 12.202389000000000
    -69.623333000000002 11.474527999999999
    -68.395861000000025 11.187082999999999
    -68.129194000000041 10.488750000000000
    -66.234167000000014 10.653749999999999
    -65.055056000000036 10.063722000000000
    -63.642889000000025 10.492471999999999
    -64.260861000000034 10.667028000000000
    -61.866639000000021 10.746167000000000
    -62.888750000000016 10.374972000000000
    -62.338861000000009 9.818194000000000
    -61.636666999999989 9.902917000000000
    -60.855028000000004 9.437861000000000
    -60.875889000000029 8.590389000000000
    -60.226694000000009 8.642806000000000
    -59.044972000000030 7.958749999999999
    -58.479861000000028 7.334694000000000
    -58.690028000000041 6.382083000000000
    -58.341694000000018 6.892083000000000
    -57.143583000000035 5.836583000000000
    -54.169278000000020 5.883693999999999
    -52.290861000000007 4.947916999999999
    -51.657389000000023 4.059528000000000
    -51.548778000000027 4.427250000000000
    -51.301333000000000 4.250500000000000
    -50.766667000000041 2.102139000000000
    -49.932694000000026 1.711722000000000
    -50.138443999999993 1.209778000000000
    -49.898472000000027 1.198111000000000
    -51.311278000000016 -0.079194000000000
    -51.700917000000004 -0.992389000000000
    -51.288361000000009 -0.512111000000000
    -51.248389000000032 -0.993361000000000
    -50.834167000000036 -0.548778000000000
    -50.800306000000035 -1.017083000000000
    -50.339194000000020 -0.096250000000000
    -48.387083000000018 -0.295833000000000
    -48.898361000000023 -1.503778000000000
    -50.442556000000025 -1.956889000000000
    -49.282500000000027 -1.727111000000000
    -49.485861000000000 -2.382917000000000
    -48.652500000000032 -1.394639000000000
    -48.446639000000005 -1.707111000000000
    -48.067083000000025 -1.550028000000000
    -48.494639000000006 -1.462556000000000
    -48.053360999999995 -0.659639000000000
    -47.367111000000023 -0.829194000000000
    -47.290888999999993 -0.596278000000000
    -46.347528000000011 -1.113778000000000
    -46.196666999999991 -0.888833000000000
    -46.147471999999993 -1.304611000000000
    -45.987527999999998 -1.045444000000000
    -45.695028000000036 -1.431278000000000
    -45.415416999999991 -1.291694000000000
    -45.521694000000025 -1.512083000000000
    -45.326666999999986 -1.317889000000000
    -45.239167000000009 -1.851278000000000
    -44.832917000000009 -1.414167000000000
    -44.482944000000032 -2.050861000000000
    -44.987944000000027 -2.448361000000000
    -44.360472000000016 -2.336722000000000
    -44.749556000000041 -2.623333000000000
    -44.818332999999996 -3.357944000000000
    -43.421667000000014 -2.332111000000000
    -42.260861000000034 -2.859583000000000
    -40.022471999999993 -2.837083000000000
    -38.475000000000023 -3.702944000000000
    -37.150332999999989 -4.974167000000000
    -35.616693999999995 -5.112083000000000
    -35.260444000000007 -5.481667000000000
    -34.794582999999989 -7.154166999999999
    -34.939583000000027 -8.355833000000001
    -38.068750000000023 -12.666694000000000
    -38.471667000000025 -13.014610999999999
    -38.690861000000041 -12.584610999999999
    -38.845750000000010 -12.834805999999999
    -39.137056000000030 -17.690805999999998
    -39.698750000000018 -18.373332999999999
    -39.808750000000032 -19.605000000000000
    -41.071278000000007 -21.501666999999998
    -40.984611000000029 -22.002499999999998
    -41.961694000000023 -22.531250000000000
    -42.014166999999986 -22.997083000000000
    -43.050860999999998 -22.982111000000000
    -43.083333000000039 -22.678777999999998
    -43.557527999999991 -23.077916999999999
    -44.412528000000009 -22.943777999999998
    -45.413361000000009 -23.824555999999998
    -46.380167000000029 -23.898693999999999
    -47.572499999999991 -24.678777999999998
    -48.212500000000034 -25.468750000000000
    -48.740860999999995 -25.372944000000000
    -48.348722000000009 -25.571666999999998
    -48.812139000000002 -26.309221999999998
    -48.465443999999991 -27.145861000000000
    -48.762083000000018 -28.538360999999998
    -49.699611000000004 -29.301666999999998
    -50.794639000000018 -31.142527999999999
    -52.085889000000009 -32.164611000000001
    -50.568778000000009 -30.464221999999999
    -51.303750000000036 -30.005027999999999
    -51.095443999999986 -30.371693999999998
    -52.274167000000034 -31.777943999999998
    -52.595443999999986 -33.059193999999998
    -54.150861000000020 -34.670471999999997
    -56.161721999999997 -34.935443999999997
    -57.855833000000018 -34.477111000000001
    -58.429611000000023 -33.919249999999998
    -58.442528000000038 -33.070444000000002
    -58.569611000000009 -34.417527999999997
    -57.197917000000018 -35.303332999999995
    -57.379583000000025 -35.970027999999999
    -56.730416999999989 -36.334167000000001
    -56.668778000000032 -36.887527999999996
    -57.547528000000000 -38.103749999999998
    -58.506694000000039 -38.542971999999999
    -61.110833000000014 -39.002943999999999
    -62.340889000000004 -38.770443999999998
    -62.006250000000023 -39.382528000000001
    -62.313722000000041 -39.298361000000000
    -62.382528000000036 -40.911277999999996
    -63.790055999999993 -41.167082999999998
    -65.007944000000009 -40.718361000000002
    -65.047139000000016 -42.055833000000000
    -64.470861000000014 -42.441277999999997
    -63.765056000000016 -42.075443999999997
    -63.584639000000038 -42.616667000000000
    -64.092528000000016 -42.877943999999999
    -64.395000000000039 -42.518749999999997
    -64.979167000000018 -42.652943999999998
    -64.306278000000020 -42.977556000000000
    -65.332110999999998 -43.663360999999995
    -65.521250000000009 -44.931666999999997
    -66.949194000000034 -45.267111000000000
    -67.627083000000027 -46.052499999999995
    -66.794167000000016 -46.998722000000001
    -65.739555999999993 -47.202528000000001
    -65.765471999999988 -47.917499999999997
    -67.572528000000034 -49.043332999999997
    -67.917555999999990 -50.009222000000001
    -68.343416999999988 -50.126249999999999
    -68.727500000000020 -49.756667000000000
    -68.360833000000014 -50.166722000000000
    -69.429250000000025 -51.091667000000001
    -68.954194000000030 -51.570000000000000
    -69.585861000000023 -51.607527999999995
    -68.967528000000016 -51.625861000000000
    -68.352500000000020 -52.340638999999996
    -69.216722000000004 -52.202805999999995
    -70.882944000000009 -52.738999999999997
    -71.283361000000014 -53.900444000000000
    -72.484167000000014 -53.394999999999996
    -71.855083000000036 -53.231277999999996
    -71.966722000000004 -53.578749999999999
    -71.349250000000040 -53.127527999999998
    -71.545083000000034 -52.568943999999995
    -72.926750000000027 -52.556249999999999
    -72.977583000000038 -53.082443999999995
    -73.361721999999986 -53.000416999999999
    ];

america_pshape=polyshape(america_coord);