
function australia_pshape=coastline_australia(flag)

%--------------------------------------------------------------------------
% Polyshape object that is a coarse approximation of Australia (including
% Tasmania).
%--------------------------------------------------------------------------
% INPUT:
% flag: 0: Australia Island 1: Australia and Tasmania
%--------------------------------------------------------------------------
% Information:
% Authors: A. Sommariva, M. Dessole and M. Vianello.
% Date: June 7, 2021.
%--------------------------------------------------------------------------

% In vertices we store, respectively, Longitude and Latitute, in degrees.
% Column 1: Longitude. Column 2: Latitude.

australia0_coord=[
    146.230028000000004 -38.697082999999999
    146.276221999999990 -39.000000000000000
    145.371638999999988 -38.539611000000001
    145.488305999999994 -38.235444000000001
    144.658360999999985 -38.311278000000001
    145.116277999999994 -38.148333000000001
    144.928305999999992 -37.842917000000000
    143.556638999999990 -38.858750000000001
    140.581666999999982 -38.032916999999998
    139.740361000000007 -37.183306000000002
    139.612110999999999 -36.156721999999995
    139.722471999999982 -36.288806000000001
    139.517555999999985 -35.961250000000000
    138.890805999999998 -35.533749999999998
    138.097860999999995 -35.626694000000001
    138.567860999999994 -34.826667000000000
    138.094193999999987 -34.135416999999997
    137.762555999999989 -35.117944000000001
    136.851693999999981 -35.285416999999995
    137.015832999999986 -34.895443999999998
    137.452944000000002 -34.908332999999999
    137.450444000000005 -34.140028000000001
    137.977916999999991 -33.553360999999995
    137.754138999999981 -32.458777999999995
    137.781000000000006 -33.000000000000000
    135.933721999999989 -34.534193999999999
    135.957499999999982 -35.007916999999999
    135.112888999999996 -34.589999999999996
    135.518749999999983 -34.614193999999998
    134.707916999999981 -33.181666999999997
    134.059610999999990 -32.914138999999999
    134.181667000000004 -32.485416999999998
    131.152471999999989 -31.464582999999998
    125.957499999999996 -32.288778000000001
    124.234138999999999 -33.019582999999997
    123.526666999999989 -33.937971999999995
    119.903360999999990 -33.934582999999996
    117.953305999999998 -35.128777999999997
    116.624139000000000 -35.057943999999999
    115.128305999999995 -34.372943999999997
    115.000416999999999 -33.528360999999997
    115.697916999999990 -33.300860999999998
    115.882943999999995 -31.961693999999998
    115.052110999999996 -30.507527999999997
    114.867055999999991 -29.114193999999998
    113.152861000000001 -26.149193999999998
    113.837916999999990 -26.591666999999998
    113.509110999999990 -25.505416999999998
    113.722082999999998 -26.200028000000000
    113.870806000000002 -25.942083000000000
    114.231221999999988 -26.315888999999999
    113.396249999999995 -24.406693999999998
    113.990416999999994 -21.872527999999999
    114.330027999999999 -22.522138999999999
    114.645832999999996 -21.837916999999997
    116.804166999999993 -20.523778000000000
    117.377471999999997 -20.777082999999998
    119.092472000000001 -19.957916999999998
    121.113305999999994 -19.539611000000001
    122.369555999999989 -18.117500000000000
    122.172916999999998 -17.263332999999999
    122.922528000000000 -16.387944000000001
    123.566721999999999 -17.627082999999999
    123.569527999999991 -17.037555999999999
    123.930805999999990 -17.267917000000001
    123.971277999999998 -16.825832999999999
    123.504582999999997 -16.662499999999998
    123.557499999999990 -16.173749999999998
    124.400027999999992 -16.565443999999999
    124.976249999999993 -16.381722000000000
    124.391306000000000 -16.339221999999999
    124.750388999999998 -15.810889000000000
    124.494999999999990 -16.002972000000000
    124.360416999999998 -15.670027999999999
    124.675027999999998 -15.254582999999998
    125.249583000000001 -15.581666999999999
    124.829555999999997 -15.157471999999999
    125.506693999999996 -15.172056000000000
    125.137889000000001 -14.745832999999999
    125.614166999999995 -14.230471999999999
    125.918360999999990 -14.677083000000000
    126.009166999999991 -13.920389000000000
    126.230027999999990 -14.250416999999999
    126.535805999999994 -13.932082999999999
    126.612527999999998 -14.250416999999999
    126.874972000000000 -13.747138999999999
    127.428332999999995 -13.942943999999999
    128.227056000000005 -14.714193999999999
    128.009972000000005 -15.513750000000000
    128.128332999999998 -15.186249999999999
    128.372139000000004 -15.496694000000000
    128.199582999999990 -15.069222000000000
    128.559138999999988 -14.766278000000000
    129.092527999999987 -14.904610999999999
    129.125860999999986 -15.281277999999999
    129.289999999999992 -14.862083000000000
    129.605832999999990 -15.206249999999999
    129.998777999999987 -14.705860999999999
    129.365417000000008 -14.339971999999999
    129.816638999999981 -13.499582999999999
    130.317971999999997 -13.373332999999999
    130.351222000000007 -12.670028000000000
    130.732082999999989 -12.728332999999999
    130.575832999999989 -12.407110999999999
    130.964971999999989 -12.671277999999999
    130.812139000000002 -12.408332999999999
    131.287527999999980 -12.045444000000000
    131.462500000000006 -12.285444000000000
    132.762944000000005 -12.154582999999999
    132.722971999999999 -11.623332999999999
    131.767888999999997 -11.325832999999999
    131.973332999999997 -11.127110999999999
    133.508332999999993 -11.879583000000000
    133.915832999999992 -11.742082999999999
    134.150889000000006 -12.174583000000000
    134.748389000000003 -11.951250000000000
    135.215388999999988 -12.300860999999999
    135.912499999999994 -11.952916999999999
    135.652888999999988 -12.206666999999999
    136.044999999999987 -12.064610999999999
    136.016694000000001 -12.498778000000000
    136.564138999999983 -11.879610999999999
    136.977971999999994 -12.348333000000000
    136.462083000000007 -12.777500000000000
    136.461667000000006 -13.253777999999999
    135.909555999999981 -13.285000000000000
    136.072111000000007 -13.667527999999999
    135.411221999999981 -14.934972000000000
    136.676666999999981 -15.926305999999999
    139.036638999999980 -16.912917000000000
    139.598360999999983 -17.538778000000001
    140.609166999999985 -17.613806000000000
    141.667027999999988 -15.040861000000000
    141.461250000000007 -13.852528000000000
    141.976832999999999 -12.594778000000000
    141.586221999999992 -12.558361000000000
    142.079611000000000 -11.985861000000000
    142.130388999999980 -10.961694000000000
    142.534166999999997 -10.688722000000000
    143.545416999999986 -12.844166999999999
    143.772917000000007 -14.399194000000000
    144.515055999999987 -14.166250000000000
    145.347888999999981 -14.949193999999999
    145.402139000000005 -16.434999999999999
    145.957888999999994 -16.897527999999998
    146.260444000000007 -18.863388999999998
    148.772943999999995 -20.236694000000000
    149.630471999999997 -22.584999999999997
    149.812500000000000 -22.382110999999998
    150.060417000000001 -22.658360999999999
    150.041666999999990 -22.125416999999999
    150.635861000000006 -22.660443999999998
    150.668306000000001 -22.347082999999998
    150.791666999999990 -23.509611000000000
    151.769555999999994 -24.020861000000000
    153.192943999999983 -25.931694000000000
    153.024583000000007 -27.294193999999997
    153.639582999999988 -28.638361000000000
    153.065416999999997 -31.058388999999998
    152.359555999999998 -32.186667000000000
    152.542944000000006 -32.444221999999996
    151.201222000000001 -33.510832999999998
    150.602943999999979 -34.865832999999995
    150.842943999999989 -35.066693999999998
    150.152972000000005 -35.700972000000000
    149.979611000000006 -37.505055999999996
    147.657471999999984 -37.850443999999996
    147.454138999999998 -38.079611000000000
    147.972082999999998 -37.893360999999999
    146.230028000000004 -38.697082999999999
    ];

if flag == 0
    australia_pshape=polyshape(australia0_coord); return;
end


tasmania_coord=100*[
    1.459990830000000  -0.433303890000000
    1.460000000000000  -0.433303610000000
    1.452553890000000  -0.426241390000000
    1.451683060000000  -0.421962500000000
    1.455553890000000  -0.423575560000000
    1.447437500000000  -0.414216940000000
    1.446837220000000  -0.406683610000000
    1.466066940000000  -0.412604170000000
    1.480775560000000  -0.407704440000000
    1.483611940000000  -0.421975000000000
    1.482066390000000  -0.419504440000000
    1.480062780000000  -0.432308610000000
    1.471966670000000  -0.427279170000000
    1.468699720000000  -0.436404440000000
    1.459990830000000  -0.433303890000000];


australia0_pshape=polyshape(australia0_coord);
tasmania_pshape=polyshape(tasmania_coord);
australia_pshape=union(australia0_pshape,tasmania_pshape);