
function demo_driver

%--------------------------------------------------------------------------
% OBJECT:
% In this routine, we implement a driver so to easily try all the results
% obtained in the paper.
%--------------------------------------------------------------------------

example=4;


switch example
    case 1

        % Figure 2: The 380544 nodes of a rule of PI-type with ADE=8, on a
        % spherical polygon approximating South and North America, before
        % Caratheodory-Tchakaloff compression. The computation of this
        % formula requires about 10 seconds.

        % Figure 3: Triangulation of a spherical polygon (967 spherical
        % triangles) and quadrature rule of PI-type with ADE=8, 81 points,
        % after Caratheodory-Tchakaloff compression (magenta). The
        % compression cputime requires approximatively 3.5 seconds.

        fprintf(2,'\n \t * Figure 2-3: ADE 8 RULES OVER N-S.AMERICA \n');
        continent_parm=1; deg=8; doplot=1;

        for k=1:3 % Clean previous figures.
            h=figure(k); f1=ishandle(h)&&strcmp(get(h,'type'),'figure');
            if f1,clf(k);end
        end

        [Ntri,Nrule,NruleC,momerr,cpus]=demo_cub_continents(...
            continent_parm,deg,doplot);

        str='* NOTE: ROTATE FIGURES TO OBTAIN THOSE IN THE PAPER  ';
        fprintf('\n \t'); fprintf(2,str); fprintf('\n \n');


    case 2

        % Figure 4: Quadrature nodes of a formula of PI-type having ADE
        % equal to 10, on a coarse approximation of Australia using 169
        % points of S2. To this purpose, we determined a triangulation of
        % such a spherical polygon in 167 spherical triangles, obtained a
        % first rule of PI-type with 82413 nodes, and then a compressed
        % one with 121, with moments error of 5e-15. The determination of
        % the Caratheodory-Tchakaloff formula took about 6 seconds.

        fprintf(2,'\n \t * Figure 4: ADE 10 RULES OVER AUSTRALIA \n');
        continent_parm=3;
        deg=10;
        doplot=1;

        for k=1:3 % Clean previous figures.
            h=figure(k); f1=ishandle(h)&&strcmp(get(h,'type'),'figure');
            if f1,clf(k);end
        end

        [Ntri,Nrule,NruleC,momerr,cpus]=demo_cub_continents(...
            continent_parm,deg,doplot);

        str='* NOTE: ROTATE FIGURES TO OBTAIN THOSE IN THE PAPER  ';
        fprintf('\n \t'); fprintf(2,str); fprintf('\n \n');




    case 3

        fprintf(2,'\n \t * Figure 4: RELATIVE ERRORS OF RULES OVER AUSTRALIA \n');

        % continent_parm : parameter of the continent,
        %     1. South/North America, 2. Africa, 3 or 4. Australia.
        % deg            : Algebraic degree of exactness.
        % Ntest          : number of tests for experiment.

        fprintf(2,'\n \t * Table 1: RULES OVER AUSTRALIA \n');

        continent_parm=3;
        degV=1:4; degV=degV';
        Ntest=10;

        NruleV=[]; NruleCV=[];  cpusV=[]; cpus12V=[];


        for j=1:length(degV)

            % Make a single experiment many times and compute the median
            %  of the cputimes.
            deg=degV(j);
            for k=1:Ntest
                [Ntri,Nrule,NruleC,momerr,cpus]=demo_cub_continents(...
                    continent_parm,deg);
                cpusL(k)=sum(cpus);
                cpusL12(k)=sum(cpus(:,1:2));
            end

            % Collect data.
            NruleV=[NruleV; Nrule];
            NruleCV=[NruleCV; NruleC];
            cpusV=[cpusV; median(cpusL)];
            cpus12V=[cpus12V; median(cpusL12)];
        end

        fprintf('\n \t ....................... Summary .......................... \n \n ')

        T=table(degV,NruleV,NruleCV,NruleV./NruleCV,cpusV,...
            'VariableNames',...
            {'n','#basic','#comp','#Cratio','CPU:1-2-3'});
        disp(T);
        fprintf('\n \t');


    case 4

        % Figure 5: Quadrature relative errors, in semilogarithmic scale,
        % obtained by approximating IP(fk), for k = 1; 2; : : : ; 6, by
        % rules with ADE equal to 1; 2; : : : ; 16.

        domain_type=3;
        degV=1:16;
        function_typeV=1:6;

        [aeM,reM]=demo_cub_sphpgon0(domain_type,degV,function_typeV);

        T=table(degV(:),reM(:,1),reM(:,2),reM(:,3), reM(:,4),...
            reM(:,5),reM(:,6),...
            'VariableNames',...
            {'ADE','f1','f2','f3','f4','f5','f6'});
        disp(T);
        fprintf('\n \t');

        % plot figure
        colorsL={[0.10,0.70,0.51],[1.00,0.00,1.00],[1.00,0.00,0.00],...
            [0.00,1.00,0.00],[0.07,0.62,1.00],[0.00,1.00,1.00]};
        Markers = {'+','o','*','x','v','d','^','s','>','<'};
        for k=1:6
            semilogy(degV, reM(:,k),strcat('-',Markers{k}),...
                'color', colorsL{k},'MarkerEdgeColor','k',...
                'MarkerSize',4,'LineWidth',2);
            hold on;
        end
        legend('f1','f2','f3','f4','f5','f6')
        hold off;


end



%..........................................................................
%                         SOME PRECOMPUTED RESULTS
%..........................................................................





%..........................................................................................
% CASE 4:
%..........................................................................................
%
% ADE        f1            f2            f3            f4            f5            f6
% ___    __________    __________    __________    __________    __________    __________
%
% 1      0.0020176         8.8526    4.0966e-05    0.00048881    0.00099675       0.66058
% 2     0.00037688        0.84485    4.2283e-06    3.4561e-06    7.6551e-06      0.054325
% 3     2.2118e-05        0.90188    2.5538e-06    1.3375e-08    3.5613e-08      0.002482
% 4     1.4595e-06        0.62813    7.8042e-07    1.8668e-11    5.9048e-09    5.1191e-06
% 5     6.8131e-08        0.11887    1.2795e-08    8.7588e-15    8.5091e-11     1.715e-05
% 6     1.2916e-15       0.023661    4.5187e-10    4.6099e-16    3.7858e-12    2.0588e-05
% 7              0      0.0061235    1.1723e-11    1.5366e-16    1.5055e-13    1.6334e-05
% 8              0     0.00080711     1.272e-13    4.6099e-16    2.9116e-15    9.3004e-07
% 9     6.4579e-16      1.696e-05    2.5094e-15    4.6099e-16    1.7127e-16    4.1487e-06
% 10     9.2563e-15     1.707e-05    1.0508e-14    8.9125e-15    8.2211e-15    5.5548e-07
% 11       4.09e-15    1.2063e-06    4.3915e-15    3.8416e-15     3.768e-15    3.9787e-07
% 12     3.4442e-15    2.6564e-07    2.6663e-15     2.305e-15    2.3978e-15    2.7799e-07
% 13     1.0763e-15    1.4939e-08    9.4104e-16    7.6832e-16    5.1382e-16    1.3086e-07
% 14     6.4579e-16    1.2748e-09    6.2736e-16    1.2293e-15    1.3702e-15    1.4526e-07
% 15     4.7358e-15    3.6431e-10    5.9599e-15    4.1489e-15    2.9116e-15    5.3724e-08
% 16     5.1663e-15    2.3042e-12    6.1168e-15    4.9172e-15    4.6244e-15    4.6288e-08