function [thetaw,xw]=cubature_2_torus(x,n,r,fig)

%%%%%%%
% TORUS NOTES:
% Trying a first naive adaptation of the spherical routine
% Just changing the parametrizations and the surface element
%%%%%%%

% ORIGINAL COMMENTS:
% this program is optimized for caps in S^2
% for general S^d use cubature_d_sphere
%
% let use the (iper)spherical coordinate system over S^2 (in R^3)
%
% x_1=cos(phi)sin(theta)
% x_2=sin(phi)sin(theta)
% x_3=cos(theta)
%
% with phi in [0,2*pi] and theta in [0,pi]
%
% remember the volume element for these coordinates
% sin(theta) (formally abs(sin(theta)))
%
% input
% x = vector 2 x 2
% horizontally, x must denote the start point and the end point for each
% range [phi_s,phi_f], [theta_s,theta_f] (remember that the first
% one must be contained in [0,2*pi] and the other in [0,pi])
%
% n = degree of polinomially exactness of nodes and weights in output
%
% fig = 0,1
% if 1 it will show a figure of the points
%
% output
% thetaw = vector (n+2)*(n+1) x 3
% for each row it will denote the iperspherical coordinates of nodes
% and in the last column it will denote the weights for each node
%
% xw = vector (n+2)*(n+1) x 4
% for each row it will denote the cartesian coordinates of nodes
% in the last column it will denote the weights for each node
%
% if x represents a cap, we will have less number of nodes, that is
% if n is odd
% thetaw = vector (n+1)*(n+1)/2 x 3
% xw     = vector (n+1)*(n+1)/2 x 4
% if n is even
% thetaw = vector (n+1)*(n+2)/2-(n/2) x 3
% xw     = vector (n+1)*(n+2)/2-(n/2) x 4
%
% functions not usually lie in standard Matlab
%
% trigauss.m
% from Prof.Vianello web page from Padua University
% http://www.math.unipd.it/~marcov/CAAsoft.html
%
% trigauss_sph.m
%
% show_r3_point_set
% from Paul Leopardi
tic

% Note:
% x should (if I understand correctly) give the limits first in theta, then in phi
% with the notations used in the article

d=size(x,1);
if d~=2
    fprintf('Use cubature_d_torus\n')
else

% So, d is = 2 for the entire function... what's the point?

% Should add some input argument sanitation/test
% Torus dimensions
R = r(1);
r = r(2);

% BEGIN CUT
% Case of Caps - not applicable to tori

%if (x(1,2)-x(1,1)==2*pi) && (x(2,1)==0)
%    if mod(n,2)==1
%        yy=ones(d,n+1,2);
%        yy(1,1:n+1,:)=trigauss(n,x(1,1),x(1,2));
%        yy(2,1:n+1,:)=trigauss_cap(n,x(2,2));
%        % note that in the case of a cap we will consider the volume
%        % element directly in trigauss_sph, so we will not need to add it
%        [A,B]=meshgrid(yy(1,1:n+1,1),yy(2,1:((n+1)/2),1));
%        yys(:,1)=A(:);
%        yys(:,2)=B(:);
%        [C,D]=meshgrid(yy(1,1:n+1,2),yy(2,1:((n+1)/2),2));
%        yys(:,3)=C(:).*D(:);
%    end
%    if mod(n,2)==0
%        yy=ones(d,n+2,2);
%        % we will need even number of nodes in [0,2*pi]
%        % to have a central simmetry
%        yy(1,1:n+2,:)=trigauss(n+1,x(1,1),x(1,2));
%        yy(2,1:n+1,:)=trigauss_cap(n,x(2,2));
%        % note that in the case of a cap we will consider the volume
%        % element directly in trigauss_sph, so we will not need to add it
%        [A,B]=meshgrid(yy(1,1:n+2,1),yy(2,1:floor((n+1)/2),1));
%        yys(:,1)=A(:);
%        yys(:,2)=B(:);
%        [C,D]=meshgrid(yy(1,1:n+2,2),yy(2,1:floor((n+1)/2),2));
%        yys(:,3)=C(:).*D(:);
%        % manually add the North Pole
%        yys(end+1,2)=0; yys(end,3)=yy(2,floor((n+1)/2)+1,2)*pi;
%    end
%    thetaw=yys;
%else
% END CUT

yy=ones(d,n+2,2);

% Here we are calculating 1-dim angles and weights via trigonometric gaussian formulas
% This is why yy is a ""depth-2"" matrix; in 1st component angles, in 2nd weights
% Also, note the different exanctness degree
% I think this sould remain exactly the same, btw
yy(1,1:n+1,:)=trigauss(n,x(1,1),x(1,2));
yy(2,1:n+2,:)=trigauss(n+1,x(2,1),x(2,2));

% Meshgrid only of the angles
[A,B]=meshgrid(yy(1,1:n+1,1),yy(2,1:n+2,1));

%Meshgrid put into a single ""depth-2"" matrix
yys(:,1)=A(:);
yys(:,2)=B(:);

% Meshgrid of the weights
[C,D]=meshgrid(yy(1,1:n+1,2),yy(2,1:n+2,2));
% Note the volume element in the weights... do I have to keep it?
% Note also that yys is now "depth-3". It has the angles in depth 1 and 2, and weights in depth3
element = r*(R+ r*cos(yys(:,1)));
yys(:,3)=C(:).*D(:).*element;

thetaw=yys;
%This was for the if above
%end

% convert all points in cartesian coordinates
% Original (spherical coords)
% x_1=cos(phi)sin(theta)
% x_2=sin(phi)sin(theta)
% x_3=cos(theta)
% Toroidal coords:
% x_1=(R + r cos(theta))cos(phi)
% x_2=(R + r cos(theta))sin(phi)
% x_3=sin(theta)
% So assuming theta is thetaw(:,1) and phi is thetaw(:,2) we should have...
%xw=ones(size(thetaw,1),d+2);
%xw(:,d+2)=thetaw(:,d+1);
%xw(:,1)=cos(thetaw(:,1));
%xw(:,2)=sin(thetaw(:,1));
%xw(:,1)=xw(:,1).*sin(thetaw(:,2));
%xw(:,2)=xw(:,2).*sin(thetaw(:,2));
%xw(:,d+1)=cos(thetaw(:,d));

xw=ones(size(thetaw,1),d+2);
%So, xw(4), I don't think it's even used... meh
xw(:,d+2)=thetaw(:,d+1);
% xw(:,1:2) should be x and y
xw(:,1)=cos(thetaw(:,1));
xw(:,2)=sin(thetaw(:,1));
% Multiplying for (R + rcos(theta))
xw(:,1)=xw(:,1).*(R + r*cos(thetaw(:,2)));
xw(:,2)=xw(:,2).*(R + r*cos(thetaw(:,2)));
% xw(:,3) aka z
xw(:,d+1)=r*sin(thetaw(:,1));

% figures

if size(x,1)==2
if fig==1
show_r3_point_set(xw(:,1:3)',x);
%material([0.3 0.7 0.2]) %sets the ambient/diffuse/specular strength of the objects.
% LIGHTANGLE(183,22)
% LIGHTANGLE(125,28)
end
end

end
toc
