% First test for cubature rule
% Testing polynomial exactness for small degrees, 
% And whether increasing degree of precision 
% Gives worse results

%FIRST TEST

% Region: [0,pi]x[0,pi]
% "Standard" torus with radii 2,1

format long;

x = [0,pi;0,pi];
n = [2,5,10];
R = [2,1];

flag = 0;

% Test function f(x,y,z) = x^2
% x = (2 + cos(t))cos(p)

for i=1:length(n)
	ni = n(i);
	[tw,xw] = cubature_2_torus(x,ni,R,0);	

	% Wolfram alpha result
	wa = 54.2828;

	%Cubature result
	xc = xw(:,1);
	t = tw(:,1);
	p = tw(:,2);
	w = tw(:,3);
	summands = (2+cos(t)).^2.*cos(p).^2.*w;
	sum(summands);

	if ((wa - sum(summands)) > 10^(-4))
		disp('Test1: Approximation not good')
		ni
		flag = 1;
	end
end

if (flag == 0)
	disp('Test1: Succeeded')
end

%SECOND TEST

% Region: [pi/6,pi/4]x[pi/3,pi/2]
% "Standard" torus with radii 2,1

format long;

x = [pi/6,pi/4;pi/3,pi/2];
n = [2,5,10];
R = [2,1];

flag = 0;

% Test function f(x,y,z) = xyz
% x = (2 + cos(t))cos(p)
% y = (2 + cos(t))sin(p)
% z = sin(t)

for i=1:length(n)
	ni = n(i);
	[tw,xw] = cubature_2_torus(x,ni,R,0);	

	% Wolfram alpha result
	wa = 0.430176;

	%Cubature result
	xc = xw(:,1);
	t = tw(:,1);
	p = tw(:,2);
	w = tw(:,3);
	summands = (2+cos(t)).^2.*cos(p).*sin(p).*sin(t).*w;
	sum(summands);

	if ((wa - sum(summands)) > 10^(-4))
		disp('Test2: Approximation not good')
		ni
		flag = 1;
	end
end

if (flag == 0)
	disp('Test2: Succeeded')
end


