function [bool] = test_polinomial_exactness(region,poli)
% First test for cubature rule
% Testing polynomial exactness for small degrees, 
% And whether increasing degree of precision 
% Gives worse results

% "Standard" torus with radii 2,1

format long;

deg = sum(poli);
n = [max(ceil(deg/2),2),deg+1,deg*2];
R = [2,1];

flag = 0;

% Sympy result
command = sprintf('python symb_test.py %d %d %d %f %f %f %f',poli(1),poli(2),poli(3),region(1,1),region(1,2),region(2,1),region(2,2));
[ret,wa] = system(command);
disp(wa)

% Cubature formula result
for i=1:length(n)
	disp('Degree of exactness:');
	ni = n(i)
	[tw,xw] = cubature_2_torus(region,ni,R,0);

	%Cubature result
	xc = xw(:,1);
	t = tw(:,1);
	p = tw(:,2);
	w = tw(:,3);
	
	x = (2+cos(t)).*cos(p);
	y = (2+cos(t)).*sin(p);
	z = sin(t);
	summands = x.^(poli(1)).*y.^(poli(2)).*z.^(poli(3)).*w;
	disp('Result:');
	sum(summands)

	if ((wa - sum(summands)) > 10^(-4))
		disp('Test1: Approximation not good at degree')
		ni
		flag = 1;
	end
end

if (flag == 0)
	disp('Test1: Succeeded')
end

bool = flag

end
