/*
 * Decompiled with CFR 0.152.
 */
package it.unipd.chess.chessmlprofile.Dependability.FailurePropagation.FailurePropagationDataTypes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FailureType implements Enumerator
{
    LATE(0, "late", "late"),
    EARLY(1, "early", "early"),
    VALUE_SUBTLE(2, "valueSubtle", "valueSubtle"),
    VALUE_COARSE(3, "valueCoarse", "valueCoarse"),
    OMISSION(4, "omission", "omission"),
    COMMISSION(5, "commission", "commission"),
    NO_FAILURE(6, "noFailure", "noFailure"),
    VARIABLE(7, "variable", "variable"),
    WILDCARD(8, "wildcard", "wildcard");

    public static final int LATE_VALUE = 0;
    public static final int EARLY_VALUE = 1;
    public static final int VALUE_SUBTLE_VALUE = 2;
    public static final int VALUE_COARSE_VALUE = 3;
    public static final int OMISSION_VALUE = 4;
    public static final int COMMISSION_VALUE = 5;
    public static final int NO_FAILURE_VALUE = 6;
    public static final int VARIABLE_VALUE = 7;
    public static final int WILDCARD_VALUE = 8;
    private static final FailureType[] VALUES_ARRAY;
    public static final List<FailureType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FailureType[]{LATE, EARLY, VALUE_SUBTLE, VALUE_COARSE, OMISSION, COMMISSION, NO_FAILURE, VARIABLE, WILDCARD};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FailureType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FailureType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FailureType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FailureType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FailureType get(int value) {
        switch (value) {
            case 0: {
                return LATE;
            }
            case 1: {
                return EARLY;
            }
            case 2: {
                return VALUE_SUBTLE;
            }
            case 3: {
                return VALUE_COARSE;
            }
            case 4: {
                return OMISSION;
            }
            case 5: {
                return COMMISSION;
            }
            case 6: {
                return NO_FAILURE;
            }
            case 7: {
                return VARIABLE;
            }
            case 8: {
                return WILDCARD;
            }
        }
        return null;
    }

    private FailureType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

