/*
 * Decompiled with CFR 0.152.
 */
package it.unipd.chess.chessmlprofile.Dependability.StateBased.StateBasedDataTypes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ConfidenceKind implements Enumerator
{
    RELATIVE(0, "relative", "relative"),
    ABSOLUTE(1, "absolute", "absolute");

    public static final int RELATIVE_VALUE = 0;
    public static final int ABSOLUTE_VALUE = 1;
    private static final ConfidenceKind[] VALUES_ARRAY;
    public static final List<ConfidenceKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ConfidenceKind[]{RELATIVE, ABSOLUTE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ConfidenceKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConfidenceKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConfidenceKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConfidenceKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConfidenceKind get(int value) {
        switch (value) {
            case 0: {
                return RELATIVE;
            }
            case 1: {
                return ABSOLUTE;
            }
        }
        return null;
    }

    private ConfidenceKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

