/*
 * Decompiled with CFR 0.152.
 */
package it.unipd.chess.chessmlprofile.Predictability.DeploymentConfiguration.DeploymentConfAnalysis;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OptimizationGoal implements Enumerator
{
    AVERAGE(0, "average", "average"),
    MAX_HIGH_PERF_USAGE(1, "maxHighPerfUsage", "maxHighPerfUsage");

    public static final int AVERAGE_VALUE = 0;
    public static final int MAX_HIGH_PERF_USAGE_VALUE = 1;
    private static final OptimizationGoal[] VALUES_ARRAY;
    public static final List<OptimizationGoal> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OptimizationGoal[]{AVERAGE, MAX_HIGH_PERF_USAGE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OptimizationGoal get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OptimizationGoal result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OptimizationGoal getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OptimizationGoal result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OptimizationGoal get(int value) {
        switch (value) {
            case 0: {
                return AVERAGE;
            }
            case 1: {
                return MAX_HIGH_PERF_USAGE;
            }
        }
        return null;
    }

    private OptimizationGoal(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

