/*
 * Decompiled with CFR 0.152.
 */
package it.unipd.chess.chessmlprofile.Predictability.DeploymentConfiguration.HardwareBaseline;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BasicOperation implements Enumerator
{
    ADD(0, "add", "add"),
    MUL(1, "mul", "mul"),
    DIV(2, "div", "div"),
    MOD(3, "mod", "mod"),
    SHIFT(4, "shift", "shift");

    public static final int ADD_VALUE = 0;
    public static final int MUL_VALUE = 1;
    public static final int DIV_VALUE = 2;
    public static final int MOD_VALUE = 3;
    public static final int SHIFT_VALUE = 4;
    private static final BasicOperation[] VALUES_ARRAY;
    public static final List<BasicOperation> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BasicOperation[]{ADD, MUL, DIV, MOD, SHIFT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BasicOperation get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BasicOperation result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BasicOperation getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BasicOperation result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BasicOperation get(int value) {
        switch (value) {
            case 0: {
                return ADD;
            }
            case 1: {
                return MUL;
            }
            case 2: {
                return DIV;
            }
            case 3: {
                return MOD;
            }
            case 4: {
                return SHIFT;
            }
        }
        return null;
    }

    private BasicOperation(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

