/*
 * Decompiled with CFR 0.152.
 */
package it.unipd.chess.codegen;

import it.unipd.chess.codegen.main.GenerateInfrastructure;
import it.unipd.chess.util.CHESSProjectSupport;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.acceleo.engine.utils.AcceleoLaunchingUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.Bundle;

public class AcceleoCodeGen {
    private URI modelURI;
    private IContainer targetFolder;
    List<? extends Object> arguments;

    public AcceleoCodeGen(URI modelURI, IContainer targetFolder, List<? extends Object> arguments) {
        this.modelURI = modelURI;
        this.targetFolder = targetFolder;
        this.arguments = arguments;
    }

    public void doGenerate(IProgressMonitor monitor) throws IOException {
        if (!this.targetFolder.getLocation().toFile().exists()) {
            this.targetFolder.getLocation().toFile().mkdirs();
        }
        monitor.subTask("Loading...");
        GenerateInfrastructure gen1 = new GenerateInfrastructure(this.modelURI, this.targetFolder.getLocation().toFile(), this.arguments);
        monitor.worked(1);
        String generationID = AcceleoLaunchingUtil.computeUIProjectID((String)"it.unipd.chess.codegen", (String)GenerateInfrastructure.class.getName(), (String)this.modelURI.toString(), (String)this.targetFolder.getFullPath().toString(), new ArrayList());
        gen1.setGenerationID(generationID);
        gen1.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
    }

    private URI getTemplateURI(String bundleID, IPath relativePath) throws IOException {
        Enumeration entries;
        Bundle bundle = Platform.getBundle((String)bundleID);
        if (bundle == null) {
            return URI.createPlatformResourceURI((String)new Path(bundleID).append(relativePath).toString(), (boolean)false);
        }
        URL url = bundle.getEntry(relativePath.toString());
        if (url == null && relativePath.segmentCount() > 1 && (entries = bundle.findEntries("/", "*.emtl", true)) != null) {
            String[] segmentsRelativePath = relativePath.segments();
            while (url == null && entries.hasMoreElements()) {
                String[] segmentsPath;
                URL entry = (URL)entries.nextElement();
                Path path = new Path(entry.getPath());
                if (path.segmentCount() > relativePath.segmentCount()) {
                    path = path.removeFirstSegments(path.segmentCount() - relativePath.segmentCount());
                }
                boolean equals = (segmentsPath = path.segments()).length == segmentsRelativePath.length;
                int i = 0;
                while (equals && i < segmentsPath.length) {
                    equals = segmentsPath[i].equals(segmentsRelativePath[i]);
                    ++i;
                }
                if (!equals) continue;
                url = bundle.getEntry(entry.getPath());
            }
        }
        URI result = url != null ? URI.createPlatformPluginURI((String)new Path(bundleID).append((IPath)new Path(url.getPath())).toString(), (boolean)false) : URI.createPlatformResourceURI((String)new Path(bundleID).append(relativePath).toString(), (boolean)false);
        return result;
    }

    public static void runCodegen(IFile model, IContainer target, IProgressMonitor monitor) throws Exception {
        URI modelURI = URI.createPlatformResourceURI((String)model.getFullPath().toString(), (boolean)true);
        AcceleoCodeGen generator = new AcceleoCodeGen(modelURI, target, new ArrayList());
        CHESSProjectSupport.printlnToCHESSConsole((String)"*** CHESS Ada infrastructural code generation   ***");
        generator.doGenerate(monitor);
        CHESSProjectSupport.printlnToCHESSConsole((String)"*** End of CHESS Ada infrastructural code generation   ***");
    }
}

