/*
 * Decompiled with CFR 0.152.
 */
package it.unipd.chess.codegen;

import it.unipd.chess.codegen.Transformations;
import it.unipd.chess.editor.CHESSEditor;
import it.unipd.chess.util.CHESSProjectSupport;
import it.unipd.chess.util.uml.ResourceUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;

public class AdaGenUIHandler
extends AbstractHandler {
    private IProject getActiveProject(IEditorPart editor) {
        IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
        IFile file = input.getFile();
        return file.getProject();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        Job job = new Job("Transforming"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        AdaGenUIHandler.this.execute_(editor, monitor);
                    }
                    finally {
                        AdaGenUIHandler.this.getActiveProject(editor).refreshLocal(2, monitor);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    CHESSProjectSupport.printlnToCHESSConsole((String)sw.toString());
                    return new Status(4, "it.unipd.chess.m2m", 1, "Error in transformation " + e.getMessage(), null);
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    CHESSProjectSupport.printlnToCHESSConsole((String)"Job completed successfully");
                } else {
                    CHESSProjectSupport.printlnToCHESSConsole((String)"Job did not complete successfully");
                }
            }
        });
        job.setUser(true);
        job.setPriority(20);
        job.schedule();
        return null;
    }

    public Object execute_(IEditorPart editor, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Transforming", 4);
        if (!(editor instanceof CHESSEditor)) {
            return null;
        }
        CHESSEditor cEditor = (CHESSEditor)editor;
        Resource inResource = null;
        try {
            inResource = ResourceUtils.getUMLResource((ServicesRegistry)cEditor.getServicesRegistry());
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw new Exception("Unable to load the model");
        }
        IFile inputFile = CHESSProjectSupport.resourceToFile((Resource)inResource);
        Transformations.performCodeGeneration((CHESSEditor)editor, inputFile, monitor);
        return null;
    }
}

