/*
 * Decompiled with CFR 0.152.
 */
package it.unipd.chess.codegen.service;

import it.unipd.chess.chessmlprofile.ComponentModel.ComponentImplementation;
import it.unipd.chess.chessmlprofile.Dependability.MitigationMeans.TransmissionWithProtocol;
import it.unipd.chess.chessmlprofile.Predictability.RTComponentModel.CHRtPortSlot;
import it.unipd.chess.chessmlprofile.Predictability.RTComponentModel.CHRtSpecification;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM.ClientServerKind;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM.ClientServerPort;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.HLAM.CallConcurrencyKind;
import org.eclipse.papyrus.MARTE.MARTE_Foundations.Alloc.Assign;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityFinalNode;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.ControlFlow;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InitialNode;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public class UML2Service {
    private static final String DOCSTEREO = "Papyrus::Documentation::Documentation";
    private static final String REQUIREMENT_EXTENSION = "requirement";
    private static final Object LINK = "#Link_to";

    public Interface getProvidedInterface(Port port, String stName) {
        Stereotype clSvPortSt = port.getAppliedStereotype(stName);
        ClientServerPort clSvPort = (ClientServerPort)port.getStereotypeApplication(clSvPortSt);
        return (Interface)clSvPort.getProvInterface().get(0);
    }

    public Interface getRequiredInterface(Port port, String stName) {
        Stereotype clSvPortSt = port.getAppliedStereotype(stName);
        ClientServerPort clSvPort = (ClientServerPort)port.getStereotypeApplication(clSvPortSt);
        return (Interface)clSvPort.getReqInterface().get(0);
    }

    public Boolean isProvidedPort(Port pt, String stName) {
        Stereotype st = pt.getAppliedStereotype(stName);
        ClientServerPort csp = (ClientServerPort)pt.getStereotypeApplication(st);
        if (csp != null) {
            return csp.getKind().equals((Object)ClientServerKind.PROVIDED);
        }
        return false;
    }

    public Boolean isRequiredPort(Port pt, String stName) {
        Stereotype st = pt.getAppliedStereotype(stName);
        ClientServerPort csp = (ClientServerPort)pt.getStereotypeApplication(st);
        if (csp != null) {
            return csp.getKind().equals((Object)ClientServerKind.REQUIRED);
        }
        return false;
    }

    public List<Interface> getProvidedInterfaceList(List<Port> portList, String stName) {
        ArrayList<Interface> intList = new ArrayList<Interface>();
        Port pt = null;
        Stereotype st = null;
        ClientServerPort csp = null;
        int i = 0;
        while (i < portList.size()) {
            pt = portList.get(i);
            csp = (ClientServerPort)pt.getStereotypeApplication(st = pt.getAppliedStereotype(stName));
            if (csp != null && csp.getKind().equals((Object)ClientServerKind.PROVIDED)) {
                intList.add((Interface)csp.getProvInterface().get(0));
            }
            ++i;
        }
        return intList;
    }

    public String getProvidedInterfaceListAsQualifiedString(List<Port> portList, String stName) {
        Port pt = null;
        Stereotype st = null;
        ClientServerPort csp = null;
        String piNameList = new String();
        String interfaceName = null;
        boolean firstWritten = false;
        int i = 0;
        while (i < portList.size()) {
            pt = portList.get(i);
            csp = (ClientServerPort)pt.getStereotypeApplication(st = pt.getAppliedStereotype(stName));
            if (csp != null && csp.getKind().equals((Object)ClientServerKind.PROVIDED)) {
                interfaceName = ((Interface)csp.getProvInterface().get(0)).getName();
                if (!firstWritten) {
                    piNameList = String.valueOf(piNameList) + interfaceName + "." + interfaceName;
                    firstWritten = true;
                } else {
                    piNameList = String.valueOf(piNameList) + " and " + interfaceName + "." + interfaceName;
                }
            }
            ++i;
        }
        return piNameList;
    }

    public Boolean hasRequiredInterface(List<Port> portList, String stName) {
        Port pt = null;
        Stereotype st = null;
        ClientServerPort csp = null;
        int i = 0;
        while (i < portList.size()) {
            pt = portList.get(i);
            csp = (ClientServerPort)pt.getStereotypeApplication(st = pt.getAppliedStereotype(stName));
            if (csp != null && csp.getKind().equals((Object)ClientServerKind.REQUIRED)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public List<Interface> getRequiredInterfaceList(List<Port> portList, String stName) {
        ArrayList<Interface> intList = new ArrayList<Interface>();
        Port pt = null;
        Stereotype st = null;
        ClientServerPort csp = null;
        int i = 0;
        while (i < portList.size()) {
            pt = portList.get(i);
            csp = (ClientServerPort)pt.getStereotypeApplication(st = pt.getAppliedStereotype(stName));
            if (csp != null && csp.getKind().equals((Object)ClientServerKind.REQUIRED)) {
                intList.add((Interface)csp.getReqInterface().get(0));
            }
            ++i;
        }
        return intList;
    }

    public String getOperationSignature(Component c, Operation op) {
        String opName = new String(String.valueOf(c.getName()) + "." + op.getName());
        EList lParam = op.getOwnedParameters();
        if (lParam.size() > 0) {
            opName = String.valueOf(opName) + "(";
            opName = String.valueOf(opName) + ((Parameter)lParam.get(0)).getType().getName();
            if (lParam.size() > 1) {
                int i = 1;
                while (i < lParam.size()) {
                    opName = String.valueOf(opName) + ", " + ((Parameter)lParam.get(i)).getType().getName();
                    ++i;
                }
            }
            opName = String.valueOf(opName) + ")";
        }
        return opName;
    }

    public List<String> getPackageToWithSpec(List<Object> slotList, String stName, String st2Name) {
        boolean cyclicRequired = false;
        boolean sporadicRequired = false;
        boolean pkgSystemAdded = false;
        boolean pkgRealTimeAdded = false;
        boolean pkgDataStructureAdded = false;
        boolean pkgContainerProtectionAdded = false;
        boolean pkgCyclicTaskAdded = false;
        Slot slot = null;
        CHRtPortSlot chrtPs = null;
        CHRtSpecification chrtSpec = null;
        EList chRtSpecList = null;
        ArrayList<String> withPackageList = new ArrayList<String>();
        int i = 0;
        while (i < slotList.size()) {
            slot = (Slot)slotList.get(i);
            EList stList = slot.getAppliedStereotypes();
            if (!stList.isEmpty()) {
                chrtPs = (CHRtPortSlot)slot.getStereotypeApplication((Stereotype)stList.get(0));
                chRtSpecList = chrtPs.getCH_RtSpecification();
                int j = 0;
                while (j < chRtSpecList.size()) {
                    chrtSpec = (CHRtSpecification)chRtSpecList.get(j);
                    String occKind = chrtSpec.getOccKind();
                    if (occKind != null && !occKind.equals("")) {
                        if (occKind.startsWith("periodic") && !cyclicRequired) {
                            if (!pkgRealTimeAdded) {
                                withPackageList.add("with Ada.Real_Time; use Ada.Real_Time;");
                                pkgRealTimeAdded = true;
                            }
                            if (!pkgDataStructureAdded) {
                                withPackageList.add("with Data_Structure;");
                                pkgDataStructureAdded = true;
                            }
                            if (!pkgContainerProtectionAdded) {
                                withPackageList.add("with Container_Protection; use Container_Protection;");
                                pkgContainerProtectionAdded = true;
                            }
                            if (!pkgCyclicTaskAdded) {
                                withPackageList.add("with Cyclic_Task;");
                                pkgCyclicTaskAdded = true;
                            }
                            cyclicRequired = true;
                        } else if (occKind.startsWith("sporadic") && !sporadicRequired) {
                            if (!pkgSystemAdded) {
                                withPackageList.add("with System;");
                                pkgSystemAdded = true;
                            }
                            if (!pkgRealTimeAdded) {
                                withPackageList.add("with Ada.Real_Time; use Ada.Real_Time;");
                                pkgRealTimeAdded = true;
                            }
                            if (!pkgDataStructureAdded) {
                                withPackageList.add("with Data_Structure;");
                                pkgDataStructureAdded = true;
                            }
                            sporadicRequired = true;
                        }
                    } else if (chrtSpec.getProtection().equals((Object)CallConcurrencyKind.GUARDED) && !pkgSystemAdded) {
                        withPackageList.add("with System;");
                        pkgSystemAdded = true;
                    }
                    ++j;
                }
                if (cyclicRequired && sporadicRequired) break;
            }
            ++i;
        }
        return withPackageList;
    }

    public String getValue(String inputVSL) {
        int endOfValueIndex = inputVSL.indexOf(",unit");
        int startOfValueIndex = inputVSL.indexOf("value=") + 6;
        return inputVSL.substring(startOfValueIndex, endOfValueIndex);
    }

    public String getUnit(String inputVSL) {
        int startOfUnitIndex = inputVSL.indexOf("unit=") + 5;
        int endOfUnitIndex = inputVSL.indexOf("))");
        return inputVSL.substring(startOfUnitIndex, endOfUnitIndex);
    }

    public String getPriority(List<Object> slotList, Operation op, String stName) {
        Slot slot = null;
        int i = 0;
        while (i < slotList.size()) {
            slot = (Slot)slotList.get(i);
            CHRtPortSlot chrtPs = null;
            EList stList = slot.getAppliedStereotypes();
            if (!stList.isEmpty()) {
                chrtPs = (CHRtPortSlot)slot.getStereotypeApplication((Stereotype)stList.get(0));
                EList CHRtSpecList = chrtPs.getCH_RtSpecification();
                int j = 0;
                while (j < CHRtSpecList.size()) {
                    if (((CHRtSpecification)CHRtSpecList.get(j)).getContext().equals(op)) {
                        return ((CHRtSpecification)CHRtSpecList.get(j)).getRelativePriority();
                    }
                    ++j;
                }
            }
            ++i;
        }
        return "ERROR_PRIORITY_NOT_FOUND";
    }

    public String getPeriodOrMIAT(List<Object> slotList, Operation op, String stName) {
        Slot slot = null;
        int i = 0;
        while (i < slotList.size()) {
            slot = (Slot)slotList.get(i);
            CHRtPortSlot chrtPs = null;
            EList stList = slot.getAppliedStereotypes();
            if (!stList.isEmpty()) {
                chrtPs = (CHRtPortSlot)slot.getStereotypeApplication((Stereotype)stList.get(0));
                EList CHRtSpecList = chrtPs.getCH_RtSpecification();
                int j = 0;
                while (j < CHRtSpecList.size()) {
                    if (((CHRtSpecification)CHRtSpecList.get(j)).getContext().equals(op)) {
                        String occKind = ((CHRtSpecification)chrtPs.getCH_RtSpecification().get(0)).getOccKind();
                        String periodOrMIAT = this.getValue(occKind);
                        if (periodOrMIAT.length() <= 5) {
                            return periodOrMIAT.substring(0, periodOrMIAT.length() - 2);
                        }
                        return periodOrMIAT.substring(0, periodOrMIAT.length() - 5).concat("_").concat(periodOrMIAT.substring(periodOrMIAT.length() - 5, periodOrMIAT.length() - 2));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return "ERROR_PERIOD_OR_MIAT_NOT_FOUND";
    }

    public String getCeiling(List<Object> slotList, Operation op, String stName) {
        Slot slot = null;
        int i = 0;
        while (i < slotList.size()) {
            slot = (Slot)slotList.get(i);
            CHRtPortSlot chrtPs = null;
            EList stList = slot.getAppliedStereotypes();
            if (!stList.isEmpty()) {
                chrtPs = (CHRtPortSlot)slot.getStereotypeApplication((Stereotype)stList.get(0));
                EList CHRtSpecList = chrtPs.getCH_RtSpecification();
                int j = 0;
                while (j < CHRtSpecList.size()) {
                    if (((CHRtSpecification)CHRtSpecList.get(j)).getContext().equals(op)) {
                        return ((CHRtSpecification)chrtPs.getCH_RtSpecification().get(0)).getCeiling();
                    }
                    ++j;
                }
            }
            ++i;
        }
        return "ERROR_CEILING_NOT_FOUND";
    }

    public List<Operation> getCyclicOperationList(List<Slot> slotList, String stName) {
        ArrayList<Operation> cyclicOpList = new ArrayList<Operation>();
        CHRtPortSlot chrtPs = null;
        Slot slot = null;
        int i = 0;
        while (i < slotList.size()) {
            slot = slotList.get(i);
            EList stList = slot.getAppliedStereotypes();
            if (!stList.isEmpty()) {
                chrtPs = (CHRtPortSlot)slot.getStereotypeApplication((Stereotype)stList.get(0));
                EList CHRtSpecList = chrtPs.getCH_RtSpecification();
                int j = 0;
                while (j < CHRtSpecList.size()) {
                    String occKind = ((CHRtSpecification)chrtPs.getCH_RtSpecification().get(j)).getOccKind();
                    if (occKind != null && occKind.startsWith("periodic")) {
                        cyclicOpList.add((Operation)((CHRtSpecification)CHRtSpecList.get(j)).getContext());
                    }
                    ++j;
                }
            }
            ++i;
        }
        return cyclicOpList;
    }

    public List<Operation> getSporadicOperationList(List<Slot> slotList, String stName) {
        ArrayList<Operation> sporadicOpList = new ArrayList<Operation>();
        CHRtPortSlot chrtPs = null;
        Slot slot = null;
        int i = 0;
        while (i < slotList.size()) {
            slot = slotList.get(i);
            EList stList = slot.getAppliedStereotypes();
            if (!stList.isEmpty()) {
                chrtPs = (CHRtPortSlot)slot.getStereotypeApplication((Stereotype)stList.get(0));
                EList CHRtSpecList = chrtPs.getCH_RtSpecification();
                int j = 0;
                while (j < CHRtSpecList.size()) {
                    String occKind = ((CHRtSpecification)chrtPs.getCH_RtSpecification().get(j)).getOccKind();
                    if (occKind != null && occKind.startsWith("sporadic")) {
                        sporadicOpList.add((Operation)((CHRtSpecification)CHRtSpecList.get(j)).getContext());
                    }
                    ++j;
                }
            }
            ++i;
        }
        return sporadicOpList;
    }

    public List<Operation> getProtectedOperationList(List<Slot> slotList, String stName) {
        ArrayList<Operation> protectedOpList = new ArrayList<Operation>();
        CHRtPortSlot chrtPs = null;
        Slot slot = null;
        int i = 0;
        while (i < slotList.size()) {
            slot = slotList.get(i);
            EList stList = slot.getAppliedStereotypes();
            if (!stList.isEmpty()) {
                chrtPs = (CHRtPortSlot)slot.getStereotypeApplication((Stereotype)stList.get(0));
                EList CHRtSpecList = chrtPs.getCH_RtSpecification();
                int j = 0;
                while (j < CHRtSpecList.size()) {
                    String occKind = ((CHRtSpecification)chrtPs.getCH_RtSpecification().get(j)).getOccKind();
                    if (((CHRtSpecification)CHRtSpecList.get(j)).getProtection().equals((Object)CallConcurrencyKind.GUARDED) && occKind == null) {
                        protectedOpList.add((Operation)((CHRtSpecification)CHRtSpecList.get(j)).getContext());
                    }
                    ++j;
                }
            }
            ++i;
        }
        return protectedOpList;
    }

    public List<Operation> getSlotProtectedOperation(Slot sl, String stName) {
        ArrayList<Operation> protectedOpList = new ArrayList<Operation>();
        CHRtPortSlot chrtPs = null;
        EList stList = sl.getAppliedStereotypes();
        if (!stList.isEmpty()) {
            chrtPs = (CHRtPortSlot)sl.getStereotypeApplication((Stereotype)stList.get(0));
            EList CHRtSpecList = chrtPs.getCH_RtSpecification();
            int j = 0;
            while (j < CHRtSpecList.size()) {
                String occKind = ((CHRtSpecification)chrtPs.getCH_RtSpecification().get(j)).getOccKind();
                if (((CHRtSpecification)CHRtSpecList.get(j)).getProtection().equals((Object)CallConcurrencyKind.GUARDED) && occKind == null) {
                    protectedOpList.add((Operation)((CHRtSpecification)CHRtSpecList.get(j)).getContext());
                }
                ++j;
            }
        }
        return protectedOpList;
    }

    public List<Operation> getUnprotectedOperationList(List<Slot> slotList, String stName) {
        ArrayList<Operation> unprotectedOpList = new ArrayList<Operation>();
        CHRtPortSlot chrtPs = null;
        Slot slot = null;
        int i = 0;
        while (i < slotList.size()) {
            slot = slotList.get(i);
            EList stList = slot.getAppliedStereotypes();
            if (!stList.isEmpty()) {
                chrtPs = (CHRtPortSlot)slot.getStereotypeApplication((Stereotype)stList.get(0));
                EList CHRtSpecList = chrtPs.getCH_RtSpecification();
                int j = 0;
                while (j < CHRtSpecList.size()) {
                    String occKind = ((CHRtSpecification)chrtPs.getCH_RtSpecification().get(j)).getOccKind();
                    if (((CHRtSpecification)CHRtSpecList.get(j)).getProtection().equals((Object)CallConcurrencyKind.CONCURRENT) && occKind == null) {
                        unprotectedOpList.add((Operation)((CHRtSpecification)CHRtSpecList.get(j)).getContext());
                    }
                    ++j;
                }
            }
            ++i;
        }
        return unprotectedOpList;
    }

    public List<InstanceSpecification> getComponentInstanceList(List<InstanceSpecification> instList, String stName) {
        ArrayList<InstanceSpecification> componentInstanceList = new ArrayList<InstanceSpecification>();
        int i = 0;
        while (i < instList.size()) {
            Stereotype st;
            EList clList = instList.get(i).getClassifiers();
            if (clList.size() > 0 && (st = ((Classifier)clList.get(0)).getAppliedStereotype(stName)) != null) {
                componentInstanceList.add(instList.get(i));
            }
            ++i;
        }
        return componentInstanceList;
    }

    public List<Slot> getRequiredInterfaceSlotList(List<InstanceSpecification> instList, String stName) {
        ArrayList<Slot> reqInterfaceSlotList = new ArrayList<Slot>();
        int i = 0;
        while (i < instList.size()) {
            EList slList = instList.get(i).getSlots();
            int j = 0;
            while (j < slList.size()) {
                ClientServerPort csp;
                Port pt;
                Stereotype st;
                if (((Slot)slList.get(j)).getDefiningFeature() instanceof Port && (st = (pt = (Port)((Slot)slList.get(j)).getDefiningFeature()).getAppliedStereotype(stName)) != null && (csp = (ClientServerPort)pt.getStereotypeApplication(st)).getKind() == ClientServerKind.REQUIRED) {
                    reqInterfaceSlotList.add((Slot)slList.get(j));
                }
                ++j;
            }
            ++i;
        }
        return reqInterfaceSlotList;
    }

    public List<Slot> getInstanceRequiredInterfaceSlotList(InstanceSpecification inst, String stName) {
        ArrayList<Slot> reqInterfaceSlotList = new ArrayList<Slot>();
        EList slList = inst.getSlots();
        int j = 0;
        while (j < slList.size()) {
            ClientServerPort csp;
            Port pt;
            Stereotype st;
            if (((Slot)slList.get(j)).getDefiningFeature() instanceof Port && (st = (pt = (Port)((Slot)slList.get(j)).getDefiningFeature()).getAppliedStereotype(stName)) != null && (csp = (ClientServerPort)pt.getStereotypeApplication(st)).getKind() == ClientServerKind.REQUIRED) {
                reqInterfaceSlotList.add((Slot)slList.get(j));
            }
            ++j;
        }
        return reqInterfaceSlotList;
    }

    public List<Slot> getProvidedInterfaceSlotList(List<InstanceSpecification> instList, String stName) {
        ArrayList<Slot> provInterfaceSlotList = new ArrayList<Slot>();
        int i = 0;
        while (i < instList.size()) {
            EList slList = instList.get(i).getSlots();
            int j = 0;
            while (j < slList.size()) {
                ClientServerPort csp;
                Port pt;
                Stereotype st;
                if (((Slot)slList.get(j)).getDefiningFeature() instanceof Port && (st = (pt = (Port)((Slot)slList.get(j)).getDefiningFeature()).getAppliedStereotype(stName)) != null && (csp = (ClientServerPort)pt.getStereotypeApplication(st)).getKind() == ClientServerKind.PROVIDED) {
                    provInterfaceSlotList.add((Slot)slList.get(j));
                }
                ++j;
            }
            ++i;
        }
        return provInterfaceSlotList;
    }

    public List<Slot> getInstanceProvidedInterfaceSlotList(InstanceSpecification inst, String stName) {
        ArrayList<Slot> provInterfaceSlotList = new ArrayList<Slot>();
        EList slList = inst.getSlots();
        int j = 0;
        while (j < slList.size()) {
            ClientServerPort csp;
            Port pt;
            Stereotype st;
            if (((Slot)slList.get(j)).getDefiningFeature() instanceof Port && (st = (pt = (Port)((Slot)slList.get(j)).getDefiningFeature()).getAppliedStereotype(stName)) != null && (csp = (ClientServerPort)pt.getStereotypeApplication(st)).getKind() == ClientServerKind.PROVIDED) {
                provInterfaceSlotList.add((Slot)slList.get(j));
            }
            ++j;
        }
        return provInterfaceSlotList;
    }

    public List<InstanceSpecification> getConnectorInstList(List<InstanceSpecification> instList, String stName) {
        ArrayList<InstanceSpecification> connectorInstList = new ArrayList<InstanceSpecification>();
        int i = 0;
        while (i < instList.size()) {
            Port pt;
            Stereotype st;
            EList slList;
            if (instList.get(i).getClassifiers().size() == 0 && (slList = instList.get(i).getSlots()).size() > 0 && (st = (pt = (Port)((Slot)slList.get(0)).getDefiningFeature()).getAppliedStereotype(stName)) != null) {
                connectorInstList.add(instList.get(i));
            }
            ++i;
        }
        return connectorInstList;
    }

    public List<Component> getComponentImplList(List<Component> compList, String stName) {
        ArrayList<Component> compImplList = new ArrayList<Component>();
        int i = 0;
        while (i < compList.size()) {
            Stereotype st = compList.get(i).getAppliedStereotype(stName);
            if (st != null) {
                compImplList.add(compList.get(i));
            }
            ++i;
        }
        return compImplList;
    }

    public Slot getBoundPIslot(Slot sl, List<InstanceSpecification> connectorInstList) {
        int i = 0;
        while (i < connectorInstList.size()) {
            int j;
            InstanceSpecification targetIs;
            InstanceValue iv;
            EList vsList;
            EList slotList = connectorInstList.get(i).getSlots();
            EList targetInstanceSlotList = null;
            Slot targetSlot = null;
            Slot slot0 = (Slot)slotList.get(0);
            Slot slot1 = (Slot)slotList.get(1);
            if (slot0.getDefiningFeature().equals(sl.getDefiningFeature())) {
                vsList = slot0.getValues();
                iv = (InstanceValue)vsList.get(0);
                if (sl.getOwningInstance().equals(iv.getInstance())) {
                    vsList = slot1.getValues();
                    iv = (InstanceValue)vsList.get(0);
                    targetIs = iv.getInstance();
                    targetInstanceSlotList = targetIs.getSlots();
                    j = 0;
                    while (j < targetInstanceSlotList.size()) {
                        targetSlot = (Slot)targetInstanceSlotList.get(j);
                        if (targetSlot.getDefiningFeature().equals(slot1.getDefiningFeature())) {
                            return targetSlot;
                        }
                        ++j;
                    }
                }
            } else if (slot1.getDefiningFeature().equals(sl.getDefiningFeature())) {
                vsList = slot1.getValues();
                iv = (InstanceValue)vsList.get(0);
                if (sl.getOwningInstance().equals(iv.getInstance())) {
                    vsList = slot0.getValues();
                    iv = (InstanceValue)vsList.get(0);
                    targetIs = iv.getInstance();
                    targetInstanceSlotList = targetIs.getSlots();
                    j = 0;
                    while (j < targetInstanceSlotList.size()) {
                        targetSlot = (Slot)targetInstanceSlotList.get(j);
                        if (targetSlot.getDefiningFeature().equals(slot1.getDefiningFeature())) {
                            return targetSlot;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return sl;
    }

    public List<Slot> getBoundRIslotList(Slot sl, List<InstanceSpecification> connectorInstList) {
        ArrayList<Slot> boundRIslotList = new ArrayList<Slot>();
        int i = 0;
        while (i < connectorInstList.size()) {
            int j;
            InstanceSpecification targetIs;
            InstanceValue iv;
            EList vsList;
            EList slotList = connectorInstList.get(i).getSlots();
            EList targetInstanceSlotList = null;
            Slot targetSlot = null;
            Slot slot0 = (Slot)slotList.get(0);
            Slot slot1 = (Slot)slotList.get(1);
            if (slot0.getDefiningFeature().equals(sl.getDefiningFeature())) {
                vsList = slot0.getValues();
                iv = (InstanceValue)vsList.get(0);
                if (sl.getOwningInstance().equals(iv.getInstance())) {
                    vsList = slot1.getValues();
                    iv = (InstanceValue)vsList.get(0);
                    targetIs = iv.getInstance();
                    targetInstanceSlotList = targetIs.getSlots();
                    j = 0;
                    while (j < targetInstanceSlotList.size()) {
                        targetSlot = (Slot)targetInstanceSlotList.get(j);
                        if (targetSlot.getDefiningFeature().equals(slot1.getDefiningFeature())) {
                            boundRIslotList.add(targetSlot);
                        }
                        ++j;
                    }
                }
            } else if (slot1.getDefiningFeature().equals(sl.getDefiningFeature())) {
                vsList = slot1.getValues();
                iv = (InstanceValue)vsList.get(0);
                if (sl.getOwningInstance().equals(iv.getInstance())) {
                    vsList = slot0.getValues();
                    iv = (InstanceValue)vsList.get(0);
                    targetIs = iv.getInstance();
                    targetInstanceSlotList = targetIs.getSlots();
                    j = 0;
                    while (j < targetInstanceSlotList.size()) {
                        targetSlot = (Slot)targetInstanceSlotList.get(j);
                        if (targetSlot.getDefiningFeature().equals(slot0.getDefiningFeature())) {
                            boundRIslotList.add(targetSlot);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return boundRIslotList;
    }

    public boolean isCyclicOperation(List<Slot> slotList, Operation op, String stName) {
        CHRtPortSlot chrtPs = null;
        Slot slot = null;
        int i = 0;
        while (i < slotList.size()) {
            slot = slotList.get(i);
            EList stList = slot.getAppliedStereotypes();
            if (!stList.isEmpty()) {
                chrtPs = (CHRtPortSlot)slot.getStereotypeApplication((Stereotype)stList.get(0));
                EList CHRtSpecList = chrtPs.getCH_RtSpecification();
                int j = 0;
                while (j < CHRtSpecList.size()) {
                    String occKind;
                    Operation myOp = (Operation)((CHRtSpecification)CHRtSpecList.get(j)).getContext();
                    if (myOp.equals(op) && (occKind = ((CHRtSpecification)chrtPs.getCH_RtSpecification().get(j)).getOccKind()) != null && occKind.startsWith("periodic")) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    public List<CallOperationAction> getCalledOperation(Operation op) {
        ArrayList<CallOperationAction> coaList = new ArrayList<CallOperationAction>();
        EList bhList = op.getMethods();
        if (bhList.size() > 0) {
            int i = 0;
            while (i < bhList.size()) {
                if (bhList.get(i) instanceof Activity) {
                    EList actNodeList = ((Activity)bhList.get(i)).getNodes();
                    int j = 0;
                    while (j < actNodeList.size()) {
                        if (actNodeList.get(j) instanceof CallOperationAction) {
                            coaList.add((CallOperationAction)actNodeList.get(j));
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return coaList;
    }

    public boolean isSameOperation(Operation op1, Operation op2) {
        if (!op1.getName().equals(op2.getName())) {
            return false;
        }
        if (!op1.getVisibility().equals((Object)op2.getVisibility())) {
            return false;
        }
        EList paramList1 = op1.getOwnedParameters();
        EList paramList2 = op2.getOwnedParameters();
        if (paramList1.size() != paramList2.size()) {
            return false;
        }
        int i = 0;
        while (i < paramList1.size()) {
            Parameter par1 = (Parameter)paramList1.get(i);
            Parameter par2 = (Parameter)paramList2.get(i);
            if (!par1.getType().getName().equals(par2.getType().getName())) {
                return false;
            }
            if (!par1.getName().equals(par2.getName())) {
                return false;
            }
            if (!par1.getDirection().equals((Object)par2.getDirection())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Interface getInterface(Operation op, List<Port> ptList, String stName) {
        List<Interface> interfaceList = this.getProvidedInterfaceList(ptList, stName);
        int i = 0;
        while (i < interfaceList.size()) {
            Interface myIf = interfaceList.get(i);
            EList opList = myIf.getOperations();
            int j = 0;
            while (j < opList.size()) {
                if (this.isSameOperation(op, (Operation)opList.get(j))) {
                    return myIf;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public boolean isDataTypeWithRequired(Interface aInt) {
        EList opList = aInt.getOwnedOperations();
        int i = 0;
        while (i < opList.size()) {
            EList parList = ((Operation)opList.get(i)).getOwnedParameters();
            int j = 0;
            while (j < parList.size()) {
                Parameter par = (Parameter)parList.get(j);
                if (!(par.getName().equals("Integer") || par.getName().equals("Float") || par.getName().equals("Natural"))) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public String getImplementationLanguage(Component c, String stName) {
        Stereotype cImplSt = c.getAppliedStereotype(stName);
        ComponentImplementation cImpl = (ComponentImplementation)c.getStereotypeApplication(cImplSt);
        String lang = cImpl.getLanguage();
        if (lang == null) {
            return "Ada";
        }
        return lang;
    }

    public String adaTypeToCtype(Type type) {
        if (type instanceof PrimitiveType && type.getName().equals("Integer")) {
            return "int";
        }
        if (type instanceof PrimitiveType && type.getName().equals("Float")) {
            return "float";
        }
        if (type instanceof PrimitiveType && type.getName().equals("Boolean")) {
            return "bool";
        }
        return type.getName();
    }

    public Boolean hasCimplementation(List<Component> lComp, String stName) {
        int i = 0;
        while (i < lComp.size()) {
            ComponentImplementation cImpl;
            Stereotype compImplSt = lComp.get(i).getAppliedStereotype(stName);
            if (compImplSt != null && ((cImpl = (ComponentImplementation)lComp.get(i).getStereotypeApplication(compImplSt)).getLanguage().equals("C") || cImpl.getLanguage().equals("C++"))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public List<CallOperationAction> getCalledOperationList(Activity act) {
        ArrayList<CallOperationAction> coaList = new ArrayList<CallOperationAction>();
        EList actNodeList = act.getNodes();
        InitialNode actNode = null;
        ControlFlow cf = null;
        boolean finalNodeFound = false;
        int j = 0;
        while (j < actNodeList.size()) {
            if (actNodeList.get(j) instanceof InitialNode) {
                actNode = (InitialNode)actNodeList.get(j);
                break;
            }
            ++j;
        }
        while (!finalNodeFound) {
            cf = (ControlFlow)actNode.getOutgoings().get(0);
            if (cf.getTarget() instanceof CallOperationAction) {
                actNode = (CallOperationAction)cf.getTarget();
                coaList.add((CallOperationAction)actNode);
                continue;
            }
            if (cf.getTarget() instanceof ActivityFinalNode) {
                finalNodeFound = true;
                continue;
            }
            return null;
        }
        return coaList;
    }

    public Activity getICB(Operation op) {
        EList bhList = op.getMethods();
        int i = 0;
        while (i < bhList.size()) {
            if (bhList.get(i) instanceof Activity) {
                return (Activity)bhList.get(i);
            }
            ++i;
        }
        return null;
    }

    public List<InstanceSpecification> getComponentInstanceList(Component cImpl, List<InstanceSpecification> allIsList) {
        ArrayList<InstanceSpecification> isList = new ArrayList<InstanceSpecification>();
        int i = 0;
        while (i < allIsList.size()) {
            if (((Classifier)allIsList.get(i).getClassifiers().get(0)).equals(cImpl)) {
                isList.add(allIsList.get(i));
            }
            ++i;
        }
        return isList;
    }

    public Boolean isSingleNodeSystem(List<InstanceSpecification> allIsList, String stName) {
        InstanceSpecification processingNode = null;
        Stereotype st = null;
        int i = 0;
        while (i < allIsList.size()) {
            st = allIsList.get(i).getAppliedStereotype(stName);
            if (st != null) {
                if (processingNode == null) {
                    processingNode = allIsList.get(i);
                } else if (!allIsList.get(i).equals(processingNode)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public List<InstanceSpecification> getProcessingNodeList(List<InstanceSpecification> allIsList, String stName) {
        ArrayList<InstanceSpecification> pnList = new ArrayList<InstanceSpecification>();
        Stereotype st = null;
        int i = 0;
        while (i < allIsList.size()) {
            st = allIsList.get(i).getAppliedStereotype(stName);
            if (st != null) {
                pnList.add(allIsList.get(i));
            }
            ++i;
        }
        return pnList;
    }

    public List<InstanceSpecification> getNodeInstanceSpecification(InstanceSpecification node, List<Comment> commList, String stName) {
        ArrayList<InstanceSpecification> isList = new ArrayList<InstanceSpecification>();
        Stereotype st = null;
        Assign ass = null;
        int i = 0;
        while (i < commList.size()) {
            st = commList.get(i).getAppliedStereotype(stName);
            if (st != null && ((Element)(ass = (Assign)commList.get(i).getStereotypeApplication(st)).getTo().get(0)).equals(node)) {
                isList.add((InstanceSpecification)ass.getFrom().get(0));
            }
            ++i;
        }
        return isList;
    }

    public List<Component> getNodeComponentImplementationList(List<InstanceSpecification> isList, String stName) {
        ArrayList<Component> cImplList = new ArrayList<Component>();
        Component cImpl = null;
        int i = 0;
        while (i < isList.size()) {
            if (isList.get(i).getClassifiers().get(0) instanceof Component && (cImpl = (Component)isList.get(i).getClassifiers().get(0)).getAppliedStereotype(stName) != null) {
                cImplList.add(cImpl);
            }
            ++i;
        }
        return cImplList;
    }

    public List<Component> getNodeComponentTypeList(List<Component> cImplList, String stName) {
        ArrayList<Component> cTypeList = new ArrayList<Component>();
        Component cType = null;
        int i = 0;
        while (i < cImplList.size()) {
            if (((Dependency)cImplList.get(i).getClientDependencies().get(0)).getSuppliers().get(0) instanceof Component && (cType = (Component)((Dependency)cImplList.get(i).getClientDependencies().get(0)).getSuppliers().get(0)).getAppliedStereotype(stName) != null) {
                cTypeList.add(cType);
            }
            ++i;
        }
        return cTypeList;
    }

    public List<Component> getAllComponentTypeList(List<Component> allComponentList, String stName) {
        ArrayList<Component> cTypeList = new ArrayList<Component>();
        int i = 0;
        while (i < allComponentList.size()) {
            if (allComponentList.get(i).getAppliedStereotype(stName) != null) {
                cTypeList.add(allComponentList.get(i));
            }
            ++i;
        }
        return cTypeList;
    }

    public List<Interface> getNodeInterfaceList(List<Component> cTypeList, String stName) {
        ArrayList<Interface> ifList = new ArrayList<Interface>();
        Stereotype st = null;
        int i = 0;
        while (i < cTypeList.size()) {
            EList pList = cTypeList.get(i).getOwnedAttributes();
            ClientServerPort csp = null;
            if (pList != null) {
                int j = 0;
                while (j < pList.size()) {
                    if (pList.get(j) instanceof Port && (st = ((Property)pList.get(j)).getAppliedStereotype(stName)) != null) {
                        csp = (ClientServerPort)((Property)pList.get(j)).getStereotypeApplication(st);
                        if (csp.getKind().equals((Object)ClientServerKind.PROVIDED)) {
                            if (csp.getProvInterface().get(0) != null) {
                                ifList.add((Interface)csp.getProvInterface().get(0));
                            }
                        } else if (csp.getKind().equals((Object)ClientServerKind.REQUIRED) && csp.getReqInterface().get(0) != null) {
                            ifList.add((Interface)csp.getReqInterface().get(0));
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return ifList;
    }

    public InstanceSpecification getDeploymentProcessingNode(Slot sl, List<Comment> commList, String stName) {
        Stereotype st = null;
        Assign ass = null;
        int i = 0;
        while (i < commList.size()) {
            st = commList.get(i).getAppliedStereotype(stName);
            if (st != null && (ass = (Assign)commList.get(i).getStereotypeApplication(st)).getFrom() != null && ass.getTo() != null && ass.getTo().get(0) instanceof InstanceSpecification && ass.getFrom().get(0) instanceof InstanceSpecification && ((Element)ass.getFrom().get(0)).equals(sl.getOwningInstance())) {
                return (InstanceSpecification)ass.getTo().get(0);
            }
            ++i;
        }
        return null;
    }

    public Boolean isRemoteCommNecessary(List<Slot> slList, InstanceSpecification procNode, List<Comment> commList, String stName) {
        int i = 0;
        while (i < slList.size()) {
            if (!this.getDeploymentProcessingNode(slList.get(i), commList, stName).equals(procNode)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public List<Operation> getProvidedOperationList(List<Component> cTypeList, String stName) {
        ArrayList<Operation> opList = new ArrayList<Operation>();
        Stereotype st = null;
        Port pt = null;
        Interface myIf = null;
        int i = 0;
        while (i < cTypeList.size()) {
            EList pList = cTypeList.get(i).getOwnedAttributes();
            int j = 0;
            while (j < pList.size()) {
                ClientServerPort csp;
                if (pList.get(j) instanceof Port && (csp = (ClientServerPort)(pt = (Port)pList.get(j)).getStereotypeApplication(st = pt.getAppliedStereotype(stName))).getKind().equals((Object)ClientServerKind.PROVIDED)) {
                    myIf = (Interface)csp.getProvInterface().get(0);
                    EList ifOpList = myIf.getOwnedOperations();
                    int k = 0;
                    while (k < ifOpList.size()) {
                        opList.add((Operation)ifOpList.get(k));
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return opList;
    }

    public List<Slot> getRemoteRIslotList(List<Slot> riSlotList, InstanceSpecification procNode, List<InstanceSpecification> connectorInstList, List<Comment> commList, String assignStName) {
        ArrayList<Slot> remoteRIslotList = new ArrayList<Slot>();
        Slot boundSlot = null;
        int i = 0;
        while (i < riSlotList.size()) {
            boundSlot = this.getBoundPIslot(riSlotList.get(i), connectorInstList);
            if (!this.getDeploymentProcessingNode(boundSlot, commList, assignStName).equals(procNode) && !remoteRIslotList.contains(boundSlot)) {
                remoteRIslotList.add(boundSlot);
            }
            ++i;
        }
        return remoteRIslotList;
    }

    public Boolean isRemoteMsgClientNecessary(List<Slot> riSlotList, InstanceSpecification procNode, List<InstanceSpecification> connectorInstList, List<Comment> commList, String assignStName) {
        Slot boundSlot = null;
        int i = 0;
        while (i < riSlotList.size()) {
            boundSlot = this.getBoundPIslot(riSlotList.get(i), connectorInstList);
            if (!this.getDeploymentProcessingNode(boundSlot, commList, assignStName).equals(procNode)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Boolean isRemoteMsgServerNecessary(List<Slot> slList, InstanceSpecification procNode, List<InstanceSpecification> connectorInstList, List<Comment> commList, String stName) {
        List<Slot> boundSlotList = null;
        int i = 0;
        while (i < slList.size()) {
            boundSlotList = this.getBoundRIslotList(slList.get(i), connectorInstList);
            int j = 0;
            while (j < boundSlotList.size()) {
                if (!this.getDeploymentProcessingNode(boundSlotList.get(j), commList, stName).equals(procNode)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public Boolean useSequenceID(Slot sl, List<InstanceSpecification> connectorInstList, List<Connector> connectorList, String stName) {
        int i = 0;
        while (i < connectorInstList.size()) {
            InstanceValue iv;
            EList vsList;
            EList slotList = connectorInstList.get(i).getSlots();
            Slot slot0 = (Slot)slotList.get(0);
            Slot slot1 = (Slot)slotList.get(1);
            if (slot0.getDefiningFeature().equals(sl.getDefiningFeature())) {
                vsList = slot0.getValues();
                iv = (InstanceValue)vsList.get(0);
                if (sl.getOwningInstance().equals(iv.getInstance())) {
                    return this.isTransmissionWithSequenceID(slot0, slot1, connectorList, stName);
                }
            } else if (slot1.getDefiningFeature().equals(sl.getDefiningFeature())) {
                vsList = slot1.getValues();
                iv = (InstanceValue)vsList.get(0);
                if (sl.getOwningInstance().equals(iv.getInstance())) {
                    return this.isTransmissionWithSequenceID(slot0, slot1, connectorList, stName);
                }
            }
            ++i;
        }
        return false;
    }

    public Boolean isTransmissionWithSequenceID(Slot slot0, Slot slot1, List<Connector> connectorList, String stName) {
        EList ctEndList = null;
        int i = 0;
        while (i < connectorList.size()) {
            ctEndList = connectorList.get(i).getEnds();
            ConnectorEnd ce0 = (ConnectorEnd)ctEndList.get(0);
            ConnectorEnd ce1 = (ConnectorEnd)ctEndList.get(1);
            if ((ce0.getRole().equals(slot0.getDefiningFeature()) || ce1.getRole().equals(slot0.getDefiningFeature())) && (ce0.getRole().equals(slot1.getDefiningFeature()) || ce1.getRole().equals(slot1.getDefiningFeature()))) {
                Stereotype st = connectorList.get(i).getAppliedStereotype(stName);
                if (st == null) {
                    return false;
                }
                TransmissionWithProtocol twp = (TransmissionWithProtocol)connectorList.get(i).getStereotypeApplication(st);
                return twp.isUseSeqID();
            }
            ++i;
        }
        return false;
    }

    public String getCRClib(Slot sl, List<InstanceSpecification> connectorInstList, List<Connector> connectorList, String stName) {
        int i = 0;
        while (i < connectorInstList.size()) {
            InstanceValue iv;
            EList vsList;
            EList slotList = connectorInstList.get(i).getSlots();
            Slot slot0 = (Slot)slotList.get(0);
            Slot slot1 = (Slot)slotList.get(1);
            if (slot0.getDefiningFeature().equals(sl.getDefiningFeature())) {
                vsList = slot0.getValues();
                iv = (InstanceValue)vsList.get(0);
                if (sl.getOwningInstance().equals(iv.getInstance())) {
                    return this.getTransmissionWithCRC(slot0, slot1, connectorList, stName);
                }
            } else if (slot1.getDefiningFeature().equals(sl.getDefiningFeature())) {
                vsList = slot1.getValues();
                iv = (InstanceValue)vsList.get(0);
                if (sl.getOwningInstance().equals(iv.getInstance())) {
                    return this.getTransmissionWithCRC(slot0, slot1, connectorList, stName);
                }
            }
            ++i;
        }
        return "";
    }

    public String getTransmissionWithCRC(Slot slot0, Slot slot1, List<Connector> connectorList, String stName) {
        EList ctEndList = null;
        int i = 0;
        while (i < connectorList.size()) {
            ctEndList = connectorList.get(i).getEnds();
            ConnectorEnd ce0 = (ConnectorEnd)ctEndList.get(0);
            ConnectorEnd ce1 = (ConnectorEnd)ctEndList.get(1);
            if ((ce0.getRole().equals(slot0.getDefiningFeature()) || ce1.getRole().equals(slot0.getDefiningFeature())) && (ce0.getRole().equals(slot1.getDefiningFeature()) || ce1.getRole().equals(slot1.getDefiningFeature()))) {
                Stereotype st = connectorList.get(i).getAppliedStereotype(stName);
                if (st == null) {
                    return "";
                }
                TransmissionWithProtocol twp = (TransmissionWithProtocol)connectorList.get(i).getStereotypeApplication(st);
                return twp.getCRC();
            }
            ++i;
        }
        return "";
    }

    public String getDocumentation(NamedElement elem) {
        String docString = "";
        EList comments = elem.getOwnedComments();
        for (Comment comment : comments) {
            Stereotype documentation = comment.getAppliedStereotype(DOCSTEREO);
            if (documentation == null) continue;
            docString = comment.getBody();
        }
        String commented = "";
        Scanner scanner = new Scanner(docString);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            commented = String.valueOf(commented) + "-- " + line + System.getProperty("line.separator");
        }
        return commented;
    }
}

