-----------------------------------------------------------------------
--           Code Archetypes for the CHESS Component Model           --
--                                                                   --
--                   Copyright (C) 2011-2012                         --
--                 University of Padova, ITALY                       --
--                                                                   --
-- Author: Marco Panunzio         panunzio@math.unipd.it             --
--                                                                   --
-- This program is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU General Public License       --
-- version 3 as published by the Free Software Foundation.           --
--                                                                   --
-- This program is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details.                          --
--                                                                   --
-- You should have received a copy of the GNU General Public         --
-- License along with this program; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
-----------------------------------------------------------------------


package body Container_Protection is

   --------------------------
   -- Release_Control_OBCS --
   --------------------------

   protected body Release_Control_OBCS is

      entry Enqueue_For_Release(Release_Time : out Ada.Real_Time.Time) when Barrier is
      begin
         Release_Time := Ada.Real_Time.Clock;
      end Enqueue_For_Release;

      procedure Set_Release_Flag(New_Flag : in Boolean) is
      begin
         Barrier := New_Flag;
      end Set_Release_Flag;

      function Get_Release_Flag return Boolean is
      begin
         return Barrier;
      end Get_Release_Flag;


   end Release_Control_OBCS;

   --------------------------
   -- Simple_Counter_OBCS --
   --------------------------

   protected body Simple_Counter_OBCS is

      procedure Update_Barrier is
      begin
         Barrier := Barrier_Release_Flag and Request_Pending > 0;
      end Update_Barrier;

      entry Enqueue_For_Release(Release_Time : out Ada.Real_Time.Time) when Barrier is
      begin
         Release_Time := Ada.Real_Time.Clock;
         Request_Pending := Request_Pending - 1;
         Update_Barrier;
      end Enqueue_For_Release;

      procedure Set_Release_Flag(New_Flag : in Boolean) is
      begin
         Barrier_Release_Flag := New_Flag;
         Update_Barrier;
      end Set_Release_Flag;

      function Get_Release_Flag return Boolean is
      begin
         return Barrier;
      end Get_Release_Flag;

      procedure Put_Request is
      begin
         if Request_Pending < Max_Pending then
            Request_Pending := Request_Pending + 1;
         end if;
         Update_Barrier;
      end Put_Request;

   end Simple_Counter_OBCS;



end Container_Protection;
