-----------------------------------------------------------------------
--           Code Archetypes for the CHESS Component Model           --
--                                                                   --
--                   Copyright (C) 2011-2012                         --
--                 University of Padova, ITALY                       --
--                                                                   --
-- Author: Marco Panunzio         panunzio@math.unipd.it             --
--                                                                   --
-- This program is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU General Public License       --
-- version 3 as published by the Free Software Foundation.           --
--                                                                   --
-- This program is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details.                          --
--                                                                   --
-- You should have received a copy of the GNU General Public         --
-- License along with this program; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
-----------------------------------------------------------------------


with Ada.Real_Time;
with System;

package Task_Attributes is

   -- Task_State

   type Task_Attributes_Record is abstract tagged record
      Relative_Deadline : Ada.Real_Time.Time_Span := Ada.Real_Time.Time_Span_Zero;
      Execution_Time : Ada.Real_Time.Time_Span := Ada.Real_Time.Time_Span_Zero;
      Prio : System.Any_Priority := System.Priority'First;
   end record;

   type Task_Attributes_ptr is access all Task_Attributes_Record'Class;

   -- Periodic_Task_State

   type Periodic_Task_Attributes_Record is new Task_Attributes_Record with record
      Period : Ada.Real_Time.Time_Span := Ada.Real_Time.Time_Span_Zero;
   end record;

   type Periodic_Task_Attributes_Record_ptr is access all
     Periodic_Task_Attributes_Record'Class;

   -- Sporadic_Task_State

   type Sporadic_Task_Attributes_Record is new Task_Attributes_Record with record
      MIAT : Ada.Real_Time.Time_Span := Ada.Real_Time.Time_Span_Zero;
   end record;

   type Sporadic_Task_Attributes_Record_ptr is access all
     Sporadic_Task_Attributes_Record'Class;

   -- Bursty_Task_State

   type Bursty_Task_Attributes_Record is new Task_Attributes_Record with record
      Burst_Interval : Ada.Real_Time.Time_Span := Ada.Real_Time.Time_Span_Zero;
      Max_Activations : Natural := 0;
   end record;

   type Bursty_Task_Attributes_Record_ptr is access all
     Bursty_Task_Attributes_Record'Class;

end Task_Attributes;
