-----------------------------------------------------------------------
--           Code Archetypes for the CHESS Component Model           --
--                                                                   --
--                   Copyright (C) 2011-2012                         --
--                 University of Padova, ITALY                       --
--                                                                   --
-- Author: Marco Panunzio         panunzio@math.unipd.it             --
--                                                                   --
-- This program is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU General Public License       --
-- version 3 as published by the Free Software Foundation.           --
--                                                                   --
-- This program is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details.                          --
--                                                                   --
-- You should have received a copy of the GNU General Public         --
-- License along with this program; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
-----------------------------------------------------------------------

with System_Time;
with Ada.Text_IO; use Ada.Text_IO;

package body Cyclic_Task is

   use Ada.Real_Time;

   task body Thread_T is
      Task_Static_Offset : constant Time_Span := Milliseconds(Static_Offset);
      Task_Period : constant Time_Span := Milliseconds(Period);
      Next_Time : Time := System_Time.System_Start_Time +
        System_Time.Task_Activation_Delay + Task_Static_Offset;
      Assigned_Task_ID : constant Task_Gen_ID := My_Task_ID;
      Release_Time : Time;

   begin
      -- Suspend the task until first release;
      delay until Next_Time;


      Put("Task ");
      Put(Natural'Image(Natural(Assigned_Task_ID)));
      Put_Line(" first activation");

      Task_Loop :
      loop
         -- First action : enqueue for release
         Enqueue_for_Release.all (Release_Time);

         --  Execute the sequential operation
         Operation.all;

         -- Calculate new release time and suspend
         Next_Time:= Next_Time + Task_Period;
         delay until Next_Time;

      end loop Task_Loop;

   end Thread_T;

--   procedure Initialize is
--   begin
--      null;
--   end Initialize;

end Cyclic_Task;
