-----------------------------------------------------------------------
--           Code Archetypes for the CHESS Component Model           --
--                                                                   --
--                   Copyright (C) 2011-2012                         --
--                 University of Padova, ITALY                       --
--                                                                   --
-- Author: Marco Panunzio         panunzio@math.unipd.it             --
--                                                                   --
-- This program is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU General Public License       --
-- version 3 as published by the Free Software Foundation.           --
--                                                                   --
-- This program is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details.                          --
--                                                                   --
-- You should have received a copy of the GNU General Public         --
-- License along with this program; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
-----------------------------------------------------------------------

with System_Time;
with Ada.Real_Time; use Ada.Real_Time;
with Ada.Text_IO;

package body Sporadic_Task is

   --------------
   -- Thread_T --
   --------------

   task body Thread_T is
      Req_Desc : Data_Structure.Request_Descriptor_T;
      Release : Time;
      Task_MIAT : constant Time_Span := Milliseconds(MIAT);
      Next_Time : Time := System_Time.System_Start_Time +
        System_Time.Task_Activation_Delay;
      Assigned_Task_ID : constant Data_Structure.Task_Gen_ID := My_Task_ID;
   begin

      -- Suspend the task until first release;
      delay until Next_Time;

      Ada.Text_IO.Put("Task ");
      Ada.Text_IO.Put(Natural'Image(Natural(Assigned_Task_ID)));
      Ada.Text_IO.Put_Line(" first activation");

      Task_Loop :
      loop
         -- First action : enqueue in the release entry of the CPA
         Get_Request(Req_Desc, Release);

         --  Execute the sequential operation
         --Ada.Text_IO.Put_Line("Sporadic Task: Calling My_OPCS");
         Data_Structure.My_OPCS(Req_Desc.Params.all);

         -- Calculate the new earliest release time and suspend
         Next_Time := Release + Task_MIAT;
         delay until Next_Time;
      end loop Task_Loop;

   end Thread_T;

end Sporadic_Task;
