/*
 * Decompiled with CFR 0.152.
 */
package it.unipd.chess.editor;

import it.unipd.chess.profiles.CHESSProfileManager;
import it.unipd.chess.resourcelistener.ResourceSetListenerManager;
import it.unipd.chess.resourcelistener.SelectionListenerManager;
import it.unipd.chess.util.MainRegistry;
import it.unipd.chess.views.DiagramStatus;
import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class CHESSEditor
extends PapyrusMultiDiagramEditor {
    public static String ID = "it.unipd.chess.editor";
    CHESSEditor me;
    DiagramStatus diagramStatus;
    ServicesRegistry servicesRegistry;
    MainRegistry mainRegistry;
    IEditorSite site;
    public static Hashtable<String, ImageDescriptor> viewIcons = new Hashtable();
    SelectionListenerManager sl;

    public DiagramStatus getDiagramStatus() {
        return this.diagramStatus;
    }

    protected void activate() {
        super.activate();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ServicesRegistry serviceRegistry = (ServicesRegistry)CHESSEditor.this.me.getAdapter(ServicesRegistry.class);
                ModelSet modelSet = null;
                try {
                    MainRegistry mr;
                    modelSet = (ModelSet)serviceRegistry.getService(ModelSet.class);
                    TransactionalEditingDomain editingDomain = modelSet.getTransactionalEditingDomain();
                    CHESSProfileManager.loadCHESSProfile((ResourceSet)editingDomain.getResourceSet());
                    ISashWindowsContainer p = CHESSEditor.this.getISashWindowsContainer();
                    CHESSEditor.this.diagramStatus = new DiagramStatus(p.getActiveSashWindowsPage());
                    CHESSEditor.this.mainRegistry = mr = new MainRegistry(serviceRegistry);
                    mr.add(DiagramStatus.class, (Object)CHESSEditor.this.diagramStatus);
                    CHESSEditor.this.sl = new SelectionListenerManager(mr);
                    CHESSEditor.this.me.site.getPage().addSelectionListener((ISelectionListener)CHESSEditor.this.sl);
                    editingDomain.addResourceSetListener((ResourceSetListener)new ResourceSetListenerManager(mr));
                    URL nullFile = FileLocator.find((Bundle)Platform.getBundle((String)"it.unipd.chess.editor"), (IPath)new Path("icons/NullView.gif"), null);
                    ImageDescriptor icon = ImageDescriptor.createFromURL((URL)nullFile);
                    viewIcons.put("NullView", icon);
                    for (String v : CHESSProfileManager.CHESS_VIEWS_LIST) {
                        URL file = FileLocator.find((Bundle)Platform.getBundle((String)"it.unipd.chess.editor"), (IPath)new Path("icons/" + v + ".gif"), null);
                        icon = file != null ? ImageDescriptor.createFromURL((URL)file) : ImageDescriptor.createFromURL((URL)nullFile);
                        viewIcons.put(v, icon);
                    }
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void dispose() {
        this.site.getPage().removeSelectionListener((ISelectionListener)this.sl);
        super.dispose();
    }

    public MainRegistry getMainRegistry() {
        return this.mainRegistry;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        try {
            this.me = this;
            this.site = site;
            super.init(site, input);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Diagram getDiagram() {
        EObject diagramEObj;
        Object model = this.getISashWindowsContainer().getActiveSashWindowsPage().getRawModel();
        Diagram diagram = null;
        if (model instanceof PageRef && (diagramEObj = ((PageRef)model).getEmfPageIdentifier()) instanceof Diagram) {
            diagram = (Diagram)diagramEObj;
        }
        return diagram;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        return activeWorkbenchWindow.getActivePage();
    }
}

