/*
 * Decompiled with CFR 0.152.
 */
package it.unipd.chess.editor;

import it.unipd.chess.editor.CHESSEditor;
import it.unipd.chess.views.DiagramStatus;
import it.unipd.chess.views.ViewDiagramAssociations;
import java.util.List;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.ui.IEditorPart;

public class PaletteManager {
    protected static List<Object> lookupSelectedElements(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return structuredSelection.toList();
        }
        if (selection instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)selection;
            return treeSelection.toList();
        }
        return null;
    }

    public static void setPaletteVisibility(CHESSEditor editor, DiagramStatus ds) {
        try {
            IEditorPart ep = editor.getActiveEditor();
            ISelection selection = ep.getSite().getSelectionProvider().getSelection();
            List<Object> selections = PaletteManager.lookupSelectedElements(selection);
            GraphicalEditPart a = (GraphicalEditPart)selections.get(0);
            DiagramEditDomain de = (DiagramEditDomain)a.getDiagramEditDomain();
            PaletteViewer pv = de.getPaletteViewer();
            String viewName = ds.getActiveView();
            String diagramName = ds.getCurrentView().getCurrentDiagramName();
            for (Object o : pv.getPaletteRoot().getChildren()) {
                if (!(o instanceof PaletteDrawer)) continue;
                PaletteDrawer d = (PaletteDrawer)o;
                PaletteManager.setPaletteVisibility(d, viewName, diagramName);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private static void setPaletteVisibility(PaletteDrawer paletteDrawer, String viewName, String diagramName) {
        if (diagramName.equals("SystemView")) {
            return;
        }
        if (diagramName.equals(ViewDiagramAssociations.ANYDIAGRAM)) {
            paletteDrawer.setVisible(false);
            return;
        }
        paletteDrawer.setVisible(true);
        String label = paletteDrawer.getLabel();
        String paletteId = paletteDrawer.getId();
        if (viewName.equals("ComponentView")) {
            if (diagramName.equals(ViewDiagramAssociations.classDiagram) || diagramName.equals(ViewDiagramAssociations.compositeDiagram)) {
                paletteDrawer.setVisible(false);
                if (label.equals("CHESS FunctView") || label.equals("FoReVer")) {
                    paletteDrawer.setVisible(true);
                }
            }
            if (diagramName.equals(ViewDiagramAssociations.activityDiagram)) {
                paletteDrawer.setVisible(false);
                if (label.equals("CHESS/Activity")) {
                    paletteDrawer.setVisible(true);
                }
            }
            if (diagramName.equals(ViewDiagramAssociations.stateMachineDiagram)) {
                paletteDrawer.setVisible(true);
                String id = paletteDrawer.getId();
                if (id.compareTo("SM_FunctionalDrawer__1317124986519") != 0) {
                    paletteDrawer.setVisible(false);
                }
            }
            if (diagramName.equals(ViewDiagramAssociations.sequenceDiagram)) {
                paletteDrawer.setVisible(false);
            }
        }
        if (viewName.equals("ExtraFunctionalView")) {
            if (diagramName.equals(ViewDiagramAssociations.stateMachineDiagram)) {
                paletteDrawer.setVisible(true);
                if (paletteId.compareTo("SM_ErrorModelDrawer__1317126136270") != 0) {
                    paletteDrawer.setVisible(false);
                }
            }
            if (diagramName.equals(ViewDiagramAssociations.compositeDiagram)) {
                paletteDrawer.setVisible(true);
                if (paletteId.compareTo("CSD_RTDrawer__1302019186026") != 0 && paletteId.compareTo("CSD_FPTC_Drawer__1317635175167") != 0) {
                    paletteDrawer.setVisible(false);
                }
            }
            if (diagramName.equals(ViewDiagramAssociations.classDiagram)) {
                paletteDrawer.setVisible(false);
            }
            if (diagramName.equals(ViewDiagramAssociations.activityDiagram)) {
                paletteDrawer.setVisible(false);
            }
            if (diagramName.equals(ViewDiagramAssociations.sequenceDiagram)) {
                paletteDrawer.setVisible(true);
                if (paletteId.compareTo("drawer_1329924117088") != 0 && paletteId.compareTo("Drawer__1329924033356") != 0) {
                    paletteDrawer.setVisible(false);
                }
            }
        }
        if (viewName.equals("DeploymentView")) {
            if (diagramName.equals(ViewDiagramAssociations.classDiagram)) {
                paletteDrawer.setVisible(false);
                if (label.equals("CHESS/Deployment") || label.equals("FoReVerDeploymentCD")) {
                    paletteDrawer.setVisible(true);
                }
            }
            if (diagramName.equals(ViewDiagramAssociations.compositeDiagram)) {
                paletteDrawer.setVisible(false);
                if (label.equals("CHESS/Deployment") || label.equals("FoReVer")) {
                    paletteDrawer.setVisible(true);
                }
            }
            if (diagramName.equals(ViewDiagramAssociations.stateMachineDiagram)) {
                paletteDrawer.setVisible(true);
                if (paletteId.compareTo("SM_FunctionalDrawer__1317124986519") != 0) {
                    paletteDrawer.setVisible(false);
                }
            }
        }
        if (viewName.equals("DependabilityView")) {
            if (diagramName.equals(ViewDiagramAssociations.stateMachineDiagram)) {
                paletteDrawer.setVisible(true);
                if (paletteId.compareTo("SM_ErrorModelDrawer__1317126136270") != 0) {
                    paletteDrawer.setVisible(false);
                }
            } else if (diagramName.equals(ViewDiagramAssociations.classDiagram)) {
                paletteDrawer.setVisible(false);
            } else if (diagramName.equals(ViewDiagramAssociations.compositeDiagram)) {
                paletteDrawer.setVisible(true);
                if (paletteId.compareTo("CSD_FPTC_Drawer__1317635175167") != 0) {
                    paletteDrawer.setVisible(false);
                }
            }
        }
        if (viewName.equals("DependabilityAnalysisView") && diagramName.equals(ViewDiagramAssociations.classDiagram)) {
            paletteDrawer.setVisible(true);
            if (paletteId.compareTo("DepAnalysisViewDrawer__1317300165546") != 0) {
                paletteDrawer.setVisible(false);
            }
        }
        if (viewName.equals("RTAnalysisView") && diagramName.equals(ViewDiagramAssociations.classDiagram)) {
            paletteDrawer.setVisible(false);
            if (paletteId.compareTo("AnalysisViewDrawer__1317300165546") != 0) {
                paletteDrawer.setVisible(false);
            }
        }
        if (viewName.equals("RailwayView")) {
            paletteDrawer.setVisible(false);
            if (diagramName.equals(ViewDiagramAssociations.compositeDiagram) && paletteId.compareTo("Drawer__1301934597253") == 0) {
                paletteDrawer.setVisible(true);
            }
        }
    }

    private static IEditorPart getActiveSashPage(CHESSEditor editorPart) {
        ISashWindowsContainer sashWindowsContainer = (ISashWindowsContainer)editorPart.getAdapter(ISashWindowsContainer.class);
        if (sashWindowsContainer != null) {
            return sashWindowsContainer.getActiveEditor();
        }
        return null;
    }
}

