/*
 * Decompiled with CFR 0.152.
 */
package it.unipd.chess.editor;

import it.unipd.chess.editor.Activator;
import it.unipd.chess.editor.CHESSEditor;
import it.unipd.chess.editor.PaletteManager;
import it.unipd.chess.editor.commands.SwitchSourceProvider;
import it.unipd.chess.resourcelistener.SelectionListenerExtra;
import it.unipd.chess.views.DiagramStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.impl.EObjectTreeElementImpl;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPageBookView;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.services.ISourceProviderService;
import org.eclipse.ui.views.properties.PropertySheet;

public class SelectionListener
extends SelectionListenerExtra {
    DiagramStatus diagramStatus = null;

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        TreeSelection tSelection;
        Object fElement;
        if (this.diagramStatus == null) {
            this.diagramStatus = (DiagramStatus)this.getRegistry().getService(DiagramStatus.class);
        }
        this.diagramStatus.setUserAction(true);
        if (part instanceof PropertySheet) {
            part = ((PropertySheet)part).getSite().getWorkbenchWindow().getActivePage().getActiveEditor();
        }
        if (part instanceof CHESSEditor) {
            CHESSEditor editor = (CHESSEditor)part;
            IPage newPage = editor.getISashWindowsContainer().getActiveSashWindowsPage();
            this.diagramStatus.setActualView(newPage);
            PaletteManager.setPaletteVisibility(editor, this.diagramStatus);
        } else if (part instanceof ModelExplorerPageBookView && selection instanceof TreeSelection && !selection.isEmpty() && (fElement = (tSelection = (TreeSelection)selection).getFirstElement()) instanceof EObjectTreeElementImpl) {
            this.diagramStatus.setActualView(tSelection);
        }
        IWorkbenchWindow window = null;
        try {
            window = part.getSite().getWorkbenchWindow();
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "it.unipd.chess.editor", e.getMessage()));
            return;
        }
        if (window.getActivePage() != null) {
            ISourceProviderService spService = (ISourceProviderService)window.getService(ISourceProviderService.class);
            SwitchSourceProvider sp = (SwitchSourceProvider)spService.getSourceProvider("it.unipd.chess.editor.commands.switchState");
            sp.updateStatus(window.getActivePage().getActiveEditor());
        }
    }
}

