/*
 * Decompiled with CFR 0.152.
 */
package it.unipd.chess.editor.commands;

import it.unipd.chess.editor.CHESSEditor;
import it.unipd.chess.editor.utils.CHESSEditorUtils;
import it.unipd.chess.profiles.CHESSProfileManager;
import it.unipd.chess.util.CHESSProjectSupport;
import it.unipd.chess.views.DiagramStatus;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

public class SupersuserToggleCommand
extends AbstractHandler
implements IElementUpdater {
    private boolean selected = false;
    String uncheckedText = "Enable superuser: deactivate write permission checking";
    String checkedText = "Disable superuser: activate write permission checking";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        if (editor instanceof CHESSEditor && CHESSProfileManager.ARE_VIEWS_LOADED) {
            DiagramStatus diagramStatus = ((CHESSEditor)editor).getDiagramStatus();
            if (diagramStatus == null) {
                return null;
            }
            this.selected = !this.selected;
            diagramStatus.setSuperuser(this.selected);
            CHESSProjectSupport.printlnToCHESSConsole((String)("Superuser " + (this.selected ? "ON" : "OFF")));
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        CHESSEditor editor = CHESSEditorUtils.getCHESSEditor();
        if (editor != null && CHESSProfileManager.ARE_VIEWS_LOADED) {
            DiagramStatus st = editor.getDiagramStatus();
            this.selected = st.isSuperuser();
        }
        element.setChecked(this.selected);
        element.setText(this.selected ? this.checkedText : this.uncheckedText);
    }
}

