/*
 * Decompiled with CFR 0.152.
 */
package it.unipd.chess.editor.commands;

import it.unipd.chess.editor.CHESSEditor;
import it.unipd.chess.views.DiagramStatus;
import it.unipd.chess.views.ViewUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class SwitchSourceProvider
extends AbstractSourceProvider {
    public static final String SWITCH = "it.unipd.chess.editor.commands.switchState";
    private static final String DISABLED = "disabled";
    private String currentState = "disabled";
    public static List<String> commandsToRefresh = new ArrayList<String>();

    public void dispose() {
    }

    public Map getCurrentState() {
        HashMap<String, String> currentSt = new HashMap<String, String>(2);
        currentSt.put(SWITCH, this.currentState);
        return currentSt;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{SWITCH};
    }

    private void setEnabledValue(String v) {
        this.currentState = v;
        this.fireSourceChanged(0, SWITCH, v);
    }

    public void updateStatus(IEditorPart activeEditor) {
        try {
            if (activeEditor instanceof CHESSEditor) {
                DiagramStatus.DesignView currentView = ((CHESSEditor)activeEditor).getDiagramStatus().getCurrentView();
                if (currentView != null && (ViewUtils.hasConcurrentViews((DiagramStatus.DesignView)currentView) || ViewUtils.isConcurrentView((DiagramStatus.DesignView)currentView))) {
                    String name = ViewUtils.getBaseViewName((DiagramStatus.DesignView)currentView);
                    this.setEnabledValue(name);
                } else {
                    this.setEnabledValue(DISABLED);
                }
            } else {
                this.setEnabledValue(DISABLED);
            }
            this.refreshElements();
        }
        catch (Exception exception) {
            return;
        }
    }

    private void refreshElements() {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
        for (String commandId : commandsToRefresh) {
            service.refreshElements(commandId, null);
        }
    }
}

