/*
 * Decompiled with CFR 0.152.
 */
package it.unipd.chess.editor.commands;

import it.unipd.chess.editor.CHESSEditor;
import it.unipd.chess.editor.PaletteManager;
import it.unipd.chess.editor.commands.SwitchSourceProvider;
import it.unipd.chess.editor.utils.CHESSEditorUtils;
import it.unipd.chess.profiles.CHESSProfileManager;
import it.unipd.chess.views.DiagramStatus;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.ISourceProviderService;

public class SwitchToView {
    public String commandId;
    private String theView;
    String checkedText;
    String uncheckedText;
    private boolean selected = false;

    public SwitchToView(String theView, String commandId) {
        this.theView = theView;
        this.commandId = commandId;
        this.checkedText = "Deactivate " + theView;
        this.uncheckedText = "Activate " + theView;
        SwitchSourceProvider.commandsToRefresh.add(commandId);
    }

    public void refresh() {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
        service.refreshElements(this.commandId, null);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        if (editor instanceof CHESSEditor && CHESSProfileManager.ARE_VIEWS_LOADED) {
            DiagramStatus diagramStatus = ((CHESSEditor)editor).getDiagramStatus();
            if (diagramStatus == null) {
                return null;
            }
            IWorkbenchWindow window = editor.getSite().getWorkbenchWindow();
            ISourceProviderService spService = (ISourceProviderService)window.getService(ISourceProviderService.class);
            SwitchSourceProvider sp = (SwitchSourceProvider)spService.getSourceProvider("it.unipd.chess.editor.commands.switchState");
            this.selected = diagramStatus.requestView(this.theView, !this.selected);
            this.hideShowElements((CHESSEditor)editor);
            PaletteManager.setPaletteVisibility((CHESSEditor)editor, diagramStatus);
            sp.updateStatus(editor);
        }
        return null;
    }

    private void hideShowElements(CHESSEditor editor) {
    }

    public void updateElement(UIElement element, Map parameters) {
        CHESSEditor editor = CHESSEditorUtils.getCHESSEditor();
        if (editor != null && CHESSProfileManager.ARE_VIEWS_LOADED) {
            DiagramStatus st = editor.getDiagramStatus();
            this.selected = this.selected && st.getCurrentView().isEnabled(this.theView);
        }
        element.setChecked(this.selected);
        if (this.selected) {
            element.setText(this.checkedText);
        } else {
            element.setText(this.uncheckedText);
        }
    }
}

