/*
 * Decompiled with CFR 0.152.
 */
package it.unipd.chess.editor.utils;

import it.unipd.chess.editor.CHESSEditor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.uml2.uml.Port;

public class CHESSEditorUtils {
    public static DiagramCommandStack getDiagramCommandStack() {
        try {
            Object stack = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getAdapter(CommandStack.class);
            return stack instanceof DiagramCommandStack ? (DiagramCommandStack)stack : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Diagram getDiagram() {
        IMultiDiagramEditor editor = EditorUtils.getMultiDiagramEditor();
        return (Diagram)editor.getAdapter(Diagram.class);
    }

    public static DiagramEditPart getDiagramEditPart() {
        IMultiDiagramEditor editor = EditorUtils.getMultiDiagramEditor();
        return (DiagramEditPart)editor.getAdapter(DiagramEditPart.class);
    }

    public static IDiagramGraphicalViewer getDiagramGraphicalViewer() {
        DiagramEditPart diagramEP = CHESSEditorUtils.getDiagramEditPart();
        return (IDiagramGraphicalViewer)diagramEP.getViewer();
    }

    public static List<View> getDiagramAllVisiblePort(View diagram) {
        return CHESSEditorUtils.getDiagramAllVisiblePortRecur(new ArrayList<View>(), diagram);
    }

    private static List<View> getDiagramAllVisiblePortRecur(List<View> list, View view) {
        for (Object v : view.getVisibleChildren()) {
            if (!(v instanceof View)) continue;
            if (((View)v).getElement() instanceof Port) {
                list.add((View)v);
            }
            CHESSEditorUtils.getDiagramAllVisiblePortRecur(list, (View)v);
        }
        return list;
    }

    public static IEditorPart getEditor() {
        IEditorPart editor;
        try {
            editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        }
        catch (Exception exception) {
            editor = null;
        }
        return editor;
    }

    public static CHESSEditor getCHESSEditor() {
        IEditorPart editor = CHESSEditorUtils.getEditor();
        return editor != null && editor instanceof CHESSEditor ? (CHESSEditor)editor : null;
    }

    public static MessageDialog showConfirmDialog(EditorPart editor, String dialogTitle, String dialogMessage) {
        MessageDialog md = new MessageDialog(editor.getSite().getShell(), dialogTitle, null, dialogMessage, 5, new String[]{"OK", "No", "Cancel"}, 0);
        md.setBlockOnOpen(true);
        return md;
    }

    public static MessageDialog showYesNoDialog(EditorPart editor, String dialogTitle, String dialogMessage) {
        MessageDialog md = new MessageDialog(editor.getSite().getShell(), dialogTitle, null, dialogMessage, 5, new String[]{"Yes", "No"}, 0);
        md.setBlockOnOpen(true);
        return md;
    }

    public static int StatusDialog(EditorPart editor, String dialogTitle, String dialogMessage, IStatus st) {
        ErrorDialog er = new ErrorDialog(editor.getSite().getShell(), dialogTitle, dialogMessage, st, 4){

            protected void createButtonsForButtonBar(Composite parent) {
                this.createButton(parent, 2, IDialogConstants.YES_LABEL, true);
                this.createButton(parent, 3, IDialogConstants.NO_LABEL, true);
                this.createDetailsButton(parent);
            }

            protected void buttonPressed(int id) {
                if (id == 2) {
                    id = 0;
                }
                if (id == 3) {
                    this.setReturnCode(5);
                    this.close();
                } else {
                    super.buttonPressed(id);
                }
            }
        };
        return er.open();
    }

    public static void reopenEditor(IEditorPart editor, Boolean save) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = editor.getEditorSite().getPage();
                IEditorInput input = editor.getEditorInput();
                page.closeEditor(editor, save.booleanValue());
                try {
                    page.openEditor(input, CHESSEditor.ID, save.booleanValue());
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

