/*
 * Decompiled with CFR 0.152.
 */
package it.unipd.chess.m2m;

import it.unipd.chess.chessmlprofile.Predictability.DeploymentConfiguration.HardwareBaseline.CH_HwBus;
import it.unipd.chess.chessmlprofile.Predictability.DeploymentConfiguration.HardwareBaseline.CH_HwProcessor;
import it.unipd.chess.chessmlprofile.Predictability.RTComponentModel.CHRtSpecification;
import it.unipd.chess.editor.CHESSEditor;
import it.unipd.chess.editor.utils.CHESSEditorUtils;
import it.unipd.chess.m2m.TransUtil;
import it.unipd.chess.util.CHESSProjectSupport;
import it.unipd.chess.util.uml.ResourceUtils;
import it.unipd.chess.util.uml.UMLUtils;
import it.unipd.chess.views.ViewUtils;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ModelContent;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;

public class PurgePIMHandler
extends AbstractHandler {
    protected IEditorPart editor;

    private IProject getActiveProject(IEditorPart editor) {
        IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
        IFile file = input.getFile();
        return file.getProject();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        Job job = new Job("Transforming"){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        if (!(PurgePIMHandler.this.editor instanceof CHESSEditor)) {
                            return null;
                        }
                        Resource inResource = null;
                        try {
                            inResource = ResourceUtils.getUMLResource((ServicesRegistry)((CHESSEditor)PurgePIMHandler.this.editor).getServicesRegistry());
                        }
                        catch (ServiceException e) {
                            e.printStackTrace();
                            throw new Exception("Unable to load the model");
                        }
                        IFile modelFile = CHESSProjectSupport.resourceToFile((Resource)inResource);
                        ModelContent inModel = TransUtil.loadModel(modelFile);
                        Model m = (Model)inModel.getContent().get(0);
                        m = PurgePIMHandler.this.removeRtAnalysis(m);
                        m = PurgePIMHandler.this.resetStereotypeValues(m);
                        m.eResource().save(null);
                        CHESSEditorUtils.reopenEditor((IEditorPart)PurgePIMHandler.this.editor, (Boolean)false);
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    finally {
                        PurgePIMHandler.this.getActiveProject(PurgePIMHandler.this.editor).refreshLocal(2, monitor);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return new Status(4, "it.unipd.chess.m2m", 1, "Error in transformation " + e.getMessage(), null);
                }
                if (!monitor.isCanceled()) return Status.OK_STATUS;
                return Status.CANCEL_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    CHESSProjectSupport.printlnToCHESSConsole((String)"Job completed successfully");
                } else {
                    CHESSProjectSupport.printlnToCHESSConsole((String)"Job did not complete successfully");
                }
            }
        });
        job.setPriority(20);
        job.schedule();
        return null;
    }

    private Model resetStereotypeValues(Model m) {
        Package rt = ViewUtils.getCHESSComponentPackage((Model)m);
        for (Element e : rt.allOwnedElements()) {
            CHRtSpecification s;
            if (!(e instanceof Comment) || (s = (CHRtSpecification)UMLUtils.getStereotypeApplication((Element)e, CHRtSpecification.class)) == null) continue;
            CHESSProjectSupport.printlnToCHESSConsole((String)("Resetting:" + e));
            s.getBlockT().clear();
            s.getRespT().clear();
        }
        rt = ViewUtils.getCHESSDeploymentPackage((Model)m);
        for (Element e : rt.allOwnedElements()) {
            CH_HwBus bu;
            if (!(e instanceof InstanceSpecification)) continue;
            CH_HwProcessor pr = (CH_HwProcessor)UMLUtils.getStereotypeApplication((Element)e, CH_HwProcessor.class);
            if (pr != null) {
                pr.setUtilization(null);
                CHESSProjectSupport.printlnToCHESSConsole((String)("Resetting:" + e));
            }
            if ((bu = (CH_HwBus)UMLUtils.getStereotypeApplication((Element)e, CH_HwBus.class)) == null) continue;
            bu.setUtilization(null);
            CHESSProjectSupport.printlnToCHESSConsole((String)("Resetting:" + e));
        }
        return m;
    }

    private Model removeRtAnalysis(Model m) {
        Package rt = ViewUtils.getCHESSRtAnalysisPackage((Model)m);
        System.out.println(rt.getName());
        ArrayList<Element> l = new ArrayList<Element>();
        for (Element e : rt.getOwnedElements()) {
            if (!(e instanceof Package)) continue;
            l.add(e);
            CHESSProjectSupport.printlnToCHESSConsole((String)("Removing:" + ((Package)e).getName()));
        }
        int i = 0;
        while (i < l.size()) {
            ((Element)l.get(i)).destroy();
            ++i;
        }
        return m;
    }
}

