/*
 * Decompiled with CFR 0.152.
 */
package it.unipd.chess.m2m;

import it.unipd.chess.chessmlprofile.Predictability.DeploymentConfiguration.HardwareBaseline.CH_HwProcessor;
import it.unipd.chess.chessmlprofile.Predictability.RTComponentModel.CHRtPortSlot;
import it.unipd.chess.editor.CHESSEditor;
import it.unipd.chess.editor.utils.CHESSEditorUtils;
import it.unipd.chess.m2m.SchedResultDialog;
import it.unipd.chess.m2m.TransUtil;
import it.unipd.chess.m2m.TransformationResultsData;
import it.unipd.chess.m2m.transformations.PIMPSMTransformationVERDE;
import it.unipd.chess.util.CHESSProjectSupport;
import it.unipd.chess.util.uml.ResourceUtils;
import it.unipd.chess.util.uml.UMLUtils;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ModelContent;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Model;

public class QVToUIHandlerVERDE
extends AbstractHandler {
    private IProject getActiveProject(IEditorPart editor) {
        IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
        IFile file = input.getFile();
        return file.getProject();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!(editor instanceof CHESSEditor)) {
            return null;
        }
        Job job = new Job("Transforming"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    editor.getEditorSite().getPage();
                    TransformationResultsData result = null;
                    try {
                        result = QVToUIHandlerVERDE.this.execute_(editor, monitor);
                        CHESSEditorUtils.reopenEditor((IEditorPart)editor, (Boolean)false);
                    }
                    finally {
                        QVToUIHandlerVERDE.this.getActiveProject(editor).refreshLocal(2, monitor);
                    }
                    try {
                        ModelContent inModel = TransUtil.loadModel(result.umlFile);
                        Model model = (Model)inModel.getContent().get(0);
                        QVToUIHandlerVERDE.this.openSchedAnalysisReport(model, result.res);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new Exception("Unable to load the model and so open the schedAnalysisReport");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return new Status(4, "it.unipd.chess.m2m", 1, "Error in transformation " + e.getMessage(), null);
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    CHESSProjectSupport.printlnToCHESSConsole((String)"Job completed successfully");
                } else {
                    CHESSProjectSupport.printlnToCHESSConsole((String)"Job did not complete successfully");
                }
            }
        });
        job.setUser(true);
        job.setPriority(20);
        job.schedule();
        return null;
    }

    public TransformationResultsData execute_(IEditorPart editor, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Transforming", 4);
        if (!(editor instanceof CHESSEditor)) {
            return null;
        }
        Resource inResource = null;
        try {
            inResource = ResourceUtils.getUMLResource((ServicesRegistry)((CHESSEditor)editor).getServicesRegistry());
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw new Exception("Unable to load the model");
        }
        IFile inputFile = CHESSProjectSupport.resourceToFile((Resource)inResource);
        PIMPSMTransformationVERDE t = new PIMPSMTransformationVERDE();
        TransformationResultsData result = t.performTransformation((CHESSEditor)editor, inputFile, monitor);
        return result;
    }

    public void openSchedAnalysisReport(Model model, final String result) {
        if (result == null) {
            return;
        }
        final ArrayList<CHRtPortSlot> specifications = new ArrayList<CHRtPortSlot>();
        final ArrayList<CH_HwProcessor> cpus = new ArrayList<CH_HwProcessor>();
        for (Element elem : model.allOwnedElements()) {
            CH_HwProcessor chHwProc;
            CHRtPortSlot chrtSlot = (CHRtPortSlot)UMLUtils.getStereotypeApplication((Element)elem, CHRtPortSlot.class);
            if (chrtSlot != null) {
                specifications.add(chrtSlot);
            }
            if (!(elem instanceof InstanceSpecification) || (chHwProc = (CH_HwProcessor)UMLUtils.getStereotypeApplication((Element)elem, CH_HwProcessor.class)) == null) continue;
            cpus.add(chHwProc);
        }
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = new Shell(display);
                SchedResultDialog dialog = new SchedResultDialog(shell, result, specifications, cpus);
                if (dialog.open() == 0) {
                    System.out.println("OK");
                }
            }
        });
    }
}

