/*
 * Decompiled with CFR 0.152.
 */
package it.unipd.chess.m2m;

import it.unipd.chess.Activator;
import it.unipd.chess.chessmlprofile.Predictability.DeploymentConfiguration.HardwareBaseline.CH_HwProcessor;
import it.unipd.chess.chessmlprofile.Predictability.RTComponentModel.CHRtPortSlot;
import it.unipd.chess.chessmlprofile.Predictability.RTComponentModel.CHRtSpecification;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.osgi.framework.Bundle;

public class SchedResultDialog
extends Dialog {
    private Shell shell;
    private String result;
    private List<CHRtPortSlot> specifications;
    private List<CH_HwProcessor> cpus;

    public SchedResultDialog(Shell parentShell, String result, List<CHRtPortSlot> specifications, List<CH_HwProcessor> cpus) {
        super(parentShell);
        this.shell = parentShell;
        this.result = result;
        this.specifications = specifications;
        this.cpus = cpus;
        Image image = null;
        URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("/resources/CHESSicon.gif"), null);
        try {
            url = FileLocator.toFileURL((URL)url);
            image = Activator.getImageDescriptor((String)url.toString()).createImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Dialog.setDefaultImage(image);
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        layout.marginBottom = 5;
        layout.marginTop = 5;
        parent.setLayout((Layout)layout);
        Display display = this.shell.getDisplay();
        Color green = display.getSystemColor(5);
        Color red = display.getSystemColor(3);
        Label resultLabel = new Label(parent, 0);
        resultLabel.setFont(new Font((Device)display, "Tahoma", 14, 1));
        if (this.result != null) {
            resultLabel.setText(this.result);
        }
        Table cpuTable = new Table(parent, 2064);
        cpuTable.setLinesVisible(true);
        cpuTable.setHeaderVisible(true);
        GridData data = new GridData(4, 1, true, false, 1, 1);
        cpuTable.setLayoutData((Object)data);
        String[] cpuTitles = new String[]{"HW Instance", "Utilization", "Result"};
        int i = 0;
        while (i < cpuTitles.length) {
            TableColumn column = new TableColumn(cpuTable, 0);
            column.setText(cpuTitles[i]);
            ++i;
        }
        for (CH_HwProcessor processor : this.cpus) {
            TableItem item = new TableItem(cpuTable, 0);
            String utilization = processor.getUtilization();
            if (utilization == null) continue;
            item.setText(0, processor.getBase_InstanceSpecification().getName());
            String utilValue = SchedResultDialog.getValue(utilization, "value");
            item.setText(1, String.valueOf(utilValue) + "%");
            if (Float.parseFloat(utilValue) <= 100.0f) {
                item.setText(2, "OK");
                item.setForeground(2, green);
                continue;
            }
            item.setText(2, "NOT OK: utiliaztion over 100%");
            item.setForeground(2, red);
        }
        i = 0;
        while (i < cpuTitles.length) {
            cpuTable.getColumn(i).pack();
            ++i;
        }
        Table slotTable = new Table(parent, 2064);
        slotTable.setLinesVisible(true);
        slotTable.setHeaderVisible(true);
        data = new GridData(4, 1, true, false, 1, 1);
        slotTable.setLayoutData((Object)data);
        String[] slotTitles = new String[]{"SW Instance", "Operation", "Response Time", "Deadline", "Result"};
        int i2 = 0;
        while (i2 < slotTitles.length) {
            TableColumn column = new TableColumn(slotTable, 0);
            column.setText(slotTitles[i2]);
            ++i2;
        }
        for (CHRtPortSlot slot : this.specifications) {
            EList specifications = slot.getCH_RtSpecification();
            for (CHRtSpecification spec : specifications) {
                double conv;
                if (spec.getRlDl() == null || spec.getRlDl().isEmpty()) continue;
                TableItem item = new TableItem(slotTable, 0);
                item.setText(0, slot.getBase_Slot().getOwningInstance().getName());
                item.setText(1, spec.getContext().getName());
                String rldl = spec.getRlDl();
                String rldlUnit = SchedResultDialog.getValue(rldl, "unit");
                String rldlValue = SchedResultDialog.getValue(rldl, "value");
                String deadline = String.valueOf(rldlValue) + rldlUnit;
                item.setText(3, deadline);
                String respT = "";
                String respUnit = "";
                String respValue = "";
                if (spec.getRespT().size() > 0) {
                    respT = (String)spec.getRespT().get(0);
                    respUnit = SchedResultDialog.getValue(respT, "unit");
                    respValue = SchedResultDialog.getValue(respT, "worst");
                }
                if (respValue != null && !respValue.isEmpty() && rldlUnit.equals("ms")) {
                    conv = Float.parseFloat(respValue) * 1000.0f;
                    conv = (double)Math.round(conv * 100.0) / 100.0;
                    respValue = Double.toString(conv);
                    respUnit = "ms";
                }
                if (respValue != null && !respValue.isEmpty() && rldlUnit.equals("us")) {
                    conv = Float.parseFloat(respValue) * 1000000.0f;
                    conv = (double)Math.round(conv * 100.0) / 100.0;
                    respValue = Double.toString(conv);
                    respUnit = "us";
                }
                String responseTime = String.valueOf(respValue) + respUnit;
                item.setText(2, responseTime);
                if (respValue.isEmpty() || rldlValue.isEmpty()) continue;
                if (Float.parseFloat(respValue) <= Float.parseFloat(rldlValue)) {
                    item.setText(4, "OK");
                    item.setForeground(4, green);
                    continue;
                }
                item.setText(4, "NOT OK: Response Time > Deadline");
                item.setForeground(4, red);
            }
        }
        i = 0;
        while (i < slotTitles.length) {
            slotTable.getColumn(i).pack();
            ++i;
        }
        return super.createDialogArea(parent);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Schedulability Analysis Report");
        shell.setSize(650, 250);
        Monitor primary = shell.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        shell.setLocation(x, y);
    }

    protected boolean isResizable() {
        return true;
    }

    private static String getValue(String s, String match) {
        String[] splits;
        if (s == null) {
            return "";
        }
        String found = null;
        String[] stringArray = splits = s.split(",");
        int n = splits.length;
        int n2 = 0;
        while (n2 < n) {
            String split = stringArray[n2];
            if (split.contains(match)) {
                String[] ssplits;
                String[] stringArray2 = ssplits = split.split("=");
                int n3 = ssplits.length;
                int n4 = 0;
                while (n4 < n3) {
                    String str = stringArray2[n4];
                    if (!str.contains(match)) {
                        found = str;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (found != null) {
            if ((found = found.trim()).startsWith("(")) {
                found = found.substring(1, found.length());
            }
            if (found.endsWith(")")) {
                found = found.substring(0, found.length() - 1);
            }
        }
        return found;
    }
}

