/*
 * Decompiled with CFR 0.152.
 */
package it.unipd.chess.m2m;

import it.unipd.chess.editor.CHESSEditor;
import it.unipd.chess.m2m.AcceleoMarte2mast;
import it.unipd.chess.m2m.QVToTransformation;
import it.unipd.chess.m2m.TransUtil;
import it.unipd.chess.m2m.TransformationResultsData;
import it.unipd.chess.m2m.backpropagation.Backpropagation;
import it.unipd.chess.m2m.backpropagation.BackpropagationFull;
import it.unipd.chess.m2m.backpropagation.BackpropagationFullVERDE;
import it.unipd.chess.util.CHESSProjectSupport;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;

public class Transformations {
    public static String performPIMPSMTransformation(CHESSEditor editor, IFile model, IProgressMonitor monitor) throws Exception {
        IFolder transDir = model.getProject().getFolder("schedulability_analysis");
        CHESSProjectSupport.deleteFolder((IFolder)transDir);
        CHESSProjectSupport.createFolder((IFolder)transDir);
        IFile modelCopy = CHESSProjectSupport.copyFile((IFile)model, (String)"schedulability_analysis", (String)model.getName());
        TransUtil.purgeModel(modelCopy);
        QVToTransformation.launchBuildMultiInstance(modelCopy, monitor);
        QVToTransformation.launchPIM2PSM(modelCopy, monitor);
        String result = AcceleoMarte2mast.runMarte2Mast(modelCopy, (IContainer)transDir, monitor);
        Backpropagation.processQVTOTraceFile(editor, modelCopy);
        QVToTransformation.launchRemoveMultiInstance(modelCopy, monitor);
        CHESSProjectSupport.fileReplace((IFile)modelCopy, (IFile)model);
        return result;
    }

    public static String performPIMPSMTransformationFull(CHESSEditor editor, IFile model, IProgressMonitor monitor) throws Exception {
        IFolder transDir = model.getProject().getFolder("schedulability_analysis_full");
        CHESSProjectSupport.deleteFolder((IFolder)transDir);
        CHESSProjectSupport.createFolder((IFolder)transDir);
        IFile modelCopy = CHESSProjectSupport.copyFile((IFile)model, (String)"schedulability_analysis_full", (String)model.getName());
        TransUtil.purgeModel(modelCopy);
        QVToTransformation.launchBuildMultiInstance(modelCopy, monitor);
        QVToTransformation.launchPIM2PSMFull(modelCopy, monitor);
        String result = AcceleoMarte2mast.runMarte2Mast(modelCopy, (IContainer)transDir, monitor);
        BackpropagationFull.processQVTOTraceFile(editor, modelCopy);
        QVToTransformation.launchRemoveMultiInstance(modelCopy, monitor);
        CHESSProjectSupport.fileReplace((IFile)modelCopy, (IFile)model);
        return result;
    }

    public static TransformationResultsData performPIMPSMTransformationVERDE(CHESSEditor editor, IFile model, IProgressMonitor monitor) throws Exception {
        IFolder transDir = model.getProject().getFolder("schedulability_analysis_full_VERDE");
        CHESSProjectSupport.deleteFolder((IFolder)transDir);
        CHESSProjectSupport.createFolder((IFolder)transDir);
        IFile modelCopy = CHESSProjectSupport.copyFile((IFile)model, (String)"schedulability_analysis_full_VERDE", (String)model.getName());
        TransUtil.purgeModel(modelCopy);
        QVToTransformation.launchBuildMultiInstance(modelCopy, monitor);
        QVToTransformation.launchPIM2PSMVERDE(modelCopy, monitor);
        String result = AcceleoMarte2mast.runMarte2Mast(modelCopy, (IContainer)transDir, monitor);
        BackpropagationFullVERDE.processQVTOTraceFile(editor, modelCopy);
        QVToTransformation.launchRemoveMultiInstance(modelCopy, monitor);
        CHESSProjectSupport.fileReplace((IFile)modelCopy, (IFile)model);
        return new TransformationResultsData(result, model);
    }
}

