/*
 * Decompiled with CFR 0.152.
 */
package it.unipd.chess.m2m.blackbox;

import it.unipd.chess.chessmlprofile.Core.IdentifInstance;
import it.unipd.chess.chessmlprofile.Core.IdentifSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;
import org.eclipse.m2m.qvt.oml.util.IContext;
import org.eclipse.papyrus.MARTE.MARTE_AnalysisModel.SAM.SaSharedResource;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.SRM.SW_Interaction.SwMutualExclusionResource;
import org.eclipse.papyrus.MARTE.MARTE_Foundations.Alloc.Assign;
import org.eclipse.papyrus.MARTE.MARTE_Foundations.GRM.MutualExclusionResource;
import org.eclipse.papyrus.MARTE.MARTE_Foundations.NFPs.NfpConstraint;
import org.eclipse.papyrus.MARTE_Library.GRM_BasicTypes.ProtectProtocolKind;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Slot;

public class VSLUtils {
    @Operation(kind=Operation.Kind.HELPER, contextual=true, withExecutionContext=true)
    public static String getArrivalPatternType(IContext context, String self) {
        String regex = "(\\w*)\\s*\\((.*)\\)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(self);
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        context.getLog().log("No ArrivalPattern detected");
        return null;
    }

    private static boolean isRealNumber(String n) {
        try {
            Double.parseDouble(n);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Operation(kind=Operation.Kind.OPERATION, contextual=true, withExecutionContext=true)
    public static String normalizeNFPInteger(IContext context, String self) {
        if (self == null) {
            return "(value = 0)";
        }
        try {
            return "(value = " + Integer.valueOf(self).toString() + ")";
        }
        catch (Exception exception) {
            self = VSLUtils.parseGetFirstValidVSL(self);
            if (self == null) {
                return "(value = 0)";
            }
            String regex = "\\(([^\\(\\)]*)\\)";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(self);
            if (!matcher.find()) {
                return "MALFORMED INPUT";
            }
            return "(value = " + VSLUtils.parseInteger(matcher.group(1), "value") + ")";
        }
    }

    private static String parseGetFirstValidVSL(String inputText) {
        String regexStatQ;
        String inText;
        Vector<String> splittedText = new Vector<String>();
        String outText = null;
        if (inputText == null) {
            return null;
        }
        String regex = "(\\(.*?\\))";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(inputText);
        while (matcher.find()) {
            if (matcher.groupCount() <= 0) continue;
            splittedText.add(matcher.group(1));
        }
        if (splittedText == null || splittedText.size() == 0) {
            return null;
        }
        int i = 0;
        while (i < splittedText.size()) {
            inText = (String)splittedText.get(i);
            regexStatQ = "statQ\\s*=\\s*calc";
            pattern = Pattern.compile(regexStatQ);
            matcher = pattern.matcher(inText);
            if (!matcher.find()) {
                return inText;
            }
            ++i;
        }
        i = 0;
        while (i < splittedText.size()) {
            inText = (String)splittedText.get(i);
            regexStatQ = "statQ\\s*=\\s*calc";
            pattern = Pattern.compile(regexStatQ);
            matcher = pattern.matcher(inText);
            if (matcher.find()) {
                return inText;
            }
            ++i;
        }
        splittedText.clear();
        return outText;
    }

    private static String parseInteger(String propertiesText, String propertyName) {
        if (propertiesText == null) {
            return "MALFORMED INPUT";
        }
        if (propertyName.equals("value")) {
            String regex = "\\s*" + propertyName + "\\s*=\\s*(\\d+)";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(propertiesText);
            if (!matcher.find()) {
                return "MALFORMED INPUT";
            }
            return matcher.group(1);
        }
        if (propertyName.equals("source")) {
            String regex = "\\s*source\\s*=\\s*(est|meas|calc|req)";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(propertiesText);
            if (!matcher.find()) {
                return "MALFORMED INPUT";
            }
            return matcher.group(1);
        }
        if (propertyName.equals("statQ")) {
            String regex = "\\s*statQ\\s*=\\s*(min|max)";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(propertiesText);
            if (!matcher.find()) {
                return "MALFORMED INPUT";
            }
            return matcher.group(1);
        }
        return "NOT IMPLEMENTED";
    }

    @Operation(kind=Operation.Kind.HELPER, contextual=true, withExecutionContext=true)
    public static String parseNFPDuration(IContext context, String self, String propertyName) {
        if (self == null) {
            return "MALFORMED INPUT";
        }
        if ((self = VSLUtils.parseGetFirstValidVSL(self)) == null) {
            return "MALFORMED INPUT";
        }
        String regex = "\\((.*)\\)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(self);
        if (!matcher.find()) {
            context.getLog().log("WARNING: can't parse NFP_Duration ");
            return "MALFORMED INPUT";
        }
        String propertiesText = matcher.group(1);
        if (propertyName.equals("source")) {
            regex = "\\s*source\\s*=\\s*([est|meas|calc|req])";
            pattern = Pattern.compile(regex);
            matcher = pattern.matcher(propertiesText);
            if (!matcher.find()) {
                context.getLog().log("WARNING: NFP_Duration doesn't have a valid value for \"source\" ");
                return "MALFORMED INPUT";
            }
            return matcher.group(1);
        }
        if (propertyName.equals("value") || propertyName.equals("best") || propertyName.equals("worst")) {
            String theUnit;
            regex = "\\s*" + propertyName + "\\s*=\\s*(\\d+\\.*\\d*)";
            pattern = Pattern.compile(regex);
            matcher = pattern.matcher(propertiesText);
            if (!matcher.find()) {
                context.getLog().log("WARNING: can't parse NFP_Duration ");
                return "MALFORMED INPUT";
            }
            String theValue = matcher.group(1);
            regex = "\\s*" + propertyName + "\\s*=\\s*(\\d+\\.+\\d+)";
            pattern = Pattern.compile(regex);
            matcher = pattern.matcher(propertiesText);
            if (!matcher.find()) {
                theValue = String.valueOf(theValue) + ".0";
            }
            if ((theUnit = (matcher = (pattern = Pattern.compile(regex = "\\s*unit\\s*=\\s*(\\w+)")).matcher(propertiesText)).find() ? matcher.group(1) : "s").equals("s")) {
                return theValue;
            }
            if (theUnit.equals("ms")) {
                return String.valueOf(theValue) + "E-3";
            }
            if (theUnit.equals("us")) {
                return String.valueOf(theValue) + "E-6";
            }
            if (theUnit.equals("ns")) {
                return String.valueOf(theValue) + "E-9";
            }
            context.getLog().log("WARNING: can't parse NFP_Duration ");
            return "MALFORMED INPUT";
        }
        context.getLog().log("WARNING: can't parse NFP_Duration ");
        return "NOT IMPLEMENTED";
    }

    @Operation(kind=Operation.Kind.OPERATION, contextual=true, withExecutionContext=true)
    public static String parseNFPReal(IContext context, String self, String propertyName) {
        if (self == null) {
            return "MALFORMED INPUT";
        }
        try {
            return Double.valueOf(self).toString();
        }
        catch (Exception exception) {
            self = VSLUtils.parseGetFirstValidVSL(self);
            if (self == null) {
                return "MALFORMED INPUT";
            }
            String regex = "\\((.*)\\)";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(self);
            if (!matcher.find()) {
                return "MALFORMED INPUT";
            }
            if (matcher.groupCount() < 1) {
                return "";
            }
            String propertiesText = matcher.group(1);
            regex = "\\s*" + propertyName + "\\s*=\\s*(\\d+\\.*\\d*)";
            pattern = Pattern.compile(regex);
            matcher = pattern.matcher(propertiesText);
            if (!matcher.find()) {
                return "MALFORMED INPUT";
            }
            return matcher.group(1);
        }
    }

    @Operation(kind=Operation.Kind.OPERATION, contextual=true, withExecutionContext=true)
    public static void setCeiling(IContext context, Class self, String ceiling) {
        if (ceiling == null) {
            return;
        }
        if (ceiling.isEmpty()) {
            return;
        }
        for (EObject e : self.getStereotypeApplications()) {
            if (!(e instanceof SaSharedResource)) continue;
            SaSharedResource s = (SaSharedResource)e;
            if (!VSLUtils.isRealNumber(ceiling)) {
                ceiling = VSLUtils.parseNFPReal(context, ceiling, "value");
            }
            s.setCeiling(ceiling);
        }
    }

    @Operation(kind=Operation.Kind.OPERATION, contextual=true, withExecutionContext=true)
    public static void setCeiling2(IContext context, Class self, String ceiling) {
        if (ceiling == null) {
            return;
        }
        if (ceiling.isEmpty()) {
            return;
        }
        for (EObject e : self.getStereotypeApplications()) {
            if (!(e instanceof SwMutualExclusionResource)) continue;
            SwMutualExclusionResource s = (SwMutualExclusionResource)e;
            if (!VSLUtils.isRealNumber(ceiling)) {
                ceiling = VSLUtils.parseNFPReal(context, ceiling, "value");
            }
            s.setCeiling(ceiling);
        }
    }

    @Operation(kind=Operation.Kind.OPERATION, contextual=true, withExecutionContext=true)
    public static void setCeiling3(IContext context, Class self, String ceiling) {
        if (ceiling == null) {
            return;
        }
        if (ceiling.isEmpty()) {
            return;
        }
        for (EObject e : self.getStereotypeApplications()) {
            if (!(e instanceof MutualExclusionResource)) continue;
            MutualExclusionResource s = (MutualExclusionResource)e;
            if (!VSLUtils.isRealNumber(ceiling)) {
                ceiling = VSLUtils.parseNFPReal(context, ceiling, "value");
            }
            s.setCeiling(ceiling);
        }
    }

    @Operation(kind=Operation.Kind.OPERATION, contextual=true, withExecutionContext=true)
    public static void setProtectKind(IContext context, Class self, String type) {
        for (EObject e : self.getStereotypeApplications()) {
            if (!(e instanceof SaSharedResource)) continue;
            SaSharedResource s = (SaSharedResource)e;
            ProtectProtocolKind a = ProtectProtocolKind.getByName((String)type);
            s.setProtectKind(a);
        }
    }

    @Operation(kind=Operation.Kind.OPERATION, contextual=true, withExecutionContext=true)
    public static void setProtectKind2(IContext context, Class self, String type) {
        for (EObject e : self.getStereotypeApplications()) {
            if (!(e instanceof SwMutualExclusionResource)) continue;
            SwMutualExclusionResource s = (SwMutualExclusionResource)e;
            ProtectProtocolKind a = ProtectProtocolKind.getByName((String)type);
            s.setProtectKind(a);
        }
    }

    @Operation(kind=Operation.Kind.OPERATION, contextual=true, withExecutionContext=true)
    public static void setProtectKind3(IContext context, Class self, String type) {
        for (EObject e : self.getStereotypeApplications()) {
            if (!(e instanceof MutualExclusionResource)) continue;
            MutualExclusionResource s = (MutualExclusionResource)e;
            ProtectProtocolKind a = ProtectProtocolKind.getByName((String)type);
            s.setProtectKind(a);
        }
    }

    @Operation(kind=Operation.Kind.HELPER, contextual=true, withExecutionContext=true)
    public static EList<Slot> portToSlotsByRule(IContext context, InstanceSpecification self, Port onPort, Constraint rule) {
        BasicEList list = new BasicEList();
        String[] values = rule.getSpecification().stringValue().trim().split(" ");
        ArrayList<int[]> boundsList = new ArrayList<int[]>();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            boundsList.add(VSLUtils.getBounds(value));
            ++n2;
        }
        for (Slot slot : self.getSlots()) {
            IdentifSlot id = VSLUtils.getStereotypeApplication((Element)slot, IdentifSlot.class);
            if (id != null && slot.getDefiningFeature() == onPort && VSLUtils.isInBounds(id.getId(), boundsList).booleanValue()) {
                list.add((Object)slot);
                continue;
            }
            if (slot.getDefiningFeature() != onPort) continue;
            list.add((Object)slot);
        }
        return list;
    }

    @Operation(kind=Operation.Kind.HELPER, contextual=true, withExecutionContext=true)
    public static EList<InstanceSpecification> getInstances(IContext context, Comment self, Package inst, Package instFull) {
        BasicEList list = new BasicEList();
        Assign ass = VSLUtils.getStereotypeApplication((Element)self, Assign.class);
        InstanceSpecification originatingInst = (InstanceSpecification)ass.getFrom().get(0);
        if (originatingInst == null) {
            return list;
        }
        if (!inst.allOwnedElements().contains((Object)originatingInst)) {
            return list;
        }
        int[] bounds = VSLUtils.getBounds(self);
        if (bounds != null) {
            for (Element el : instFull.allOwnedElements()) {
                IdentifInstance id = VSLUtils.getStereotypeApplication(el, IdentifInstance.class);
                if (!(el instanceof InstanceSpecification) || id == null || !VSLUtils.isInBounds(id.getId(), bounds).booleanValue() || id.getSourceInstanceSpec() != originatingInst) continue;
                list.add((Object)((InstanceSpecification)el));
            }
        } else {
            for (Element el : instFull.allOwnedElements()) {
                IdentifInstance id = VSLUtils.getStereotypeApplication(el, IdentifInstance.class);
                if (!(el instanceof InstanceSpecification) || id == null || id.getSourceInstanceSpec() != originatingInst) continue;
                list.add((Object)((InstanceSpecification)el));
            }
        }
        return list;
    }

    @Operation(kind=Operation.Kind.HELPER, contextual=true, withExecutionContext=true)
    public static Boolean isReferringId(IContext context, Comment self, Integer id) {
        int[] bounds = VSLUtils.getBounds(self);
        if (bounds == null) {
            return true;
        }
        return VSLUtils.isInBounds((int)id, bounds);
    }

    private static Boolean isInBounds(int id, int[] bounds) {
        if (id >= bounds[0] && id <= bounds[1]) {
            return true;
        }
        return false;
    }

    private static Boolean isInBounds(int id, List<int[]> bounds) {
        for (int[] b : bounds) {
            if (!VSLUtils.isInBounds(id, b).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static int[] getBounds(Comment comment) {
        if (!comment.getAnnotatedElements().isEmpty()) {
            Constraint a = VSLUtils.getNfpConstraint((EList<Element>)comment.getAnnotatedElements());
            String value = a.getSpecification().stringValue();
            return VSLUtils.getBounds(value);
        }
        return null;
    }

    private static int[] getBounds(String value) {
        String regex = "\\s*\\[\\s*(\\d+)\\s*\\.*\\s*(\\d+)\\]\\s*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(value);
        int[] b = new int[2];
        if (matcher.find() && matcher.groupCount() == 2) {
            String begin_ = matcher.group(1);
            String end_ = matcher.group(2);
            b[0] = Integer.parseInt(begin_);
            b[1] = Integer.parseInt(end_);
            return b;
        }
        regex = "\\s*\\[\\s*(\\d+)\\s*\\]\\s*";
        pattern = Pattern.compile(regex);
        matcher = pattern.matcher(value);
        if (matcher.find() && matcher.groupCount() == 1) {
            String begin_ = matcher.group(1);
            b[0] = Integer.parseInt(begin_);
            b[1] = b[0];
            return b;
        }
        regex = "\\s*(\\d+)\\s*";
        pattern = Pattern.compile(regex);
        matcher = pattern.matcher(value);
        if (matcher.find() && matcher.groupCount() == 1) {
            String begin_ = matcher.group(1);
            b[0] = Integer.parseInt(begin_);
            b[1] = b[0];
            return b;
        }
        return null;
    }

    private static Constraint getNfpConstraint(EList<Element> list) {
        for (Element element : list) {
            if (!(element instanceof Constraint) || VSLUtils.getStereotypeApplication(element, NfpConstraint.class) == null) continue;
            return (Constraint)element;
        }
        return null;
    }

    private static <T extends EObject> T getStereotypeApplication(Element element, java.lang.Class<T> stereotypeClass) {
        for (EObject stereoApplication : element.getStereotypeApplications()) {
            if (!stereotypeClass.isInstance(stereoApplication)) continue;
            return (T)stereoApplication;
        }
        return null;
    }
}

