/*
 * Decompiled with CFR 0.152.
 */
package it.unipd.chess.m2m.transformations;

import it.unipd.chess.editor.CHESSEditor;
import it.unipd.chess.m2m.AcceleoMarte2mastProxy;
import it.unipd.chess.m2m.QVToTransformation;
import it.unipd.chess.m2m.TransUtil;
import it.unipd.chess.m2m.TransformationResultsData;
import it.unipd.chess.util.CHESSProjectSupport;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractTransformation {
    String folder = "schedulability_analysis";
    IFolder transDir;

    protected IFile s1(IFile model) throws Exception {
        this.transDir = model.getProject().getFolder(this.folder);
        CHESSProjectSupport.deleteFolder((IFolder)this.transDir);
        CHESSProjectSupport.createFolder((IFolder)this.transDir);
        IFile modelCopy = CHESSProjectSupport.copyFile((IFile)model, (String)this.folder, (String)model.getName());
        TransUtil.purgeModel(modelCopy);
        return modelCopy;
    }

    public TransformationResultsData performTransformation(CHESSEditor editor, IFile model, IProgressMonitor monitor) throws Exception {
        IFile modelCopy = this.s1(model);
        QVToTransformation.launchBuildMultiInstance(modelCopy, monitor);
        this.build1(monitor, modelCopy);
        String result = this.build2(monitor, modelCopy, editor);
        QVToTransformation.launchRemoveMultiInstance(modelCopy, monitor);
        CHESSProjectSupport.fileReplace((IFile)modelCopy, (IFile)model);
        return new TransformationResultsData(result, model);
    }

    protected abstract void build1(IProgressMonitor var1, IFile var2) throws Exception;

    protected abstract void backpropagation(CHESSEditor var1, IFile var2) throws Exception;

    protected String build2(IProgressMonitor monitor, IFile modelCopy, CHESSEditor editor) throws Exception {
        try {
            String result = AcceleoMarte2mastProxy.runMarte2Mast(modelCopy, this.transDir, monitor);
            this.backpropagation(editor, modelCopy);
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

