/*
 * Decompiled with CFR 0.152.
 */
package it.unipd.chess.transformationExecutor;

import it.unipd.chess.transformationExecutor.ITransformationExecutor;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class TransformationExecutorManager {
    private Hashtable<String, ITransformationExecutor> executorRegistry = new Hashtable();
    private String LISTENERID_EXTENSION_ID = "it.unipd.chess.transformationExecutor";
    private String NAME_ID = "name";
    private String REALIZATION_ID = "realization";
    private static TransformationExecutorManager instance;

    public static TransformationExecutorManager instance() {
        if (instance == null) {
            instance = new TransformationExecutorManager();
        }
        return instance;
    }

    private TransformationExecutorManager() {
        this.initializeExecutorList();
    }

    private void initializeExecutorList() {
        Platform.getExtensionRegistry();
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(this.LISTENERID_EXTENSION_ID);
        int i = 0;
        while (i < configElements.length) {
            this.inializeOneRule(configElements[i]);
            ++i;
        }
    }

    private void inializeOneRule(IConfigurationElement element) {
        String listenerName = element.getAttribute(this.NAME_ID);
        try {
            ITransformationExecutor listener = (ITransformationExecutor)TransformationExecutorManager.createExtension(element, element.getAttribute(this.REALIZATION_ID));
            this.executorRegistry.put(listenerName, listener);
        }
        catch (Exception exception) {}
    }

    private static Object createExtension(IConfigurationElement element, String classAttribute) throws Exception {
        try {
            Bundle extensionBundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespaceIdentifier());
            Class clazz = extensionBundle.loadClass(classAttribute);
            Object obj = clazz.newInstance();
            return obj;
        }
        catch (Exception e) {
            throw new Exception("unable to create Extension " + e);
        }
    }

    public ITransformationExecutor getExecutor(String name) {
        return this.executorRegistry.get(name);
    }

    public static void init() {
        TransformationExecutorManager.instance();
    }
}

