/*
 * Decompiled with CFR 0.152.
 */
package it.unipd.chess.util;

import it.unipd.chess.Activator;
import it.unipd.chess.natures.CHESSNature;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.osgi.framework.Bundle;

public class CHESSProjectSupport {
    private static String CHESS_CONSOLE_NAME = "CHESS notification console";
    private static final boolean isConsoleEnabled = true;
    public static final MessageConsoleStream CHESS_CONSOLE = CHESSProjectSupport.findCHESSconsole();
    public static final PrintStream CHESS_CONSOLE_STREAM = new PrintStream((OutputStream)CHESS_CONSOLE);

    public static void printlnToCHESSConsole(String s) {
        CHESS_CONSOLE.println(s);
    }

    public static IProject createProject(String projectName, URI location) {
        IProject project = CHESSProjectSupport.createBaseProject(projectName, location);
        try {
            CHESSProjectSupport.addNature(project);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return project;
    }

    private static IProject createBaseProject(String projectName, URI location) {
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!newProject.exists()) {
            URI projectLocation = location;
            IProjectDescription desc = newProject.getWorkspace().newProjectDescription(newProject.getName());
            if (location != null && ResourcesPlugin.getWorkspace().getRoot().getLocationURI().equals(location)) {
                projectLocation = null;
            }
            desc.setLocationURI(projectLocation);
            try {
                newProject.create(desc, null);
                if (!newProject.isOpen()) {
                    newProject.open(null);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return newProject;
    }

    public static void createFolder(IFolder folder) throws CoreException {
        IContainer parent = folder.getParent();
        if (parent instanceof IFolder) {
            CHESSProjectSupport.createFolder((IFolder)parent);
        }
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
    }

    private static void addToProjectStructure(IProject newProject, String[] paths) throws CoreException {
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            IFolder etcFolder = newProject.getFolder(path);
            CHESSProjectSupport.createFolder(etcFolder);
            ++n2;
        }
    }

    private static void addNature(IProject project) throws CoreException {
        if (!project.hasNature(CHESSNature.NATURE_ID)) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = CHESSNature.NATURE_ID;
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        }
    }

    private static MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    public static MessageConsoleStream findCHESSconsole() {
        MessageConsole myConsole = CHESSProjectSupport.findConsole(CHESS_CONSOLE_NAME);
        return myConsole.newMessageStream();
    }

    public static IFile resourceToFile(Resource inResource) {
        URI inputJURI = null;
        if (inResource.getURI().isPlatformResource()) {
            inputJURI = URI.create(inResource.getURI().toPlatformString(false).toString());
            IPath path = FileUtil.toPath((URI)inputJURI);
            IFile inputFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            return inputFile;
        }
        return null;
    }

    public static String getPluginInstallLocation(String pluginId) throws Exception {
        Bundle bundle = Platform.getBundle((String)pluginId);
        URL locationUrl = FileLocator.find((Bundle)bundle, (IPath)new Path("/"), null);
        URL fileUrl = FileLocator.toFileURL((URL)locationUrl);
        return fileUrl.getFile();
    }

    public static String getNameWithoutExtension(IFile inputFile) {
        String inputName = inputFile.getName();
        int extensionIndex = inputName.lastIndexOf(46);
        if (extensionIndex != -1) {
            inputName = inputName.substring(0, extensionIndex);
        }
        return inputName;
    }

    public static IFile copyFile(IFile inputFile, String folder, String outputName) throws Exception {
        IFile inputCopy = inputFile.getProject().getFile(String.valueOf(folder) + File.separator + outputName);
        try {
            inputCopy.delete(true, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new Exception("Unable to make a copy of the model");
        }
        try {
            inputFile.copy(inputCopy.getFullPath(), true, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new Exception("Unable to make a copy of the model");
        }
        return inputCopy;
    }

    public static void fileCopy(InputStream in, FileOutputStream out) throws IOException {
        int length;
        byte[] buf = new byte[8192];
        while ((length = in.read(buf)) >= 0) {
            out.write(buf, 0, length);
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        try {
            out.close();
        }
        catch (IOException iOException) {}
    }

    public static void fileReplace(IFile in, IFile out) throws CoreException, IOException {
        InputStream ins = in.getContents(true);
        out.setContents(ins, true, true, null);
        ins.close();
    }

    private static void getBundleContents(Plugin activator, String path, List<String> collectedPaths) {
        Enumeration enums = activator.getBundle().getEntryPaths(path);
        while (enums.hasMoreElements()) {
            Object object = enums.nextElement();
            Enumeration tmpEnum = activator.getBundle().getEntryPaths(object.toString());
            if (tmpEnum != null) {
                CHESSProjectSupport.getBundleContents(activator, object.toString(), collectedPaths);
                continue;
            }
            collectedPaths.add(object.toString());
        }
    }

    public static void writeLog(String s) throws FileNotFoundException {
        FileOutputStream out = new FileOutputStream(String.valueOf(CHESSProjectSupport.getEclipseInstallLocation()) + "CHESSLOG");
        PrintStream p = new PrintStream(out);
        p.println(s);
        p.close();
    }

    public static String getEclipseInstallLocation() {
        if (System.getProperty("os.name").equals("Linux")) {
            return System.getProperties().get("osgi.install.area").toString().substring(5);
        }
        return System.getProperties().get("osgi.install.area").toString().substring(6);
    }

    public static void installMAST() {
        String eclipseLocation = CHESSProjectSupport.getEclipseInstallLocation();
        if (new Path(String.valueOf(eclipseLocation) + File.separator + "mast").toFile().exists()) {
            CHESS_CONSOLE.println("MAST is already installed");
            return;
        }
        FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("/mast"), null);
        Activator.getDefault().getBundle().getEntryPaths("/mast");
        ArrayList<String> collectedPaths = new ArrayList<String>();
        CHESSProjectSupport.getBundleContents((Plugin)Activator.getDefault(), "/mast", collectedPaths);
        for (String p : collectedPaths) {
            Path pa = new Path(p);
            URL u = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)pa, null);
            try {
                InputStream in = u.openStream();
                File f = new File(String.valueOf(eclipseLocation) + p);
                if (f.setExecutable(true)) {
                    CHESS_CONSOLE.println("Exec permission set for " + f.getName());
                }
                f.getParentFile().mkdirs();
                FileOutputStream o = new FileOutputStream(f);
                CHESSProjectSupport.fileCopy(in, o);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void bundleToProjectCopy(String pluginID, Plugin plugin, String pluginPath, IProject currentProject, String projectPath, boolean includeBundleFolder) {
        ArrayList<String> collectedPaths = new ArrayList<String>();
        CHESSProjectSupport.getBundleContents(plugin, pluginPath, collectedPaths);
        IPath workingDir = currentProject.getFolder(projectPath).getLocation();
        for (String collectedPath : collectedPaths) {
            Path path = new Path(collectedPath);
            URL u = FileLocator.find((Bundle)plugin.getBundle(), (IPath)path, null);
            if (!includeBundleFolder) {
                collectedPath = collectedPath.substring(pluginPath.length() + 1);
            }
            try {
                InputStream in = u.openStream();
                File f = new File(workingDir + "/" + collectedPath);
                f.getParentFile().mkdirs();
                FileOutputStream o = new FileOutputStream(f);
                CHESSProjectSupport.fileCopy(in, o);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static IFile getIFileFromAbsolutePath(String path) {
        IPath location = Path.fromOSString((String)path);
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(location);
    }

    public static void deleteFolder(IFolder folder) throws CoreException {
        if (folder.exists()) {
            folder.delete(true, null);
        }
    }
}

