/*
 * Decompiled with CFR 0.152.
 */
package it.unipd.chess.views;

import it.unipd.chess.profiles.CHESSProfileManager;
import it.unipd.chess.views.ViewDiagramAssociations;
import it.unipd.chess.views.ViewPermissions;
import it.unipd.chess.views.ViewUtils;
import it.unipd.chess.views.permissions.EntryId;
import it.unipd.chess.views.permissions.PermissionList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Stack;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.impl.EObjectTreeElementImpl;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.uml2.uml.Package;

public class DiagramStatus {
    private Package actualView;
    private DesignView currentView = new DesignView();
    private HashMap<String, Boolean> concurrentToggles = new HashMap(CHESSProfileManager.CONCURRENT_VIEWS.size());
    private boolean isUser = true;
    private boolean superuser = false;
    private Stack<String> lastToggledView = new Stack();

    public DiagramStatus() {
        this.disableAllToggles();
    }

    public DiagramStatus(IPage initialDiagram) {
        this.disableAllToggles();
        this.setActualView(initialDiagram);
    }

    private void disableAllToggles() {
        for (String view : CHESSProfileManager.CONCURRENT_VIEWS) {
            this.concurrentToggles.put(view, false);
        }
    }

    @Deprecated
    public Package getActualView() {
        return this.actualView;
    }

    public synchronized DesignView getCurrentView() {
        if (this.actualView == null) {
            return null;
        }
        return this.currentView;
    }

    private boolean requestConcurrentView(String view, boolean yes) {
        this.concurrentToggles.put(view, yes);
        if (yes) {
            this.lastToggledView.push(view);
        } else if (this.lastToggledView.peek().equals(view)) {
            this.lastToggledView.pop();
        }
        this.setCurrentView();
        return this.concurrentToggles.get(view);
    }

    public String getActiveView() {
        return this.lastToggledView.peek();
    }

    public boolean requestView(String view, boolean b) {
        if (CHESSProfileManager.CONCURRENT_VIEWS.contains(view)) {
            return this.requestConcurrentView(view, b);
        }
        return false;
    }

    public synchronized void setActualView(IPage currentDiagram) {
        if (currentDiagram != null && ((PageRef)currentDiagram.getRawModel()).getEmfPageIdentifier() instanceof Diagram) {
            Diagram dg = (Diagram)((PageRef)currentDiagram.getRawModel()).getEmfPageIdentifier();
            Package newActualView = currentDiagram == null ? null : ViewUtils.getView(dg.getElement());
            this.currentView.currentDiagram = dg.getType();
            if (this.actualView != null && !ViewUtils.getViewName(this.actualView).equals(ViewUtils.getViewName(newActualView))) {
                this.disableAllToggles();
            }
            this.actualView = newActualView;
            this.setCurrentView();
        }
    }

    public synchronized void setActualView(TreeSelection currentTreeViewSelection) {
        TreeSelection tSelection = currentTreeViewSelection;
        EObjectTreeElementImpl elem = (EObjectTreeElementImpl)tSelection.getFirstElement();
        Package newActualView = currentTreeViewSelection == null ? null : ViewUtils.getView(elem.getEObject());
        this.currentView.currentDiagram = ViewDiagramAssociations.ANYDIAGRAM;
        if (this.actualView != null && !ViewUtils.getViewName(this.actualView).equals(ViewUtils.getViewName(newActualView))) {
            this.disableAllToggles();
        }
        this.actualView = newActualView;
        this.setCurrentView();
    }

    private synchronized void setCurrentView() {
        if (this.actualView == null) {
            this.currentView.enableView(null);
            this.lastToggledView.removeAllElements();
            this.disableAllToggles();
        } else if (ViewUtils.hasConcurrentViews(ViewUtils.getViewName(this.actualView))) {
            boolean toggled = false;
            for (String concurrentView : CHESSProfileManager.CONCURRENT_VIEWS_ASSOCIATION.get(ViewUtils.getViewName(this.actualView))) {
                if (this.concurrentToggles.get(concurrentView).booleanValue()) {
                    this.currentView.enableView(concurrentView);
                    toggled = true;
                    continue;
                }
                this.currentView.disableView(concurrentView);
            }
            if (!toggled) {
                this.lastToggledView.removeAllElements();
                this.lastToggledView.push(ViewUtils.getViewName(this.actualView));
                this.currentView.enableView(ViewUtils.getViewName(this.actualView));
            }
        } else {
            this.lastToggledView.removeAllElements();
            this.lastToggledView.push(ViewUtils.getViewName(this.actualView));
            this.currentView.enableView(ViewUtils.getViewName(this.actualView));
            this.disableAllToggles();
        }
    }

    public synchronized void setUserAction(boolean b) {
        this.isUser = b;
    }

    public boolean isUserAction() {
        return this.isUser;
    }

    public boolean isSuperuser() {
        return this.superuser;
    }

    public void setSuperuser(boolean b) {
        this.superuser = b;
    }

    public static class DesignView {
        Hashtable<String, Boolean> views = new Hashtable(CHESSProfileManager.CHESS_VIEWS_LIST.size());
        short enabledNum = 0;
        short concurNum = 0;
        String currentDiagram = null;

        private DesignView() {
            try {
                Class.forName(ViewPermissions.class.getName());
            }
            catch (Exception exception) {}
            this.clearAll();
        }

        private void clearAll() {
            for (String v : CHESSProfileManager.CHESS_VIEWS_LIST) {
                this.views.put(v, false);
            }
            this.enabledNum = 0;
            this.concurNum = 0;
        }

        private void clearNotConcurrent(String view) {
            for (String v : CHESSProfileManager.CHESS_VIEWS_LIST) {
                if (CHESSProfileManager.CONCURRENT_VIEWS.contains(v)) continue;
                this.views.put(v, false);
            }
            for (String k : CHESSProfileManager.CONCURRENT_VIEWS_ASSOCIATION.keySet()) {
                if (CHESSProfileManager.CONCURRENT_VIEWS_ASSOCIATION.get(k).contains(view)) continue;
                for (String l : CHESSProfileManager.CONCURRENT_VIEWS_ASSOCIATION.get(k)) {
                    this.views.put(l, false);
                }
            }
            this.enabledNum = 0;
        }

        void enableView(String view) {
            if (view == null) {
                this.clearAll();
            } else if (CHESSProfileManager.CONCURRENT_VIEWS.contains(view)) {
                this.clearNotConcurrent(view);
                this.views.put(view, true);
                this.concurNum = (short)(this.concurNum + 1);
            } else {
                this.clearAll();
                this.views.put(view, true);
                this.enabledNum = (short)(this.enabledNum + 1);
                assert (this.enabledNum == 1);
            }
        }

        void disableView(String view) {
            this.views.put(view, false);
            this.concurNum = (short)(this.concurNum - 1);
        }

        public String getName() {
            ArrayList<String> names = new ArrayList<String>();
            for (String v : CHESSProfileManager.CHESS_VIEWS_LIST) {
                if (!this.views.get(v).booleanValue()) continue;
                names.add(v);
            }
            if (names.size() == 0) {
                return "NullView";
            }
            if (names.size() == 1) {
                return (String)names.get(0);
            }
            Collections.sort(names);
            StringBuffer name = new StringBuffer();
            int count = 0;
            for (String v : names) {
                if (++count > 1) {
                    name.append('-');
                }
                name.append(v);
            }
            return name.toString();
        }

        public boolean isEnabled(String view) {
            return this.views.get(view);
        }

        public String getCurrentDiagramName() {
            return this.currentDiagram;
        }

        public PermissionList getViewPermissions(String view, String diagram) {
            if (diagram.equals(ViewDiagramAssociations.ANYDIAGRAM)) {
                return ViewPermissions.permissions.get(view).get(diagram);
            }
            PermissionList list = new PermissionList();
            PermissionList d = ViewPermissions.permissions.get(view).get(ViewDiagramAssociations.ANYDIAGRAM);
            if (d != null) {
                list.addAll(d);
            }
            String actualDiagram = ViewDiagramAssociations.papyrusNames2Standard.get(diagram);
            HashMap<String, PermissionList> viewPermissions = ViewPermissions.permissions.get(view);
            d = viewPermissions.get(actualDiagram);
            if (d != null) {
                list.addAll(d);
            }
            return list;
        }

        private PermissionList getEnabledPermissions() {
            if (this.concurNum > 1) {
                PermissionList union = new PermissionList();
                for (String v : CHESSProfileManager.CONCURRENT_VIEWS) {
                    if (!this.views.get(v).booleanValue()) continue;
                    union.addAll(this.getViewPermissions(v, this.currentDiagram));
                }
                return union;
            }
            for (String v : CHESSProfileManager.CHESS_VIEWS_LIST) {
                if (!this.views.get(v).booleanValue()) continue;
                return this.getViewPermissions(v, this.currentDiagram);
            }
            return null;
        }

        public boolean checkPermission(EntryId entryId, byte permission) {
            if (entryId.isANY()) {
                return true;
            }
            PermissionList l = this.getEnabledPermissions();
            return l == null || l.checkPermission(entryId, permission);
        }

        public boolean isDiagramAllowed(Diagram d) {
            if (this.concurNum > 1) {
                for (String v : CHESSProfileManager.CONCURRENT_VIEWS) {
                    HashSet<String> h;
                    if (!this.views.get(v).booleanValue() || (h = ViewDiagramAssociations.viewDiagramsAssociation.get(v)) == null || !h.contains(d.getType())) continue;
                    return true;
                }
                return false;
            }
            for (String v : CHESSProfileManager.CHESS_VIEWS_LIST) {
                HashSet<String> h;
                if (!this.views.get(v).booleanValue() || (h = ViewDiagramAssociations.viewDiagramsAssociation.get(v)) == null) continue;
                return h.contains(d.getType());
            }
            return false;
        }
    }
}

