/*
 * Decompiled with CFR 0.152.
 */
package it.unipd.chess.views;

import it.unipd.chess.profiles.CHESSProfileManager;
import it.unipd.chess.util.CHESSProjectSupport;
import it.unipd.chess.views.DiagramStatus;
import it.unipd.chess.views.permissions.EntryId;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ViewUtils {
    public static Package getView(EObject ob) {
        if (ob == null) {
            return null;
        }
        Package pkg = null;
        if (ob instanceof Package && ViewUtils.hasViewStereotypeApplied(pkg = (Package)ob)) {
            return pkg;
        }
        return ViewUtils.getView(ob.eContainer());
    }

    public static String getViewName(Package pkg) {
        Stereotype s = ViewUtils.getViewStereotypeApplied(pkg);
        return s != null ? s.getName() : null;
    }

    public static Stereotype getViewStereotypeApplied(Package pkg) {
        if (pkg == null) {
            return null;
        }
        EList list = pkg.getAppliedStereotypes();
        for (Stereotype stereotype : list) {
            if (!ViewUtils.isViewStereotype(stereotype)) continue;
            return stereotype;
        }
        return null;
    }

    public static Package getViewWithThrows(EObject ob) throws Exception {
        if (ob == null) {
            throw new Exception("containing object is null");
        }
        Package pkg = null;
        if (ob instanceof Package && ViewUtils.hasViewStereotypeApplied(pkg = (Package)ob)) {
            return pkg;
        }
        return ViewUtils.getViewWithThrows(ob.eContainer());
    }

    public static boolean hasViewStereotypeApplied(Package pkg) {
        EList list = pkg.getAppliedStereotypes();
        for (Stereotype stereotype : list) {
            if (!ViewUtils.isViewStereotype(stereotype)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDeploymentView(DiagramStatus.DesignView view) {
        return view == null ? false : view.isEnabled("DeploymentView");
    }

    public static boolean isDeploymentView(Package pkg) {
        EList list = pkg.getAppliedStereotypes();
        for (Stereotype stereotype : list) {
            if (!stereotype.getName().equals("DeploymentView")) continue;
            return true;
        }
        return false;
    }

    public static boolean isRTAnalysisView(Package pkg) {
        EList list = pkg.getAppliedStereotypes();
        for (Stereotype stereotype : list) {
            if (!stereotype.getName().equals("RTAnalysisView")) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isElementWritable(Element element, DiagramStatus.DesignView currentView) {
        Package view = null;
        view = ViewUtils.getView(element.eContainer());
        if (view != null && currentView != null) {
            String viewName = ViewUtils.getViewName(view);
            return currentView.isEnabled(viewName);
        }
        return true;
    }

    public static boolean isElementWritable_(EObject element, Object feature, DiagramStatus.DesignView currentView) {
        if (currentView != null) {
            ArrayList<EntryId> ids = EntryId.computeEntryIds_(element, feature);
            return ViewUtils.checkIdPermission(ids, currentView, (byte)0);
        }
        return false;
    }

    public static boolean isElementInstantiable(EObject element, Object feature, DiagramStatus.DesignView currentView) {
        if (currentView != null) {
            ArrayList<EntryId> ids = EntryId.computeEntryIds_(element, feature);
            return ViewUtils.checkIdPermission(ids, currentView, (byte)1);
        }
        return false;
    }

    public static boolean isStereotypeWritable(EObject element, Object feature, Object stereotype, DiagramStatus.DesignView currentView) {
        if (currentView != null) {
            ArrayList<EntryId> ids = EntryId.computeStereotypeEntryIds(element, feature, stereotype);
            return ViewUtils.checkIdPermission(ids, currentView, (byte)0);
        }
        return false;
    }

    public static boolean isStereotypeInstantiable(EObject element, Object feature, Object stereotype, DiagramStatus.DesignView currentView) {
        if (currentView != null) {
            ArrayList<EntryId> ids = EntryId.computeStereotypeEntryIds(element, feature, stereotype);
            return ViewUtils.checkIdPermission(ids, currentView, (byte)1);
        }
        return false;
    }

    private static boolean checkIdPermission(ArrayList<EntryId> ids, DiagramStatus.DesignView currentView, byte permission) {
        if (ids.isEmpty()) {
            return true;
        }
        boolean res4Stereo = false;
        for (EntryId entryId : ids) {
            CHESSProjectSupport.printlnToCHESSConsole(entryId.toString());
            boolean perm = currentView.checkPermission(entryId, permission);
            if (entryId.getStereotype().equals(EntryId.NONE) && !perm) {
                return false;
            }
            boolean bl = res4Stereo = res4Stereo || perm;
        }
        return res4Stereo;
    }

    public static boolean isExtraFunctionalView(DiagramStatus.DesignView view) {
        return view == null ? false : view.isEnabled("ExtraFunctionalView");
    }

    public static boolean isExtraFunctionalView(Package pkg) {
        EList list = pkg.getAppliedStereotypes();
        for (Stereotype stereotype : list) {
            if (!stereotype.getName().equals("ExtraFunctionalView")) continue;
            return true;
        }
        return false;
    }

    public static boolean isComponentView(DiagramStatus.DesignView view) {
        return view == null ? false : view.isEnabled("ComponentView");
    }

    public static boolean isComponentView(Package pkg) {
        if (pkg != null) {
            EList list = pkg.getAppliedStereotypes();
            for (Stereotype stereotype : list) {
                if (!stereotype.getName().equals("ComponentView")) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isRequirementView(Package pkg) {
        if (pkg != null) {
            EList list = pkg.getAppliedStereotypes();
            for (Stereotype stereotype : list) {
                if (!stereotype.getName().equals("RequirementView")) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSystemView(Package pkg) {
        if (pkg != null) {
            EList list = pkg.getAppliedStereotypes();
            for (Stereotype stereotype : list) {
                if (!stereotype.getName().equals("SystemView")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isView(EObject notifier) {
        if (notifier instanceof Package && ViewUtils.hasViewStereotypeApplied((Package)notifier)) {
            return true;
        }
        return CHESSProfileManager.CHESS_VIEWS_LIST.contains(notifier.eClass().getName());
    }

    public static boolean isViewModifiedOrRemoved(ENotificationImpl notification) {
        Object o;
        Object el = notification.getNotifier();
        if (notification.getEventType() == 20 || notification.getEventType() == 21 || notification.getEventType() == 22) {
            Object st = notification.getNewValue();
            if (el instanceof EObject && st instanceof EObject) {
                String viewName = ((EObject)st).eClass().getName();
                return CHESSProfileManager.CHESS_VIEWS_LIST.contains(viewName);
            }
        }
        if (notification.getEventType() == 4 && (o = notification.getOldValue()) instanceof EObject) {
            return ViewUtils.isView((EObject)o);
        }
        if (el instanceof DynamicEObjectImpl) {
            DynamicEObjectImpl d = (DynamicEObjectImpl)el;
            Stereotype stereo = UMLUtil.getStereotype((EObject)d);
            return ViewUtils.isViewStereotype(stereo);
        }
        if (notification.getEventType() == 1 && el instanceof EObject) {
            return ViewUtils.isView((EObject)el);
        }
        return false;
    }

    public static boolean isViewStereotype(Stereotype stereotype) {
        return CHESSProfileManager.CHESS_VIEWS_LIST.contains(stereotype.getName());
    }

    public static boolean isConcurrentView(DiagramStatus.DesignView currentView) {
        if (currentView == null) {
            return false;
        }
        for (String view : CHESSProfileManager.CONCURRENT_VIEWS) {
            if (!currentView.isEnabled(view)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOnView(DiagramStatus.DesignView currentView, String view) {
        if (currentView == null) {
            return false;
        }
        for (String v : CHESSProfileManager.CONCURRENT_VIEWS_ASSOCIATION.get(view)) {
            if (!currentView.isEnabled(v)) continue;
            return true;
        }
        return false;
    }

    public static Package getCHESSRequirementPackage(Model theModel) {
        for (Element p : theModel.allOwnedElements()) {
            if (!(p instanceof Package) || !ViewUtils.isRequirementView((Package)p)) continue;
            return (Package)p;
        }
        return theModel;
    }

    public static Package getCHESSSystemPackage(Model theModel) {
        for (Element p : theModel.allOwnedElements()) {
            if (!(p instanceof Package) || !ViewUtils.isSystemView((Package)p)) continue;
            return (Package)p;
        }
        return theModel;
    }

    public static Package getCHESSRtAnalysisPackage(Model theModel) {
        for (Element p : theModel.allOwnedElements()) {
            if (!(p instanceof Package) || !ViewUtils.isRTAnalysisView((Package)p)) continue;
            return (Package)p;
        }
        return theModel;
    }

    public static Package getCHESSComponentPackage(Model theModel) {
        for (Element p : theModel.allOwnedElements()) {
            if (!(p instanceof Package) || !ViewUtils.isComponentView((Package)p)) continue;
            return (Package)p;
        }
        return theModel;
    }

    public static Package getCHESSDeploymentPackage(Model theModel) {
        for (Element p : theModel.allOwnedElements()) {
            if (!(p instanceof Package) || !ViewUtils.isDeploymentView((Package)p)) continue;
            return (Package)p;
        }
        return theModel;
    }

    public static boolean hasConcurrentViews(DiagramStatus.DesignView currentView) {
        for (String v : CHESSProfileManager.CONCURRENT_VIEWS_ASSOCIATION.keySet()) {
            if (!currentView.isEnabled(v)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasConcurrentViews(String viewName) {
        return CHESSProfileManager.CONCURRENT_VIEWS_ASSOCIATION.keySet().contains(viewName);
    }

    public static String getBaseViewName(DiagramStatus.DesignView currentView) {
        return currentView.getName();
    }
}

